-- Add wallet_bal column to yn_site_mem table
-- This query will add the column only if it doesn't exist

-- Check if column exists and add if not (MySQL)
-- Method 1: Check and add (safe - won't error if column already exists)
ALTER TABLE `yn_site_mem` 
ADD COLUMN IF NOT EXISTS `wallet_bal` DECIMAL(10,2) DEFAULT 0.00 AFTER `mid`;

-- Method 2: If IF NOT EXISTS is not supported in your MySQL version, use this:
-- First check manually, then run:
ALTER TABLE `yn_site_mem` 
ADD COLUMN `wallet_bal` DECIMAL(10,2) DEFAULT 0.00 AFTER `mid`;

-- To check if column exists:
SHOW COLUMNS FROM `yn_site_mem` LIKE 'wallet_bal';

-- To update existing users' wallet balance to 0.00 (if NULL):
UPDATE `yn_site_mem` SET `wallet_bal` = 0.00 WHERE `wallet_bal` IS NULL;

