<?php
defined('BASEPATH') or exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$route['default_controller'] = 'main';
$route['404_override'] = '';
$route['translate_uri_dashes'] = true;

// Custom routes for teacher functionality
$route['get-subject-teachers'] = 'action/get_subject_teachers';
$route['admin'] = 'admin/login';


$route['otp-verify'] = 'main/otp_verify';
$route['login_otp_verify'] = 'main/login_otp_verify';
$route['test-otp'] = 'main/test_otp';
$route['page/(:any)'] = 'main/page/$1';
$route['blog/(:any)'] = 'main/theBlog/$1';
$route['product/(:num)/(:any)'] = 'main/product/$1/$2';
$route['course_detail/(:num)/(:any)'] = 'main/course_detail/$1/$2';
$route['contact/(:num)/(:any)'] = 'main/contact/$1/$2';
$route['qbank/(:num)/(:any)'] = 'main/qbank_detail/$1/$2';
$route['topic/(:any)/(:num)'] = 'main/topic_detail/$1/$2';
$route['topic-detail/(:any)/(:num)'] = 'main/topic_detail/$1/$2';
$route['debug-topic/(:any)/(:num)'] = 'main/debug_topic/$1/$2';
$route['sub/(:any)/(:num)'] = 'main/sub/$1/$2';
$route['sub-sub/(:any)/(:num)'] = 'main/sub_sub/$1/$2';
$route['sub-sub-sub/(:any)/(:num)'] = 'main/sub_sub_sub/$1/$2';
$route['teacher-selection'] = 'main/teacher_selection';
$route['instructor'] = 'main/instructor';
$route['instructor-details/(:num)'] = 'main/instructor_details/$1';
$route['ecom/checkout2'] = 'e_com/checkout2';
$route['save-meeting-details'] = 'main/save_meeting_details';
$route['teacher-videos'] = 'main/teacher_videos';
$route['upload-subject-video'] = 'action/upload_subject_video';
$route['get-teacher-subjects'] = 'action/get_teacher_subjects';
$route['delete-subject-video'] = 'action/delete_subject_video';
$route['clear-teacher-video-notification'] = 'action/clear_teacher_video_notification';
$route['get-topic-teachers'] = 'action/get_topic_teachers';
$route['get-subject-teachers'] = 'action/get_subject_teachers';
$route['get_subject_teachers'] = 'action/get_subject_teachers';

$route['checkout'] = 'main/checkout';
$route['service/(:any)'] = 'main/service/$1';

$route['signup/(:any)'] = 'main/signup/$1';
$route['logout'] = 'action/logout';
$route['search/(:any)/(:any)'] = 'main/search/$1/$2';
$route['search/(:any)'] = 'main/search/$1';
$route['shop/(:any)'] = 'main/shop/$1';
$route['download/(:any)'] = 'main/download/$1';
$route['category/(:any)'] = 'main/product_category/$1';
$route['search-suggestions'] = 'main/search_suggestions';
$route['pay-now'] = 'main/pay_now';

// Banner Mind - Collections routes
$route['collections'] = 'main/collections';
$route['collection-detail/(:num)'] = 'main/collection_detail/$1';
$route['generate-image/(:num)'] = 'main/generate_image/$1';
$route['check-gd'] = 'main/check_gd';

// Stories routes
$route['upload-story'] = 'action/upload_story';
$route['get-stories'] = 'action/get_user_stories';
$route['mark-story-viewed'] = 'action/mark_story_viewed';

// Main controller routes (page display) - must be before catch-all
$route['request/(:any)'] = 'main/request/$1';
$route['wallet'] = 'main/wallet';
$route['wallet/history'] = 'main/wallet/history';

// Exclude action and admin from catch-all - they use default CodeIgniter routing
// Catch-all route - must be at the end (only for Main controller)
// Note: action/* and admin/* routes use default routing automatically
$route['(:any)'] = "main/$1";
