<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Main extends CI_Controller
{
	function __construct()
	{
		parent::__construct();
	}

	// Check GD Library availability - Public diagnostic function (no login required)
	function check_gd()
	{
		// Start output buffering FIRST to prevent any header issues
		if (!ob_get_level()) {
			ob_start();
		}
		
		// Don't require login for this diagnostic page - skip session checks
		@session_start();
		
		// Try to get db_variables, but handle errors gracefully
		try {
			$data = db_variables();
			$data['seo_title'] = 'GD Library Check - ' . (isset($data['meta_title']) ? $data['meta_title'] : 'Diagnostic');
			$data['seo_description'] = isset($data['meta_desc']) ? $data['meta_desc'] : '';
			$data['seo_image'] = isset($data['meta_image']) ? $data['meta_image'] : '';
			$data['seo_keywords'] = isset($data['meta_key']) ? $data['meta_key'] : '';
			$data['meta_array'] = $data;
		} catch (Exception $e) {
			// If db_variables fails, use defaults
			$data = array();
			$data['seo_title'] = 'GD Library Check';
			$data['seo_description'] = '';
			$data['seo_image'] = '';
			$data['seo_keywords'] = '';
			$data['meta_array'] = $data;
		}

		// Check GD Library
		$data['gd_loaded'] = extension_loaded('gd');
		$data['gd_info'] = function_exists('gd_info') ? @gd_info() : array();
		
		// Check individual functions
		$functions = [
			'imagecreatetruecolor',
			'imagecreatefromjpeg',
			'imagecreatefrompng',
			'imagecreatefromgif',
			'imagecreatefromwebp',
			'imagecopyresampled',
			'imagecopy',
			'imagepng',
			'imagejpeg',
			'imagestring',
			'imagecolorallocate',
			'imagecolorallocatealpha',
			'imagefilledrectangle',
			'imagesx',
			'imagesy'
		];
		
		$data['gd_functions'] = array();
		foreach ($functions as $func) {
			$data['gd_functions'][$func] = function_exists($func);
		}
		
		// Test image creation
		$data['test_image_creation'] = false;
		if (function_exists('imagecreatetruecolor') && function_exists('imagepng')) {
			$test_img = @imagecreatetruecolor(100, 100);
			if ($test_img) {
				$data['test_image_creation'] = true;
				@imagedestroy($test_img);
			}
		}
		
		$data['php_version'] = phpversion();
		$data['php_ini_file'] = php_ini_loaded_file();
		$data['php_ini_scanned'] = php_ini_scanned_files();

		// Clean any output before loading views
		ob_clean();
		
		// Load views
		$this->load->view('inc/_header', $data);
		$this->load->view('check-gd-view', $data);
		$this->load->view('inc/_footer', $data);
		
		// Flush output buffer safely
		if (ob_get_level()) {
			ob_end_flush();
		}
	}

	public function index()
	{
		@session_start();
		// Check if user is logged in, if not redirect to login
		if (!isset($_SESSION['yid']) || $_SESSION['yid'] == '') {
			$this->login();
			return;
		}
		$data = db_variables();

		if ($data['home_page'] != '') {
			redirect(base_url($data['home_page']));
		}

		$data['seo_title'] = 'Home - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		$yid = $_SESSION['yid'];
		
		// Cleanup expired stories automatically (3 days old)
		$tables = $this->db->list_tables();
		if (in_array('yn_ai_stories', $tables)) {
			$cleanup_query = "UPDATE yn_ai_stories 
				SET story_status = '0' 
				WHERE story_status = '1' 
				AND story_expires_at IS NOT NULL 
				AND story_expires_at < NOW()";
			$this->db->query($cleanup_query);
		}
		
		// Get user's company ID for filtering
		$user_comp_id_stories = '';
		if (isset($_SESSION['yid']) && !empty($_SESSION['yid'])) {
			$user_query_stories = $this->db->query("SELECT comp_id FROM yn_site_mem WHERE mid = '" . $_SESSION['yid'] . "'");
			if ($user_query_stories && $user_query_stories->num_rows() > 0) {
				$user_data_stories = $user_query_stories->row_array();
				$user_comp_id_stories = isset($user_data_stories['comp_id']) ? $user_data_stories['comp_id'] : '';
			}
		}
		
		// Get Stories - Active stories from users in the same company (not expired, within 3 days)
		$stories_query = "SELECT s.*, 
			u.name as user_name, 
			u.firstname, 
			u.lastname, 
			u.photo as user_photo,
			(SELECT COUNT(*) FROM yn_ai_story_views sv WHERE sv.view_story_id = s.story_id) as view_count,
			(SELECT COUNT(*) FROM yn_ai_story_views sv WHERE sv.view_story_id = s.story_id AND sv.view_user_id = '$yid') as is_viewed
			FROM yn_ai_stories s
			LEFT JOIN yn_site_mem u ON s.story_user_id = u.mid
			WHERE s.story_status = '1' 
			AND (s.story_expires_at IS NULL OR s.story_expires_at > NOW())";
		
		// Filter by user's company if comp_id exists
		if (!empty($user_comp_id_stories)) {
			$stories_query .= " AND u.comp_id = '$user_comp_id_stories'";
		}
		
		$stories_query .= " ORDER BY s.story_created DESC";
		
		$get_stories = $this->db->query($stories_query);
		$all_stories = $get_stories->result_array();
		
		// Group stories by user
		$stories_by_user = array();
		foreach ($all_stories as $story) {
			$user_id = $story['story_user_id'];
			if (!isset($stories_by_user[$user_id])) {
				$stories_by_user[$user_id] = array(
					'user_id' => $user_id,
					'user_name' => !empty($story['user_name']) ? $story['user_name'] : ($story['firstname'] . ' ' . $story['lastname']),
					'user_photo' => $story['user_photo'],
					'stories' => array(),
					'has_unviewed' => false
				);
			}
			$stories_by_user[$user_id]['stories'][] = $story;
			if ($story['is_viewed'] == 0) {
				$stories_by_user[$user_id]['has_unviewed'] = true;
			}
		}
		$data['stories_by_user'] = array_values($stories_by_user);
		
		// Get user's own stories
		$my_stories_query = "SELECT * FROM yn_ai_stories 
			WHERE story_user_id = '$yid' 
			AND story_status = '1' 
			AND (story_expires_at IS NULL OR story_expires_at > NOW())
			ORDER BY story_created DESC";
		$get_my_stories = $this->db->query($my_stories_query);
		$data['my_stories'] = $get_my_stories->result_array();

		// Get user's used templates for Dashboard (instead of collections)
		$tables = $this->db->list_tables();
		$data['used_templates'] = array();
		$data['collections'] = array();
		
		// Get user's company ID
		$user_comp_id = '';
		if (isset($_SESSION['yid']) && !empty($_SESSION['yid'])) {
			$user_query = $this->db->query("SELECT comp_id FROM yn_site_mem WHERE mid = '" . $_SESSION['yid'] . "'");
			if ($user_query && $user_query->num_rows() > 0) {
				$user_data = $user_query->row_array();
				$user_comp_id = isset($user_data['comp_id']) ? $user_data['comp_id'] : '';
			}
		}
		
		// Get all active collections with template count for home page (filtered by user's company)
		$collections_query = "SELECT c.*, comp.comp_name, comp.comp_logo,
			(SELECT COUNT(*) FROM yn_ai_templates t WHERE t.temp_coll_id = c.coll_id AND t.temp_status = '1') as template_count
			FROM yn_ai_collections c 
			LEFT JOIN yn_ai_companies comp ON c.coll_comp_id = comp.comp_id 
			WHERE c.coll_status='1'";
		
		// Filter by user's company if comp_id exists
		if (!empty($user_comp_id)) {
			$collections_query .= " AND c.coll_comp_id = '$user_comp_id'";
		}
		
		$collections_query .= " ORDER BY c.coll_id DESC";
		
		$get_collections = $this->db->query($collections_query);
		if ($get_collections && $get_collections->num_rows() > 0) {
			$collections_array = $get_collections->result_array();
			
			// Get templates for ALL collections - filtered by user's company
			foreach ($collections_array as $index => $collection) {
				$coll_id = $collection['coll_id'];
				$templates_query = "SELECT t.*, c.coll_id, c.coll_name 
					FROM yn_ai_templates t 
					LEFT JOIN yn_ai_collections c ON t.temp_coll_id = c.coll_id 
					WHERE t.temp_coll_id = '$coll_id' AND t.temp_status = '1'";
				
				// Filter by user's company if comp_id exists
				if (!empty($user_comp_id)) {
					$templates_query .= " AND c.coll_comp_id = '$user_comp_id'";
				}
				
				$templates_query .= " ORDER BY t.temp_id DESC";
				$get_templates = $this->db->query($templates_query);
				if ($get_templates && $get_templates->num_rows() > 0) {
					$collections_array[$index]['templates'] = $get_templates->result_array();
				} else {
					$collections_array[$index]['templates'] = array();
				}
			}
			
			$data['collections'] = $collections_array;
		}
		
		if (in_array('yn_ai_generations', $tables)) {
			// Get templates with their LATEST GENERATED IMAGE (what users actually created)
			// This shows users what the final output looks like when they use a template
			// Filtered by user's company
			$templates_query = "SELECT DISTINCT g.gen_temp_id as temp_id, 
				COALESCE(t.temp_name, CONCAT('Template #', g.gen_temp_id)) as temp_name, 
				t.temp_image, t.temp_coll_id,
				c.coll_id, c.coll_name, c.coll_cover_image,
				comp.comp_id, comp.comp_name, comp.comp_logo,
				(SELECT g_latest.gen_image FROM yn_ai_generations g_latest 
				 WHERE g_latest.gen_temp_id = g.gen_temp_id 
				 AND g_latest.gen_image IS NOT NULL AND g_latest.gen_image != ''
				 ORDER BY g_latest.gen_created DESC LIMIT 1) as latest_gen_image,
				(SELECT g_latest.gen_user_id FROM yn_ai_generations g_latest 
				 WHERE g_latest.gen_temp_id = g.gen_temp_id 
				 AND g_latest.gen_image IS NOT NULL AND g_latest.gen_image != ''
				 ORDER BY g_latest.gen_created DESC LIMIT 1) as latest_gen_user_id,
				(SELECT COUNT(*) FROM yn_ai_generations g2 WHERE g2.gen_temp_id = g.gen_temp_id AND g2.gen_image IS NOT NULL AND g2.gen_image != '') as total_usage_count,
				(SELECT COUNT(*) FROM yn_ai_generations g3 WHERE g3.gen_temp_id = g.gen_temp_id AND g3.gen_user_id = '$yid' AND g3.gen_image IS NOT NULL AND g3.gen_image != '') as my_usage_count
				FROM yn_ai_generations g
				LEFT JOIN yn_ai_templates t ON g.gen_temp_id = t.temp_id
				LEFT JOIN yn_ai_collections c ON t.temp_coll_id = c.coll_id
				LEFT JOIN yn_ai_companies comp ON c.coll_comp_id = comp.comp_id
				WHERE (g.gen_image IS NOT NULL AND g.gen_image != '')";
			
			// Filter by user's company if comp_id exists
			if (!empty($user_comp_id)) {
				$templates_query .= " AND c.coll_comp_id = '$user_comp_id'";
			}
			
			$templates_query .= " GROUP BY g.gen_temp_id
				ORDER BY MAX(g.gen_created) DESC
				LIMIT 6";
			
			$get_templates = $this->db->query($templates_query);
			if ($get_templates && $get_templates->num_rows() > 0) {
				$data['used_templates'] = $get_templates->result_array();
			}
		}

		// Get logged-in user's generated images (filtered by user's company)
		$data['generated_images'] = array();
		if (in_array('yn_ai_generations', $tables)) {
			$generated_query = "SELECT g.*, 
				t.temp_id, t.temp_name, t.temp_coll_id, t.temp_image,
				u.name as user_name, u.firstname, u.lastname, u.photo as user_photo,
				c.coll_id, c.coll_name, c.coll_cover_image,
				comp.comp_name
				FROM yn_ai_generations g
				LEFT JOIN yn_ai_templates t ON g.gen_temp_id = t.temp_id
				LEFT JOIN yn_site_mem u ON g.gen_user_id = u.mid
				LEFT JOIN yn_ai_collections c ON t.temp_coll_id = c.coll_id
				LEFT JOIN yn_ai_companies comp ON c.coll_comp_id = comp.comp_id
				WHERE g.gen_user_id = '$yid' 
				AND t.temp_status='1' 
				AND (c.coll_status='1' OR c.coll_status IS NULL)";
			
			// Filter by user's company if comp_id exists
			if (!empty($user_comp_id)) {
				$generated_query .= " AND c.coll_comp_id = '$user_comp_id'";
			}
			
			$generated_query .= " AND g.gen_image IS NOT NULL
				AND g.gen_image != ''
				ORDER BY g.gen_created DESC
				LIMIT 12";
			
			$get_generated = $this->db->query($generated_query);
			if ($get_generated) {
				$data['generated_images'] = $get_generated->result_array();
			}
		}

		// Get user profile data for stories
		$profile_data = $this->ynaps_model->getprofile_data('*', $yid);
		$data['profile_data'] = $profile_data;

		// Get all categories for the home page - removed type restriction and increased limit
		$thecats = $this->db->query("select * from yn_site_catagory");
		$all_cats = $thecats->result_array();
		
		$data['the_cats'] = $all_cats;

		$geththeblogs = $this->db->query("SELECT blog_id, title, blog_time, blog_img, slug, category, blog_username, scomment FROM yn_site_blogs WHERE status = 1 ORDER BY blog_id DESC LIMIT 4");
		$all_blogs = $geththeblogs->result_array();
		$data['show_blogs'] = $all_blogs;

		// Get dynamic students for banner section
		$dynamic_students_query = "SELECT firstname, lastname, photo FROM yn_site_mem WHERE user_type = 'student' AND firstname IS NOT NULL AND firstname != '' ORDER BY mid DESC LIMIT 2";
		$dynamic_students_result = $this->db->query($dynamic_students_query);
		$data['dynamic_students'] = $dynamic_students_result->result_array();

		// Get 2 images after main slider - first image with img_sort=1 and img_place=home, second image with img_sort=2 and img_place=home
		$get_sliders = $this->db->query("select * from yn_site_img where img_place ='home' and img_status='1' and img_sort IN (1,2) order by img_sort asc limit 2");
		$all_sliders = $get_sliders->result_array();
		$data['show_sliders'] = $all_sliders;

		// Get 2 images after main slider - first image with img_sort=1 and img_place=home, second image with img_sort=2 and img_place=home
		$get_sliders_bottom = $this->db->query("select * from yn_site_img where img_place ='home' and img_status='1' and img_sort IN (3,4) order by img_sort asc limit 2");
		$all_sliders_bottom = $get_sliders_bottom->result_array();
		$data['show_sliders_bottom'] = $all_sliders_bottom;

		//All products - Latest Tractor with pagination
		// Get total count for pagination
		$total_query = "SELECT COUNT(*) as total FROM yn_ecom_products WHERE p_vendor IS NOT NULL AND p_vendor != ''";
		$total_result = $this->db->query($total_query)->row_array();
		$total_num = $total_result['total'];

		// Pagination setup for Latest Tractor
		$rec_per_page = 6;
		$this->load->library('pagination');
		$config['base_url'] = base_url('');
		$config['total_rows'] = $total_num;
		$config['per_page'] = $rec_per_page;
		$config['num_links'] = 3;
		$config['use_page_numbers'] = TRUE;
		$config['full_tag_open'] = "";
		$config['full_tag_close'] = '';
		$config['reuse_query_string'] = true;
		$config['page_query_string'] = TRUE;
		$config['query_string_segment'] = 'page';
		$config['first_link'] = 'First';
		$config['last_link'] = 'Last';
		$config['next_link'] = 'Next';
		$config['prev_link'] = 'Previous';
		$this->pagination->initialize($config);

		@$page = $_GET['page'];
		if (isset($_GET['page'])) {
			$page = $page - 1;
		} else {
			$page = 0;
		}
		$limit1 = $page * $rec_per_page;

		// Get latest products with pagination
		$products_query = "SELECT * FROM yn_ecom_products WHERE p_vendor IS NOT NULL AND p_vendor != '' ORDER BY p_id DESC LIMIT $limit1, $rec_per_page";
		$getProducts = $this->db->query($products_query);
		$the_prods = $getProducts->result_array();
		$data['prod'] = $the_prods;
		
		// Pass pagination links to view
		$data['latest_pagination'] = $this->pagination->create_links();
		//prod1
		$getProducts = $this->db->query("SELECT * FROM `yn_ecom_products`  WHERE p_looking = '1' ORDER BY p_id DESC LIMIT 6");
		$the_prods = $getProducts->result_array();
		$data['prod1'] = $the_prods;
		//prod2
		$getProducts = $this->db->query("SELECT * FROM `yn_ecom_products`  WHERE p_looking = '2' ORDER BY p_id DESC LIMIT 6");
		$the_prods = $getProducts->result_array();
		$data['prod2'] = $the_prods;
		//prod3
		$getProducts = $this->db->query("SELECT * FROM `yn_ecom_products`  WHERE p_looking = '3' ORDER BY p_id DESC LIMIT 6");
		$the_prods = $getProducts->result_array();
		$data['prod3'] = $the_prods;
		//prod4
		$getProducts = $this->db->query("SELECT * FROM `yn_ecom_products`  WHERE p_looking = '4' ORDER BY p_id DESC LIMIT 6");
		$the_prods = $getProducts->result_array();
		$data['prod4'] = $the_prods;
		//prod5
		$getProducts = $this->db->query("SELECT * FROM `yn_ecom_products`  WHERE p_looking = '5' ORDER BY p_id DESC LIMIT 6");
		$the_prods = $getProducts->result_array();
		$data['prod5'] = $the_prods;
		//prod6
		$getProducts = $this->db->query("SELECT * FROM `yn_ecom_products`  WHERE p_looking = '6' ORDER BY p_id DESC LIMIT 6");
		$the_prods = $getProducts->result_array();
		$data['prod6'] = $the_prods;

		// Get products for "Explore Our World's Best Learning Programs" section
		// First get products with category names
		$courses_query = "SELECT p.*, c.name as category_name
						 FROM yn_ecom_products p 
						 LEFT JOIN yn_site_catagory c ON p.p_category = c.ctid 
						 WHERE p.p_status = '1' 
						 ORDER BY p.p_id DESC 
						 LIMIT 6";
		$getCourses = $this->db->query($courses_query);
		$courses = $getCourses->result_array();
		
		// Now get images for each product separately - matching the structure used in topic_detail.php
		foreach($courses as $key => $course) {
			$pid = $course['p_id'];
			$img_query = "SELECT img FROM yn_ecom_products_img WHERE pid = '$pid' ORDER BY id ASC";
			$img_result = $this->db->query($img_query);
			$img_data = $img_result->result_array();
			$courses[$key]['images'] = $img_data; // Store as array like in topic_detail.php
		}
		
		$data['courses'] = $courses;

		// Get teachers for "Our Top Class & Expert Instructors" section
		$teachers_query = "SELECT m.mid, m.firstname, m.lastname, m.username, m.photo, m.skill, m.about, 
						   c.name as category_name, sc.sc_name as subcategory_name, ssc.mr_sub2_name as sub_subcategory_name
						   FROM yn_site_mem m 
						   LEFT JOIN yn_site_catagory c ON m.category_id = c.ctid 
						   LEFT JOIN yn_site_sub_cat sc ON m.subcategory_id = sc.sc_id 
						   LEFT JOIN yn_site_sub2_cat ssc ON m.sub_subcategory_id = ssc.mr_sub2_id 
						   WHERE m.user_type = 'teacher' 
						   AND m.firstname IS NOT NULL 
						   AND m.firstname != '' 
						   ORDER BY m.mid DESC 
						   LIMIT 4";
		$getTeachers = $this->db->query($teachers_query);
		$teachers = $getTeachers->result_array();
		$data['teachers'] = $teachers;

		// Get dynamic statistics for the fact section
		// 1. Total students (users with type 'student')
		$students_query = "SELECT COUNT(*) as total FROM yn_site_mem WHERE user_type = 'student'";
		$students_result = $this->db->query($students_query);
		$data['total_students'] = $students_result->row()->total;

		// 2. Total topics (from products table)
		$topics_query = "SELECT COUNT(*) as total FROM yn_ecom_products WHERE p_status = '1'";
		$topics_result = $this->db->query($topics_query);
		$data['total_topics'] = $topics_result->row()->total;

		// 3. Total teachers (users with type 'teacher')
		$teachers_count_query = "SELECT COUNT(*) as total FROM yn_site_mem WHERE user_type = 'teacher'";
		$teachers_count_result = $this->db->query($teachers_count_query);
		$data['total_teachers'] = $teachers_count_result->row()->total;

		// 4. Total categories
		$categories_query = "SELECT COUNT(*) as total FROM yn_site_catagory WHERE display = '1'";
		$categories_result = $this->db->query($categories_query);
		$data['total_categories'] = $categories_result->row()->total;

		// Get specific topic (ID 84) for hero section
		$hero_topic_query = "SELECT p.*, 
							c.name as category_name,
							sc.sc_name as subcategory_name,
							ssc.mr_sub2_name as sub_subcategory_name,
							sssc.mr_sub3_name as sub_sub_subcategory_name,
							pi.img as product_image,
							(SELECT COUNT(*) FROM yn_ecom_orders_detail od 
							 JOIN yn_ecom_order o ON od.checkout_order_id = o.so_order_id 
							 WHERE od.xod_pid = p.p_id) as enrolled_students
							FROM yn_ecom_products p 
							LEFT JOIN yn_site_catagory c ON p.p_category = c.ctid 
							LEFT JOIN yn_site_sub_cat sc ON p.p_sub_category = sc.sc_id
							LEFT JOIN yn_site_sub2_cat ssc ON p.p_sub_sub_cat = ssc.mr_sub2_id
							LEFT JOIN yn_site_sub3_cat sssc ON p.p_sub_sub_sub_cat = sssc.mr_sub3_id
							LEFT JOIN yn_ecom_products_img pi ON p.p_id = pi.pid
							WHERE p.p_status = '1' AND p.p_id = 84
							LIMIT 1";
		$hero_topic_result = $this->db->query($hero_topic_query);
		$data['hero_topic'] = $hero_topic_result->row_array();

		// Get FAQ for the hero topic
		if (!empty($data['hero_topic'])) {
			$faq_query = "SELECT question as faq_question, answer as faq_answer FROM yn_topic_faqs WHERE topic_id = ? AND faq_status = '1' ORDER BY faq_order ASC LIMIT 3";
			$faq_result = $this->db->query($faq_query, [$data['hero_topic']['p_id']]);
			$data['hero_topic_faqs'] = $faq_result->result_array();
			
			// Get enrolled students' profile images
			$enrolled_students_query = "SELECT DISTINCT m.mid, m.firstname, m.lastname, m.photo 
										FROM yn_ecom_orders_detail od 
										JOIN yn_ecom_order o ON od.checkout_order_id = o.so_order_id 
										JOIN yn_site_mem m ON o.so_mid = m.mid 
										WHERE od.xod_pid = ? AND m.photo IS NOT NULL AND m.photo != ''
										ORDER BY o.so_date DESC 
										LIMIT 6";
			$enrolled_students_result = $this->db->query($enrolled_students_query, [$data['hero_topic']['p_id']]);
			$data['enrolled_students_images'] = $enrolled_students_result->result_array();
		}

		// hot deals for "Deals Hot of The Day" section
		// Fetch only products from category 8, join for tyre/engine condition names and city/state names
		$getHotDeals = $this->db->query("SELECT p.p_id, p.p_name, p.p_year, p.p_model, p.p_price, p.p_image1, 
            ci.city_name AS city, s.state_name AS state,
            tc.stg_name AS tyre_condition, ec.stg_name AS engine_condition
            FROM yn_ecom_products p
            LEFT JOIN yn_site_tags tc ON p.tyre_condition = tc.stg_tgid AND tc.stg_type = 'tyre_type'
            LEFT JOIN yn_site_tags ec ON p.engine_type = ec.stg_tgid AND ec.stg_type = 'engine_typ'
            LEFT JOIN yn_site_cities ci ON p.city = ci.city_id
            LEFT JOIN yn_site_states s ON p.state = s.state_id
            WHERE p.p_category = '8' ORDER BY p.p_id DESC LIMIT 4");
		$hot_deals = $getHotDeals->result_array();

		// Get additional images for each hot deal product
		foreach($hot_deals as $key => $deal) {
			$pid = $deal['p_id'];
			// Main image from img1
			$hot_deals[$key]['main_image'] = !empty($deal['p_image1']) ? $deal['p_image1'] : '';
			// All images from yn_ecom_products_img
			$getProductImages = $this->db->query("SELECT img FROM yn_ecom_products_img WHERE pid = '$pid' ORDER BY id ASC");
			$productImages = $getProductImages->result_array();
			$hot_deals[$key]['additional_images'] = $productImages;
		}
		$data['hot_deals'] = $hot_deals;

		// Top 3 Best Seller products (using p_looking = '7')
		$getBestSellers = $this->db->query("SELECT * FROM `yn_ecom_products` WHERE p_looking = '6' ORDER BY p_id DESC LIMIT 3");
		$best_sellers = $getBestSellers->result_array();
		
		// Get review count for best seller products
		foreach($best_sellers as $key => $seller) {
			$reviewCount = !empty($seller['p_weight']) ? $seller['p_weight'] : 0;
			$best_sellers[$key]['review_count'] = $reviewCount;
		}
		
		$data['best_sellers'] = $best_sellers;

		// featured products
		$featuredproducts = $this->db->query("SELECT * FROM yn_ecom_products WHERE p_sale_status = '2' ORDER BY p_id DESC LIMIT 6");
		$featuredproductsdata = $featuredproducts->result_array();
		$data['featuredProducts'] = $featuredproductsdata;

		// banner
		$get_banner = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='home' AND img_status='1' ORDER BY img_id DESC LIMIT 3");
		$thebanner = $get_banner->result_array();
		$data['banner'] = $thebanner;
		
		$get_banners = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='homeb' AND img_status='1' ORDER BY img_id DESC LIMIT 1");
		$thebanners = $get_banners->row_array();
		$data['banners'] = $thebanners;

		// Video banner
		$get_banner1 = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='homevideo' AND img_status='1' ORDER BY img_id DESC LIMIT 1");
		$thebanner1 = $get_banner1->row_array();
		$data['video'] = $thebanner1;

		// Home page slider
		$get_sliders = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='slider1' AND img_status='1' ORDER BY img_sort ASC LIMIT 10");
		$home_sliders = $get_sliders->result_array();
		$data['home_sliders'] = $home_sliders;

		// Popular Departments - New Arrivals with View More functionality
		$all_new_products = $this->db->query("SELECT * FROM yn_ecom_products WHERE p_year = 2025 AND p_vendor IS NOT NULL AND p_vendor != '' ORDER BY p_id DESC")->result_array();
		$initial_new_products = array_slice($all_new_products, 0, 4);
		$data['popular_products_new'] = $initial_new_products;
		$data['all_new_products'] = $all_new_products;
		
		// Best Seller with View More functionality
		$all_best_products = $this->db->query("SELECT * FROM yn_ecom_products WHERE p_vendor IS NOT NULL AND p_vendor != '' ORDER BY p_id DESC")->result_array();
		$initial_best_products = array_slice($all_best_products, 0, 4);
		$data['popular_products_best'] = $initial_best_products;
		$data['all_best_products'] = $all_best_products;
		
		// Most Popular with View More functionality
		$all_popular_products = $this->db->query("SELECT * FROM yn_ecom_products WHERE p_year = 2025 AND p_vendor IS NOT NULL AND p_vendor != '' ORDER BY p_id DESC")->result_array();
		$initial_popular_products = array_slice($all_popular_products, 0, 4);
		$data['popular_products_popular'] = $initial_popular_products;
		$data['all_popular_products'] = $all_popular_products;
		
		// Featured with View More functionality
		$all_featured_products = $this->db->query("SELECT * FROM yn_ecom_products WHERE p_year = 2025 AND p_vendor IS NOT NULL AND p_vendor != '' ORDER BY p_id DESC")->result_array();
		$initial_featured_products = array_slice($all_featured_products, 0, 4);
		$data['popular_products_featured'] = $initial_featured_products;
		$data['all_featured_products'] = $all_featured_products;

		// Dynamic category sections (first 3 categories)
		$categories = $this->db->query("SELECT * FROM yn_site_catagory ORDER BY sid ASC LIMIT 3")->result_array();
		$category_products = [];
		foreach ($categories as $cat) {
			$category_products[$cat['ctid']] = $this->db->query("SELECT * FROM yn_ecom_products WHERE p_category = '{$cat['ctid']}' ORDER BY p_id DESC LIMIT 8")->result_array();
		}
		$data['categories'] = $categories;
		$data['category_products'] = $category_products;

		// Main dynamic category section (first real category)
		$main_category = $this->db->query("SELECT * FROM yn_site_catagory ORDER BY sid ASC LIMIT 1")->row_array();
		$main_products = [];
		if (!empty($main_category['ctid'])) {
			$main_products = $this->db->query("SELECT * FROM yn_ecom_products WHERE p_category = '{$main_category['ctid']}' ORDER BY p_id DESC LIMIT 8")->result_array();
		}
		$data['main_category'] = $main_category;
		$data['main_products'] = $main_products;

		// Top Categories Of The Month - distinct sid
			$top_categories = $this->db->query("SELECT * FROM yn_site_catagory WHERE sid NOT IN (4,5, 6)  ORDER BY sid ASC")->result_array();
			$data['top_categories'] = $top_categories;


		// Our Clients - Brands with View More functionality
		// Get all brands initially
		$all_brands_query = "SELECT * FROM yn_site_tags WHERE stg_type = 'Brands' ORDER BY stg_name ASC";
		$all_brands = $this->db->query($all_brands_query)->result_array();
		
		// Show first 8 brands initially
		$initial_brands = array_slice($all_brands, 0, 8);
		$data['brands'] = $initial_brands;
		$data['all_brands'] = $all_brands;
		$data['total_brands'] = count($all_brands);

		// Get FAQs for the home page
		$faqs_query = $this->db->query("SELECT * FROM yn_site_faq WHERE faq_status = '1' ORDER BY faq_sort ASC LIMIT 4");
		$faqs = $faqs_query->result_array();
		$data['faqs'] = $faqs;

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/brain.php', $data);
		$this->load->view('home', $data);
		$this->load->view('inc/_footer', $data);
	}
	function admin()
	{
		redirect(base_url('admin/login'));
	}

	function error_404()
	{

		$data = db_variables();
		$data['seo_title'] = $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		$this->load->view('inc/_header', $data);
		$this->load->view('error', $data);
		$this->load->view('inc/_footer', $data);
	}

	function page($slug)
	{
		$get_all_blocks = $this->db->query("select * from yn_admin_pages where pg_slug ='$slug' ");
		$the_pages_data = $get_all_blocks->row_array();


		$data = db_variables();
		$data['seo_title'] = $the_pages_data['pg_meta_title'];
		$data['seo_description'] = $data['meta_title'];;
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['page_name'] = 'Ynaps.com';
		$data['page_data'] = $the_pages_data['content'];
		$data['meta_array'] = $data;


		$this->load->view('inc/_header', $data);
		$this->load->view('inc/_page_data.php', $data);
		$this->load->view('inc/_footer', $data);
	}

	function about()
	{
		$data = db_variables();
		$data['seo_title'] = 'About Us - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		// banner
		$get_banner = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='home' AND img_status='1' ORDER BY img_id DESC LIMIT 3");
		$thebanner = $get_banner->result_array();
		$data['banner'] = $thebanner;
		
		$get_banner = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='about' AND img_status='1' ORDER BY img_id DESC LIMIT 1");
		$thebanner = $get_banner->row_array();
		$data['image'] = $thebanner;

		$get_banner1 = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='babout' AND img_status='1' ORDER BY img_id DESC LIMIT 1");
		$thebanner1 = $get_banner1->row_array();
		$data['breadcrumb'] = $thebanner1;
		
		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('about', $data);
		$this->load->view('inc/_footer', $data);
	}

	function services()
	{

		if (check_service_status('1', '2', 'se') != '1') {
			redirect('error-404?e=this feature is not enabled.');
		}

		$data = db_variables();
		$data['seo_title'] = $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;


		$getAllServices = $this->db->query("SELECT * FROM yn_site_services ORDER BY service_id ASC LIMIT 10");
		$all_services = $getAllServices->result_array();
		$data['services'] = $all_services;

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('service', $data);
		$this->load->view('inc/_footer', $data);
	}

	function service($slug)
	{


		if (check_service_status('1', '2', 'se') != '1') {
			redirect('error-404?e=this feature is not enabled.');
		}

		$data = db_variables();
		$data['seo_title'] = $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		$slug = clean($slug);
		if ($slug == '') {
			redirect(base_url('error-404?e=No Service found.'));
		}
		$getTheService = $this->db->query("SELECT * FROM yn_site_services WHERE slug = '$slug'");
		$theService = $getTheService->row_array();
		$data['theService'] = $theService;

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('service_detail', $data);
		$this->load->view('inc/_footer', $data);
	}

	function pricing()
	{
		$data = db_variables();
		$data['seo_title'] = 'Pricing - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('inc/pricing.php', $data);
		$this->load->view('inc/_footer', $data);
	}



	function support($cid = 0, $cname = null)
	{
		$this->contact();
	}
	function career($cid = 0, $cname = null)
	{
		$this->contact();
	}

	function contact($cid = 0, $cname = null)
	{
		$data = db_variables();
		$data['seo_title'] = 'Contact us - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_title'];;
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['page_name'] = 'YNAPS';
		$data['meta_array'] = $data;

		$data['con_type'] = '0';
		if ($cid > '0') {
			$data['con_type'] = '6';
			$data['cid'] = $cid;
			$data['cname'] = unsmart_url($cname);
		}

		$get_banner1 = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='bcontact' AND img_status='1' ORDER BY img_id DESC LIMIT 1");
		$thebanner1 = $get_banner1->row_array();
		$data['breadcrumb'] = $thebanner1;

		$this->load->view('inc/_header', $data);
		// $this->load->view('inc/section.php', $data);
		$this->load->view('contact', $data);
		$this->load->view('inc/_footer', $data);
	}

	function accounts()
	{
		$this->account();
	}
	function account()
	{
		check_session('1', 'profile');
		$theoption = $this->uri->segment(3);
		switch ($theoption) {
			case 'login':
				$this->login();
				break;
			default:
				$this->login();
				break;
		}
	}

	public function signup($user_type = null)
	{
		check_session(1, 'profile');
		$data = db_variables();
		$data['seo_title'] = 'Signup - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;
		
		// Get all active companies for dropdown (with logo)
		$get_companies = $this->db->query("SELECT comp_id, comp_name, comp_logo FROM yn_ai_companies WHERE comp_status='1' ORDER BY comp_name ASC");
		$data['companies'] = $get_companies->result_array();
		
		// Get all active collections for dropdown
		$get_collections = $this->db->query("SELECT coll_id, coll_name, coll_comp_id FROM yn_ai_collections WHERE coll_status='1' ORDER BY coll_name ASC");
		$data['collections'] = $get_collections->result_array();
		
		// Store redirect URL for after signup/OTP verification
		$redirect_url = $this->input->get('redirect');
		if (!empty($redirect_url)) {
			$_SESSION['redirect_after_login'] = $redirect_url;
		}

		$this->load->view('signup', $data);
	}

	// Company and Collection Selection Page (after OTP verification)
	public function select_company_collection()
	{
		@session_start();
		// Check if user is logged in
		if (!isset($_SESSION['yid']) || empty($_SESSION['yid'])) {
			redirect(base_url('login'));
			return;
		}
		
		$data = db_variables();
		$data['seo_title'] = 'Select Company & Collection - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;
		
		// Get all active companies for dropdown (with logo)
		$get_companies = $this->db->query("SELECT comp_id, comp_name, comp_logo FROM yn_ai_companies WHERE comp_status='1' ORDER BY comp_name ASC");
		$data['companies'] = $get_companies->result_array();
		
		// Get all active collections for dropdown
		$get_collections = $this->db->query("SELECT coll_id, coll_name, coll_comp_id FROM yn_ai_collections WHERE coll_status='1' ORDER BY coll_name ASC");
		$data['collections'] = $get_collections->result_array();
		
		$this->load->view('select_company_collection', $data);
	}


	public function login()
	{
		check_session(1, 'profile');
		$data = db_variables();
		$data['seo_title'] = 'Login - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;
		
		// Store redirect URL for after login
		$redirect_url = $this->input->get('redirect');
		if (!empty($redirect_url)) {
			$_SESSION['redirect_after_login'] = $redirect_url;
		}

		$this->load->view('login', $data);
	}

	public function login_phone()
	{
		check_session(1, 'profile');
		$data = db_variables();
		$data['seo_title'] = 'Phone Login - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;
		
		$get_banner1 = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='bloginp' AND img_status='1' ORDER BY img_id DESC LIMIT 1");
		$thebanner1 = $get_banner1->row_array();
		$data['breadcrumb'] = $thebanner1;

		$this->load->view('inc/_header', $data);
		$this->load->view('login_phone', $data);
		$this->load->view('inc/_footer', $data);
	}

	function login_otp_verify()
	{
		@session_start();
		//check_session('2','account');
		$data = db_variables();
		$data['seo_title'] = 'OTP Verify - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_title'];
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['page_name'] = 'YNAPS';
		$data['meta_array'] = $data;

		// Load standalone login OTP verification page (no main header/footer)
		$this->load->view('inc/_header', $data);
		$this->load->view('login_otp_verify', $data);
		$this->load->view('inc/_footer', $data);

	}

	function password()
	{
		if (isset($_SESSION['yid']) && $_SESSION['yid'] != '') {
			redirect(base_url('profile'));
		}
		$data = db_variables();
		$data['seo_title'] = 'Password Reset - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_title'];
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['page_name'] = 'Password';
		$data['meta_array'] = $data;

		// Load standalone password reset page (no header/footer, like login/signup)
		$this->load->view('password_reset.php', $data);
	}

	function reset_password()
	{
		// if(isset($_SESSION['yid']) && $_SESSION['yid'] !=''){ redirect(base_url('profile')); }

		$data = db_variables();
		$data['seo_title'] = 'Password Reset - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_title'];
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['page_name'] = 'Reset Password';
		$data['meta_array'] = $data;

		$email = $this->input->get('mail');

		$getdats = $this->db->query("select pass_reset from yn_site_mem where email='$email' ");
		$thedetails = $getdats->row_array();

		$c = $this->input->get('c');
		if ($thedetails['pass_reset'] != $c) {
			redirect(base_url('error-404'));
		}

		$hash = $this->input->get('ha');

		if (sha1($email) . '90' != $hash) {
			redirect(base_url('profile'));
		} else {
			$data['e'] = $email;

			// Load standalone password reset2 page (no header/footer, like login/signup)
			$this->load->view('password_reset2.php', $data);
		}
	}

	function refund()
	{
		$data = db_variables();
		$data['seo_title'] = 'Refund - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['meta_array'] = $data;
		$data['page_name'] = 'Terms';

        $get_banner1 = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='brefund' AND img_status='1' ORDER BY img_id DESC LIMIT 1");
		$thebanner1 = $get_banner1->row_array();
		$data['breadcrumb'] = $thebanner1;


		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('refund', $data);
		$this->load->view('inc/_footer', $data);
	}

	function test()
	{

		echo "<pre>";
		print_r($this->session->all_userdata());
		echo "</pre>";
		// $this->load->view('test');
	}

	function terms()
	{
		$data = db_variables();
		$data['seo_title'] = 'Terms & Conditions - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['meta_array'] = $data;
		$data['page_name'] = 'Terms';
		
		$get_banner1 = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='bterm' AND img_status='1' ORDER BY img_id DESC LIMIT 1");
		$thebanner1 = $get_banner1->row_array();
		$data['breadcrumb'] = $thebanner1;



		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('terms', $data);
		$this->load->view('inc/_footer', $data);
	}
	function privacy()
	{
		$data = db_variables();
		$data['seo_title'] = 'Privacy Policy - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['meta_array'] = $data;
		$data['page_name'] = 'YNAPS';
		
		$get_banner1 = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='bprivacy' AND img_status='1' ORDER BY img_id DESC LIMIT 1");
		$thebanner1 = $get_banner1->row_array();
		$data['breadcrumb'] = $thebanner1;

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('privacy', $data);
		$this->load->view('inc/_footer', $data);
	}

	function faq()
	{
		$data = db_variables();
		$data['seo_title'] = 'FAQs - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['meta_array'] = $data;
		$data['page_name'] = 'FAQ';
		
		$get_banner1 = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='bfaq' AND img_status='1' ORDER BY img_id DESC LIMIT 1");
		$thebanner1 = $get_banner1->row_array();
		$data['breadcrumb'] = $thebanner1;



		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('inc/faq', $data);
		$this->load->view('inc/_footer', $data);
	}

	function profile()
	{
		@session_start();
		check_session('2', 'account');
		$data = db_variables();
		$data['seo_title'] = 'Profile - ' . $data['meta_title'];;
		$data['seo_description'] = $data['meta_title'];;
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['page_name'] = 'Profile';
		$data['meta_array'] = $data;

		$yid = $_SESSION['yid'];
		error_log("Profile Debug - Session YID: " . $yid);
		error_log("Profile Debug - Session data: " . json_encode($_SESSION));
		
		$themyuser_details = $this->ynaps_model->getprofile_data('*', $_SESSION['yid']);
		
		// Debug: Log profile data
		error_log("Profile Debug - Profile data from model: " . json_encode($themyuser_details));
		
		// Ensure profile_data is set even if empty
		if (empty($themyuser_details)) {
			error_log("Profile Debug - WARNING: Profile data is empty!");
			$themyuser_details = array();
		}
		
		$data['profile_data'] = $themyuser_details;
		
		// Fallback to session data if profile_data is empty
		if (empty($data['profile_data']['name']) && isset($_SESSION['name'])) {
			$data['profile_data']['name'] = $_SESSION['name'];
		}
		if (empty($data['profile_data']['email']) && isset($_SESSION['email'])) {
			$data['profile_data']['email'] = $_SESSION['email'];
		}
		if (empty($data['profile_data']['phone']) && isset($_SESSION['phone'])) {
			$data['profile_data']['phone'] = $_SESSION['phone'];
		}
		if (empty($data['profile_data']['photo']) && isset($_SESSION['photo'])) {
			$data['profile_data']['photo'] = $_SESSION['photo'];
		}
		if (empty($data['profile_data']['user_type']) && isset($_SESSION['user_type'])) {
			$data['profile_data']['user_type'] = $_SESSION['user_type'];
		}
		
		// Ensure wallet_bal is set (default to 0 if not present)
		if (!isset($data['profile_data']['wallet_bal'])) {
			$data['profile_data']['wallet_bal'] = 0.00;
		}
		
		// Load company and collection names if IDs exist
		if (isset($themyuser_details['comp_id']) && !empty($themyuser_details['comp_id'])) {
			$company_query = $this->db->query("SELECT comp_name FROM yn_ai_companies WHERE comp_id = '" . $themyuser_details['comp_id'] . "'");
			$company = $company_query->row_array();
			if ($company) {
				$data['profile_data']['company_name'] = $company['comp_name'];
			}
		}
		if (isset($themyuser_details['coll_id']) && !empty($themyuser_details['coll_id'])) {
			$collection_query = $this->db->query("SELECT coll_name FROM yn_ai_collections WHERE coll_id = '" . $themyuser_details['coll_id'] . "'");
			$collection = $collection_query->row_array();
			if ($collection) {
				$data['profile_data']['collection_name'] = $collection['coll_name'];
			}
		}
		
		// Load teacher's category hierarchy if user is a teacher
		if (isset($_SESSION['user_type']) && $_SESSION['user_type'] == 'teacher') {
			$teacher_hierarchy_query = "SELECT 
				c.name as category_name,
				sc.sc_name as subcategory_name,
				ssc.mr_sub2_name as sub_subcategory_name,
				ssc.mr_sub2_id as sub_subcategory_id
			FROM yn_site_mem m
			LEFT JOIN yn_site_catagory c ON m.category_id = c.ctid
			LEFT JOIN yn_site_sub_cat sc ON m.subcategory_id = sc.sc_id
			LEFT JOIN yn_site_sub2_cat ssc ON m.sub_subcategory_id = ssc.mr_sub2_id
			WHERE m.mid = '$yid'";
			
			$teacher_hierarchy = $this->db->query($teacher_hierarchy_query)->row_array();
			if ($teacher_hierarchy) {
				$data['profile_data']['category_name'] = $teacher_hierarchy['category_name'];
				$data['profile_data']['subcategory_name'] = $teacher_hierarchy['subcategory_name'];
				$data['profile_data']['sub_subcategory_name'] = $teacher_hierarchy['sub_subcategory_name'];
				$data['profile_data']['sub_subcategory_id'] = $teacher_hierarchy['sub_subcategory_id'];
			}
		}

		// Load teacher-specific data into session if user is a teacher
		if (isset($_SESSION['user_type']) && $_SESSION['user_type'] == 'teacher') {
			$teacher_data = $this->db->query("SELECT teacher_intro_video, teacher_experience, teacher_education, video_uploaded FROM yn_site_mem WHERE mid = '$yid'")->row_array();
			if ($teacher_data) {
				$_SESSION['teacher_intro_video'] = $teacher_data['teacher_intro_video'];
				$_SESSION['teacher_experience'] = $teacher_data['teacher_experience'];
				$_SESSION['teacher_education'] = $teacher_data['teacher_education'];
				$_SESSION['video_uploaded'] = $teacher_data['video_uploaded'];
			}
		}

		// Load separate profile columns directly to data array (not session)
		$profile_columns = $this->db->query("SELECT firstname, lastname, username, phone, skill, displayname, about, name FROM yn_site_mem WHERE mid = '$yid'")->row_array();
		if ($profile_columns) {
			$data['profile_firstname'] = $profile_columns['firstname'];
			$data['profile_lastname'] = $profile_columns['lastname'];
			$data['profile_username'] = $profile_columns['username'];
			$data['profile_phone'] = $profile_columns['phone'];
			$data['profile_skill'] = $profile_columns['skill'];
			$data['profile_displayname'] = $profile_columns['displayname'];
			$data['profile_about'] = $profile_columns['about'];
			
			// Use firstname + lastname if available, otherwise use the name field
			if (!empty($profile_columns['firstname']) && !empty($profile_columns['lastname'])) {
				$data['profile_name'] = $profile_columns['firstname'] . ' ' . $profile_columns['lastname'];
			} else {
				$data['profile_name'] = $profile_columns['name'];
			}
		}

		$yid = $_SESSION['yid'];
		$email = $_SESSION['email'];

		$getall_order = $this->db->query("select * from yn_ecom_order where so_email = '$email' order by so_id desc");
		$all_order = $getall_order->result_array();
		$data['allorders'] = $all_order;

		// Get user's products (with names via JOIN)
		$get_user_products = $this->db->query("SELECT p.*, c.name AS category_name, b.stg_name AS brand_name, s.state_name, ci.city_name FROM yn_ecom_products p LEFT JOIN yn_site_catagory c ON p.p_category = c.ctid LEFT JOIN yn_site_tags b ON p.p_brand_name = b.stg_tgid LEFT JOIN yn_site_states s ON p.state = s.state_id LEFT JOIN yn_site_cities ci ON p.city = ci.city_id WHERE p.p_vendor = '$yid' ORDER BY p.p_id DESC");
		$user_products = $get_user_products->result_array();
		// Get images for each product (with error handling)
		foreach ($user_products as &$product) {
			$product_id = $product['p_id'];
			try {
				$get_images = $this->db->query("SELECT id as img_id, img as img_name FROM yn_ecom_products_img WHERE pid = '$product_id' ORDER BY id ASC");
				$product['images'] = $get_images->result_array();
			} catch (Exception $e) {
				$product['images'] = array();
			}
		}
		$data['user_products'] = $user_products;

		// Load user topics data directly in profile function
		$user_type = $_SESSION['user_type'] ?? 'user';
		
		// Debug: Log user type and user ID
		error_log("Profile Debug - User Type: " . $user_type);
		error_log("Profile Debug - User ID: " . $yid);
		
		// Check what's actually in the database
		$db_user_check = $this->db->query("SELECT user_type FROM yn_site_mem WHERE mid = '$yid'")->row_array();
		error_log("Profile Debug - Database user_type: " . ($db_user_check ? $db_user_check['user_type'] : 'Not found'));
		
		// Use database user_type if session is wrong or empty
		if ($db_user_check && $db_user_check['user_type']) {
			$user_type = $db_user_check['user_type'];
			// Update session with correct user_type
			$_SESSION['user_type'] = $user_type;
			error_log("Profile Debug - Using database user_type: " . $user_type);
		}
		
		if ($user_type == 'teacher' || $user_type == 't') {
			// For teachers: get topic IDs assigned to them from orders (newest first)
			$topic_ids_query = "SELECT DISTINCT od.xod_pid as topic_id, od.checkout_order_id as order_id, o.so_date as purchase_date, o.so_mid as student_id, o.so_name as student_name, o.so_email as student_email, o.so_phone as student_phone, sm.photo as student_image
				FROM yn_ecom_orders_detail od
				LEFT JOIN yn_ecom_order o ON od.checkout_order_id = o.so_order_id
				LEFT JOIN yn_site_mem sm ON o.so_mid = sm.mid
				WHERE od.teacher_id = '$yid' 
				AND o.so_status = 1
				ORDER BY o.so_date DESC";
			
			$topic_ids_result = $this->db->query($topic_ids_query);
			$topic_orders = $topic_ids_result->result_array();
			
			$topics = array();
			foreach ($topic_orders as $order) {
				$topic_id = $order['topic_id'];
				
				// Get topic details from products table
				$topic_query = "SELECT 
					p.p_id as topic_id,
					p.p_name as topic_name,
					p.p_descp as topic_description,
					p.topic_duration as topic_duration,
					p.topic_level as topic_level,
					p.topic_lessons as topic_lessons,
					p.p_star as rating,
					p.p_weight as reviews_count,
					p.p_price as topic_price,
					c.name as category_name,
					sc.sc_name as subcategory_name,
					ssc.mr_sub2_name as sub_subcategory_name,
					sssc.mr_sub3_name as sub_sub_subcategory_name,
					pi.img as product_image
				FROM yn_ecom_products p
				LEFT JOIN yn_site_catagory c ON p.p_category = c.ctid
				LEFT JOIN yn_site_sub_cat sc ON p.p_sub_category = sc.sc_id
				LEFT JOIN yn_site_sub2_cat ssc ON p.p_sub_sub_cat = ssc.mr_sub2_id
				LEFT JOIN yn_site_sub3_cat sssc ON p.p_sub_sub_sub_cat = sssc.mr_sub3_id
				LEFT JOIN yn_ecom_products_img pi ON p.p_id = pi.pid
				WHERE p.p_id = '$topic_id'
				LIMIT 1";
				
				$topic_result = $this->db->query($topic_query);
				$topic_data = $topic_result->row_array();
				
				if ($topic_data) {
					// Merge order data with topic data
					$topic_data['order_id'] = $order['order_id'];
					$topic_data['purchase_date'] = $order['purchase_date'];
					$topic_data['student_id'] = $order['student_id'];
					$topic_data['student_name'] = $order['student_name'];
					$topic_data['student_email'] = $order['student_email'];
					$topic_data['student_phone'] = $order['student_phone'];
					$topic_data['student_image'] = $order['student_image'];
					$topic_data['topic_image'] = ''; // Not used since we have product_image
					
					// Add default values for dynamic fields
					$topic_data['rating'] = $topic_data['rating'] ?: '4.5';
					$topic_data['reviews_count'] = $topic_data['reviews_count'] ?: '0';
					
					$topics[] = $topic_data;
				}
			}

		} else {
			// For students: get topic IDs they purchased from orders
			error_log("Profile Debug - Processing student topics for user ID: " . $yid);
			
			// First, let's check if there are any orders for this user
			$check_orders_query = "SELECT COUNT(*) as total FROM yn_ecom_order WHERE so_mid = '$yid'";
			$check_orders_result = $this->db->query($check_orders_query);
			$total_orders = $check_orders_result->row()->total;
			error_log("Profile Debug - Total orders for user $yid: " . $total_orders);
			
			// Check orders with status 1
			$check_orders_status_query = "SELECT COUNT(*) as total FROM yn_ecom_order WHERE so_mid = '$yid' AND so_status = 1";
			$check_orders_status_result = $this->db->query($check_orders_status_query);
			$total_orders_status_1 = $check_orders_status_result->row()->total;
			error_log("Profile Debug - Orders with status 1 for user $yid: " . $total_orders_status_1);
			
			// Get only purchased topics for this student (exclude custom topics) - newest first
			$topic_ids_query = "SELECT DISTINCT od.xod_pid as topic_id, od.checkout_order_id as order_id, o.so_date as purchase_date, od.teacher_id, 'purchased' as topic_type
				FROM yn_ecom_orders_detail od
				LEFT JOIN yn_ecom_order o ON od.checkout_order_id = o.so_order_id
				WHERE o.so_mid = '$yid' 
				AND o.so_status = 1
				ORDER BY o.so_date DESC";
			
			error_log("Profile Debug - Student query: " . $topic_ids_query);
			
			$topic_ids_result = $this->db->query($topic_ids_query);
			$topic_orders = $topic_ids_result->result_array();
			
			error_log("Profile Debug - Found " . count($topic_orders) . " student topic orders");
			
			// Debug: Log the actual order data with purchase dates
			error_log("Profile Debug - Order data: " . json_encode($topic_orders));
			
			// Debug: Log purchase dates to verify ordering
			foreach ($topic_orders as $index => $order) {
				error_log("Profile Debug - Order $index: Topic ID " . $order['topic_id'] . ", Purchase Date: " . $order['purchase_date']);
			}
			
			$topics = array();
			foreach ($topic_orders as $order) {
				$topic_id = $order['topic_id'];
				$teacher_id = $order['teacher_id'];
				$topic_type = $order['topic_type'];
				
				// Get topic details from products table with teacher information
				$topic_query = "SELECT 
					p.p_id as topic_id,
					p.p_name as topic_name,
					p.p_descp as topic_description,
					p.topic_duration as topic_duration,
					p.topic_level as topic_level,
					p.topic_lessons as topic_lessons,
					p.p_star as rating,
					p.p_weight as reviews_count,
					p.p_price as topic_price,
					c.name as category_name,
					sc.sc_name as subcategory_name,
					ssc.mr_sub2_name as sub_subcategory_name,
					COALESCE(ssc.mr_sub2_id, sssc.mr_sub3_sid) as sub_subcategory_id,
					sssc.mr_sub3_name as sub_sub_subcategory_name,
					pi.img as product_image,
					m.firstname as teacher_name,
					m.email as teacher_email,
					m.phone as teacher_phone,
					m.about as teacher_bio,
					m.photo as teacher_image,
					p.p_sku as sku
				FROM yn_ecom_products p
				LEFT JOIN yn_site_catagory c ON p.p_category = c.ctid
				LEFT JOIN yn_site_sub_cat sc ON p.p_sub_category = sc.sc_id
				LEFT JOIN yn_site_sub2_cat ssc ON p.p_sub_sub_cat = ssc.mr_sub2_id
				LEFT JOIN yn_site_sub3_cat sssc ON p.p_sub_sub_sub_cat = sssc.mr_sub3_id
				LEFT JOIN yn_ecom_products_img pi ON p.p_id = pi.pid
				LEFT JOIN yn_site_mem m ON m.mid = '$teacher_id'
				WHERE p.p_id = '$topic_id'
				LIMIT 1";
				
				$topic_result = $this->db->query($topic_query);
				$topic_data = $topic_result->row_array();
				
				if ($topic_data) {
					// Merge order data with topic data
					$topic_data['order_id'] = $order['order_id'];
					$topic_data['purchase_date'] = $order['purchase_date'];
					$topic_data['teacher_id'] = $teacher_id;
					$topic_data['topic_type'] = $topic_type;
					$topic_data['topic_image'] = ''; // Not used since we have product_image
					
					// Add default values for dynamic fields
					$topic_data['rating'] = $topic_data['rating'] ?: '4.5';
					$topic_data['reviews_count'] = $topic_data['reviews_count'] ?: '0';
					
					// Mark as custom topic
					$topic_data['is_custom_topic'] = (strpos($topic_data['sku'], 'CUSTOM_STUDENT_') === 0) ? 1 : 0;
					
					$topics[] = $topic_data;
				}
			}
		}

		// Add meeting information for each topic from database
		foreach ($topics as &$topic) {
			$topic_id = $topic['topic_id'];
			$order_id = $topic['order_id'];
			
			// Fetch enhanced meeting details from database
			$meeting_query = "SELECT meeting_link, meeting_time, meeting_notes, meeting_type, 
							  meeting_date, meeting_day, meeting_timezone, meeting_status
							  FROM yn_topic_meetings 
							  WHERE topic_id = '$topic_id' AND order_id = '$order_id' 
							  LIMIT 1";
			$meeting_result = $this->db->query($meeting_query);
			$meeting_data = $meeting_result->row_array();
			
			if ($meeting_data) {
				$topic['meeting_link'] = $meeting_data['meeting_link'] ?: '';
				$topic['meeting_time'] = $meeting_data['meeting_time'] ?: '';
				$topic['meeting_notes'] = $meeting_data['meeting_notes'] ?: '';
				$topic['meeting_type'] = $meeting_data['meeting_type'] ?: 'specific_date';
				$topic['meeting_date'] = $meeting_data['meeting_date'] ?: '';
				$topic['meeting_day'] = $meeting_data['meeting_day'] ?: '';
				$topic['meeting_timezone'] = $meeting_data['meeting_timezone'] ?: 'Asia/Kolkata';
				$topic['meeting_status'] = $meeting_data['meeting_status'] ?: 'scheduled';
			} else {
				$topic['meeting_link'] = '';
				$topic['meeting_time'] = '';
				$topic['meeting_notes'] = '';
				$topic['meeting_type'] = 'specific_date';
				$topic['meeting_date'] = '';
				$topic['meeting_day'] = '';
				$topic['meeting_timezone'] = 'Asia/Kolkata';
				$topic['meeting_status'] = 'scheduled';
			}
		}

		error_log("Profile Debug - Final topics count: " . count($topics));
		error_log("Profile Debug - Topics data: " . json_encode($topics));

		$data['user_topics'] = $topics;
		$data['user_type'] = $user_type;

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section2', $data);
		$this->load->view('profile', $data);
		$this->load->view('inc/_footer', $data);
		
	}

	function profile_setting()
	{
		@session_start();
		check_session('2', 'account');
		$data = db_variables();
		$data['seo_title'] = 'Profile Setting - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		$yid = $_SESSION['yid'];
		$themyuser_details = $this->ynaps_model->getprofile_data('*', $_SESSION['yid']);
		$data['profile_data'] = $themyuser_details;
		
		// Get companies for dropdown (to allow changing company)
		$get_companies = $this->db->query("SELECT comp_id, comp_name FROM yn_ai_companies WHERE comp_status='1' ORDER BY comp_name ASC");
		$data['companies'] = $get_companies->result_array();
		
		// Get collections for dropdown (filtered by selected company)
		$selected_comp_id = isset($themyuser_details['comp_id']) ? $themyuser_details['comp_id'] : '';
		if ($selected_comp_id) {
			$get_collections = $this->db->query("SELECT coll_id, coll_name FROM yn_ai_collections WHERE coll_comp_id='$selected_comp_id' AND coll_status='1' ORDER BY coll_name ASC");
			$data['collections'] = $get_collections->result_array();
		} else {
			$data['collections'] = array();
		}

		$this->load->view('inc/_header', $data);
		$this->load->view('profile-setting', $data);
		$this->load->view('inc/section2', $data);
		$this->load->view('inc/_footer', $data);
	}

	// Change Company page - Separate page for changing company
	function change_company()
	{
		@session_start();
		check_session('2', 'account');
		$data = db_variables();
		$data['seo_title'] = 'Change Company - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		$yid = $_SESSION['yid'];
		$themyuser_details = $this->ynaps_model->getprofile_data('*', $_SESSION['yid']);
		$data['profile_data'] = $themyuser_details;
		
		// Get company name if comp_id exists
		if (!empty($themyuser_details['comp_id'])) {
			$company_query = $this->db->query("SELECT comp_name FROM yn_ai_companies WHERE comp_id = '" . $themyuser_details['comp_id'] . "'");
			$company = $company_query->row_array();
			if ($company) {
				$data['profile_data']['company_name'] = $company['comp_name'];
			}
		}
		
		// Get collection name if coll_id exists
		if (!empty($themyuser_details['coll_id'])) {
			$collection_query = $this->db->query("SELECT coll_name FROM yn_ai_collections WHERE coll_id = '" . $themyuser_details['coll_id'] . "'");
			$collection = $collection_query->row_array();
			if ($collection) {
				$data['profile_data']['collection_name'] = $collection['coll_name'];
			}
		}
		
		// Get companies for dropdown (with logo)
		$get_companies = $this->db->query("SELECT comp_id, comp_name, comp_logo FROM yn_ai_companies WHERE comp_status='1' ORDER BY comp_name ASC");
		$data['companies'] = $get_companies->result_array();
		
		// Get collections for dropdown (filtered by selected company)
		$selected_comp_id = isset($themyuser_details['comp_id']) ? $themyuser_details['comp_id'] : '';
		if ($selected_comp_id) {
			$get_collections = $this->db->query("SELECT coll_id, coll_name FROM yn_ai_collections WHERE coll_comp_id='$selected_comp_id' AND coll_status='1' ORDER BY coll_name ASC");
			$data['collections'] = $get_collections->result_array();
		} else {
			$data['collections'] = array();
		}

		$this->load->view('inc/_header', $data);
		$this->load->view('change-company', $data);
		$this->load->view('inc/_footer', $data);
	}

	// Saved Templates page - Shows user's saved templates
	function saved_templates()
	{
		@session_start();
		check_session('2', 'account');
		$data = db_variables();
		$data['seo_title'] = 'Saved Templates - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		$yid = $_SESSION['yid'];
		$data['saved_templates'] = array();
		
		// Get user's company ID
		$user_comp_id = '';
		$user_query = $this->db->query("SELECT comp_id FROM yn_site_mem WHERE mid = '$yid'");
		if ($user_query && $user_query->num_rows() > 0) {
			$user_data = $user_query->row_array();
			$user_comp_id = isset($user_data['comp_id']) ? $user_data['comp_id'] : '';
		}
		
		// Check if tables exist
		$tables = $this->db->list_tables();
		
		// Get templates that user has used (from generations table) - filtered by company
		$used_template_ids = array();
		if (in_array('yn_ai_generations', $tables)) {
			$used_query_str = "SELECT DISTINCT g.gen_temp_id 
				FROM yn_ai_generations g
				LEFT JOIN yn_ai_templates t ON g.gen_temp_id = t.temp_id
				LEFT JOIN yn_ai_collections c ON t.temp_coll_id = c.coll_id
				WHERE g.gen_user_id = '$yid' 
				AND g.gen_temp_id IS NOT NULL AND g.gen_temp_id != ''";
			
			if (!empty($user_comp_id)) {
				$used_query_str .= " AND c.coll_comp_id = '$user_comp_id'";
			}
			
			$used_query = $this->db->query($used_query_str);
			if ($used_query && $used_query->num_rows() > 0) {
				foreach ($used_query->result_array() as $used) {
					$used_template_ids[] = $used['gen_temp_id'];
				}
			}
		}
		
		// Get explicitly saved templates - filtered by company
		$saved_template_ids = array();
		if (in_array('yn_ai_saved_templates', $tables)) {
			$saved_query_str = "SELECT s.save_temp_id 
				FROM yn_ai_saved_templates s
				LEFT JOIN yn_ai_templates t ON s.save_temp_id = t.temp_id
				LEFT JOIN yn_ai_collections c ON t.temp_coll_id = c.coll_id
				WHERE s.save_user_id = '$yid'";
			
			if (!empty($user_comp_id)) {
				$saved_query_str .= " AND c.coll_comp_id = '$user_comp_id'";
			}
			
			$saved_query = $this->db->query($saved_query_str);
			if ($saved_query && $saved_query->num_rows() > 0) {
				foreach ($saved_query->result_array() as $saved) {
					$saved_template_ids[] = $saved['save_temp_id'];
				}
			}
		}
		
		// Combine both: used templates + explicitly saved templates (unique)
		$all_template_ids = array_unique(array_merge($used_template_ids, $saved_template_ids));
		
		if (!empty($all_template_ids)) {
			$template_ids_str = implode(',', array_map('intval', $all_template_ids));
			
			// Get template details with collection and company info (filtered by user's company)
			$templates_query = "SELECT DISTINCT t.temp_id, t.temp_name, t.temp_image, t.temp_coll_id,
				c.coll_id, c.coll_name, c.coll_cover_image,
				comp.comp_id, comp.comp_name, comp.comp_logo,
				s.save_created,
				(SELECT MAX(gen_created) FROM yn_ai_generations WHERE gen_user_id = '$yid' AND gen_temp_id = t.temp_id) as last_used_date
				FROM yn_ai_templates t
				LEFT JOIN yn_ai_collections c ON t.temp_coll_id = c.coll_id
				LEFT JOIN yn_ai_companies comp ON c.coll_comp_id = comp.comp_id
				LEFT JOIN yn_ai_saved_templates s ON s.save_temp_id = t.temp_id AND s.save_user_id = '$yid'
				WHERE t.temp_id IN ($template_ids_str) AND t.temp_status = '1'";
			
			// Filter by user's company if comp_id exists
			if (!empty($user_comp_id)) {
				$templates_query .= " AND c.coll_comp_id = '$user_comp_id'";
			}
			
			$templates_query .= " ORDER BY t.temp_id DESC";
			
			$get_templates = $this->db->query($templates_query);
			if ($get_templates && $get_templates->num_rows() > 0) {
				$data['saved_templates'] = $get_templates->result_array();
			}
		}

		$this->load->view('inc/_header', $data);
		$this->load->view('saved-templates', $data);
		$this->load->view('inc/_footer', $data);
	}

	// My Gallery page - User's image gallery
	function my_gallery()
	{
		@session_start();
		check_session('2', 'account');
		
		$data = db_variables();
		$data['seo_title'] = 'My Gallery - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;
		$data['page_name'] = 'My Gallery';
		
		$yid = $_SESSION['yid'];
		
		// Check if gallery table exists, if not create it
		$tables = $this->db->list_tables();
		if (!in_array('yn_user_gallery', $tables)) {
			// Create table
			$create_table = "CREATE TABLE IF NOT EXISTS `yn_user_gallery` (
				`gallery_id` int(11) NOT NULL AUTO_INCREMENT,
				`gallery_user_id` int(11) NOT NULL,
				`gallery_image` varchar(255) NOT NULL,
				`gallery_original_name` varchar(255) DEFAULT NULL,
				`gallery_created` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
				`gallery_status` tinyint(1) NOT NULL DEFAULT '1',
				PRIMARY KEY (`gallery_id`),
				KEY `gallery_user_id` (`gallery_user_id`),
				KEY `gallery_status` (`gallery_status`)
			) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";
			$this->db->query($create_table);
		}
		
		// Get user's gallery images
		$gallery_query = "SELECT * FROM yn_user_gallery WHERE gallery_user_id='$yid' AND gallery_status='1' ORDER BY gallery_created DESC";
		$get_gallery = $this->db->query($gallery_query);
		$data['gallery_images'] = array();
		if ($get_gallery && $get_gallery->num_rows() > 0) {
			$data['gallery_images'] = $get_gallery->result_array();
		}
		
		$this->load->view('inc/_header', $data);
		$this->load->view('my-gallery', $data);
		$this->load->view('inc/_footer', $data);
	}

	// AJAX: Get user's gallery images for template generation
	function get_gallery_images()
	{
		@session_start();
		header('Content-Type: application/json');
		
		if (!isset($_SESSION['yid']) || $_SESSION['yid'] == '') {
			echo json_encode(['success' => false, 'message' => 'Please login first.']);
			return;
		}
		
		$yid = $_SESSION['yid'];
		$images = array();
		
		try {
			// Check if gallery table exists
			$tables = $this->db->list_tables();
			if (!in_array('yn_user_gallery', $tables)) {
				echo json_encode(['success' => true, 'images' => []]);
				return;
			}
			
			// Get user's gallery images
			$gallery_query = "SELECT gallery_id, gallery_image, gallery_original_name, gallery_created 
				FROM yn_user_gallery 
				WHERE gallery_user_id='$yid' AND gallery_status='1' 
				ORDER BY gallery_created DESC";
			$get_gallery = $this->db->query($gallery_query);
			
			if ($get_gallery && $get_gallery->num_rows() > 0) {
				foreach ($get_gallery->result_array() as $image) {
					$image_path = 'assets/mem/' . $yid . '/gallery/' . $image['gallery_image'];
					
					// Check if file exists
					if (file_exists($image_path)) {
						$image_url = base_url($image_path);
						$images[] = array(
							'gallery_id' => $image['gallery_id'],
							'image_url' => $image_url,
							'image_name' => !empty($image['gallery_original_name']) ? $image['gallery_original_name'] : $image['gallery_image'],
							'created' => $image['gallery_created']
						);
					}
				}
			}
			
			echo json_encode([
				'success' => true,
				'images' => $images
			]);
		} catch (Exception $e) {
			error_log('Gallery images error: ' . $e->getMessage());
			echo json_encode([
				'success' => false,
				'message' => 'Error loading gallery images: ' . $e->getMessage(),
				'images' => []
			]);
		}
	}

	// Collections page - Shows all active collections
	function collections()
	{
		@session_start();
		check_session('2', 'account');
		$data = db_variables();
		$data['seo_title'] = 'Collections - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		// Get user's company ID
		$yid = $_SESSION['yid'];
		$user_comp_id = '';
		$user_query = $this->db->query("SELECT comp_id FROM yn_site_mem WHERE mid = '$yid'");
		if ($user_query && $user_query->num_rows() > 0) {
			$user_data = $user_query->row_array();
			$user_comp_id = isset($user_data['comp_id']) ? $user_data['comp_id'] : '';
		}
		
		// Get all active collections (filtered by user's company)
		$collections_query = "SELECT c.*, comp.comp_name, comp.comp_logo 
			FROM yn_ai_collections c 
			LEFT JOIN yn_ai_companies comp ON c.coll_comp_id = comp.comp_id 
			WHERE c.coll_status='1'";
		
		// Filter by user's company if comp_id exists
		if (!empty($user_comp_id)) {
			$collections_query .= " AND c.coll_comp_id = '$user_comp_id'";
		}
		
		$collections_query .= " ORDER BY c.coll_id DESC";
		
		$get_collections = $this->db->query($collections_query);
		$data['collections'] = array();
		if ($get_collections && $get_collections->num_rows() > 0) {
			$data['collections'] = $get_collections->result_array();
		}

		$this->load->view('inc/_header', $data);
		$this->load->view('collections', $data);
		$this->load->view('inc/_footer', $data);
	}

	// AJAX: Get templates for a collection
	function get_collection_templates()
	{
		@session_start();
		if (!isset($_SESSION['yid']) || $_SESSION['yid'] == '') {
			echo json_encode(['success' => false, 'message' => 'Not logged in']);
			return;
		}
		
		$yid = $_SESSION['yid'];
		$coll_id = $this->input->post('coll_id');
		if (empty($coll_id)) {
			echo json_encode(['success' => false, 'message' => 'Collection ID required']);
			return;
		}
		
		// Get user's company ID
		$user_comp_id = '';
		$user_query = $this->db->query("SELECT comp_id FROM yn_site_mem WHERE mid = '$yid'");
		if ($user_query && $user_query->num_rows() > 0) {
			$user_data = $user_query->row_array();
			$user_comp_id = isset($user_data['comp_id']) ? $user_data['comp_id'] : '';
		}
		
		// Verify collection belongs to user's company
		if (!empty($user_comp_id)) {
			$collection_check = $this->db->query("SELECT coll_id FROM yn_ai_collections WHERE coll_id = '$coll_id' AND coll_comp_id = '$user_comp_id' AND coll_status = '1'");
			if ($collection_check->num_rows() == 0) {
				echo json_encode(['success' => false, 'message' => 'Collection not found or access denied.']);
				return;
			}
		}
		
		// Get templates for this collection
		$templates_query = "SELECT t.*, c.coll_id, c.coll_name 
			FROM yn_ai_templates t 
			LEFT JOIN yn_ai_collections c ON t.temp_coll_id = c.coll_id 
			WHERE t.temp_coll_id = '$coll_id' AND t.temp_status = '1' 
			ORDER BY t.temp_id DESC";
		
		$get_templates = $this->db->query($templates_query);
		$templates = array();
		
		if ($get_templates && $get_templates->num_rows() > 0) {
			foreach ($get_templates->result_array() as $template) {
				$template['temp_image_url'] = '';
				if (!empty($template['temp_image'])) {
					$image_path = 'assets/ai/uploads/templates/' . $template['temp_image'];
					if (file_exists($image_path)) {
						$template['temp_image_url'] = base_url($image_path);
					}
				}
				$templates[] = $template;
			}
		}
		
		echo json_encode([
			'success' => true,
			'templates' => $templates
		]);
	}

	// Collection detail page - shows templates in grid
	function collection_detail($coll_id = null)
	{
		@session_start();
		check_session('2', 'account');
		$data = db_variables();
		
		// Get collection ID from parameter or URI segment
		if (empty($coll_id)) {
			$coll_id = $this->uri->segment(2);
		}
		
		if (empty($coll_id)) {
			redirect(base_url('collections'));
			return;
		}

		// Get user's company ID
		$yid = $_SESSION['yid'];
		$user_comp_id = '';
		$user_query = $this->db->query("SELECT comp_id FROM yn_site_mem WHERE mid = '$yid'");
		if ($user_query && $user_query->num_rows() > 0) {
			$user_data = $user_query->row_array();
			$user_comp_id = isset($user_data['comp_id']) ? $user_data['comp_id'] : '';
		}
		
		// Get collection details (filtered by user's company)
		$collection_query = "SELECT c.*, comp.comp_name, comp.comp_logo 
			FROM yn_ai_collections c 
			LEFT JOIN yn_ai_companies comp ON c.coll_comp_id = comp.comp_id 
			WHERE c.coll_id='$coll_id' AND c.coll_status='1'";
		
		// Filter by user's company if comp_id exists
		if (!empty($user_comp_id)) {
			$collection_query .= " AND c.coll_comp_id = '$user_comp_id'";
		}
		
		$get_collection = $this->db->query($collection_query);
		if ($get_collection->num_rows() == 0) {
			redirect(base_url('collections'));
			return;
		}
		
		$collection = $get_collection->row_array();
		$data['collection'] = $collection;

		// Get all templates in this collection
		$templates_query = "SELECT * FROM yn_ai_templates 
			WHERE temp_coll_id='$coll_id' AND temp_status='1' 
			ORDER BY temp_id DESC";
		
		$get_templates = $this->db->query($templates_query);
		$data['templates'] = $get_templates->result_array();
		
		// Get saved template IDs for logged-in user
		$yid = $_SESSION['yid'];
		$data['saved_template_ids'] = array();
		$tables = $this->db->list_tables();
		if (in_array('yn_ai_saved_templates', $tables)) {
			$saved_query = $this->db->query("SELECT save_temp_id FROM yn_ai_saved_templates WHERE save_user_id = '$yid'");
			if ($saved_query && $saved_query->num_rows() > 0) {
				foreach ($saved_query->result_array() as $saved) {
					$data['saved_template_ids'][] = $saved['save_temp_id'];
				}
			}
		}

		$data['seo_title'] = $collection['coll_name'] . ' - Collections - ' . $data['meta_title'];
		$data['seo_description'] = !empty($collection['coll_description']) ? $collection['coll_description'] : $data['meta_desc'];
		$data['seo_image'] = !empty($collection['coll_cover_image']) ? base_url('assets/ai/uploads/collections/' . $collection['coll_cover_image']) : $data['meta_image'];
		$data['meta_array'] = $data;

		$this->load->view('inc/_header', $data);
		$this->load->view('collection-detail', $data);
		$this->load->view('inc/_footer', $data);
	}

	// Image generation page
	function generate_image($temp_id = null)
	{
		@session_start();
		check_session('2', 'account');
		$data = db_variables();
		
		// Get template ID from parameter or URI segment
		if (empty($temp_id)) {
			$temp_id = $this->uri->segment(2);
		}
		
		if (empty($temp_id)) {
			redirect(base_url('collections'));
			return;
		}

		// Get user's company ID
		$yid = $_SESSION['yid'];
		$user_comp_id = '';
		$user_query = $this->db->query("SELECT comp_id FROM yn_site_mem WHERE mid = '$yid'");
		if ($user_query && $user_query->num_rows() > 0) {
			$user_data = $user_query->row_array();
			$user_comp_id = isset($user_data['comp_id']) ? $user_data['comp_id'] : '';
		}
		
		// Get template details with collection info (filtered by user's company)
		$template_query = "SELECT t.*, c.coll_name, c.coll_id, c.coll_description, comp.comp_name, comp.comp_logo 
			FROM yn_ai_templates t 
			LEFT JOIN yn_ai_collections c ON t.temp_coll_id = c.coll_id 
			LEFT JOIN yn_ai_companies comp ON c.coll_comp_id = comp.comp_id 
			WHERE t.temp_id='$temp_id' AND t.temp_status='1'";
		
		// Filter by user's company if comp_id exists
		if (!empty($user_comp_id)) {
			$template_query .= " AND c.coll_comp_id = '$user_comp_id'";
		}
		
		$get_template = $this->db->query($template_query);
		if ($get_template->num_rows() == 0) {
			redirect(base_url('collections'));
			return;
		}
		
		$template = $get_template->row_array();
		$data['template'] = $template;
		
		// Load multiple positions from positions table
		$template_positions = array();
		$tables = $this->db->list_tables();
		if (in_array('yn_ai_template_positions', $tables)) {
			// Check if pos_status column exists
			$columns = $this->db->list_fields('yn_ai_template_positions');
			$status_condition = '';
			if (in_array('pos_status', $columns)) {
				$status_condition = " AND pos_status = '1'";
			}
			
			$temp_id_for_query = intval($template['temp_id']);
			
			// First, try query with status condition
			$positions_query = $this->db->query("SELECT pos_x as x, pos_y as y, pos_width as width, pos_height as height, pos_order FROM yn_ai_template_positions WHERE pos_temp_id = '$temp_id_for_query'" . $status_condition . " ORDER BY pos_order ASC, pos_id ASC");
			
			// Debug: Log the query
			error_log('=== POSITIONS QUERY DEBUG ===');
			error_log('Template ID: ' . $temp_id_for_query);
			error_log('Status condition: ' . ($status_condition ?: 'NONE'));
			error_log('Query executed');
			
			if ($positions_query) {
				$num_rows = $positions_query->num_rows();
				error_log('Query returned ' . $num_rows . ' rows');
				
				if ($num_rows > 0) {
					// Use result_array() to get all rows
					$template_positions = $positions_query->result_array();
					
					// Debug: Log positions count and data
					error_log('Found ' . count($template_positions) . ' positions in result_array()');
					
					// Verify each position and ensure array is properly indexed
					$verified_positions = array();
					foreach ($template_positions as $idx => $pos) {
						$verified_positions[] = array(
							'x' => intval($pos['x']),
							'y' => intval($pos['y']),
							'width' => intval($pos['width']),
							'height' => intval($pos['height']),
							'pos_order' => isset($pos['pos_order']) ? intval($pos['pos_order']) : $idx
						);
						error_log("Position $idx: x=" . $pos['x'] . ", y=" . $pos['y'] . ", width=" . $pos['width'] . ", height=" . $pos['height'] . ", order=" . (isset($pos['pos_order']) ? $pos['pos_order'] : $idx));
					}
					
					$template_positions = $verified_positions;
					error_log('Verified positions count: ' . count($template_positions));
					error_log('Positions data: ' . print_r($template_positions, true));
				} else {
					error_log('Query returned 0 rows');
					// Try without status condition to see if that's the issue
					$test_query = $this->db->query("SELECT pos_x as x, pos_y as y, pos_width as width, pos_height as height, pos_order, pos_status FROM yn_ai_template_positions WHERE pos_temp_id = '$temp_id_for_query' ORDER BY pos_order ASC, pos_id ASC");
					if ($test_query && $test_query->num_rows() > 0) {
						$test_positions = $test_query->result_array();
						error_log('Found ' . count($test_positions) . ' positions WITHOUT status filter');
						error_log('Test positions: ' . print_r($test_positions, true));
						// Use test positions if status filter was the issue
						$template_positions = $test_positions;
					}
				}
			} else {
				$db_error = $this->db->error();
				error_log('Query failed: ' . print_r($db_error, true));
			}
			error_log('Final template_positions count: ' . (isset($template_positions) ? count($template_positions) : 0));
			error_log('===========================');
		}
		$data['template_positions'] = $template_positions;
		
		// Load text fields from text fields table
		$template_text_fields = array();
		if (in_array('yn_ai_template_text_fields', $tables)) {
			$temp_id_for_query = intval($template['temp_id']);
			$text_fields_query = $this->db->query("SELECT * FROM yn_ai_template_text_fields WHERE text_temp_id = '$temp_id_for_query' AND text_status = '1' ORDER BY text_order ASC, text_id ASC");
			
			if ($text_fields_query && $text_fields_query->num_rows() > 0) {
				$template_text_fields = $text_fields_query->result_array();
			}
		}
		$data['template_text_fields'] = $template_text_fields;
		
		// Check if template is saved by user
		$yid = $_SESSION['yid'];
		$data['is_template_saved'] = false;
		if (in_array('yn_ai_saved_templates', $tables)) {
			$check_saved = $this->db->query("SELECT save_id FROM yn_ai_saved_templates WHERE save_user_id = '$yid' AND save_temp_id = '" . $template['temp_id'] . "'");
			$data['is_template_saved'] = ($check_saved && $check_saved->num_rows() > 0);
		}
		
		// Determine template type/category for dynamic fields
		$collection_name = strtolower($template['coll_name'] ?? '');
		$template_name = strtolower($template['temp_name'] ?? '');
		$data['template_type'] = 'generic'; // Default
		
		// Check template type based on collection/template name
		if (strpos($collection_name, 'bike') !== false || strpos($template_name, 'bike') !== false || 
		    strpos($collection_name, 'motorcycle') !== false || strpos($template_name, 'motorcycle') !== false) {
			$data['template_type'] = 'bike';
		} elseif (strpos($collection_name, 'car') !== false || strpos($template_name, 'car') !== false) {
			$data['template_type'] = 'car';
		} elseif (strpos($collection_name, 'achievement') !== false || strpos($template_name, 'achievement') !== false) {
			$data['template_type'] = 'achievement';
		}

		// Get user profile data for pre-filling
		$yid = $_SESSION['yid'];
		$user_data = $this->ynaps_model->getprofile_data('*', $yid);
		$data['user_data'] = $user_data;
		
		// Get user's company name if available
		if (!empty($user_data['comp_id'])) {
			$company_query = $this->db->query("SELECT comp_name FROM yn_ai_companies WHERE comp_id = '" . $user_data['comp_id'] . "'");
			$company = $company_query->row_array();
			if ($company) {
				$data['user_company_name'] = $company['comp_name'];
			}
		}

		$data['seo_title'] = 'Generate Image - ' . $template['temp_name'] . ' - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = !empty($template['temp_image']) ? base_url('assets/ai/uploads/templates/' . $template['temp_image']) : $data['meta_image'];
		$data['meta_array'] = $data;

		$this->load->view('inc/_header', $data);
		$this->load->view('generate-image', $data);
		$this->load->view('inc/_footer', $data);
	}

	function view_checkout()
	{
		@session_start();
		check_session('2', 'account');
		$data = db_variables();
		$data['seo_title'] = 'Order Detail - ' . $data['meta_title'];;
		$data['seo_description'] = $data['meta_title'];;
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['page_name'] = 'Profile';
		$data['meta_array'] = $data;

		$yid = $_SESSION['yid'];
		$themyuser_details = $this->ynaps_model->getprofile_data('*', $_SESSION['yid']);
		$data['profile_data'] = $themyuser_details;

		$yid = $_SESSION['yid'];
		$email = $_SESSION['email'];

		$getall_order = $this->db->query("select * from yn_ecom_order where so_email = '$email' order by so_id desc");
		$all_order = $getall_order->result_array();
		$data['allorders'] = $all_order;


		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section2', $data);
		$this->load->view('view_checkout', $data);
		$this->load->view('inc/_footer', $data);
	}

	function otp_verify()
	{
		// Check if user is logged in but allow unverified users to access OTP verification
		if (!isset($_SESSION['yid']) || $_SESSION['yid'] == '') {
			redirect(base_url('login'));
		}
		
		$data = db_variables();
		$data['seo_title'] = 'OTP Verify - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		// Check if user is already verified
		$thedetails = $this->ynaps_model->getprofile_data('*', $_SESSION['yid']);
		if ($thedetails['user_email_status'] == '1' && $thedetails['user_status'] == '1') {
			redirect(base_url('profile'));
		}
		
		$data['profile_data'] = $thedetails;
		$yid = $_SESSION['yid'];
		$email = $_SESSION['email'];

		// Load standalone OTP verification page (no main header/footer)
		$this->load->view('otp_verify', $data);
	}

	function test_otp()
	{
		// Simple test function to check if OTP verification page loads
		echo "OTP verification page test - OK";
		echo "<br>Session YID: " . (isset($_SESSION['yid']) ? $_SESSION['yid'] : 'Not set');
		echo "<br>OTP Required: " . (isset($_SESSION['otp_required']) ? $_SESSION['otp_required'] : 'Not set');
		echo "<br>Signup Code Email: " . (isset($_SESSION['signup_code_email']) ? $_SESSION['signup_code_email'] : 'Not set');
	}

	function edit($data_pass = null)
	{
		$data = db_variables();
		$data['seo_title'] = 'Edit - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_title'];
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['page_name'] = 'Edit';
		$data['meta_array'] = $data;

		$themyuser_details = $this->ynaps_model->getprofile_data('*', $_SESSION['yid']);
		$data['profile_data'] = $themyuser_details;



		check_session('2', 'account');
		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section2', $data);
		$this->load->view('edit', $data);
		$this->load->view('inc/_footer', $data);
	}

	function verify()
	{
		$data = db_variables();
		$data['seo_title'] = $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		$data['profile_data'] = $this->ynaps_model->getprofile_data('*', $_SESSION['yid']);


		check_session('2', 'account');
		$this->load->view('inc/_header', $data);
		$this->load->view('verify', $data);
		$this->load->view('inc/_footer', $data);
	}

	function logout()
	{
		$user_data = $this->session->all_userdata();
		foreach ($user_data as $key => $value) {
			if ($key != 'session_id' && $key != 'ip_address' && $key != 'user_agent' && $key != 'last_activity') {
				$this->session->unset_userdata($key);
			}
		}
		$this->session->sess_destroy();
		redirect(base_url());
	}


	function blog()
	{
		// if (check_service_status('1', '2', 'bl') != '1') {
		// 	redirect('error-404?e=this feature is not enabled.');
		// }

		$data = db_variables();
		$data['seo_title'] = 'Blogs - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['page_name'] = 'YNAPS';
		$data['meta_array'] = $data;

		$type = @$_GET['type'];
		$search = @$_GET['q'];
		$tag = @$_GET['tag'];

		// Build WHERE clause based on filters
		$where_conditions = array();
		$where_clause = "";

		if (!empty($type)) {
			$where_conditions[] = "blog_type = '$type'";
		}

		if (!empty($search)) {
			$search = clean($search);
			$where_conditions[] = "(title LIKE '%$search%' OR comment LIKE '%$search%')";
		}

		if (!empty($tag)) {
			$tag = clean($tag);
			$where_conditions[] = "tags LIKE '%$tag%'";
		}

		if (!empty($where_conditions)) {
			$where_clause = "WHERE " . implode(" AND ", $where_conditions);
		}

		// Get total count for pagination
		$count_query = "SELECT COUNT(*) as total FROM yn_site_blogs $where_clause";
		$total_result = $this->db->query($count_query)->row_array();
		$total_num = $total_result['total'];

		$rec_per_page = '9';
		$this->load->library('pagination');
		$config['base_url'] = base_url('blog');
		$config['total_rows'] = $total_num;
		$config['per_page'] = $rec_per_page;
		$config['num_links'] = 3;
		$config['use_page_numbers'] = TRUE;
		$config['full_tag_open'] = '<ul class="pagination justify-content-center mb-10 pb-2 pt-2">';
		$config['full_tag_close'] = '</ul>';
		$config['first_link'] = '<i class="w-icon-long-arrow-left"></i>First';
		$config['last_link'] = 'Last<i class="w-icon-long-arrow-right"></i>';
		$config['next_link'] = 'Next<i class="w-icon-long-arrow-right"></i>';
		$config['prev_link'] = '<i class="w-icon-long-arrow-left"></i>Prev';
		$config['cur_tag_open'] = '<li class="page-item active"><a class="page-link" href="#">';
		$config['cur_tag_close'] = '</a></li>';
		$config['num_tag_open'] = '<li class="page-item">';
		$config['num_tag_close'] = '</li>';
		$config['anchor_class'] = 'page-link';
		$config['reuse_query_string'] = true;
		$config['page_query_string'] = TRUE;
		$config['query_string_segment'] = 'page';
		$this->pagination->initialize($config);

		@$page = $_GET['page'];
		if (isset($_GET['page'])) {
			$page = $page - 1;
		}
		$limit1 = $page * $rec_per_page;

		// Get blogs with filters and pagination
		$blogs_query = "SELECT * FROM yn_site_blogs $where_clause ORDER BY blog_id DESC LIMIT $limit1, $rec_per_page";
		$geththeblogs = $this->db->query($blogs_query);
		$all_blogs = $geththeblogs->result_array();
		$data['blogs'] = $all_blogs;
		$data['pagination'] = $this->pagination->create_links();

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('blog', $data);
		$this->load->view('inc/_footer', $data);
	}
	function theBlog($slug)
	{


		// if (check_service_status('1', '2', 'bl') != '1') {
		// 	redirect('error-404?e=this feature is not enabled.');
		// }

		count_view('bl', 'un');

		$data = db_variables();
		$config['base_url'] = base_url('blog');

		$geththeblog = $this->db->query("select * from yn_site_blogs where slug='$slug'");
		$theBlog = $geththeblog->row_array();
		$data['blog_rea'] = $theBlog;

		if (empty($theBlog)) {
			redirect(base_url('error-404?e=no blog found.'));
		}

		$data['seo_title'] = $theBlog['title'];
		$data['seo_description'] = trim_text(strip_tags($theBlog['comment']), 200);
		if ($theBlog['blog_img'] != '')
			$data['seo_image'] = base_url('assets/avator/upload/') . $theBlog['blog_img'];
		else
			$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['page_name'] = 'YNAPS';
		$data['meta_array'] = $data;

		// Get related blogs (exclude current blog)
		$geththeblogs = $this->db->query("SELECT * FROM yn_site_blogs WHERE blog_id != '{$theBlog['blog_id']}' ORDER BY blog_id DESC LIMIT 10");
		$all_blogs = $geththeblogs->result_array();
		$data['show_blogs'] = $all_blogs;


		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('theBlog', $data);
		$this->load->view('inc/_footer', $data);
	}

	function setcurrency()
	{
		$cur = xss_clean($_GET['c']);
		switch ($cur) {
			case 'USD':
			case 'INR':
				$_SESSION['currency'] = $cur;
				break;
			default:
				$_SESSION['currency'] = $cur;
				break;
		}
	}


	function teacher_selection()
	{
		@session_start();
		
		// Get topic details from URL parameters
		$topic_id = $this->input->get('topic');
		$topic_name = $this->input->get('name');
		$topic_price = $this->input->get('price');

		if (empty($topic_id) || empty($topic_name) || empty($topic_price)) {
			redirect(base_url());
			return;
		}

		$data = db_variables();
		$data['seo_title'] = 'Select Teacher - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		// Get topic details from database
		$topic_query = "SELECT p.*, 
			c.name as category_name,
			sc.sc_name as subcategory_name,
			ssc.mr_sub2_name as sub_subcategory_name,
			sssc.mr_sub3_name as sub_sub_subcategory_name
		FROM yn_ecom_products p
		LEFT JOIN yn_site_catagory c ON p.p_category = c.ctid
		LEFT JOIN yn_site_sub_cat sc ON p.p_sub_category = sc.sc_id
		LEFT JOIN yn_site_sub2_cat ssc ON p.p_sub_sub_cat = ssc.mr_sub2_id
		LEFT JOIN yn_site_sub3_cat sssc ON p.p_sub_sub_sub_cat = sssc.mr_sub3_id
		WHERE p.p_id = '$topic_id' LIMIT 1";
		
		$topic_data = $this->db->query($topic_query)->row_array();
		
		if (empty($topic_data)) {
			redirect(base_url());
			return;
		}

		// Get teachers for this topic's category hierarchy (only those with videos)
		$teachers_query = "SELECT m.*, 
			c.name as category_name,
			sc.sc_name as subcategory_name,
			ssc.mr_sub2_name as sub_subcategory_name,
			COALESCE(m.teacher_education, m.user_education) as education,
			m.teacher_experience as experience,
			m.about as bio
		FROM yn_site_mem m
		LEFT JOIN yn_site_catagory c ON m.category_id = c.ctid
		LEFT JOIN yn_site_sub_cat sc ON m.subcategory_id = sc.sc_id
		LEFT JOIN yn_site_sub2_cat ssc ON m.sub_subcategory_id = ssc.mr_sub2_id
		WHERE m.user_type = 'teacher' 
		AND m.category_id = '{$topic_data['p_category']}'
		AND m.teacher_intro_video IS NOT NULL 
		AND m.teacher_intro_video != ''
		ORDER BY m.mid DESC";
		
		$teachers = $this->db->query($teachers_query)->result_array();

		$data['topic_data'] = $topic_data;
		$data['topic_id'] = $topic_id;
		$data['topic_name'] = $topic_name;
		$data['topic_price'] = $topic_price;
		$data['teachers'] = $teachers;

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('teacher_selection', $data);
		$this->load->view('inc/_footer', $data);
	}
	
	function teacher_videos()
	{
		@session_start();
		
		// Check if user is logged in and is a teacher
		if (!isset($_SESSION['yid']) || $_SESSION['user_type'] != 'teacher') {
			redirect(base_url('login'));
			return;
		}
		
		$data = db_variables();
		$data['seo_title'] = 'Upload Subject Videos - ' . $data['meta_title'];
		$data['seo_description'] = 'Upload videos for each subject you teach';
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;
		
		// Get teacher's subjects with video status
		$teacher_id = $_SESSION['yid'];
		
		// Check if the teacher_subject_videos table exists
		$table_check = $this->db->query("SHOW TABLES LIKE 'yn_teacher_subject_videos'");
		
		if ($table_check->num_rows() > 0) {
			$query = "
				SELECT 
					s.mr_sub2_id as subject_id,
					s.mr_sub2_name as subject_name,
					v.video_filename,
					v.video_title,
					v.video_description,
					v.upload_date,
					CASE WHEN v.id IS NOT NULL THEN 1 ELSE 0 END as has_video
				FROM yn_site_mem m
				LEFT JOIN yn_site_sub2_cat s ON FIND_IN_SET(s.mr_sub2_id, m.sub_subcategory_id)
				LEFT JOIN yn_teacher_subject_videos v ON v.teacher_id = m.mid AND v.subject_id = s.mr_sub2_id AND v.status = 'active'
				WHERE m.mid = '$teacher_id' AND m.user_type = 'teacher'
				ORDER BY s.mr_sub2_name ASC
			";
		} else {
			// Fallback query without video table
			$query = "
				SELECT 
					s.mr_sub2_id as subject_id,
					s.mr_sub2_name as subject_name,
					NULL as video_filename,
					NULL as video_title,
					NULL as video_description,
					NULL as upload_date,
					0 as has_video
				FROM yn_site_mem m
				LEFT JOIN yn_site_sub2_cat s ON FIND_IN_SET(s.mr_sub2_id, m.sub_subcategory_id)
				WHERE m.mid = '$teacher_id' AND m.user_type = 'teacher'
				ORDER BY s.mr_sub2_name ASC
			";
		}
		
		$subjects = $this->db->query($query)->result_array();
		$data['subjects'] = $subjects;
		
		// Check if all subjects have videos
		$total_subjects = count($subjects);
		$subjects_with_videos = count(array_filter($subjects, function($subject) {
			return $subject['has_video'] == 1;
		}));
		$data['all_videos_uploaded'] = ($total_subjects > 0 && $total_subjects == $subjects_with_videos);
		$data['total_subjects'] = $total_subjects;
		$data['subjects_with_videos'] = $subjects_with_videos;
		
		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('teacher_videos', $data);
		$this->load->view('inc/_footer', $data);
	}

	function pay_now()
	{
		@session_start();
		
		// Get topic details from URL parameters if available
		$topic_id = $this->input->get('topic_id') ?: $this->input->get('topic');
		$topic_name = $this->input->get('topic_name') ?: $this->input->get('name');
		$topic_price = $this->input->get('topic_price') ?: $this->input->get('price');
		$selected_teacher_id = $this->input->get('teacher');
		
		// Debug: Log received parameters
		error_log("Pay Now Debug - Topic ID: $topic_id, Topic Name: $topic_name, Topic Price: $topic_price, Teacher ID: $selected_teacher_id");
		
		$cid = $_SESSION['ecom_order_id'];
		
		// Generate order ID if not exists
		if (empty($cid)) {
			$cid = 'ORD' . date('Ymd') . rand(1000, 9999);
			$_SESSION['ecom_order_id'] = $cid;
		}
		
		// Store redirect URL for after login - use redirect parameter if provided, otherwise current URL
		$redirect_url = $this->input->get('redirect');
		if (!empty($redirect_url)) {
			$_SESSION['redirect_after_login'] = $redirect_url;
		} else {
			$_SESSION['redirect_after_login'] = current_url();
		}
		check_session('2', 'account');

		$data = db_variables();
		$data['seo_title'] = 'Pay Now - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		@$yid = $_SESSION['yid'];
		
		// Check if user is logged in
		if (empty($yid) || $yid <= 0) {
			// Redirect to login with current URL as redirect parameter
			$current_url = current_url();
			redirect(base_url('login?redirect=' . urlencode($current_url)));
		}
		
		$thedetails = $this->ynaps_model->getprofile_data('*', $yid);
		$data['profile_data'] = $thedetails;
		
		// Validate profile data
		if (empty($thedetails['name']) || empty($thedetails['email']) || (empty($thedetails['phone']) && empty($thedetails['contact']))) {
			// Redirect to profile completion if required data is missing
			redirect(base_url('profile?msg=complete_profile'));
		}

		// Get the order from database (should already exist from checkout2 function)
		$getListing = $this->db->query("SELECT * FROM `yn_ecom_order` where so_order_id='$cid'");
		$data['theorder'] = $getListing->row_array();
		
		// If we have topic details from URL but no order exists, create the order
		if ($topic_id && $topic_name && $topic_price && empty($data['theorder'])) {
			// Create order in database
			$user = $this->ynaps_model->getprofile_data('*', $yid);
			$name = $user['name'];
			$email = $user['email'];
			$phone = $user['phone'] ?: $user['contact']; // Use phone field first, fallback to contact

			$order_data = array(
				'so_order_id' => $cid,
				'so_mid' => $yid,
				'so_name' => $name,
				'so_email' => $email,
				'so_phone' => $phone,
				'so_price' => $topic_price,
				'so_status' => 0,
				'or_pay_status' => 0,
				'so_date' => date('Y-m-d H:i:s'), // Add current date and time
			);

			$this->db->insert('yn_ecom_order', $order_data);

			// Insert Topic Details with Teacher ID
			$this->db->query("INSERT INTO yn_ecom_orders_detail (`checkout_order_id`,`xod_pid`,`xod_name`,`xod_image1`,`xod_price`,`xod_qty`,`teacher_id`) VALUES ('$cid','$topic_id','$topic_name','','$topic_price','1','$selected_teacher_id')");

			// Refresh the order data
			$getListing = $this->db->query("SELECT * FROM `yn_ecom_order` where so_order_id='$cid'");
			$data['theorder'] = $getListing->row_array();
		}
		
		// If we have topic details from URL, use them for display
		if ($topic_id && $topic_name && $topic_price) {
			$data['topic_id'] = $topic_id;
			$data['topic_name'] = $topic_name;
			$data['topic_price'] = $topic_price;
			
			// Get topic details with category hierarchy for teacher matching
			$topic_query = "SELECT p.*, 
				c.name as category_name,
				sc.sc_name as subcategory_name,
				ssc.mr_sub2_name as sub_subcategory_name,
				sssc.mr_sub3_name as sub_sub_subcategory_name
			FROM yn_ecom_products p
			LEFT JOIN yn_site_catagory c ON p.p_category = c.ctid
			LEFT JOIN yn_site_sub_cat sc ON p.p_sub_category = sc.sc_id
			LEFT JOIN yn_site_sub2_cat ssc ON p.p_sub_sub_cat = ssc.mr_sub2_id
			LEFT JOIN yn_site_sub3_cat sssc ON p.p_sub_sub_sub_cat = sssc.mr_sub3_id
			WHERE p.p_id = '$topic_id' LIMIT 1";
			
			$topic_data = $this->db->query($topic_query)->row_array();
			$data['topic_data'] = $topic_data;
			
			// Get selected teacher details if teacher ID is provided
			if ($selected_teacher_id) {
				// First, let's check what user_type the teacher actually has
				$check_teacher = $this->db->query("SELECT mid, firstname, lastname, user_type FROM yn_site_mem WHERE mid = '$selected_teacher_id'")->row_array();
				
				$teacher_query = "SELECT m.*, 
					c.name as category_name,
					sc.sc_name as subcategory_name,
					ssc.mr_sub2_name as sub_subcategory_name
				FROM yn_site_mem m
				LEFT JOIN yn_site_catagory c ON m.category_id = c.ctid
				LEFT JOIN yn_site_sub_cat sc ON m.subcategory_id = sc.sc_id
				LEFT JOIN yn_site_sub2_cat ssc ON m.sub_subcategory_id = ssc.mr_sub2_id
				WHERE m.mid = '$selected_teacher_id'";
				
				$selected_teacher = $this->db->query($teacher_query)->row_array();
				$data['selected_teacher'] = $selected_teacher;
				$data['selected_teacher_id'] = $selected_teacher_id;
				
				// Debug: Log teacher info
				error_log("Teacher Debug - ID: $selected_teacher_id, Found: " . ($selected_teacher ? 'Yes' : 'No'));
				if ($selected_teacher) {
					error_log("Teacher Debug - Name: " . $selected_teacher['firstname'] . " " . $selected_teacher['lastname']);
				}
			} else {
				$data['selected_teacher'] = null;
				$data['selected_teacher_id'] = null;
			}
			
			// No need for multiple teachers on payment page - only show selected teacher
			$data['teachers'] = array();
			$data['current_teacher_index'] = 0;
			
		} else {
			$getListing = $this->db->query("SELECT * FROM `yn_ecom_order` where so_order_id='$cid'");
			$data['theorder'] = $getListing->row_array();
			$data['teachers'] = array();
			$data['current_teacher_index'] = 0;
		}
		// if (empty($data['theorder'])) {
		// 	redirect(base_url('profile'));
		// }

		$data['cid'] = $cid;
		$data['order_id'] = $cid; // Also pass as order_id for clarity

		$this->load->view('inc/_header', $data);
		// $this->load->view('inc/section', $data);
		$this->load->view('pay_now.php', $data);
		$this->load->view('inc/_footer', $data);
	}

	function thank_you()
	{
		// @session_start();
		// check_session('2', 'account');
		$data = db_variables();
		$data['seo_title'] = 'Thank You - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;
		
		$get_banner1 = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='bthank' AND img_status='1' ORDER BY img_id DESC LIMIT 1");
		$thebanner1 = $get_banner1->row_array();
		$data['breadcrumb'] = $thebanner1;


		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('thank_you.php', $data);
		$this->load->view('inc/_footer', $data);
	}

	function payment_failed()
	{
		// @session_start();
		// check_session('2', 'account');
		$data = db_variables();
		$data['seo_title'] = 'Payment Failed - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;
		$_SESSION['ecom_order_id'] = 1231231231;

		if (isset($_SESSION['ecom_order_id'])) {
			unset($_SESSION['ecom_order_id']);
			unset($_SESSION['ecom_cart']);
		}


		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('payment_failed', $data);
		$this->load->view('inc/_footer', $data);
	}

	function sub($category_name = '', $category_id = 0){
		@session_start();
		$data = db_variables();
		
		// Get category details
		$category = $this->db->query("SELECT * FROM yn_site_catagory WHERE ctid = '$category_id'")->row_array();
		
		if (!$category) {
			// If category not found, redirect to home
			redirect(base_url());
		}
		
		// Get subcategories for this category
		$subcategories = $this->db->query("SELECT * FROM yn_site_sub_cat WHERE sc_ctid = '$category_id' ORDER BY sc_sort ASC")->result_array();
		
		$data['category'] = $category;
		$data['subcategories'] = $subcategories;
		$data['seo_title'] = $category['name'] . ' - ' . $data['meta_title'];
		$data['seo_description'] = 'Explore ' . $category['name'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $category['name'] . ', subcategories';
		$data['meta_array'] = $data;

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('sub', $data);
		$this->load->view('inc/_footer', $data);
	}

	function sub_sub($subcategory_name = '', $subcategory_id = 0){
		@session_start();
		$data = db_variables();
		
		// Get subcategory details
		$subcategory = $this->db->query("SELECT * FROM yn_site_sub_cat WHERE sc_id = '$subcategory_id'")->row_array();
		
		if (!$subcategory) {
			// If subcategory not found, redirect to home
			redirect(base_url());
		}
		
		// Get category details for breadcrumb
		$category = $this->db->query("SELECT * FROM yn_site_catagory WHERE ctid = '{$subcategory['sc_ctid']}'")->row_array();
		
		// Pagination setup - 3 items per page
		$rec_per_page = 6;
		$this->load->library('pagination');
		$config['base_url'] = base_url('sub-sub/' . $subcategory_name . '/' . $subcategory_id);
		$config['total_rows'] = $this->db->query("SELECT COUNT(*) as total FROM yn_site_sub2_cat WHERE mr_sub2_sid = '$subcategory_id'")->row()->total;
		$config['per_page'] = $rec_per_page;
		$config['num_links'] = 3;
		$config['use_page_numbers'] = TRUE;
		$config['full_tag_open'] = '<ul class="list-wrap">';
		$config['full_tag_close'] = '</ul>';
		$config['first_link'] = FALSE;
		$config['last_link'] = FALSE;
		$config['next_link'] = FALSE;
		$config['prev_link'] = FALSE;
		$config['cur_tag_open'] = '<li class="active"><a href="#">';
		$config['cur_tag_close'] = '</a></li>';
		$config['num_tag_open'] = '<li>';
		$config['num_tag_close'] = '</li>';
		$config['anchor_class'] = '';
		$config['page_query_string'] = TRUE;
		$config['query_string_segment'] = 'page';
		$config['reuse_query_string'] = TRUE;
		$this->pagination->initialize($config);

		@$page = $_GET['page'];
		if (isset($_GET['page'])) {
			$page = $page - 1;
		} else {
			$page = 0;
		}
		$limit1 = $page * $rec_per_page;
		
		// Get sub-subcategories for this subcategory with pagination
		$sub_subcategories = $this->db->query("SELECT * FROM yn_site_sub2_cat WHERE mr_sub2_sid = '$subcategory_id' ORDER BY mr_sub2_sort ASC LIMIT $limit1, $rec_per_page")->result_array();
		
		$data['category'] = $category;
		$data['subcategory'] = $subcategory;
		$data['sub_subcategories'] = $sub_subcategories;
		$data['pagination'] = $this->pagination->create_links();
		$data['seo_title'] = $subcategory['sc_name'] . ' - ' . $data['meta_title'];
		$data['seo_description'] = 'Explore ' . $subcategory['sc_name'] . ' subjects and specializations';
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $subcategory['sc_name'] . ', subjects, specializations';
		$data['meta_array'] = $data;

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('sub-sub', $data);
		$this->load->view('inc/_footer', $data);
	}

	function sub_sub_sub($sub_sub_subcategory_name = '', $sub_sub_subcategory_id = 0){
		@session_start();
		$data = db_variables();
		
		// Get sub-sub-subcategory details
		$sub_sub_subcategory = $this->db->query("SELECT * FROM yn_site_sub3_cat WHERE mr_sub3_id = '$sub_sub_subcategory_id'")->row_array();
		
		if (!$sub_sub_subcategory) {
			// If sub-sub-subcategory not found, redirect to home
			redirect(base_url());
		}
		
		// Get sub-subcategory details for breadcrumb
		$sub_subcategory = $this->db->query("SELECT * FROM yn_site_sub2_cat WHERE mr_sub2_id = '{$sub_sub_subcategory['mr_sub3_sid']}'")->row_array();
		
		// Get subcategory details for breadcrumb
		$subcategory = $this->db->query("SELECT * FROM yn_site_sub_cat WHERE sc_id = '{$sub_subcategory['mr_sub2_sid']}'")->row_array();
		
		// Get category details for breadcrumb
		$category = $this->db->query("SELECT * FROM yn_site_catagory WHERE ctid = '{$sub_subcategory['mr_sub2_cid']}'")->row_array();
		
		// Get topics/products for this sub-sub-sub category (including custom topics)
		$topics = $this->db->query("
			SELECT p.*, 
				   c.name as category_name,
				   sc.sc_name as subcategory_name,
				   ssc.mr_sub2_name as sub_subcategory_name,
				   sssc.mr_sub3_name as sub_sub_subcategory_name,
				   t.name as teacher_name,
				   t.photo as teacher_photo,
				   CASE 
					   WHEN p.p_sku LIKE 'CUSTOM_%' THEN 1 
					   ELSE 0 
				   END as is_custom_topic
			FROM yn_ecom_products p
			LEFT JOIN yn_site_catagory c ON p.p_category = c.ctid
			LEFT JOIN yn_site_sub_cat sc ON p.p_sub_category = sc.sc_id
			LEFT JOIN yn_site_sub2_cat ssc ON p.p_sub_sub_cat = ssc.mr_sub2_id
			LEFT JOIN yn_site_sub3_cat sssc ON p.p_sub_sub_sub_cat = sssc.mr_sub3_id
			LEFT JOIN yn_site_mem t ON p.p_vendor = t.mid
			WHERE p.p_sub_sub_sub_cat = '$sub_sub_subcategory_id'
			ORDER BY p.p_id DESC
		")->result_array();
		
		$data['category'] = $category;
		$data['subcategory'] = $subcategory;
		$data['sub_subcategory'] = $sub_subcategory;
		$data['sub_sub_subcategory'] = $sub_sub_subcategory;
		$data['topics'] = $topics;
		
		// Create hierarchy array for breadcrumb display
		$data['hierarchy'] = array(
			'category_name' => $category['name'] ?? 'Category',
			'category_id' => $category['ctid'] ?? '',
			'subcategory_name' => $subcategory['sc_name'] ?? 'Specialization',
			'subcategory_id' => $subcategory['sc_id'] ?? '',
			'sub_subcategory_name' => $sub_subcategory['mr_sub2_name'] ?? 'Subject',
			'sub_sub_subcategory_name' => $sub_sub_subcategory['mr_sub3_name'] ?? 'Unit'
		);
		$data['seo_title'] = $sub_sub_subcategory['mr_sub3_name'] . ' - ' . $data['meta_title'];
		$data['seo_description'] = 'Explore ' . $sub_sub_subcategory['mr_sub3_name'] . ' topics and specializations';
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $sub_subcategory['mr_sub2_name'] . ', specializations, topics';
		$data['meta_array'] = $data;

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('sub-sub-sub', $data);
		$this->load->view('inc/_footer', $data);
	}

	function search()
	{
		$data = db_variables();
		$data['seo_title'] = $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;


		$conditions = array();

		@$q = $_GET['q'];
		@$cat = $_GET['cat'];
		@$price = clean($_GET['price']);
		@$rating = clean($_GET['rating']);

		if ($price != '') {
			$conditions[] = "p_price = ('$price') ";
		}

		if ($cat != '') {
			$cat = "'" . str_replace(",", "','", $cat) . "'";
			$conditions[] = "p_category IN ($cat) ";
		}

		if ($q != '') {
			$conditions[] = "(p_name like '%$q%' OR p_descp like '%$q%' OR p_model like '%$q%' )";
		}

		if ($rating != '') {
			$rating = "'" . str_replace(",", "','", $rating) . "'";
			$conditions[] = "p_weight IN ($rating) ";
		}

		$sql_filter = "p_vendor IS NOT NULL AND p_vendor != ''";
		if (count(@$conditions) > 0) {
			$sql_filter .= ' AND ' . implode(' AND ', @$conditions);
		}


		$allcourses = $this->db->query("select * from yn_ecom_products where p_vendor IS NOT NULL AND p_vendor != '' and $sql_filter order by p_id desc");

		$total_num = $allcourses->num_rows();
		$data['total_num'] = $total_num;
		$rec_per_page = '20';
		$this->load->library('pagination');
		$config['base_url'] = base_url('search');
		$config['total_rows'] = $total_num;
		$config['per_page'] = $rec_per_page;
		$config['num_links'] = 10;
		$config['use_page_numbers'] = TRUE;
		$config['full_tag_open'] = "";
		$config['full_tag_close'] = '';
		$config['reuse_query_string'] = true;
		$config['page_query_string'] = TRUE;
		$config['query_string_segment'] = 'page';
		$this->pagination->initialize($config);

		@$page = $_GET['page'];
		if (isset($_GET['page'])) {
			$page = $page - 1;
		}
		$limit1 = $page * $rec_per_page;

		//echo "select * from yn_ecom_products where $sql_filter order by p_id desc  limit 10";die;
		$allcourses = $this->db->query("select * from yn_ecom_products where $sql_filter order by p_id desc  limit $limit1,$rec_per_page");
		$show_courses = $allcourses->result_array();
		$data['show_courses'] = $show_courses;

		$this->load->view('inc/_header', $data);
		$this->load->view('search', $data);
		$this->load->view('inc/_footer', $data);
		//unset($_SESSION['filters']);
	}


	function auto_search($course)
	{
		$q = $this->input->post('search');
		switch ($course) {
			case 'course':

				$geththecourses = $this->db->query("select * from yn_ecom_products where ( (p_name like '%$q%') and p_vendor IS NOT NULL AND p_vendor != '') limit 8");
				// select * from yn_ecom_products where p_vendor IS NOT NULL AND p_vendor != '' order by p_id desc  limit 10
				// echo "select * from yn_ecom_products where ( (p_name like '%$q%') and p_vendor IS NOT NULL AND p_vendor != '') limit 8"; die;

				$thedetails_course = $geththecourses->result_array();
				foreach ($thedetails_course as $courses) { ?>
					<div class="col-12 py-2">
						<a href="<?= base_url('product/') ?><?= $courses['p_id'] ?>/<?= url_smart($courses['p_name']) ?>"><b><?= $courses['p_name'] ?></b></a>
					</div>
				<?php }
				break;
				case 'product':
				$getproducts = $this->db->query("select * from yn_ecom_products where (p_name like '%$q%') limit 8");
				$allproducts = $getproducts->result_array();
				
				if (count($allproducts) > 0) {
					foreach ($allproducts as $pro) { ?>
						<div class="product">
							<figure class="product-media">
								<a href="<?= base_url('product/'.$pro['p_id'].'/'.url_smart($pro['p_name'])) ?>">
									<img src="<?= !empty($pro['p_image1']) ? base_url('assets/avator/upload/') . $pro['p_image1'] : base_url('assets/theme/v2/assets/images/products/default/1-800x900.jpg') ?>"
										alt="<?= htmlspecialchars($pro['p_name']) ?>"
										width="60" height="60" style="object-fit:cover;" />
								</a>
							</figure>
							<div class="product-details">
								<h4 class="product-name">
									<a href="<?= base_url('product/'.$pro['p_id'].'/'.url_smart($pro['p_name'])) ?>">
										<?= htmlspecialchars($pro['p_name']) ?>
									</a>
								</h4>
								<div class="product-price">
									₹<?= number_format($pro['p_price'], 2) ?>
								</div>
								<?php if (!empty($pro['p_model'])) { ?>
								<div class="product-info">
									Model: <?= htmlspecialchars($pro['p_model']) ?>
								</div>
								<?php } ?>
							</div>
						</div>
					<?php }
				} else { ?>
					<div class="no-results">
						No products found for "<?= htmlspecialchars($q) ?>"
					</div>
				<?php }
				break;
			default:
				$getproducts = $this->db->query("select * from rm_post,site_mem where (rmp_status !='0' and rmp_user=mid) and (rmp_title like '%$q%' or rmp_cat_name like '%$q%' or name like '%$q%') limit 5");
				$allproducts = $getproducts->result_array();
				foreach ($allproducts as $pro) { ?>
					<a href="<?= base_url('article') ?>?id=<?= $pro['rmp_id'] ?>" class='no_link_90 col-12'>
						<div class="list_details">
							<?= $pro['rmp_title'] ?></b> in <?= $pro['rmp_cat_name'] ?>
						</div>
					</a>
<?php }
				break;
		}
	}

	function category()
	{
		if (check_service_status('1', '2', 'eco') != '1') {
			redirect('error-404?e=this feature is not enabled.');
		}

		$data = db_variables();
		

		// Initialize filter variables
		$data['active_filters'] = array();
		$data['seo_title'] = 'Category - ' . $data['meta_title'];

		// Base query - only products with p_vendor not empty
		$base_where = "WHERE p_vendor IS NOT NULL AND p_vendor != ''";
		$count_where = "WHERE p_vendor IS NOT NULL AND p_vendor != ''";

		// Handle brand filter
		if (isset($_GET['brand']) && !empty($_GET['brand'])) {
			$brand_id = $_GET['brand'];
			$base_where .= " AND p_brand_name = '$brand_id'";
			$count_where .= " AND p_brand_name = '$brand_id'";
			
			// Get brand name for display
			$brand_info = $this->db->query("SELECT stg_name FROM yn_site_tags WHERE stg_tgid = '$brand_id' AND stg_type = 'Brands'")->row_array();
			$brand_name = $brand_info ? $brand_info['stg_name'] : 'Brand';
			$data['active_filters']['brand'] = array(
				'type' => 'brand',
				'name' => $brand_name,
				'value' => $brand_id,
				'display' => 'Brand: ' . $brand_name
			);
			$data['seo_title'] = $brand_name . ' Products - ' . $data['meta_title'];
		}

		// Handle category filter
		if (isset($_GET['cat']) && !empty($_GET['cat'])) {
			$cat_id = $_GET['cat'];
			$base_where .= " AND p_category = '$cat_id'";
			$count_where .= " AND p_category = '$cat_id'";
			
			// Get category name for display
			$cat_info = $this->db->query("SELECT name FROM yn_site_catagory WHERE ctid = '$cat_id'")->row_array();
			$cat_name = $cat_info ? $cat_info['name'] : 'Category';
			$data['active_filters']['category'] = array(
				'type' => 'category',
				'name' => $cat_name,
				'value' => $cat_id,
				'display' => 'Category: ' . $cat_name
			);
			if (!isset($data['active_filters']['brand'])) {
				$data['seo_title'] = $cat_name . ' - ' . $data['meta_title'];
			}
		}

		// Handle subcategory filter
		if (isset($_GET['subcat']) && !empty($_GET['subcat'])) {
			$subcat_id = $_GET['subcat'];
			$base_where .= " AND p_sub_category = '$subcat_id'";
			$count_where .= " AND p_sub_category = '$subcat_id'";
			
			// Get subcategory name for display
			$subcat_info = $this->db->query("SELECT sc_name FROM yn_site_sub_cat WHERE sc_id = '$subcat_id'")->row_array();
			$subcat_name = $subcat_info ? $subcat_info['sc_name'] : 'Subcategory';
			$data['active_filters']['subcategory'] = array(
				'type' => 'subcategory',
				'name' => $subcat_name,
				'value' => $subcat_id,
				'display' => 'Subcategory: ' . $subcat_name
			);
			if (!isset($data['active_filters']['brand']) && !isset($data['active_filters']['category'])) {
				$data['seo_title'] = $subcat_name . ' - ' . $data['meta_title'];
			}
		}

		// Handle product filter
		if (isset($_GET['product']) && !empty($_GET['product'])) {
			$product_id = $_GET['product'];
			$base_where .= " AND p_id = '$product_id'";
			$count_where .= " AND p_id = '$product_id'";
			
			// Get product name for display
			$product_info = $this->db->query("SELECT p_name FROM yn_ecom_products WHERE p_id = '$product_id'")->row_array();
			$product_name = $product_info ? $product_info['p_name'] : 'Product';
			$data['active_filters']['product'] = array(
				'type' => 'product',
				'name' => $product_name,
				'value' => $product_id,
				'display' => 'Product: ' . $product_name
			);
			$data['seo_title'] = $product_name . ' - ' . $data['meta_title'];
		}

		// Handle search filter
		if (isset($_GET['q']) && !empty($_GET['q'])) {
			$search_term = $_GET['q'];
			$base_where .= " AND p_name LIKE '%$search_term%'";
			$count_where .= " AND p_name LIKE '%$search_term%'";
			
			$data['active_filters']['search'] = array(
				'type' => 'search',
				'name' => $search_term,
				'value' => $search_term,
				'display' => 'Search: ' . $search_term
			);
			if (count($data['active_filters']) == 1) {
				$data['seo_title'] = 'Search Results for "' . $search_term . '" - ' . $data['meta_title'];
			}
		}

		// Handle price range filter
		if (isset($_GET['min_price']) || isset($_GET['max_price'])) {
			$min_price = isset($_GET['min_price']) && !empty($_GET['min_price']) ? (float)$_GET['min_price'] : 0;
			$max_price = isset($_GET['max_price']) && !empty($_GET['max_price']) ? (float)$_GET['max_price'] : 999999999;
			
			$base_where .= " AND p_price >= $min_price AND p_price <= $max_price";
			$count_where .= " AND p_price >= $min_price AND p_price <= $max_price";
			
			$price_range = '₹' . number_format($min_price, 2) . ' - ₹' . number_format($max_price, 2);
			$data['active_filters']['price'] = array(
				'type' => 'price',
				'name' => $price_range,
				'min' => $min_price,
				'max' => $max_price,
				'display' => 'Price Range: ' . $price_range
			);
			if (count($data['active_filters']) == 1) {
				$data['seo_title'] = 'Products ' . $price_range . ' - ' . $data['meta_title'];
			}
		}

		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		// Get subcategories for the current category
		if (isset($_GET['cat']) && !empty($_GET['cat'])) {
			$cat_id = $_GET['cat'];
			$data['subcategories'] = $this->db->query("SELECT * FROM yn_site_sub_cat WHERE sc_ctid = '$cat_id' ORDER BY sc_id DESC")->result_array();
		}

		// Get total count for pagination
		$total_where = "WHERE sid NOT IN (4, 5, 6)";
		
		// If there's a search query, filter total count too
		if (isset($_GET['q']) && !empty($_GET['q'])) {
			$search_term = $_GET['q'];
			$total_where .= " AND (name LIKE '%$search_term%' OR `desc` LIKE '%$search_term%')";
		}
		
		$total_query = "SELECT COUNT(*) as total FROM yn_site_catagory $total_where";
		$total_result = $this->db->query($total_query)->row_array();
		$total_num = $total_result['total'];
		$data['total_num'] = $total_num;
		
		// Debug: Check if we have categories
		$debug_categories = $this->db->query("SELECT COUNT(*) as total FROM yn_site_catagory WHERE sid NOT IN (4, 5, 6)")->row_array();
		$data['debug_total'] = $debug_categories['total'];

		// Pagination setup
		$rec_per_page = 6;
		$this->load->library('pagination');
		$config['base_url'] = base_url('category');
		$config['total_rows'] = $total_num;
		$config['per_page'] = $rec_per_page;
		$config['num_links'] = 3;
		$config['use_page_numbers'] = TRUE;
		$config['full_tag_open'] = "";
		$config['full_tag_close'] = '';
		$config['reuse_query_string'] = true;
		$config['page_query_string'] = TRUE;
		$config['query_string_segment'] = 'page';
		$this->pagination->initialize($config);

		@$page = $_GET['page'];
		if (isset($_GET['page'])) {
			$page = $page - 1;
		}
		$limit1 = $page * $rec_per_page;

		// Get categories for main content - exclude sid 4, 5, 6
		$categories_where = "WHERE sid NOT IN (4, 5, 6)";
		
		// If there's a search query, filter categories
		if (isset($_GET['q']) && !empty($_GET['q'])) {
			$search_term = $_GET['q'];
			$categories_where .= " AND (name LIKE '%$search_term%' OR `desc` LIKE '%$search_term%')";
		}
		
		$categories_query = "SELECT * FROM yn_site_catagory $categories_where ORDER BY ctid DESC LIMIT $limit1, $rec_per_page";
		$getCategories = $this->db->query($categories_query);
		$the_categories = $getCategories->result_array();
		$data['categories'] = $the_categories;

		// Get categories for sidebar - exclude sid 4 and 6
		$thecats = $this->db->query("SELECT * FROM yn_site_catagory WHERE sid NOT IN (4, 5 ,6) ORDER BY sid ASC")->result_array();
		$data['the_cats'] = $thecats;

		// Get brands for sidebar
		$brands = $this->db->query("SELECT * FROM yn_site_tags WHERE stg_type = 'Brands' ORDER BY stg_name ASC")->result_array();
		$data['brands'] = $brands;

		// Breadcrumb
		$get_banner1 = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='bshop' AND img_status='1' ORDER BY img_id DESC LIMIT 1");
		$thebanner1 = $get_banner1->row_array();
		$data['breadcrumb'] = $thebanner1;

		// Shop Banner
		$shop_banner = $this->db->query("SELECT * FROM yn_site_img WHERE img_place='home' AND img_sort=7 AND img_status='1' LIMIT 1")->row_array();
		$data['shop_banner'] = $shop_banner;

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('category.php', $data);
		$this->load->view('inc/_footer', $data);
	}

	function search_suggestions()
	{
		$query = $this->input->get('q');
		$suggestions = array();
		
		if (!empty($query)) {
			try {
			// Search in categories for suggestions
				$category_suggestions = $this->db->query("SELECT ctid, name, `desc` FROM yn_site_catagory WHERE sid NOT IN (4, 5, 6) AND (name LIKE '%$query%' OR `desc` LIKE '%$query%') ORDER BY ctid DESC LIMIT 5")->result_array();
			
			foreach ($category_suggestions as $category) {
				$suggestions[] = array(
					'type' => 'category',
					'id' => $category['ctid'],
					'name' => $category['name'],
						'description' => $category['desc'],
					'url' => base_url('sub/' . url_smart($category['name']) . '/' . $category['ctid'])
					);
				}
				
				// Search in sub-sub-categories (subjects) for suggestions
				$sub_sub_category_suggestions = $this->db->query("
					SELECT ssc.mr_sub2_id, ssc.mr_sub2_name, 
						   c.name as category_name, sc.sc_name as subcategory_name
					FROM yn_site_sub2_cat ssc
					LEFT JOIN yn_site_catagory c ON ssc.mr_sub2_cid = c.ctid
					LEFT JOIN yn_site_sub_cat sc ON ssc.mr_sub2_sid = sc.sc_id
					WHERE ssc.mr_sub2_name LIKE '%$query%'
					ORDER BY ssc.mr_sub2_id DESC 
					LIMIT 8
				")->result_array();
				
				foreach ($sub_sub_category_suggestions as $subject) {
					// Get the first sub-sub-sub-category (unit) for this subject
					$unit = $this->db->query("
						SELECT mr_sub3_id, mr_sub3_name 
						FROM yn_site_sub3_cat 
						WHERE mr_sub3_sid = '{$subject['mr_sub2_id']}' 
						ORDER BY mr_sub3_id ASC 
						LIMIT 1
					")->row_array();
					
					if ($unit) {
						$suggestions[] = array(
							'type' => 'subject',
							'id' => $subject['mr_sub2_id'],
							'name' => $subject['mr_sub2_name'],
							'description' => '',
							'category' => $subject['category_name'],
							'subcategory' => $subject['subcategory_name'],
							'unit_name' => $unit['mr_sub3_name'],
							'url' => base_url('sub-sub-sub/' . url_smart($unit['mr_sub3_name']) . '/' . $unit['mr_sub3_id'])
						);
					}
				}
			} catch (Exception $e) {
				// Log error and return empty suggestions
				$suggestions[] = array(
					'type' => 'error',
					'name' => 'Error: ' . $e->getMessage(),
					'url' => '#'
				);
			}
		}
		
		header('Content-Type: application/json');
		echo json_encode($suggestions);
	}

	function cart()
	{

		if (check_service_status('1', '2', 'eco') != '1') {
			redirect('error-404?e=this feature is not enabled.');
		}

		$data = db_variables();
		$data['seo_title'] = 'Cart - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		$allpoppro = $this->db->query("select * from yn_ecom_products ORDER BY p_id desc limit 5 ");
		$thepoppro = $allpoppro->result_array();
		$data['prod'] = $thepoppro;
		
		$get_banner1 = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='bcart' AND img_status='1' ORDER BY img_id DESC LIMIT 1");
		$thebanner1 = $get_banner1->row_array();
		$data['breadcrumb'] = $thebanner1;

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('cart.php', $data);
		$this->load->view('inc/_footer', $data);
	}
	function course()
	{

		

		$data = db_variables();
		$data['seo_title'] = 'Cart - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		$allpoppro = $this->db->query("select * from yn_ecom_products ORDER BY p_id desc limit 5 ");
		$thepoppro = $allpoppro->result_array();
		$data['prod'] = $thepoppro;
		
		$get_banner1 = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='bcart' AND img_status='1' ORDER BY img_id DESC LIMIT 1");
		$thebanner1 = $get_banner1->row_array();
		$data['breadcrumb'] = $thebanner1;

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('course.php', $data);
		$this->load->view('inc/_footer', $data);
	}

	function product($pid, $pname)
	{
		if (check_service_status('1', '2', 'eco') != '1') {
			redirect('error-404?e=this feature is not enabled.');
		}

		$data = db_variables();
		
		// Fetch product details with joins for category, brand, city, state names
		$product_query = "SELECT p.*, 
			c.name AS category_name, 
			b.stg_name AS brand_name, 
			b.stg_img AS brand_image,
			ci.city_name, 
			s.state_name,
			tc.stg_name AS tyre_condition,
			ec.stg_name AS engine_condition,
			-- Vendor information
			v.name AS vendor_name,
			v.email AS vendor_email,
			v.contact AS vendor_phone,
			v.address AS vendor_address,
			v.photo AS vendor_profile_pic,
			v.about AS vendor_about
			FROM yn_ecom_products p
			LEFT JOIN yn_site_catagory c ON p.p_category = c.ctid
			LEFT JOIN yn_site_tags b ON p.p_brand_name = b.stg_tgid AND b.stg_type = 'Brands'
			LEFT JOIN yn_site_cities ci ON p.city = ci.city_id
			LEFT JOIN yn_site_states s ON p.state = s.state_id
			LEFT JOIN yn_site_tags tc ON p.tyre_condition = tc.stg_tgid AND tc.stg_type = 'tyre_type'
			LEFT JOIN yn_site_tags ec ON p.engine_type = ec.stg_tgid AND ec.stg_type = 'engine_typ'
			-- Vendor joins
			LEFT JOIN yn_site_mem v ON p.p_vendor = v.mid
			WHERE p.p_id = '$pid'";
		
		$product_result = $this->db->query($product_query);
		$product = $product_result->row_array();

		if (!$product) {
			redirect('error-404?e=Product not found.');
		}

		// Fetch additional product images
		$images_query = "SELECT * FROM yn_ecom_products_img WHERE pid = '$pid' ORDER BY id ASC";
		$product_images = $this->db->query($images_query)->result_array();

		// Set SEO data
		$data['seo_title'] = $product['p_name'] . ' - ' . $data['meta_title'];
		$data['seo_description'] = strip_tags($product['p_descp']);
		$data['seo_image'] = !empty($product['p_image1']) ? base_url('assets/avator/upload/') . $product['p_image1'] : $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		// Pass product data to view
		$data['product'] = $product;
		$data['product_images'] = $product_images;

		// Get related products (same category, excluding current product)
		$related_products = $this->db->query("SELECT * FROM yn_ecom_products WHERE p_category = '{$product['p_category']}' AND p_id != '$pid' ORDER BY p_id DESC LIMIT 4")->result_array();
		$data['related_products'] = $related_products;
		
		// Get vendor products (same vendor, excluding current product)
		$vendor_products = [];
		if (!empty($product['p_vendor'])) {
			$vendor_products = $this->db->query("SELECT * FROM yn_ecom_products WHERE p_vendor = '{$product['p_vendor']}' AND p_id != '$pid' ORDER BY p_id DESC LIMIT 8")->result_array();
		}
		$data['vendor_products'] = $vendor_products;
		
		// Get sidebar products (random products excluding current product)
		$sidebar_products = $this->db->query("SELECT * FROM yn_ecom_products WHERE p_id != '$pid' AND p_vendor IS NOT NULL AND p_vendor != '' ORDER BY RAND() LIMIT 6")->result_array();
		$data['sidebar_products'] = $sidebar_products;
		
		// Get breadcrumb
		$get_banner1 = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='bproduct' AND img_status='1' ORDER BY img_id DESC LIMIT 1");
		$thebanner1 = $get_banner1->row_array();
		$data['breadcrumb'] = $thebanner1;

		// Fetch checklist tag names for this product
		$exterior_ids = !empty($product['exterior_checklist']) ? explode(',', $product['exterior_checklist']) : [];
		$interior_ids = !empty($product['interior_checklist']) ? explode(',', $product['interior_checklist']) : [];
		$other_ids    = !empty($product['other_checklist'])    ? explode(',', $product['other_checklist'])    : [];

		$data['exterior_checklist_items'] = [];
		$data['interior_checklist_items'] = [];
		$data['other_checklist_items']    = [];

		if (!empty($exterior_ids)) {
			$in = implode(",", array_map('intval', $exterior_ids));
			$data['exterior_checklist_items'] = $this->db->query("SELECT stg_tgid, stg_name FROM yn_site_tags WHERE stg_tgid IN ($in) AND stg_type = 'exterior' ORDER BY FIELD(stg_tgid, $in)")->result_array();
		}
		if (!empty($interior_ids)) {
			$in = implode(",", array_map('intval', $interior_ids));
			$data['interior_checklist_items'] = $this->db->query("SELECT stg_tgid, stg_name FROM yn_site_tags WHERE stg_tgid IN ($in) AND stg_type = 'interior' ORDER BY FIELD(stg_tgid, $in)")->result_array();
		}
		if (!empty($other_ids)) {
			$in = implode(",", array_map('intval', $other_ids));
			$data['other_checklist_items'] = $this->db->query("SELECT stg_tgid, stg_name FROM yn_site_tags WHERE stg_tgid IN ($in) AND stg_type = 'other' ORDER BY FIELD(stg_tgid, $in)")->result_array();
		}


		// // featured products
		// $featuredproducts = $this->db->query("SELECT * FROM yn_ecom_products WHERE p_sale_status = '2' ORDER BY p_id DESC LIMIT 3");
		// $featuredproductsdata = $featuredproducts->result_array();
		// $data['featuredProducts'] = $featuredproductsdata;


		// $allpoppro = $this->db->query("select * from yn_ecom_products ORDER BY RAND() limit 5 ");
		// $thepoppro = $allpoppro->result_array();
		// $data['prod'] = $thepoppro;

		// $getprd = $this->db->query("select * from yn_ecom_products where p_id='$pid'  ");
		// $thepfd = $getprd->row_array();

		// $getprd_img = $this->db->query("select * from  yn_ecom_products_img where pid='$pid'  ");
		// $thepfd_mimg = $getprd_img->result_array();

		// $data['product'] = $thepfd;
		// $data['prod_img'] = $thepfd_mimg;

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('product_detail.php', $data);
		$this->load->view('inc/_footer', $data);
	}

	// function product_detail($product_id = null)
	// {
	// 	if (check_service_status('1', '2', 'eco') != '1') {
	// 		redirect('error-404?e=this feature is not enabled.');
	// 	}

	// 	// Get product ID from URL parameter or query string (same as shop function)
	// 	if (!$product_id) {
	// 		$product_id = $this->input->get('product');
	// 	}

	// 	// If still no product_id, try to get from URL segments
	// 	if (!$product_id) {
	// 		$product_id = $this->uri->segment(2);
	// 	}

	// 	// If still no product_id, try to get from POST
	// 	if (!$product_id) {
	// 		$product_id = $this->input->post('product');
	// 	}

	// 	// If still no product_id, check if it's in the URL path
	// 	if (!$product_id) {
	// 		$uri_segments = $this->uri->segments;
	// 		foreach ($uri_segments as $segment) {
	// 			if (is_numeric($segment)) {
	// 				$product_id = $segment;
	// 				break;
	// 			}
	// 		}
	// 	}

	// 	if (!$product_id || !is_numeric($product_id)) {
	// 		redirect('error-404?e=Product not found.');
	// 	}

	// 	$data = db_variables();

	// 	// Fetch product details with joins for category, brand, city, state names
	// 	$product_query = "SELECT p.*, 
	// 		c.name AS category_name, 
	// 		b.stg_name AS brand_name, 
	// 		ci.city_name, 
	// 		s.state_name,
	// 		tc.stg_name AS tyre_condition,
	// 		ec.stg_name AS engine_condition
	// 		FROM yn_ecom_products p
	// 		LEFT JOIN yn_site_catagory c ON p.p_category = c.ctid
	// 		LEFT JOIN yn_site_tags b ON p.p_brand_name = b.stg_tgid AND b.stg_type = 'Brands'
	// 		LEFT JOIN yn_site_cities ci ON p.city = ci.city_id
	// 		LEFT JOIN yn_site_states s ON p.state = s.state_id
	// 		LEFT JOIN yn_site_tags tc ON p.tyre_condition = tc.stg_tgid AND tc.stg_type = 'tyre_type'
	// 		LEFT JOIN yn_site_tags ec ON p.engine_type = ec.stg_tgid AND ec.stg_type = 'engine_typ'
	// 		WHERE p.p_id = '$product_id'";
		
	// 	$product_result = $this->db->query($product_query);
	// 	$product = $product_result->row_array();

	// 	if (!$product) {
	// 		redirect('error-404?e=Product not found.');
	// 	}

	// 	// Fetch additional product images
	// 	$images_query = "SELECT * FROM yn_ecom_products_img WHERE pid = '$product_id' ORDER BY id ASC";
	// 	$product_images = $this->db->query($images_query)->result_array();

	// 	// Set SEO data
	// 	$data['seo_title'] = $product['p_name'] . ' - ' . $data['meta_title'];
	// 	$data['seo_description'] = strip_tags($product['p_descp']);
	// 	$data['seo_image'] = !empty($product['p_image1']) ? base_url('assets/avator/upload/') . $product['p_image1'] : $data['meta_image'];
	// 	$data['seo_keywords'] = $data['meta_key'];
	// 	$data['meta_array'] = $data;

	// 	// Pass product data to view
	// 	$data['product'] = $product;
	// 	$data['product_images'] = $product_images;

	// 	// Get related products (same category, excluding current product)
	// 	$related_products = $this->db->query("SELECT * FROM yn_ecom_products WHERE p_category = '{$product['p_category']}' AND p_id != '$product_id' ORDER BY p_id DESC LIMIT 4")->result_array();
	// 	$data['related_products'] = $related_products;
		
	// 	// Get breadcrumb
	// 	$get_banner1 = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='bproduct' AND img_status='1' ORDER BY img_id DESC LIMIT 1");
	// 	$thebanner1 = $get_banner1->row_array();
	// 	$data['breadcrumb'] = $thebanner1;

	// 	// Fetch checklist tag names for this product
	// 	$exterior_ids = !empty($product['exterior_checklist']) ? explode(',', $product['exterior_checklist']) : [];
	// 	$interior_ids = !empty($product['interior_checklist']) ? explode(',', $product['interior_checklist']) : [];
	// 	$other_ids    = !empty($product['other_checklist'])    ? explode(',', $product['other_checklist'])    : [];

	// 	$data['exterior_checklist_items'] = [];
	// 	$data['interior_checklist_items'] = [];
	// 	$data['other_checklist_items']    = [];

	// 	if (!empty($exterior_ids)) {
	// 		$in = implode(",", array_map('intval', $exterior_ids));
	// 		$data['exterior_checklist_items'] = $this->db->query("SELECT stg_tgid, stg_name FROM yn_site_tags WHERE stg_tgid IN ($in) AND stg_type = 'exterior' ORDER BY FIELD(stg_tgid, $in)")->result_array();
	// 	}
	// 	if (!empty($interior_ids)) {
	// 		$in = implode(",", array_map('intval', $interior_ids));
	// 		$data['interior_checklist_items'] = $this->db->query("SELECT stg_tgid, stg_name FROM yn_site_tags WHERE stg_tgid IN ($in) AND stg_type = 'interior' ORDER BY FIELD(stg_tgid, $in)")->result_array();
	// 	}
	// 	if (!empty($other_ids)) {
	// 		$in = implode(",", array_map('intval', $other_ids));
	// 		$data['other_checklist_items'] = $this->db->query("SELECT stg_tgid, stg_name FROM yn_site_tags WHERE stg_tgid IN ($in) AND stg_type = 'other' ORDER BY FIELD(stg_tgid, $in)")->result_array();
	// 	}

	// 	$this->load->view('inc/_header', $data);
	// 	$this->load->view('inc/section', $data);
	// 	$this->load->view('product_detail.php', $data);
	// 	$this->load->view('inc/_footer', $data);
	// }


	

	///////////////////////	


	function checkout()
	{
		// @session_start();
		// check_session('2','login');
		$data = db_variables();
		$data['seo_title'] = 'Checkout - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;
		
		$getprd_img = $this->db->query("select * from  yn_site_states where status= 1  ");
		$statess = $getprd_img->result_array();
		$data['states'] = $statess;

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('checkout', $data);
		$this->load->view('inc/_footer', $data);
	}

	function help()
	{
		// @session_start();
		// check_session('2','login');
		$data = db_variables();
		$data['seo_title'] = 'Help - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('help', $data);
		$this->load->view('inc/_footer', $data);
	}
	function view()
	{
		@session_start();
		check_session('2', 'account');
		$data = db_variables();
		$data['seo_title'] = 'View - ' . $data['meta_title'];;
		$data['seo_description'] = $data['meta_title'];;
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['page_name'] = 'View';
		$data['meta_array'] = $data;

		$oid = $_GET['ordid'];
		$viewallorder = $this->db->query("select * from yn_ecom_orders_detail where checkout_order_id = '$oid'  order by xod_id desc");
		$viewalldetail = $viewallorder->result_array();
		$data['viewall'] = $viewalldetail;


		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section2', $data);
		$this->load->view('view', $data);
		$this->load->view('inc/_footer', $data);
	}
	function wholesale()
	{
		$data = db_variables();
		$data['seo_title'] = 'Wholesale - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		//All products
		$getProducts = $this->db->query("SELECT * FROM `yn_ecom_products` where wholesale='1' order by p_id desc limit 21");
		$the_prods = $getProducts->result_array();
		$data['prod'] = $the_prods;
		
		$get_banner1 = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='bwhole' AND img_status='1' ORDER BY img_id DESC LIMIT 1");
		$thebanner1 = $get_banner1->row_array();
		$data['breadcrumb'] = $thebanner1;

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('wholesale', $data);
		$this->load->view('inc/_footer', $data);
	}
	function rewards()
	{
		$data = db_variables();
		$data['seo_title'] = 'Rewards - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		$get_banner1 = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='brewards' AND img_status='1' ORDER BY img_id DESC LIMIT 1");
		$thebanner1 = $get_banner1->row_array();
		$data['breadcrumb'] = $thebanner1;

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('rewards', $data);
		$this->load->view('inc/_footer', $data);
	}

	function calculator()
	{
		$data = db_variables();
		$data['seo_title'] = 'Calculator - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		$this->load->view('inc/_header', $data);
		$this->load->view('calculator', $data);
		$this->load->view('inc/_footer', $data);
	}

	function loan_calculator()
	{
		$data = db_variables();
		$data['seo_title'] = 'Loan Calculator - EMI Calculator for Tractor Financing - ' . $data['meta_title'];
		$data['seo_description'] = 'Calculate your tractor loan EMI with our comprehensive loan calculator. Get detailed amortization schedule, interest calculations, and loan comparison tools for tractor financing in India.';
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = 'loan calculator, EMI calculator, tractor loan, agricultural loan, tractor financing, EMI calculation, loan amortization';
		$data['meta_array'] = $data;

		$this->load->view('inc/_header', $data);
		$this->load->view('loan_calculator', $data);
		$this->load->view('inc/_footer', $data);
	}

	function compare()
	{
		$data = db_variables();
		$data['seo_title'] = 'Compare Tractors - ' . $data['meta_title'];
		$data['seo_description'] = 'Compare tractor models side-by-side by price, engine power, year and key specs.';
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = 'tractor compare, compare tractors, tractor specs comparison';
		$data['meta_array'] = $data;

		$this->load->view('inc/_header', $data);
		$this->load->view('compare_tractors', $data);
		$this->load->view('inc/_footer', $data);
	}

    // Used Tractors listing with State/City filters
    function used_tractors()
    {
        $data = db_variables();
        $data['seo_title'] = 'Used Tractors - ' . $data['meta_title'];
        $data['seo_description'] = 'Browse all available used tractors by state and city. Filter easily to find used tractors near you with complete details.';
        $data['seo_image'] = $data['meta_image'];
        $data['seo_keywords'] = 'used tractors, second hand tractor, tractors by state, tractors by city';
        $data['meta_array'] = $data;

        // Inputs
        $state = $this->input->get('state');
        $city  = $this->input->get('city');
        $data['selected_state'] = $state;
        $data['selected_city']  = $city;

        // Load states (same pattern as add_product)
        $states = $this->db->query("SELECT * FROM yn_site_states WHERE status = 1 ORDER BY state_name ASC")->result_array();
        $data['states'] = $states;
        // Load cities for selected state (same as add_product)
        $data['cities'] = [];
        if (!empty($state)) {
            $data['cities'] = $this->db->query("SELECT * FROM yn_site_cities WHERE state_id = '$state' ORDER BY city_name ASC")->result_array();
        }

        // If a specific category id is used in DB (e.g., 15), prefer that; else fallback by name
        $usedCatId = '';
        $hint = $this->db->query("SELECT ctid FROM yn_site_catagory WHERE ctid='15'")->row_array();
        if ($hint) { $usedCatId = '15'; }
        if ($usedCatId === '') {
            $catRow = $this->db->query("SELECT ctid FROM yn_site_catagory WHERE name LIKE 'Used Tractor%'")->row_array();
            if (!$catRow) { $catRow = $this->db->query("SELECT ctid FROM yn_site_catagory WHERE name LIKE 'Used Tractors%'")->row_array(); }
            $usedCatId = $catRow ? $catRow['ctid'] : '';
        }

        // Build WHERE (do not require p_vendor; show all records like other pages do in some sections)
        $where = "WHERE 1=1";
        if ($usedCatId !== '') { $where .= " AND p_category = '$usedCatId'"; }
        if (!empty($state)) { $where .= " AND p.state = '$state'"; }
        if (!empty($city))  { $where .= " AND p.city = '$city'"; }

        // Pagination
        $this->load->library('pagination');
        $total_num = $this->db->query("SELECT COUNT(*) AS t FROM yn_ecom_products p $where")->row_array();
        $total = isset($total_num['t']) ? (int)$total_num['t'] : 0;
        $rec_per_page = 12;
        $config['base_url'] = base_url('used-tractors');
        $config['total_rows'] = $total;
        $config['per_page'] = $rec_per_page;
        $config['num_links'] = 3;
        $config['use_page_numbers'] = TRUE;
        $config['reuse_query_string'] = true; // keep state/city when paging
        $config['page_query_string'] = TRUE;
        $config['query_string_segment'] = 'page';
        $this->pagination->initialize($config);

        $page = $this->input->get('page');
        if ($page) { $page = ((int)$page) - 1; } else { $page = 0; }
        $limit1 = $page * $rec_per_page;

        // Fetch products
        $sql = "SELECT p.*, s.state_name, ci.city_name
                FROM yn_ecom_products p
                LEFT JOIN yn_site_states s ON p.state = s.state_id
                LEFT JOIN yn_site_cities ci ON p.city = ci.city_id
                $where ORDER BY p_id DESC LIMIT $limit1, $rec_per_page";
        $getProducts = $this->db->query($sql);
        $data['prod'] = $getProducts->result_array();

        // pagination links
        $data['pagination'] = $this->pagination->create_links();

        $this->load->view('inc/_header', $data);
        $this->load->view('used_tractors', $data);
        $this->load->view('inc/_footer', $data);
    }

	function onRoad_price()
	{
		$data = db_variables();
		$data['seo_title'] = 'On Road Price - ' . $data['meta_title'];
		$data['seo_description'] = 'Check on road price for tractors and agricultural equipment. Get detailed pricing information including taxes, insurance, and registration costs.';
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = 'on road price, tractor price, agricultural equipment price, tractor cost calculator';
		$data['meta_array'] = $data;

		$this->load->view('inc/_header', $data);
		$this->load->view('onRoad_price', $data);
		$this->load->view('inc/_footer', $data);
	}

	// Tractor Insurance (static UI first)
	function insurance()
	{
		$data = db_variables();
		$data['seo_title'] = 'Tractor Insurance - Compare & Apply Online - ' . $data['meta_title'];
		$data['seo_description'] = 'Get tractor insurance online in minutes. Compare policies, premiums and features from popular insurers and apply instantly.';
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = 'tractor insurance, farm vehicle insurance, compare tractor insurance, commercial tractor insurance';
		$data['meta_array'] = $data;

		// Brands for the brands grid (reuse home.php logic)
        $all_brands_query = "SELECT * FROM yn_site_tags WHERE stg_type = 'Brands' ORDER BY stg_name ASC";
        $all_brands = $this->db->query($all_brands_query)->result_array();
        $initial_brands = array_slice($all_brands, 0, 8);
        $data['brands'] = $initial_brands;
        $data['all_brands'] = $all_brands;
        $data['total_brands'] = count($all_brands);

		$this->load->view('inc/_header', $data);
		$this->load->view('insurance', $data);
		$this->load->view('inc/_footer', $data);
	}

	// Dealer Inquiry page (form + details block)
	function dealer_inquiry()
	{
		$data = db_variables();
		$data['seo_title'] = 'Dealer Inquiry Form - ' . $data['meta_title'];
		$data['seo_description'] = 'Submit your dealer inquiry. Share your details and our team will contact you with complete information and next steps.';
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = 'dealer inquiry, tractor dealer, dealership form';
		$data['meta_array'] = $data;

		// States for selects if needed
		$data['states'] = $this->db->query("SELECT * FROM yn_site_states WHERE status = 1 ORDER BY state_name ASC")->result_array();
		// Brands list
		$data['brand_options'] = $this->db->query("SELECT stg_tgid, stg_name FROM yn_site_tags WHERE stg_type='Brands' ORDER BY stg_name ASC")->result_array();

		$this->load->view('inc/_header', $data);
		$this->load->view('dealer_inquiry', $data);
		$this->load->view('inc/_footer', $data);
	}

	function wishlist()
	{
		$data = db_variables();
		$data['seo_title'] = 'Wishlist - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		// Get wishlist products (you can modify this query based on your database structure)
		$getWishlistProducts = $this->db->query("SELECT * FROM `yn_ecom_products` ORDER BY p_id DESC LIMIT 10");
		$wishlistProducts = $getWishlistProducts->result_array();
		$data['wishlist_products'] = $wishlistProducts;
		
		$get_banner1 = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='bwishlist' AND img_status='1' ORDER BY img_id DESC LIMIT 1");
		$thebanner1 = $get_banner1->row_array();
		$data['breadcrumb'] = $thebanner1;

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('wishlist', $data);
		$this->load->view('inc/_footer', $data);
	}

	function add_product()
	{
		@session_start();
		check_session('2', 'account');
		$data = db_variables();
		$data['seo_title'] = 'Add Product - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_title'];
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['page_name'] = 'Add Product';
		$data['meta_array'] = $data;

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section2', $data);
		$this->load->view('add_product', $data);
		$this->load->view('inc/_footer', $data);
	}

	public function get_product_images() {
    $product_id = $this->input->get('product_id');
    if (empty($product_id)) {
        echo json_encode(['success' => false, 'error' => 'Product ID missing']);
        return;
    }
    $images = $this->db->query("SELECT img_id, img as img_name FROM yn_ecom_products_img WHERE pid = '$product_id'")->result_array();
    echo json_encode(['success' => true, 'images' => $images]);
}



function product_category($slug = null)
{
    $data = db_variables();
    $data['seo_title'] = 'Product Category - ' . $data['meta_title'];
    $data['seo_description'] = $data['meta_title'];
    $data['seo_image'] = base_url('assets/avator/og_img.jpg');
    $data['seo_keywords'] = 'keywords';
    $data['page_name'] = 'Product Category';
    $data['meta_array'] = $data;

    // Always use category id (ctid) from query string or URL
    $category_id = null;
    if (isset($_GET['category']) && is_numeric($_GET['category'])) {
        $category_id = $_GET['category'];
    } elseif (isset($_GET['cat']) && is_numeric($_GET['cat'])) {
        $category_id = $_GET['cat'];
    } elseif ($slug && is_numeric($slug)) {
        $category_id = $slug;
    }

    // Fetch category by ctid
    $category = null;
    if ($category_id) {
        $category = $this->db->query("SELECT * FROM yn_site_catagory WHERE ctid = '$category_id' LIMIT 1")->row_array();
    }
    if (!$category) {
        $category = $this->db->query("SELECT * FROM yn_site_catagory ORDER BY sid ASC LIMIT 1")->row_array();
    }
    $data['category'] = $category;
    $data['category_name'] = $category ? $category['name'] : 'All Products';

    // Fetch products for this category
    $products = [];
    if ($category && !empty($category['ctid'])) {
        $products = $this->db->query("SELECT p_id, p_name, p_price, p_model, p_year, p_brand_name, p_cover, p_category FROM yn_ecom_products WHERE p_category = '{$category['ctid']}' ORDER BY p_id DESC")->result_array();
    }
    $data['category_products'] = $products;

    $this->load->view('inc/_header', $data);
    $this->load->view('inc/section2', $data);
    $this->load->view('product_category', $data);
    $this->load->view('inc/_footer', $data);
}

	function student_dashboard()
	{
		$data = db_variables();
		$data['seo_title'] = 'Student Dashboard - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		// Get student-specific data
		// You can add queries here to get student courses, progress, etc.
		$data['student_data'] = array(); // Placeholder for student data

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('student_dashboard', $data);
		$this->load->view('inc/_footer', $data);
	}

	function instructor()
	{
		$data = db_variables();
		$data['seo_title'] = 'Our Instructors - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		// Fetch all teachers with their category information
		$instructors_query = "SELECT m.*, 
			c.name as category_name,
			sc.sc_name as subcategory_name,
			ssc.mr_sub2_name as sub_subcategory_name,
			COALESCE(m.teacher_education, m.user_education) as education,
			m.teacher_experience as experience,
			m.about as bio
		FROM yn_site_mem m
		LEFT JOIN yn_site_catagory c ON m.category_id = c.ctid
		LEFT JOIN yn_site_sub_cat sc ON m.subcategory_id = sc.sc_id
		LEFT JOIN yn_site_sub2_cat ssc ON m.sub_subcategory_id = ssc.mr_sub2_id
		WHERE m.user_type = 'teacher' AND m.user_status = '1'
		ORDER BY m.mid DESC";
		
		$instructors = $this->db->query($instructors_query)->result_array();
		$data['instructors'] = $instructors;

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('instructor', $data);
		$this->load->view('inc/_footer', $data);
	}

	function instructor_details()
	{
		$data = db_variables();
		
		// Get instructor ID from URL segment
		$instructor_id = $this->uri->segment(2);
		
		// Check if instructor ID is provided
		if (empty($instructor_id)) {
			redirect(base_url('instructor'));
			return;
		}

		// Fetch instructor details with category information
		$instructor_query = "SELECT m.*, 
			c.name as category_name,
			sc.sc_name as subcategory_name,
			ssc.mr_sub2_name as sub_subcategory_name,
			COALESCE(m.teacher_education, m.user_education) as education,
			m.teacher_experience as experience,
			m.about as bio
		FROM yn_site_mem m
		LEFT JOIN yn_site_catagory c ON m.category_id = c.ctid
		LEFT JOIN yn_site_sub_cat sc ON m.subcategory_id = sc.sc_id
		LEFT JOIN yn_site_sub2_cat ssc ON m.sub_subcategory_id = ssc.mr_sub2_id
		WHERE m.mid = '$instructor_id' AND m.user_type = 'teacher' AND m.user_status = '1'";
		
		$instructor_result = $this->db->query($instructor_query);
		$instructor = $instructor_result->row_array();
		
		// If instructor not found, redirect to instructor list
		if (empty($instructor)) {
			redirect(base_url('instructor'));
			return;
		}
		
		$data['instructor'] = $instructor;
		$data['seo_title'] = $instructor['firstname'] . ' ' . $instructor['lastname'] . ' - Instructor - ' . $data['meta_title'];
		$data['seo_description'] = 'Learn from ' . $instructor['firstname'] . ' ' . $instructor['lastname'] . ', ' . ($instructor['subcategory_name'] ?: $instructor['category_name']) . ' expert';
		$data['seo_image'] = !empty($instructor['photo']) ? base_url('assets/avator/upload/') . $instructor['photo'] : $data['meta_image'];
		$data['seo_keywords'] = $instructor['firstname'] . ' ' . $instructor['lastname'] . ', instructor, teacher, ' . ($instructor['subcategory_name'] ?: $instructor['category_name']);
		$data['meta_array'] = $data;

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('instructor_details', $data);
		$this->load->view('inc/_footer', $data);
	}

	function become_teacher()
	{
		$data = db_variables();
		$data['seo_title'] = 'Become a Teacher - ' . $data['meta_title'];
		$data['seo_description'] = 'Join our platform as a teacher and share your knowledge with students worldwide.';
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'become teacher, instructor, teach online, education';
		$data['meta_array'] = $data;

		// Fetch categories for the form
		$categories = $this->db->query("SELECT * FROM yn_site_catagory WHERE sid NOT IN (4, 5, 6) ORDER BY name ASC")->result_array();
		$data['categories'] = $categories;

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section2', $data);
		$this->load->view('become_teacher', $data);
		$this->load->view('inc/_footer', $data);
	}

	function instructor_dashboard()
	{
		$data = db_variables();
		$data['seo_title'] = 'Instructor Dashboard - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		// Get instructor-specific data
		// You can add queries here to get instructor courses, students, etc.
		$data['instructor_data'] = array(); // Placeholder for instructor data

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('instructor_dashboard', $data);
		$this->load->view('inc/_footer', $data);
	}

	function debug_topic($topic_name = null, $topic_id = null)
	{
		echo "Debug Topic Function Called<br>";
		echo "Topic Name: " . $topic_name . "<br>";
		echo "Topic ID: " . $topic_id . "<br>";
		echo "URL: " . current_url() . "<br>";
		exit;
	}

	function topic_detail($topic_name = null, $topic_id = null)
	{
		$data = db_variables();
		
		// Validate topic_id
		if (!$topic_id || !is_numeric($topic_id)) {
			redirect(base_url('error-404?e=Invalid topic ID.'));
		}

		// Fetch topic details with full category hierarchy
		$topic_query = "SELECT p.*, 
			c.name as category_name,
			sc.sc_name as subcategory_name,
			ssc.mr_sub2_name as sub_subcategory_name,
			sssc.mr_sub3_name as sub_sub_subcategory_name
		FROM yn_ecom_products p
		LEFT JOIN yn_site_catagory c ON p.p_category = c.ctid
		LEFT JOIN yn_site_sub_cat sc ON p.p_sub_category = sc.sc_id
		LEFT JOIN yn_site_sub2_cat ssc ON p.p_sub_sub_cat = ssc.mr_sub2_id
		LEFT JOIN yn_site_sub3_cat sssc ON p.p_sub_sub_sub_cat = sssc.mr_sub3_id
		WHERE p.p_id = '$topic_id' LIMIT 1";
		
		$topic_data = $this->db->query($topic_query)->row_array();
		
		if (!$topic_data) {
			redirect(base_url('error-404?e=Topic not found.'));
		}

		// Get topic images
		$topic_images = $this->db->query("SELECT img FROM yn_ecom_products_img WHERE pid = '$topic_id' ORDER BY id ASC")->result_array();
		$topic_data['images'] = $topic_images;
		$topic_data['product_images'] = $topic_images;

		// Set SEO data
		$data['seo_title'] = $topic_data['p_name'] . ' - ' . $data['meta_title'];
		$data['seo_description'] = !empty($topic_data['p_descp']) ? strip_tags($topic_data['p_descp']) : 'Learn ' . $topic_data['p_name'] . ' with comprehensive course materials.';
		$data['seo_image'] = !empty($topic_images[0]['img']) ? base_url('assets/avator/upload/') . $topic_images[0]['img'] : $data['meta_image'];
		$data['seo_keywords'] = $topic_data['p_name'] . ', ' . $topic_data['category_name'] . ', learning, course';
		$data['meta_array'] = $data;

		// Pass topic data to view
		$data['topic_data'] = $topic_data;
		$data['topic_name'] = $topic_data['p_name'];
		$data['topic_id'] = $topic_id;
		
		// Get related topics from the same sub-sub-sub category
		$related_topics_query = "SELECT p.*, 
			c.name as category_name,
			sc.sc_name as subcategory_name,
			ssc.mr_sub2_name as sub_subcategory_name,
			sssc.mr_sub3_name as sub_sub_subcategory_name
		FROM yn_ecom_products p
		LEFT JOIN yn_site_catagory c ON p.p_category = c.ctid
		LEFT JOIN yn_site_sub_cat sc ON p.p_sub_category = sc.sc_id
		LEFT JOIN yn_site_sub2_cat ssc ON p.p_sub_sub_cat = ssc.mr_sub2_id
		LEFT JOIN yn_site_sub3_cat sssc ON p.p_sub_sub_sub_cat = sssc.mr_sub3_id
		WHERE p.p_sub_sub_sub_cat = '{$topic_data['p_sub_sub_sub_cat']}' AND p.p_id != '$topic_id'
		ORDER BY p.p_id DESC LIMIT 6";
		$related_topics = $this->db->query($related_topics_query)->result_array();
		
		// Get images for related topics
		foreach ($related_topics as &$related_topic) {
			$related_topic_id = $related_topic['p_id'];
			$related_topic_images = $this->db->query("SELECT img FROM yn_ecom_products_img WHERE pid = '$related_topic_id' ORDER BY id ASC")->result_array();
			$related_topic['images'] = $related_topic_images;
		}
		
		$data['related_topics'] = $related_topics;

		// Get FAQs for this topic
		$faqs_query = "SELECT * FROM yn_topic_faqs WHERE topic_id = '$topic_id' AND faq_status = 1 ORDER BY faq_order ASC";
		$faqs = $this->db->query($faqs_query)->result_array();
		$data['faqs'] = $faqs;

		// Get breadcrumb
		$get_banner1 = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='btopic' AND img_status='1' ORDER BY img_id DESC LIMIT 1");
		$thebanner1 = $get_banner1->row_array();
		$data['breadcrumb'] = $thebanner1;

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('topic_detail', $data);
		$this->load->view('inc/_footer', $data);
	}

	// Get instant learning topics (custom topics for both students and teachers)
	function get_instant_learning_topics()
	{
		try {
			// Check if user is logged in
			if (!isset($_SESSION['yid'])) {
				echo json_encode(['success' => false, 'message' => 'Unauthorized access']);
				return;
			}

			$user_id = $_SESSION['yid'];
			$user_type = $_SESSION['user_type'] ?? 'student';
			error_log("Instant Learning Debug - User ID: " . $user_id . ", User Type: " . $user_type);

			// Build query based on user type
			if ($user_type === 'student') {
				// For students: show custom topics created for them
				$where_clause = "p.p_vendor = '$user_id' AND p.p_sku LIKE 'CUSTOM_STUDENT_%'";
				error_log("Instant Learning Debug - Student query: showing topics created for student");
			} else {
				// For teachers: show custom topics they created for any student
				$where_clause = "p.p_sku LIKE 'CUSTOM_STUDENT_%' AND p.p_sku LIKE '%_$user_id_%'";
				error_log("Instant Learning Debug - Teacher query: showing topics created by teacher");
			}

			// Get custom topics based on user type
			$query = "SELECT 
				p.p_id as topic_id,
				p.p_name as topic_name,
				p.p_descp as topic_description,
				p.topic_duration as topic_duration,
				p.topic_level as topic_level,
				p.topic_lessons as topic_lessons,
				p.p_star as rating,
				p.p_weight as reviews_count,
				p.p_price as topic_price,
				c.name as category_name,
				sc.sc_name as subcategory_name,
				ssc.mr_sub2_name as sub_subcategory_name,
				sssc.mr_sub3_name as sub_sub_subcategory_name,
				pi.img as product_image,
				p.p_sku as sku,
				p.p_vendor as student_id
			FROM yn_ecom_products p
			LEFT JOIN yn_site_catagory c ON p.p_category = c.ctid
			LEFT JOIN yn_site_sub_cat sc ON p.p_sub_category = sc.sc_id
			LEFT JOIN yn_site_sub2_cat ssc ON p.p_sub_sub_cat = ssc.mr_sub2_id
			LEFT JOIN yn_site_sub3_cat sssc ON p.p_sub_sub_sub_cat = sssc.mr_sub3_id
			LEFT JOIN yn_ecom_products_img pi ON p.p_id = pi.pid
			WHERE $where_clause
			ORDER BY p.p_id DESC";

			error_log("Instant Learning Debug - Query: " . $query);

			$result = $this->db->query($query);
			
			if ($result) {
				error_log("Instant Learning Debug - Query executed successfully");
				error_log("Instant Learning Debug - Number of rows: " . $result->num_rows());
				
				if ($result->num_rows() > 0) {
					$topics = $result->result_array();
					
					// Process topics based on user type
					foreach ($topics as &$topic) {
						$sku = $topic['sku'];
						$topic_id = $topic['topic_id'];
						
						// Extract teacher ID and student ID from SKU format: CUSTOM_STUDENT_teacherId_studentId_timestamp
						if (preg_match('/CUSTOM_STUDENT_(\d+)_(\d+)_/', $sku, $matches)) {
							$teacher_id = $matches[1];
							$student_id_from_sku = $matches[2];
							$topic['teacher_id'] = $teacher_id;
							$topic['student_id_from_sku'] = $student_id_from_sku;
							
							// Get teacher information
							$teacher_query = "SELECT mid, firstname, lastname, email, phone, about, photo FROM yn_site_mem WHERE mid = '$teacher_id'";
							$teacher_result = $this->db->query($teacher_query);
							if ($teacher_result && $teacher_result->num_rows() > 0) {
								$teacher_data = $teacher_result->row_array();
								$topic['teacher_name'] = $teacher_data['firstname'] . ' ' . $teacher_data['lastname'];
								$topic['teacher_email'] = $teacher_data['email'];
								$topic['teacher_phone'] = $teacher_data['phone'];
								$topic['teacher_bio'] = $teacher_data['about'];
								$topic['teacher_image'] = $teacher_data['photo'];
							}
							
							// Get student information
							$student_query = "SELECT mid, firstname, lastname, email, phone, photo FROM yn_site_mem WHERE mid = '$student_id_from_sku'";
							$student_result = $this->db->query($student_query);
							if ($student_result && $student_result->num_rows() > 0) {
								$student_data = $student_result->row_array();
								$topic['student_name'] = $student_data['firstname'] . ' ' . $student_data['lastname'];
								$topic['student_email'] = $student_data['email'];
								$topic['student_phone'] = $student_data['phone'];
								$topic['student_image'] = $student_data['photo'];
							}
							
							// For teachers: Check if the custom topic has been purchased
							if ($user_type === 'teacher') {
								$purchase_query = "SELECT COUNT(*) as purchase_count 
												   FROM yn_ecom_orders_detail od 
												   LEFT JOIN yn_ecom_order o ON od.checkout_order_id = o.so_order_id 
												   WHERE od.xod_pid = '$topic_id' 
												   AND o.so_status = 1";
								$purchase_result = $this->db->query($purchase_query);
								$purchase_count = $purchase_result ? $purchase_result->row()->purchase_count : 0;
								
								$topic['is_purchased'] = $purchase_count > 0 ? 1 : 0;
								$topic['purchase_status'] = $purchase_count > 0 ? 'Purchased' : 'Not Purchased';
								$topic['purchase_badge_color'] = $purchase_count > 0 ? 'success' : 'warning';
							}
						}
					}
					
					// Get unread count for notifications (only for students)
					$unread_count = 0;
					if ($user_type === 'student') {
						$unread_query = "SELECT COUNT(*) as unread_count 
										 FROM yn_ecom_products p 
										 LEFT JOIN yn_notification_reads nr ON p.p_id = nr.notification_id AND nr.user_id = '$user_id' AND nr.notification_type = 'instant_learning'
										 WHERE p.p_vendor = '$user_id' 
										 AND p.p_sku LIKE 'CUSTOM_STUDENT_%'
										 AND nr.id IS NULL";
						$unread_result = $this->db->query($unread_query);
						$unread_count = $unread_result ? $unread_result->row()->unread_count : 0;
					}
					
					error_log("Instant Learning Debug - Topics found: " . count($topics));
					error_log("Instant Learning Debug - Unread count: " . $unread_count);
					echo json_encode([
						'success' => true,
						'topics' => $topics,
						'unread_count' => (int)$unread_count
					]);
				} else {
					error_log("Instant Learning Debug - No topics found");
					echo json_encode([
						'success' => true,
						'topics' => [],
						'unread_count' => 0
					]);
				}
			} else {
				error_log("Instant Learning Debug - Query failed");
				echo json_encode([
					'success' => false,
					'message' => 'Database query failed'
				]);
			}
		} catch (Exception $e) {
			error_log("Instant Learning Debug - Exception: " . $e->getMessage());
			echo json_encode([
				'success' => false,
				'message' => 'Server error: ' . $e->getMessage()
			]);
		}
	}

	// Get notification count for instant learning
	public function get_notification_count() {
		try {
			$user_id = $this->session->userdata('yid');
			$notification_type = $this->input->post('notification_type');
			
			if (!$user_id) {
				echo json_encode(['success' => false, 'message' => 'User not logged in']);
				return;
			}

			// Count unread notifications for instant learning
			$query = "SELECT COUNT(*) as unread_count 
					  FROM yn_ecom_products p 
					  LEFT JOIN yn_notification_reads nr ON p.p_id = nr.notification_id AND nr.user_id = '$user_id' AND nr.notification_type = 'instant_learning'
					  WHERE p.p_vendor = '$user_id' 
					  AND p.p_sku LIKE 'CUSTOM_STUDENT_%'
					  AND nr.id IS NULL";
			
			$result = $this->db->query($query);
			$count = $result->row()->unread_count;

			echo json_encode([
				'success' => true,
				'count' => (int)$count
			]);

		} catch (Exception $e) {
			error_log("Notification Count Error: " . $e->getMessage());
			echo json_encode([
				'success' => false,
				'message' => 'Error getting notification count'
			]);
		}
	}

	// Mark notification as read
	public function mark_notification_read() {
		try {
			$user_id = $this->session->userdata('yid');
			$notification_type = $this->input->post('notification_type');
			
			if (!$user_id) {
				echo json_encode(['success' => false, 'message' => 'User not logged in']);
				return;
			}

			// Get all unread instant learning topics for this user
			$query = "SELECT p.p_id 
					  FROM yn_ecom_products p 
					  LEFT JOIN yn_notification_reads nr ON p.p_id = nr.notification_id AND nr.user_id = '$user_id' AND nr.notification_type = 'instant_learning'
					  WHERE p.p_vendor = '$user_id' 
					  AND p.p_sku LIKE 'CUSTOM_STUDENT_%'
					  AND nr.id IS NULL";
			
			$result = $this->db->query($query);
			$topics = $result->result_array();

			// Mark each topic as read
			foreach ($topics as $topic) {
				$insert_data = [
					'user_id' => $user_id,
					'notification_type' => $notification_type,
					'notification_id' => $topic['p_id'],
					'read_at' => date('Y-m-d H:i:s')
				];
				$this->db->insert('yn_notification_reads', $insert_data);
			}

			echo json_encode([
				'success' => true,
				'message' => 'Notifications marked as read'
			]);

		} catch (Exception $e) {
			error_log("Mark Notification Read Error: " . $e->getMessage());
			echo json_encode([
				'success' => false,
				'message' => 'Error marking notifications as read'
			]);
		}
	}

	function request($req)
	{
		check_session('2', 'account');
		$data = db_variables();

		$data['seo_title'] = 'Requests | ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_title'];
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['page_name'] = 'YNAPS';

		$yid = $_SESSION['yid'];
		$themyuser_details = $this->ynaps_model->getprofile_data('*', $_SESSION['yid']);
		$data['profile_data'] = $themyuser_details;
		$data['req'] = $req;

		if ($req == "withdraw") {
			// Get user bank details
			$tables = $this->db->list_tables();
			if (in_array('x_play_bank', $tables)) {
				$getthebankdetails = $this->db->query("select * from x_play_bank where bank_mid='$yid'");
				$bank = $getthebankdetails->row_array();
				$data['bank'] = $bank;
			} else {
				$data['bank'] = array();
			}
		} else {
			// TopUp - Get admin bank details
			$tables = $this->db->list_tables();
			$data['upi'] = array();
			$data['bank_details'] = array();
			if (in_array('admin_bank', $tables)) {
				$gettheupidetails = $this->db->query("select * from admin_bank LIMIT 1");
				if ($gettheupidetails->num_rows() > 0) {
					$admin_bank = $gettheupidetails->row_array();
					// Convert admin bank details to UPI format for display
					$data['upi'] = array();
					if (!empty($admin_bank['bacc_gpay'])) {
						$data['upi'][] = array('upi_id' => $admin_bank['bacc_gpay'], 'type' => 'GPay');
					}
					if (!empty($admin_bank['bacc_phonepay'])) {
						$data['upi'][] = array('upi_id' => $admin_bank['bacc_phonepay'], 'type' => 'PhonePe');
					}
					if (!empty($admin_bank['bacc_paytm'])) {
						$data['upi'][] = array('upi_id' => $admin_bank['bacc_paytm'], 'type' => 'PayTM');
					}
					if (!empty($admin_bank['bacc_upi'])) {
						$data['upi'][] = array('upi_id' => $admin_bank['bacc_upi'], 'type' => 'UPI');
					}
					// Also add bank account details
					if (!empty($admin_bank['bacc_num'])) {
						$data['bank_details'] = $admin_bank;
					}
				}
			}
		}

		$this->load->view('inc/_header', $data);
		$this->load->view('request', $data);
		$this->load->view('inc/_footer', $data);
	}

	function wallet($action = '')
	{
		check_session('2', 'account');

		$data = db_variables();
		$yid = $_SESSION['yid'];
		$themyuser_details = $this->ynaps_model->getprofile_data('*', $_SESSION['yid']);
		$data['profile_data'] = $themyuser_details;
		$data['yid'] = $yid;

		if ($action == 'history') {
			// Transaction History Page
			$data['seo_title'] = 'Transaction History | ' . $data['meta_title'];
			$data['seo_description'] = $data['meta_title'];
			$data['seo_image'] = base_url('assets/avator/og_img.jpg');
			$data['seo_keywords'] = 'keywords';
			$data['page_name'] = 'YNAPS';

			// Get wallet transactions
			$tables = $this->db->list_tables();
			$data['wallet_trans'] = array();
			if (in_array('site_wallet', $tables)) {
				$wallet = $this->db->query("SELECT * FROM site_wallet where wallet_userID='$yid' order by wallet_id DESC limit 50");
				$data['wallet_trans'] = $wallet->result_array();
			}

			$this->load->view('inc/_header', $data);
			$this->load->view('wallet-history', $data);
			$this->load->view('inc/_footer', $data);
		} else {
			// Main Wallet Page (Balance Card Only)
			$data['seo_title'] = 'Wallet | ' . $data['meta_title'];
			$data['seo_description'] = $data['meta_title'];
			$data['seo_image'] = base_url('assets/avator/og_img.jpg');
			$data['seo_keywords'] = 'keywords';
			$data['page_name'] = 'YNAPS';

			$this->load->view('inc/_header', $data);
			$this->load->view('wallet', $data);
			$this->load->view('inc/_footer', $data);
		}
	}

}
