<link rel="stylesheet" type="text/css" href="<?= base_url() ?>assets/theme/v2/assets/css/style.min.css">
<?php
if(isset($_GET['id']) && $_GET['id'] != '') {
    $what = 'edit_product';
    $product_id = xss_clean($_GET['id']);
    $product = $this->db->query("SELECT * FROM yn_ecom_products WHERE p_id = '$product_id'")->row_array();
} else {
    $what = 'add_product';
}
?>

<!-- Start of Main -->
<main class="main">
    <!-- Start of Page Header -->
    <div class="page-header">
        <div class="container">
            <h1 class="page-title mb-0"><?= ($what == 'edit_product') ? 'Edit Your Tractor' : 'Add Your Tractor' ?></h1>
        </div>
    </div>
    <!-- End of Page Header -->

    <!-- Start of Breadcrumb -->
    <nav class="breadcrumb-nav">
        <div class="container">
            <ul class="breadcrumb">
                <li><a href="<?= base_url() ?>">Home</a></li>
                <li><?= ($what == 'edit_product') ? 'Edit Product' : 'Add Product' ?></li>
            </ul>
        </div>
    </nav>
    <!-- End of Breadcrumb -->

    <!-- Start of Page Content -->
    <div class="page-content">
        <div class="container">
            <style>
                body,
                .sell-product-page {
                    background: #f6f9fb;
                }

                .main-sell-row {
                    display: flex;
                    justify-content: center;
                    align-items: flex-start;
                    min-height: auto;
                    padding: 20px 0;
                    gap: 0;
                    margin: 0px 10px;
                }

                .junction-section {
                    margin: 0px 30px;
                    padding: 20px 0 0 0;
                }

                .left-card {
                    width: 100%;
                    max-width: 650px;
                    min-width: 320px;
                    background: #fff;
                    box-shadow: 0 8px 32px 0 #0001, 0 1px 8px #0001;
                    display: flex;
                    flex-direction: column;
                    align-items: stretch;
                    overflow: visible;
                    position: relative;
                    margin-bottom: 20px;
                }

                .stepper {
                    display: flex;
                    align-items: center;
                    justify-content: center;
                    background: transparent;
                    margin-bottom: 0;
                    gap: 0;
                    user-select: none;
                    padding: 20px 24px 0 24px;
                }

                .stepper-step {
                    display: flex;
                    align-items: center;
                    gap: 10px;
                    font-family: 'Inter', Arial, sans-serif;
                }

                .stepper-circle {
                    width: 38px;
                    height: 38px;
                    border-radius: 50%;
                    background: #e0e4ea;
                    color: #555;
                    display: flex;
                    align-items: center;
                    justify-content: center;
                    font-weight: 700;
                    font-size: 1.18rem;
                    transition: background 0.2s, color 0.2s;
                    box-shadow: 0 2px 8px #0001;
                }

                .stepper-step.active .stepper-circle {
                    background: #d32f2f;
                    color: #fff;
                }

                .stepper-step.completed .stepper-circle {
                    background: #204080;
                    color: #fff;
                }

                .stepper-label {
                    font-size: 1.08rem;
                    font-weight: 500;
                    color: #222;
                    min-width: 120px;
                    text-align: left;
                    font-family: 'Inter', Arial, sans-serif;
                }

                .stepper-line {
                    width: 64px;
                    height: 2px;
                    background: #e0e4ea;
                    margin: 0 8px;
                    border-radius: 1px;
                }

                .left-card-inner {
                    padding: 0 18px 24px 18px;
                    display: flex;
                    flex-direction: column;
                    align-items: stretch;
                }

                .left-card h3 {
                    font-size: 1.18rem;
                    font-weight: 700;
                    margin-bottom: 18px;
                    color: #222;
                    text-align: left;
                    font-family: 'Inter', Arial, sans-serif;
                    margin-top: 20px;
                }

                .left-card label {
                    font-weight: 600;
                    color: #333;
                    margin-bottom: 4px;
                    font-family: 'Inter', Arial, sans-serif;
                }

                .left-card .form-control {
                    border-radius: 0;
                    border: 1.2px solid #e0e4ea;
                    padding: 12px 14px;
                    font-size: 1.05rem;
                    background: #f8fafc;
                    margin-bottom: 16px;
                    font-family: 'Inter', Arial, sans-serif;
                    box-shadow: none;
                    width: 100%;
                }

                .left-card .form-control:focus {
                    border-color: #204080;
                    outline: none;
                    box-shadow: 0 0 0 2px #20408022;
                }

                .form-row-2 {
                    display: flex;
                    gap: 12px;
                    margin-bottom: 0;
                }

                .form-row-2>* {
                    flex: 1;
                }

                .form-row-3 {
                    display: flex;
                    gap: 12px;
                    margin-bottom: 0;
                }

                .form-row-3>* {
                    flex: 1;
                }

                .left-card .btn-primary {
                    /* width: 100%; */
                    padding: 18px 0;
                    font-size: 1.18rem;
                    font-weight: 700;
                    border-radius: 12px;
                    margin-bottom: 12px;
                    background: #0d335d;
                    border: none;
                    letter-spacing: 1px;
                    font-family: 'Inter', Arial, sans-serif;
                    box-shadow: 0 2px 8px #0001;
                    transition: background 0.2s;
                }

                .left-card .btn-primary:hover {
                    background: #183060;
                }

                .left-card .back-link {
                    display: block;
                    text-align: center;
                    color: #204080;
                    text-decoration: none;
                    font-size: 1rem;
                    margin-top: 8px;
                    font-family: 'Inter', Arial, sans-serif;
                }

                .left-card .back-link:hover {
                    text-decoration: underline;
                }

                .right-content {
                    flex: 1;
                    min-width: 0;
                    padding-left: 40px;
                    display: flex;
                    flex-direction: column;
                    gap: 24px;
                    height: auto;
                }

                .why-section {
                    background: #eaf4ff;
                    /* border-radius: 12px; */
                    padding: 32px 32px 24px 32px;
                    margin-bottom: 0;
                    display: flex;
                    flex-direction: column;
                    align-items: flex-start;
                    min-width: 250px;
                }

                .why-section h4 {
                    font-size: 1.1rem;
                    font-weight: 700;
                    margin-bottom: 18px;
                    color: #204080;
                }

                .why-list {
                    list-style: none;
                    padding: 0;
                    margin: 0 0 18px 0;
                }

                .why-list li {
                    color: #28a745;
                    font-weight: 500;
                    margin-bottom: 6px;
                    display: flex;
                    align-items: center;
                    font-size: 1rem;
                }

                .why-list li i {
                    color: #28a745;
                    margin-right: 8px;
                    font-size: 1.1rem;
                }

                .eval-range {
                    background: #fff;
                    border-radius: 8px;
                    padding: 18px 24px;
                    margin: 18px 0 0 0;
                    box-shadow: 0 2px 8px #0001;
                    width: 100%;
                    max-width: 340px;
                }

                .eval-range-label {
                    font-size: 1rem;
                    color: #222;
                    font-weight: 600;
                    margin-bottom: 8px;
                }

                .eval-bar {
                    width: 100%;
                    height: 8px;
                    border-radius: 4px;
                    background: linear-gradient(90deg, #28a745 0%, #ffc107 50%, #dc3545 100%);
                    margin-bottom: 8px;
                }

                .eval-values {
                    display: flex;
                    justify-content: space-between;
                    font-size: 0.98rem;
                    color: #204080;
                    font-weight: 600;
                }

                .tractor-illustration {
                    margin: 32px 0 0 0;
                    width: 340px;
                    max-width: 100%;
                    display: flex;
                    flex-direction: column;
                    align-items: center;
                }

                .tractor-illustration img {
                    width: 220px;
                    margin-bottom: 12px;
                }

                .info-boxes {
                    display: grid;
                    grid-template-columns: repeat(3, 1fr);
                    gap: 18px;
                    margin: 32px 0 0 0;
                }

                .info-box {
                    background: #fff;
                    border-radius: 10px;
                    box-shadow: 0 2px 8px #0001;
                    padding: 18px 14px 14px 14px;
                    display: flex;
                    flex-direction: column;
                    align-items: flex-start;
                    min-height: 110px;
                }

                .info-box i {
                    font-size: 1.5rem;
                    color: #204080;
                    margin-bottom: 8px;
                }

                .info-box .info-title {
                    font-weight: 600;
                    color: #222;
                    margin-bottom: 4px;
                    font-size: 1rem;
                }

                .info-box .info-desc {
                    color: #666;
                    font-size: 0.98rem;
                }

                /* Form Steps */
                .form-step {
                    display: none;
                    animation: fadeIn 0.3s ease-in-out;
                }

                .form-step.active {
                    display: block;
                }

                @keyframes fadeIn {
                    from { opacity: 0; transform: translateY(10px); }
                    to { opacity: 1; transform: translateY(0); }
                }

                /* Alert styles */
                .alert {
                    padding: 12px 16px;
                    border-radius: 8px;
                    margin-top: 16px;
                    font-family: 'Inter', Arial, sans-serif;
                }

                .alert-success {
                    background-color: #d4edda;
                    border: 1px solid #c3e6cb;
                    color: #155724;
                }

                .alert-danger {
                    background-color: #f8d7da;
                    border: 1px solid #f5c6cb;
                    color: #721c24;
                }

                /* Google Maps */
                #map {
                    height: 200px;
                    width: 100%;
                    border-radius: 14px;
                    margin-bottom: 28px;
                    border: 1.5px solid #e0e4ea;
                }

                /* Responsive Styles */
                @media (max-width: 1200px) {
                    .main-sell-row {
                        flex-wrap: wrap;
                    }

                    .right-content {
                        padding-left: 0;
                        margin-top: 30px;
                        height: auto;
                    }
                }

                @media (max-width: 992px) {
                    .main-sell-row {
                        margin: 0 15px;
                    }

                    .left-card {
                        min-width: 300px;
                    }

                    .stepper {
                        padding: 30px 30px 0 30px;
                    }

                    .left-card-inner {
                        padding: 0 30px 30px 30px;
                    }

                    .why-section,
                    .eval-range {
                        min-width: 300px;
                    }
                }

                @media (max-width: 768px) {
                    .main-sell-row {
                        flex-direction: column;
                        padding: 20px 0 0 0;
                        margin: 0 10px;
                    }

                    .left-card {
                        width: 100%;
                        max-width: 100%;
                        min-width: auto;
                        margin: 0 auto;
                    }

                    .right-content {
                        width: 100%;
                        margin-top: 20px;
                    }

                    .why-section,
                    .eval-range {
                        width: 100%;
                        max-width: 100%;
                        min-width: auto;
                    }

                    .stepper-label {
                        min-width: 80px;
                        font-size: 0.95rem;
                    }

                    .stepper-line {
                        width: 30px;
                    }

                    .form-row-2 {
                        flex-direction: column;
                        gap: 0;
                    }

                    .info-boxes {
                        grid-template-columns: repeat(2, 1fr);
                    }
                }

                @media (max-width: 576px) {
                    .main-sell-row {
                        padding: 10px 0 0 0;
                        margin: 0 5px;
                    }

                    .stepper {
                        padding: 20px 15px 0 15px;
                    }

                    .stepper-circle {
                        width: 30px;
                        height: 30px;
                        font-size: 1rem;
                    }

                    .stepper-label {
                        min-width: 60px;
                        font-size: 0.85rem;
                    }

                    .stepper-line {
                        width: 15px;
                    }

                    .left-card-inner {
                        padding: 0 15px 20px 15px;
                    }

                    .left-card h3 {
                        font-size: 1.2rem;
                        margin-top: 30px;
                        margin-bottom: 20px;
                    }

                    .left-card .form-control {
                        padding: 14px 16px;
                        font-size: 1rem;
                        margin-bottom: 20px;
                    }

                    .left-card .btn-primary {
                        padding: 14px 0;
                        font-size: 1.05rem;
                    }

                    .why-section {
                        padding: 20px;
                    }

                    .info-boxes {
                        grid-template-columns: 1fr;
                    }
                }

                /* Junction Section Responsive Styles */
                @media (max-width: 767.98px) {
                    .junction-section {
                        margin: 0 5px !important;
                        padding: 24px 0 0 0 !important;
                    }

                    .junction-section .card {
                        min-width: 0;
                        margin-left: 0 !important;
                        margin-right: 0 !important;
                    }

                    .junction-section .row {
                        margin-left: 0 !important;
                        margin-right: 0 !important;
                    }

                    .junction-section .card-body {
                        padding: 18px 6px !important;
                    }

                    .junction-section h2.title {
                        font-size: 1.3rem !important;
                        text-align: left !important;
                        padding-left: 2px !important;
                    }
                }

                @media (max-width: 575.98px) {
                    .junction-section .card-body {
                        padding: 12px 2px !important;
                    }

                    .junction-section h2.title {
                        font-size: 1.1rem !important;
                    }
                }

                .form-nav-row {
                    display: flex;
                    justify-content: space-between;
                    align-items: center;
                    margin-top: 18px;
                }

                .left-card .btn,
                .left-card .btn-outline-primary,
                .left-card .btn-primary {
                    min-width: 80px;
                    padding: 6px 18px;
                    font-size: 0.95rem;
                    border-radius: 6px;
                    margin-bottom: 0;
                    font-weight: 600;
                    box-shadow: none;
                }
            </style>
            <!-- Tractor Inspection Checklist CSS -->
            <style>
                .tractor-checklist-section {
                    background: #f6f9fb;
                    border-radius: 14px;
                    box-shadow: 0 2px 8px #0001;
                    padding: 28px 18px 36px 18px;
                    margin-bottom: 24px;
                    margin-top: 24px;
                }

                .tractor-checklist-title {
                    font-size: 1.3rem;
                    font-weight: 700;
                    margin-bottom: 18px;
                }

                .checklist-tabs {
                    display: flex;
                    gap: 0;
                    margin-bottom: 0;
                }

                .checklist-tab {
                    background: #fff;
                    border: 1px solid #e0e4ea;
                    border-bottom: none;
                    border-radius: 8px 8px 0 0;
                    padding: 8px 18px;
                    font-size: 1.05rem;
                    font-weight: 600;
                    color: #222;
                    cursor: pointer;
                    margin-right: 2px;
                    transition: background 0.2s, color 0.2s;
                    outline: none;
                }

                .checklist-tab.active {
                    background: #f6f9fb;
                    color: #204080;
                    border-bottom: 2px solid #f6f9fb;
                }

                .checklist-tab:not(.active):hover {
                    background: #f0f2f7;
                }

                .checklist-tab-content {
                    background: #fff;
                    border-radius: 0 0 8px 8px;
                    box-shadow: 0 2px 8px #0001;
                    padding: 18px 12px 12px 12px;
                    margin-top: -1px;
                }

                .checklist-items {
                    display: flex;
                    flex-wrap: wrap;
                    gap: 0;
                }

                .checklist-col {
                    flex: 1 1 33%;
                    min-width: 120px;
                    max-width: 33%;
                }

                .checklist-list {
                    list-style: none;
                    padding: 0;
                    margin: 0 0 0 0;
                }

                .checklist-list li {
                    display: flex;
                    align-items: center;
                    font-size: 1.02rem;
                    margin-bottom: 12px;
                    color: #181818;
                }

                .checklist-icon {
                    color: #d44d53;
                    font-size: 1.1rem;
                    margin-right: 8px;
                    display: flex;
                    align-items: center;
                }

                .checklist-items .checklist-list {
                    display: grid;
                    grid-template-columns: repeat(3, 1fr);
                    gap: 0 18px;
                }

                @media (max-width: 991px) {
                    .checklist-col {
                        min-width: 45%;
                        max-width: 100%;
                    }
                }

                @media (max-width: 600px) {
                    .tractor-checklist-section {
                        padding: 10px 2px;
                    }

                    .tractor-checklist-title {
                        font-size: 1.1rem;
                    }

                    .checklist-items {
                        display: grid;
                        grid-template-columns: 1fr 1fr;
                        gap: 0;
                    }

                    .checklist-col {
                        min-width: 0;
                        max-width: 100%;
                        width: 100%;
                    }

                    .checklist-tab {
                        padding: 8px 10px;
                        font-size: 1rem;
                    }

                    .checklist-tab-content {
                        padding: 10px 4px 8px 4px;
                    }
                }
            </style>
            <!-- Validation error style: only red border, no error text -->
            <style>
                .is-invalid,
                .form-control.is-invalid,
                .select2-container--default .select2-selection--single.is-invalid {
                    border-color: #e53935 !important;
                    background: inherit !important;
                }
            </style>

            <div class="sell-product-page">
                <div class="main-sell-row container-fluid" style="justify-content:center;align-items:center;padding:40px 0 0 0;">
                    <!-- Left Card (now centered and wider) -->
                    <div class="left-card" style="margin:auto;max-width:900px;width:100%;min-width:unset;">
                        <!-- Stepper INSIDE the card -->
                        <div class="stepper" id="formStepper">
                            <div class="stepper-step active" data-step="1">
                                <div class="stepper-circle">1</div>
                                <div class="stepper-label">Location & Contact</div>
                            </div>
                            <div class="stepper-line"></div>
                            <div class="stepper-step" data-step="2">
                                <div class="stepper-circle">2</div>
                                <div class="stepper-label">Product Details</div>
                            </div>
                            <div class="stepper-line"></div>
                            <div class="stepper-step" data-step="3">
                                <div class="stepper-circle">3</div>
                                <div class="stepper-label">Images</div>
                            </div>
                        </div>
                        <div class="left-card-inner" style="padding:0 32px 32px 32px;">
                            <form id="step1Form" method="post"
                                action="<?= base_url('index.php/action/add_product'); ?>"
                                onsubmit="return uploadandform('<?= base_url('index.php/action/add_product') ?>','post',this,'image_name','progress_value_sc','prog_valie_text','Show_Errors_987','loader_post_upload','1','uni_loader_prog_status');"
                                enctype="multipart/form-data">
                                <input type="hidden" name="what" value="<?=$what?>">
                                <input type="hidden" name="product_id" value="<?=$product_id?>">
                                <!-- Step 1: Location & Contact -->
                                <div class="form-step active" id="step1">
                                    <h3>Your Location & Contact Information</h3>
                                    <div class="form-row-2">
                                        <div>
                                            <label>State <span class="required-star">*</span></label>
                                            <select class="form-control" name="state" id="stateSelect" onchange="load_new_citys(this)">
                                                <option value="">Select State</option>
                                                <?php
                                                $states = $this->db->query("SELECT * FROM yn_site_states WHERE status = 1 ORDER BY state_name ASC")->result_array();
                                                foreach ($states as $state) { ?>
                                                    <option value="<?= $state['state_id'] ?>" <?=(@$product['state'] == $state['state_id']) ? 'selected':''?>><?= $state['state_name'] ?></option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                        <div>
                                            <label>City <span class="required-star">*</span></label>
                                            <select class="form-control" name="city" id="get_cities_data">
                                                <?php
                                                if (isset($product['state']) && $product['state'] != '') {
                                                    $state_id = $product['state'];
                                                    $cities = $this->db->query("SELECT * FROM yn_site_cities WHERE state_id = '$state_id' ORDER BY city_name ASC")->result_array();
                                                    foreach ($cities as $city) { ?> 
                                                    <option value="<?=$city['city_id']?>" <?=($product['city'] == $city['city_id']) ? 'selected':''?>><?=$city['city_name']?></option>
                                                    <?php } } else { ?>
                                                <option value="">Select City</option> <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                    <label>Location</label>
                                    <!-- <div id="map"></div> -->
                                    <input type="hidden" name="latitude" id="latitude2" value="<?=@$product['latitude']?>">
                                    <input type="hidden" name="longitude" id="longitude2" value="<?=@$product['latitude']?>">
                                    <input type="text" class="form-control" name="address" id="autocomplete2" placeholder="Enter your address" value="<?=@$product['address']?>">
                                    <button type="button" class="btn btn-primary" id="nextBtn1">NEXT</button>
 

                                </div>
                                <!-- Step 2: Product Details -->
                                <div class="form-step" id="step2">
                                    <h3>Product Details</h3>
                                    <div class="form-row-3">
                                        <div>
                                            <label>Product Name <span class="required-star">*</span></label>
                                            <input type="text" class="form-control" name="p_name" id="productName" placeholder="Enter product name" value="<?=@$product['p_name']?>">
                                        </div>
                                        <div>
                                            <label>Brand <span class="required-star">*</span></label>
                                            <select class="form-control" name="p_brand_name" id="brandSelect">
                                                <option value="">Select Brand</option>
                                                <?php
                                                $brands = $this->db->query("SELECT * FROM yn_site_tags WHERE stg_type = 'Brands' ORDER BY stg_name ASC")->result_array();
                                                foreach ($brands as $brand) { ?>
                                                    <option value="<?= $brand['stg_tgid'] ?>" <?=(@$product['p_brand_name'] == $brand['stg_tgid']) ? 'selected':''?>><?= $brand['stg_name'] ?></option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                       
                                        <div>
                                            <label>Category <span class="required-star">*</span></label>
                                            <select class="form-control" name="p_category" id="categorySelect" onchange="load_subcats(this)">
                                                <option value="">Select Category</option>
                                                <?php
                                                $categories = $this->db->query("SELECT * FROM yn_site_catagory ORDER BY sid ASC")->result_array();
                                                foreach ($categories as $category) { ?>
                                                    <option value="<?= $category['ctid'] ?>" <?=(@$product['p_category'] == $category['ctid']) ? 'selected':''?>><?= $category['name'] ?></option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form-row-3">
                                        <div>
                                            <label>Sub Category</label>
                                            <select class="form-control" name="p_sub_category" id="get_subcat_data">
                                                <option value="">Select Sub Category</option>
                                            </select>
                                        </div>
                                        <div>
                                            <label>Model</label>
                                            <input type="text" class="form-control" name="p_model" id="modelInput" placeholder="e.g., 5075E, 575DI" value="<?=@$product['p_model']?>">
                                        </div>
                                        <div>
                                            <label>Year</label>
                                            <select class="form-control" name="p_year" id="yearSelect">
                                                <option value="">Select Manufacturing Year</option>
                                                <?php for ($year = date('Y'); $year >= 1990; $year--): ?>
                                                    <option value="<?= $year ?>" <?=(@$product['p_year'] == $year) ? 'selected':''?>><?= $year ?></option>
                                                <?php endfor; ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form-row-3">
                                        <div>
                                            <label>Tyre Condition <span class="required-star">*</span></label>
                                            <select class="form-control" name="tyre_condition" id="tyreConditionSelect">
                                                <option value="">Select Tyre Condition</option>
                                                <?php
                                                $tyreConditions = $this->db->query("SELECT * FROM yn_site_tags WHERE stg_type = 'tyre_type' ORDER BY stg_name ASC")->result_array();
                                                foreach ($tyreConditions as $condition) { ?>
                                                    <option value="<?= $condition['stg_tgid'] ?>" <?=(@$product['tyre_condition'] == $condition['stg_tgid']) ? 'selected':''?>><?= $condition['stg_name'] ?></option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                        <div>
                                            <label>Engine Condtion <span class="required-star">*</span></label>
                                            <select class="form-control" name="engine_type" id="engineTypeSelect">
                                                <option value="">Select Engine Type</option>
                                                <?php
                                                $engineTypes = $this->db->query("SELECT * FROM yn_site_tags WHERE stg_type = 'engine_typ' ORDER BY stg_name ASC")->result_array();
                                                foreach ($engineTypes as $engineType) { ?>
                                                    <option value="<?= $engineType['stg_tgid'] ?>" <?=(@$product['engine_type'] == $engineType['stg_tgid']) ? 'selected':''?>><?= $engineType['stg_name'] ?></option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                        <div>
                                            <label>Engine Power</label>
                                            <input type="text" class="form-control" name="engine_power" id="enginePower" placeholder="Enter engine power" value="<?=@$product['engine_power']?>">
                                        </div>
                                    </div>
                                    <div class="form-row-3">
                                        <div>
                                            <label>RTO NO.</label>
                                            <input type="text" class="form-control" name="rto_no" id="rtoNo" placeholder="Enter RTO number" value="<?=@$product['rto_no']?>">
                                        </div>
                                        <div>
                                            <label>Financier / NOC</label>
                                            <select class="form-control" name="financier_noc" id="financierNoc">
                                                <option value="">Select Option</option>
                                                <option value="Yes" <?=(@$product['financier_noc'] == 'Yes') ? 'selected':''?>>Yes</option>
                                                <option value="No" <?=(@$product['financier_noc'] == 'No') ? 'selected':''?>>No</option>
                                            </select>
                                        </div>
                                        <div>
                                            <label>RC</label>
                                            <select class="form-control" name="rc" id="rcSelect">
                                                <option value="">Select Option</option>
                                                <option value="Yes" <?=(@$product['rc'] == 'Yes') ? 'selected':''?>>Yes</option>
                                                <option value="No" <?=(@$product['rc'] == 'No') ? 'selected':''?>>No</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form-row-2">
                                        <div>
                                            <label>Price <span class="required-star">*</span></label>
                                            <input type="text" class="form-control" name="p_price" id="p_price" placeholder="Enter price" value="<?=@$product['p_price']?>">
                                        </div>
                                         <div>
                                            <label>Croptype (for Harvestors)</label>
                                            <select class="form-control" name="croptype" id="croptype">
                                                <option value="">Select Croptype (optional)</option>
                                                <?php
                                                $croptypes = $this->db->query("SELECT stg_tgid, stg_name FROM yn_site_tags WHERE stg_type = 'crop_type' ORDER BY stg_name ASC")->result_array();
                                                foreach ($croptypes as $crop) { ?>
                                                    <option value="<?= $crop['stg_tgid'] ?>" <?=(@$product['croptype'] == $crop['stg_tgid']) ? 'selected':''?>><?= htmlspecialchars($crop['stg_name']) ?></option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form-row-3">
                                        <div style="flex:1;">
                                            <label>Description <span class="required-star">*</span></label>
                                            <textarea class="form-control" name="p_descp" id="p_descp" placeholder="Enter product description" rows="3"><?=@$product['p_descp']?></textarea>
                                        </div>
                                    </div>

                                    <!-- Tractor Inspection Checklist Section (HTML only, formatted) -->
                                    <div class="tractor-checklist-section">
                                        <div class="tractor-checklist-title">Tractor Inspection Checklist</div>
                                        <div class="checklist-tabs">
                                            <button class="checklist-tab active" type="button" onclick="showChecklistTab(event, 'exterior')">Exterior</button>
                                            <button class="checklist-tab" type="button" onclick="showChecklistTab(event, 'interior')">Interior</button>
                                            <button class="checklist-tab" type="button" onclick="showChecklistTab(event, 'other')">Others</button>
                                        </div>
                                        <div class="checklist-tab-content" id="checklist-tab-exterior">
                                            <div class="checklist-items">
                                                <ul class="checklist-list">
                                                    <?php
                                                    $exterior_tags = $this->db->query("SELECT * FROM yn_site_tags WHERE stg_type = 'exterior' ORDER BY stg_name ASC")->result_array();
                                                    $exterior_checklist = isset($product['exterior_checklist']) ? explode(',', $product['exterior_checklist']) : array();
                                                    foreach ($exterior_tags as $tag): ?>
                                                        <li><label style="display:flex;align-items:center;gap:6px;"><input type="checkbox" name="exterior_checklist[]" value="<?= htmlspecialchars($tag['stg_tgid']) ?>" <?= in_array($tag['stg_tgid'], $exterior_checklist) ? 'checked' : '' ?>><span class="checklist-icon"><i class="fa fa-cogs"></i></span><?= htmlspecialchars($tag['stg_name']) ?></label></li>
                                                    <?php endforeach; ?>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="checklist-tab-content" id="checklist-tab-interior" style="display:none;">
                                            <div class="checklist-items">
                                                <ul class="checklist-list">
                                                    <?php
                                                    $interior_tags = $this->db->query("SELECT * FROM yn_site_tags WHERE stg_type = 'interior' ORDER BY stg_name ASC")->result_array();
                                                    $interior_checklist = isset($product['interior_checklist']) ? explode(',', $product['interior_checklist']) : array();
                                                    foreach ($interior_tags as $tag): ?>
                                                        <li><label style="display:flex;align-items:center;gap:6px;"><input type="checkbox" name="interior_checklist[]" value="<?= htmlspecialchars($tag['stg_tgid']) ?>" <?= in_array($tag['stg_tgid'], $interior_checklist) ? 'checked' : '' ?>><span class="checklist-icon"><i class="fa fa-cogs"></i></span><?= htmlspecialchars($tag['stg_name']) ?></label></li>
                                                    <?php endforeach; ?>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="checklist-tab-content" id="checklist-tab-other" style="display:none;">
                                            <div class="checklist-items">
                                                <ul class="checklist-list">
                                                    <?php
                                                    $other_tags = $this->db->query("SELECT * FROM yn_site_tags WHERE stg_type = 'other' ORDER BY stg_name ASC")->result_array();
                                                    $other_checklist = isset($product['other_checklist']) ? explode(',', $product['other_checklist']) : array();
                                                    foreach ($other_tags as $tag): ?>
                                                        <li><label style="display:flex;align-items:center;gap:6px;"><input type="checkbox" name="other_checklist[]" value="<?= htmlspecialchars($tag['stg_tgid']) ?>" <?= in_array($tag['stg_tgid'], $other_checklist) ? 'checked' : '' ?>><span class="checklist-icon"><i class="fa fa-cogs"></i></span><?= htmlspecialchars($tag['stg_name']) ?></label></li>
                                                    <?php endforeach; ?>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-nav-row">
                                        <button type="button" class="btn btn-outline-primary btn-sm" id="backLink2">Back</button>
                                        <button type="button" class="btn btn-primary btn-sm" id="nextBtn2">Next</button>
                                    </div>
                                </div>

                                <!-- Step 3: Images (Placeholder) -->
                                <div class="form-step" id="step3">
                                    <h3>Upload Images</h3>
                                    <label>Product Images <?= ($what == 'edit_product') ? '' : '<span class="required-star">*</span>' ?></label>
                                    <input type="file" class="form-control" name="p_image1" id="productImages" accept="image/*">
                                    <small class="text-muted">
                                        <?php if ($what == 'edit_product'): ?>
                                        Leave empty to keep the existing image. Upload a new image to replace the current one.
                                        <?php else: ?>
                                        You can select multiple images. Maximum 5 images allowed.
                                        <?php endif; ?>
                                    </small>
                                    
                                    <?php if ($what == 'edit_product' && !empty($product['p_image1'])): ?>
                                    <div style="margin-top: 15px; padding: 15px; background: #f8f9fa; border-radius: 8px; border: 1px solid #dee2e6;">
                                        <label style="font-weight: 600; margin-bottom: 10px; display: block;">Current Image:</label>
                                        <img src="<?= base_url('assets/avator/upload/' . $product['p_image1']) ?>" alt="Current Product Image" style="max-width: 200px; max-height: 150px; border-radius: 5px; border: 1px solid #ddd;">
                                    </div>
                                    <?php endif; ?>
                                    <input type="hidden" name="old_img" value="<?=@$product['p_cover']?>">

                                    <div class="form-nav-row">
                                        <button type="button" class="btn btn-outline-primary btn-sm" id="backLink3">Back</button>
                                        <button type="submit" class="btn btn-primary btn-sm" id="submitBtn"><?= ($what == 'edit_product') ? 'Update Product' : 'Submit' ?></button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Why Tractor Yaari Section -->
            <div style="background:#f8fbfd;">
                <div class="container-fluid junction-section">
                    <h2 class="title ls-normal mb-4 mt-2 pt-1">Why Tractor Yaari ?</h2>
                    <div class="row" style="display:flex;align-items:center;flex-wrap:wrap;">
                        <!-- Left: Cards -->
                        <div class="col-12 col-lg-8" style="display:flex;flex-wrap:wrap;gap:18px;">
                            <div class="card shadow-sm border-0 h-100 flex-fill" style="background:#F6F6F6;min-width:260px;max-width:calc(33% - 12px);flex:1 1 260px;">
                                <div class="card-body text-center py-4">
                                    <i class="fas fa-star" style="font-size:2.5rem;color:#ffc107;margin-bottom:18px;"></i>
                                    <h4 class="card-title font-weight-bold mb-2">Priority to Customers</h4>
                                    <p class="card-text mb-0">10 Lakh+ Monthly Users.</p>
                                </div>
                            </div>
                            <div class="card shadow-sm border-0 h-100 flex-fill" style="background:#F6F6F6;min-width:260px;max-width:calc(33% - 12px);flex:1 1 260px;">
                                <div class="card-body text-center py-4">
                                    <i class="fas fa-user-tie" style="font-size:2.5rem;color:#3b82f6;margin-bottom:18px;"></i>
                                    <h4 class="card-title font-weight-bold mb-2">Fair Market Price</h4>
                                    <p class="card-text mb-0">Get a fair price for all the farm machines.</p>
                                </div>
                            </div>
                            <div class="card shadow-sm border-0 h-100 flex-fill" style="background:#F6F6F6;min-width:260px;max-width:calc(33% - 12px);flex:1 1 260px;">
                                <div class="card-body text-center py-4">
                                    <i class="fas fa-rupee-sign" style="font-size:2.5rem;color:#e53935;margin-bottom:18px;"></i>
                                    <h4 class="card-title font-weight-bold mb-2">Free of Cost</h4>
                                    <p class="card-text mb-0">All services provided free of cost.</p>
                                </div>
                            </div>
                            <div class="card shadow-sm border-0 h-100 flex-fill" style="background:#F6F6F6;min-width:260px;max-width:calc(33% - 12px);flex:1 1 260px;">
                                <div class="card-body text-center py-4">
                                    <i class="fas fa-certificate" style="font-size:2.5rem;color:#222;margin-bottom:18px;"></i>
                                    <h4 class="card-title font-weight-bold mb-2">All services provided free of cost.</h4>
                                    <p class="card-text mb-0">Here we provide genuine buyers.</p>
                                </div>
                            </div>
                            <div class="card shadow-sm border-0 h-100 flex-fill" style="background:#F6F6F6;min-width:260px;max-width:calc(33% - 12px);flex:1 1 260px;">
                                <div class="card-body text-center py-4">
                                    <i class="fas fa-bell" style="font-size:2.5rem;color:#222;margin-bottom:18px;"></i>
                                    <h4 class="card-title font-weight-bold mb-2">Instant Notification</h4>
                                    <p class="card-text mb-0">Get immediate SMS notification on your mobile.</p>
                                </div>
                            </div>
                            <div class="card shadow-sm border-0 h-100 flex-fill" style="background:#F6F6F6;min-width:260px;max-width:calc(33% - 12px);flex:1 1 260px;">
                                <div class="card-body text-center py-4">
                                    <i class="fas fa-headset" style="font-size:2.5rem;color:#222;margin-bottom:18px;"></i>
                                    <h4 class="card-title font-weight-bold mb-2">Customer Support</h4>
                                    <p class="card-text mb-0">Call us at +91-97709-74974.</p>
                                </div>
                            </div>
                        </div>
                        <!-- Right: Image -->
                        <div class="col-12 col-lg-4 d-flex justify-content-center align-items-center" style="min-height:320px;">
                            <img src="<?= base_url('assets/theme/v2/assets/images/demos/demo1/sliders/tractor1.png') ?>" alt="Tractor" style="max-width:100%;height:auto;max-height:320px;object-fit:contain;">
                        </div>
                    </div>
                </div>
            </div>
            <style>
                @media (max-width: 991.98px) {
                    .junction-section .row {
                        flex-direction: column !important;
                    }

                    .junction-section .col-lg-8,
                    .junction-section .col-lg-4 {
                        max-width: 100%;
                        flex: 0 0 100%;
                    }

                    .junction-section img {
                        margin-top: 24px;
                    }
                }
            </style>

            <!-- Tractor Yaari USP/Intro Section -->
            <div style="background:#f8f9fa; padding:32px 18px; border-radius:10px; margin:32px auto; max-width:100%;">
                <h3 style="font-weight:600; font-size:1.5rem; border-left:4px solid #2d6fa3; padding-left:12px; margin-bottom:18px;">Tractor Yaari is the smartest way to sell your tractor</h3>
                <div style="margin-bottom:10px; font-weight:600;">Want to upgrade your tractor with zero hassle?</div>
                <div style="margin-bottom:10px; font-weight:600;">Looking for genuine buyers and the best price?</div>
                <div style="margin-bottom:18px; font-weight:600;">Ready to experience a smooth, transparent selling journey?</div>
                <div style="color:#444; font-size:1.05rem;">
                    At Tractor Yaari, we make selling your old tractor easy, safe, and rewarding. Our platform connects you directly with verified buyers, ensuring you get the best value without any middlemen or hidden charges. From instant listing to expert support, we handle everything so you can focus on what matters most—your farm and your future. Join Tractor Yaari today and discover a new, trustworthy way to sell your tractor. Hassle-free, transparent, and always in your favor—because at Tractor Yaari, your satisfaction drives us!
                </div>
            </div>
        </div>
    </div>
    <!-- End of Page Content -->
</main>
<!-- End of Main -->

<script src="https://kit.fontawesome.com/7b8e1e4e3a.js" crossorigin="anonymous"></script>
<script>
    // Global variables
    let map, marker;
    let currentStep = 1;

    // Initialize Google Maps (without API key for now)
    function initMap() {
        // Check if Google Maps is available
        if (typeof google === 'undefined' || typeof google.maps === 'undefined') {
            console.log('Google Maps not available - using fallback location picker');
            setupFallbackLocationPicker();
            return;
        }

        try {
            // Default location (India center)
            const defaultLocation = {
                lat: 20.5937,
                lng: 78.9629
            };

            map = new google.maps.Map(document.getElementById('map'), {
                zoom: 5,
                center: defaultLocation,
                mapTypeControl: false,
                streetViewControl: false
            });

            marker = new google.maps.Marker({
                position: defaultLocation,
                map: map,
                draggable: true
            });

            // Set initial coordinates
            document.getElementById('latitude').value = defaultLocation.lat;
            document.getElementById('longitude').value = defaultLocation.lng;

            // Handle map click
            map.addListener('click', function(event) {
                const position = event.latLng;
                marker.setPosition(position);
                document.getElementById('latitude').value = position.lat();
                document.getElementById('longitude').value = position.lng();

                // Reverse geocode to get address
                const geocoder = new google.maps.Geocoder();
                geocoder.geocode({
                    location: position
                }, function(results, status) {
                    if (status === 'OK' && results[0]) {
                        document.getElementById('address').value = results[0].formatted_address;
                    }
                });
            });

            // Handle marker drag
            marker.addListener('dragend', function() {
                const position = marker.getPosition();
                document.getElementById('latitude').value = position.lat();
                document.getElementById('longitude').value = position.lng();

                // Reverse geocode to get address
                const geocoder = new google.maps.Geocoder();
                geocoder.geocode({
                    location: position
                }, function(results, status) {
                    if (status === 'OK' && results[0]) {
                        document.getElementById('address').value = results[0].formatted_address;
                    }
                });
            });

        } catch (error) {
            console.log('Google Maps error:', error);
            setupFallbackLocationPicker();
        }
    }

    // Fallback location picker when Google Maps is not available
    function setupFallbackLocationPicker() {
        const mapDiv = document.getElementById('map');
        mapDiv.innerHTML = `
        <div style="height: 200px; background: #f8f9fa; border: 2px dashed #dee2e6; display: flex; align-items: center; justify-content: center; flex-direction: column;">
            <i class="fas fa-map-marker-alt" style="font-size: 2rem; color: #6c757d; margin-bottom: 10px;"></i>
            <p style="color: #6c757d; margin: 0; text-align: center;">Location picker not available<br>Please enter your address manually</p>
        </div>
    `;

        // Set default coordinates for India
        document.getElementById('latitude').value = '20.5937';
        document.getElementById('longitude').value = '78.9629';
    }

    // Step navigation functions
    function setStepper(step) {
        const steps = document.querySelectorAll('.stepper-step');
        steps.forEach((el, idx) => {
            el.classList.remove('active', 'completed');
            if (idx + 1 < step) el.classList.add('completed');
            else if (idx + 1 === step) el.classList.add('active');
        });
    }

    function showStep(step) {
        // Hide all steps
        document.querySelectorAll('.form-step').forEach(el => {
            el.classList.remove('active');
        });

        // Show current step
        document.getElementById('step' + step).classList.add('active');

        // Update stepper
        setStepper(step);
        currentStep = step;
    }




    // Validation for required fields on Next button (Step 1 and Step 2) - no error text, only red border
    function validateStep2() {
        let valid = true;

        function markInvalid(selector) {
            const el = document.querySelector(selector);
            if (!el) return;
            el.classList.add('is-invalid');
            valid = false;
        }

        function clearInvalid(selector) {
            const el = document.querySelector(selector);
            if (!el) return;
            el.classList.remove('is-invalid');
        }
        // Product Name
        const pname = document.getElementById('productName');
        if (!pname.value.trim()) markInvalid('#productName');
        else clearInvalid('#productName');
        // Brand
        const brand = document.getElementById('brandSelect');
        if (!brand.value) markInvalid('#brandSelect');
        else clearInvalid('#brandSelect');
        // Category
        const cat = document.getElementById('categorySelect');
        if (!cat.value) markInvalid('#categorySelect');
        else clearInvalid('#categorySelect');
        // Price
        const price = document.getElementById('p_price');
        if (!price.value.trim()) markInvalid('#p_price');
        else clearInvalid('#p_price');
        // Description
        const desc = document.getElementById('p_descp');
        if (!desc.value.trim()) markInvalid('#p_descp');
        else clearInvalid('#p_descp');
        // Tyre Condition
        const tyre = document.getElementById('tyreConditionSelect');
        if (!tyre.value) markInvalid('#tyreConditionSelect');
        else clearInvalid('#tyreConditionSelect');
        // Engine Condition
        const engine = document.getElementById('engineTypeSelect');
        if (!engine.value) markInvalid('#engineTypeSelect');
        else clearInvalid('#engineTypeSelect');
        // Note: Image is uploaded in Step 3. Do not validate here or it blocks navigation to Step 3.
        return valid;
    }

    function validateStep1() {
        let valid = true;

        function markInvalid(selector) {
            const el = document.querySelector(selector);
            if (!el) return;
            el.classList.add('is-invalid');
            valid = false;
        }

        function clearInvalid(selector) {
            const el = document.querySelector(selector);
            if (!el) return;
            el.classList.remove('is-invalid');
        }
        // State
        const state = document.getElementById('stateSelect');
        if (!state.value) markInvalid('#stateSelect');
        else clearInvalid('#stateSelect');
        // City
        const city = document.getElementById('get_cities_data');
        if (!city.value) markInvalid('#get_cities_data');
        else clearInvalid('#get_cities_data');
        return valid;
    }

    // Form validation and navigation
    const nextBtn1 = document.getElementById('nextBtn1');
    if (nextBtn1) {
        nextBtn1.addEventListener('click', function() {
            if (validateStep1()) {
                showStep(2);
            }
        });
    }

    const nextBtn2 = document.getElementById('nextBtn2');
    if (nextBtn2) {
        nextBtn2.addEventListener('click', function() {
            if (validateStep2()) {
                showStep(3);
            }
        });
    }

    document.getElementById('submitBtn').addEventListener('click', function() {
        // Here you would submit the form data to your backend
        // alert('Form submitted successfully!');
        // You can redirect or show success message
    });

    // Handle form submission with page refresh
    document.getElementById('step1Form').addEventListener('submit', function(e) {
        // Let uploadandform handle the submission
        // After submission, redirect to profile page
        setTimeout(function() {
            <?php if ($what == 'edit_product'): ?>
            // For edit mode, redirect to profile page with success message
            window.location.href = '<?= base_url("profile") ?>?edit_success=1';
            <?php else: ?>
            // For add mode, refresh the page
            location.reload();
            <?php endif; ?>
        }, 2000); // Wait 2 seconds for uploadandform to complete
    });

    // Back navigation
    document.getElementById('backLink2').addEventListener('click', function(e) {
        e.preventDefault();
        showStep(1);
    });

    document.getElementById('backLink3').addEventListener('click', function(e) {
        e.preventDefault();
        showStep(2);
    });

    // Initialize map when page loads
    document.addEventListener('DOMContentLoaded', function() {
        initMap();
        
        // If editing, load subcategories for the selected category
        <?php if ($what == 'edit_product' && isset($product['p_category']) && $product['p_category'] != ''): ?>
        load_subcats_for_edit('<?= $product['p_category'] ?>', '<?= $product['p_sub_category'] ?>');
        <?php endif; ?>
    });
    
    // Function to load subcategories for edit mode
    function load_subcats_for_edit(categoryId, selectedSubCategory) {
        if (categoryId) {
            fetch('<?= base_url("action/load_subcategories") ?>?category_id=' + categoryId)
                .then(response => response.text())
                .then(data => {
                    const subcatSelect = document.getElementById('get_subcat_data');
                    subcatSelect.innerHTML = data;
                    
                    // Set the selected subcategory if it exists
                    if (selectedSubCategory) {
                        subcatSelect.value = selectedSubCategory;
                    }
                })
                .catch(error => {
                    console.error('Error loading subcategories:', error);
                });
        }
    }
</script>

<script>
    // Tractor Inspection Checklist tab JS
    function showChecklistTab(evt, tab) {
        var tabcontent = document.querySelectorAll('.checklist-tab-content');
        var tablinks = document.querySelectorAll('.checklist-tab');
        tabcontent.forEach(function(tc) {
            tc.style.display = 'none';
        });
        tablinks.forEach(function(tl) {
            tl.classList.remove('active');
        });
        document.getElementById('checklist-tab-' + tab).style.display = '';
        evt.currentTarget.classList.add('active');
    }
</script>
<style>
    .required-star {
        color: #e53935 !important;
        margin-left: 2px;
        font-size: 1.1em;
    }
</style>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Step 1 Next
        var nextBtn1 = document.getElementById('nextBtn1');
        if (nextBtn1) {
            nextBtn1.addEventListener('click', function() {
                if (validateStep1()) {
                    showStep(2);
                }
            });
        }
        // Step 2 Next
        var nextBtn2 = document.getElementById('nextBtn2');
        if (nextBtn2) {
            nextBtn2.addEventListener('click', function() {
                if (validateStep2()) {
                    showStep(3);
                }
            });
        }
        // Step 2 Back
        var backLink2 = document.getElementById('backLink2');
        if (backLink2) {
            backLink2.addEventListener('click', function() {
                showStep(1);
            });
        }
        // Step 3 Back
        var backLink3 = document.getElementById('backLink3');
        if (backLink3) {
            backLink3.addEventListener('click', function() {
                showStep(2);
            });
        }
    });
</script>
<script>
    function showChecklistTab(evt, tab) {
        var tabcontent = document.querySelectorAll('.checklist-tab-content');
        var tablinks = document.querySelectorAll('.checklist-tab');
        tabcontent.forEach(function(tc) {
            tc.style.display = 'none';
        });
        tablinks.forEach(function(tl) {
            tl.classList.remove('active');
        });
        document.getElementById('checklist-tab-' + tab).style.display = '';
        evt.currentTarget.classList.add('active');
    }
</script>
<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAH0ovld3PKMKQwLH5F_Qnjtf7WMWZsrhM&libraries=places">
</script>
 
<script script>
    let autocomplete2;
 
    function initAutocomplete2() {
        const input = document.getElementById('autocomplete2');
        if (!input) return;
 
        autocomplete2 = new google.maps.places.Autocomplete(input, {
            componentRestrictions: {
                country: "in"
            },
            fields: ["geometry", "address_components"]
        });
 
        autocomplete2.addListener("place_changed", () => {
            const place = autocomplete2.getPlace();
 
            if (!place.geometry || !place.address_components) {
                console.warn("Place details missing.");
                return;
            }
 
            const lat = place.geometry.location.lat();
            const lng = place.geometry.location.lng();
 
            document.getElementById("latitude2").value = lat;
            document.getElementById("longitude2").value = lng;
 
            const city = place.address_components.find(c => c.types.includes("locality"))?.long_name || "";
            const country = place.address_components.find(c => c.types.includes("country"))?.long_name || "";
 
            console.log("City:", city, "| Country:", country);
        });
    }
 
    // Initialize on load
    window.addEventListener("load", () => {
        initAutocomplete2();
    });
</script>
 