<!-- main-area -->
<main class="main-area fix">

    <!-- breadcrumb-area -->
    <!-- <section class="breadcrumb__area breadcrumb__bg" data-background="assets/img/bg/breadcrumb_bg.jpg">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="breadcrumb__content">
                        <h3 class="title">
                            <?php
                            if (isset($_GET['type']) && !empty($_GET['type'])) {
                                echo htmlspecialchars($_GET['type']) . ' Blogs';
                            } elseif (isset($_GET['q']) && !empty($_GET['q'])) {
                                echo 'Search Results for "' . htmlspecialchars($_GET['q']) . '"';
                            } else {
                                echo 'Latest Blogs';
                            }
                            ?>
                        </h3>
                    </div>
                </div>
            </div>
        </div>

    </section> -->
    <!-- breadcrumb-area-end -->

    <!-- blog-area -->
    <section class="blog-area section-py-60 mb-3">
        <div class="container">
            <div class="row">
                <div class="col-xl-9 col-lg-8">
                    <!-- Active Filters Display -->
                    <?php if (isset($_GET['type']) || isset($_GET['q']) || isset($_GET['tag'])): ?>
                        <div class="mb-4 p-3 bg-light rounded">
                            <h6 class="mb-2">Active Filters:</h6>
                            <div class="d-flex flex-wrap">
                                <?php if (isset($_GET['type']) && !empty($_GET['type'])): ?>
                                    <span class="badge bg-primary me-2 mb-2">
                                        Type: <?= htmlspecialchars($_GET['type']) ?>
                                        <a href="<?= base_url('blog') ?>" class="text-white text-decoration-none ms-2">×</a>
                                    </span>
                                <?php endif; ?>
                                <?php if (isset($_GET['q']) && !empty($_GET['q'])): ?>
                                    <span class="badge bg-info me-2 mb-2">
                                        Search: "<?= htmlspecialchars($_GET['q']) ?>"
                                        <a href="<?= base_url('blog') ?>" class="text-white text-decoration-none ms-2">×</a>
                                    </span>
                                <?php endif; ?>
                                <?php if (isset($_GET['tag']) && !empty($_GET['tag'])): ?>
                                    <span class="badge bg-success me-2 mb-2">
                                        Tag: <?= htmlspecialchars($_GET['tag']) ?>
                                        <a href="<?= base_url('blog') ?>" class="text-white text-decoration-none ms-2">×</a>
                                    </span>
                                <?php endif; ?>
                                <a href="<?= base_url('blog') ?>" class="btn btn-sm btn-outline-secondary">Clear All</a>
                            </div>
                        </div>
                    <?php endif; ?>

                    <div class="row gutter-20">
                        <?php if (isset($blogs) && !empty($blogs)): ?>
                            <?php foreach ($blogs as $blog): ?>
                                <div class="col-xl-4 col-md-6">
                                    <div class="blog__post-item shine__animate-item">
                                        <div class="blog__post-thumb">
                                            <a href="<?= base_url('blog/' . $blog['slug']) ?>" class="shine__animate-link">
                                                <?php if (!empty($blog['blog_img'])): ?>
                                                    <img src="<?= base_url('assets/avator/upload/' . $blog['blog_img']) ?>"
                                                        alt="<?= htmlspecialchars($blog['title']) ?>"
                                                        onerror="this.src='<?= base_url('assets/theme/v2/skillgro/') ?>assets/img/blog/blog_post01.jpg'">
                                                <?php else: ?>
                                                    <img src="<?= base_url('assets/theme/v2/skillgro/') ?>assets/img/blog/blog_post01.jpg" alt="<?= htmlspecialchars($blog['title']) ?>">
                                                <?php endif; ?>
                                            </a>
                                            <a href="<?= base_url('blog?type=' . urlencode($blog['blog_type'] ?? 'General')) ?>" class="post-tag">
                                                <?= !empty($blog['blog_type']) ? htmlspecialchars($blog['blog_type']) : 'General' ?>
                                            </a>
                                        </div>
                                        <div class="blog__post-content">
                                            <div class="blog__post-meta">
                                                <ul class="list-wrap">
                                                    <li><i class="flaticon-calendar"></i><?= date('d M, Y', strtotime($blog['blog_time'])) ?></li>
                                                    <li><i class="flaticon-user-1"></i>by <a href="#"><?= !empty($blog['blog_username']) ? htmlspecialchars($blog['blog_username']) : 'Admin' ?></a></li>
                                                </ul>
                                            </div>
                                            <h4 class="title">
                                                <a href="<?= base_url('blog/' . $blog['slug']) ?>">
                                                    <?= htmlspecialchars($blog['title']) ?>
                                                </a>
                                            </h4>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <div class="col-12">
                                <div class="text-center py-5">
                                    <h4>No blogs found</h4>
                                    <p class="text-muted">There are no blogs available at the moment.</p>
                                    <a href="<?= base_url('blog') ?>" class="btn btn-two">View All Blogs</a>
                                </div>
                            </div>
                        <?php endif; ?>


                    </div>
                    <?php if (isset($pagination) && !empty($pagination)): ?>
                        <nav class="pagination__wrap mt-25">
                            <?= $pagination ?>
                        </nav>
                    <?php endif; ?>
                </div>
                <div class="col-xl-3 col-lg-4">
                    <aside class="blog-sidebar">
                        <div class="blog-widget widget_search">
                            <div class="sidebar-search-form">
                                <form action="<?= base_url('blog') ?>" method="GET">
                                    <input type="text" name="q" placeholder="Search blogs..." value="<?= isset($_GET['q']) ? htmlspecialchars($_GET['q']) : '' ?>">
                                    <button type="submit"><i class="flaticon-search"></i></button>
                                </form>
                            </div>
                        </div>
                        <div class="blog-widget">
                            <h4 class="widget-title">All Blog</h4>
                            <div class="shop-cat-list">
                                <ul class="list-wrap">
                                    <li>
                                        <a href="<?= base_url('blog') ?>"><i class="flaticon-angle-right"></i>All Blogs</a>
                                    </li>
                                    <?php 
                                if(isset($_GET['type']) && !empty($_GET['type'])) {
                                    echo htmlspecialchars($_GET['type']) . ' Blogs';
                                } elseif(isset($_GET['q']) && !empty($_GET['q'])) {
                                    echo 'Search Results for "' . htmlspecialchars($_GET['q']) . '"';
                                } else {
                                    echo 'Latest Blogs';
                                }
                                ?>
                                </ul>
                            </div>
                        </div>
                        <div class="blog-widget">
                            <h4 class="widget-title">Latest Posts</h4>
                            <?php
                            // Get latest 4 blogs for sidebar
                            if (isset($blogs) && !empty($blogs)) {
                                $latest_blogs = array_slice($blogs, 0, 4);
                                foreach ($latest_blogs as $latest_blog): ?>
                                    <div class="rc-post-item">
                                        <div class="rc-post-thumb">
                                            <a href="<?= base_url('blog/' . url_smart($latest_blog['title'])) ?>">
                                                <?php if (!empty($latest_blog['blog_img'])): ?>
                                                    <img src="<?= base_url('assets/avator/upload/' . $latest_blog['blog_img']) ?>"
                                                        alt="<?= htmlspecialchars($latest_blog['title']) ?>"
                                                        onerror="this.src='<?= base_url('assets/theme/v2/skillgro/') ?>assets/img/blog/latest_post01.jpg'">
                                                <?php else: ?>
                                                    <img src="<?= base_url('assets/theme/v2/skillgro/') ?>assets/img/blog/latest_post01.jpg"
                                                        alt="<?= htmlspecialchars($latest_blog['title']) ?>">
                                                <?php endif; ?>
                                            </a>
                                        </div>
                                        <div class="rc-post-content">
                                            <span class="date">
                                                <i class="flaticon-calendar"></i>
                                                <?= date('M d, Y', strtotime($latest_blog['blog_time'])) ?>
                                            </span>
                                            <h4 class="title">
                                                <a href="<?= base_url('blog/' . url_smart($latest_blog['title'])) ?>">
                                                    <?= htmlspecialchars(substr($latest_blog['title'], 0, 50)) ?>
                                                    <?= strlen($latest_blog['title']) > 50 ? '...' : '' ?>
                                                </a>
                                            </h4>
                                        </div>
                                    </div>
                                <?php endforeach;
                            } else { ?>
                                <div class="rc-post-item">
                                    <div class="rc-post-thumb">
                                        <a href="#">
                                            <img src="<?= base_url('assets/theme/v2/skillgro/') ?>assets/img/blog/latest_post01.jpg" alt="No posts yet">
                                        </a>
                                    </div>
                                    <div class="rc-post-content">
                                        <span class="date"><i class="flaticon-calendar"></i> No posts yet</span>
                                        <h4 class="title"><a href="#">No blog posts available</a></h4>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                        <div class="blog-widget">
                            <h4 class="widget-title">Popular Tags</h4>
                            <div class="tagcloud">
                                <?php
                                // Get unique tags from blogs
                                if (isset($blogs) && !empty($blogs)) {
                                    $all_tags = array();
                                    foreach ($blogs as $blog) {
                                        if (!empty($blog['tags'])) {
                                            $blog_tags = explode(',', $blog['tags']);
                                            foreach ($blog_tags as $tag) {
                                                $tag = trim($tag);
                                                if (!empty($tag) && !in_array($tag, $all_tags)) {
                                                    $all_tags[] = $tag;
                                                }
                                            }
                                        }
                                    }

                                    // Show tags (limit to 10 most popular)
                                    $tag_count = 0;
                                    foreach ($all_tags as $tag) {
                                        if ($tag_count < 10) {
                                            echo '<a href="' . base_url('blog?tag=' . urlencode($tag)) . '">' . htmlspecialchars($tag) . '</a>';
                                            $tag_count++;
                                        }
                                    }

                                    // If no tags found, show default ones
                                    if (empty($all_tags)) {
                                        echo '<a href="' . base_url('blog?type=Education') . '">Education</a>';
                                        echo '<a href="' . base_url('blog?type=Training') . '">Training</a>';
                                        echo '<a href="' . base_url('blog?type=Online') . '">Online</a>';
                                        echo '<a href="' . base_url('blog?type=Learning') . '">Learning</a>';
                                    }
                                } else {
                                    // Default tags if no blogs
                                    echo '<a href="' . base_url('blog?type=Education') . '">Education</a>';
                                    echo '<a href="' . base_url('blog?type=Training') . '">Training</a>';
                                    echo '<a href="' . base_url('blog?type=Online') . '">Online</a>';
                                    echo '<a href="' . base_url('blog?type=Learning') . '">Learning</a>';
                                }
                                ?>
                            </div>
                        </div>
                    </aside>
                </div>
            </div>
        </div>
    </section>
    <!-- blog-area-end -->

</main>
<!-- main-area-end -->