  <!-- main-area -->
    <main class="main-area fix">

        <!-- breadcrumb-area -->
        <section class="breadcrumb__area breadcrumb__bg" data-background="assets/img/bg/breadcrumb_bg.jpg">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="breadcrumb__content">
                            <?php if (isset($_GET['q']) && !empty($_GET['q'])): ?>
                                <h3 class="title">"<?= htmlspecialchars($_GET['q']) ?>"</h3>
                                <nav class="breadcrumb">
                                    <span property="itemListElement" typeof="ListItem">
                                        <a href="<?= base_url() ?>">Home</a>
                                    </span>
                                    <span class="breadcrumb-separator"><i class="fas fa-angle-right"></i></span>
                                    <span property="itemListElement" typeof="ListItem">
                                        <a href="<?= base_url('category') ?>">Categories</a>
                                    </span>
                                    <span class="breadcrumb-separator"><i class="fas fa-angle-right"></i></span>
                                    <span property="itemListElement" typeof="ListItem">"<?= htmlspecialchars($_GET['q']) ?>"</span>
                                </nav>
                            <?php else: ?>
                                <h3 class="title">All Categories</h3>
                            <nav class="breadcrumb">
                                <span property="itemListElement" typeof="ListItem">
                                        <a href="<?= base_url() ?>">Home</a>
                                </span>
                                <span class="breadcrumb-separator"><i class="fas fa-angle-right"></i></span>
                                    <span property="itemListElement" typeof="ListItem">Categories</span>
                            </nav>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="breadcrumb__shape-wrap">
                <img src="<?= base_url('assets/theme/v2/skillgro/') ?>assets/img/others/breadcrumb_shape01.svg" alt="img" class="alltuchtopdown">
                <img src="<?= base_url('assets/theme/v2/skillgro/') ?>assets/img/others/breadcrumb_shape02.svg" alt="img" data-aos="fade-right" data-aos-delay="300">
                <img src="<?= base_url('assets/theme/v2/skillgro/') ?>assets/img/others/breadcrumb_shape03.svg" alt="img" data-aos="fade-up" data-aos-delay="400">
                <img src="<?= base_url('assets/theme/v2/skillgro/') ?>assets/img/others/breadcrumb_shape04.svg" alt="img" data-aos="fade-down-left" data-aos-delay="400">
                <img src="<?= base_url('assets/theme/v2/skillgro/') ?>assets/img/others/breadcrumb_shape05.svg" alt="img" data-aos="fade-left" data-aos-delay="400">
            </div>
        </section>
        <!-- breadcrumb-area-end -->



        <!-- all-courses -->
        <section class="all-courses-area section-py-120">
            <div class="container">
                <div class="row">
                    <div class="col-xl-3 col-lg-4 order-2 order-lg-0">
                        <aside class="courses__sidebar">
                            <div class="courses-widget">
                                <h4 class="widget-title">Categories</h4>
                                <div class="courses-cat-list">
                                    <ul class="list-wrap">
                                        <?php if(isset($the_cats) && !empty($the_cats)): ?>
                                            <?php foreach($the_cats as $category): ?>
                                                <li>
                                                    <div class="form-check">
                                                        <input class="form-check-input" type="checkbox" value="<?= $category['ctid'] ?>" id="cat_<?= $category['ctid'] ?>">
                                                        <label class="form-check-label" for="cat_<?= $category['ctid'] ?>"><?= $category['name'] ?></label>
                                                    </div>
                                                </li>
                                            <?php endforeach; ?>
                                        <?php else: ?>
                                            <li>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" value="" id="cat_1">
                                                    <label class="form-check-label" for="cat_1">No Categories Available</label>
                                                </div>
                                            </li>
                                        <?php endif; ?>
                                    </ul>
                                    <div class="show-more">
                                        <a href="#">Show More +</a>
                                    </div>
                                </div>
                            </div>
                        </aside>
                    </div>
                    <div class="col-xl-9 col-lg-8">
                        <div class="courses-top-wrap courses-top-wrap">
                            <div class="row align-items-center">
                                <div class="col-md-5">
                                    <div class="courses-top-left">
                                        <p>Showing <?= isset($total_num) ? $total_num : '0' ?> total results (Total categories: <?= isset($debug_total) ? $debug_total : '0' ?>)</p>
                                    </div>
                                </div>
                                <div class="col-md-7">
                                    <div class="d-flex justify-content-center justify-content-md-end align-items-center flex-wrap">
                                        <!-- <div class="courses-top-right m-0 ms-md-auto">
                                            <span class="sort-by">Sort By:</span>
                                            <div class="courses-top-right-select">
                                                <select name="orderby" class="orderby">
                                                    <option value="Most Popular">Most Popular</option>
                                                    <option value="latest">Latest</option>
                                                    <option value="name">Name</option>
                                                </select>
                                            </div>
                                        </div> -->
                                        <ul class="nav nav-tabs courses__nav-tabs" id="myTab" role="tablist">
                                            <li class="nav-item" role="presentation">
                                                <button class="nav-link active" id="grid-tab" data-bs-toggle="tab" data-bs-target="#grid" type="button" role="tab" aria-controls="grid" aria-selected="true">
                                                    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <path d="M6 1H2C1.44772 1 1 1.44772 1 2V6C1 6.55228 1.44772 7 2 7H6C6.55228 7 7 6.55228 7 6V2C7 1.44772 6.55228 1 6 1Z"  stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                                                        <path d="M16 1H12C11.4477 1 11 1.44772 11 2V6C11 6.55228 11.4477 7 12 7H16C16.5523 7 17 6.55228 17 6V2C17 1.44772 16.5523 1 16 1Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                                                        <path d="M6 11H2C1.44772 11 1 11.4477 1 12V16C1 16.5523 1.44772 17 2 17H6C6.55228 17 7 16.5523 7 16V12C7 11.4477 6.55228 11 6 11Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                                                        <path d="M16 11H12C11.4477 11 11 11.4477 11 12V16C11 16.5523 11.4477 17 12 17H16C16.5523 17 17 16.5523 17 16V12C17 11.4477 16.5523 11 16 11Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                                                    </svg>
                                                </button>
                                            </li>
                                            <li class="nav-item" role="presentation">
                                                <button class="nav-link" id="list-tab" data-bs-toggle="tab" data-bs-target="#list" type="button" role="tab" aria-controls="list" aria-selected="false">
                                                    <svg width="19" height="15" viewBox="0 0 19 15" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <path d="M1.5 6C0.67 6 0 6.67 0 7.5C0 8.33 0.67 9 1.5 9C2.33 9 3 8.33 3 7.5C3 6.67 2.33 6 1.5 6ZM1.5 0C0.67 0 0 0.67 0 1.5C0 2.33 0.67 3 1.5 3C2.33 3 3 2.33 3 1.5C3 0.67 2.33 0 1.5 0ZM1.5 12C0.67 12 0 12.68 0 13.5C0 14.32 0.68 15 1.5 15C2.32 15 3 14.32 3 13.5C3 12.68 2.33 12 1.5 12ZM5.5 14.5H17.5C18.05 14.5 18.5 14.05 18.5 13.5C18.5 12.95 18.05 12.5 17.5 12.5H5.5C4.95 12.5 4.5 12.95 4.5 13.5C4.5 14.05 4.95 14.5 5.5 14.5ZM5.5 8.5H17.5C18.05 8.5 18.5 8.05 18.5 7.5C18.5 6.95 18.05 6.5 17.5 6.5H5.5C4.95 6.5 4.5 6.95 4.5 7.5C4.5 8.05 4.95 8.5 5.5 8.5ZM4.5 1.5C4.5 2.05 4.95 2.5 5.5 2.5H17.5C18.05 2.5 18.5 2.05 18.5 1.5C18.5 0.95 18.05 0.5 17.5 0.5H5.5C4.95 0.5 4.5 0.95 4.5 1.5Z" fill="currentColor" />
                                                    </svg>
                                                </button>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tab-content" id="myTabContent">
                            <div class="tab-pane fade show active" id="grid" role="tabpanel" aria-labelledby="grid-tab">
                                <div class="row courses__grid-wrap row-cols-1 row-cols-xl-3 row-cols-lg-2 row-cols-md-2 row-cols-sm-1">
                                    <?php if(isset($categories) && !empty($categories)): ?>
                                        <?php foreach($categories as $category): ?>
                                    <div class="col">
                                        <div class="courses__item shine__animate-item">
                                            <div class="courses__item-thumb">
                                                    <a href="<?= base_url('topic/' . url_smart($category['name']) . '/' . $category['ctid']) ?>" class="shine__animate-link">
                                                        <?php if(!empty($category['img'])): ?>
                                                            <img src="<?= base_url('assets/avator/upload/') . $category['img'] ?>" alt="<?= htmlspecialchars($category['name']) ?>">
                                                        <?php else: ?>
                                                            <img src="<?= base_url('assets/theme/v2/skillgro/') ?>assets/img/courses/course_thumb01.jpg" alt="<?= htmlspecialchars($category['name']) ?>">
                                                        <?php endif; ?>
                                                </a>
                                            </div>
                                            <div class="courses__item-content">
                                                <ul class="courses__item-meta list-wrap">
                                                    <li class="courses__item-tag">
                                                            <a href="<?= base_url('topic/' . url_smart($category['name']) . '/' . $category['ctid']) ?>"><?= htmlspecialchars($category['name']) ?></a>
                                                    </li>
                                                        <li class="avg-rating"><i class="fas fa-star"></i> (<?= !empty($category['sid']) ? $category['sid'] : '0' ?> Topics)</li>
                                                </ul>
                                                    <h5 class="title"><a href="<?= base_url('topic/' . url_smart($category['name']) . '/' . $category['ctid']) ?>"><?= htmlspecialchars($category['name']) ?></a></h5>
                                                    <p class="author"><?= !empty($category['desc']) ? htmlspecialchars(substr($category['desc'], 0, 100)) . '...' : 'No description available' ?></p>
                                                <div class="courses__item-bottom">
                                                    <div class="button">
                                                            <a href="<?= base_url('topic/' . url_smart($category['name']) . '/' . $category['ctid']) ?>">
                                                                <span class="text">Learn This Topic</span>
                                                            <i class="flaticon-arrow-right"></i>
                                                        </a>
                                                    </div>
                                                        <h5 class="price">Topic <?= $category['ctid'] ?></h5>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        <div class="col-12">
                                            <div class="text-center py-5">
                                                <h4>No Categories Available</h4>
                                                <p class="text-muted">There are no categories to display at the moment.</p>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <nav class="pagination__wrap mt-30">
                                    <ul class="list-wrap">
                                        <?php echo $this->pagination->create_links(); ?>
                                    </ul>
                                </nav>
                            </div>
                            <div class="tab-pane fade" id="list" role="tabpanel" aria-labelledby="list-tab">
                                <div class="row courses__list-wrap row-cols-1">
                                    <?php if(isset($categories) && !empty($categories)): ?>
                                        <?php foreach($categories as $category): ?>
                                    <div class="col">
                                        <div class="courses__item courses__item-three shine__animate-item">
                                            <div class="courses__item-thumb">
                                                    <a href="<?= base_url('topic/' . url_smart($category['name']) . '/' . $category['ctid']) ?>" class="shine__animate-link">
                                                        <?php if(!empty($category['img'])): ?>
                                                            <img src="<?= base_url('assets/avator/upload/') . $category['img'] ?>" alt="<?= htmlspecialchars($category['name']) ?>">
                                                        <?php else: ?>
                                                            <img src="<?= base_url('assets/theme/v2/skillgro/') ?>assets/img/courses/course_thumb01.jpg" alt="<?= htmlspecialchars($category['name']) ?>">
                                                        <?php endif; ?>
                                                </a>
                                            </div>
                                            <div class="courses__item-content">
                                                <ul class="courses__item-meta list-wrap">
                                                    <li class="courses__item-tag">
                                                            <a href="<?= base_url('topic/' . url_smart($category['name']) . '/' . $category['ctid']) ?>"><?= htmlspecialchars($category['name']) ?></a>
                                                        <div class="avg-rating">
                                                                <i class="fas fa-star"></i> (<?= !empty($category['sid']) ? $category['sid'] : '0' ?> Topics)
                                                        </div>
                                                    </li>
                                                        <li class="price">Topic <?= $category['ctid'] ?></li>
                                                </ul>
                                                    <h5 class="title"><a href="<?= base_url('topic/' . url_smart($category['name']) . '/' . $category['ctid']) ?>"><?= htmlspecialchars($category['name']) ?></a></h5>
                                                    <p class="author">Category ID: <?= $category['ctid'] ?></p>
                                                    <p class="info"><?= !empty($category['desc']) ? htmlspecialchars(substr($category['desc'], 0, 200)) . '...' : 'No description available' ?></p>
                                                <div class="courses__item-bottom">
                                                    <div class="button">
                                                            <a href="<?= base_url('topic/' . url_smart($category['name']) . '/' . $category['ctid']) ?>">
                                                                <span class="text">Learn This Topic</span>
                                                            <i class="flaticon-arrow-right"></i>
                                                        </a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        <div class="col-12">
                                            <div class="text-center py-5">
                                                <h4>No Categories Available</h4>
                                                <p class="text-muted">There are no categories to display at the moment.</p>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <nav class="pagination__wrap mt-30">
                                    <ul class="list-wrap">
                                        <?php echo $this->pagination->create_links(); ?>
                                    </ul>
                                </nav>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- all-courses-end -->

    </main>
    <!-- main-area-end -->



