<!-- header starts -->
<header class="header ecommerce-main-header">
    <div class="custom-container2">
        <div class="header-panel">
            <div class="header-top-content text-center">
                <a href="<?= base_url('index.php/profile') ?>" onclick="history.back()">
                    <i class="iconsax icon-btn" data-icon="chevron-left"></i>
                </a>
                <h3>Change Company</h3>
            </div>
        </div>
    </div>
</header>
<!-- header end -->

<!-- account section starts -->
<section class="section-lg-t-space">
    <div class="custom-container">
        <!-- Current Company Card -->
        <div class="current-company-card">
            <div class="current-company-header">
                <i class="iconsax" data-icon="buildings-2"></i>
                <h5>Current Company</h5>
            </div>
            <div class="current-company-content">
                <?php if (isset($profile_data['company_name']) && !empty($profile_data['company_name'])): ?>
                    <div class="company-info-item">
                        <span class="info-label">Company:</span>
                        <span class="info-value"><?= htmlspecialchars($profile_data['company_name']) ?></span>
                    </div>
                    <?php if (isset($profile_data['collection_name']) && !empty($profile_data['collection_name'])): ?>
                        <div class="company-info-item">
                            <span class="info-label">Collection:</span>
                            <span class="info-value"><?= htmlspecialchars($profile_data['collection_name']) ?></span>
                        </div>
                    <?php endif; ?>
                <?php else: ?>
                    <div class="company-info-item">
                        <span class="info-value no-company">No company selected</span>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <form class="ecommerce-form" id="changeCompanyForm" onsubmit="return handleCompanyChange(this);">
            <div id="error_div" class="alert alert-danger" style="display:none; margin-bottom: 20px;"></div>
            <div id="loder_div" style="display:none; text-align:center; padding:20px;">
                <img src="<?= base_url('assets/theme/v1/social-app/assets/images/gif/fashion.gif') ?>" style="width:50px; height:50px;">
            </div>

            <div class="profile-setting-details">
                <!-- Company Selection with Logo -->
                <div class="form-group floating-label-input">
                    <!-- Hidden select for form submission -->
                    <select class="input-text" id="comp_id" name="comp_id" required onchange="loadCollections(this.value)" style="display: none;">
                        <option value="">Choose a company</option>
                        <?php if(isset($companies) && !empty($companies)): ?>
                            <?php foreach($companies as $company): ?>
                                <option value="<?= $company['comp_id'] ?>" 
                                    <?= (isset($profile_data['comp_id']) && $profile_data['comp_id'] == $company['comp_id']) ? 'selected' : '' ?>
                                    data-logo="<?= !empty($company['comp_logo']) ? htmlspecialchars($company['comp_logo']) : '' ?>">
                                    <?= htmlspecialchars($company['comp_name']) ?>
                                </option>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </select>
                    <!-- Custom Dropdown with Logo -->
                    <div class="custom-select-wrapper" id="comp_id_wrapper">
                        <div class="custom-select-trigger" id="comp_id_trigger">
                            <span class="custom-select-placeholder">
                                <i class="iconsax" data-icon="buildings-2"></i> Choose a company
                            </span>
                            <i class="iconsax custom-select-arrow" data-icon="arrow-down-2"></i>
                        </div>
                        <div class="custom-select-options" id="comp_id_options">
                            <?php if(isset($companies) && !empty($companies)): ?>
                                <?php foreach($companies as $company): ?>
                                    <?php 
                                    $logo_url = '';
                                    if (!empty($company['comp_logo'])) {
                                        $logo_path = 'assets/ai/uploads/companies/' . $company['comp_logo'];
                                        if (file_exists($logo_path)) {
                                            $logo_url = base_url($logo_path);
                                        }
                                    }
                                    $is_selected = (isset($profile_data['comp_id']) && $profile_data['comp_id'] == $company['comp_id']);
                                    ?>
                                    <div class="custom-select-option <?= $is_selected ? 'selected' : '' ?>" 
                                         data-value="<?= $company['comp_id'] ?>"
                                         data-logo="<?= htmlspecialchars($logo_url) ?>">
                                        <?php if ($logo_url): ?>
                                            <img src="<?= $logo_url ?>" alt="<?= htmlspecialchars($company['comp_name']) ?>" class="company-logo-option" onerror="this.style.display='none'">
                                        <?php else: ?>
                                            <div class="company-logo-placeholder">
                                                <i class="iconsax" data-icon="buildings-2"></i>
                                            </div>
                                        <?php endif; ?>
                                        <span class="company-name-option"><?= htmlspecialchars($company['comp_name']) ?></span>
                                    </div>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </div>
                    </div>
                    <label class="form-check-label" for="comp_id">
                        <i class="iconsax" data-icon="buildings-2"></i> Select Company
                    </label>
                </div>

                <!-- Collection Selection -->
                <div class="form-group floating-label-input">
                    <select class="input-text" id="coll_id" name="coll_id" required>
                        <option value="">Choose a collection</option>
                        <?php if(isset($collections) && !empty($collections)): ?>
                            <?php foreach($collections as $collection): ?>
                                <option value="<?= $collection['coll_id'] ?>" 
                                    <?= (isset($profile_data['coll_id']) && $profile_data['coll_id'] == $collection['coll_id']) ? 'selected' : '' ?>>
                                    <?= htmlspecialchars($collection['coll_name']) ?>
                                </option>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </select>
                    <label class="form-check-label" for="coll_id">
                        <i class="iconsax" data-icon="folder-2"></i> Select Collection
                    </label>
                </div>

                <!-- Info Note -->
                <div class="info-note-box">
                    <div class="info-note-icon">
                        <i class="iconsax" data-icon="info-circle"></i>
                    </div>
                    <div class="info-note-content">
                        <strong>Important Note</strong>
                        <p>Changing your company will update your profile. Please ensure you select the correct company and collection.</p>
                    </div>
                </div>

                <button type="submit" class="btn ecommerce-btn w-100 mt-4 update-company-btn">
                    <i class="iconsax" data-icon="tick-circle"></i>
                    Update Company
                </button>
            </div>
        </form>
    </div>
</section>
<!-- account section end -->

<style>
/* Current Company Card */
.current-company-card {
    background: linear-gradient(135deg, #ffc107 0%, #ff9800 100%);
    border-radius: 16px;
    padding: 20px;
    margin-bottom: 25px;
    box-shadow: 0 4px 15px rgba(255, 193, 7, 0.2);
}

.current-company-header {
    display: flex;
    align-items: center;
    gap: 10px;
    margin-bottom: 15px;
    color: #fff;
}

.current-company-header i {
    font-size: 24px;
    color: #fff;
}

.current-company-header h5 {
    margin: 0;
    font-size: 16px;
    font-weight: 600;
    color: #fff;
}

.current-company-content {
    background: rgba(255, 255, 255, 0.95);
    border-radius: 12px;
    padding: 15px;
}

.company-info-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 10px 0;
    border-bottom: 1px solid rgba(0, 0, 0, 0.05);
}

.company-info-item:last-child {
    border-bottom: none;
}

.info-label {
    font-size: 14px;
    color: #666;
    font-weight: 500;
}

.info-value {
    font-size: 15px;
    color: #333;
    font-weight: 600;
    text-align: right;
    flex: 1;
    margin-left: 10px;
}

.info-value.no-company {
    color: #999;
    font-style: italic;
    text-align: center;
    width: 100%;
}

/* Form Improvements */
.profile-setting-details {
    background: #fff;
    border-radius: 16px;
    padding: 20px;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
}

.form-group.floating-label-input {
    margin-bottom: 20px;
    margin-top: 0 !important;
    position: relative;
}

.form-group.floating-label-input label {
    display: flex !important;
    align-items: center;
    gap: 8px;
    font-size: 14px;
    font-weight: 600;
    color: #333;
    margin-bottom: 0 !important;
    position: absolute !important;
    top: 50% !important;
    left: 16px !important;
    transform: translateY(-50%) !important;
    background: transparent !important;
    padding: 0 5px !important;
    cursor: default;
    pointer-events: none;
    z-index: 1;
    transition: all 0.2s ease;
}

.form-group.floating-label-input label i {
    font-size: 18px;
    color: #ffc107;
}

.form-group.floating-label-input select.input-text {
    width: 100% !important;
    padding: 14px 40px 14px 16px !important;
    border: 2px solid #e0e0e0 !important;
    border-radius: 12px !important;
    font-size: 15px !important;
    background: #fff !important;
    background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='12' height='12' viewBox='0 0 12 12'%3E%3Cpath fill='%23333' d='M6 9L1 4h10z'/%3E%3C/svg%3E") !important;
    background-repeat: no-repeat !important;
    background-position: right 16px center !important;
    background-size: 12px !important;
    color: #333 !important;
    transition: all 0.3s ease;
    appearance: none !important;
    -webkit-appearance: none !important;
    -moz-appearance: none !important;
    outline: none !important;
    box-shadow: none !important;
}

/* Hide label when select has value or is focused */
.form-group.floating-label-input select.input-text:not([value=""]) + label,
.form-group.floating-label-input select.input-text:focus + label,
.form-group.floating-label-input select.input-text:valid + label {
    top: 0 !important;
    left: 15px !important;
    background: rgba(255, 255, 255, 1) !important;
    padding: 0 8px !important;
    font-size: 12px !important;
    transform: translateY(-50%) !important;
}

/* When select has selected value (not empty), move label up */
.form-group.floating-label-input select.input-text.has-value + label,
.form-group.floating-label-input select.input-text:not([value=""]) + label {
    top: 0 !important;
    left: 15px !important;
    background: rgba(255, 255, 255, 1) !important;
    padding: 0 8px !important;
    font-size: 12px !important;
    transform: translateY(-50%) !important;
}

.form-group.floating-label-input select.input-text:focus {
    outline: none !important;
    border-color: #ffc107 !important;
    box-shadow: 0 0 0 3px rgba(255, 193, 7, 0.1) !important;
}

.form-group.floating-label-input select.input-text:active,
.form-group.floating-label-input select.input-text:hover {
    border-color: #ffc107 !important;
}

/* Custom Dropdown with Logo */
.custom-select-wrapper {
    position: relative;
    width: 100%;
    margin-bottom: 0;
}

/* Fix label positioning for custom dropdown */
.form-group.floating-label-input {
    position: relative;
    margin-bottom: 20px;
}

.form-group.floating-label-input .custom-select-wrapper + label {
    position: absolute !important;
    top: 0 !important;
    left: 15px !important;
    transform: translateY(-50%) !important;
    background: #fff !important;
    padding: 0 8px !important;
    font-size: 12px !important;
    color: #ffc107 !important;
    pointer-events: none !important;
    z-index: 2 !important;
    transition: all 0.2s ease !important;
    margin-bottom: 0 !important;
    display: flex !important;
    align-items: center !important;
    gap: 6px !important;
}

/* Ensure custom dropdown trigger is above label */
.custom-select-trigger {
    position: relative;
    z-index: 1;
}

.custom-select-trigger {
    width: 100%;
    padding: 14px 40px 14px 16px;
    border: 2px solid #e0e0e0;
    border-radius: 12px;
    background: #fff;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: space-between;
    transition: all 0.3s ease;
    min-height: 50px;
}

.custom-select-trigger:hover {
    border-color: #ffc107;
}

.custom-select-wrapper.active .custom-select-trigger {
    border-color: #ffc107;
    box-shadow: 0 0 0 3px rgba(255, 193, 7, 0.1);
}

.custom-select-placeholder {
    display: flex;
    align-items: center;
    gap: 8px;
    color: #999;
    font-size: 15px;
}

.custom-select-trigger.selected .custom-select-placeholder {
    color: #333;
}

.custom-select-trigger .selected-company {
    display: flex;
    align-items: center;
    gap: 10px;
}

.custom-select-trigger .selected-company img {
    width: 32px;
    height: 32px;
    object-fit: contain;
    border-radius: 4px;
}

.custom-select-trigger .selected-company-name {
    font-size: 15px;
    color: #333;
    font-weight: 500;
}

.custom-select-arrow {
    font-size: 16px;
    color: #666;
    transition: transform 0.3s ease;
}

.custom-select-wrapper.active .custom-select-arrow {
    transform: rotate(180deg);
}

.custom-select-options {
    position: absolute;
    top: calc(100% + 5px);
    left: 0;
    right: 0;
    background: #fff;
    border: 2px solid #e0e0e0;
    border-radius: 12px;
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.15);
    max-height: 300px;
    overflow-y: auto;
    z-index: 1000;
    display: none;
}

.custom-select-wrapper.active .custom-select-options {
    display: block;
}

.custom-select-option {
    padding: 12px 16px;
    cursor: pointer;
    display: flex;
    align-items: center;
    gap: 12px;
    transition: all 0.2s ease;
    border-bottom: 1px solid #f0f0f0;
}

.custom-select-option:last-child {
    border-bottom: none;
}

.custom-select-option:hover {
    background: #f8f9fa;
}

.custom-select-option.selected {
    background: #fff9e6;
}

.company-logo-option {
    width: 32px;
    height: 32px;
    object-fit: contain;
    border-radius: 4px;
    flex-shrink: 0;
}

.company-logo-placeholder {
    width: 32px;
    height: 32px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: #f0f0f0;
    border-radius: 4px;
    flex-shrink: 0;
}

.company-logo-placeholder i {
    font-size: 18px;
    color: #999;
}

.company-name-option {
    font-size: 15px;
    color: #333;
    font-weight: 500;
}


/* Info Note Box */
.info-note-box {
    background: linear-gradient(135deg, #e3f2fd 0%, #bbdefb 100%);
    border-left: 4px solid #2196f3;
    border-radius: 12px;
    padding: 16px;
    margin-top: 20px;
    margin-bottom: 20px;
    display: flex;
    gap: 12px;
    align-items: flex-start;
}

.info-note-icon {
    flex-shrink: 0;
    width: 32px;
    height: 32px;
    background: #2196f3;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: #fff;
}

.info-note-icon i {
    font-size: 18px;
}

.info-note-content {
    flex: 1;
}

.info-note-content strong {
    display: block;
    font-size: 14px;
    color: #1976d2;
    margin-bottom: 6px;
    font-weight: 600;
}

.info-note-content p {
    margin: 0;
    font-size: 13px;
    color: #555;
    line-height: 1.5;
}

/* Update Button */
.update-company-btn {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%) !important;
    border: none !important;
    border-radius: 12px;
    padding: 16px;
    font-size: 16px;
    font-weight: 600;
    color: #fff !important;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 10px;
    box-shadow: 0 4px 15px rgba(102, 126, 234, 0.4);
    transition: all 0.3s ease;
    margin-top: 10px;
}

.update-company-btn:hover {
    background: linear-gradient(135deg, #764ba2 0%, #667eea 100%) !important;
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(102, 126, 234, 0.5);
}

.update-company-btn:active {
    transform: translateY(0);
}

.update-company-btn i {
    font-size: 20px;
}

/* Mobile Responsive */
@media (max-width: 768px) {
    .section-lg-t-space {
        padding-top: 20px !important;
    }
    
    .current-company-card {
        padding: 16px;
        margin-bottom: 20px;
        border-radius: 12px;
    }
    
    .profile-setting-details {
        padding: 16px;
        border-radius: 12px;
    }
    
    .company-info-item {
        flex-direction: column;
        align-items: flex-start;
        gap: 5px;
        padding: 8px 0;
    }
    
    .info-label {
        font-size: 13px;
    }
    
    .info-value {
        text-align: left;
        margin-left: 0;
        width: 100%;
        font-size: 14px;
    }
    
    .form-group.floating-label-input {
        margin-bottom: 18px;
    }
    
    .form-group.floating-label-input label {
        font-size: 12px;
        left: 14px !important;
    }
    
    .form-group.floating-label-input label i {
        font-size: 16px;
    }
    
    .form-group.floating-label-input select.input-text {
        padding: 12px 38px 12px 14px !important;
        font-size: 14px !important;
        border-radius: 10px !important;
    }
    
    .form-group.floating-label-input select.input-text:not([value=""]) + label,
    .form-group.floating-label-input select.input-text:focus + label {
        left: 12px !important;
        font-size: 11px !important;
    }
    
    .info-note-box {
        padding: 14px;
        margin-top: 15px;
        margin-bottom: 15px;
    }
    
    .info-note-content strong {
        font-size: 13px;
    }
    
    .info-note-content p {
        font-size: 12px;
    }
    
    .update-company-btn {
        padding: 14px;
        font-size: 15px;
        border-radius: 10px;
        margin-top: 5px;
    }
}

@media (max-width: 480px) {
    .section-lg-t-space {
        padding-top: 15px !important;
    }
    
    .custom-container {
        padding-left: 12px;
        padding-right: 12px;
    }
    
    .current-company-card {
        padding: 14px;
        border-radius: 12px;
        margin-bottom: 18px;
    }
    
    .current-company-header {
        margin-bottom: 12px;
    }
    
    .current-company-header i {
        font-size: 20px;
    }
    
    .current-company-header h5 {
        font-size: 14px;
    }
    
    .current-company-content {
        padding: 12px;
        border-radius: 10px;
    }
    
    .company-info-item {
        padding: 6px 0;
    }
    
    .info-label {
        font-size: 12px;
    }
    
    .info-value {
        font-size: 13px;
    }
    
    .profile-setting-details {
        padding: 14px;
        border-radius: 12px;
    }
    
    .form-group.floating-label-input {
        margin-bottom: 16px;
    }
    
    .form-group.floating-label-input label {
        font-size: 11px;
        left: 12px !important;
    }
    
    .form-group.floating-label-input label i {
        font-size: 14px;
    }
    
    .form-group.floating-label-input select.input-text {
        padding: 11px 36px 11px 12px !important;
        font-size: 13px !important;
        border-radius: 10px !important;
    }
    
    .form-group.floating-label-input select.input-text:not([value=""]) + label,
    .form-group.floating-label-input select.input-text:focus + label {
        left: 10px !important;
        font-size: 10px !important;
    }
    
    .info-note-box {
        padding: 12px;
        flex-direction: row;
        gap: 10px;
        margin-top: 12px;
        margin-bottom: 12px;
        border-radius: 10px;
    }
    
    .info-note-icon {
        width: 28px;
        height: 28px;
        flex-shrink: 0;
    }
    
    .info-note-icon i {
        font-size: 16px;
    }
    
    .info-note-content strong {
        font-size: 12px;
        margin-bottom: 4px;
    }
    
    .info-note-content p {
        font-size: 11px;
        line-height: 1.4;
    }
    
    .update-company-btn {
        padding: 13px;
        font-size: 14px;
        border-radius: 10px;
        margin-top: 5px;
    }
    
    .update-company-btn i {
        font-size: 18px;
    }
}
</style>

<!-- panel-space start -->
<div class="panel-space"></div>
<!-- panel-space end -->

<!-- SweetAlert2 Library -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
// Check and update label position for selects with values
function updateSelectLabels() {
    document.querySelectorAll('.form-group.floating-label-input select').forEach(function(select) {
        var label = select.nextElementSibling;
        if (label && label.classList.contains('form-check-label')) {
            if (select.value && select.value !== '') {
                select.classList.add('has-value');
            } else {
                select.classList.remove('has-value');
            }
        }
    });
}

// Custom Dropdown with Logo Functionality
function initCustomDropdown() {
    const wrapper = document.getElementById('comp_id_wrapper');
    const trigger = document.getElementById('comp_id_trigger');
    const options = document.getElementById('comp_id_options');
    const select = document.getElementById('comp_id');
    
    if (!wrapper || !trigger || !options || !select) return;
    
    // Ensure label is always floated
    const label = wrapper.nextElementSibling;
    if (label && label.classList.contains('form-check-label')) {
        label.style.top = '0';
        label.style.left = '15px';
        label.style.background = '#fff';
        label.style.padding = '0 8px';
        label.style.fontSize = '12px';
        label.style.color = '#ffc107';
        label.style.transform = 'translateY(-50%)';
    }
    
    // Set initial value if selected
    const selectedOption = select.options[select.selectedIndex];
    if (selectedOption && selectedOption.value) {
        const logoUrl = selectedOption.getAttribute('data-logo');
        const companyName = selectedOption.text;
        updateTriggerDisplay(companyName, logoUrl);
        wrapper.classList.add('has-value');
        wrapper.classList.add('selected');
    }
    
    // Toggle dropdown
    trigger.addEventListener('click', function(e) {
        e.stopPropagation();
        wrapper.classList.toggle('active');
    });
    
    // Close dropdown when clicking outside
    document.addEventListener('click', function(e) {
        if (!wrapper.contains(e.target)) {
            wrapper.classList.remove('active');
        }
    });
    
    // Handle option selection
    options.querySelectorAll('.custom-select-option').forEach(function(option) {
        option.addEventListener('click', function() {
            const value = this.getAttribute('data-value');
            const logoUrl = this.getAttribute('data-logo');
            const companyName = this.querySelector('.company-name-option').textContent;
            
            // Update select value
            select.value = value;
            select.dispatchEvent(new Event('change'));
            
            // Update trigger display
            updateTriggerDisplay(companyName, logoUrl);
            
            // Update selected state
            options.querySelectorAll('.custom-select-option').forEach(function(opt) {
                opt.classList.remove('selected');
            });
            this.classList.add('selected');
            
                // Close dropdown
                wrapper.classList.remove('active');
                wrapper.classList.add('has-value');
                wrapper.classList.add('selected');
                
                // Trigger loadCollections
                loadCollections(value);
            });
        });
    }

function updateTriggerDisplay(companyName, logoUrl) {
    const trigger = document.getElementById('comp_id_trigger');
    const placeholder = trigger.querySelector('.custom-select-placeholder');
    
    if (companyName && companyName !== 'Choose a company') {
        trigger.classList.add('selected');
        if (logoUrl) {
            placeholder.innerHTML = '<div class="selected-company"><img src="' + logoUrl + '" alt="' + companyName + '" onerror="this.style.display=\'none\'"><span class="selected-company-name">' + companyName + '</span></div>';
        } else {
            placeholder.innerHTML = '<div class="selected-company"><div class="company-logo-placeholder"><i class="iconsax" data-icon="buildings-2"></i></div><span class="selected-company-name">' + companyName + '</span></div>';
        }
    } else {
        trigger.classList.remove('selected');
        placeholder.innerHTML = '<i class="iconsax" data-icon="buildings-2"></i> Choose a company';
    }
    
    // Update iconsax
    if (typeof iconsax !== 'undefined') {
        iconsax.init();
    }
}

// Initialize on page load
document.addEventListener('DOMContentLoaded', function() {
    updateSelectLabels();
    initCustomDropdown();
    
    // Update labels when selects change
    document.querySelectorAll('.form-group.floating-label-input select').forEach(function(select) {
        select.addEventListener('change', function() {
            updateSelectLabels();
        });
    });
});

// Load collections based on selected company
function loadCollections(compId) {
    var collSelect = document.getElementById('coll_id');
    collSelect.innerHTML = '<option value="">Loading...</option>';
    
    if (!compId) {
        collSelect.innerHTML = '<option value="">Select Collection</option>';
        return;
    }
    
    $.ajax({
        url: '<?= base_url('index.php/action/get_collections') ?>',
        type: 'POST',
        data: { comp_id: compId },
        success: function(response) {
            try {
                var collections = JSON.parse(response);
                collSelect.innerHTML = '<option value="">Select Collection</option>';
                collections.forEach(function(coll) {
                    collSelect.innerHTML += '<option value="' + coll.coll_id + '">' + coll.coll_name + '</option>';
                });
                
                // Update label position after loading collections
                setTimeout(function() {
                    updateSelectLabels();
                }, 100);
            } catch(e) {
                collSelect.innerHTML = '<option value="">Select Collection</option>';
                console.error('Error loading collections:', e);
            }
        },
        error: function() {
            collSelect.innerHTML = '<option value="">Select Collection</option>';
            console.error('Error loading collections');
        }
    });
}

// Handle company change form submission
function handleCompanyChange(form) {
    var compId = document.getElementById('comp_id').value;
    var collId = document.getElementById('coll_id').value;
    
    if (!compId || !collId) {
        Swal.fire({
            icon: 'warning',
            title: 'Required Fields',
            text: 'Please select both Company and Collection.',
            confirmButtonText: 'OK'
        });
        return false;
    }
    
    $('#error_div').hide();
    $('#loder_div').show();
    
    $.ajax({
        url: '<?= base_url('index.php/action/change_company') ?>',
        type: 'POST',
        data: {
            comp_id: compId,
            coll_id: collId
        },
        success: function(response) {
            $('#loder_div').hide();
            try {
                var result = typeof response === 'string' ? JSON.parse(response) : response;
                
                if (result.success || response.trim() == 'YNAPS_SUCCESS') {
                    Swal.fire({
                        icon: 'success',
                        title: 'Success!',
                        text: 'Company changed successfully!',
                        timer: 2000,
                        showConfirmButton: false,
                        timerProgressBar: true
                    }).then(function() {
                        window.location.href = '<?= base_url('index.php/profile') ?>';
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error!',
                        text: result.message || response || 'Failed to change company. Please try again.',
                        confirmButtonText: 'OK'
                    });
                    $('#error_div').html(result.message || response || 'Failed to change company.').show();
                }
            } catch(e) {
                if (response.trim() == 'YNAPS_SUCCESS') {
                    Swal.fire({
                        icon: 'success',
                        title: 'Success!',
                        text: 'Company changed successfully!',
                        timer: 2000,
                        showConfirmButton: false,
                        timerProgressBar: true
                    }).then(function() {
                        window.location.href = '<?= base_url('index.php/profile') ?>';
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error!',
                        text: response || 'Failed to change company. Please try again.',
                        confirmButtonText: 'OK'
                    });
                    $('#error_div').html(response || 'Failed to change company.').show();
                }
            }
        },
        error: function(xhr, status, error) {
            $('#loder_div').hide();
            Swal.fire({
                icon: 'error',
                title: 'Error!',
                text: 'An error occurred. Please try again.',
                confirmButtonText: 'OK'
            });
            $('#error_div').html('An error occurred. Please try again.').show();
        }
    });
    
    return false;
}
</script>

