<!-- header starts -->
<header class="header ecommerce-main-header">
    <div class="custom-container2">
        <div class="header-panel">
            <div class="header-top-content text-center">
                <a href="<?= base_url() ?>" onclick="history.back()">
                    <i class="iconsax icon-btn" data-icon="chevron-left"></i>
                </a>
                <h3>GD Library Check</h3>
            </div>
        </div>
    </div>
</header>
<!-- header end -->

<!-- GD check section starts -->
<section class="section-lg-t-space">
    <div class="custom-container">
        <div class="gd-check-card">
            <h2 class="mb-4">GD Library Diagnostic Check</h2>
            
            <!-- PHP Information -->
            <div class="info-box mb-4">
                <h4>PHP Information</h4>
                <p><strong>PHP Version:</strong> <?= $php_version ?></p>
                <p><strong>PHP.ini File:</strong> <code><?= $php_ini_file ?></code></p>
                <?php if (!empty($php_ini_scanned)): ?>
                    <p><strong>Additional .ini files:</strong> <?= $php_ini_scanned ?></p>
                <?php endif; ?>
            </div>

            <!-- GD Extension Status -->
            <div class="status-box mb-4 <?= $gd_loaded ? 'success' : 'error' ?>">
                <h4>GD Extension Status</h4>
                <?php if ($gd_loaded): ?>
                    <p class="status-text success">✓ GD Extension is LOADED</p>
                <?php else: ?>
                    <p class="status-text error">✗ GD Extension is NOT loaded</p>
                <?php endif; ?>
            </div>

            <!-- GD Information -->
            <?php if (!empty($gd_info)): ?>
            <div class="info-box mb-4">
                <h4>GD Library Information</h4>
                <div class="gd-info">
                    <?php foreach ($gd_info as $key => $value): ?>
                        <p><strong><?= htmlspecialchars($key) ?>:</strong> 
                            <?= is_bool($value) ? ($value ? 'Yes' : 'No') : htmlspecialchars($value) ?>
                        </p>
                    <?php endforeach; ?>
                </div>
            </div>
            <?php else: ?>
            <div class="info-box mb-4 error">
                <h4>GD Information</h4>
                <p class="error">✗ gd_info() function is not available</p>
            </div>
            <?php endif; ?>

            <!-- GD Functions -->
            <div class="info-box mb-4">
                <h4>GD Functions Availability</h4>
                <?php
                $available_count = 0;
                $total_count = count($gd_functions);
                foreach ($gd_functions as $func => $available):
                    if ($available) $available_count++;
                ?>
                    <p class="<?= $available ? 'success' : 'error' ?>">
                        <?= $available ? '✓' : '✗' ?> 
                        <code><?= htmlspecialchars($func) ?></code>
                    </p>
                <?php endforeach; ?>
                <p class="mt-3"><strong>Available: <?= $available_count ?> / <?= $total_count ?></strong></p>
            </div>

            <!-- Test Image Creation -->
            <div class="status-box mb-4 <?= $test_image_creation ? 'success' : 'error' ?>">
                <h4>Test Image Creation</h4>
                <?php if ($test_image_creation): ?>
                    <p class="status-text success">✓ Successfully created test image (100x100)</p>
                <?php else: ?>
                    <p class="status-text error">✗ Failed to create test image</p>
                <?php endif; ?>
            </div>

            <!-- Final Recommendation -->
            <div class="recommendation-box <?= ($gd_loaded && $available_count > 10) ? 'success' : 'error' ?>">
                <h4>Recommendation</h4>
                <?php if ($gd_loaded && $available_count > 10): ?>
                    <p class="status-text success">✓ GD Library is properly configured and ready to use!</p>
                    <p>You can now use image generation features.</p>
                <?php else: ?>
                    <div class="error">
                        <p class="status-text error">✗ GD Library is NOT properly configured</p>
                        <h5>Please follow these steps:</h5>
                        <ol>
                            <li><strong>Check php.ini file:</strong><br>
                                <code><?= $php_ini_file ?></code><br>
                                Line 931 should have: <code>extension=gd</code> (without semicolon)</li>
                            <?php 
                            $php_ini_content = @file_get_contents($php_ini_file);
                            $has_gd = $php_ini_content && strpos($php_ini_content, 'extension=gd') !== false;
                            $has_gd_commented = $php_ini_content && strpos($php_ini_content, ';extension=gd') !== false;
                            if ($has_gd && !$has_gd_commented): ?>
                                <li class="success">✓ <strong>php.ini is already configured correctly!</strong><br>
                                    <code>extension=gd</code> is uncommented.</li>
                            <?php else: ?>
                                <li><strong>Uncomment the line:</strong><br>
                                    Change <code>;extension=gd</code> to <code>extension=gd</code><br>
                                    (Remove the semicolon at the beginning)</li>
                                <li><strong>Save the file</strong></li>
                            <?php endif; ?>
                            <li class="important"><strong>⚠️ RESTART APACHE (IMPORTANT!):</strong><br>
                                <strong>Method 1:</strong> XAMPP Control Panel → Stop Apache → Wait 3 seconds → Start Apache<br>
                                <strong>Method 2:</strong> Close XAMPP Control Panel completely and reopen it, then restart Apache<br>
                                <strong>Method 3:</strong> Restart your computer</li>
                            <li><strong>After restart, refresh this page</strong> to verify</li>
                        </ol>
                        <p><strong>Note:</strong> If <code>extension=gd</code> doesn't work, try <code>extension=gd2</code></p>
                    </div>
                <?php endif; ?>
            </div>

            <div class="mt-4">
                <a href="<?= base_url() ?>" class="btn ecommerce-btn">Back to Home</a>
                <a href="<?= base_url('check-gd') ?>" class="btn btn-secondary ml-2">Refresh Check</a>
            </div>
        </div>
    </div>
</section>
<!-- GD check section end -->

<style>
.gd-check-card {
    background: #fff;
    padding: 30px;
    border-radius: 12px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    max-width: 900px;
    margin: 0 auto;
}

.info-box {
    background: #f9f9f9;
    padding: 20px;
    border-radius: 8px;
    border-left: 4px solid #007bff;
}

.status-box {
    padding: 20px;
    border-radius: 8px;
    border-left: 4px solid;
}

.status-box.success {
    background: #d4edda;
    border-color: #28a745;
}

.status-box.error {
    background: #f8d7da;
    border-color: #dc3545;
}

.status-text {
    font-size: 18px;
    margin: 0;
}

.status-text.success {
    color: #28a745;
}

.status-text.error {
    color: #dc3545;
}

.recommendation-box {
    padding: 20px;
    border-radius: 8px;
    border-left: 4px solid;
}

.recommendation-box.success {
    background: #d4edda;
    border-color: #28a745;
}

.recommendation-box.error {
    background: #f8d7da;
    border-color: #dc3545;
}

.gd-info p {
    margin: 8px 0;
    font-size: 14px;
}

code {
    background: #f5f5f5;
    padding: 2px 6px;
    border-radius: 3px;
    font-family: 'Courier New', monospace;
}

ol {
    margin: 15px 0;
    padding-left: 25px;
}

ol li {
    margin: 10px 0;
    line-height: 1.6;
}

ol li.important {
    background: #fff3cd;
    padding: 10px;
    border-radius: 5px;
    border-left: 4px solid #ffc107;
    font-weight: bold;
}

ol li.success {
    background: #d4edda;
    padding: 10px;
    border-radius: 5px;
    border-left: 4px solid #28a745;
}
</style>

