<!-- header starts -->
<header class="header ecommerce-main-header">
    <div class="custom-container2">
        <div class="header-panel">
            <div class="header-top-content text-center">
                <a href="<?= base_url() ?>" onclick="history.back()">
                    <i class="iconsax icon-btn" data-icon="chevron-left"></i>
                </a>
                <h3>Collections</h3>
            </div>
        </div>
    </div>
</header>
<!-- header end -->

<!-- collections section starts -->
<section class="section-lg-t-space" style="padding-top: 0; margin-top: 0;">
    <?php if (isset($collections) && !empty($collections) && is_array($collections) && count($collections) > 0): ?>
        <!-- Collections Slider - Same as Home Page Used Templates -->
        <section class="collections-section" style="padding-top: 0; margin-top: 0;">
            <!-- Collections Slider - One collection per slide -->
            <div id="collectionsCarousel" class="carousel slide carousel-fade" data-ride="carousel" data-interval="5000">
                <div class="carousel-inner">
                    <?php 
                    $slide_index = 0;
                    foreach ($collections as $collection): 
                        $is_active = ($slide_index == 0) ? 'active' : '';
                    ?>
                        <div class="carousel-item <?= $is_active ?>">
                            <a href="<?= base_url('collection-detail/' . $collection['coll_id']) ?>" class="template-slide-link">
                                <div class="template-slide-wrapper">
                                    <?php if (!empty($collection['coll_cover_image'])): ?>
                                        <img src="<?= base_url('assets/ai/uploads/collections/' . $collection['coll_cover_image']) ?>"
                                            alt="<?= htmlspecialchars($collection['coll_name']) ?>"
                                            class="d-block w-100 template-slide-image"
                                            onerror="this.src='<?= base_url('assets/theme/v1/social-app/assets/images/profile/p3.png') ?>'">
                                    <?php else: ?>
                                        <img src="<?= base_url('assets/theme/v1/social-app/assets/images/profile/p3.png') ?>"
                                            alt="Default Collection Image"
                                            class="d-block w-100 template-slide-image">
                                    <?php endif; ?>
                                    
                                    <!-- Collection Info Overlay -->
                                    <div class="template-slide-info">
                                        <h4 class="template-slide-name"><?= htmlspecialchars($collection['coll_name']) ?></h4>
                                        <?php if (!empty($collection['comp_name'])): ?>
                                            <p class="template-slide-collection"><?= htmlspecialchars($collection['comp_name']) ?></p>
                                        <?php endif; ?>
                                        <?php if (!empty($collection['template_count'])): ?>
                                            <p class="template-slide-usage"><?= $collection['template_count'] ?> template<?= $collection['template_count'] > 1 ? 's' : '' ?></p>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </a>
                        </div>
                        <?php $slide_index++; ?>
                    <?php endforeach; ?>
                </div>
                
                <!-- Carousel Controls -->
                <?php if (count($collections) > 1): ?>
                    <a class="carousel-control-prev" href="#collectionsCarousel" role="button" data-slide="prev">
                        <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                        <span class="sr-only">Previous</span>
                    </a>
                    <a class="carousel-control-next" href="#collectionsCarousel" role="button" data-slide="next">
                        <span class="carousel-control-next-icon" aria-hidden="true"></span>
                        <span class="sr-only">Next</span>
                    </a>
                    
                    <!-- Carousel Indicators -->
                    <ol class="carousel-indicators">
                        <?php for ($i = 0; $i < count($collections); $i++): ?>
                            <li data-target="#collectionsCarousel" data-slide-to="<?= $i ?>" 
                                class="<?= $i == 0 ? 'active' : '' ?>"></li>
                        <?php endfor; ?>
                    </ol>
                <?php endif; ?>
            </div>
        </section>
    <?php else: ?>
        <!-- No collections found -->
        <div class="custom-container">
            <div class="empty-state text-center py-5">
                <i class="iconsax" data-icon="image" style="font-size: 64px; color: #ccc; margin-bottom: 20px;"></i>
                <h4>No Collections Available</h4>
                <p>Collections will appear here once they are added.</p>
            </div>
        </div>
    <?php endif; ?>
</section>
<!-- collections section end -->

<style>
    /* Template Slider Styles */
    .template-slide-link {
        display: block;
        text-decoration: none;
        color: inherit;
        width: 100%;
    }
    
    .template-slide-wrapper {
        position: relative;
        width: 100%;
        height: 400px;
        border-radius: 0;
        overflow: hidden;
        background: #1a1a1a;
        box-shadow: none;
        margin: 0;
        padding: 0;
    }
    
    .template-slide-image {
        width: 100%;
        height: 400px;
        object-fit: contain;
        object-position: center;
        display: block;
        background: #1a1a1a;
    }
    
    .template-slide-info {
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        background: linear-gradient(to top, rgba(0,0,0,0.95), rgba(0,0,0,0.7), transparent);
        padding: 15px 12px 12px;
        color: #fff;
        z-index: 10;
        pointer-events: none;
    }
    
    .template-slide-name {
        font-size: 16px;
        font-weight: 700;
        margin: 0 0 4px 0;
        color: #fff;
        text-shadow: 2px 2px 4px rgba(0,0,0,0.9);
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }
    
    .template-slide-collection {
        font-size: 12px;
        color: #e0e0e0;
        margin: 0 0 3px 0;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }
    
    .template-slide-usage {
        font-size: 11px;
        color: #ccc;
        margin: 0;
    }
    
    #collectionsCarousel {
        margin-top: 0;
        width: 100%;
        padding: 0;
        margin-left: 0;
        margin-right: 0;
        background: transparent;
        overflow: hidden;
    }
    
    #collectionsCarousel .carousel-item {
        height: 400px;
        width: 100%;
        background: transparent;
        transition: opacity 0.6s ease-in-out;
    }
    
    #collectionsCarousel .carousel-item.active {
        opacity: 1;
    }
    
    #collectionsCarousel .carousel-inner {
        height: 400px;
        width: 100%;
        background: transparent;
    }
    
    /* Fade transition for carousel */
    #collectionsCarousel.carousel-fade .carousel-item {
        opacity: 0;
        transition-property: opacity;
        transform: none;
    }
    
    #collectionsCarousel.carousel-fade .carousel-item.active,
    #collectionsCarousel.carousel-fade .carousel-item-next.carousel-item-start,
    #collectionsCarousel.carousel-fade .carousel-item-prev.carousel-item-end {
        opacity: 1;
    }
    
    #collectionsCarousel.carousel-fade .active.carousel-item-start,
    #collectionsCarousel.carousel-fade .active.carousel-item-end {
        opacity: 0;
    }
    
    #collectionsCarousel .carousel-control-prev,
    #collectionsCarousel .carousel-control-next {
        width: 50px;
        height: 50px;
        background: rgba(0,0,0,0.5);
        border-radius: 50%;
        top: 50%;
        transform: translateY(-50%);
        opacity: 0.8;
    }
    
    #collectionsCarousel .carousel-control-prev:hover,
    #collectionsCarousel .carousel-control-next:hover {
        opacity: 1;
    }
    
    #collectionsCarousel .carousel-control-prev {
        left: 10px;
    }
    
    #collectionsCarousel .carousel-control-next {
        right: 10px;
    }
    
    @media (max-width: 768px) {
        #collectionsCarousel .carousel-control-prev,
        #collectionsCarousel .carousel-control-next {
            width: 40px;
            height: 40px;
        }
    }
    
    #collectionsCarousel .carousel-indicators {
        bottom: 20px;
    }
    
    #collectionsCarousel .carousel-indicators li {
        width: 12px;
        height: 12px;
        border-radius: 50%;
        background: rgba(255,255,255,0.5);
        border: 2px solid #fff;
        margin: 0 5px;
    }
    
    #collectionsCarousel .carousel-indicators li.active {
        background: #fff;
    }

    /* Collections Section */
    .collections-section {
        padding: 0;
        overflow-x: hidden;
    }
    
    .collections-section .custom-container {
        padding-left: 15px;
        padding-right: 15px;
    }
    
    .collections-section #collectionsCarousel {
        width: 100%;
        margin-left: 0;
        margin-right: 0;
        padding: 0;
    }
    
    @media (max-width: 768px) {
        .template-slide-wrapper {
            height: 300px;
        }
        .template-slide-image {
            height: 300px;
        }
        #collectionsCarousel .carousel-item {
            height: 300px;
        }
        #collectionsCarousel .carousel-inner {
            height: 300px;
        }
    }
    
    @media (max-width: 480px) {
        .template-slide-wrapper {
            height: 250px;
        }
        .template-slide-image {
            height: 250px;
        }
        #collectionsCarousel .carousel-item {
            height: 250px;
        }
        #collectionsCarousel .carousel-inner {
            height: 250px;
        }
    }

    .empty-state {
        padding: 60px 20px;
    }

    .empty-state h4 {
        color: #333;
        margin-bottom: 10px;
    }

    .empty-state p {
        color: #666;
    }
</style>

