<!-- Theme CSS -->
<link rel="stylesheet" type="text/css" href="<?= base_url() ?>assets/theme/v2/assets/css/style.min.css">

<main class="main">
  <div class="page-header" style="padding: 20px 0;">
    <div class="container">
      <h1 class="page-title mb-0">Compare Tractors</h1>
    </div>
  </div>
  <nav class="breadcrumb-nav">
    <div class="container">
      <ul class="breadcrumb">
        <li><a href="<?= base_url() ?>">Home</a></li>
        <li>Compare</li>
      </ul>
    </div>
  </nav>
  <div class="page-content pt-2">
    <div class="container">
      <style>
        .cmp-grid{display:grid;grid-template-columns:repeat(4,1fr);gap:16px;margin:16px 0 48px}
        .cmp-card{border:1px solid #e5e5e5;border-radius:10px;background:#fff;min-height:220px;display:flex;align-items:center;justify-content:center;flex-direction:column}
        .cmp-empty{border:2px dashed #cfd6df;background:#fafafa}
        .cmp-add{color:#204080;font-weight:600;cursor:pointer}
        .cmp-top{margin-bottom:18px}
        .cmp-btn{background:#2c7be5;color:#fff;border:0;border-radius:8px;padding:10px 16px}
        .cmp-modal{position:fixed;inset:0;background:rgba(0,0,0,.45);display:none;align-items:center;justify-content:center;z-index:1050}
        .cmp-modal.open{display:flex}
        .cmp-dialog{width:min(700px,94vw);max-height:90vh;background:#fff;border-radius:12px;box-shadow:0 20px 60px rgba(0,0,0,.25);display:flex;flex-direction:column}
        .cmp-hd{padding:12px 14px;border-bottom:1px solid #eee;display:flex;align-items:center;justify-content:space-between}
        .cmp-body{padding:12px 14px;overflow:auto;flex:1}
        .cmp-modal-footer{border-top:1px solid #eee;padding:10px 16px;background:#fafafa;position:sticky;bottom:0;box-shadow:0 -4px 12px rgba(0,0,0,.04)}
        .cmp-pick-grid{display:grid;grid-template-columns:repeat(3,1fr);gap:8px;margin-bottom:8px}
        .cmp-pick{border:1px solid #cfe1ff;border-radius:8px;background:linear-gradient(180deg,#edf3ff 0%,#ffffff 100%);padding:6px 8px;display:flex;align-items:flex-start;justify-content:flex-start;cursor:pointer;min-height:42px}
        .cmp-pick-info{display:flex;flex-direction:column;line-height:1.15}
        .cmp-pick-info .brand{font-size:11px;color:#3b5ea9;opacity:.95}
        .cmp-pick-info .model{font-weight:700;color:#0b172a;font-size:13px;margin-top:2px;white-space:nowrap;overflow:hidden;text-overflow:ellipsis}
        .cmp-add-mini{border:1px dashed #cfd6df;background:#fff;color:#204080;border-radius:8px;padding:10px 8px;text-align:center;cursor:pointer;min-height:42px;display:flex;align-items:center;justify-content:center;font-size:13px}
        .cmp-add-mini .plus{font-size:14px;margin-right:6px;opacity:.7}
        @media(min-width:1000px){.cmp-pick-grid{grid-template-columns:repeat(4,1fr)}}
        @media(max-width:768px){.cmp-pick-grid{grid-template-columns:repeat(2,1fr)}}
        @media(max-width:575px){.cmp-pick-grid{grid-template-columns:1fr}}
        .cmp-search{display:flex;gap:10px;margin-bottom:12px}
        .cmp-search input{flex:1;height:38px;border:1px solid #ddd;border-radius:8px;padding:0 10px}
        .brand-list,.model-list{border:1px solid #eee;border-radius:10px;overflow:auto;max-height:280px}
        .brand-item,.model-item{padding:10px 12px;border-bottom:1px solid #f2f2f2;cursor:pointer}
        .brand-item:hover,.model-item:hover{background:#f6f9ff}
        .cmp-specs{margin-top:24px;border:1px solid #e5e5e5;border-radius:10px}
        .cmp-specs table{width:100%;border-collapse:collapse}
        .cmp-specs th,.cmp-specs td{border-top:1px solid #eee;padding:10px;text-align:left}
        .cmp-specs th{background:#fafafa;width:220px}
        @media(max-width:991px){.cmp-grid{grid-template-columns:repeat(2,1fr)}}
        @media(max-width:575px){
          .cmp-grid{grid-template-columns:1fr}
          .cmp-card{min-height:170px}
          .cmp-btn{padding:8px 12px;font-size:13px}
          .cmp-dialog{width:96vw;max-height:92vh}
          .cmp-modal-footer .btn{width:100%}
        }
      </style>

      <div class="cmp-top">
        <p>Choose up to 4 tractors to compare their price, power and key specs.</p>
      </div>

      <div class="cmp-grid" id="cmpGrid">
        <?php for($i=0;$i<4;$i++): ?>
          <div class="cmp-card cmp-empty" data-slot="<?= $i ?>">
            <div style="font-size:42px;opacity:.4;">🚜</div>
            <div class="cmp-add" onclick="openCompareModal(<?= $i ?>)">Add Tractor</div>
          </div>
        <?php endfor; ?>
      </div>

    

      

      <!-- Static demo layout (always visible) -->
      <style>
        /* Static compare layout */
        .cmp-static{margin-top:16px}
        .cmp-static-tabs{display:flex;gap:8px;flex-wrap:wrap;margin-bottom:12px}
        .cmp-chip{padding:6px 12px;border:1px solid #e5e5e5;border-radius:999px;background:#fff;font-size:13px;cursor:pointer}
        .cmp-chip.active{background:#204080;color:#fff;border-color:#204080}
        .cmp-static-section{margin:14px 0;border:1px solid #eee;border-radius:10px;background:#fff}
        .cmp-static-head{padding:10px 12px;border-bottom:1px solid #eee;font-weight:700;display:flex;align-items:center;gap:8px}
        .cmp-static-table{width:100%;border-collapse:collapse}
        .cmp-static-table th,.cmp-static-table td{border-top:1px solid #f1f1f1;padding:10px;text-align:left;font-size:13px}
        .cmp-static-table thead th{background:#f8f9fb;font-weight:600}
        .cmp-static-sub{padding:10px 12px;font-weight:700;border-top:1px solid #f3f3f3;background:#fff}
        .cmp-static-actions{padding:8px 12px}
        .cmp-see-more{font-size:12px;color:#204080;cursor:pointer}
      </style>

      <div class="cmp-static" id="cmpStatic" style="display:none;">
        <div class="cmp-static-tabs">
          <span class="cmp-chip active">Basic Information</span>
          <span class="cmp-chip">Power</span>
          <span class="cmp-chip">Control</span>
          <span class="cmp-chip">Structural and Design</span>
          <span class="cmp-chip">Other Information</span>
        </div>

       
      </div>

      <!-- Results (full layout) -->
      <style>
        .cmp-hero{margin-top:16px;margin-bottom:12px}
        .cmp-hero-title{font-weight:700;margin-bottom:10px}
        .cmp-hero-grid{display:grid;grid-template-columns:repeat(4,1fr);gap:12px}
        .cmp-hero-card{border:1px solid #e5e5e5;border-radius:10px;background:#fff;overflow:hidden}
        .cmp-hero-img{height:130px;background:#f7f8fb;display:flex;align-items:center;justify-content:center}
        .cmp-hero-img img{max-height:100%;max-width:100%;object-fit:contain}
        .cmp-hero-body{padding:10px}
        .cmp-hero-name{font-weight:700}
        .cmp-hero-price{font-size:13px;color:#555}
        .cmp-hero-btn{margin-top:8px}
        .cmp-hero-add{display:flex;align-items:center;justify-content:center;height:200px;border:2px dashed #d7dcea;border-radius:10px;background:#fafbff;cursor:pointer}
        .cmp-tabs{display:flex;gap:8px;margin:10px 0;overflow-x:auto;white-space:nowrap;-webkit-overflow-scrolling:touch}
        .cmp-tab{padding:6px 10px;border:1px solid #e5e5e5;border-radius:999px;background:#fff;cursor:pointer;font-size:13px}
        .cmp-tab.active{background:#204080;color:#fff;border-color:#204080}
        .cmp-section{display:block;margin-top:6px;overflow-x:auto}
        .cmp-table{width:100%;min-width:700px;border-collapse:collapse;background:#fff;border:1px solid #eee;border-radius:8px;overflow:hidden}
        .cmp-table th,.cmp-table td{border-top:1px solid #eee;padding:10px;text-align:left}
        .cmp-table thead th{background:#f8f9fb}
        .cmp-subhead{background:#fff;font-weight:700}
        @media(max-width:991px){.cmp-hero-grid{grid-template-columns:repeat(2,1fr)}}
        @media(max-width:575px){
          .cmp-hero-grid{grid-template-columns:1fr}
          .cmp-hero-img{height:110px}
          .cmp-hero-add{height:160px}
        }
      </style>
      <div id="cmpResults" style="display:none;">
        <style>
          /* extra spacing for results block */
          #cmpResults{margin-top:24px;margin-bottom:56px}
        </style>
        <div class="cmp-hero">
          <div class="cmp-hero-title" id="cmpHeroTitle">Comparison</div>
          <div class="cmp-hero-grid" id="cmpHeroGrid"></div>
        </div>
        <div class="cmp-tabs">
          <button class="cmp-tab active" data-tab="basic">Basic Information</button>
          <button class="cmp-tab" data-tab="power">Power</button>
          <button class="cmp-tab" data-tab="control">Control</button>
          <button class="cmp-tab" data-tab="struct">Structural and Design</button>
          <button class="cmp-tab" data-tab="other">Other Information</button>
        </div>
        <div class="cmp-section" id="tab-basic">
          <table class="cmp-table" id="tbl-basic"></table>
        </div>
        <div class="cmp-section" id="tab-power">
          <table class="cmp-table" id="tbl-power"></table>
        </div>
        <div class="cmp-section" id="tab-control">
          <table class="cmp-table" id="tbl-control"></table>
        </div>
        <div class="cmp-section" id="tab-struct">
          <table class="cmp-table" id="tbl-struct"></table>
        </div>
        <div class="cmp-section" id="tab-other">
          <table class="cmp-table" id="tbl-other"></table>
        </div>
      </div>


        <!-- About Compare Tractors (static content) -->
        <style>
        .cmp-about{margin:36px 0 72px;background:#fff;border:1px solid #eaecef;border-radius:10px;padding:18px}
        .cmp-about p{color:#444;line-height:1.7;margin:8px 0}
        .cmp-about .cmp-h{background:#f6f8fc;border:1px solid #eceff4;border-left:4px solid #d34a4a;border-radius:6px;padding:8px 10px;margin:18px 0 10px;font-weight:700;color:#1d2430}
        .cmp-about ul{margin:0 0 12px 18px}
        .cmp-about li{margin:6px 0;color:#333}
      </style>
      <div class="cmp-about" id="cmpAbout">
        <div class="cmp-h">About Compare Tractors</div>
        <p>
          TractorYaari provides a dedicated compare page where you can place two or more tractor models side-by-side and
          review their price, specifications, features, mileage, power and warranty in one place. All top brands like
          Mahindra, John Deere, Swaraj, Eicher, Sonalika, New Holland and more are available here so you can make an
          informed, unbiased decision.
        </p>
        <p>
          With our comparison tool, farmers across India can quickly compare tractors from various brands and HP ranges
          and choose the best value for their needs. The information shown is accurate and easy to understand to help you
          confidently select your next tractor.
        </p>

        <div class="cmp-h">Why Should You Compare Tractors?</div>
        <ul>
          <li><strong>Make informed decisions:</strong> Understand features like engine power, fuel efficiency and key specs.</li>
          <li><strong>Choose the best performance:</strong> Compare strengths and weaknesses to pick the right model.</li>
          <li><strong>Get the best price:</strong> Ensure you’re paying the right amount for the value you receive.</li>
          <li><strong>Use the best tools:</strong> See clear, side‑by‑side data for faster decision‑making.</li>
          <li><strong>Ensure relevancy:</strong> Match products to your budget and on‑field requirements.</li>
        </ul>

        <div class="cmp-h">How to Compare Tractors in India? (Based on Specification)</div>
        <ul>
          <li><strong>Engine:</strong> Check displacement (cc), cylinders, RPM and power delivery (kW/HP).</li>
          <li><strong>Transmission:</strong> Know the gearbox type, number of gears and clutch type.</li>
          <li><strong>PTO (Power Take‑Off):</strong> Type and speed options matter for implements.</li>
          <li><strong>Hydraulics:</strong> Compare lifting capacity and linkage system.</li>
          <li><strong>Dimensions:</strong> Fuel tank, weight, wheelbase and overall size impact stability and efficiency.</li>
        </ul>

        <div class="cmp-h">What Steps Should You Follow To Do Tractor Comparison?</div>
        <ul>
          <li><strong>Identify your need:</strong> Field work, haulage or both? Prioritise features accordingly.</li>
          <li><strong>Shortlist brands & models:</strong> Look at the available options and their reliability.</li>
          <li><strong>Compare side‑by‑side:</strong> Use our compare tool to see differences instantly.</li>
          <li><strong>Check prices:</strong> Select a model that fits your budget without compromising value.</li>
          <li><strong>Read reviews:</strong> Learn from real users and their experiences.</li>
        </ul>

        <div class="cmp-h">Why Choose TractorYaari to Compare Tractors?</div>
        <p>
          Our platform brings verified tractor data, prices and EMI options with a detailed comparison chart. Whether you
          are comparing different brands or narrowing down models, you’ll find all essential information arranged neatly
          to help you take the best decision for your farm.
        </p>
      </div>

      <!-- Modal -->
      <div class="cmp-modal" id="cmpModal" aria-hidden="true">
        <div class="cmp-dialog">
          <div class="cmp-hd"><strong id="cmpModalTitle">Select Brand</strong><button onclick="closeCompareModal()" class="btn btn-sm btn-outline-dark">Close</button></div>
          <div class="cmp-body">
            <div id="brandBox">
              <div class="cmp-search">
                <input type="text" id="cmpBrandSearch" placeholder="Search Brand" oninput="filterList('brand')">
              </div>
              <div class="brand-list" id="brandList"></div>
            </div>

            <div id="modelBox" style="display:none;">
              <div id="brandChip" style="margin-bottom:8px; display:none;">
                <span class="badge" style="background:#eef3ff;color:#204080;padding:6px 10px;border-radius:999px;display:inline-flex;align-items:center;gap:8px;">
                  <span id="brandChipLabel" class="notranslate" translate="no"></span>
                  <button id="brandChipClear" class="btn btn-xs btn-outline-primary" style="padding:2px 6px;line-height:1;">×</button>
                </span>
              </div>
              <div class="cmp-search">
                <input type="text" id="cmpModelSearch" placeholder="Search Model" oninput="filterList('model')">
              </div>
              <div class="model-list" id="modelList"></div>
            </div>
          </div>
          <div class="cmp-modal-footer">
            <div class="cmp-pick-grid" id="cmpPickGrid"></div>
            <div style="display:flex;gap:12px;justify-content:space-between;align-items:center;flex-wrap:wrap;">
              <button class="btn btn-light" id="cmpClearAllBtn" type="button">Clear All</button>
              <button class="btn btn-primary" id="cmpRunBtnModal" type="button" disabled>Compare Tractors</button>
            </div>
          </div>
        </div>
      </div>

      <script>
        let activeSlot = 0;
        let selected = [null,null,null,null];

        function openCompareModal(slot){
          activeSlot = slot;
          document.getElementById('cmpModal').classList.add('open');
          showBrandStep();
          loadBrands();
          renderModalFooter();
        }
        function closeCompareModal(){
          document.getElementById('cmpModal').classList.remove('open');
          document.getElementById('brandList').innerHTML = '';
          document.getElementById('modelBox').style.display = 'none';
          document.getElementById('modelList').innerHTML = '';
        }

        function filterList(type){
          const q = (type==='brand'?document.getElementById('cmpBrandSearch'):document.getElementById('cmpModelSearch')).value.trim().toLowerCase();
          const list = document.getElementById(type==='brand'?'brandList':'modelList');
          Array.from(list.children).forEach(li=>{ li.style.display = li.dataset.name.includes(q)?'block':'none'; });
        }

        function showBrandStep(){
          document.getElementById('cmpModalTitle').textContent = 'Select Brand';
          document.getElementById('brandBox').style.display = 'block';
          document.getElementById('modelBox').style.display = 'none';
          document.getElementById('brandChip').style.display = 'none';
          document.getElementById('cmpBrandSearch').value = '';
        }

        function showModelStep(brandName){
          document.getElementById('cmpModalTitle').textContent = 'Select Model';
          document.getElementById('brandBox').style.display = 'none';
          document.getElementById('modelBox').style.display = 'block';
          document.getElementById('brandChip').style.display = 'block';
          document.getElementById('brandChipLabel').textContent = brandName || '';
          document.getElementById('cmpModelSearch').value = '';
        }

        async function loadBrands(){
          const res = await fetch('<?= base_url('action/compare_brands') ?>');
          const data = await res.json();
          const list = document.getElementById('brandList');
          list.innerHTML = '';
          data.forEach(b => {
            const a = document.createElement('div');
            a.className = 'brand-item';
            a.dataset.name = (b.name||'').toLowerCase();
            a.textContent = b.name;
            a.addEventListener('click', ()=> loadModels(b.id, b.name));
            list.appendChild(a);
          });
        }

        async function loadModels(brandId, brandName){
          showModelStep(brandName);
          const res = await fetch('<?= base_url('action/compare_models?brand_id=') ?>'+brandId);
          const data = await res.json();
          const list = document.getElementById('modelList');
          list.innerHTML = '';
          data.forEach(m => {
            const a = document.createElement('div');
            a.className = 'model-item';
            a.dataset.name = (m.name||'').toLowerCase();
            a.textContent = m.name;
            a.addEventListener('click', ()=> selectModel(brandId, m.id, m.name));
            list.appendChild(a);
          });
          document.getElementById('brandChipClear').onclick = () => showBrandStep();
        }

        async function selectModel(brandId, modelId, modelName){
          const res = await fetch('<?= base_url('action/compare_product?brand_id=') ?>'+brandId+'&model_id='+modelId);
          const p = await res.json();
          selected[activeSlot] = p;
          renderSlots();
          renderModalFooter();
          const next = getNextEmptySlot();
          if (next !== -1) {
            activeSlot = next;
            showBrandStep();
            loadBrands();
          }
          // ensure modal compare button state reflects current selection count
          const btn = document.getElementById('cmpRunBtnModal');
          if (btn) btn.disabled = selected.filter(Boolean).length < 2;
        }

        function getNextEmptySlot(){
          for(let i=0;i<4;i++){ if(!selected[i]) return i; }
          return -1;
        }

        function renderSlots(){
          const grid = document.getElementById('cmpGrid');
          const runBtn = null; // page button removed; only modal button works
          Array.from(grid.children).forEach((card, idx)=>{
            const prod = selected[idx];
            if(!prod){
              card.classList.add('cmp-empty');
              card.innerHTML = '<div style="font-size:42px;opacity:.4;">🚜</div><div class="cmp-add" onclick="openCompareModal('+idx+')">Add Tractor</div>';
            } else {
              card.classList.remove('cmp-empty');
              card.innerHTML = '<div style="text-align:center;padding:10px">'
                + '<div style="font-weight:700;">'+(prod.p_name||'-')+'</div>'
                + '<div style="font-size:13px;color:#666">'+(prod.brand_name||'')+' '+(prod.p_model||'')+'</div>'
                + '<div style="margin-top:6px;font-weight:600;color:#204080">₹'+(Number(prod.p_price||0).toLocaleString('en-IN'))+'</div>'
                + '<button class="cmp-btn" style="margin-top:10px;" onclick="openCompareModal('+idx+')">Change</button>'
                + '</div>';
            }
          });
          // only modal button state is managed below
          renderModalFooterButtonsState();
        }

        function renderModalFooter(){
          const box = document.getElementById('cmpPickGrid');
          box.innerHTML = '';
          for(let i=0;i<4;i++){
            const p = selected[i];
            const el = document.createElement('div');
            if(p){
              el.className = 'cmp-pick';
              el.innerHTML = '<div class="cmp-pick-info">'
                + '<span class="brand">'+(p.brand_name||'')+'</span>'
                + '<span class="model">'+(p.p_model||'')+'</span>'
                + '</div>';
              el.onclick = ()=>{ activeSlot = i; showBrandStep(); loadBrands(); };
            } else {
              el.className = 'cmp-add-mini';
              el.innerHTML = '<span class="plus">+</span> Add Tractor';
              el.onclick = ()=>{ activeSlot = i; showBrandStep(); loadBrands(); };
            }
            box.appendChild(el);
          }
          renderModalFooterButtonsState();
        }

        function renderModalFooterButtonsState(){
          const btn = document.getElementById('cmpRunBtnModal');
          if(btn){
            const count = selected.filter(Boolean).length;
            btn.disabled = count < 2;
          }
        }

        function runComparison(){
          // show the new layout
          document.getElementById('cmpResults').style.display = 'block';
          // title
          const chosen = selected.filter(Boolean).map(p => (p.p_name || (p.brand_name+' '+p.p_model))).join(' vs ');
          document.getElementById('cmpHeroTitle').textContent = chosen || 'Comparison';
          // hero cards
          const hero = document.getElementById('cmpHeroGrid');
          if (!hero) return; // safety
          hero.innerHTML = '';
          for(let i=0;i<4;i++){
            const p = selected[i];
            const card = document.createElement('div');
            if(p){
              card.className = 'cmp-hero-card';
              // resolve main image like other pages: prefer main_image if present, else first from images table via p_cover, else fallback
              var imgSrc = '<?= base_url('assets/theme/v2/assets/images/products/default/1-800x900.jpg') ?>';
              if (p.main_image) { imgSrc = '<?= base_url('assets/avator/upload/') ?>'+p.main_image; }
              else if (p.p_cover) { imgSrc = '<?= base_url('assets/avator/upload/') ?>'+p.p_cover; }
              card.innerHTML = '<div class="cmp-hero-img">'
                + '<img src="'+imgSrc+'" alt="'+(p.p_name||'')+'" />'
                + '</div>'
                + '<div class="cmp-hero-body">'
                + '<div class="cmp-hero-name">'+(p.p_name|| (p.brand_name+' '+p.p_model))+'</div>'
                + '<div class="cmp-hero-price">'+(p.p_price?('₹'+Number(p.p_price).toLocaleString('en-IN')):'Not Available')+'</div>'
                + '<div class="cmp-hero-btn"><button class="btn btn-sm btn-outline-primary">Check Tractor Price</button></div>'
                + '</div>';
            } else {
              card.className = '';
              card.innerHTML = '<div class="cmp-hero-add" onclick="openCompareModal('+i+')">+ Add Tractor</div>';
            }
            hero.appendChild(card);
          }
          // tables
          fillTable('tbl-basic', [
            {label:'Ex-Showroom Price', field:'p_price', fmt: v=> v?('₹'+Number(v).toLocaleString('en-IN')):'—'},
            {label:'EMI Starts', field:'emi', fmt: _=>'—'}
          ], 'Basic Information');
          fillTable('tbl-power', [
            {label:'Engine Power', field:'engine_power'}
          ], 'Power');
          fillTable('tbl-control', [
            {label:'Tyre Condition', field:'tyre_condition'},
            {label:'Engine Type', field:'engine_type'},
            {label:'RC', field:'rc'}
          ], 'Control');
          fillTable('tbl-struct', [
            {label:'Year', field:'p_year'}
          ], 'Structural and Design');
          fillTable('tbl-other', [
            {label:'RTO NO.', field:'rto_no'},
            {label:'Financier / NOC', field:'financier_noc'}
          ], 'Other Information');

          function fillTable(tableId, rows, title){
            const tbl = document.getElementById(tableId);
            const headTitle = title || 'Specification';
            let html = '<thead><tr><th>'+headTitle+'</th>';
            for(let i=0;i<4;i++){ html += '<th>'+(selected[i]? (selected[i].p_name || (selected[i].brand_name+' '+selected[i].p_model)) : '—')+'</th>'; }
            html += '</tr></thead><tbody>';
            rows.forEach(r=>{
              html += '<tr><td>'+r.label+'</td>';
              for(let i=0;i<4;i++){
                const p = selected[i]||{};
                const val = p[r.field];
                html += '<td>' + (r.fmt? r.fmt(val) : (val || '—')) + '</td>';
              }
              html += '</tr>';
            });
            html += '</tbody>';
            tbl.innerHTML = html;
          }

          // tabs behavior (scroll to section; keep all sections visible)
          document.querySelectorAll('.cmp-tab').forEach(btn=>{
            btn.onclick = ()=>{
              document.querySelectorAll('.cmp-tab').forEach(b=>b.classList.remove('active'));
              btn.classList.add('active');
              const target = document.getElementById('tab-'+btn.dataset.tab);
              if (target){ window.scrollTo({ top: target.offsetTop - 90, behavior: 'smooth' }); }
            };
          });

          window.scrollTo({top: document.getElementById('cmpResults').offsetTop-100, behavior:'smooth'});
        }
        // page compare button may be absent (we removed it). Guard binding.
        (function(){ const pb=document.getElementById('cmpRunBtn'); if(pb) pb.addEventListener('click', runComparison); })();
        // Robust bind for modal compare button (works even if modal DOM is re-rendered)
        function onCompareClick(){
          const count = selected.filter(Boolean).length;
          if (count < 2) { alert('Please select at least 2 tractors to compare.'); return; }
          runComparison();
          closeCompareModal();
        }
        (function bindCompareBtn(){
          const btn = document.getElementById('cmpRunBtnModal');
          if (btn && !btn.dataset.bound){ btn.dataset.bound = '1'; btn.addEventListener('click', onCompareClick); }
          // delegate as fallback
          document.addEventListener('click', function(e){
            if (e.target && e.target.id === 'cmpRunBtnModal') { onCompareClick(); }
          });
        })();
        document.getElementById('cmpClearAllBtn').addEventListener('click', ()=>{ selected=[null,null,null,null]; renderSlots(); renderModalFooter(); showBrandStep(); loadBrands(); });
      </script>
    </div>
  </div>
</main>
