<!-- header starts -->
<header class="header ecommerce-main-header">
    <div class="custom-container2">
        <div class="header-panel">
            <div class="header-top-content text-center">
                <a href="<?= base_url('collection-detail/' . $template['coll_id']) ?>" onclick="history.back(); return false;">
                    <i class="iconsax icon-btn" data-icon="chevron-left"></i>
                </a>
                <h3><?= htmlspecialchars($template['temp_name']) ?></h3>
            </div>
        </div>
    </div>
</header>
<!-- header end -->

<!-- Global Loader Overlay for Screen Switching -->
<div id="globalLoaderOverlay" class="global-loader-overlay" style="display: none !important; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0, 0, 0, 0.7); z-index: 99999;">
    <div style="display: flex; align-items: center; justify-content: center; flex-direction: column; width: 100%; height: 100%;">
        <div class="spinner-border text-light" role="status" style="width: 3rem; height: 3rem;">
            <span class="visually-hidden">Loading...</span>
        </div>
        <p class="mt-3 mb-0" style="font-size: 16px; color: #fff; font-weight: 500;" id="globalLoaderText">Loading...</p>
    </div>
</div>

<!-- generate image section starts -->
<section class="section-lg-t-space" style="padding-top: 5px; padding-bottom: 10px; margin-top: 0;">
    <!-- Template Preview - Collection Banner Layout -->
    <div class="template-preview-wrapper mb-2" style="margin-top: 0; padding: 0; width: 100%;">
                <?php if (!empty($template['temp_image'])): ?>
                    <div class="template-image-container" style="position: relative; display: block; width: 100%; overflow: hidden;">
                        <div style="position: relative; width: 100%; min-height: 200px; overflow: hidden; display: flex; align-items: center; justify-content: center; background: #1a1a1a;">
                            <img src="<?= base_url('assets/ai/uploads/templates/' . $template['temp_image']) ?>" 
                                 alt="<?= htmlspecialchars($template['temp_name']) ?>" 
                                 class="template-preview-image"
                                 id="mainTemplateImage"
                                 style="max-width: 100%; max-height: 100%; width: auto; height: auto; object-fit: contain; display: block;"
                                 onload="setTemplateDimensions(this)"
                                 onerror="this.src='<?= base_url('assets/theme/v1/social-app/assets/images/profile/p3.png') ?>'">
                            
                            <!-- User Image Overlay on Template (Runtime) -->
                            <div id="templateImageOverlay" style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; pointer-events: none; display: none; z-index: 5;">
                                <!-- Old single overlay element - hidden by default, will be replaced by dynamic overlays -->
                                <img id="overlayUserImage" 
                                     src="" 
                                     alt="User Image" 
                                     style="display: none; position: absolute; max-width: 100%; max-height: 100%; object-fit: contain; pointer-events: auto; cursor: move; border: 2px dashed #ffc107; border-radius: 4px;">
                                <!-- Dynamic overlay images will be added here with IDs: overlayUserImage-0, overlayUserImage-1, etc. -->
                            </div>
                            
                            <!-- Text Fields Overlay on Template (Runtime) -->
                            <div id="templateTextFieldsOverlay" style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; pointer-events: none; z-index: 6;">
                                <!-- Text fields will be dynamically added here -->
                            </div>
                            
                            <!-- Template Name Overlay - Removed -->
                            
                            <!-- Save Template Button -->
                            <?php 
                            $is_saved = isset($is_template_saved) ? $is_template_saved : false;
                            ?>
                            <button type="button" 
                                    class="template-save-btn-header <?= $is_saved ? 'saved' : '' ?>" 
                                    data-template-id="<?= $template['temp_id'] ?>"
                                    onclick="toggleSaveTemplate(<?= $template['temp_id'] ?>, this)"
                                    title="<?= $is_saved ? 'Unsave Template' : 'Save Template' ?>"
                                    style="z-index: 15;">
                                <i class="iconsax" data-icon="<?= $is_saved ? 'heart' : 'heart-add' ?>"></i>
                            </button>
                        </div>
                    </div>
                <?php endif; ?>
    </div>
    
    <div class="custom-container" style="padding-top: 15px;">
        <form id="generateImageForm" enctype="multipart/form-data">
            <input type="hidden" name="temp_id" value="<?= $template['temp_id'] ?>">
            <input type="hidden" id="template_price" value="<?= isset($template['temp_price']) ? floatval($template['temp_price']) : 0.00 ?>">

            <!-- Gallery Images Section - Below Template (Like Screenshot) -->
            <div class="gallery-section-below-template mb-2" id="gallerySectionWrapper">
                <h6 class="gallery-section-title mb-2" style="font-size: 14px; font-weight: 600; color: #666; text-align: center;">
                    <i class="iconsax" data-icon="gallery" style="margin-right: 6px;"></i>
                    Select from Gallery
                </h6>
                <div id="gallerySectionLoading" class="text-center" style="display: none; padding: 8px 0;">
                    <div class="spinner-border spinner-border-sm text-primary" role="status">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                </div>
                <div id="gallerySectionContent">
                    <div id="gallerySectionGrid" class="d-flex flex-row" style="overflow-x: auto; overflow-y: hidden; gap: 10px; padding: 5px; -webkit-overflow-scrolling: touch; min-height: 80px;">
                        <!-- Gallery images will be loaded here in horizontal sequence -->
                    </div>
                    <div id="gallerySectionEmpty" class="text-center" style="display: none; padding: 8px 0;">
                        <p class="text-muted mb-1" style="font-size: 12px; margin: 0;">No images in gallery</p>
                        <a href="<?= base_url('index.php/my-gallery') ?>" class="btn btn-sm ecommerce-btn mt-1" style="padding: 6px 12px; font-size: 11px;">
                            <i class="iconsax" data-icon="add" style="margin-right: 4px; font-size: 12px;"></i>
                            Upload Images
                        </a>
                    </div>
                </div>
            </div>

            <!-- Photo Selection Tabs -->
            <div class="photo-tabs mb-2">
                <button type="button" class="photo-tab active" data-tab="my-photo" onclick="switchTab('my-photo')">
                    <span>From Mobile</span>
                </button>
                <button type="button" 
                        class="photo-tab save-template-tab <?= isset($is_template_saved) && $is_template_saved ? 'saved' : '' ?>" 
                        data-tab="others" 
                        data-template-id="<?= $template['temp_id'] ?>"
                        onclick="saveTemplateFromTab(<?= $template['temp_id'] ?>, this)">
                    <span><?= isset($is_template_saved) && $is_template_saved ? 'Template Saved' : 'Save Template' ?></span>
                </button>
            </div>

            <!-- Single Image Upload Section -->
            <div class="image-upload-section mb-2" id="mobileUploadSection">
                <h6 class="section-label mb-2" style="font-size: 16px; font-weight: 600; color: #333; text-align: center;">
                    <i class="iconsax" data-icon="camera" style="margin-right: 8px;"></i>
                    Upload Your Photo
                </h6>
                <div class="image-upload-grid" style="justify-content: center;">
                    <div class="image-upload-item">
                        <div class="image-upload-square" onclick="uploadImage(0)" style="position: relative;">
                            <input type="file" class="image-upload-input" data-index="0" accept="image/*" onchange="handleImageUpload(event, 0)" style="display: none;">
                            <div class="image-placeholder" id="placeholder-0" style="display: flex;">
                                <i class="iconsax" data-icon="add"></i>
                            </div>
                            <img class="uploaded-image-preview" id="preview-0" style="display: none; width: 100%; height: 100%; object-fit: cover; border-radius: 8px;">
                            <button type="button" class="remove-image-btn" onclick="event.stopPropagation(); removeImage(0);" style="display: none; position: absolute; top: 5px; right: 5px; z-index: 10;">
                                <i class="iconsax" data-icon="close-circle"></i>
                            </button>
                            <div id="bgRemovalLoader" class="bg-removal-loader" style="display: none;">
                                <div class="spinner-border spinner-border-sm text-white" role="status">
                                    <span class="visually-hidden">Removing background...</span>
                        </div>
                                <p style="margin-top: 8px; font-size: 12px; color: #fff;">Removing Background...</p>
                    </div>
                            </div>
                        <label class="image-upload-label" id="label-0">Upload Photo</label>
                        </div>
                </div>
            </div>

            <!-- Top Uplines Section -->
            <div class="uplines-section mb-3" id="uplinesSection" style="position: relative;">
                <div class="uplines-label-wrapper" style="margin-bottom: 10px;">
                    <div class="uplines-label" style="display: inline-block; background: #fff; padding: 6px 16px; border-radius: 20px; box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
                        <span style="font-size: 14px; font-weight: 600; color: #333;">Top Uplines</span>
                    </div>
                </div>
                <div class="uplines-container" style="display: flex; flex-direction: row; overflow-x: auto; overflow-y: hidden; gap: 12px; padding: 10px 5px; -webkit-overflow-scrolling: touch; min-height: 80px; align-items: center; position: relative;">
                    <!-- Upline Upload Loader -->
                    <div id="uplineUploadLoader" class="upline-upload-loader" style="display: none !important; position: absolute; top: 0; left: 0; right: 0; bottom: 0; background: rgba(255, 255, 255, 0.9); border-radius: 12px; z-index: 100;">
                        <div style="display: flex; align-items: center; justify-content: center; flex-direction: column; width: 100%; height: 100%;">
                            <div class="spinner-border text-warning" role="status" style="width: 3rem; height: 3rem;">
                                <span class="visually-hidden">Loading...</span>
                            </div>
                            <p class="mt-2 mb-0" style="font-size: 14px; color: #333; font-weight: 500;">Uploading upline photo...</p>
                        </div>
                    </div>
                    <div id="uplinesList" style="display: flex; gap: 12px; align-items: center;">
                        <!-- Upline photos will be added here dynamically -->
                    </div>
                    <div class="add-upline-btn" onclick="addUplinePhoto()" style="flex-shrink: 0; width: 60px; height: 60px; border-radius: 50%; background: #ffc107; display: flex; align-items: center; justify-content: center; cursor: pointer; border: 2px solid #ffc107; box-shadow: 0 2px 8px rgba(0,0,0,0.1);" title="Add Senior Photo">
                        <i class="iconsax" data-icon="add" style="font-size: 28px; color: #fff; font-weight: bold;"></i>
                        </div>
                </div>
            </div>

            <!-- Gallery Selection Modal -->
            <div class="modal fade" id="galleryModal" tabindex="-1" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-lg">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Select from Gallery</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <div id="galleryLoading" class="text-center py-4">
                                <div class="spinner-border text-primary" role="status">
                                    <span class="visually-hidden">Loading...</span>
                                </div>
                                <p class="mt-2">Loading gallery images...</p>
                            </div>
                            <div id="galleryContent" style="display: none;">
                                <div id="galleryGrid" class="d-flex flex-row" style="overflow-x: auto; overflow-y: hidden; gap: 12px; padding: 10px 0; max-height: 200px; -webkit-overflow-scrolling: touch;">
                                    <!-- Gallery images will be loaded here in horizontal sequence -->
                                </div>
                                <div id="galleryEmpty" class="text-center py-5" style="display: none;">
                                    <div class="empty-gallery-icon mb-3">
                                        <i class="iconsax" data-icon="gallery" style="font-size: 64px; color: #ccc;"></i>
                                    </div>
                                    <h6 class="mb-2" style="color: #666; font-weight: 600;">You don't have images in gallery</h6>
                                    <p class="text-muted mb-3" style="font-size: 14px;">Please upload some images to your gallery first.</p>
                                    <a href="<?= base_url('index.php/my-gallery') ?>" class="btn ecommerce-btn mt-2" style="padding: 10px 20px; font-size: 14px;">
                                        <i class="iconsax" data-icon="add" style="margin-right: 5px;"></i>
                                        Upload Images to Gallery
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Unified Editor Section - All in One -->
            <!-- EDIT SECTION COMMENTED OUT - NOT WORKING -->
            <!--
            <div id="unifiedEditorSection" class="unified-editor-section mb-4" style="display: none;">
                <div class="form-section">
                    <h5 class="section-title">
                        <i class="iconsax" data-icon="edit-2"></i> Edit Your Design
                    </h5>
                    
                    <div class="editor-mode-switcher mb-3" style="display: none;">
                        <button type="button" class="mode-btn active" id="photoModeBtn" onclick="switchEditorMode('photo')">
                            <i class="iconsax" data-icon="image"></i> Edit Photos
                        </button>
                    </div>
                    
                    <div class="image-selector-tabs mb-3" id="imageSelectorTabs" style="display: none;">
                    </div>
                    
                    <div class="image-editor-container">
                        <div class="template-preview-editor">
                            <canvas id="unifiedEditorCanvas"></canvas>
                            <div id="photoOverlaysContainer"></div>
                        </div>
                        
                        <div id="photoControlsPanel" class="advanced-controls-panel">
                            <div class="control-group">
                                <label class="control-label">
                                    <i class="iconsax" data-icon="resize"></i> Size
                                </label>
                                <input type="range" id="sizeSlider" min="10" max="200" value="100" class="control-slider" oninput="updateCurrentPhotoSize(this.value)">
                                <span class="control-value" id="sizeValue">100%</span>
                            </div>
                            
                            <div class="control-group">
                                <label class="control-label">
                                    <i class="iconsax" data-icon="rotate-right"></i> Rotation
                                </label>
                                <input type="range" id="rotationSlider" min="-180" max="180" value="0" class="control-slider" oninput="updateCurrentPhotoRotation(this.value)">
                                <span class="control-value" id="rotationValue">0°</span>
                            </div>
                            
                            <div class="control-group">
                                <label class="control-label">
                                    <i class="iconsax" data-icon="eye"></i> Opacity
                                </label>
                                <input type="range" id="opacitySlider" min="0" max="100" value="100" class="control-slider" oninput="updateCurrentPhotoOpacity(this.value)">
                                <span class="control-value" id="opacityValue">100%</span>
                            </div>
                            
                            <div class="control-group">
                                <label class="control-label">
                                    <i class="iconsax" data-icon="crop"></i> Crop Mode
                                </label>
                                <button type="button" class="btn btn-sm btn-outline-primary" id="cropModeBtn" onclick="toggleCropMode()">
                                    <i class="iconsax" data-icon="crop"></i> Enable Crop
                                </button>
                            </div>
                        </div>
                        
                        <div class="editor-controls">
                            <button type="button" class="btn btn-secondary" id="resetCurrentBtn" onclick="resetCurrentItem()">
                                <i class="iconsax" data-icon="refresh"></i> Reset Current
                            </button>
                            <button type="button" class="btn btn-warning" onclick="resetAllItems()">
                                <i class="iconsax" data-icon="refresh-left"></i> Reset All
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            -->

            <!-- Dynamic Fields Based on Template/Collection -->
            <?php
            // Determine which fields to show based on collection name or template name
            $collection_name = strtolower($template['coll_name'] ?? '');
            $template_name = strtolower($template['temp_name'] ?? '');
            $show_bike_fields = false;
            $show_custom_fields = false;
            
            // Check if this is a bike-related template
            if (strpos($collection_name, 'bike') !== false || 
                strpos($template_name, 'bike') !== false ||
                strpos($collection_name, 'motorcycle') !== false ||
                strpos($template_name, 'motorcycle') !== false) {
                $show_bike_fields = true;
            }
            
            // You can add more conditions here for other template types
            // For example: if (strpos($collection_name, 'car') !== false) { $show_car_fields = true; }
            ?>
            
            <?php if ($show_bike_fields): ?>
            <!-- Bike Details Form (only for bike templates) -->
            <div class="form-section mb-4">
                <h5 class="section-title">Bike Details</h5>
                <div class="form-group floating-label-input mb-3">
                    <input class="input-text" type="text" id="bike_company" name="bike_company" 
                           placeholder="Enter company/model name">
                    <label class="form-check-label" for="bike_company">Bike Company/Model</label>
                </div>
                <div class="form-group floating-label-input mb-3">
                    <input class="input-text" type="text" id="bike_price" name="bike_price" 
                           placeholder="Enter model price">
                    <label class="form-check-label" for="bike_price">Bike Price (₹)</label>
                </div>
            </div>
            <?php endif; ?>
            
            <!-- Text Fields Form - Hidden (Data fetched from session automatically) -->
            <?php if (!empty($template_text_fields) && is_array($template_text_fields) && count($template_text_fields) > 0): ?>
            <div class="form-section mb-4" style="display: none !important;">
                <h5 class="section-title">Enter Details</h5>
                <?php foreach ($template_text_fields as $text_field): ?>
                <div class="form-group floating-label-input mb-3">
                    <input class="input-text" 
                           type="text" 
                           id="text_field_<?= $text_field['text_field_name'] ?>" 
                           name="text_field_<?= $text_field['text_field_name'] ?>" 
                           placeholder="Enter <?= htmlspecialchars($text_field['text_label'] ?: $text_field['text_field_name']) ?>"
                           data-field-name="<?= htmlspecialchars($text_field['text_field_name']) ?>">
                    <label class="form-check-label" for="text_field_<?= $text_field['text_field_name'] ?>">
                        <?= htmlspecialchars($text_field['text_label'] ?: $text_field['text_field_name']) ?>
                    </label>
                </div>
                <?php endforeach; ?>
            </div>
            <?php endif; ?>

            <!-- CREATE Button -->
            <button type="submit" class="btn create-btn w-100 mt-4" id="generateBtn">
                <i class="iconsax" data-icon="magic-star"></i> GENERATE IMAGE
            </button>
        </form>

        <!-- Generated Image Display (hidden initially) -->
        <div id="generatedImageSection" style="display: none;" class="mt-5">
            <div class="generated-image-card">
                <h5 class="mb-3">Your Generated Image</h5>
                <div id="generatedImageContainer" class="text-center mb-3">
                    <!-- Generated image will appear here -->
                </div>
                <div class="share-buttons d-flex gap-2">
                    <button type="button" class="btn btn-primary flex-fill" id="downloadBtn" onclick="downloadImage()">
                        <i class="iconsax" data-icon="download"></i> <span id="downloadBtnText">Download</span>
                    </button>
                    <button type="button" class="btn btn-success flex-fill" onclick="shareImage()">
                        <i class="iconsax" data-icon="share"></i> Share
                    </button>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- generate image section end -->

<style>

.template-preview-wrapper {
    text-align: center;
    padding: 0;
    margin: 0;
    width: 100%;
}

.template-image-container {
    width: 100%;
    margin: 0;
    display: block;
    position: relative;
}

.template-image-container > div {
    min-height: 200px;
    max-height: 600px;
}

.template-image-container img#mainTemplateImage {
    max-height: 600px;
}

.template-save-btn-header {
    position: absolute;
    top: 15px;
    right: 15px;
    width: 45px;
    height: 45px;
    border-radius: 50%;
    border: none;
    background: rgba(255, 255, 255, 0.95);
    color: #666;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    z-index: 20;
    transition: all 0.3s ease;
    box-shadow: 0 2px 10px rgba(0,0,0,0.2);
}

.template-save-btn-header:hover {
    background: #fff;
    transform: scale(1.1);
    box-shadow: 0 4px 15px rgba(0,0,0,0.3);
}

.template-save-btn-header.saved {
    background: #ff4757;
    color: #fff;
}

.template-save-btn-header i {
    font-size: 22px;
}

/* Save Template Section (With Others Tab) */
.save-template-section {
    text-align: center;
    padding: 15px 0;
}

.save-template-btn {
    display: inline-flex;
    align-items: center;
    gap: 10px;
    padding: 14px 28px;
    border-radius: 12px;
    border: 2px solid #ffc107;
    background: #fff;
    color: #333;
    font-weight: 600;
    font-size: 16px;
    cursor: pointer;
    transition: all 0.3s ease;
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
}

.save-template-btn:hover {
    background: #ffc107;
    color: #000;
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(255,193,7,0.3);
}

.save-template-btn.saved {
    background: #ff4757;
    border-color: #ff4757;
    color: #fff;
}

.save-template-btn.saved:hover {
    background: #ff3742;
    border-color: #ff3742;
}

.save-template-btn i {
    font-size: 20px;
}

.template-preview-image {
    max-width: 100%;
    max-height: 300px;
    border-radius: 12px;
    box-shadow: 0 4px 20px rgba(0,0,0,0.3);
}

/* Photo Tabs */
.photo-tabs {
    display: flex;
    gap: 10px;
    margin-bottom: 15px;
    width: 100%;
    justify-content: space-between;
    align-items: stretch;
}

.photo-tab {
    flex: 1;
    min-width: 0;
    padding: 12px 8px;
    border: 2px solid #e0e0e0;
    border-radius: 12px;
    background: #fff;
    color: #333;
    font-weight: 600;
    font-size: 14px;
    cursor: pointer;
    transition: all 0.3s ease;
    display: flex;
    align-items: center;
    justify-content: center;
    position: relative;
    min-height: 50px;
    box-shadow: 0 1px 3px rgba(0,0,0,0.1);
    text-align: center;
}

.photo-tab span {
    font-size: 14px;
    line-height: 1.4;
    overflow: hidden;
    text-overflow: ellipsis;
    width: 100%;
    padding: 0;
    white-space: nowrap;
    text-align: center;
    box-sizing: border-box;
    display: block;
    margin: 0;
}

.photo-tab.active {
    background: #ffc107;
    color: #000;
    border-color: #ffc107;
    box-shadow: 0 2px 8px rgba(255, 193, 7, 0.3);
}

.photo-tab:hover:not(.active) {
    background: #f8f9fa;
    border-color: #ffc107;
}

.photo-tab.save-template-tab {
    display: flex;
    align-items: center;
    justify-content: center;
    min-height: 50px;
    text-align: center;
}

.photo-tab.save-template-tab span {
    padding: 0;
    text-align: center;
    width: 100%;
    display: block;
    margin: 0;
}

/* Uplines Section Styles */
.uplines-section {
    margin: 15px 0;
}

.uplines-container {
    scrollbar-width: thin;
    scrollbar-color: #ffc107 #f0f0f0;
}

.uplines-container::-webkit-scrollbar {
    height: 6px;
}

.uplines-container::-webkit-scrollbar-track {
    background: #f0f0f0;
    border-radius: 3px;
}

.uplines-container::-webkit-scrollbar-thumb {
    background: #ffc107;
    border-radius: 3px;
}

.upline-photo-item {
    transition: transform 0.2s, box-shadow 0.2s;
}

.upline-photo-item:hover {
    transform: scale(1.05);
    box-shadow: 0 4px 12px rgba(255, 193, 7, 0.4);
}

.add-upline-btn {
    transition: transform 0.2s, box-shadow 0.2s;
}

.add-upline-btn:hover {
    transform: scale(1.1);
    box-shadow: 0 4px 12px rgba(255, 193, 7, 0.4);
}

.add-upline-btn:active {
    transform: scale(0.95);
}

.remove-upline-btn:hover {
    background: #cc0000 !important;
    transform: scale(1.1);
}

.photo-tabs {
    text-align: center;
    width: 100%;
    box-sizing: border-box;
}

.photo-tab.save-template-tab.saved {
    background: #ff4757;
    color: #fff;
    border-color: #ff4757;
}

.photo-tab.save-template-tab.saved:hover {
    background: #ff3742;
    border-color: #ff3742;
}

/* Mobile Responsive for Photo Tabs */
@media (max-width: 768px) {
    .photo-tabs {
        gap: 8px;
        margin-bottom: 12px;
    }
    
    .photo-tab {
        padding: 10px 6px;
        border-radius: 10px;
        font-size: 13px;
        min-height: 48px;
    }
    
    .photo-tab span {
        font-size: 13px;
        line-height: 1.4;
        text-align: center;
        width: 100%;
        display: block;
        margin: 0;
    }
}

@media (max-width: 480px) {
    .photo-tabs {
        gap: 6px;
        margin-bottom: 10px;
    }
    
    .photo-tab {
        padding: 10px 4px;
        border-radius: 10px;
        font-size: 12px;
        min-width: 0;
        min-height: 46px;
    }
    
    .photo-tab span {
        font-size: 12px;
        line-height: 1.4;
        text-align: center;
        width: 100%;
        padding: 0;
        display: block;
        margin: 0;
    }
}

.section-title {
    color: #333;
    font-size: 16px;
    font-weight: 600;
    margin-bottom: 15px;
}

/* Image Upload Section */
.image-upload-section {
    padding: 10px;
    background: #fff;
    border-radius: 12px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.05);
}

.image-upload-grid {
    display: grid;
    grid-template-columns: repeat(4, 1fr);
    gap: 15px;
    margin-bottom: 0;
}

.image-upload-item {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 8px;
}

.image-upload-square {
    position: relative;
    width: 100%;
    padding-top: 100%; /* Makes it square */
    background: #f8f9fa;
    border: 2px dashed #ddd;
    border-radius: 12px;
    cursor: pointer;
    overflow: hidden;
    transition: all 0.3s ease;
}

.image-upload-square:hover {
    border-color: #ffc107;
    background: #fffbf0;
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(255, 193, 7, 0.2);
}

.image-placeholder {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    color: #999;
    gap: 8px;
}

.image-placeholder i {
    font-size: 36px;
    color: #ccc;
}

.image-upload-label {
    font-size: 13px;
    font-weight: 600;
    color: #666;
    text-align: center;
    margin-top: 4px;
    transition: color 0.3s ease;
    min-height: 20px;
}

.image-upload-item:hover .image-upload-label {
    color: #ffc107;
}

.image-upload-label.uploaded {
    color: #28a745;
    font-weight: 700;
}

.uploaded-image-preview {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.remove-image-btn {
    position: absolute;
    top: 5px;
    right: 5px;
    background: rgba(255,0,0,0.8);
    color: white;
    border: none;
    border-radius: 50%;
    width: 28px;
    height: 28px;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    z-index: 10;
}

/* Form Sections */
.form-section {
    background: #f5f5f5;
    padding: 20px;
    border-radius: 12px;
    margin-bottom: 20px;
    display: block !important;
    visibility: visible !important;
    width: 100%;
    box-sizing: border-box;
}

.form-section .section-title {
    color: #333;
    font-size: 18px;
    font-weight: 600;
    margin-bottom: 15px;
    margin-top: 0;
}

.form-section .floating-label-input {
    position: relative;
    width: 100%;
    margin-top: 20px;
    margin-bottom: 0;
}

.form-section .floating-label-input:first-child {
    margin-top: 0;
}

.form-section .floating-label-input > .form-check-label {
    position: absolute;
    top: 50%;
    left: 16px;
    color: #666;
    transform: translateY(-50%);
    cursor: text;
    transition: all 0.2s ease-out;
    background: transparent;
    padding: 0 5px;
    font-size: 18px;
    pointer-events: none;
    z-index: 1;
}

.form-section .floating-label-input .input-text {
    width: 100%;
    font-size: 16px;
    padding: 14px 16px;
    border: 1px solid #e0e0e0;
    border-radius: 8px;
    background: #fff;
    color: #333;
    transition: all 0.2s ease-out;
}

.form-section .floating-label-input .input-text:focus {
    outline: none;
    border-color: #ffc107;
    box-shadow: 0 0 0 3px rgba(255, 193, 7, 0.1);
}

.form-section .floating-label-input .input-text::-webkit-input-placeholder {
    opacity: 0;
}

.form-section .floating-label-input .input-text::-moz-placeholder {
    opacity: 0;
}

.form-section .floating-label-input .input-text::placeholder {
    opacity: 0;
}

.form-section .floating-label-input .input-text:focus + .form-check-label,
.form-section .floating-label-input .input-text:not(:placeholder-shown) + .form-check-label,
.form-section .floating-label-input .input-text:valid + .form-check-label {
    top: 0;
    left: 15px;
    background: #fff;
    padding: 0 8px;
    font-size: 14px;
    color: #ffc107;
    transform: translateY(-50%);
}

.form-section .form-check-label {
    color: #666;
    font-size: 16px;
}

/* CREATE Button */
.create-btn {
    background: #ffc107;
    color: #000;
    font-weight: 700;
    font-size: 18px;
    padding: 16px;
    border-radius: 12px;
    border: none;
    box-shadow: 0 4px 15px rgba(255,193,7,0.3);
}

.create-btn:hover {
    background: #ffb300;
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(255,193,7,0.4);
}

/* Generated Image Card */
.generated-image-card {
    background: #f5f5f5;
    padding: 20px;
    border-radius: 12px;
    margin-top: 20px;
}

.generated-image-card h5 {
    color: #333;
}

#generatedImageContainer img {
    max-width: 100%;
    border-radius: 12px;
    box-shadow: 0 4px 20px rgba(0,0,0,0.3);
}

.share-buttons {
    margin-top: 15px;
}

/* Unified Editor Styles */
.unified-editor-section {
    margin-top: 20px;
}

.image-editor-section {
    margin-top: 20px;
}

/* Editor Mode Switcher */
.editor-mode-switcher {
    display: flex;
    gap: 10px;
    margin-bottom: 15px;
    border-bottom: 2px solid #e0e0e0;
    padding-bottom: 10px;
}

.mode-btn {
    flex: 1;
    padding: 10px 20px;
    border: 2px solid #e0e0e0;
    background: #fff;
    color: #666;
    border-radius: 8px;
    cursor: pointer;
    transition: all 0.3s;
    font-weight: 500;
}

.mode-btn:hover {
    border-color: #007bff;
    color: #007bff;
}

.mode-btn.active {
    background: #007bff;
    color: #fff;
    border-color: #007bff;
}

.mode-btn i {
    margin-right: 5px;
}

#unifiedEditorCanvas {
    width: 100%;
    height: auto;
    display: block;
    max-height: 500px;
    object-fit: contain;
    background: #f5f5f5;
}

.section-subtitle {
    font-size: 12px;
    color: #999;
    margin-bottom: 15px;
}

.image-editor-container {
    position: relative;
    width: 100%;
}

.template-preview-editor {
    position: relative;
    width: 100%;
    max-width: 600px;
    margin: 0 auto;
    border: 2px solid #e0e0e0;
    border-radius: 8px;
    overflow: hidden;
    background: #f5f5f5;
    min-height: 300px;
}

#editorCanvas {
    width: 100%;
    height: auto;
    display: block;
    max-height: 500px;
    object-fit: contain;
    background: #f5f5f5;
}

/* Mobile Responsive */
@media (max-width: 768px) {
    .image-editor-section {
        margin-top: 15px;
        padding: 0 5px;
    }
    
    .image-editor-container {
        overflow-x: auto;
        -webkit-overflow-scrolling: touch;
        padding: 0;
    }
    
    .template-preview-editor {
        min-height: 200px;
        max-width: 100%;
        border-width: 1px;
    }
    
    #editorCanvas {
        max-height: 300px;
    }
    
    .section-subtitle {
        font-size: 11px;
        padding: 0 10px;
        margin-bottom: 10px;
    }
    
    .section-title {
        font-size: 16px;
        padding: 0 10px;
    }
    
    .user-photo-overlay {
        border-width: 2px;
    }
}

@media (max-width: 480px) {
    .template-preview-editor {
        min-height: 180px;
    }
    
    #editorCanvas {
        max-height: 250px;
    }
    
    .image-editor-section {
        padding: 0;
    }
}

.user-photo-overlay {
    position: absolute;
    cursor: move;
    border: 2px dashed #ffc107;
    background: rgba(255, 193, 7, 0.1);
    box-sizing: border-box;
    pointer-events: all;
    z-index: 10;
    touch-action: none;
    -webkit-touch-callout: none;
    -webkit-user-select: none;
    user-select: none;
    max-width: 100%;
    max-height: 100%;
    transform-origin: center center;
}

.user-photo-overlay.active {
    border-color: #ff6b35;
    border-width: 3px;
    box-shadow: 0 0 0 3px rgba(255, 107, 53, 0.3);
    z-index: 15;
}

.user-photo-overlay img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    display: block;
    pointer-events: none;
}

/* Advanced Controls Panel */
.advanced-controls-panel {
    background: #f8f9fa;
    border-radius: 12px;
    padding: 20px;
    margin-top: 20px;
    border: 1px solid #e0e0e0;
}

.control-group {
    margin-bottom: 20px;
}

.control-group:last-child {
    margin-bottom: 0;
}

.control-label {
    display: flex;
    align-items: center;
    gap: 8px;
    font-size: 14px;
    font-weight: 600;
    color: #333;
    margin-bottom: 10px;
}

.control-label i {
    font-size: 18px;
    color: #ffc107;
}

.control-slider {
    width: 100%;
    height: 6px;
    border-radius: 3px;
    background: #ddd;
    outline: none;
    -webkit-appearance: none;
    appearance: none;
}

.control-slider::-webkit-slider-thumb {
    -webkit-appearance: none;
    appearance: none;
    width: 20px;
    height: 20px;
    border-radius: 50%;
    background: #ffc107;
    cursor: pointer;
    box-shadow: 0 2px 4px rgba(0,0,0,0.2);
}

.control-slider::-moz-range-thumb {
    width: 20px;
    height: 20px;
    border-radius: 50%;
    background: #ffc107;
    cursor: pointer;
    border: none;
    box-shadow: 0 2px 4px rgba(0,0,0,0.2);
}

.control-value {
    display: inline-block;
    min-width: 50px;
    text-align: right;
    font-size: 13px;
    font-weight: 600;
    color: #666;
    margin-left: 10px;
}

/* Image Selector Tabs */
.image-selector-tabs {
    display: flex;
    gap: 10px;
    flex-wrap: wrap;
    padding: 10px;
    background: #f8f9fa;
    border-radius: 8px;
}

.image-selector-tab {
    flex: 1;
    min-width: 100px;
    padding: 10px 15px;
    background: #fff;
    border: 2px solid #ddd;
    border-radius: 8px;
    cursor: pointer;
    text-align: center;
    font-size: 13px;
    font-weight: 600;
    color: #666;
    transition: all 0.3s ease;
}

.image-selector-tab:hover {
    border-color: #ffc107;
    color: #ffc107;
}

.image-selector-tab.active {
    background: #ffc107;
    border-color: #ffc107;
    color: #fff;
}

.image-selector-tab.has-image {
    position: relative;
}

.image-selector-tab.has-image::before {
    content: '✓';
    position: absolute;
    top: 5px;
    right: 5px;
    width: 18px;
    height: 18px;
    background: #28a745;
    color: #fff;
    border-radius: 50%;
    font-size: 11px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: bold;
}

.resize-handles {
    position: absolute;
    width: 100%;
    height: 100%;
    top: 0;
    left: 0;
    pointer-events: none;
}

.handle {
    position: absolute;
    width: 12px;
    height: 12px;
    background: #ffc107;
    border: 2px solid #fff;
    border-radius: 50%;
    pointer-events: all;
    cursor: nwse-resize;
    touch-action: none;
    -webkit-touch-callout: none;
}

@media (max-width: 768px) {
    .handle {
        width: 16px;
        height: 16px;
        border-width: 2px;
    }
}

.handle-nw {
    top: -6px;
    left: -6px;
    cursor: nwse-resize;
}

.handle-ne {
    top: -6px;
    right: -6px;
    cursor: nesw-resize;
}

.handle-sw {
    bottom: -6px;
    left: -6px;
    cursor: nesw-resize;
}

.handle-se {
    bottom: -6px;
    right: -6px;
    cursor: nwse-resize;
}

.editor-controls {
    display: flex;
    gap: 10px;
    justify-content: center;
    margin-top: 15px;
}

.editor-controls .btn {
    padding: 10px 20px;
    border-radius: 8px;
    font-weight: 600;
}

@media (max-width: 768px) {
    .editor-controls {
        gap: 8px;
        margin-top: 12px;
        flex-wrap: wrap;
        padding: 0 10px;
    }
    
    .editor-controls .btn {
        padding: 12px 16px;
        font-size: 14px;
        flex: 1;
        min-width: 100px;
        max-width: 200px;
    }
}

/* Horizontal Gallery Styles - Like Screenshot */
#galleryGrid, #gallerySectionGrid {
    scrollbar-width: thin;
    scrollbar-color: #ffc107 #f0f0f0;
}

#galleryGrid::-webkit-scrollbar, #gallerySectionGrid::-webkit-scrollbar {
    height: 6px;
}

#galleryGrid::-webkit-scrollbar-track, #gallerySectionGrid::-webkit-scrollbar-track {
    background: #f0f0f0;
    border-radius: 10px;
}

#galleryGrid::-webkit-scrollbar-thumb, #gallerySectionGrid::-webkit-scrollbar-thumb {
    background: #ffc107;
    border-radius: 10px;
}

#galleryGrid::-webkit-scrollbar-thumb:hover, #gallerySectionGrid::-webkit-scrollbar-thumb:hover {
    background: #ffb300;
}

.gallery-item-horizontal {
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
}

.gallery-item-horizontal:hover {
    box-shadow: 0 4px 12px rgba(255,193,7,0.4);
}

.gallery-item-horizontal img {
    transition: transform 0.3s ease;
}

.gallery-item-horizontal:hover img {
    transform: scale(1.1);
}

/* Background Removal Loader */
.bg-removal-loader {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(0, 0, 0, 0.7);
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    border-radius: 8px;
    z-index: 10;
}

/* Upline Upload Loader */
.upline-upload-loader {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(255, 255, 255, 0.95);
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    border-radius: 12px;
    z-index: 100;
    backdrop-filter: blur(2px);
}

/* Global Loader Overlay */
.global-loader-overlay {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0, 0, 0, 0.8);
    z-index: 99999;
    display: flex;
    align-items: center;
    justify-content: center;
    flex-direction: column;
    backdrop-filter: blur(3px);
}

/* Gallery Section Below Template */
.gallery-section-below-template {
    background: #f8f9fa;
    border-radius: 12px;
    padding: 8px 8px 8px 0;
    margin-top: 10px;
    margin-left: 0;
}

/* Reduce padding when gallery is empty */
.gallery-section-below-template:has(#gallerySectionEmpty[style*="display: block"]) {
    padding: 8px 8px 10px 0;
}

.gallery-section-title {
    font-size: 14px;
    font-weight: 600;
    color: #666;
    text-align: center;
    margin-bottom: 8px;
}

#gallerySectionGrid {
    justify-content: flex-start;
    align-items: center;
}

@media (max-width: 768px) {
    .gallery-section-below-template {
        padding: 12px 12px 12px 0;
    }
    
    .gallery-item-horizontal {
        width: 80px !important;
        height: 80px !important;
    }
}

/* Text Fields Styling - Ensure font size is properly applied */
.template-text-field {
    font-size: inherit !important;
    font-weight: normal;
    line-height: 1.2;
    word-wrap: break-word;
    max-width: 100%;
}

.template-text-field * {
    font-size: inherit !important;
}
</style>

<script>
let uploadedImages = {};
let activeTab = 'my-photo';
let currentEditingIndex = 0; // Which image is currently being edited (0-3)
let photoAdjustments = {}; // Store adjustments for each image: {0: {x, y, width, height, rotation, opacity}, 1: {...}, ...}
let allPhotoOverlays = {}; // Store all overlay elements: {0: overlayElement, 1: overlayElement, ...}

// Admin-set positions from template (multiple positions support)
let adminImagePositions = [];
let currentImageIndex = 0; // Track which image index we're on (for sequence mapping)

// Text fields from template
let templateTextFields = [];
<?php if (!empty($template_text_fields) && is_array($template_text_fields) && count($template_text_fields) > 0): ?>
    templateTextFields = <?= json_encode($template_text_fields, JSON_HEX_TAG | JSON_HEX_AMP | JSON_HEX_APOS | JSON_HEX_QUOT) ?>;
    console.log('Text fields loaded:', templateTextFields);
<?php endif; ?>

// Session data for text fields (fetched from PHP session)
let sessionData = {};
<?php
// Get all session data that might be used in text fields
$session_fields = array();
if (!empty($template_text_fields) && is_array($template_text_fields)) {
    foreach ($template_text_fields as $text_field) {
        $field_name = $text_field['text_field_name'];
        $field_value = null;
        
        // Priority 1: Check direct session variable with field name
        if (isset($_SESSION[$field_name]) && !empty($_SESSION[$field_name])) {
            $field_value = $_SESSION[$field_name];
        }
        // Priority 2: Check common session field names
        elseif ($field_name == 'name' && isset($_SESSION['name'])) {
            $field_value = $_SESSION['name'];
        }
        elseif ($field_name == 'email' && isset($_SESSION['email'])) {
            $field_value = $_SESSION['email'];
        }
        elseif ($field_name == 'phone' && isset($_SESSION['phone'])) {
            $field_value = $_SESSION['phone'];
        }
        // Priority 3: Check user_data array if available
        elseif (isset($user_data) && is_array($user_data) && isset($user_data[$field_name]) && !empty($user_data[$field_name])) {
            $field_value = $user_data[$field_name];
        }
        // Priority 4: Check user_data for common fields
        elseif (isset($user_data) && is_array($user_data)) {
            if ($field_name == 'name' && isset($user_data['name'])) {
                $field_value = $user_data['name'];
            }
            elseif ($field_name == 'email' && isset($user_data['email'])) {
                $field_value = $user_data['email'];
            }
            elseif ($field_name == 'phone' && isset($user_data['phone'])) {
                $field_value = $user_data['phone'];
            }
        }
        
        // Add to session_fields if value found
        if ($field_value !== null) {
            $session_fields[$field_name] = $field_value;
        }
    }
}
?>
sessionData = <?= json_encode($session_fields, JSON_HEX_TAG | JSON_HEX_AMP | JSON_HEX_APOS | JSON_HEX_QUOT) ?>;
console.log('Session data loaded for text fields:', sessionData);
console.log('Available session fields:', Object.keys(sessionData));

// Load multiple positions from database table
<?php 
// Debug: Log positions count
error_log('Template ID: ' . $template['temp_id'] . ' - PHP Positions Count: ' . (isset($template_positions) ? count($template_positions) : 0));
if (isset($template_positions) && is_array($template_positions)) {
    error_log('Template Positions: ' . print_r($template_positions, true));
}
?>
<?php 
// Debug: Check positions before JSON encoding
$positions_count = isset($template_positions) && is_array($template_positions) ? count($template_positions) : 0;
error_log('=== VIEW DEBUG ===');
error_log('Template ID: ' . $template['temp_id']);
error_log('Positions count in view: ' . $positions_count);
if (isset($template_positions) && is_array($template_positions)) {
    error_log('Positions data in view: ' . print_r($template_positions, true));
    error_log('JSON encoded: ' . json_encode($template_positions));
}
error_log('==================');
?>
<?php if (!empty($template_positions) && is_array($template_positions) && count($template_positions) > 0): ?>
    adminImagePositions = <?= json_encode($template_positions, JSON_HEX_TAG | JSON_HEX_AMP | JSON_HEX_APOS | JSON_HEX_QUOT) ?>;
    
    // Ensure positions are sorted by pos_order (should already be sorted from database, but double-check)
    adminImagePositions.sort(function(a, b) {
        const orderA = (a.pos_order !== undefined && a.pos_order !== null) ? parseInt(a.pos_order) : 999;
        const orderB = (b.pos_order !== undefined && b.pos_order !== null) ? parseInt(b.pos_order) : 999;
        return orderA - orderB;
    });
    
    console.log('=== Positions Loaded from Database ===');
    console.log('Template ID: <?= $template['temp_id'] ?>');
    console.log('Total positions:', <?= count($template_positions) ?>);
    console.log('Positions array:', adminImagePositions);
    console.log('Array length:', adminImagePositions.length);
    console.log('Position 0:', adminImagePositions[0]);
    console.log('Position 1:', adminImagePositions[1]);
    console.log('Position 2:', adminImagePositions[2]);
    console.log('Full array keys:', Object.keys(adminImagePositions));
    console.log('=====================================');
    
    // Verify positions are properly loaded
    if (adminImagePositions.length < 2) {
        console.error('WARNING: Expected 2 positions but only ' + adminImagePositions.length + ' loaded!');
    }
<?php else: ?>
    console.log('=== NO POSITIONS FOUND ===');
    console.log('Template ID: <?= $template['temp_id'] ?>');
    console.log('template_positions:', <?= isset($template_positions) ? json_encode($template_positions) : 'null' ?>);
    console.log('========================');
    // Fallback to single position (backward compatibility)
    const singlePos = {
        x: <?= !empty($template['temp_image_x']) ? intval($template['temp_image_x']) : 'null' ?>,
        y: <?= !empty($template['temp_image_y']) ? intval($template['temp_image_y']) : 'null' ?>,
        width: <?= !empty($template['temp_image_width']) ? intval($template['temp_image_width']) : 'null' ?>,
        height: <?= !empty($template['temp_image_height']) ? intval($template['temp_image_height']) : 'null' ?>
    };
    if (singlePos.x !== null && singlePos.y !== null && singlePos.width !== null && singlePos.height !== null) {
        adminImagePositions = [singlePos];
    }
<?php endif; ?>

// Get position for current image index (sequence wise)
function getAdminPositionForIndex(index) {
    console.log('=== getAdminPositionForIndex CALLED ===');
    console.log('Requested index:', index);
    console.log('adminImagePositions.length:', adminImagePositions.length);
    console.log('adminImagePositions:', adminImagePositions);
    
    if (adminImagePositions.length === 0) {
        console.log('No admin positions available');
        return null;
    }
    
    // Use direct index mapping (0 -> position 0, 1 -> position 1, etc.)
    // If more images than positions, cycle back (but that shouldn't happen)
    const positionIndex = index < adminImagePositions.length ? index : (index % adminImagePositions.length);
    const selectedPosition = adminImagePositions[positionIndex];
    
    console.log('positionIndex:', positionIndex);
    console.log('selectedPosition:', selectedPosition);
    console.log('=====================================');
    
    return selectedPosition;
}

// Find next available image index (sequential assignment - no overwrite)
function getNextAvailableImageIndex() {
    // Count total images that are already on template
    let maxIndex = -1;
    
    // Check uploadedImages for highest index
    if (uploadedImages) {
        Object.keys(uploadedImages).forEach(key => {
            const idx = parseInt(key);
            if (!isNaN(idx) && uploadedImages[key] && uploadedImages[key].preview) {
                if (idx > maxIndex) {
                    maxIndex = idx;
                }
            }
        });
    }
    
    // Check templateOverlayPosition for highest index
    if (templateOverlayPosition && typeof templateOverlayPosition === 'object') {
        Object.keys(templateOverlayPosition).forEach(key => {
            const idx = parseInt(key);
            if (!isNaN(idx) && templateOverlayPosition[key]) {
                if (idx > maxIndex) {
                    maxIndex = idx;
                }
            }
        });
    }
    
    // Check if overlay elements exist in DOM
    const overlayDiv = document.getElementById('templateImageOverlay');
    if (overlayDiv) {
        const existingOverlays = overlayDiv.querySelectorAll('img[id^="overlayUserImage-"]');
        existingOverlays.forEach(overlay => {
            const id = overlay.id;
            const match = id.match(/overlayUserImage-(\d+)/);
            if (match) {
                const idx = parseInt(match[1]);
                if (!isNaN(idx) && idx > maxIndex) {
                    maxIndex = idx;
                }
            }
        });
    }
    
    const nextIndex = maxIndex + 1;
    console.log('=== getNextAvailableImageIndex ===');
    console.log('uploadedImages:', uploadedImages);
    console.log('templateOverlayPosition:', templateOverlayPosition);
    console.log('maxIndex found:', maxIndex);
    console.log('nextIndex returned:', nextIndex);
    console.log('===============================');
    
    // Return the next sequential index (maxIndex + 1)
    return nextIndex;
}
// Photo editor drag/resize variables
let isDragging = false;
let isResizing = false;
let dragStartX = 0;
let dragStartY = 0;

let templateImageLoaded = false;
let templateCanvas = null;
let templateCtx = null;
let actualTemplateWidth = 0;
let actualTemplateHeight = 0;
let canvasDisplayScale = 1; // Scale factor between displayed size and actual size

// Set template dimensions when image loads (must be defined early for onload attribute)
function setTemplateDimensions(img) {
    actualTemplateWidth = img.naturalWidth || img.width;
    actualTemplateHeight = img.naturalHeight || img.height;
    console.log('Template dimensions set:', actualTemplateWidth, 'x', actualTemplateHeight);
    
    // If images are already set, recalculate their positions
    if (typeof setImageOnTemplateHelper === 'function') {
        // Recalculate all existing overlay positions
        const overlayDiv = document.getElementById('templateImageOverlay');
        if (overlayDiv) {
            const existingOverlays = overlayDiv.querySelectorAll('img[id^="overlayUserImage-"]');
            existingOverlays.forEach(overlay => {
                const id = overlay.id;
                const match = id.match(/overlayUserImage-(\d+)/);
                if (match) {
                    const idx = parseInt(match[1]);
                    if (currentTemplateImage && currentTemplateImage[idx]) {
                        setTimeout(function() {
                            setImageOnTemplateHelper(
                                currentTemplateImage[idx].preview,
                                currentTemplateImage[idx].imageName,
                                currentTemplateImage[idx].file,
                                idx
                            );
                        }, 100);
                    }
                }
            });
        }
    }
    
    // Load saved upline photos after template is loaded
    if (typeof loadSavedUplines === 'function') {
        setTimeout(function() {
            loadSavedUplines();
        }, 500);
    }
    
    // Render text fields on template
    renderTextFieldsOnTemplate();
}

// Render text fields on template preview
function renderTextFieldsOnTemplate() {
    const textFieldsOverlay = document.getElementById('templateTextFieldsOverlay');
    if (!textFieldsOverlay || !templateTextFields || templateTextFields.length === 0) {
        return;
    }
    
    // Clear existing text fields
    textFieldsOverlay.innerHTML = '';
    
    const templateImg = document.getElementById('mainTemplateImage');
    if (!templateImg) return;
    
    // Calculate display scale (how much the template is scaled down for display)
    const displayScale = templateImg.offsetWidth / templateImg.naturalWidth;
    
    // Debug: Log scale calculation
    console.log('Font size calculation - Display scale:', displayScale, 'Template width:', templateImg.naturalWidth, 'Display width:', templateImg.offsetWidth);
    
    templateTextFields.forEach(function(textField) {
        const fieldName = textField.text_field_name;
        
        // Get text value from session data (priority)
        let textValue = getSessionValue(fieldName);
        
        // Fallback to input element if exists (for backward compatibility)
        if (!textValue) {
            const inputElement = document.getElementById('text_field_' + fieldName);
            if (inputElement) {
                textValue = inputElement.value.trim();
            }
        }
        
        if (!textValue) {
            console.log('No value found for field:', fieldName);
            return; // Don't render if no value
        }
        
        // Calculate position (admin-set position)
        const x = (textField.text_x || 0) * displayScale;
        const y = (textField.text_y || 0) * displayScale;
        const width = textField.text_width ? (textField.text_width * displayScale) : 'auto';
        const height = textField.text_height ? (textField.text_height * displayScale) : 'auto';
        
        // Calculate font size - scale it properly for display
        // Font size is stored in actual template pixels, need to scale for display
        const actualFontSize = parseInt(textField.text_font_size) || 16;
        const displayFontSize = actualFontSize * displayScale;
        
        // Create text element
        const textElement = document.createElement('div');
        textElement.className = 'template-text-field';
        textElement.dataset.fieldName = fieldName;
        textElement.textContent = textValue;
        textElement.style.cssText = `
            position: absolute;
            left: ${x}px;
            top: ${y}px;
            width: ${width};
            height: ${height};
            font-size: ${displayFontSize}px !important;
            color: ${textField.text_color || '#000000'};
            font-family: ${textField.text_font_family || 'Arial'};
            text-align: ${textField.text_align || 'left'};
            pointer-events: none;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
            z-index: 6;
            line-height: 1.2;
        `;
        
        textFieldsOverlay.appendChild(textElement);
        console.log('Text field rendered:', {
            fieldName: fieldName,
            value: textValue,
            position: {x: x, y: y},
            fontSize: {
                actual: actualFontSize,
                display: displayFontSize,
                displayScale: displayScale
            }
        });
    });
    
    // Show overlay
    textFieldsOverlay.style.display = 'block';
}

// Get value from session data
function getSessionValue(fieldName) {
    // First check sessionData object (from PHP session)
    if (sessionData && sessionData[fieldName]) {
        return sessionData[fieldName];
    }
    
    // Return null if not found
    return null;
}

// Auto-render text fields on page load (no input fields needed - data from session)
document.addEventListener('DOMContentLoaded', function() {
    // Initial render after template loads (with session data)
    setTimeout(function() {
        renderTextFieldsOnTemplate();
    }, 1000);
    
    // Also render when template image loads
    const templateImg = document.getElementById('mainTemplateImage');
    if (templateImg) {
        if (templateImg.complete) {
            setTimeout(function() {
                renderTextFieldsOnTemplate();
            }, 500);
        } else {
            templateImg.addEventListener('load', function() {
                setTimeout(function() {
                    renderTextFieldsOnTemplate();
                }, 500);
            });
        }
    }
});

function switchTab(tab) {
    activeTab = tab;
    document.querySelectorAll('.photo-tab').forEach(btn => {
        btn.classList.remove('active');
    });
    const tabBtn = document.querySelector(`[data-tab="${tab}"]`);
    if (tabBtn) {
        tabBtn.classList.add('active');
    }
}

// Open Gallery Modal (kept for backward compatibility, but not used)
function openGalleryModal() {
    // Load gallery images below template instead of modal
    loadGalleryImagesBelowTemplate();
}

// Load gallery images below template (new function)
function loadGalleryImagesBelowTemplate() {
    const loadingDiv = document.getElementById('gallerySectionLoading');
    const contentDiv = document.getElementById('gallerySectionContent');
    const emptyDiv = document.getElementById('gallerySectionEmpty');
    const gridDiv = document.getElementById('gallerySectionGrid');
    
    loadingDiv.style.display = 'block';
    contentDiv.style.display = 'block';
    emptyDiv.style.display = 'none';
    gridDiv.style.display = 'none'; // Hide grid initially
    gridDiv.innerHTML = '';
    
    $.ajax({
        url: '<?= base_url('index.php/main/get_gallery_images') ?>',
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            loadingDiv.style.display = 'none';
            
            // Handle both string and object responses
            let responseData = response;
            if (typeof response === 'string') {
                try {
                    responseData = JSON.parse(response);
                } catch (e) {
                    console.error('Error parsing response:', e);
                    emptyDiv.style.display = 'block';
                    emptyDiv.innerHTML = '<p class="text-danger" style="font-size: 12px;">Error loading gallery. Please try again.</p>';
                    return;
                }
            }
            
            if (responseData.success && responseData.images && responseData.images.length > 0) {
                emptyDiv.style.display = 'none';
                gridDiv.style.display = 'flex'; // Show grid when images are available
                
                // Show gallery section wrapper
                const galleryWrapper = document.getElementById('gallerySectionWrapper');
                if (galleryWrapper) galleryWrapper.style.display = 'block';
                
                responseData.images.forEach(function(image) {
                    // Escape image URL and name to prevent XSS
                    const safeImageUrl = image.image_url.replace(/'/g, "\\'");
                    const safeImageName = (image.image_name || 'Image').replace(/'/g, "\\'");
                    
                    // Create horizontal gallery item (like screenshot - multiple images in one line)
                    const galleryItem = document.createElement('div');
                    galleryItem.className = 'gallery-item-horizontal';
                    galleryItem.style.cssText = 'flex-shrink: 0; width: 100px; height: 100px; position: relative; cursor: pointer; border-radius: 8px; overflow: hidden; border: 2px solid #e0e0e0; transition: all 0.3s;';
                    galleryItem.innerHTML = `
                        <img src="${safeImageUrl}" 
                             alt="${safeImageName}" 
                             class="img-fluid" 
                             style="width: 100%; height: 100%; object-fit: cover;"
                             onerror="this.src='<?= base_url('assets/theme/v1/social-app/assets/images/profile/p3.png') ?>'">
                        <div class="gallery-select-overlay" style="position: absolute; top: 0; left: 0; right: 0; bottom: 0; background: rgba(0,0,0,0.3); display: flex; align-items: center; justify-content: center; opacity: 0; transition: opacity 0.3s;">
                            <i class="iconsax" data-icon="tick-circle" style="font-size: 20px; color: #fff;"></i>
                        </div>
                    `;
                    
                    // Add click handler - remove background then overlay image on template preview
                    galleryItem.onclick = function() {
                        // Show loading
                        const loader = document.getElementById('bgRemovalLoader');
                        if (loader) loader.style.display = 'flex';
                        
                        // Fetch image and remove background
                        fetch(safeImageUrl)
                            .then(response => response.blob())
                            .then(blob => {
                                const file = new File([blob], safeImageName, { type: blob.type });
                                removeBackground(file, function(processedFile, processedPreviewUrl) {
                                    // Get next available index
                                    const imageIndex = getNextAvailableImageIndex();
                                    
                                    // Store in uploadedImages BEFORE calling setImageOnTemplate
                                    uploadedImages[imageIndex] = {
                                        file: processedFile,
                                        preview: processedPreviewUrl,
                                        imageUrl: processedPreviewUrl,
                                        imageName: safeImageName,
                                        fromGallery: true,
                                        index: imageIndex
                                    };
                                    
                                    // Set currentImageIndex
                                    currentImageIndex = imageIndex;
                                    
                                    console.log('Gallery image clicked - stored at index', imageIndex);
                                    
                                    // Hide loading
                                    if (loader) loader.style.display = 'none';
                                    // Set on template with explicit index
                                    setImageOnTemplate(processedPreviewUrl, safeImageName, processedFile, imageIndex);
                                });
                            })
                            .catch(error => {
                                console.error('Error loading gallery image:', error);
                                if (loader) loader.style.display = 'none';
                                alert('Error loading image from gallery. Please try again.');
                            });
                    };
                    
                    // Add hover effects
                    galleryItem.onmouseover = function() {
                        this.style.borderColor = '#ffc107';
                        this.style.transform = 'scale(1.05)';
                        this.querySelector('.gallery-select-overlay').style.opacity = '1';
                    };
                    galleryItem.onmouseout = function() {
                        this.style.borderColor = '#e0e0e0';
                        this.style.transform = 'scale(1)';
                        this.querySelector('.gallery-select-overlay').style.opacity = '0';
                    };
                    
                    gridDiv.appendChild(galleryItem);
                });
            } else {
                emptyDiv.style.display = 'block';
                gridDiv.style.display = 'none'; // Hide grid when no images
                
                // Hide entire gallery section when no images
                const galleryWrapper = document.getElementById('gallerySectionWrapper');
                if (galleryWrapper) galleryWrapper.style.display = 'none';
            }
        },
        error: function(xhr, status, error) {
            console.error('AJAX Error:', status, error);
            loadingDiv.style.display = 'none';
            emptyDiv.style.display = 'block';
            gridDiv.style.display = 'none'; // Hide grid on error
            
            // Hide entire gallery section on error
            const galleryWrapper = document.getElementById('gallerySectionWrapper');
            if (galleryWrapper) galleryWrapper.style.display = 'none';
            
            emptyDiv.innerHTML = '<p class="text-danger" style="font-size: 12px;">Error loading gallery. Please try again.</p>';
        }
    });
}

// Load gallery images via AJAX
function loadGalleryImages() {
    const loadingDiv = document.getElementById('galleryLoading');
    const contentDiv = document.getElementById('galleryContent');
    const emptyDiv = document.getElementById('galleryEmpty');
    const gridDiv = document.getElementById('galleryGrid');
    
    loadingDiv.style.display = 'block';
    contentDiv.style.display = 'none';
    emptyDiv.style.display = 'none';
    gridDiv.innerHTML = '';
    
    $.ajax({
        url: '<?= base_url('index.php/main/get_gallery_images') ?>',
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            loadingDiv.style.display = 'none';
            
            // Handle both string and object responses
            let responseData = response;
            if (typeof response === 'string') {
                try {
                    responseData = JSON.parse(response);
                } catch (e) {
                    console.error('Error parsing response:', e);
                    emptyDiv.style.display = 'block';
                    emptyDiv.innerHTML = '<p class="text-danger">Error parsing server response. Please try again.</p>';
                    return;
                }
            }
            
            if (responseData.success && responseData.images && responseData.images.length > 0) {
                contentDiv.style.display = 'block';
                
                responseData.images.forEach(function(image) {
                    // Escape image URL and name to prevent XSS
                    const safeImageUrl = image.image_url.replace(/'/g, "\\'");
                    const safeImageName = (image.image_name || 'Image').replace(/'/g, "\\'");
                    
                    // Create horizontal gallery item (like screenshot - multiple images in one line)
                    const galleryItem = document.createElement('div');
                    galleryItem.className = 'gallery-item-horizontal';
                    galleryItem.style.cssText = 'flex-shrink: 0; width: 120px; height: 120px; position: relative; cursor: pointer; border-radius: 8px; overflow: hidden; border: 2px solid #e0e0e0; transition: all 0.3s;';
                    galleryItem.innerHTML = `
                            <img src="${safeImageUrl}" 
                                 alt="${safeImageName}" 
                             class="img-fluid" 
                             style="width: 100%; height: 100%; object-fit: cover;"
                                 onerror="this.src='<?= base_url('assets/theme/v1/social-app/assets/images/profile/p3.png') ?>'">
                        <div class="gallery-select-overlay" style="position: absolute; top: 0; left: 0; right: 0; bottom: 0; background: rgba(0,0,0,0.3); display: flex; align-items: center; justify-content: center; opacity: 0; transition: opacity 0.3s;">
                            <i class="iconsax" data-icon="tick-circle" style="font-size: 24px; color: #fff;"></i>
                        </div>
                    `;
                    
                    // Add click handler
                    galleryItem.onclick = function() {
                        selectGalleryImage(safeImageUrl, safeImageName);
                    };
                    
                    // Add hover effects
                    galleryItem.onmouseover = function() {
                        this.style.borderColor = '#ffc107';
                        this.style.transform = 'scale(1.05)';
                        this.querySelector('.gallery-select-overlay').style.opacity = '1';
                    };
                    galleryItem.onmouseout = function() {
                        this.style.borderColor = '#e0e0e0';
                        this.style.transform = 'scale(1)';
                        this.querySelector('.gallery-select-overlay').style.opacity = '0';
                    };
                    
                    gridDiv.appendChild(galleryItem);
                });
            } else {
                contentDiv.style.display = 'block';
                emptyDiv.style.display = 'block';
                gridDiv.style.display = 'none';
            }
        },
        error: function(xhr, status, error) {
            console.error('AJAX Error:', status, error);
            console.error('Response:', xhr.responseText);
            loadingDiv.style.display = 'none';
            contentDiv.style.display = 'block';
            emptyDiv.style.display = 'block';
            gridDiv.style.display = 'none';
            emptyDiv.innerHTML = '<div class="text-center" style="padding: 8px 0;"><p class="text-muted mb-1" style="font-size: 12px; margin: 0;">No images in gallery</p><a href="<?= base_url('index.php/my-gallery') ?>" class="btn btn-sm ecommerce-btn mt-1" style="padding: 6px 12px; font-size: 11px;"><i class="iconsax" data-icon="add" style="margin-right: 4px; font-size: 12px;"></i>Upload Images</a></div>';
        }
    });
}

// Select image from gallery and add to upload grid (for modal - kept for compatibility)
function selectGalleryImage(imageUrl, imageName) {
    // Get next available sequential index (no overwrite)
    const imageIndex = getNextAvailableImageIndex();
    
    // Fetch image and convert to blob/file
    fetch(imageUrl)
        .then(response => response.blob())
        .then(blob => {
            const file = new File([blob], imageName, { type: blob.type });
            const previewUrl = URL.createObjectURL(blob);
            
            // Remove background first
            removeBackground(file, function(processedFile, processedPreviewUrl) {
                // Store image in uploadedImages array with the calculated index
                uploadedImages[imageIndex] = {
                    file: processedFile,
                    preview: processedPreviewUrl,
                    imageUrl: processedPreviewUrl,
                    imageName: imageName,
                    fromGallery: true,
                    index: imageIndex
                };
                
                // Set currentImageIndex to the calculated imageIndex BEFORE calling setImageOnTemplate
                // This ensures the correct position is used
                currentImageIndex = imageIndex;
                
                console.log('Gallery image selected - imageIndex:', imageIndex, 'imageName:', imageName);
                console.log('uploadedImages before setImageOnTemplate:', uploadedImages);
                
                // Use setImageOnTemplate to display image on template (same as upload)
                // Pass imageIndex explicitly to ensure correct mapping
                setImageOnTemplate(processedPreviewUrl, imageName, processedFile, imageIndex);
            });
        })
        .catch(error => {
            console.error('Error loading gallery image:', error);
            alert('Error loading image from gallery. Please try again.');
        });
}

// Select image from gallery and directly set to template position (NEW - for below template gallery)
// Set image directly on template preview (NEW - Only 1 image at a time)
let currentTemplateImage = null; // Store current image data
let templateOverlayPosition = { x: 0, y: 0, width: 0, height: 0 }; // Store overlay position

function setImageOnTemplate(imageUrl, imageName, file, imageIndexParam) {
    const overlayDiv = document.getElementById('templateImageOverlay');
    const templateImg = document.getElementById('mainTemplateImage');
    
    if (!overlayDiv || !templateImg) {
        console.error('Template overlay elements not found');
        return;
    }
    
    // Use provided imageIndex or fallback to currentImageIndex
    // This ensures correct index mapping even if currentImageIndex changes
    const imageIndex = (imageIndexParam !== undefined && imageIndexParam !== null) ? imageIndexParam : currentImageIndex;
    
    // Update currentImageIndex to match (for consistency)
    if (imageIndexParam !== undefined && imageIndexParam !== null) {
        currentImageIndex = imageIndexParam;
    }
    
    console.log('=== setImageOnTemplate CALLED ===');
    console.log('imageIndex:', imageIndex);
    console.log('currentImageIndex:', currentImageIndex);
    console.log('imageName:', imageName);
    console.log('uploadedImages:', uploadedImages);
    console.log('================================');
    
    // Use provided file or fetch from URL
    let processedFile = file;
    let previewUrl = imageUrl;
    
    if (!processedFile) {
    // Convert image URL to blob/file-like object
    fetch(imageUrl)
        .then(response => response.blob())
        .then(blob => {
                processedFile = new File([blob], imageName, { type: blob.type });
                previewUrl = URL.createObjectURL(blob);
                setImageOnTemplateHelper(previewUrl, imageName, processedFile, imageIndex);
            })
            .catch(error => {
                console.error('Error loading image:', error);
                alert('Error loading image. Please try again.');
            });
        return;
    }
    
    setImageOnTemplateHelper(previewUrl, imageName, processedFile, imageIndex);
}

function setImageOnTemplateHelper(previewUrl, imageName, processedFile, imageIndex) {
    const overlayDiv = document.getElementById('templateImageOverlay');
    const templateImg = document.getElementById('mainTemplateImage');
    
    if (!overlayDiv || !templateImg) {
        console.error('Template overlay elements not found');
        return;
    }
    
    // Use the passed imageIndex (don't rely on currentImageIndex which might have changed)
    if (imageIndex === undefined || imageIndex === null) {
        imageIndex = currentImageIndex;
    }
    
    console.log('=== setImageOnTemplateHelper CALLED ===');
    console.log('imageIndex (passed):', imageIndex);
    console.log('currentImageIndex (current):', currentImageIndex);
    console.log('imageName:', imageName);
    console.log('Existing overlays in DOM:', overlayDiv.querySelectorAll('img[id^="overlayUserImage-"]').length);
    console.log('=====================================');
    
    // Get admin position early to determine z-index
    const adminPosition = getAdminPositionForIndex(imageIndex);
    
    // Calculate z-index: lower index = higher z-index (so first image stays on top)
    let zIndexValue = 100 - imageIndex; // First image (index 0) gets z-index 100, second gets 99, etc.
    if (adminPosition && adminPosition.pos_order !== undefined && adminPosition.pos_order !== null) {
        // Use pos_order: lower pos_order = higher z-index (appears on top)
        zIndexValue = 100 - adminPosition.pos_order;
    }
    
    // GUIDELINE: Create position container for each admin-defined position
    // Each position gets its own container div, user image renders inside it
    let positionContainer = document.getElementById(`positionContainer-${imageIndex}`);
    let overlayImg = null;
    
    if (!positionContainer) {
        // Create position container div (GUIDELINE: container for each position)
        positionContainer = document.createElement('div');
        positionContainer.id = `positionContainer-${imageIndex}`;
        positionContainer.className = 'position-container';
        positionContainer.setAttribute('data-position-index', imageIndex);
        positionContainer.style.cssText = 'position: absolute; pointer-events: auto; border: 2px dashed #ffc107; border-radius: 4px; overflow: hidden; z-index: ' + zIndexValue + '; display: none;';
        overlayDiv.appendChild(positionContainer);
        
        // Create user image element inside position container (GUIDELINE: image inside container)
        overlayImg = document.createElement('img');
        overlayImg.id = `overlayUserImage-${imageIndex}`;
        overlayImg.alt = `User Image ${imageIndex + 1}`;
        // GUIDELINE: Use object-fit: cover, width: 100%, height: 100% for proper fitting
        overlayImg.style.cssText = 'width: 100%; height: 100%; object-fit: cover; display: block; pointer-events: none;';
        positionContainer.appendChild(overlayImg);
        
        console.log('✅ Created position container and image element for index:', imageIndex);
    } else {
        // Container exists, get the image element inside it
        overlayImg = positionContainer.querySelector(`#overlayUserImage-${imageIndex}`);
        if (!overlayImg) {
            overlayImg = document.createElement('img');
            overlayImg.id = `overlayUserImage-${imageIndex}`;
            overlayImg.alt = `User Image ${imageIndex + 1}`;
            overlayImg.style.cssText = 'width: 100%; height: 100%; object-fit: cover; display: block; pointer-events: none;';
            positionContainer.appendChild(overlayImg);
        }
        // Update z-index
        positionContainer.style.zIndex = zIndexValue;
        console.log('Position container already exists for index:', imageIndex);
    }
    
    // Store current image data in BOTH currentTemplateImage AND uploadedImages
    // This ensures images are available for generation
    if (!currentTemplateImage) {
        currentTemplateImage = {};
    }
    currentTemplateImage[imageIndex] = {
        file: processedFile,
        preview: previewUrl,
        imageUrl: previewUrl,
        imageName: imageName,
        fromGallery: true
    };
    
    // CRITICAL: Also store in uploadedImages for generation
    // This ensures the image file is available when generating
    if (!uploadedImages) {
        uploadedImages = {};
    }
    uploadedImages[imageIndex] = {
        file: processedFile,
        preview: previewUrl,
        imageUrl: previewUrl,
        imageName: imageName,
        fromGallery: true,
        index: imageIndex
    };
    
    console.log('✅ Image stored in uploadedImages at index', imageIndex, ':', imageName);
            
    // Load image to get dimensions
    const userImg = new Image();
    userImg.src = previewUrl;
    
    userImg.onload = function() {
        // Wait for template dimensions to be set
        if (actualTemplateWidth === 0 || actualTemplateHeight === 0) {
            // Retry after a short delay - IMPORTANT: pass imageIndex to maintain correct position mapping
            setTimeout(function() {
                setImageOnTemplateHelper(previewUrl, imageName, processedFile, imageIndex);
            }, 100);
            return;
        }
        
        // Get template container (parent of template image)
        const templateContainer = templateImg.parentElement;
        const containerRect = templateContainer.getBoundingClientRect();
        const containerWidth = containerRect.width;
        const containerHeight = containerRect.height;
        
        // Get actual displayed image dimensions and position (with object-fit: contain)
        const templateRect = templateImg.getBoundingClientRect();
        const displayedImageWidth = templateRect.width;
        const displayedImageHeight = templateRect.height;
        
        // Get template image's actual position relative to its container
        // Since container uses flexbox with center alignment, image might be centered
        // Calculate offset from container's top-left to image's top-left
        const imageOffsetX = templateRect.left - containerRect.left;
        const imageOffsetY = templateRect.top - containerRect.top;
        
        // Template uses object-fit: contain, so it fits entirely within container
        // Calculate scale factor (contain uses the smaller scale to fit)
        const scaleX = displayedImageWidth / actualTemplateWidth;
        const scaleY = displayedImageHeight / actualTemplateHeight;
        const scale = Math.min(scaleX, scaleY); // Use smaller scale for contain (should be same for both)
        
        // Get position for current image (sequence wise) - retrieve again to ensure correct position for this imageIndex
        // This ensures we get the correct position even if imageIndex changed
        const adminPosition = getAdminPositionForIndex(imageIndex);
        
        console.log('=== Position Calculation ===');
        console.log('imageIndex:', imageIndex);
        console.log('adminPosition:', adminPosition);
        console.log('adminImagePositions:', adminImagePositions);
        console.log('actualTemplateWidth:', actualTemplateWidth);
        console.log('actualTemplateHeight:', actualTemplateHeight);
        console.log('scale:', scale);
        console.log('imageOffsetX:', imageOffsetX);
        console.log('imageOffsetY:', imageOffsetY);
        console.log('displayedImageWidth:', displayedImageWidth);
        console.log('displayedImageHeight:', displayedImageHeight);
        console.log('containerWidth:', containerWidth);
        console.log('containerHeight:', containerHeight);
        
        // Warn if position is outside template bounds
        if (adminPosition) {
            if (adminPosition.x < 0 || adminPosition.y < 0 || 
                adminPosition.x + adminPosition.width > actualTemplateWidth ||
                adminPosition.y + adminPosition.height > actualTemplateHeight) {
                console.warn('⚠️ WARNING: Position ' + imageIndex + ' is outside template bounds!', {
                    position: adminPosition,
                    templateSize: {width: actualTemplateWidth, height: actualTemplateHeight}
                });
            }
        }
        console.log('===========================');
        
        // Calculate position and size
        let overlayX, overlayY, overlayWidth, overlayHeight;
        let actualX, actualY, actualWidth, actualHeight; // Store actual template dimensions for generation
        
        // Check if admin has set position for this template
        if (adminPosition && adminPosition.x !== null && adminPosition.y !== null && 
            adminPosition.width !== null && adminPosition.height !== null) {
            // Admin positions are in ACTUAL template dimensions (not displayed)
            // Store actual dimensions first (for generation)
            actualX = adminPosition.x;
            actualY = adminPosition.y;
            actualWidth = adminPosition.width;
            actualHeight = adminPosition.height;
            
            // Scale admin position to displayed size for preview
            const scaledX = adminPosition.x * scale;
            const scaledY = adminPosition.y * scale;
            const scaledWidth = adminPosition.width * scale;
            const scaledHeight = adminPosition.height * scale;
            
            // GUIDELINE: Use exact admin position coordinates (pixel-based positioning)
            // Adjust for image offset (with contain, image is centered in container)
            overlayX = imageOffsetX + scaledX;
            overlayY = imageOffsetY + scaledY;
            overlayWidth = scaledWidth;
            overlayHeight = scaledHeight;
            
            // GUIDELINE: Use admin-defined width and height exactly
            // object-fit: cover will handle image fitting inside container
            // No aspect ratio adjustment needed - container size is fixed by admin
            
            console.log('Scaled Position:', {
                actualX: actualX,
                actualY: actualY,
                actualWidth: actualWidth,
                actualHeight: actualHeight,
                scaledX: scaledX,
                scaledY: scaledY,
                overlayX: overlayX,
                overlayY: overlayY,
                overlayWidth: overlayWidth,
                overlayHeight: overlayHeight
            });
            
            // DON'T increment currentImageIndex here - it should be incremented by caller
            // currentImageIndex will be set by the next image upload
            } else {
            // Use default center position
            const initialSize = Math.min(displayedImageWidth, displayedImageHeight) * 0.4;
            const aspectRatio = userImg.width / userImg.height;
            overlayWidth = initialSize;
            overlayHeight = initialSize / aspectRatio;
            
            if (overlayHeight > initialSize) {
                overlayHeight = initialSize;
                overlayWidth = initialSize * aspectRatio;
            }
            
            overlayX = imageOffsetX + (displayedImageWidth - overlayWidth) / 2;
            overlayY = imageOffsetY + (displayedImageHeight - overlayHeight) / 2;
            
            // Calculate actual template dimensions for default position
            actualX = (overlayX - imageOffsetX) / scale;
            actualY = (overlayY - imageOffsetY) / scale;
            actualWidth = overlayWidth / scale;
            actualHeight = overlayHeight / scale;
        }
        
        // Store position for generation (store per image index)
        // Store BOTH displayed and actual dimensions
        if (!templateOverlayPosition) {
            templateOverlayPosition = {};
        }
        templateOverlayPosition[imageIndex] = {
            // Displayed dimensions (for preview)
            x: overlayX,
            y: overlayY,
            width: overlayWidth,
            height: overlayHeight,
            // Actual template dimensions (for generation)
            actualX: actualX,
            actualY: actualY,
            actualWidth: actualWidth,
            actualHeight: actualHeight
        };
        
        // GUIDELINE: Set position container dimensions (not image directly)
        // Container uses absolute positioning based on admin coordinates (pixel-based)
        // Get positionContainer again inside onload to ensure we have the correct reference
        const currentPositionContainer = document.getElementById(`positionContainer-${imageIndex}`);
        if (currentPositionContainer && currentPositionContainer.id.startsWith('positionContainer-')) {
            currentPositionContainer.style.left = overlayX + 'px';
            currentPositionContainer.style.top = overlayY + 'px';
            currentPositionContainer.style.width = overlayWidth + 'px';
            currentPositionContainer.style.height = overlayHeight + 'px';
            console.log('Position container dimensions set:', {
                left: overlayX,
                top: overlayY,
                width: overlayWidth,
                height: overlayHeight
            });
        } else {
            // Fallback: if container structure is wrong, set on image directly
            console.warn('⚠️ Position container not found for index ' + imageIndex + ', using image directly');
            overlayImg.style.position = 'absolute';
            overlayImg.style.left = overlayX + 'px';
            overlayImg.style.top = overlayY + 'px';
            overlayImg.style.width = overlayWidth + 'px';
            overlayImg.style.height = overlayHeight + 'px';
        }
        
        // GUIDELINE: Set user image inside container (width: 100%, height: 100%, object-fit: cover)
        overlayImg.src = previewUrl;
        // Image already has width: 100%, height: 100%, object-fit: cover from above
        
        // Only display container if image source is valid
        overlayImg.onload = function() {
            overlayImg.style.display = 'block';
            if (currentPositionContainer && currentPositionContainer.id.startsWith('positionContainer-')) {
                currentPositionContainer.style.display = 'block';
            }
        };
        overlayImg.onerror = function() {
            overlayImg.style.display = 'none';
            if (currentPositionContainer && currentPositionContainer.id.startsWith('positionContainer-')) {
                currentPositionContainer.style.display = 'none';
            }
            console.error('Failed to load overlay image for index:', imageIndex);
        };
        
        // If image is already loaded (cached), display immediately
        if (overlayImg.complete && overlayImg.naturalWidth > 0) {
            overlayImg.style.display = 'block';
            if (currentPositionContainer && currentPositionContainer.id.startsWith('positionContainer-')) {
                currentPositionContainer.style.display = 'block';
            }
        } else {
            // Wait for image to load - hide until loaded
            overlayImg.style.display = 'none';
            if (currentPositionContainer && currentPositionContainer.id.startsWith('positionContainer-')) {
                currentPositionContainer.style.display = 'none';
            }
        }
        
        console.log('=== Overlay Set (GUIDELINE COMPLIANT) ===');
        const logPositionContainer = document.getElementById(`positionContainer-${imageIndex}`);
        console.log('positionContainer.id:', logPositionContainer ? logPositionContainer.id : 'N/A');
        console.log('overlayImg.id:', overlayImg.id);
        console.log('Container position (displayed):', {
            left: overlayX + 'px',
            top: overlayY + 'px',
            width: overlayWidth + 'px',
            height: overlayHeight + 'px'
        });
        console.log('Actual template coordinates (for generation):', {
            x: actualX,
            y: actualY,
            width: actualWidth,
            height: actualHeight
        });
        console.log('Image CSS:', {
            width: '100%',
            height: '100%',
            objectFit: 'cover'
        });
        console.log('==================');
        
        // Show overlay container
        overlayDiv.style.display = 'block';
        
        // Make draggable (disabled - position is fixed)
        if (currentPositionContainer) {
            makeOverlayDraggable(currentPositionContainer);
        } else {
            makeOverlayDraggable(overlayImg);
        }
        
        // Increment currentImageIndex AFTER image is set (for next image)
        currentImageIndex = imageIndex + 1;
        console.log('Updated currentImageIndex to:', currentImageIndex);
    };
}

// Make overlay image draggable and resizable
function makeOverlayDraggable(imgElement) {
    // Position is FIXED - user cannot move/drag the image
    // Admin-defined position must be maintained
    imgElement.style.cursor = 'default';
    imgElement.style.pointerEvents = 'auto';
    
    // Disable all drag functionality
    return;
    
    // OLD CODE - DISABLED (position is fixed)
    /*
    let isDragging = false;
    let startX, startY, startLeft, startTop;
    
    imgElement.style.cursor = 'move';
    
    imgElement.addEventListener('mousedown', function(e) {
        isDragging = true;
        startX = e.clientX;
        startY = e.clientY;
        startLeft = parseInt(imgElement.style.left) || 0;
        startTop = parseInt(imgElement.style.top) || 0;
        e.preventDefault();
    });
    
    document.addEventListener('mousemove', function(e) {
        if (!isDragging) return;
        
        const deltaX = e.clientX - startX;
        const deltaY = e.clientY - startY;
        
        const templateImg = document.getElementById('mainTemplateImage');
        const templateRect = templateImg.getBoundingClientRect();
        
        let newLeft = startLeft + deltaX;
        let newTop = startTop + deltaY;
        
        // Constrain within template bounds
        newLeft = Math.max(0, Math.min(newLeft, templateRect.width - parseInt(imgElement.style.width)));
        newTop = Math.max(0, Math.min(newTop, templateRect.height - parseInt(imgElement.style.height)));
        
        imgElement.style.left = newLeft + 'px';
        imgElement.style.top = newTop + 'px';
        
        // Update stored position
        templateOverlayPosition.x = newLeft;
        templateOverlayPosition.y = newTop;
    });
    
    document.addEventListener('mouseup', function() {
        isDragging = false;
    });
    
    // Touch support for mobile
    imgElement.addEventListener('touchstart', function(e) {
        isDragging = true;
        const touch = e.touches[0];
        startX = touch.clientX;
        startY = touch.clientY;
        startLeft = parseInt(imgElement.style.left) || 0;
        startTop = parseInt(imgElement.style.top) || 0;
        e.preventDefault();
    });
    
    document.addEventListener('touchmove', function(e) {
        if (!isDragging) return;
        const touch = e.touches[0];
        const deltaX = touch.clientX - startX;
        const deltaY = touch.clientY - startY;
        
        const templateImg = document.getElementById('mainTemplateImage');
        const templateRect = templateImg.getBoundingClientRect();
        
        let newLeft = startLeft + deltaX;
        let newTop = startTop + deltaY;
        
        newLeft = Math.max(0, Math.min(newLeft, templateRect.width - parseInt(imgElement.style.width)));
        newTop = Math.max(0, Math.min(newTop, templateRect.height - parseInt(imgElement.style.height)));
        
        imgElement.style.left = newLeft + 'px';
        imgElement.style.top = newTop + 'px';
        
        templateOverlayPosition.x = newLeft;
        templateOverlayPosition.y = newTop;
        e.preventDefault();
    });
    
    document.addEventListener('touchend', function() {
        isDragging = false;
        });
    */
}

// Save Template from Tab Button
function saveTemplateFromTab(tempId, button) {
    // Don't switch tab, just save
    toggleSaveTemplate(tempId, button);
}

function uploadImage(index) {
    const input = document.querySelector(`.image-upload-input[data-index="${index}"]`);
    if (input) {
        input.click();
    }
}

function handleImageUpload(event, index) {
    const file = event.target.files[0];
    if (file && file.type.startsWith('image/')) {
        // Get next available sequential index (no overwrite)
        const imageIndex = getNextAvailableImageIndex();
        
        // Show loading indicator
        const loader = document.getElementById('bgRemovalLoader');
        const placeholder = document.getElementById(`placeholder-${index}`);
        if (loader) loader.style.display = 'flex';
        if (placeholder) placeholder.style.display = 'none';
        
        // First, remove background
        removeBackground(file, function(processedFile, processedPreviewUrl) {
            // Hide loading indicator
            if (loader) loader.style.display = 'none';
            
            // Show preview in upload section
            const preview = document.getElementById(`preview-${index}`);
            const placeholder = document.getElementById(`placeholder-${index}`);
            const removeBtn = document.querySelector(`.remove-image-btn[onclick*="removeImage(${index})"]`);
            const label = document.getElementById(`label-${index}`);
            
            if (preview) {
                preview.src = processedPreviewUrl;
                preview.style.display = 'block';
            }
            if (placeholder) {
                placeholder.style.display = 'none';
            }
            
            // Show remove button
            if (removeBtn) {
                removeBtn.style.display = 'block';
            }
            
            // Update label
            if (label) {
                label.textContent = '✓ Uploaded';
                label.classList.add('uploaded');
            }
            
            // Store image in uploadedImages array with the calculated index
            // This allows multiple images to be stored separately
            uploadedImages[imageIndex] = {
                file: processedFile,
                preview: processedPreviewUrl,
                imageUrl: processedPreviewUrl,
                imageName: file.name,
                fromGallery: false,
                index: imageIndex
            };
            
            // Set currentImageIndex to the calculated imageIndex BEFORE calling setImageOnTemplate
            // This ensures the correct position is used
            const previousIndex = currentImageIndex;
            currentImageIndex = imageIndex;
            
            console.log('Upload image - stored at index', imageIndex, ':', file.name);
            
            // Use setImageOnTemplate to display image on template (same as gallery images)
            // Pass imageIndex explicitly to ensure correct mapping
            setImageOnTemplate(processedPreviewUrl, file.name, processedFile, imageIndex);
            
            // Reset the file input so same file can be selected again if needed
            event.target.value = '';
        });
    }
}

// Remove background from image
function removeBackground(file, callback) {
    const formData = new FormData();
    formData.append('image', file);
    
    $.ajax({
        url: '<?= base_url('index.php/action/remove_background') ?>',
        type: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        success: function(response) {
            try {
                const result = typeof response === 'string' ? JSON.parse(response) : response;
                if (result.success && result.image_url) {
                    // Convert data URL to File object
                    fetch(result.image_url)
                        .then(res => res.blob())
                        .then(blob => {
                            const processedFile = new File([blob], file.name.replace(/\.[^/.]+$/, '.png'), { type: 'image/png' });
                            callback(processedFile, result.image_url);
                        })
                        .catch(error => {
                            console.error('Error converting processed image:', error);
                            // Fallback: use original image
                            const reader = new FileReader();
                            reader.onload = function(e) {
                                callback(file, e.target.result);
                            };
                            reader.readAsDataURL(file);
                        });
                } else {
                    // Fallback: use original image if background removal fails
                    console.warn('Background removal failed, using original image');
                    const reader = new FileReader();
                    reader.onload = function(e) {
                        callback(file, e.target.result);
        };
        reader.readAsDataURL(file);
    }
            } catch(e) {
                console.error('Error parsing background removal response:', e);
                // Fallback: use original image
                const reader = new FileReader();
                reader.onload = function(e) {
                    callback(file, e.target.result);
                };
                reader.readAsDataURL(file);
            }
        },
        error: function(xhr, status, error) {
            console.error('Background removal error:', error);
            // Fallback: use original image
            const reader = new FileReader();
            reader.onload = function(e) {
                callback(file, e.target.result);
            };
            reader.readAsDataURL(file);
        }
    });
}

// Unified Editor - Photo editing only
let currentEditorMode = 'photo'; // Only 'photo' mode now

function switchEditorMode(mode) {
    currentEditorMode = mode;
    
    // Update button states
    const photoBtn = document.getElementById('photoModeBtn');
    if (photoBtn) photoBtn.classList.toggle('active', mode === 'photo');
    
    // Show/hide controls
    const photoControls = document.getElementById('photoControlsPanel');
    const imageTabs = document.getElementById('imageSelectorTabs');
    
    if (photoControls) photoControls.style.display = mode === 'photo' ? 'flex' : 'none';
    if (imageTabs) imageTabs.style.display = mode === 'photo' ? 'flex' : 'none';
    
    // Show/hide overlays - keep all visible but adjust opacity
    const photoOverlays = document.querySelectorAll('.user-photo-overlay');
    photoOverlays.forEach(overlay => {
        if (mode === 'photo') {
            overlay.style.pointerEvents = 'all';
            // Active overlay fully visible, others semi-transparent
            overlay.style.opacity = overlay.classList.contains('active') ? '1' : '0.5';
            overlay.style.display = 'block'; // Ensure all are visible
        } else {
            overlay.style.pointerEvents = 'none';
            overlay.style.opacity = '0.3';
            overlay.style.display = 'block'; // Still visible but dimmed
        }
    });
    
    // Update reset button text
    const resetBtn = document.getElementById('resetCurrentBtn');
    if (resetBtn) {
            resetBtn.innerHTML = '<i class="iconsax" data-icon="refresh"></i> Reset Current Photo';
    }
}

function resetCurrentItem() {
        resetCurrentPhoto();
}

function resetAllItems() {
    resetAllPhotos();
}

// Initialize Unified Editor - Combines photo and text editing
function initializeUnifiedEditor() {
    const editorSection = document.getElementById('unifiedEditorSection');
    const canvas = document.getElementById('unifiedEditorCanvas');
    const overlaysContainer = document.getElementById('photoOverlaysContainer');
    
    if (!canvas || !overlaysContainer) {
        console.error('Unified editor elements not found');
        return;
    }
    
    // Show unified editor section
    if (editorSection) {
        editorSection.style.display = 'block';
    }
    
    // Check if editor is already initialized
    if (templateImageLoaded && templateCanvas) {
        // Editor already initialized, just update overlays for new images
        updatePhotoOverlays();
        
    } else {
        // First time initialization
        initializeAdvancedImageEditor();
    }
}

// Update photo overlays without reinitializing everything
function updatePhotoOverlays() {
    const overlaysContainer = document.getElementById('photoOverlaysContainer');
    if (!overlaysContainer) return;
    
    // Create overlay for any new uploaded images that don't have overlays yet
    Object.keys(uploadedImages).forEach(index => {
        if (uploadedImages[index] && uploadedImages[index].preview) {
            const existingOverlay = document.getElementById(`photoOverlay-${index}`);
            if (!existingOverlay) {
                // Create new overlay for this image
                createPhotoOverlay(parseInt(index), uploadedImages[index].preview);
            } else {
                // Update existing overlay if image source changed
                const img = existingOverlay.querySelector('img');
                if (img && img.src !== uploadedImages[index].preview) {
                    img.src = uploadedImages[index].preview;
                }
                // Make sure it's in allPhotoOverlays
                if (!allPhotoOverlays) allPhotoOverlays = {};
                allPhotoOverlays[index] = existingOverlay;
                // Keep existing overlays visible
                existingOverlay.style.display = 'block';
            }
        }
    });
    
    // Update tabs
    createImageSelectorTabs();
    
    // Show all images, but keep current one active
    if (Object.keys(allPhotoOverlays || {}).length > 0) {
        if (currentEditingIndex === undefined || !allPhotoOverlays[currentEditingIndex]) {
            // Find first available image index
            const firstIndex = Object.keys(allPhotoOverlays).map(i => parseInt(i)).sort((a, b) => a - b)[0];
            switchToImage(firstIndex);
        } else {
            // Keep current image active, but show all
            switchToImage(currentEditingIndex);
        }
    }
}

// Advanced Multi-Image Editor - Supports multiple images with advanced controls
function initializeAdvancedImageEditor() {
    const canvas = document.getElementById('unifiedEditorCanvas') || document.getElementById('editorCanvas');
    const overlaysContainer = document.getElementById('photoOverlaysContainer');
    
    if (!canvas || !overlaysContainer) {
        console.error('Editor elements not found');
        return;
    }
    
    // Count uploaded images
    const uploadedCount = Object.keys(uploadedImages).filter(i => uploadedImages[i] && uploadedImages[i].preview).length;
    if (uploadedCount === 0) {
        return; // No images to edit
    }
    
    // Load template image
    const templateImg = new Image();
    templateImg.crossOrigin = 'anonymous';
    templateImg.src = '<?= !empty($template['temp_image']) ? base_url('assets/ai/uploads/templates/' . $template['temp_image']) : base_url('assets/theme/v1/social-app/assets/images/profile/p3.png') ?>';
    
    templateImg.onerror = function() {
        console.error('Failed to load template image');
        alert('Failed to load template image. Please refresh the page.');
    };
    
    templateImg.onload = function() {
        templateCanvas = canvas;
        templateCtx = canvas.getContext('2d');
        
        // Store actual template dimensions
        actualTemplateWidth = templateImg.width;
        actualTemplateHeight = templateImg.height;
        
        // Set canvas internal size to match template
        canvas.width = actualTemplateWidth;
        canvas.height = actualTemplateHeight;
        
        // Calculate display scale
        const canvasContainer = canvas.parentElement;
        const containerStyle = window.getComputedStyle(canvasContainer);
        const paddingLeft = parseFloat(containerStyle.paddingLeft) || 0;
        const paddingRight = parseFloat(containerStyle.paddingRight) || 0;
        const containerWidth = (canvasContainer.offsetWidth - paddingLeft - paddingRight) || Math.min(window.innerWidth - 40, 600);
        const containerHeight = canvasContainer.offsetHeight || 400;
        
        const scaleX = containerWidth / actualTemplateWidth;
        const scaleY = containerHeight / actualTemplateHeight;
        canvasDisplayScale = Math.min(scaleX, scaleY, 1);
        
        // Set display size
        canvas.style.width = (actualTemplateWidth * canvasDisplayScale) + 'px';
        canvas.style.height = (actualTemplateHeight * canvasDisplayScale) + 'px';
        
        // Draw template on canvas
        templateCtx.clearRect(0, 0, actualTemplateWidth, actualTemplateHeight);
        templateCtx.drawImage(templateImg, 0, 0, actualTemplateWidth, actualTemplateHeight);
        templateImageLoaded = true;
        
        // Initialize photoAdjustments if not exists
        if (!photoAdjustments || typeof photoAdjustments !== 'object') {
            photoAdjustments = {};
        }
        
        // Initialize photoAdjustments if not exists
        if (!photoAdjustments || typeof photoAdjustments !== 'object') {
            photoAdjustments = {};
        }
        
        // Always ensure all uploaded images have overlays - don't clear existing ones
        // Create overlay for each uploaded image that doesn't have one yet
        Object.keys(uploadedImages).forEach(index => {
            if (uploadedImages[index] && uploadedImages[index].preview) {
                const existingOverlay = document.getElementById(`photoOverlay-${index}`);
                if (!existingOverlay) {
                    // Create new overlay for this image
                    createPhotoOverlay(parseInt(index), uploadedImages[index].preview);
                } else {
                    // Update existing overlay if image source changed
                    const img = existingOverlay.querySelector('img');
                    if (img && img.src !== uploadedImages[index].preview) {
                        img.src = uploadedImages[index].preview;
                    }
                    // Make sure it's in allPhotoOverlays
                    if (!allPhotoOverlays) allPhotoOverlays = {};
                    allPhotoOverlays[index] = existingOverlay;
                    // Keep existing overlays visible
                    existingOverlay.style.display = 'block';
                }
            }
        });
        
        // Create tabs for image selection
        createImageSelectorTabs();
        
        // Show all images, activate first one
        if (Object.keys(allPhotoOverlays).length > 0) {
            const firstIndex = Object.keys(allPhotoOverlays).map(i => parseInt(i)).sort((a, b) => a - b)[0];
            switchToImage(firstIndex);
        }
        
        // Editor section is already shown by unified editor
        // No need to show it again here
    };
}

// Create image selector tabs
function createImageSelectorTabs() {
    const tabsContainer = document.getElementById('imageSelectorTabs');
    if (!tabsContainer) return;
    
    tabsContainer.innerHTML = '';
    
    for (let i = 0; i < 4; i++) {
        if (uploadedImages[i] && uploadedImages[i].preview) {
            const tab = document.createElement('button');
            tab.type = 'button';
            tab.className = `image-selector-tab ${i === currentEditingIndex ? 'active' : ''} has-image`;
            tab.textContent = `Photo ${i + 1}`;
            tab.onclick = () => switchToImage(i);
            tabsContainer.appendChild(tab);
        }
    }
}

// Create photo overlay for a specific image index
function createPhotoOverlay(index, imageSrc) {
    const overlaysContainer = document.getElementById('photoOverlaysContainer');
    if (!overlaysContainer) return;
    
    // Check if overlay already exists for this index
    const existingOverlay = document.getElementById(`photoOverlay-${index}`);
    if (existingOverlay) {
        // Update existing overlay instead of creating new one
        const img = existingOverlay.querySelector('img');
        if (img) {
            img.src = imageSrc;
        }
        // Make sure it's in allPhotoOverlays
        if (!allPhotoOverlays) allPhotoOverlays = {};
        allPhotoOverlays[index] = existingOverlay;
        return existingOverlay;
    }
    
    const overlay = document.createElement('div');
    overlay.className = 'user-photo-overlay';
    overlay.id = `photoOverlay-${index}`;
    overlay.style.display = 'none';
    
    const img = document.createElement('img');
    img.src = imageSrc;
    img.alt = `Photo ${index + 1}`;
    overlay.appendChild(img);
    
    // Add resize handles
    const handlesDiv = document.createElement('div');
    handlesDiv.className = 'resize-handles';
    handlesDiv.innerHTML = `
        <div class="handle handle-nw"></div>
        <div class="handle handle-ne"></div>
        <div class="handle handle-sw"></div>
        <div class="handle handle-se"></div>
    `;
    overlay.appendChild(handlesDiv);
    
    overlaysContainer.appendChild(overlay);
    allPhotoOverlays[index] = overlay;
    
    // Initialize adjustments for this image
    if (!photoAdjustments[index]) {
        // Load image to get dimensions
        const userImg = new Image();
        userImg.src = imageSrc;
        userImg.onload = function() {
            let x, y, photoWidth, photoHeight;
            
            // Get admin position for this specific image index
            const adminImagePosition = getAdminPositionForIndex(index);
            
            // Check if admin has set position for this template
            if (adminImagePosition && adminImagePosition.x !== null && adminImagePosition.y !== null && 
                adminImagePosition.width !== null && adminImagePosition.height !== null) {
                // Use admin-set position
                x = adminImagePosition.x;
                y = adminImagePosition.y;
                photoWidth = adminImagePosition.width;
                photoHeight = adminImagePosition.height;
                
                // Maintain aspect ratio of user's image
                const aspectRatio = userImg.width / userImg.height;
                if (photoWidth / photoHeight > aspectRatio) {
                    // Height is limiting factor
                    photoWidth = photoHeight * aspectRatio;
                } else {
                    // Width is limiting factor
                    photoHeight = photoWidth / aspectRatio;
                }
                
                // Center the image within admin's defined area
                const adminAreaWidth = adminImagePosition.width;
                const adminAreaHeight = adminImagePosition.height;
                x = adminImagePosition.x + (adminAreaWidth - photoWidth) / 2;
                y = adminImagePosition.y + (adminAreaHeight - photoHeight) / 2;
            } else {
                // Use default center position (original behavior)
                const templateSize = Math.min(actualTemplateWidth, actualTemplateHeight);
                const initialSize = templateSize * 0.4;
                const aspectRatio = userImg.width / userImg.height;
                photoWidth = initialSize;
                photoHeight = initialSize / aspectRatio;
                
                if (photoHeight > initialSize) {
                    photoHeight = initialSize;
                    photoWidth = initialSize * aspectRatio;
                }
                
                x = (actualTemplateWidth - photoWidth) / 2;
                y = (actualTemplateHeight - photoHeight) / 2;
            }
            
            photoAdjustments[index] = {
                x: x,
                y: y,
                width: photoWidth,
                height: photoHeight,
                rotation: 0,
                opacity: 100,
                scale: 100
            };
            
            updateOverlayDisplay(index);
            setupDragAndResize(overlay, index);
        };
    }
}

// Switch to editing a specific image
function switchToImage(index) {
    currentEditingIndex = index;
    
    // Update tabs
    document.querySelectorAll('.image-selector-tab').forEach((tab, i) => {
        const tabIndex = parseInt(tab.textContent.replace('Photo ', '')) - 1;
        if (tabIndex === index) {
            tab.classList.add('active');
        } else {
            tab.classList.remove('active');
        }
    });
    
    // Show ALL overlays, but highlight only the active one
    Object.keys(allPhotoOverlays).forEach(i => {
        const overlay = allPhotoOverlays[i];
        const overlayIndex = parseInt(i);
        if (overlayIndex === index) {
            overlay.style.display = 'block';
            overlay.classList.add('active');
            overlay.style.opacity = '1';
            overlay.style.zIndex = '10';
        } else {
            overlay.style.display = 'block'; // Keep visible
            overlay.classList.remove('active');
            overlay.style.opacity = '0.5'; // Dim inactive ones
            overlay.style.zIndex = '5';
        }
    });
    
    // Update controls for current image
    updateControlsForImage(index);
}

// Update controls panel for current image
function updateControlsForImage(index) {
    const adj = photoAdjustments[index] || { scale: 100, rotation: 0, opacity: 100 };
    
    const sizeSlider = document.getElementById('sizeSlider');
    const rotationSlider = document.getElementById('rotationSlider');
    const opacitySlider = document.getElementById('opacitySlider');
    
    if (sizeSlider) {
        sizeSlider.value = adj.scale || 100;
        const sizeValue = document.getElementById('sizeValue');
        if (sizeValue) sizeValue.textContent = (adj.scale || 100) + '%';
    }
    
    if (rotationSlider) {
        rotationSlider.value = adj.rotation || 0;
        const rotationValue = document.getElementById('rotationValue');
        if (rotationValue) rotationValue.textContent = (adj.rotation || 0) + '°';
    }
    
    if (opacitySlider) {
        opacitySlider.value = adj.opacity || 100;
        const opacityValue = document.getElementById('opacityValue');
        if (opacityValue) opacityValue.textContent = (adj.opacity || 100) + '%';
    }
}

// Update overlay display based on adjustments
function updateOverlayDisplay(index) {
    const overlay = allPhotoOverlays[index];
    const adj = photoAdjustments[index];
    if (!overlay || !adj) return;
    
    const displayX = adj.x * canvasDisplayScale;
    const displayY = adj.y * canvasDisplayScale;
    const displayWidth = (adj.width * (adj.scale || 100) / 100) * canvasDisplayScale;
    const displayHeight = (adj.height * (adj.scale || 100) / 100) * canvasDisplayScale;
    
    overlay.style.left = displayX + 'px';
    overlay.style.top = displayY + 'px';
    overlay.style.width = displayWidth + 'px';
    overlay.style.height = displayHeight + 'px';
    overlay.style.transform = `rotate(${adj.rotation || 0}deg)`;
    overlay.style.opacity = (adj.opacity || 100) / 100;
}

// Update current photo size
function updateCurrentPhotoSize(value) {
    if (!photoAdjustments[currentEditingIndex]) return;
    photoAdjustments[currentEditingIndex].scale = parseInt(value);
    const sizeValue = document.getElementById('sizeValue');
    if (sizeValue) sizeValue.textContent = value + '%';
    updateOverlayDisplay(currentEditingIndex);
}

// Update current photo rotation
function updateCurrentPhotoRotation(value) {
    if (!photoAdjustments[currentEditingIndex]) return;
    photoAdjustments[currentEditingIndex].rotation = parseInt(value);
    const rotationValue = document.getElementById('rotationValue');
    if (rotationValue) rotationValue.textContent = value + '°';
    updateOverlayDisplay(currentEditingIndex);
}

// Update current photo opacity
function updateCurrentPhotoOpacity(value) {
    if (!photoAdjustments[currentEditingIndex]) return;
    photoAdjustments[currentEditingIndex].opacity = parseInt(value);
    const opacityValue = document.getElementById('opacityValue');
    if (opacityValue) opacityValue.textContent = value + '%';
    updateOverlayDisplay(currentEditingIndex);
}

// Reset current photo
function resetCurrentPhoto() {
    if (!photoAdjustments[currentEditingIndex] || !uploadedImages[currentEditingIndex]) return;
    const index = currentEditingIndex;
    const templateSize = Math.min(actualTemplateWidth, actualTemplateHeight);
    const initialSize = templateSize * 0.4;
    
    const userImg = new Image();
    userImg.src = uploadedImages[index].preview;
    userImg.onload = function() {
        const aspectRatio = userImg.width / userImg.height;
        let photoWidth = initialSize;
        let photoHeight = initialSize / aspectRatio;
        
        if (photoHeight > initialSize) {
            photoHeight = initialSize;
            photoWidth = initialSize * aspectRatio;
        }
        
        photoAdjustments[index] = {
            x: (actualTemplateWidth - photoWidth) / 2,
            y: (actualTemplateHeight - photoHeight) / 2,
            width: photoWidth,
            height: photoHeight,
            rotation: 0,
            opacity: 100,
            scale: 100
        };
        
        updateOverlayDisplay(index);
        updateControlsForImage(index);
    };
}

// Reset all photos
function resetAllPhotos() {
    Object.keys(allPhotoOverlays).forEach(index => {
        resetCurrentPhoto();
        switchToImage(parseInt(index));
    });
    if (Object.keys(allPhotoOverlays).length > 0) {
        switchToImage(0);
    }
}

// Toggle crop mode
function toggleCropMode() {
    const btn = document.getElementById('cropModeBtn');
    if (btn) {
        const isActive = btn.classList.contains('active');
        if (isActive) {
            btn.classList.remove('active');
            btn.innerHTML = '<i class="iconsax" data-icon="crop"></i> Enable Crop';
        } else {
            btn.classList.add('active');
            btn.innerHTML = '<i class="iconsax" data-icon="tick-circle"></i> Crop Active';
        }
    }
}

// Initialize image editor with template and user photo
function initializeImageEditor(userPhotoSrc) {
    const editorSection = document.getElementById('imageEditorSection');
    const canvas = document.getElementById('editorCanvas');
    const overlay = document.getElementById('userPhotoOverlay');
    const userPhotoImg = document.getElementById('userPhotoInEditor');
    
    if (!canvas || !overlay || !userPhotoImg) {
        console.error('Editor elements not found');
        return;
    }
    
    // Load template image
    const templateImg = new Image();
    templateImg.crossOrigin = 'anonymous';
    templateImg.src = '<?= !empty($template['temp_image']) ? base_url('assets/ai/uploads/templates/' . $template['temp_image']) : base_url('assets/theme/v1/social-app/assets/images/profile/p3.png') ?>';
    
    templateImg.onerror = function() {
        console.error('Failed to load template image');
        alert('Failed to load template image. Please refresh the page.');
    };
    
    templateImg.onload = function() {
        templateCanvas = canvas;
        templateCtx = canvas.getContext('2d');
        
        // Store actual template dimensions
        actualTemplateWidth = templateImg.width;
        actualTemplateHeight = templateImg.height;
        
        console.log('Template dimensions: ' + actualTemplateWidth + 'x' + actualTemplateHeight);
        
        // Set canvas internal size to match template (actual pixels)
        canvas.width = actualTemplateWidth;
        canvas.height = actualTemplateHeight;
        
        // Calculate display scale (canvas might be displayed smaller due to CSS)
        const canvasContainer = canvas.parentElement;
        // Get actual container width (considering padding)
        const containerStyle = window.getComputedStyle(canvasContainer);
        const paddingLeft = parseFloat(containerStyle.paddingLeft) || 0;
        const paddingRight = parseFloat(containerStyle.paddingRight) || 0;
        const containerWidth = (canvasContainer.offsetWidth - paddingLeft - paddingRight) || Math.min(window.innerWidth - 40, 600);
        const containerHeight = canvasContainer.offsetHeight || 400;
        
        // Calculate scale to fit container while maintaining aspect ratio
        const scaleX = containerWidth / actualTemplateWidth;
        const scaleY = containerHeight / actualTemplateHeight;
        canvasDisplayScale = Math.min(scaleX, scaleY, 1); // Don't scale up, only down
        
        console.log('Display scale: ' + canvasDisplayScale);
        
        // Set display size (CSS will handle the visual scaling)
        canvas.style.width = (actualTemplateWidth * canvasDisplayScale) + 'px';
        canvas.style.height = (actualTemplateHeight * canvasDisplayScale) + 'px';
        
        // Clear canvas and draw template
        templateCtx.clearRect(0, 0, actualTemplateWidth, actualTemplateHeight);
        templateCtx.drawImage(templateImg, 0, 0, actualTemplateWidth, actualTemplateHeight);
        templateImageLoaded = true;
        
        console.log('Template image drawn on canvas');
        
        // Load user photo
        const userImg = new Image();
        userImg.crossOrigin = 'anonymous';
        userImg.src = userPhotoSrc;
        
        userImg.onerror = function() {
            console.error('Failed to load user photo');
            alert('Failed to load your photo. Please try uploading again.');
        };
        
        userImg.onload = function() {
            userPhotoImg.src = userPhotoSrc;
            
            console.log('User photo loaded: ' + userImg.width + 'x' + userImg.height);
            
            // Calculate initial size based on ACTUAL template dimensions (not displayed size)
            const templateSize = Math.min(actualTemplateWidth, actualTemplateHeight);
            const initialSize = templateSize * 0.5;
            
            // Maintain aspect ratio
            const aspectRatio = userImg.width / userImg.height;
            let photoWidth = initialSize;
            let photoHeight = initialSize / aspectRatio;
            
            // If height is too large, adjust
            if (photoHeight > initialSize) {
                photoHeight = initialSize;
                photoWidth = initialSize * aspectRatio;
            }
            
            // Center position based on ACTUAL template dimensions
            const x = (actualTemplateWidth - photoWidth) / 2;
            const y = (actualTemplateHeight - photoHeight) / 2;
            
            console.log('Photo position: x=' + x + ', y=' + y + ', w=' + photoWidth + ', h=' + photoHeight);
            console.log('Display scale: ' + canvasDisplayScale);
            
            // Set overlay position and size (scaled for display)
            const displayX = x * canvasDisplayScale;
            const displayY = y * canvasDisplayScale;
            const displayWidth = photoWidth * canvasDisplayScale;
            const displayHeight = photoHeight * canvasDisplayScale;
            
            overlay.style.position = 'absolute';
            overlay.style.left = displayX + 'px';
            overlay.style.top = displayY + 'px';
            overlay.style.width = displayWidth + 'px';
            overlay.style.height = displayHeight + 'px';
            overlay.style.display = 'block';
            overlay.style.zIndex = '10';
            
            console.log('Overlay display: left=' + displayX + ', top=' + displayY + ', width=' + displayWidth + ', height=' + displayHeight);
            
            // Save adjustments in ACTUAL template dimensions (not displayed)
            // For old single-image editor, use index 0
            if (!photoAdjustments[0]) {
                photoAdjustments[0] = {};
            }
            photoAdjustments[0].x = x;
            photoAdjustments[0].y = y;
            photoAdjustments[0].width = photoWidth;
            photoAdjustments[0].height = photoHeight;
            photoAdjustments[0].cropWidth = userImg.width;
            photoAdjustments[0].cropHeight = userImg.height;
            photoAdjustments[0].rotation = 0;
            photoAdjustments[0].opacity = 100;
            photoAdjustments[0].scale = 100;
            
            // Show editor section
            editorSection.style.display = 'block';
            setTimeout(function() {
                editorSection.scrollIntoView({ behavior: 'smooth', block: 'nearest' });
            }, 100);
            
            // Setup drag and resize
            setupDragAndResize(overlay);
        };
    };
}

// Setup drag and resize functionality (updated for multi-image support)
function setupDragAndResize(overlay, imageIndex) {
    if (imageIndex === undefined) {
        imageIndex = currentEditingIndex;
    }
    const handles = overlay.querySelectorAll('.handle');
    let currentHandle = null;
    let initialOverlayX = 0;
    let initialOverlayY = 0;
    let isThisOverlayDragging = false; // Separate flag for this specific overlay
    let dragStartXForThis = 0;
    let dragStartYForThis = 0;
    
    // Helper function to get coordinates (mouse or touch)
    function getEventCoords(e) {
        if (e.touches && e.touches.length > 0) {
            return { x: e.touches[0].clientX, y: e.touches[0].clientY };
        }
        return { x: e.clientX, y: e.clientY };
    }
    
    // Drag functionality - prevent handles from triggering drag
    function startDrag(e) {
        // Don't start drag if clicking on handles
        if (e.target.classList.contains('handle') || e.target.closest('.handle')) {
            return;
        }
        
        // Start drag only if clicking on THIS specific overlay or its image
        if (e.target === overlay || e.target === overlay.querySelector('img') || overlay.contains(e.target)) {
            e.preventDefault();
            e.stopPropagation();
            
            // Only allow dragging if this overlay is active
            if (!overlay.classList.contains('active')) {
                return;
            }
            
            isThisOverlayDragging = true;
            isDragging = true; // Global flag for preventing other interactions
            
            // Store initial overlay position in actual coordinates
            if (!photoAdjustments[imageIndex]) return;
            initialOverlayX = photoAdjustments[imageIndex].x;
            initialOverlayY = photoAdjustments[imageIndex].y;
            
            // Get canvas container position
            const canvasContainer = document.querySelector('.template-preview-editor');
            const containerRect = canvasContainer.getBoundingClientRect();
            
            // Calculate initial position relative to container
            const coords = getEventCoords(e);
            dragStartXForThis = (coords.x - containerRect.left) / canvasDisplayScale;
            dragStartYForThis = (coords.y - containerRect.top) / canvasDisplayScale;
            
            overlay.style.cursor = 'grabbing';
            overlay.style.userSelect = 'none';
        }
    }
    
    overlay.addEventListener('mousedown', startDrag);
    overlay.addEventListener('touchstart', startDrag, { passive: false });
    
    // Resize functionality
    handles.forEach(handle => {
        let resizeStartX = 0;
        let resizeStartY = 0;
        let startWidth = 0;
        let startHeight = 0;
        let startX = 0;
        let startY = 0;
        
        function startResize(e) {
            e.stopPropagation();
            e.preventDefault();
            
            // Only allow resize if this overlay is active
            if (!overlay.classList.contains('active')) {
                return;
            }
            
            isResizing = true;
            currentHandle = handle;
            const coords = getEventCoords(e);
            // Store resize start position
            resizeStartX = coords.x;
            resizeStartY = coords.y;
            // Store actual dimensions (not displayed)
            if (!photoAdjustments[imageIndex]) return;
            startWidth = photoAdjustments[imageIndex].width;
            startHeight = photoAdjustments[imageIndex].height;
            startX = photoAdjustments[imageIndex].x;
            startY = photoAdjustments[imageIndex].y;
            
            document.addEventListener('mousemove', resizePhoto);
            document.addEventListener('mouseup', stopResize);
            document.addEventListener('touchmove', resizePhoto, { passive: false });
            document.addEventListener('touchend', stopResize);
            
            function resizePhoto(e) {
                if (!isResizing) return;
                e.preventDefault();
                
                const coords = getEventCoords(e);
                // Convert display coordinates to actual coordinates - use resize start position
                const deltaX = (coords.x - resizeStartX) / canvasDisplayScale;
                const deltaY = (coords.y - resizeStartY) / canvasDisplayScale;
                
                let newWidth = startWidth;
                let newHeight = startHeight;
                let newX = startX;
                let newY = startY;
                
                if (currentHandle.classList.contains('handle-se')) {
                    newWidth = Math.max(50, startWidth + deltaX);
                    newHeight = Math.max(50, startHeight + deltaY);
                } else if (currentHandle.classList.contains('handle-sw')) {
                    newWidth = Math.max(50, startWidth - deltaX);
                    newHeight = Math.max(50, startHeight + deltaY);
                    newX = startX + (startWidth - newWidth);
                } else if (currentHandle.classList.contains('handle-ne')) {
                    newWidth = Math.max(50, startWidth + deltaX);
                    newHeight = Math.max(50, startHeight - deltaY);
                    newY = startY + (startHeight - newHeight);
                } else if (currentHandle.classList.contains('handle-nw')) {
                    newWidth = Math.max(50, startWidth - deltaX);
                    newHeight = Math.max(50, startHeight - deltaY);
                    newX = startX + (startWidth - newWidth);
                    newY = startY + (startHeight - newHeight);
                }
                
                // Maintain aspect ratio
                if (!photoAdjustments[imageIndex]) return;
                const aspectRatio = photoAdjustments[imageIndex].width / photoAdjustments[imageIndex].height;
                if (Math.abs(deltaX) > Math.abs(deltaY)) {
                    newHeight = newWidth / aspectRatio;
                } else {
                    newWidth = newHeight * aspectRatio;
                }
                
                // Keep within ACTUAL canvas bounds - ensure photo doesn't go outside
                const maxX = Math.max(0, actualTemplateWidth - newWidth);
                const maxY = Math.max(0, actualTemplateHeight - newHeight);
                
                newX = Math.max(0, Math.min(newX, maxX));
                newY = Math.max(0, Math.min(newY, maxY));
                
                // Double check bounds
                if (newX < 0) newX = 0;
                if (newY < 0) newY = 0;
                if (newX + newWidth > actualTemplateWidth) {
                    newX = Math.max(0, actualTemplateWidth - newWidth);
                }
                if (newY + newHeight > actualTemplateHeight) {
                    newY = Math.max(0, actualTemplateHeight - newHeight);
                }
                
                // Update display (scaled)
                overlay.style.left = (newX * canvasDisplayScale) + 'px';
                overlay.style.top = (newY * canvasDisplayScale) + 'px';
                overlay.style.width = (newWidth * canvasDisplayScale) + 'px';
                overlay.style.height = (newHeight * canvasDisplayScale) + 'px';
                
                // Save in ACTUAL dimensions
                if (!photoAdjustments[imageIndex]) {
                    photoAdjustments[imageIndex] = {};
                }
                photoAdjustments[imageIndex].x = newX;
                photoAdjustments[imageIndex].y = newY;
                photoAdjustments[imageIndex].width = newWidth;
                photoAdjustments[imageIndex].height = newHeight;
            }
            
            function stopResize() {
                isResizing = false;
                document.removeEventListener('mousemove', resizePhoto);
                document.removeEventListener('mouseup', stopResize);
                document.removeEventListener('touchmove', resizePhoto);
                document.removeEventListener('touchend', stopResize);
            }
        }
        
        handle.addEventListener('mousedown', startResize);
        handle.addEventListener('touchstart', startResize, { passive: false });
    });
    
    // Specific drag handler for THIS overlay only
    let dragMoveHandler = function(e) {
        // Only move if THIS specific overlay is being dragged
        if (isThisOverlayDragging && !isResizing) {
            e.preventDefault();
            e.stopPropagation();
            
            // Get canvas container position
            const canvasContainer = document.querySelector('.template-preview-editor');
            if (!canvasContainer) return;
            
            const containerRect = canvasContainer.getBoundingClientRect();
            
            // Calculate current position in actual coordinates
            const coords = getEventCoords(e);
            const currentMouseX = (coords.x - containerRect.left) / canvasDisplayScale;
            const currentMouseY = (coords.y - containerRect.top) / canvasDisplayScale;
            
            // Calculate delta (how much mouse moved) - use THIS overlay's start position
            const deltaX = currentMouseX - dragStartXForThis;
            const deltaY = currentMouseY - dragStartYForThis;
            
            // Calculate new position (initial position + delta)
            let newX = initialOverlayX + deltaX;
            let newY = initialOverlayY + deltaY;
            
            // Keep within ACTUAL canvas bounds
            if (!photoAdjustments[imageIndex]) return;
            const photoWidth = photoAdjustments[imageIndex].width || 100;
            const photoHeight = photoAdjustments[imageIndex].height || 100;
            
            let maxX = actualTemplateWidth - photoWidth;
            let maxY = actualTemplateHeight - photoHeight;
            
            // Ensure max values are not negative
            if (maxX < 0) maxX = 0;
            if (maxY < 0) maxY = 0;
            
            let boundedX = Math.max(0, Math.min(newX, maxX));
            let boundedY = Math.max(0, Math.min(newY, maxY));
            
            // Final bounds check - ensure photo doesn't go outside
            if (boundedX + photoWidth > actualTemplateWidth) {
                boundedX = Math.max(0, actualTemplateWidth - photoWidth);
            }
            if (boundedY + photoHeight > actualTemplateHeight) {
                boundedY = Math.max(0, actualTemplateHeight - photoHeight);
            }
            
            // Update display (scaled) - ONLY THIS OVERLAY
            overlay.style.left = (boundedX * canvasDisplayScale) + 'px';
            overlay.style.top = (boundedY * canvasDisplayScale) + 'px';
            
            // Save in ACTUAL dimensions
            if (!photoAdjustments[imageIndex]) {
                photoAdjustments[imageIndex] = {};
            }
            photoAdjustments[imageIndex].x = boundedX;
            photoAdjustments[imageIndex].y = boundedY;
        }
    };
    
    let dragEndHandler = function(e) {
        if (isThisOverlayDragging) {
            isThisOverlayDragging = false;
            isDragging = false;
            overlay.style.cursor = 'move';
            overlay.style.userSelect = 'auto';
        }
    };
    
    // Add event listeners for THIS specific overlay
    document.addEventListener('mousemove', dragMoveHandler);
    document.addEventListener('mouseup', dragEndHandler);
    document.addEventListener('touchmove', dragMoveHandler, { passive: false });
    document.addEventListener('touchend', dragEndHandler);
    
    // Store handlers on overlay for cleanup if needed
    overlay._dragMoveHandler = dragMoveHandler;
    overlay._dragEndHandler = dragEndHandler;
    overlay._imageIndex = imageIndex;
}

    // Reset photo position
function resetPhotoPosition() {
    if (!templateImageLoaded) return;
    
    const overlay = document.getElementById('userPhotoOverlay');
    const userImg = document.getElementById('userPhotoInEditor');
    
    if (!overlay || !userImg) {
        console.error('Overlay or user image not found');
        return;
    }
    
    if (userImg && userImg.complete && userImg.naturalWidth > 0) {
        // Use ACTUAL template dimensions
        const templateSize = Math.min(actualTemplateWidth, actualTemplateHeight);
        const initialSize = templateSize * 0.5;
        const aspectRatio = userImg.naturalWidth / userImg.naturalHeight;
        let photoWidth = initialSize;
        let photoHeight = initialSize / aspectRatio;
        
        if (photoHeight > initialSize) {
            photoHeight = initialSize;
            photoWidth = initialSize * aspectRatio;
        }
        
        // Center based on ACTUAL dimensions
        const x = (actualTemplateWidth - photoWidth) / 2;
        const y = (actualTemplateHeight - photoHeight) / 2;
        
        // Update display (scaled)
        overlay.style.left = (x * canvasDisplayScale) + 'px';
        overlay.style.top = (y * canvasDisplayScale) + 'px';
        overlay.style.width = (photoWidth * canvasDisplayScale) + 'px';
        overlay.style.height = (photoHeight * canvasDisplayScale) + 'px';
        overlay.style.display = 'block';
        
        // Save in ACTUAL dimensions (for old single-image editor, use index 0)
        if (!photoAdjustments[0]) {
            photoAdjustments[0] = {};
        }
        photoAdjustments[0].x = x;
        photoAdjustments[0].y = y;
        photoAdjustments[0].width = photoWidth;
        photoAdjustments[0].height = photoHeight;
        photoAdjustments[0].rotation = 0;
        photoAdjustments[0].opacity = 100;
        photoAdjustments[0].scale = 100;
    }
}

// Apply photo adjustments

function applyPhotoAdjustments() {
    // Adjustments are already saved in photoAdjustments object
}

function removeImage(index) {
    // Find which image index in uploadedImages corresponds to this upload slot
    // Since we're using sequential assignment, we need to find the actual imageIndex
    let imageIndexToRemove = null;
    
    // Check if there's an image at the provided index
    if (uploadedImages && uploadedImages[index]) {
        imageIndexToRemove = index;
    } else {
        // Find the image that was uploaded through this slot
        // We'll search through uploadedImages to find matching index
        for (let i in uploadedImages) {
            if (uploadedImages[i] && uploadedImages[i].index === index) {
                imageIndexToRemove = parseInt(i);
                break;
            }
        }
    }
    
    // Remove from uploadedImages if exists
    if (imageIndexToRemove !== null && uploadedImages && uploadedImages[imageIndexToRemove]) {
        delete uploadedImages[imageIndexToRemove];
    }
    
    // Remove overlay from template (new multi-overlay system)
    if (imageIndexToRemove !== null) {
        const overlayImg = document.getElementById(`overlayUserImage-${imageIndexToRemove}`);
        if (overlayImg) {
            overlayImg.remove();
        }
        
        // Remove from currentTemplateImage
        if (currentTemplateImage && currentTemplateImage[imageIndexToRemove]) {
            delete currentTemplateImage[imageIndexToRemove];
        }
        
        // Remove from templateOverlayPosition
        if (templateOverlayPosition && templateOverlayPosition[imageIndexToRemove]) {
            delete templateOverlayPosition[imageIndexToRemove];
        }
        
        // Remove overlay from unified editor (if exists)
        const overlay = document.getElementById(`photoOverlay-${imageIndexToRemove}`);
        if (overlay) {
            overlay.remove();
        }
        delete allPhotoOverlays[imageIndexToRemove];
        delete photoAdjustments[imageIndexToRemove];
        
        // If this was the current editing image, switch to another one
        if (currentEditingIndex === imageIndexToRemove) {
            const remainingIndices = Object.keys(uploadedImages).filter(i => uploadedImages[i] && uploadedImages[i].preview).map(i => parseInt(i)).sort((a, b) => a - b);
            if (remainingIndices.length > 0) {
                switchToImage(remainingIndices[0]);
            } else {
                currentEditingIndex = undefined;
            }
        }
        
        // Update tabs
        createImageSelectorTabs();
        
        // Hide overlay container if no images left
        const overlayDiv = document.getElementById('templateImageOverlay');
        if (overlayDiv) {
            const remainingOverlays = overlayDiv.querySelectorAll('img[id^="overlayUserImage-"]');
            if (remainingOverlays.length === 0) {
                overlayDiv.style.display = 'none';
            }
        }
    }
    
    // Reset upload section
    const preview = document.getElementById(`preview-${index}`);
    const placeholder = document.getElementById(`placeholder-${index}`);
    const removeBtn = document.querySelector(`.remove-image-btn[onclick*="removeImage(${index})"]`);
    const input = document.querySelector(`.image-upload-input[data-index="${index}"]`);
    const label = document.getElementById(`label-${index}`);
    
    if (preview) preview.style.display = 'none';
    if (placeholder) placeholder.style.display = 'flex';
    if (removeBtn) removeBtn.style.display = 'none';
    if (input) input.value = '';
    
    // Reset label
    if (label) {
        label.textContent = 'Upload Photo';
        label.classList.remove('uploaded');
    }
}

// Uplines photos management
let uplinePhotos = []; // Array to store upline photos

function addUplinePhoto() {
    // Create a hidden file input
    const input = document.createElement('input');
    input.type = 'file';
    input.accept = 'image/*';
    input.style.display = 'none';
    input.onchange = function(e) {
        const file = e.target.files[0];
        if (file && file.type.startsWith('image/')) {
            handleUplinePhotoUpload(file);
        }
        // Remove input after use
        document.body.removeChild(input);
    };
    document.body.appendChild(input);
    input.click();
}

function handleUplinePhotoUpload(file) {
    // Show loader
    const uplineLoader = document.getElementById('uplineUploadLoader');
    if (uplineLoader) {
        uplineLoader.style.setProperty('display', 'block', 'important');
    }
    
    // Process image (remove background)
    removeBackground(file, function(processedFile, processedPreviewUrl) {
        // Hide loader
        if (uplineLoader) {
            uplineLoader.style.setProperty('display', 'none', 'important');
        }
        // Add to upline photos array
        const uplineIndex = uplinePhotos.length;
        uplinePhotos.push({
            file: processedFile,
            preview: processedPreviewUrl,
            imageUrl: processedPreviewUrl,
            imageName: file.name,
            isNew: true // Mark as new upload
        });
        
        // Display the upline photo
        displayUplinePhoto(uplineIndex, processedPreviewUrl, true);
        
        // Save to database immediately
        saveUplineToDatabase(processedFile, uplineIndex, file.name);
    });
    
    // Add timeout protection - hide loader after 30 seconds if still showing
    setTimeout(function() {
        if (uplineLoader && uplineLoader.style.display !== 'none') {
            uplineLoader.style.setProperty('display', 'none', 'important');
            console.warn('Upline upload timeout - hiding loader');
        }
    }, 30000);
}

// Save upline photo to database immediately after upload
function saveUplineToDatabase(file, uplineIndex, originalName) {
    // Note: uplineIndex is the index in uplinePhotos array where this photo was added
    const formData = new FormData();
    formData.append('upline_photo', file);
    formData.append('original_name', originalName);
    
    $.ajax({
        url: '<?= base_url('index.php/action/save_upline_immediate') ?>',
        type: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        dataType: 'json',
        success: function(response) {
            if (response.success) {
                let existingIndex = -1; // Declare outside to use in checkmark display
                let currentIndex = uplineIndex; // Default to original index
                
                // Update upline photo object with database ID
                if (response.upline_id) {
                    // Check if this upline already exists in array (by uplineId) to avoid duplicates
                    existingIndex = uplinePhotos.findIndex(function(upline, idx) {
                        return upline.uplineId && upline.uplineId == response.upline_id && idx !== uplineIndex;
                    });
                    
                    if (existingIndex >= 0) {
                        // Duplicate found - remove the old entry
                        console.log('Duplicate upline detected at save, removing old entry at index:', existingIndex);
                        const oldElement = document.getElementById(`upline-${existingIndex}`);
                        if (oldElement) oldElement.remove();
                        uplinePhotos.splice(existingIndex, 1);
                        // Reindex after removal
                        reindexUplines();
                        // Adjust current index if we removed an item before it
                        if (existingIndex < uplineIndex) {
                            currentIndex = uplineIndex - 1;
                        }
                    }
                    
                    // Update the current entry
                    if (uplinePhotos[currentIndex]) {
                        uplinePhotos[currentIndex].uplineId = response.upline_id;
                        uplinePhotos[currentIndex].isNew = false;
                    }
                }
                
                // Show success indicator (use correct index after potential duplicate removal)
                const uplineItem = document.getElementById(`upline-${currentIndex}`);
                if (uplineItem) {
                    const checkmark = document.createElement('div');
                    checkmark.style.cssText = 'position: absolute; top: -5px; left: -5px; width: 20px; height: 20px; background: #28a745; border-radius: 50%; display: flex; align-items: center; justify-content: center; z-index: 15; border: 2px solid #fff;';
                    checkmark.innerHTML = '<i class="iconsax" data-icon="tick-circle" style="color: #fff; font-size: 12px;"></i>';
                    uplineItem.appendChild(checkmark);
                    
                    // Remove checkmark after 2 seconds
                    setTimeout(function() {
                        if (checkmark.parentElement) {
                            checkmark.remove();
                        }
                    }, 2000);
                }
                
                console.log('Upline photo saved to database:', response.message);
        } else {
                console.error('Failed to save upline:', response.message);
            }
        },
        error: function(xhr, status, error) {
            console.error('Error saving upline photo:', error);
        }
    });
}

// Load saved upline photos from database
let uplinesLoaded = false; // Flag to prevent duplicate loading
function loadSavedUplines() {
    // Prevent duplicate loading
    if (uplinesLoaded) {
        console.log('Uplines already loaded, skipping...');
        return;
    }
    
    $.ajax({
        url: '<?= base_url('index.php/action/get_user_uplines') ?>',
        type: 'POST',
        dataType: 'json',
        success: function(response) {
            if (response.success && response.uplines && response.uplines.length > 0) {
                response.uplines.forEach(function(upline) {
                    // Check if this upline is already in the array (by uplineId)
                    const exists = uplinePhotos.some(function(existing) {
                        return existing.uplineId && existing.uplineId == upline.upline_id;
                    });
                    
                    if (!exists) {
                        // Add to upline photos array
                        const uplineIndex = uplinePhotos.length;
                        uplinePhotos.push({
                            preview: upline.image_url,
                            imageUrl: upline.image_url,
                            imageName: upline.upline_original_name || 'upline.jpg',
                            uplineId: upline.upline_id,
                            isNew: false // From database
                        });
                        
                        // Display the upline photo
                        displayUplinePhoto(uplineIndex, upline.image_url, false);
                    }
                });
                uplinesLoaded = true;
            }
        },
        error: function() {
            console.error('Failed to load saved uplines');
        }
    });
}

function displayUplinePhoto(index, previewUrl, isNewUpload) {
    const uplinesList = document.getElementById('uplinesList');
    if (!uplinesList) return;
    
    // Create upline photo element
    const uplineItem = document.createElement('div');
    uplineItem.className = 'upline-photo-item';
    uplineItem.id = `upline-${index}`;
    uplineItem.style.cssText = 'position: relative; flex-shrink: 0; width: 60px; height: 60px; border-radius: 50%; overflow: hidden; border: 2px solid #d4af37; box-shadow: 0 2px 8px rgba(0,0,0,0.1);';
    
    // Create image
    const img = document.createElement('img');
    img.src = previewUrl;
    img.style.cssText = 'width: 100%; height: 100%; object-fit: cover; cursor: pointer; transition: transform 0.2s;';
    img.alt = 'Upline Photo';
    img.title = 'Click to add on template';
    
    // Add hover effect
    img.onmouseenter = function() {
        this.style.transform = 'scale(1.1)';
        this.style.boxShadow = '0 0 10px rgba(255, 193, 7, 0.6)';
    };
    img.onmouseleave = function() {
        this.style.transform = 'scale(1)';
        this.style.boxShadow = 'none';
    };
    
    // Add click handler to add this photo to template
    img.onclick = function() {
        addUplineToTemplate(index);
    };
    
    // Create remove button
    const removeBtn = document.createElement('button');
    removeBtn.type = 'button';
    removeBtn.className = 'remove-upline-btn';
    removeBtn.innerHTML = '<i class="iconsax" data-icon="close-circle"></i>';
    removeBtn.style.cssText = 'position: absolute; top: -5px; right: -5px; width: 24px; height: 24px; border-radius: 50%; background: #ff4444; border: 2px solid #fff; color: #fff; display: flex; align-items: center; justify-content: center; cursor: pointer; font-size: 12px; z-index: 10; padding: 0;';
    removeBtn.onclick = function(e) {
            e.stopPropagation();
        removeUplinePhoto(index);
    };
    
    uplineItem.appendChild(img);
    uplineItem.appendChild(removeBtn);
    
    // Insert before the add button (which is next sibling of uplinesList)
    const addBtn = uplinesList.parentElement.querySelector('.add-upline-btn');
    if (addBtn && addBtn.parentElement) {
        uplinesList.appendChild(uplineItem);
    } else {
        uplinesList.appendChild(uplineItem);
    }
}

function removeUplinePhoto(index) {
    const uplinePhoto = uplinePhotos[index];
    
    // If it's from database, delete from server
    if (uplinePhoto && uplinePhoto.uplineId && !uplinePhoto.isNew) {
        $.ajax({
            url: '<?= base_url('index.php/action/delete_upline') ?>',
            type: 'POST',
            data: { upline_id: uplinePhoto.uplineId },
            dataType: 'json',
            success: function(response) {
                console.log('Upline deleted:', response.message);
            },
            error: function() {
                console.error('Failed to delete upline from database');
            }
        });
    }
    
    // Remove from array
    uplinePhotos.splice(index, 1);
    
    // Remove from DOM
    const uplineItem = document.getElementById(`upline-${index}`);
    if (uplineItem) {
        uplineItem.remove();
    }
    
    // Re-index remaining uplines
    reindexUplines();
}

function reindexUplines() {
    const uplinesList = document.getElementById('uplinesList');
    if (!uplinesList) return;
    
    // Get all upline items
    const uplineItems = uplinesList.querySelectorAll('.upline-photo-item');
    
    // Update IDs and remove button handlers
    uplineItems.forEach((item, newIndex) => {
        item.id = `upline-${newIndex}`;
        const removeBtn = item.querySelector('.remove-upline-btn');
        if (removeBtn) {
            removeBtn.onclick = function(e) {
                e.stopPropagation();
                removeUplinePhoto(newIndex);
            };
        }
        
        // Update click handler for image
        const img = item.querySelector('img');
        if (img) {
            img.onclick = function() {
                addUplineToTemplate(newIndex);
            };
        }
    });
}

// Add upline photo to template overlay
function addUplineToTemplate(uplineIndex) {
    if (!uplinePhotos[uplineIndex]) {
        console.error('Upline photo not found at index:', uplineIndex);
        return;
    }
    
    const uplinePhoto = uplinePhotos[uplineIndex];
    
    // Mark this upline as added to template
    uplinePhoto.addedToTemplate = true;
    
    // Get next available sequential index (no overwrite)
    const imageIndex = getNextAvailableImageIndex();
    
    // Store in uploadedImages array for consistency
    uploadedImages[imageIndex] = {
        file: uplinePhoto.file,
        preview: uplinePhoto.preview,
        imageUrl: uplinePhoto.imageUrl,
        imageName: uplinePhoto.imageName,
        fromGallery: false,
        isUpline: true,
        uplineIndex: uplineIndex,
        index: imageIndex
    };
    
    // Set currentImageIndex to the calculated imageIndex BEFORE calling setImageOnTemplate
    currentImageIndex = imageIndex;
    
    // Use setImageOnTemplate to display image on template (same as upload/gallery)
    setImageOnTemplate(uplinePhoto.preview, uplinePhoto.imageName, uplinePhoto.file);
}

// Form submission
document.getElementById('generateImageForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    // Check template price
    const templatePriceElement = document.getElementById('template_price');
    if (!templatePriceElement) {
        proceedWithGeneration();
        return;
    }
    
    const templatePrice = parseFloat(templatePriceElement.value) || 0;
    
    // If price is 0 or free, proceed directly
    if (isNaN(templatePrice) || templatePrice <= 0) {
        proceedWithGeneration();
        return;
    }
    
    // If price > 0, check balance and show confirmation
    const generateBtn = document.getElementById('generateBtn');
    const originalBtnText = generateBtn.innerHTML;
    generateBtn.disabled = true;
    generateBtn.innerHTML = '<i class="iconsax" data-icon="loading"></i> Checking...';
    
    $.ajax({
        url: '<?= base_url('index.php/action/get_wallet_balance') ?>',
        type: 'POST',
        dataType: 'json',
        success: function(response) {
            generateBtn.disabled = false;
            generateBtn.innerHTML = originalBtnText;
            
            if (!response.success) {
                alert(response.message || 'Unable to check balance. Please try again.');
                return;
            }
            
            const currentBalance = parseFloat(response.balance) || 0;
            
            // Check if user has sufficient balance
            if (currentBalance < templatePrice) {
                alert('Insufficient Balance!\n\nRequired: ₹' + templatePrice.toFixed(2) + '\nAvailable: ₹' + currentBalance.toFixed(2) + '\n\nPlease recharge your wallet to continue.');
                return;
            }
            
            // Show confirmation dialog
            const confirmMsg = 'Template Price: ₹' + templatePrice.toFixed(2) + 
                             '\nYour Balance: ₹' + currentBalance.toFixed(2) + 
                             '\nBalance After: ₹' + (currentBalance - templatePrice).toFixed(2) + 
                             '\n\nDo you want to proceed with template generation?';
            
            if (confirm(confirmMsg)) {
                // User confirmed, proceed with generation
                proceedWithGeneration();
            }
        },
        error: function() {
            generateBtn.disabled = false;
            generateBtn.innerHTML = originalBtnText;
            alert('Unable to check balance. Please try again.');
        }
    });
});

function proceedWithGeneration() {
    const formData = new FormData(document.getElementById('generateImageForm'));
    
    // Add text field values from session (automatically fetched)
    if (templateTextFields && templateTextFields.length > 0) {
        templateTextFields.forEach(function(textField) {
            const fieldName = textField.text_field_name;
            const fieldValue = getSessionValue(fieldName);
            
            if (fieldValue) {
                formData.append('text_field_' + fieldName, fieldValue);
                console.log('Adding text field to form:', fieldName, '=', fieldValue);
            }
        });
    }
    
    // Add bike details if provided (check if elements exist first)
    const bikeCompanyEl = document.getElementById('bike_company');
    const bikePriceEl = document.getElementById('bike_price');
    
    if (bikeCompanyEl && bikeCompanyEl.value) {
        formData.set('bike_company', bikeCompanyEl.value);
    }
    if (bikePriceEl && bikePriceEl.value) {
        formData.set('bike_price', bikePriceEl.value);
    }
    
    // Add upline photo ONLY if it was clicked and added to template
    // Only the upline photo in currentTemplateImage should be sent
    if (currentTemplateImage && currentTemplateImage.isUpline) {
        const uplinePhoto = uplinePhotos[currentTemplateImage.uplineIndex];
        if (uplinePhoto) {
            // Get template image dimensions for position calculation
            const templateImg = document.getElementById('mainTemplateImage');
            const templateRect = templateImg.getBoundingClientRect();
            const displayWidth = templateRect.width;
            const displayHeight = templateRect.height;
            
            // Get actual template dimensions (from canvas or image natural size)
            const actualWidth = actualTemplateWidth || templateImg.naturalWidth || displayWidth;
            const actualHeight = actualTemplateHeight || templateImg.naturalHeight || displayHeight;
            
            // Calculate scale factor
            const scaleX = actualWidth / displayWidth;
            const scaleY = actualHeight / displayHeight;
            
            // Convert display position to actual template position
            const actualX = templateOverlayPosition.x * scaleX;
            const actualY = templateOverlayPosition.y * scaleY;
            const actualWidth_pos = templateOverlayPosition.width * scaleX;
            const actualHeight_pos = templateOverlayPosition.height * scaleY;
            
            // If it has a file object (new upload), send the file
            if (uplinePhoto.file) {
                formData.append('upline_photos[]', uplinePhoto.file);
                console.log('Adding clicked upline photo file to form:', uplinePhoto.imageName || 'upline');
            }
            // If it's from database (has uplineId but no file), send the ID
            else if (uplinePhoto.uplineId && !uplinePhoto.isNew) {
                formData.append('upline_ids[]', uplinePhoto.uplineId);
                console.log('Adding clicked upline photo ID to form:', uplinePhoto.uplineId);
            }
            
            // Send position and size for upline photo (same as user photo)
            formData.append('upline_photo_x', Math.round(actualX));
            formData.append('upline_photo_y', Math.round(actualY));
            formData.append('upline_photo_width', Math.round(actualWidth_pos));
            formData.append('upline_photo_height', Math.round(actualHeight_pos));
            
            // Send template dimensions for verification
            formData.append('template_width', actualWidth);
            formData.append('template_height', actualHeight);
            
            // Calculate relative positions (percentage of ACTUAL template size)
            const x_percent = (actualX / actualWidth) * 100;
            const y_percent = (actualY / actualHeight) * 100;
            const width_percent = (actualWidth_pos / actualWidth) * 100;
            const height_percent = (actualHeight_pos / actualHeight) * 100;
            
            formData.append('upline_photo_x_percent', x_percent.toFixed(2));
            formData.append('upline_photo_y_percent', y_percent.toFixed(2));
            formData.append('upline_photo_width_percent', width_percent.toFixed(2));
            formData.append('upline_photo_height_percent', height_percent.toFixed(2));
            
            console.log('Upline photo position:', {
                x: Math.round(actualX),
                y: Math.round(actualY),
                width: Math.round(actualWidth_pos),
                height: Math.round(actualHeight_pos),
                x_percent: x_percent.toFixed(2),
                y_percent: y_percent.toFixed(2),
                width_percent: width_percent.toFixed(2),
                height_percent: height_percent.toFixed(2)
            });
        }
    }
    
    // Get template image dimensions for position calculation
    const templateImg = document.getElementById('mainTemplateImage');
    const templateRect = templateImg ? templateImg.getBoundingClientRect() : { width: 0, height: 0 };
    const displayWidth = templateRect.width;
    const displayHeight = templateRect.height;
    
    // Get actual template dimensions
    const actualWidth = actualTemplateWidth || (templateImg ? templateImg.naturalWidth : 0) || displayWidth;
    const actualHeight = actualTemplateHeight || (templateImg ? templateImg.naturalHeight : 0) || displayHeight;
    
    // Send template dimensions
    formData.append('template_width', actualWidth);
    formData.append('template_height', actualHeight);
    
    // Collect all photo adjustments for multiple images
    const allPhotoAdjustmentsArray = {};
    
    console.log('=== Collecting Photo Adjustments ===');
    console.log('templateOverlayPosition:', templateOverlayPosition);
    console.log('uploadedImages keys:', Object.keys(uploadedImages));
    console.log('actualWidth:', actualWidth, 'actualHeight:', actualHeight);
    
    // Process all uploaded images from templateOverlayPosition (multiple images support)
    // Match positions with uploaded images by index
    if (templateOverlayPosition && typeof templateOverlayPosition === 'object') {
        Object.keys(templateOverlayPosition).forEach(imageIndexStr => {
            const imageIndex = parseInt(imageIndexStr);
            const pos = templateOverlayPosition[imageIndexStr];
            
            // Only process if we have actual position data AND an uploaded image at this index
            if (pos && pos.actualX !== undefined && uploadedImages[imageIndex] && uploadedImages[imageIndex].file) {
                // Use actual template dimensions (already calculated)
                allPhotoAdjustmentsArray[imageIndex] = {
                    x: Math.round(pos.actualX),
                    y: Math.round(pos.actualY),
                    width: Math.round(pos.actualWidth),
                    height: Math.round(pos.actualHeight),
                    x_percent: (pos.actualX / actualWidth) * 100,
                    y_percent: (pos.actualY / actualHeight) * 100,
                    width_percent: (pos.actualWidth / actualWidth) * 100,
                    height_percent: (pos.actualHeight / actualHeight) * 100,
                    scale: 100,
                    rotation: 0,
                    opacity: 100
                };
                console.log('✅ Position data collected for image index', imageIndex, ':', allPhotoAdjustmentsArray[imageIndex]);
            } else {
                if (!pos || pos.actualX === undefined) {
                    console.warn('⚠️ No position data for image index', imageIndex);
                }
                if (!uploadedImages[imageIndex] || !uploadedImages[imageIndex].file) {
                    console.warn('⚠️ No uploaded image file for index', imageIndex);
                }
            }
        });
    } else {
        console.warn('⚠️ templateOverlayPosition is empty or invalid');
    }
    
    console.log('Final allPhotoAdjustmentsArray:', allPhotoAdjustmentsArray);
    
    // Add all uploaded images and their positions
    // IMPORTANT: Sort by index to ensure correct order (0, 1, 2...)
    const sortedImageIndices = Object.keys(uploadedImages).map(idx => parseInt(idx)).sort((a, b) => a - b);
    
    console.log('=== Sending Images for Generation ===');
    console.log('Total uploaded images:', sortedImageIndices.length);
    console.log('uploadedImages:', uploadedImages);
    console.log('templateOverlayPosition:', templateOverlayPosition);
    console.log('allPhotoAdjustmentsArray:', allPhotoAdjustmentsArray);
    
    sortedImageIndices.forEach(index => {
        if (uploadedImages[index] && uploadedImages[index].file) {
            formData.append('user_photos[]', uploadedImages[index].file);
            console.log('Adding image at index', index, ':', uploadedImages[index].imageName || 'image');
            
            // If we have position data for this image, use it
            if (allPhotoAdjustmentsArray[index]) {
                const adj = allPhotoAdjustmentsArray[index];
                console.log('Position data for image', index, ':', adj);
                
                // Send position data for THIS specific image index
                formData.append(`photo_${index}_x`, adj.x);
                formData.append(`photo_${index}_y`, adj.y);
                formData.append(`photo_${index}_width`, adj.width);
                formData.append(`photo_${index}_height`, adj.height);
                formData.append(`photo_${index}_x_percent`, adj.x_percent.toFixed(2));
                formData.append(`photo_${index}_y_percent`, adj.y_percent.toFixed(2));
                formData.append(`photo_${index}_width_percent`, adj.width_percent.toFixed(2));
                formData.append(`photo_${index}_height_percent`, adj.height_percent.toFixed(2));
                
                // For backward compatibility, also send primary photo adjustments (index 0)
                if (index == 0) {
                    formData.append('photo_x', adj.x);
                    formData.append('photo_y', adj.y);
                    formData.append('photo_width', adj.width);
                    formData.append('photo_height', adj.height);
                    formData.append('photo_x_percent', adj.x_percent.toFixed(2));
                    formData.append('photo_y_percent', adj.y_percent.toFixed(2));
                    formData.append('photo_width_percent', adj.width_percent.toFixed(2));
                    formData.append('photo_height_percent', adj.height_percent.toFixed(2));
                }
            } else {
                console.warn('⚠️ No position data found for image index', index);
            }
        } else {
            console.warn('⚠️ Image at index', index, 'has no file');
        }
    });
    
    console.log('=== Finished Preparing Images ===');
    
    // Send all photo adjustments as JSON
    if (Object.keys(allPhotoAdjustmentsArray).length > 0) {
        formData.append('all_photo_adjustments', JSON.stringify(allPhotoAdjustmentsArray));
        console.log('Sending photo adjustments:', allPhotoAdjustmentsArray);
    }
    
    const generateBtn = document.getElementById('generateBtn');
    generateBtn.disabled = true;
    generateBtn.innerHTML = '<i class="iconsax" data-icon="loading"></i> Generating...';
    
    // Call backend to generate image
    $.ajax({
        beforeSend: function() {
            // Clear any previous error messages
            console.log('Starting image generation...');
        },
        url: '<?= base_url('index.php/action/generate_image_action') ?>',
        type: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        success: function(response) {
            try {
                const result = typeof response === 'string' ? JSON.parse(response) : response;
                if (result.success) {
                    const generatedSection = document.getElementById('generatedImageSection');
                    const generatedContainer = document.getElementById('generatedImageContainer');
                    
                    generatedContainer.innerHTML = `
                        <img src="${result.image_url}" 
                             alt="Generated Image" 
                             id="generatedImage">
                    `;
                    
                    generatedSection.style.display = 'block';
                    generateBtn.disabled = false;
                    generateBtn.innerHTML = '<i class="iconsax" data-icon="magic-star"></i> CREATE';
                    
                    // Scroll to generated image
                    generatedSection.scrollIntoView({ behavior: 'smooth' });
                } else {
                    alert(result.message || 'Failed to generate image');
                    generateBtn.disabled = false;
                    generateBtn.innerHTML = '<i class="iconsax" data-icon="magic-star"></i> CREATE';
                }
            } catch(e) {
                alert('Error generating image. Please try again.');
                generateBtn.disabled = false;
                generateBtn.innerHTML = '<i class="iconsax" data-icon="magic-star"></i> CREATE';
            }
        },
        error: function(xhr, status, error) {
            console.error('AJAX Error:', status, error);
            console.error('Response:', xhr.responseText);
            
            let errorMsg = 'Error generating image. Please try again.';
            try {
                const errorResponse = JSON.parse(xhr.responseText);
                if (errorResponse.message) {
                    errorMsg = errorResponse.message;
                }
            } catch(e) {
                // If response is not JSON, show default message
                if (xhr.responseText) {
                    errorMsg = 'Server error: ' + xhr.responseText.substring(0, 200);
                }
            }
            
            alert(errorMsg);
            generateBtn.disabled = false;
            generateBtn.innerHTML = '<i class="iconsax" data-icon="magic-star"></i> GENERATE IMAGE';
        }
    });
}

function downloadImage() {
    const img = document.getElementById('generatedImage');
    if (!img || !img.src) {
        alert('No image available to download. Please generate an image first.');
        return;
    }
    
    // Show loader on download button
    const downloadBtn = document.getElementById('downloadBtn');
    const downloadBtnText = document.getElementById('downloadBtnText');
    const originalText = downloadBtnText ? downloadBtnText.textContent : 'Download';
    
    if (downloadBtn) {
        downloadBtn.disabled = true;
        if (downloadBtnText) {
            downloadBtnText.innerHTML = '<span class="spinner-border spinner-border-sm me-2" role="status" aria-hidden="true"></span>Downloading...';
        }
    }
    
    // Create download link
    const link = document.createElement('a');
    link.download = 'generated-image-' + Date.now() + '.png';
    link.href = img.src;
    
    // Handle download completion
    link.onclick = function() {
        // Reset button after a short delay
        setTimeout(function() {
            if (downloadBtn) {
                downloadBtn.disabled = false;
                if (downloadBtnText) {
                    downloadBtnText.textContent = originalText;
                }
            }
        }, 1000);
    };
    
    // Trigger download
    document.body.appendChild(link);
    link.click();
    document.body.removeChild(link);
    
    // Fallback: reset button after 2 seconds if still disabled
    setTimeout(function() {
        if (downloadBtn && downloadBtn.disabled) {
            downloadBtn.disabled = false;
            if (downloadBtnText) {
                downloadBtnText.textContent = originalText;
            }
        }
    }, 2000);
}

function shareImage() {
    const img = document.getElementById('generatedImage');
    if (img && navigator.share) {
        fetch(img.src)
            .then(res => res.blob())
            .then(blob => {
                const file = new File([blob], 'generated-image.png', { type: 'image/png' });
                navigator.share({
                    title: 'My Generated Image',
                    files: [file]
                });
            });
    } else {
        alert('Share functionality will be implemented here');
    }
}

// Global Loader Functions for Screen Switching (only use when actually navigating)
function showGlobalLoader(message) {
    const loader = document.getElementById('globalLoaderOverlay');
    const loaderText = document.getElementById('globalLoaderText');
    if (loader) {
        if (loaderText && message) {
            loaderText.textContent = message;
        }
        loader.style.setProperty('display', 'block', 'important');
    }
}

function hideGlobalLoader() {
    const loader = document.getElementById('globalLoaderOverlay');
    if (loader) {
        loader.style.setProperty('display', 'none', 'important');
    }
}

// Ensure all loaders are hidden on page load
(function() {
    function hideAllLoaders() {
        // Hide global loader
        hideGlobalLoader();
        
        // Hide upline upload loader
        const uplineLoader = document.getElementById('uplineUploadLoader');
        if (uplineLoader) {
            uplineLoader.style.setProperty('display', 'none', 'important');
        }
    }
    
    // Hide immediately when DOM is ready
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', function() {
            hideAllLoaders();
        });
    } else {
        // DOM is already ready
        hideAllLoaders();
    }
    
    // Also hide on window load
    window.addEventListener('load', function() {
        hideAllLoaders();
    });
    
    // Hide after a short delay as backup
    setTimeout(function() {
        hideAllLoaders();
    }, 500);
})();

// Toggle Save Template
function toggleSaveTemplate(tempId, button) {
    const isSaved = button.classList.contains('saved');
    
    $.ajax({
        url: '<?= base_url('index.php/action/toggle_save_template') ?>',
        type: 'POST',
        data: { temp_id: tempId },
        dataType: 'json',
        success: function(response) {
            if (response.success) {
                // Update the clicked button
                if (response.saved) {
                    button.classList.add('saved');
                    if (button.title !== undefined) {
                        button.title = 'Unsave Template';
                    }
                    // Update button text
                    const span = button.querySelector('span');
                    if (span) {
                        span.textContent = 'Template Saved';
                    }
                } else {
                    button.classList.remove('saved');
                    if (button.title !== undefined) {
                        button.title = 'Save Template';
                    }
                    // Update button text
                    const span = button.querySelector('span');
                    if (span) {
                        span.textContent = 'Save Template';
                    }
                }
                
                // Also update the header save button if it exists
                const headerSaveBtn = document.querySelector('.template-save-btn-header[data-template-id="' + tempId + '"]');
                if (headerSaveBtn && headerSaveBtn !== button) {
                    if (response.saved) {
                        headerSaveBtn.classList.add('saved');
                        headerSaveBtn.querySelector('i').setAttribute('data-icon', 'heart');
                        headerSaveBtn.title = 'Unsave Template';
                    } else {
                        headerSaveBtn.classList.remove('saved');
                        headerSaveBtn.querySelector('i').setAttribute('data-icon', 'heart-add');
                        headerSaveBtn.title = 'Save Template';
                    }
                }
                
                // Also update the "Save Template" tab button if it exists
                const saveTabBtn = document.querySelector('.save-template-tab[data-template-id="' + tempId + '"]');
                if (saveTabBtn && saveTabBtn !== button) {
                    if (response.saved) {
                        saveTabBtn.classList.add('saved');
                        const span = saveTabBtn.querySelector('span');
                        if (span) {
                            span.textContent = 'Template Saved';
                        }
                    } else {
                        saveTabBtn.classList.remove('saved');
                        const span = saveTabBtn.querySelector('span');
                        if (span) {
                            span.textContent = 'Save Template';
                        }
                    }
                }
            } else {
                alert(response.message || 'Error saving template');
            }
        },
        error: function() {
            alert('Error saving template. Please try again.');
        }
    });
}

// Auto-load gallery images when page loads
$(document).ready(function() {
    // Hide old empty overlay element (backward compatibility)
    const oldOverlay = document.getElementById('overlayUserImage');
    if (oldOverlay && (!oldOverlay.src || oldOverlay.src === '' || oldOverlay.src === window.location.href)) {
        oldOverlay.style.display = 'none';
    }
    
    // Hide any empty overlay elements that don't have images
    const overlayDiv = document.getElementById('templateImageOverlay');
    if (overlayDiv) {
        const allOverlays = overlayDiv.querySelectorAll('img[id^="overlayUserImage"]');
        allOverlays.forEach(overlay => {
            if (!overlay.src || overlay.src === '' || overlay.src === window.location.href || overlay.naturalWidth === 0) {
                overlay.style.display = 'none';
            }
        });
    }
    
    // Set dimensions if image already loaded
    const templateImg = document.getElementById('mainTemplateImage');
    if (templateImg && templateImg.complete) {
        setTemplateDimensions(templateImg);
    }
    
    // Initially hide gallery section until images are loaded
    const galleryWrapper = document.getElementById('gallerySectionWrapper');
    if (galleryWrapper) galleryWrapper.style.display = 'none';
    
    // Load gallery images below template automatically
    loadGalleryImagesBelowTemplate();
    
    // Handle window resize - recalculate image position
    let resizeTimeout;
    window.addEventListener('resize', function() {
        clearTimeout(resizeTimeout);
        resizeTimeout = setTimeout(function() {
            // Recalculate position if image is already set
            const overlayImg = document.getElementById('overlayUserImage');
            if (overlayImg && overlayImg.src && currentTemplateImage) {
                setImageOnTemplateHelper(currentTemplateImage.preview, currentTemplateImage.imageName, currentTemplateImage.file);
            }
        }, 250);
    });
});
</script>

