<!-- Tabs Navigation - Hidden when only one tab exists -->
<!-- <section class="tabs-navigation-section">
    <div class="custom-container">
        <ul class="nav nav-tabs instagram-tabs" id="homeTabs" role="tablist">
            <li class="nav-item" role="presentation">
                <button class="nav-link active" id="dashboard-tab" data-bs-toggle="tab" data-bs-target="#dashboard" type="button" role="tab">
                    DASHBOARD
                </button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="message-tab" data-bs-toggle="tab" data-bs-target="#message" type="button" role="tab">
                    MESSAGE
                </button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="feed-tab" data-bs-toggle="tab" data-bs-target="#feed" type="button" role="tab">
                    FEED
                </button>
            </li>
        </ul>
    </div>
</section> -->

<!-- Tab Content -->
<div class="tab-content" id="homeTabsContent">
    <!-- DASHBOARD Tab -->
    <div class="tab-pane fade show active" id="dashboard" role="tabpanel">
        <!-- Stories Section -->
        <section class="stories-section">
            <div class="custom-container">
                <h5 class="stories-title">Stories</h5>
                <div class="stories-container">
                    <div class="stories-scroll">
                        <!-- User's own story (Add Story) -->
                        <div class="story-item add-story" onclick="openStoryUpload()">
                            <div class="story-circle add-story-circle">
                                <div class="story-image-wrapper">
                                    <?php
                                    $yid = $_SESSION['yid'];
                                    $user_photo = '';
                                    if (!empty($profile_data['photo']) && $profile_data['photo'] != 'photo.jpg') {
                                        $photo_path1 = 'assets/mem/' . $yid . '/img/' . $profile_data['photo'];
                                        $photo_path2 = 'assets/mem/' . $yid . '/img/photo.jpg';
                                        $photo_path3 = 'assets/avator/upload/' . $profile_data['photo'];

                                        if (file_exists($photo_path1)) {
                                            $user_photo = base_url($photo_path1);
                                        } elseif (file_exists($photo_path2)) {
                                            $user_photo = base_url($photo_path2);
                                        } elseif (file_exists($photo_path3)) {
                                            $user_photo = base_url($photo_path3);
                                        } else {
                                            $user_photo = base_url('assets/theme/v1/social-app/assets/images/profile/p3.png');
                                        }
                                    } else {
                                        $photo_path = 'assets/mem/' . $yid . '/img/photo.jpg';
                                        if (file_exists($photo_path)) {
                                            $user_photo = base_url($photo_path);
                                        } else {
                                            $user_photo = base_url('assets/theme/v1/social-app/assets/images/profile/p3.png');
                                        }
                                    }
                                    ?>
                                    <img src="<?= $user_photo ?>" alt="Your Story" class="story-profile-img">
                                    <div class="add-story-icon">
                                        <i class="iconsax" data-icon="add"></i>
                                    </div>
                                </div>
                            </div>
                            <p class="story-label">Your Story</p>
                        </div>

                        <!-- Other Users' Stories -->
                        <?php if (!empty($stories_by_user)): ?>
                            <?php foreach ($stories_by_user as $user_story): ?>
                                <div class="story-item" onclick="viewStory(<?= $user_story['user_id'] ?>)">
                                    <div class="story-circle <?= $user_story['has_unviewed'] ? 'unviewed' : '' ?>">
                                        <div class="story-image-wrapper">
                                            <?php
                                            $story_user_photo = '';
                                            if (!empty($user_story['user_photo'])) {
                                                $story_photo_path1 = 'assets/mem/' . $user_story['user_id'] . '/img/' . $user_story['user_photo'];
                                                $story_photo_path2 = 'assets/mem/' . $user_story['user_id'] . '/img/photo.jpg';
                                                $story_photo_path3 = 'assets/avator/upload/' . $user_story['user_photo'];

                                                if (file_exists($story_photo_path1)) {
                                                    $story_user_photo = base_url($story_photo_path1);
                                                } elseif (file_exists($story_photo_path2)) {
                                                    $story_user_photo = base_url($story_photo_path2);
                                                } elseif (file_exists($story_photo_path3)) {
                                                    $story_user_photo = base_url($story_photo_path3);
                                                } else {
                                                    $story_user_photo = base_url('assets/theme/v1/social-app/assets/images/profile/p3.png');
                                                }
                                            } else {
                                                $story_user_photo = base_url('assets/theme/v1/social-app/assets/images/profile/p3.png');
                                            }
                                            ?>
                                            <img src="<?= $story_user_photo ?>" alt="<?= htmlspecialchars($user_story['user_name']) ?>" class="story-profile-img">
                                            <?php if ($user_story['has_unviewed']): ?>
                                                <span class="unviewed-indicator"></span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <p class="story-label"><?= htmlspecialchars($user_story['user_name']) ?></p>
                                </div>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </section>

        <!-- Used Templates Section - Grid Format (Templates in rows) -->
        <section class="collections-section">
            <div class="custom-container">
                <div class="title">
                    <h3>Used Templates</h3>
                    <a href="<?= base_url('collections') ?>">See All</a>
                </div>
            </div>
            <!-- Used Templates Grid - Professional Grid Layout -->
            <?php if (isset($used_templates) && !empty($used_templates)): 
                $total_templates = (int) count($used_templates);
                $initial_show = 4; // Show first 4 templates (1 row)
                $show_view_more = ($total_templates > $initial_show);
            ?>
                <div class="custom-container">
                    <div class="used-templates-grid" id="usedTemplatesGrid">
                        <?php foreach ($used_templates as $index => $template): 
                            $is_hidden = ($index >= $initial_show) ? 'template-item-hidden' : '';
                        ?>
                            <a href="<?= base_url('generate-image/' . $template['temp_id']) ?>" class="used-template-item <?= $is_hidden ?>">
                                <div class="used-template-image-wrapper">
                                    <?php 
                                    // Show GENERATED IMAGE (what user actually created)
                                    if (!empty($template['latest_gen_image']) && !empty($template['latest_gen_user_id'])): 
                                        $gen_image_path = 'assets/ai/uploads/generated/' . $template['latest_gen_user_id'] . '/' . $template['latest_gen_image'];
                                        $gen_image_url = base_url($gen_image_path);
                                    ?>
                                        <img src="<?= $gen_image_url ?>"
                                            alt="<?= htmlspecialchars($template['temp_name']) ?> - Generated Preview"
                                            class="used-template-image"
                                            onerror="this.src='<?= base_url('assets/ai/uploads/templates/' . $template['temp_image']) ?>'">
                                    <?php elseif (!empty($template['temp_image'])): ?>
                                        <img src="<?= base_url('assets/ai/uploads/templates/' . $template['temp_image']) ?>"
                                            alt="<?= htmlspecialchars($template['temp_name']) ?>"
                                            class="used-template-image"
                                            onerror="this.src='<?= base_url('assets/theme/v1/social-app/assets/images/profile/p3.png') ?>'">
                                    <?php elseif (!empty($template['coll_cover_image'])): ?>
                                        <img src="<?= base_url('assets/ai/uploads/collections/' . $template['coll_cover_image']) ?>"
                                            alt="<?= htmlspecialchars($template['temp_name']) ?>"
                                            class="used-template-image"
                                            onerror="this.src='<?= base_url('assets/theme/v1/social-app/assets/images/profile/p3.png') ?>'">
                                    <?php else: ?>
                                        <img src="<?= base_url('assets/theme/v1/social-app/assets/images/profile/p3.png') ?>"
                                            alt="Default Template Image"
                                            class="used-template-image">
                                    <?php endif; ?>
                                    
                                    <!-- Template Info Overlay -->
                                    <div class="used-template-info">
                                        <h4 class="used-template-name"><?= htmlspecialchars($template['temp_name']) ?></h4>
                                        <?php if (!empty($template['coll_name'])): ?>
                                            <p class="used-template-collection"><?= htmlspecialchars($template['coll_name']) ?></p>
                                        <?php endif; ?>
                                        <?php 
                                        $usage_count = isset($template['total_usage_count']) ? $template['total_usage_count'] : (isset($template['usage_count']) ? $template['usage_count'] : 0);
                                        if ($usage_count > 0): ?>
                                            <p class="used-template-usage">Used <?= $usage_count ?> time<?= $usage_count > 1 ? 's' : '' ?> by all users</p>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </a>
                        <?php endforeach; ?>
                    </div>
                    
                    <!-- View More / Show Less Buttons -->
                    <?php if (isset($show_view_more) && $show_view_more === true): ?>
                        <div class="text-center" style="margin-top: 25px;">
                            <button id="viewMoreTemplatesBtn" class="view-more-templates-btn">
                                View More Templates
                                <i class="iconsax" data-icon="arrow-down-1" style="margin-left: 8px; font-size: 16px;"></i>
                            </button>
                            <button id="showLessTemplatesBtn" class="show-less-templates-btn" style="display: none;">
                                Show Less
                                <i class="iconsax" data-icon="arrow-up-1" style="margin-left: 8px; font-size: 16px;"></i>
                            </button>
                        </div>
                    <?php endif; ?>
                </div>
            <?php else: ?>
                <div class="col-12">
                    <div class="text-center py-4" style="color: #999;">
                        <p>No templates used yet. Generate an image to see your used templates here.</p>
                    </div>
                </div>
            <?php endif; ?>
        </section>

        <!-- Collections Section - New Layout: Collection with Templates Grid -->
        <?php if (isset($collections) && !empty($collections) && is_array($collections) && count($collections) > 0): ?>
            <?php foreach ($collections as $collection): ?>
                <?php if (!empty($collection['templates']) && is_array($collection['templates']) && count($collection['templates']) > 0): ?>
                <section class="collection-with-templates-section" style="padding: 20px 0;">
                    <div class="custom-container">
                        <!-- Collection Header -->
                        <div class="collection-header" style="margin-bottom: 15px;">
                            <a href="<?= base_url('collection-detail/' . $collection['coll_id']) ?>" style="text-decoration: none; color: inherit; display: flex; align-items: center; cursor: pointer;">
                                <h3 class="collection-title" style="font-size: 20px; font-weight: 600; color: #333; margin: 0; transition: color 0.2s;">
                                    <?= htmlspecialchars($collection['coll_name']) ?>
                                </h3>
                                <?php if (!empty($collection['template_count'])): ?>
                                    <span class="template-count" style="font-size: 14px; color: #666; margin-left: 10px;">
                                        (<?= $collection['template_count'] ?> templates)
                                    </span>
                                <?php endif; ?>
                            </a>
                        </div>
                        
                        <!-- Templates Slider - Horizontal Scroll -->
                        <?php if (!empty($collection['templates']) && is_array($collection['templates']) && count($collection['templates']) > 0): ?>
                            <div class="templates-slider-wrapper" style="margin-top: 15px;">
                                <div class="templates-slider-scroll" style="display: flex; overflow-x: auto; overflow-y: hidden; gap: 12px; padding: 5px 0; -webkit-overflow-scrolling: touch; scrollbar-width: thin;">
                                    <?php foreach ($collection['templates'] as $template): ?>
                                        <a href="<?= base_url('generate-image/' . $template['temp_id']) ?>" class="template-slider-item" style="display: block; text-decoration: none; color: inherit; flex-shrink: 0; width: 100px;">
                                            <div class="template-slider-box" style="position: relative; width: 100px; height: 100px; border-radius: 12px; overflow: visible; box-shadow: 0 2px 8px rgba(0,0,0,0.1); transition: transform 0.2s, box-shadow 0.2s; background: #fff; border: 3px solid #ffc107; padding: 4px; margin-bottom: 8px;">
                                                <div style="width: 100%; height: 100%; border-radius: 8px; overflow: hidden;">
                                                    <?php if (!empty($template['temp_image'])): ?>
                                                        <img src="<?= base_url('assets/ai/uploads/templates/' . $template['temp_image']) ?>" 
                                                             alt="<?= htmlspecialchars($template['temp_name']) ?>"
                                                             style="width: 100%; height: 100%; object-fit: cover;"
                                                             onerror="this.src='<?= base_url('assets/theme/v1/social-app/assets/images/profile/p3.png') ?>'">
                                                    <?php else: ?>
                                                        <img src="<?= base_url('assets/theme/v1/social-app/assets/images/profile/p3.png') ?>" 
                                                             alt="Template Image"
                                                             style="width: 100%; height: 100%; object-fit: cover;">
                                                    <?php endif; ?>
                                                    
                                                    <!-- Template Name Overlay (shown on hover) -->
                                                    <div class="template-overlay">
                                                        <p><?= htmlspecialchars($template['temp_name']) ?></p>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- Template Name Below Image -->
                                            <div class="template-name-below" style="width: 100px; text-align: center; margin-top: 4px;">
                                                <p style="margin: 0; font-size: 12px; color: #333; font-weight: 500; display: flex; align-items: center; justify-content: center; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;">
                                                    <span style="display: inline-block; width: 8px; height: 8px; background: #28a745; border-radius: 50%; margin-right: 6px; flex-shrink: 0;"></span>
                                                    <span style="overflow: hidden; text-overflow: ellipsis; white-space: nowrap;"><?= htmlspecialchars($template['temp_name']) ?></span>
                                                </p>
                                            </div>
                                        </a>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </section>
                <?php endif; ?>
            <?php endforeach; ?>
        <?php endif; ?>
        
        <!-- Collections Banner Section -->
        <?php if (isset($collections) && !empty($collections) && is_array($collections) && count($collections) > 0): ?>
        <section class="collections-banner-section" style="padding: 20px 0; background: #f8f9fa; margin-top: 30px;">
            <div class="custom-container" style="padding: 0;">
                <div class="collections-banner-scroll" style="display: flex; overflow-x: auto; overflow-y: hidden; gap: 0; -webkit-overflow-scrolling: touch; scrollbar-width: none;">
                    <?php foreach ($collections as $collection): ?>
                        <?php if (!empty($collection['templates']) && is_array($collection['templates']) && count($collection['templates']) > 0): ?>
                        <a href="<?= base_url('collection-detail/' . $collection['coll_id']) ?>" class="collection-banner-item" style="flex-shrink: 0; text-decoration: none; color: inherit; position: relative; display: block; width: 100vw; max-width: 100%;">
                            <!-- Collection Image - Full Width -->
                            <?php if (!empty($collection['coll_cover_image'])): ?>
                                <img src="<?= base_url('assets/ai/uploads/collections/' . $collection['coll_cover_image']) ?>" 
                                     alt="<?= htmlspecialchars($collection['coll_name']) ?>"
                                     style="width: 100%; height: 200px; object-fit: cover; display: block;"
                                     onerror="this.src='<?= base_url('assets/theme/v1/social-app/assets/images/profile/p3.png') ?>'">
                            <?php else: ?>
                                <div style="width: 100%; height: 200px; background: linear-gradient(135deg, #dc3545 0%, #c82333 100%); display: flex; align-items: center; justify-content: center;">
                                    <i class="iconsax" data-icon="gallery" style="font-size: 60px; color: #fff;"></i>
                                </div>
                            <?php endif; ?>
                            
                            <!-- Collection Name Overlay -->
                            <div style="position: absolute; bottom: 0; left: 0; right: 0; background: linear-gradient(to top, rgba(0,0,0,0.7), transparent); padding: 15px 20px;">
                                <p style="font-size: 16px; font-weight: 700; color: #fff; margin: 0; text-shadow: 2px 2px 4px rgba(0,0,0,0.5);">
                                    <?= htmlspecialchars($collection['coll_name']) ?>
                                </p>
                            </div>
                        </a>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        
        <style>
        .collections-banner-scroll {
            -ms-overflow-style: none;
            scrollbar-width: none;
        }
        .collections-banner-scroll::-webkit-scrollbar {
            display: none;
        }
        .collection-banner-item {
            transition: transform 0.3s;
        }
        .collection-banner-item:active {
            transform: scale(0.98);
        }
        </style>
        <?php endif; ?>
        
        <!-- Add margin before footer -->
        <div style="margin-bottom: 60px; padding-bottom: 20px;"></div>
    </div>

    <!-- MESSAGE Tab -->
    <!-- <div class="tab-pane fade" id="message" role="tabpanel">
        <section class="messages-section">
            <div class="custom-container">
                <h3 class="section-title">Messages</h3>
                <p class="text-muted">Messages feature coming soon...</p>
            </div>
        </section>
    </div> -->

    <!-- FEED Tab -->
    <!-- <div class="tab-pane fade" id="feed" role="tabpanel">
        <section class="feed-section">
            <div class="custom-container">
                <h3 class="section-title">Feed</h3>
                <p class="text-muted">Feed content coming soon...</p>
            </div>
        </section>
    </div> -->
</div>

<!-- Story Upload Modal -->
<div class="modal fade" id="storyUploadModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Add Story</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form id="storyUploadForm" enctype="multipart/form-data">
                    <div class="form-group">
                        <label>Select Image</label>
                        <input type="file" class="form-control" id="storyImage" name="story_image" accept="image/*" required>
                    </div>
                    <div class="form-group mt-3">
                        <label>Text (Optional)</label>
                        <textarea class="form-control" id="storyText" name="story_text" rows="3" placeholder="Add text to your story..."></textarea>
                    </div>
                    <button type="submit" class="btn btn-primary w-100 mt-3">Upload Story</button>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Story Viewer Modal - Instagram/WhatsApp Style -->
<div class="modal fade" id="storyViewerModal" tabindex="-1" aria-hidden="true" data-bs-backdrop="static">
    <div class="modal-dialog modal-fullscreen">
        <div class="modal-content story-viewer">
            <!-- Story Progress Bars -->
            <div class="story-progress-container" id="storyProgressContainer">
                <!-- Progress bars will be dynamically added here -->
            </div>

            <!-- Story Header (User Info) -->
            <div class="story-viewer-header" id="storyViewerHeader">
                <div class="story-user-info">
                    <div class="story-user-avatar" id="storyUserAvatar"></div>
                    <div class="story-user-details">
                        <h5 id="storyUserName"></h5>
                        <span id="storyTime"></span>
                    </div>
                </div>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" onclick="closeStoryViewer()"></button>
            </div>

            <!-- Story Content Area -->
            <div class="story-viewer-content" id="storyViewerContent">
                <!-- Stories will be displayed here -->
            </div>

            <!-- Navigation Areas (Left/Right for swipe) -->
            <div class="story-nav-left" onclick="previousStory()"></div>
            <div class="story-nav-right" onclick="nextStory()"></div>

            <!-- Story Counter -->
            <div class="story-counter" id="storyCounter">1 / 1</div>
        </div>
    </div>
</div>

<style>
    /* Tabs Navigation */
    .tabs-navigation-section {
        background: #fff;
        border-bottom: 1px solid #e0e0e0;
        padding: 15px 0;
        position: sticky;
        top: 0;
        z-index: 100;
    }

    .instagram-tabs {
        border: none;
        justify-content: center;
        gap: 20px;
    }

    .instagram-tabs .nav-link {
        border: none;
        color: #666;
        font-weight: 600;
        font-size: 14px;
        padding: 8px 20px;
        background: transparent;
        position: relative;
    }

    .instagram-tabs .nav-link.active {
        color: #ffc107;
        background: transparent;
    }

    .instagram-tabs .nav-link.active::after {
        content: '';
        position: absolute;
        bottom: -15px;
        left: 0;
        right: 0;
        height: 3px;
        background: #ffc107;
        border-radius: 3px 3px 0 0;
    }

    /* Stories Section */
    .stories-section {
        padding: 20px 0;
        background: #fff;
        border-top: 3px solid #ffc107;
        border-bottom: 1px solid #e0e0e0;
    }

    .stories-title {
        font-size: 16px;
        font-weight: 600;
        margin-bottom: 15px;
        padding: 0 15px;
    }

    .stories-container {
        overflow-x: auto;
        -webkit-overflow-scrolling: touch;
    }

    .stories-scroll {
        display: flex;
        gap: 15px;
        padding: 0 15px;
        min-width: max-content;
    }

    .story-item {
        text-align: center;
        min-width: 70px;
        cursor: pointer;
    }

    .story-circle {
        width: 70px;
        height: 70px;
        border-radius: 50%;
        padding: 3px;
        background: linear-gradient(45deg, #f09433 0%, #e6683c 25%, #dc2743 50%, #cc2366 75%, #bc1888 100%);
        margin: 0 auto 8px;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .story-circle.unviewed {
        background: linear-gradient(45deg, #f09433 0%, #e6683c 25%, #dc2743 50%, #cc2366 75%, #bc1888 100%);
    }

    /* Your Story - Gray border instead of gradient */
    .add-story-circle {
        background: #e0e0e0 !important;
        padding: 2px;
    }

    .story-image-wrapper {
        width: 64px;
        height: 64px;
        border-radius: 50%;
        overflow: hidden;
        background: #fff;
        display: flex;
        align-items: center;
        justify-content: center;
        position: relative;
    }

    .story-profile-img {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }

    .add-story-icon {
        position: absolute;
        bottom: -1px;
        right: -1px;
        width: 20px;
        height: 20px;
        background: #ffc107;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        border: 2.5px solid #fff;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.15);
        z-index: 10;
    }

    .add-story-icon i {
        color: #000;
        font-size: 11px;
        font-weight: bold;
        line-height: 1;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .unviewed-indicator {
        position: absolute;
        top: -2px;
        right: -2px;
        width: 12px;
        height: 12px;
        background: #dc2743;
        border-radius: 50%;
        border: 2px solid #fff;
    }

    .story-label {
        font-size: 12px;
        color: #666;
        margin: 0;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
        max-width: 70px;
    }

    /* Used Templates Grid Styles */
    .used-templates-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
        gap: 20px;
        padding: 0 0 20px 0;
        margin-top: 0;
        align-items: start;
    }
    
    .used-template-item {
        display: flex;
        flex-direction: column;
        text-decoration: none;
        color: inherit;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        border-radius: 12px;
        overflow: hidden;
        background: #fff;
        box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        height: 100%;
    }
    
    .used-template-item:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 20px rgba(0,0,0,0.15);
    }
    
    .used-template-image-wrapper {
        position: relative;
        width: 100%;
        background: #f5f5f5;
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 15px;
        min-height: 250px;
        max-height: 350px;
        aspect-ratio: 1 / 1;
        overflow: hidden;
    }
    
    .used-template-image {
        width: 100%;
        height: 100%;
        object-fit: contain;
        object-position: center;
        display: block;
        border-radius: 8px;
    }
    
    .used-template-info {
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        background: linear-gradient(to top, rgba(0,0,0,0.9), rgba(0,0,0,0.7), transparent);
        padding: 15px 12px 12px;
        color: #fff;
        z-index: 10;
        pointer-events: none;
    }
    
    .used-template-name {
        font-size: 16px;
        font-weight: 700;
        margin: 0 0 4px 0;
        color: #fff;
        text-shadow: 2px 2px 4px rgba(0,0,0,0.9);
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }
    
    .used-template-collection {
        font-size: 12px;
        color: #e0e0e0;
        margin: 0 0 3px 0;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }
    
    .used-template-usage {
        font-size: 11px;
        color: #ccc;
        margin: 0;
    }
    
    /* Hide templates beyond initial display */
    .template-item-hidden {
        display: none !important;
    }
    
    /* View More Button Styles */
    .view-more-templates-btn {
        background: linear-gradient(135deg, #ffc107 0%, #ff9800 100%);
        color: #000;
        border: none;
        padding: 12px 30px;
        border-radius: 25px;
        font-size: 16px;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
        box-shadow: 0 4px 15px rgba(255, 193, 7, 0.3);
        display: inline-flex;
        align-items: center;
        justify-content: center;
    }
    
    .view-more-templates-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(255, 193, 7, 0.4);
        background: linear-gradient(135deg, #ffb300 0%, #f57c00 100%);
    }
    
    .view-more-templates-btn:active {
        transform: translateY(0);
    }
    
    /* Show Less Button Styles */
    .show-less-templates-btn {
        background: linear-gradient(135deg, #6c757d 0%, #495057 100%);
        color: #fff;
        border: none;
        padding: 12px 30px;
        border-radius: 25px;
        font-size: 16px;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
        box-shadow: 0 4px 15px rgba(108, 117, 125, 0.3);
        display: inline-flex;
        align-items: center;
        justify-content: center;
    }
    
    .show-less-templates-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(108, 117, 125, 0.4);
        background: linear-gradient(135deg, #5a6268 0%, #3d4146 100%);
    }
    
    .show-less-templates-btn:active {
        transform: translateY(0);
    }
    
    /* Fade in animation for templates */
    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(20px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
    
    /* Fade out animation for templates */
    @keyframes fadeOut {
        from {
            opacity: 1;
            transform: translateY(0);
        }
        to {
            opacity: 0;
            transform: translateY(-20px);
        }
    }
    
    @media (max-width: 768px) {
        .used-templates-grid {
            grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
            gap: 15px;
            padding: 0 0 15px 0;
            align-items: start;
        }
        
        .used-template-image-wrapper {
            padding: 0px;
            min-height: 200px;
            max-height: 280px;
            aspect-ratio: 1 / 1;
        }
        
        .used-template-image {
            width: 100%;
            height: 100%;
            object-fit: contain;
        }
    }
    
    @media (max-width: 480px) {
        .used-templates-grid {
            grid-template-columns: repeat(auto-fill, minmax(150px, 1fr));
            gap: 12px;
            padding: 0 0 12px 0;
            align-items: start;
        }
        
        .used-template-image-wrapper {
            padding: 0px;
            min-height: 180px;
            max-height: 220px;
            aspect-ratio: 1 / 1;
        }
        
        .used-template-image {
            width: 100%;
            height: 100%;
            object-fit: contain;
        }
        
        .used-template-name {
            font-size: 14px;
        }
        
        .used-template-collection {
            font-size: 11px;
        }
        
        .used-template-usage {
            font-size: 10px;
        }
        
        .view-more-templates-btn,
        .show-less-templates-btn {
            padding: 10px 25px;
            font-size: 14px;
        }
    }

    /* Motivational Quote Section - Collections with Templates Slider */
    .motivational-quote-section {
        padding: 40px 0;
        background: linear-gradient(to bottom, #f8f9fa 0%, #ffffff 100%);
        margin-top: 30px;
        margin-bottom: 40px;
        border-top: 1px solid #e9ecef;
        border-bottom: 1px solid #e9ecef;
    }

    .motivational-title {
        color: #1a1a1a;
        font-size: 28px;
        font-weight: 800;
        margin-bottom: 30px;
        text-align: left;
        padding: 0 15px;
        letter-spacing: -0.5px;
        position: relative;
        display: inline-block;
    }

    .motivational-title::after {
        content: '';
        position: absolute;
        bottom: -8px;
        left: 15px;
        width: 60px;
        height: 4px;
        background: linear-gradient(90deg, #ffc107 0%, #ff9800 100%);
        border-radius: 2px;
    }

    /* Category Filters */
    .category-filters {
        margin-bottom: 35px;
        padding: 0 15px;
    }

    .category-filters-scroll {
        display: flex;
        align-items: center;
        gap: 25px;
        overflow-x: auto;
        scrollbar-width: thin;
        scrollbar-color: #ffc107 #f5f5f5;
        padding-bottom: 15px;
        padding-top: 5px;
    }

    .category-filters-scroll::-webkit-scrollbar {
        height: 6px;
    }

    .category-filters-scroll::-webkit-scrollbar-track {
        background: #f5f5f5;
        border-radius: 10px;
    }

    .category-filters-scroll::-webkit-scrollbar-thumb {
        background: linear-gradient(90deg, #ffc107 0%, #ff9800 100%);
        border-radius: 10px;
    }

    .category-filter-item {
        display: flex;
        flex-direction: column;
        align-items: center;
        gap: 12px;
        cursor: pointer;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        flex-shrink: 0;
        padding: 8px;
        border-radius: 16px;
    }

    .category-filter-item:hover {
        transform: translateY(-5px);
        background: rgba(255, 193, 7, 0.05);
    }

    .category-filter-item.active {
        background: rgba(255, 193, 7, 0.1);
    }

    .category-filter-item.active .category-label {
        color: #1a1a1a;
        font-weight: 700;
    }

    .category-circle {
        width: 80px;
        height: 80px;
        border-radius: 50%;
        border: 3px solid #e0e0e0;
        background: #ffffff;
        display: flex;
        align-items: center;
        justify-content: center;
        position: relative;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    }

    .category-circle:hover {
        box-shadow: 0 4px 16px rgba(255, 193, 7, 0.2);
        transform: scale(1.05);
    }

    .category-circle.active {
        background: linear-gradient(135deg, #ffc107 0%, #ff9800 100%);
        border-color: #ffc107;
        box-shadow: 0 4px 20px rgba(255, 193, 7, 0.4);
        transform: scale(1.08);
    }

    .category-circle-inner {
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        text-align: center;
        padding: 8px;
    }

    .category-text-small {
        font-size: 11px;
        font-weight: 800;
        color: #666;
        line-height: 1.2;
        letter-spacing: 0.5px;
    }

    .category-circle.active .category-text-small {
        color: #ffffff;
        text-shadow: 0 1px 2px rgba(0, 0, 0, 0.1);
    }

    .category-text-tiny {
        font-size: 9px;
        font-weight: 600;
        color: #999;
        line-height: 1.2;
        margin-top: 3px;
        letter-spacing: 0.3px;
    }

    .category-circle.active .category-text-tiny {
        color: #ffffff;
        text-shadow: 0 1px 2px rgba(0, 0, 0, 0.1);
    }

    .category-label {
        font-size: 13px;
        color: #666;
        white-space: nowrap;
        text-align: center;
        max-width: 90px;
        overflow: hidden;
        text-overflow: ellipsis;
        transition: all 0.3s ease;
        font-weight: 500;
    }

    .category-filter-item:hover .category-label {
        color: #333;
    }

    .category-scroll-indicator {
        width: 36px;
        height: 36px;
        border-radius: 50%;
        border: 2px solid #e0e0e0;
        display: flex;
        align-items: center;
        justify-content: center;
        color: #999;
        flex-shrink: 0;
        margin-left: 15px;
        background: #fff;
        transition: all 0.3s ease;
    }

    .category-scroll-indicator:hover {
        border-color: #ffc107;
        color: #ffc107;
        background: rgba(255, 193, 7, 0.05);
    }

    /* Templates Slider */
    .collection-templates-slider {
        padding: 0 15px;
    }

    .templates-slider-container {
        display: flex;
        gap: 15px;
        overflow-x: auto;
        scrollbar-width: thin;
        scrollbar-color: #ccc #f5f5f5;
        padding-bottom: 10px;
        -webkit-overflow-scrolling: touch;
    }

    .templates-slider-container::-webkit-scrollbar {
        height: 6px;
    }

    .templates-slider-container::-webkit-scrollbar-track {
        background: #f5f5f5;
        border-radius: 3px;
    }

    .templates-slider-container::-webkit-scrollbar-thumb {
        background: #ccc;
        border-radius: 3px;
    }

    .template-card-slide {
        min-width: 300px;
        max-width: 300px;
        flex-shrink: 0;
    }

    @media (max-width: 768px) {
        .motivational-quote-section {
            padding: 30px 0;
        }

        .motivational-title {
            font-size: 24px;
            margin-bottom: 25px;
        }

        .category-circle {
            width: 70px;
            height: 70px;
        }

        .category-text-small {
            font-size: 10px;
        }

        .category-text-tiny {
            font-size: 8px;
        }

        .category-label {
            font-size: 12px;
            max-width: 75px;
        }

        .template-card-slide {
            min-width: 260px;
            max-width: 260px;
        }

        .template-card-content {
            height: 170px;
        }

        .template-text-side {
            padding: 18px;
        }

        .template-text-title {
            font-size: 18px;
        }

        .template-text-desc {
            font-size: 12px;
        }
    }

    @media (max-width: 480px) {
        .motivational-title {
            font-size: 22px;
        }

        .category-circle {
            width: 65px;
            height: 65px;
        }

        .template-card-slide {
            min-width: 240px;
            max-width: 240px;
        }

        .template-card-content {
            height: 160px;
        }
    }

    .template-card-link {
        display: block;
        text-decoration: none;
        color: inherit;
    }

    .template-card-content {
        display: flex;
        height: 200px;
        border-radius: 16px;
        overflow: hidden;
        box-shadow: 0 8px 24px rgba(0,0,0,0.12);
        position: relative;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        border: 1px solid rgba(0,0,0,0.05);
    }

    .template-card-link:hover .template-card-content {
        transform: translateY(-4px);
        box-shadow: 0 12px 32px rgba(0,0,0,0.18);
    }

    .template-text-side {
        flex: 1;
        background: linear-gradient(135deg, #ff6b35 0%, #f7931e 100%);
        padding: 24px;
        display: flex;
        align-items: center;
        justify-content: center;
        position: relative;
        overflow: hidden;
    }

    .template-text-side::before {
        content: '';
        position: absolute;
        top: -50%;
        right: -50%;
        width: 100%;
        height: 100%;
        background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, transparent 70%);
        pointer-events: none;
    }

    /* Different colors for different templates */
    .template-card-slide:nth-child(2) .template-text-side {
        background: linear-gradient(135deg, #e91e63 0%, #ad1457 100%);
    }

    .template-card-slide:nth-child(3) .template-text-side {
        background: linear-gradient(135deg, #1e88e5 0%, #1565c0 100%);
    }

    .template-card-slide:nth-child(4) .template-text-side {
        background: linear-gradient(135deg, #2196f3 0%, #0d47a1 100%);
    }

    .template-text-content {
        color: #fff;
        text-align: left;
    }

    .template-text-title {
        font-size: 20px;
        font-weight: 800;
        margin: 0 0 10px 0;
        color: #fff;
        line-height: 1.3;
        text-shadow: 0 2px 4px rgba(0,0,0,0.2);
        letter-spacing: -0.3px;
    }

    .template-text-desc {
        font-size: 13px;
        margin: 0;
        color: rgba(255,255,255,0.95);
        line-height: 1.5;
        text-shadow: 0 1px 2px rgba(0,0,0,0.15);
    }

    .template-image-side {
        width: 45%;
        background: linear-gradient(135deg, #2c3e50 0%, #1a252f 100%);
        display: flex;
        align-items: center;
        justify-content: center;
        position: relative;
        overflow: hidden;
    }

    .template-person-image {
        width: 100%;
        height: 100%;
        object-fit: cover;
        object-position: center;
    }

    .no-templates-message {
        text-align: center;
        padding: 40px 20px;
        color: #999;
    }

    /* Collections Section */
    .collections-section {
        padding: 20px 0;
        overflow-x: hidden;
    }
    
    .collections-section .custom-container {
        padding-left: 8px;
        padding-right: 8px;
    }

    .collection-card {
        display: block;
        text-decoration: none;
        color: inherit;
    }

    .collection-image-wrapper {
        position: relative;
        border-radius: 12px;
        overflow: hidden;
        aspect-ratio: 1;
        margin-bottom: 10px;
    }

    .collection-image {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }

    .trending-badge {
        position: absolute;
        top: 10px;
        right: 10px;
        background: #ffc107;
        color: #000;
        padding: 4px 8px;
        border-radius: 12px;
        font-size: 10px;
        font-weight: 600;
    }

    .collection-info {
        text-align: center;
    }

    .collection-name {
        font-size: 14px;
        font-weight: 600;
        margin: 0 0 5px 0;
        color: #333;
    }

    .template-count {
        font-size: 12px;
        color: #999;
        margin: 0;
    }


    /* Story Viewer - Instagram/WhatsApp Style */
    .story-viewer {
        background: #000;
        position: relative;
        overflow: hidden;
    }

    /* Progress Bars Container */
    .story-progress-container {
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        padding: 10px 15px;
        display: flex;
        gap: 4px;
        z-index: 100;
        background: rgba(0, 0, 0, 0.3);
    }

    .story-progress-bar {
        flex: 1;
        height: 3px;
        background: rgba(255, 255, 255, 0.3);
        border-radius: 2px;
        overflow: hidden;
        position: relative;
    }

    .story-progress-bar.active .story-progress-fill {
        animation: storyProgress linear forwards;
    }

    .story-progress-fill {
        height: 100%;
        background: #fff;
        width: 0%;
        border-radius: 2px;
    }

    .story-progress-bar.viewed .story-progress-fill {
        width: 100%;
    }

    @keyframes storyProgress {
        from {
            width: 0%;
        }

        to {
            width: 100%;
        }
    }

    /* Story Viewer Header */
    .story-viewer-header {
        position: absolute;
        top: 50px;
        left: 0;
        right: 0;
        padding: 15px 20px;
        z-index: 100;
        display: flex;
        justify-content: space-between;
        align-items: center;
        background: linear-gradient(to bottom, rgba(0, 0, 0, 0.5) 0%, transparent 100%);
    }

    .story-user-info {
        display: flex;
        align-items: center;
        gap: 12px;
    }

    .story-user-avatar {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        overflow: hidden;
        border: 2px solid #fff;
    }

    .story-user-avatar img {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }

    .story-user-details h5 {
        color: #fff;
        font-size: 14px;
        font-weight: 600;
        margin: 0;
    }

    .story-user-details span {
        color: rgba(255, 255, 255, 0.8);
        font-size: 12px;
    }

    .btn-close-white {
        filter: invert(1);
        opacity: 0.9;
    }

    /* Story Content */
    .story-viewer-content {
        height: 100vh;
        width: 100%;
        position: relative;
        display: flex;
        align-items: center;
        justify-content: center;
        overflow: hidden;
    }

    .story-slide {
        position: absolute;
        width: 100%;
        height: 100%;
        display: none;
        align-items: center;
        justify-content: center;
    }

    .story-slide.active {
        display: flex;
    }

    .story-slide img {
        width: 100%;
        height: 100%;
        object-fit: contain;
    }

    .story-text-overlay {
        position: absolute;
        bottom: 100px;
        left: 50%;
        transform: translateX(-50%);
        background: rgba(0, 0, 0, 0.6);
        color: #fff;
        padding: 15px 20px;
        border-radius: 8px;
        max-width: 80%;
        text-align: center;
        font-size: 16px;
    }

    /* Navigation Areas */
    .story-nav-left,
    .story-nav-right {
        position: absolute;
        top: 0;
        bottom: 0;
        width: 30%;
        z-index: 50;
        cursor: pointer;
    }

    .story-nav-left {
        left: 0;
    }

    .story-nav-right {
        right: 0;
    }

    /* Story Counter */
    .story-counter {
        position: absolute;
        bottom: 20px;
        right: 20px;
        background: rgba(0, 0, 0, 0.6);
        color: #fff;
        padding: 8px 15px;
        border-radius: 20px;
        font-size: 12px;
        z-index: 100;
    }
</style>

<script>
    function openStoryUpload() {
        const modal = new bootstrap.Modal(document.getElementById('storyUploadModal'));
        modal.show();
    }

    let currentStories = [];
    let currentStoryIndex = 0;
    let storyProgressInterval = null;
    let storyDuration = 5000; // 5 seconds per story
    let isPaused = false;

    function viewStory(userId) {
        // Load and display stories for this user
        $.ajax({
            url: '<?= base_url('index.php/action/get_user_stories') ?>',
            type: 'POST',
            data: {
                user_id: userId
            },
            success: function(response) {
                try {
                    const stories = typeof response === 'string' ? JSON.parse(response) : response;
                    if (stories && stories.length > 0) {
                        currentStories = stories;
                        currentStoryIndex = 0;
                        displayStories(stories, userId);

                        // Mark stories as viewed
                        $.ajax({
                            url: '<?= base_url('index.php/action/mark_story_viewed') ?>',
                            type: 'POST',
                            data: {
                                user_id: userId
                            }
                        });
                    } else {
                        alert('No stories available');
                    }
                } catch (e) {
                    console.error('Error loading stories:', e);
                    alert('Error loading stories');
                }
            },
            error: function() {
                alert('Error loading stories');
            }
        });
    }

    function displayStories(stories, userId) {
        const progressContainer = document.getElementById('storyProgressContainer');
        const viewerContent = document.getElementById('storyViewerContent');
        const userName = document.getElementById('storyUserName');
        const userAvatar = document.getElementById('storyUserAvatar');
        const storyCounter = document.getElementById('storyCounter');

        // Get user info from the clicked story
        const firstStory = stories[0];

        // Create progress bars
        progressContainer.innerHTML = '';
        stories.forEach((story, index) => {
            const progressBar = document.createElement('div');
            progressBar.className = 'story-progress-bar';
            if (index === 0) progressBar.classList.add('active');
            progressBar.innerHTML = '<div class="story-progress-fill"></div>';
            progressContainer.appendChild(progressBar);
        });

        // Create story slides
        viewerContent.innerHTML = '';
        stories.forEach((story, index) => {
            const slide = document.createElement('div');
            slide.className = `story-slide ${index === 0 ? 'active' : ''}`;
            slide.innerHTML = `
            <img src="${story.image_url}" alt="Story" onload="startStoryProgress()">
            ${story.story_text ? `<div class="story-text-overlay">${story.story_text}</div>` : ''}
        `;
            viewerContent.appendChild(slide);
        });

        // Update user info
        userName.textContent = firstStory.user_name || 'User';
        if (firstStory.user_photo) {
            userAvatar.innerHTML = `<img src="${firstStory.user_photo}" alt="User">`;
        }

        // Update counter
        storyCounter.textContent = `${currentStoryIndex + 1} / ${stories.length}`;

        // Show modal
        const modal = new bootstrap.Modal(document.getElementById('storyViewerModal'));
        modal.show();

        // Start progress for first story
        setTimeout(() => {
            startStoryProgress();
        }, 500);
    }

    function startStoryProgress() {
        if (storyProgressInterval) {
            clearInterval(storyProgressInterval);
        }

        if (isPaused) return;

        const progressBars = document.querySelectorAll('.story-progress-bar');
        const currentBar = progressBars[currentStoryIndex];

        if (!currentBar) return;

        const progressFill = currentBar.querySelector('.story-progress-fill');
        if (!progressFill) return;

        // Reset progress
        progressFill.style.width = '0%';
        currentBar.classList.add('active');

        // Animate progress
        let progress = 0;
        const interval = 50; // Update every 50ms
        const increment = (100 / storyDuration) * interval;

        storyProgressInterval = setInterval(() => {
            if (isPaused) return;

            progress += increment;
            if (progress >= 100) {
                progress = 100;
                clearInterval(storyProgressInterval);
                nextStory();
            } else {
                progressFill.style.width = progress + '%';
            }
        }, interval);
    }

    function nextStory() {
        if (currentStoryIndex < currentStories.length - 1) {
            // Mark current as viewed
            const currentBar = document.querySelectorAll('.story-progress-bar')[currentStoryIndex];
            if (currentBar) {
                currentBar.classList.remove('active');
                currentBar.classList.add('viewed');
                currentBar.querySelector('.story-progress-fill').style.width = '100%';
            }

            // Hide current slide
            const currentSlide = document.querySelectorAll('.story-slide')[currentStoryIndex];
            if (currentSlide) currentSlide.classList.remove('active');

            // Show next slide
            currentStoryIndex++;
            const nextSlide = document.querySelectorAll('.story-slide')[currentStoryIndex];
            if (nextSlide) nextSlide.classList.add('active');

            // Update counter
            document.getElementById('storyCounter').textContent = `${currentStoryIndex + 1} / ${currentStories.length}`;

            // Start progress for next story
            startStoryProgress();
        } else {
            // All stories viewed, close modal
            closeStoryViewer();
        }
    }

    function previousStory() {
        if (currentStoryIndex > 0) {
            // Stop current progress
            if (storyProgressInterval) {
                clearInterval(storyProgressInterval);
            }

            // Mark current as not viewed
            const currentBar = document.querySelectorAll('.story-progress-bar')[currentStoryIndex];
            if (currentBar) {
                currentBar.classList.remove('active');
                currentBar.querySelector('.story-progress-fill').style.width = '0%';
            }

            // Hide current slide
            const currentSlide = document.querySelectorAll('.story-slide')[currentStoryIndex];
            if (currentSlide) currentSlide.classList.remove('active');

            // Show previous slide
            currentStoryIndex--;
            const prevSlide = document.querySelectorAll('.story-slide')[currentStoryIndex];
            if (prevSlide) prevSlide.classList.add('active');

            // Reset previous progress bar
            const prevBar = document.querySelectorAll('.story-progress-bar')[currentStoryIndex];
            if (prevBar) {
                prevBar.classList.remove('viewed');
                prevBar.querySelector('.story-progress-fill').style.width = '0%';
            }

            // Update counter
            document.getElementById('storyCounter').textContent = `${currentStoryIndex + 1} / ${currentStories.length}`;

            // Start progress for previous story
            startStoryProgress();
        }
    }

    function closeStoryViewer() {
        if (storyProgressInterval) {
            clearInterval(storyProgressInterval);
            storyProgressInterval = null;
        }
        isPaused = false;
        currentStories = [];
        currentStoryIndex = 0;

        const modal = bootstrap.Modal.getInstance(document.getElementById('storyViewerModal'));
        if (modal) {
            modal.hide();
        }
    }

    // Pause/Resume on click
    document.addEventListener('click', function(e) {
        if (document.getElementById('storyViewerModal').classList.contains('show')) {
            if (e.target.closest('.story-viewer-content')) {
                isPaused = !isPaused;
                if (isPaused) {
                    if (storyProgressInterval) clearInterval(storyProgressInterval);
                } else {
                    startStoryProgress();
                }
            }
        }
    });

    // Swipe navigation
    let touchStartX = 0;
    let touchEndX = 0;

    document.getElementById('storyViewerContent').addEventListener('touchstart', function(e) {
        touchStartX = e.changedTouches[0].screenX;
    });

    document.getElementById('storyViewerContent').addEventListener('touchend', function(e) {
        touchEndX = e.changedTouches[0].screenX;
        handleSwipe();
    });

    function handleSwipe() {
        const swipeThreshold = 50;
        const diff = touchStartX - touchEndX;

        if (Math.abs(diff) > swipeThreshold) {
            if (diff > 0) {
                // Swipe left - next story
                nextStory();
            } else {
                // Swipe right - previous story
                previousStory();
            }
        }
    }

    // Story Upload Form
    document.getElementById('storyUploadForm').addEventListener('submit', function(e) {
        e.preventDefault();
        const formData = new FormData(this);

        $.ajax({
            url: '<?= base_url('index.php/action/upload_story') ?>',
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                try {
                    const result = typeof response === 'string' ? JSON.parse(response) : response;
                    if (result.success) {
                        alert('Story uploaded successfully!');
                        location.reload();
                    } else {
                        alert(result.message || 'Failed to upload story');
                    }
                } catch (e) {
                    alert('Error uploading story');
                }
            },
            error: function() {
                alert('Error uploading story');
            }
        });
    });

    // Load templates for selected collection
    function loadCollectionTemplates(collId, element) {
        // Remove active class from all category filters
        document.querySelectorAll('.category-filter-item').forEach(item => {
            item.classList.remove('active');
        });
        document.querySelectorAll('.category-circle').forEach(circle => {
            circle.classList.remove('active');
        });
        
        // Add active class to clicked filter
        element.classList.add('active');
        element.querySelector('.category-circle').classList.add('active');
        
        // Show loading state
        const sliderContainer = document.getElementById('collectionTemplatesSlider');
        sliderContainer.innerHTML = '<div class="no-templates-message"><p>Loading templates...</p></div>';
        
        // AJAX call to get templates
        $.ajax({
            url: '<?= base_url('index.php/main/get_collection_templates') ?>',
            type: 'POST',
            data: { coll_id: collId },
            dataType: 'json',
            success: function(response) {
                if (response.success && response.templates && response.templates.length > 0) {
                    let html = '<div class="templates-slider-container">';
                    response.templates.forEach(function(template, index) {
                        html += `
                            <div class="template-card-slide">
                                <a href="<?= base_url('generate-image/') ?>${template.temp_id}" class="template-card-link">
                                    <div class="template-card-content">
                                        <div class="template-text-side" style="background: ${getColorForIndex(index)};">
                                            <div class="template-text-content">
                                                <h3 class="template-text-title">${template.temp_name || 'Template'}</h3>
                                                ${template.temp_description ? '<p class="template-text-desc">' + template.temp_description + '</p>' : ''}
                                            </div>
                                        </div>
                                        <div class="template-image-side">
                                            <img src="${template.temp_image_url || '<?= base_url('assets/theme/v1/social-app/assets/images/profile/p3.png') ?>'}" 
                                                 alt="${template.temp_name || 'Template'}"
                                                 class="template-person-image"
                                                 onerror="this.src='<?= base_url('assets/theme/v1/social-app/assets/images/profile/p3.png') ?>'">
                                        </div>
                                    </div>
                                </a>
                            </div>
                        `;
                    });
                    html += '</div>';
                    sliderContainer.innerHTML = html;
                } else {
                    sliderContainer.innerHTML = '<div class="no-templates-message"><p>No templates available for this collection.</p></div>';
                }
            },
            error: function() {
                sliderContainer.innerHTML = '<div class="no-templates-message"><p>Error loading templates. Please try again.</p></div>';
            }
        });
    }

    // Get color for template card based on index
    function getColorForIndex(index) {
        const colors = [
            'linear-gradient(135deg, #ff6b35 0%, #f7931e 100%)',
            'linear-gradient(135deg, #e91e63 0%, #ad1457 100%)',
            'linear-gradient(135deg, #1e88e5 0%, #1565c0 100%)',
            'linear-gradient(135deg, #2196f3 0%, #0d47a1 100%)'
        ];
        return colors[index % colors.length];
    }
    
    // View More / Show Less Templates Functionality
    document.addEventListener('DOMContentLoaded', function() {
        const viewMoreBtn = document.getElementById('viewMoreTemplatesBtn');
        const showLessBtn = document.getElementById('showLessTemplatesBtn');
        const initialShowCount = 4; // Number of templates to show initially
        
        if (viewMoreBtn) {
            viewMoreBtn.addEventListener('click', function() {
                const allTemplates = document.querySelectorAll('.used-template-item');
                const hiddenTemplates = document.querySelectorAll('.used-template-item.template-item-hidden');
                
                // Show all hidden templates with smooth animation
                hiddenTemplates.forEach(function(template, index) {
                    setTimeout(function() {
                        template.classList.remove('template-item-hidden');
                        template.style.opacity = '0';
                        template.style.animation = 'fadeInUp 0.4s ease forwards';
                    }, index * 50); // Stagger animation
                });
                
                // Hide "View More" button and show "Show Less" button
                setTimeout(function() {
                    viewMoreBtn.style.display = 'none';
                    if (showLessBtn) {
                        showLessBtn.style.display = 'inline-flex';
                    }
                }, hiddenTemplates.length * 50 + 400);
            });
        }
        
        if (showLessBtn) {
            showLessBtn.addEventListener('click', function() {
                const allTemplates = document.querySelectorAll('.used-template-item');
                
                // Hide templates beyond initial count with smooth animation
                allTemplates.forEach(function(template, index) {
                    if (index >= initialShowCount) {
                        setTimeout(function() {
                            template.style.animation = 'fadeOut 0.3s ease forwards';
                            setTimeout(function() {
                                template.classList.add('template-item-hidden');
                                template.style.animation = '';
                            }, 300);
                        }, (index - initialShowCount) * 30); // Stagger animation
                    }
                });
                
                // Hide "Show Less" button and show "View More" button
                setTimeout(function() {
                    showLessBtn.style.display = 'none';
                    if (viewMoreBtn) {
                        viewMoreBtn.style.display = 'inline-flex';
                    }
                    
                    // Scroll to top of templates section smoothly
                    const templatesGrid = document.getElementById('usedTemplatesGrid');
                    if (templatesGrid) {
                        templatesGrid.scrollIntoView({ behavior: 'smooth', block: 'start' });
                    }
                }, (allTemplates.length - initialShowCount) * 30 + 400);
            });
        }
    });
</script>

<style>
    /* Collection with Templates Section */
    .collection-with-templates-section {
        padding: 20px 0;
        border-bottom: 1px solid #f0f0f0;
    }
    
    .collection-with-templates-section:last-child {
        border-bottom: none;
        margin-bottom: 40px;
    }
    
    /* Tab Content - Add margin before footer */
    #homeTabsContent {
        margin-bottom: 60px;
        padding-bottom: 20px;
    }
    
    .collection-header {
        display: flex;
        align-items: center;
        margin-bottom: 15px;
    }
    
    .collection-header a {
        text-decoration: none;
        color: inherit;
        display: flex;
        align-items: center;
        cursor: pointer;
        transition: opacity 0.2s;
    }
    
    .collection-header a:hover {
        opacity: 0.7;
    }
    
    .collection-header a:hover .collection-title {
        color: #ffc107;
    }
    
    .collection-title {
        font-size: 20px;
        font-weight: 600;
        color: #333;
        margin: 0;
        transition: color 0.2s;
    }
    
    .template-count {
        font-size: 14px;
        color: #666;
        margin-left: 10px;
    }
    
    /* Templates Slider - Horizontal Scroll */
    .templates-slider-wrapper {
        margin-top: 15px;
    }
    
    .templates-slider-scroll {
        display: flex;
        overflow-x: auto;
        overflow-y: hidden;
        gap: 12px;
        padding: 5px 0;
        -webkit-overflow-scrolling: touch;
        scrollbar-width: thin;
        scrollbar-color: #ccc transparent;
    }
    
    .templates-slider-scroll::-webkit-scrollbar {
        height: 6px;
    }
    
    .templates-slider-scroll::-webkit-scrollbar-track {
        background: transparent;
    }
    
    .templates-slider-scroll::-webkit-scrollbar-thumb {
        background: #ccc;
        border-radius: 3px;
    }
    
    .templates-slider-scroll::-webkit-scrollbar-thumb:hover {
        background: #999;
    }
    
    .template-slider-item {
        display: block;
        text-decoration: none;
        color: inherit;
        flex-shrink: 0;
        width: 100px;
    }
    
    .template-name-below {
        width: 100px;
        text-align: center;
        margin-top: 4px;
    }
    
    .template-name-below p {
        margin: 0;
        font-size: 12px;
        color: #333;
        font-weight: 500;
        display: flex;
        align-items: center;
        justify-content: center;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }
    
    .template-name-below .green-dot {
        display: inline-block;
        width: 8px;
        height: 8px;
        background: #28a745;
        border-radius: 50%;
        margin-right: 6px;
        flex-shrink: 0;
    }
    
    .template-name-below .template-name-text {
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
    }
    
    .template-slider-box {
        position: relative;
        width: 100px;
        height: 100px;
        border-radius: 12px;
        overflow: visible;
        box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        transition: transform 0.2s, box-shadow 0.2s;
        background: #fff;
        border: 3px solid #ffc107;
        padding: 4px;
    }
    
    .template-slider-box:hover {
        transform: translateY(-4px) scale(1.05);
        box-shadow: 0 4px 15px rgba(0,0,0,0.2);
        border-color: #ffb300;
    }
    
    .template-slider-box:hover .template-overlay {
        opacity: 1;
    }
    
    .template-slider-box > div {
        width: 100%;
        height: 100%;
        border-radius: 8px;
        overflow: hidden;
        position: relative;
    }
    
    .template-slider-box img {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }
    
    .template-overlay {
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        background: linear-gradient(to top, rgba(0,0,0,0.7), transparent);
        padding: 6px;
        opacity: 0;
        transition: opacity 0.2s;
    }
    
    .template-overlay p {
        color: #fff;
        font-size: 10px;
        font-weight: 600;
        margin: 0;
        text-align: center;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }
    
    @media (max-width: 480px) {
        .template-slider-item {
            width: 90px;
        }
        
        .template-slider-box {
            width: 90px;
            height: 90px;
            border-width: 2px;
            padding: 3px;
        }
        
        .template-name-below {
            width: 90px;
        }
        
        .template-name-below p {
            font-size: 11px;
        }
    }
</style>

<!-- Mobile Section Start -->
<div class="ecommerce-mobile-menu">
    <ul class="mobile-list">
        <li class="active">
            <a href="<?= base_url() ?>">
                <div class="icon">
                    <img class="inactive" src="<?= base_url('assets/theme/v1/social-app/') ?>assets/images/ecommerce/svg/home.svg" alt="home">
                    <img class="active" src="<?= base_url('assets/theme/v1/social-app/') ?>assets/images/ecommerce/svg/home-fill.svg" alt="home">
                </div>
                <h5 class="active">Home</h5>
            </a>
        </li>
        <li>
            <a href="<?= base_url('collections') ?>">
                <div class="icon">
                    <img class="inactive" src="<?= base_url('assets/theme/v1/social-app/') ?>assets/images/ecommerce/svg/search.svg" alt="collections">
                    <img class="active" src="<?= base_url('assets/theme/v1/social-app/') ?>assets/images/ecommerce/svg/search-fill.svg" alt="collections">
                </div>
                <h5>Collections</h5>
            </a>
        </li>
        <li>
            <a href="<?= base_url('index.php/profile') ?>">
                <div class="icon">
                    <img class="inactive" src="<?= base_url('assets/theme/v1/social-app/') ?>assets/images/ecommerce/svg/profile.svg" alt="profile">
                    <img class="active" src="<?= base_url('assets/theme/v1/social-app/') ?>assets/images/ecommerce/svg/profile-fill.svg" alt="profile">
                </div>
                <h5>Profile</h5>
            </a>
        </li>
    </ul>
</div>
<!-- Mobile Section End -->
<!-- Mobile Section End -->