<link rel="stylesheet" type="text/css" href="<?= base_url() ?>assets/theme/v2/assets/css/style.min.css">

<style>
  .ins-wrap{background:#fff;border:1px solid #e6ebf2;border-radius:12px;padding:16px}
  /* centered big form */
  .ins-form-block{max-width:980px;margin:0 auto 18px;background:#fff;border:1px solid #e6ebf2;border-radius:12px;padding:16px 16px 8px;box-shadow:0 8px 22px rgba(20,30,50,.05)}
  .ins-form .form-group{margin-bottom:14px}
  .ins-form .form-control,.ins-form select{height:44px;border:1px solid #dfe5ee;border-radius:6px}
  .ins-form label{font-weight:600;color:#2b3a55;font-size:13px;margin-bottom:6px}
  .ins-apply{width:100%;height:44px;background:#153a63;border-color:#153a63;border-radius:6px}
  .ins-apply-sm{width:100%;height:34px;background:#153a63;border-color:#153a63;border-radius:6px}
  .ins-note{font-size:12px;color:#5b6678;text-align:center;margin-top:10px}
  .ins-radio{display:flex;align-items:center;gap:12px}
  .ins-radio .opt{display:flex;align-items:center;gap:8px}
  .ins-radio input{width:16px;height:16px}
  .ins-card{background:#fff;border:1px solid #e6ebf2;border-radius:12px;padding:16px;height:100%}
  .ins-card h5{font-size:16px;margin:8px 0}
  .ins-brand-grid{display:grid;grid-template-columns:repeat(4,1fr);gap:12px}
  @media(max-width:991px){.ins-brand-grid{grid-template-columns:repeat(3,1fr)}}
  @media(max-width:575px){.ins-brand-grid{grid-template-columns:repeat(2,1fr)}}
  .ins-logo{background:#fff;border:1px solid #e6ebf2;border-radius:8px;display:flex;align-items:center;justify-content:center;height:64px}
  .faq-item{border-bottom:1px solid #e6ebf2}
  .faq-q{display:flex;justify-content:space-between;align-items:center;padding:12px 0;cursor:pointer;font-weight:600}
  .faq-a{display:none;padding:0 0 12px 0;color:#444}
  .faq-item.open .faq-a{display:block}
</style>

<main class="main">
  <div class="page-header" style="padding: 20px 0;">
    <div class="container">
      <h1 class="page-title mb-0">Tractor Insurance</h1>
    </div>
  </div>

  <div class="page-content pt-2">
    <div class="container">
      <!-- Apply Form -->
      <div class="ins-form-block mb-4">
        <form class="ins-form" method="post" action="<?= base_url('action/submit_form_lead') ?>" onsubmit="return uploadandform('<?= base_url('action/submit_form_lead') ?>','post',this,'image_name','progress_value_sc','prog_valie_text','Show_Errors_987','loader_post_upload','1','uni_loader_prog_status');">
          <input type="hidden" name="form_type" value="insurance"/>
          <div class="row">
            <div class="col-md-6 col-12">
              <div class="form-group"><label>Name</label><input type="text" class="form-control" name="name" placeholder="Enter your name"></div>
              <div class="form-group"><label>Brand</label>
                <select class="form-control" id="insBrand" name="brand">
                  <option value="">Select Brand</option>
                  <?php
                  $__brands = $this->db->query("SELECT stg_tgid, stg_name FROM yn_site_tags WHERE stg_type='Brands' ORDER BY stg_name ASC")->result_array();
                  foreach($__brands as $__b){ echo '<option value="'.$__b['stg_tgid'].'">'.htmlspecialchars($__b['stg_name']).'</option>'; }
                  ?>
                </select>
              </div>
              <div class="form-group"><label>Enter Model</label><input type="text" class="form-control" name="model_text" placeholder="Enter Model"></div>
              <div class="form-group"><label>Registered Year</label>
                <select class="form-control" name="year"><option value="">Select Year</option></select>
              </div>
              <div class="form-group"><label>Claims Made In Previous Policy</label>
                <div class="ins-radio">
                  <label class="opt"><input type="radio" name="prev_claim" value="yes"> <span>Yes</span></label>
                  <label class="opt"><input type="radio" name="prev_claim" value="no" checked> <span>No</span></label>
                </div>
              </div>
            </div>
            <div class="col-md-6 col-12">
              <div class="form-group"><label>Mobile Number</label><input type="text" class="form-control" name="mobile" placeholder="Enter Mobile Number"></div>
              <div class="form-group"><label>Model</label>
                <select class="form-control" id="insModel" name="model"><option value="">Select Model</option></select>
              </div>
              <div class="form-group"><label>Vehicle Registration No.</label><input type="text" class="form-control" name="reg_no" placeholder="Ex: DL-01-AB-1234"></div>
              <div class="form-group"><label>State</label>
                <select class="form-control" id="insState" name="state" onchange="load_new_citys(this)"><option value="">Select State</option>
                  <?php $states = $this->db->query("SELECT * FROM yn_site_states WHERE status = 1 ORDER BY state_name ASC")->result_array();
                  foreach($states as $st){ echo '<option value="'.$st['state_id'].'">'.htmlspecialchars($st['state_name']).'</option>'; } ?>
                </select>
              </div>
              <div class="form-group"><label>City</label>
                <select class="form-control" id="get_cities_data" name="city"><option value="">Select City</option></select>
              </div>
            </div>
            <div class="col-12">
              <div class="form-group"><button class="btn btn-primary btn-sm ins-apply-sm" type="submit">APPLY FOR INSURANCE</button></div>
              <div class="ins-note">By proceeding ahead you expressly agree to the Tractor Junctions <a href="#">terms and conditions</a></div>
            </div>
          </div>
        </form>
      </div>

      <!-- How it works (icons styled like product_detail 'offer-icon' with dashed circle) -->
      <style>
        .steps-title{font-weight:700;margin:10px 0 12px}
        .step-card{background:#fff;border:1px solid #e6ebf2;border-radius:12px;box-shadow:0 8px 22px rgba(20,30,50,.05);padding:26px 18px;text-align:center;height:100%}
        .step-icon{width:86px;height:86px;margin:0 auto 14px;position:relative;display:flex;align-items:center;justify-content:center}
        .step-icon:after{content:"";position:absolute;inset:0;border:2px dashed #b9c3d2;border-radius:50%}
        .step-icon:before{content:"";position:absolute;width:28px;height:28px;border-radius:50%;background:#eaf3fa;right:6px;top:8px}
        .step-card h5{font-weight:700;margin-bottom:8px}
      </style>
      <h4 class="steps-title" style="font-size:20px">How to Buy Tractor Insurance Online?</h4>
      <div class="row g-3 mb-4">
        <div class="col-md-4 col-12">
          <div class="step-card">
            <span class="step-icon">
              <svg width="40" height="40" viewBox="0 0 56 56" fill="none">
                <rect x="18" y="14" width="20" height="26" rx="3" fill="#fff" stroke="#222" stroke-width="2" />
                <rect x="20" y="18" width="16" height="6" rx="1.5" fill="#fff" stroke="#222" stroke-width="1.5" />
                <path d="M20 28h16" stroke="#d44d53" stroke-width="2" />
              </svg>
            </span>
            <h5>Fill Your Tractor Details</h5>
            <p>Enter registration, brand, model, year and claim info. We’ll fetch the best plans based on your inputs.</p>
          </div>
        </div>
        <div class="col-md-4 col-12">
          <div class="step-card">
            <span class="step-icon">
              <svg width="40" height="40" viewBox="0 0 56 56" fill="none">
                <path d="M28 38c2-6 8-8 8-14a8 8 0 10-16 0c0 6 6 8 8 14z" fill="#fff" stroke="#222" stroke-width="2" />
                <path d="M28 38v4" stroke="#d44d53" stroke-width="2" />
              </svg>
            </span>
            <h5>Compare Tractor Insurance Policy</h5>
            <p>Compare premiums, add-ons and features from multiple companies and choose what fits your budget.</p>
          </div>
        </div>
        <div class="col-md-4 col-12">
          <div class="step-card">
            <span class="step-icon">
              <svg width="40" height="40" viewBox="0 0 56 56" fill="none">
                <rect x="20" y="14" width="16" height="26" rx="3" fill="#fff" stroke="#222" stroke-width="2" />
                <path d="M24 26h8" stroke="#d44d53" stroke-width="2" />
              </svg>
            </span>
            <h5>Make Payment Online</h5>
            <p>Pay securely and get your tractor insurance policy and documents instantly on your phone.</p>
          </div>
        </div>
      </div>

      <!-- Why choose us -->
      <h4 class="steps-title" style="font-size:20px">Why Choose TractorJunction for Agriculture/Commercial Tractor Insurance Online</h4>
      <div class="row g-3 mb-4">
        <div class="col-md-4 col-12">
          <div class="step-card">
            <span class="step-icon">
              <svg width="40" height="40" viewBox="0 0 56 56" fill="none">
                <rect x="18" y="14" width="20" height="26" rx="3" fill="#fff" stroke="#222" stroke-width="2" />
                <rect x="20" y="18" width="16" height="6" rx="1.5" fill="#fff" stroke="#222" stroke-width="1.5" />
                <path d="M20 28h16" stroke="#d44d53" stroke-width="2" />
              </svg>
            </span>
            <h5>Get Tractor Insurance Within 5 Minutes</h5>
            <p>Instant quotes, minimal documents and quick checkout. Your policy is delivered in minutes.</p>
          </div>
        </div>
        <div class="col-md-4 col-12">
          <div class="step-card">
            <span class="step-icon">
              <svg width="40" height="40" viewBox="0 0 56 56" fill="none">
                <rect x="18" y="18" width="20" height="16" rx="3" fill="#fff" stroke="#222" stroke-width="2" />
                <circle cx="28" cy="38" r="6" fill="#fff" stroke="#222" stroke-width="2" />
                <path d="M22 38h12" stroke="#d44d53" stroke-width="2" />
              </svg>
            </span>
            <h5>Committed Customer Support Team</h5>
            <p>Our support team is available 7 days a week to help you with renewals, claims and queries.</p>
          </div>
        </div>
        <div class="col-md-4 col-12">
          <div class="step-card">
            <span class="step-icon">
              <svg width="40" height="40" viewBox="0 0 56 56" fill="none">
                <rect x="18" y="14" width="20" height="26" rx="3" fill="#fff" stroke="#222" stroke-width="2" />
                <path d="M22 26h12M22 30h12" stroke="#d44d53" stroke-width="2" />
              </svg>
            </span>
            <h5>Get Insurance Plans with Minimum Paperwork</h5>
            <p>Online process reduces errors and documents. Enjoy a seamless experience from start to finish.</p>
          </div>
        </div>
      </div>

      <!-- Popular Brands (copied dynamic design from home.php) -->
      <style>
        .brands-section{background:#f5f5f5; padding:20px 20px; border-radius:8px; margin:10px 0}
        .brands-grid .brand-col{margin-bottom:20px; display:flex; justify-content:center}
        /* ensure view more button text visible */
        #insurance-brands-toggle-btn{background:#204080 !important; color:#fff !important; border-color:#204080 !important}
        #insurance-brands-toggle-btn:hover{background:#1b3a6e !important; color:#fff !important}
      </style>
      <div class="brands-section" id="insurance-brands">
        <h4 class="title title-underline mb-4 ls-normal">Popular Tractor Brands</h4>
        <div class="brands-grid">
          <div class="row gutter-no cols-xl-8 cols-lg-6 cols-md-4 cols-sm-3 cols-2" id="insurance-brands-container">
            <?php if (isset($brands) && !empty($brands)): ?>
              <?php foreach ($brands as $brand): ?>
                <div class="brand-col">
                  <a href="<?= base_url('shop?brand=' . $brand['stg_tgid']) ?>" style="text-decoration:none; color:inherit;">
                    <figure class="brand-wrapper text-center">
                      <div style="background:#fff; padding:15px; border-radius:8px; box-shadow:0 2px 8px rgba(0,0,0,0.05); margin-bottom:8px; width:140px; height:90px; display:flex; align-items:center; justify-content:center; margin-left:auto; margin-right:auto;">
                        <img src="<?= !empty($brand['stg_img']) ? base_url('assets/avator/upload/tags/') . $brand['stg_img'] : base_url('assets/theme/v2/assets/images/demos/demo1/brands/1.png') ?>"
                             alt="<?= htmlspecialchars($brand['stg_name']) ?>"
                             style="object-fit:contain; width:100%; height:100%; display:block;" />
                      </div>
                      <figcaption style="font-size:14px; font-weight:500; color:#222; margin-top:5px;">
                        <?= htmlspecialchars($brand['stg_name']) ?>
                      </figcaption>
                    </figure>
                  </a>
                </div>
              <?php endforeach; ?>
            <?php else: ?>
              <!-- Fallback static brands if no brands found -->
              <div class="brand-col"><figure class="brand-wrapper text-center"><div style="background:#fff; padding:15px; border-radius:8px; box-shadow:0 2px 8px rgba(0,0,0,0.05); margin-bottom:8px; width:140px; height:90px; display:flex; align-items:center; justify-content:center; margin-left:auto; margin-right:auto;"><img src="<?= base_url('assets/theme/v2/') ?>assets/images/demos/demo1/brands/1.png" alt="Brand" width="120" height="80" style="object-fit:contain; max-width:100%; height:auto;" /></div><figcaption style="font-size:14px; font-weight:500; color:#222; margin-top:5px;">Sample Brand</figcaption></figure></div>
              <div class="brand-col"><figure class="brand-wrapper text-center"><div style="background:#fff; padding:15px; border-radius:8px; box-shadow:0 2px 8px rgba(0,0,0,0.05); margin-bottom:8px; width:140px; height:90px; display:flex; align-items:center; justify-content:center; margin-left:auto; margin-right:auto;"><img src="<?= base_url('assets/theme/v2/') ?>assets/images/demos/demo1/brands/2.png" alt="Brand" width="120" height="80" style="object-fit:contain; max-width:100%; height:auto;" /></div><figcaption style="font-size:14px; font-weight:500; color:#222; margin-top:5px;">Sample Brand</figcaption></figure></div>
            <?php endif; ?>
          </div>
        </div>
        <div class="text-center mt-4" id="insurance-brands-view-more">
          <button type="button" class="btn btn-outline btn-primary btn-rounded" id="insurance-brands-toggle-btn">
            View More <i class="w-icon-long-arrow-right"></i>
          </button>
        </div>
      </div>

      <script>
        // Insurance brands View More/Less (same pattern as home.php)
        (function(){
          var toggleBtn = document.getElementById('insurance-brands-toggle-btn');
          var container = document.getElementById('insurance-brands-container');
          if(!toggleBtn || !container) return;
          var currentCount = container.children.length; // initial count (8)
          var allBrands = <?php echo json_encode($all_brands ?? []); ?>;
          var isExpanded = false;
          toggleBtn.addEventListener('click', function(){
            if(!isExpanded){
              var nextBatch = allBrands.slice(currentCount);
              nextBatch.forEach(function(brand){
                var col = document.createElement('div');
                col.className = 'brand-col';
                col.innerHTML = '\n<a href="<?= base_url('shop?brand=') ?>'+brand.stg_tgid+'" style="text-decoration:none; color:inherit;">\n  <figure class="brand-wrapper text-center">\n    <div style="background:#fff; padding:15px; border-radius:8px; box-shadow:0 2px 8px rgba(0,0,0,0.05); margin-bottom:8px; width:140px; height:90px; display:flex; align-items:center; justify-content:center; margin-left:auto; margin-right:auto;">\n      <img src="'+(brand.stg_img ? '<?= base_url('assets/avator/upload/tags/') ?>'+brand.stg_img : '<?= base_url('assets/theme/v2/assets/images/demos/demo1/brands/1.png') ?>')+'" alt="'+brand.stg_name.replace(/"/g,'&quot;')+'" style="object-fit:contain; width:100%; height:100%; display:block;" />\n    </div>\n    <figcaption style="font-size:14px; font-weight:500; color:#222; margin-top:5px;">'+brand.stg_name+'</figcaption>\n  </figure>\n</a>';
                container.appendChild(col);
              });
              isExpanded = true;
              toggleBtn.innerHTML = 'Show Less <i class="w-icon-long-arrow-right"></i>';
            } else {
              // remove extra items beyond initial 8
              while(container.children.length > <?= isset($brands) ? count($brands) : 8 ?>){
                container.removeChild(container.lastElementChild);
              }
              isExpanded = false;
              toggleBtn.innerHTML = 'View More <i class="w-icon-long-arrow-right"></i>';
            }
          });
        })();
      </script>

      <!-- Best offers/info block (match compare-style heading cards) -->
      <style>
        .ins-offers{margin-top:16px}
        .ins-offer-item{border:1px solid #eaecef;border-radius:10px;background:#fff;padding:12px;margin-bottom:14px}
        .ins-offer-head{background:#f6f8fc;border:1px solid #eceff4;border-left:4px solid #d34a4a;border-radius:6px;padding:8px 10px;margin:4px 0 10px;font-weight:700;color:#1d2430}
        .ins-offer-body{padding:0 6px 12px 6px;color:#333;line-height:1.7}
      </style>
      <div class="ins-offers mb-4">
        <div class="ins-offer-item">
          <div class="ins-offer-head">Get insured your tractor with best offers</div>
          <div class="ins-offer-body">
            Secure yourself with a Tractor Insurance. Tractor Insurance offers you peace of mind that you should not deny yourself. Tractor Yaari offers countless online tractor insurance options for your dream machine at competitive prices. We know what a tractor costs you and what it takes to manage the maintenance costs. So, here we are with the newly inducted tractor insurance price list!
          </div>
        </div>
        <div class="ins-offer-item">
          <div class="ins-offer-head">Tractor Insurance Online Policy</div>
          <div class="ins-offer-body">
            Secure yourself with a Tractor Insurance. Tractor Insurance offers you peace of mind that you should not deny yourself. Tractor Junction offers countless online tractor insurance options for your dream machine at competitive prices. We know what a tractor costs you and what it takes to manage the maintenance costs. So, here we are with the newly inducted tractor insurance price list!
          </div>
        </div>
        <div class="ins-offer-item">
          <div class="ins-offer-head">So, What Is A Tractor Insurance?</div>
          <div class="ins-offer-body">
            A tractor insurance policy is a legal agreement between the insured and the insurer. It is designed to protect your tractor from any unfortunate damages and losses caused by accidents, collisions, natural disasters or theft.
            <br/><br/>
            With agriculture tractor insurance, you can leave the task of paying for the wreckages and wearing the tears of your tractor to the insurance companies. All you must do is choose the finest tractor insurance policy that suits your budget and the needs of the tractor simultaneously.
          </div>
        </div>
        <div class="ins-offer-item">
          <div class="ins-offer-head">If You Have A Plan, Let’s Discuss</div>
          <div class="ins-offer-body">
            At Tractor Junction, you can obtain online tractor insurance policies from different tractor insurance companies like SBI tractor insurance. Additionally, you can check for tractor insurance details, apply for tractor insurance policy renewal online and much more. You can also choose from farm tractor insurance from different companies and check tractor insurance 1‑year price and tractor insurance status check in real‑time. Tractor Junction experts have made the online commercial tractor insurance process very simple.
            <br/><br/>
            It is fairly simple, fill in the details regarding the tractor, such as the brand, the model, the registered city and your name, along with contact details, and you are good to go. You can leverage the tractor insurance premium calculator to check the tractor insurance amount and, ultimately, tractor insurance price in India!
            <br/><br/>
            Tractor Junction is committed to bringing you the best tractor insurance cost in India for your development and security. When you choose us, we make sure you get the best agricultural tractor insurance online and don’t regret your choices upon your decisions.
            <br/><br/>
            Visit here to get <a href="<?= base_url('onRoad_price') ?>">Tractor Loan</a>.
          </div>
        </div>
      </div>

      <!-- FAQs -->
      <div class="ins-wrap mb-6">
        <h4 class="mb-3">Tractor Insurance FAQs</h4>
        <div class="faq-item"><div class="faq-q">What damages are covered under Tractor Insurance? <span>+</span></div><div class="faq-a">Covers loss or damage due to accidents, fire, theft, natural disasters and third-party liability depending on the plan.</div></div>
        <div class="faq-item"><div class="faq-q">Is Tractor Insurance compulsory? <span>+</span></div><div class="faq-a">Third-party liability insurance is mandatory by law for vehicles plying on roads in India.</div></div>
        <div class="faq-item"><div class="faq-q">What are the advantages of buying Tractor Insurance online? <span>+</span></div><div class="faq-a">Quick comparison, instant issuance, minimal paperwork and best pricing.</div></div>
        <div class="faq-item"><div class="faq-q">How to file a claim? <span>+</span></div><div class="faq-a">Contact insurer’s toll-free number, submit documents and photos; the surveyor assesses and claim is processed.</div></div>
      </div>
    </div>
  </div>
</main>

<script>
  document.querySelectorAll('.faq-q').forEach(function(q){
    q.addEventListener('click', function(){ q.parentElement.classList.toggle('open'); });
  });
</script>

<script>
  // dynamic cities like other forms
  function load_new_citys(obj){
    var thestate = obj.value || '';
    if(!thestate){ document.getElementById('get_cities_data').innerHTML='<option value="">Select City</option>'; return; }
    fetch('<?= base_url("ynaps_load/load_city?state=") ?>'+thestate)
      .then(r=>r.text())
      .then(html=>{ document.getElementById('get_cities_data').innerHTML = html; })
      .catch(()=>{ document.getElementById('get_cities_data').innerHTML='<option value="">Select City</option>'; });
  }

  // dynamic models on brand change (reuse compare_models endpoint)
  (function(){
    var brandSel = document.getElementById('insBrand');
    var modelSel = document.getElementById('insModel');
    if(!brandSel || !modelSel) return;
    brandSel.addEventListener('change', function(){
      modelSel.innerHTML = '<option value="">Select Model</option>';
      var bid = this.value;
      if(!bid) return;
      fetch('<?= base_url('action/compare_models?brand_id=') ?>'+bid)
        .then(r=>r.json())
        .then(function(rows){
          rows.forEach(function(m){
            var opt=document.createElement('option');
            opt.value = m.name; // keep model name
            opt.textContent = m.name;
            modelSel.appendChild(opt);
          });
        });
    });
  })();
</script>

