<!-- <link rel="stylesheet" type="text/css" href="{{base_url}}assets/theme/{{theme}}/assets/css/style.min.css">  -->
<link rel="stylesheet" type="text/css" href="<?= base_url() ?>assets/theme/v2/assets/css/style.min.css">

<?php /* Minimal EMI Calculator view */ ?>
<main class="main">
    <div class="page-header">
        <div class="container">
            <h1 class="page-title mb-0">Tractor Loan EMI Calculator</h1>
        </div>
    </div>
    <nav class="breadcrumb-nav">
        <div class="container">
            <ul class="breadcrumb">
                <li><a href="<?= base_url() ?>">Home</a></li>
                <li>Tractor Loan Calculator</li>
            </ul>
        </div>
    </nav>

    <div class="page-content pt-2">
        <div class="container">
        
      <!-- New Sections: Top Loan Form, Steps, Eligibility/Documents -->
      <style>
        .loan-top-card{max-width:640px;margin:24px auto 28px auto;background:#fff;border:1px solid #e6ebf2;border-radius:10px;box-shadow:0 8px 24px rgba(15,23,42,.06)}
        .loan-top-head{padding:18px 20px;border-top:4px solid #d94b4b;border-bottom:1px solid #f0f2f6}
        .loan-top-head h2{margin:0;font-size:28px;line-height:1.25;color:#1b2436;font-weight:800}
        .loan-top-body{padding:18px}
        .loan-row{display:flex;flex-direction:column;gap:14px}
        .loan-inp{position:relative}
        .loan-inp input{width:100%;height:52px;border:1px solid #e1e7ef;border-radius:10px;background:#f7f9fc;font-size:16px;padding:0 16px 0 48px;outline:0}
        .loan-inp select{width:100%;height:52px;border:1px solid #e1e7ef;border-radius:10px;background:#f7f9fc;font-size:16px;padding:0 16px;outline:0}
        .loan-inp .ico{position:absolute;left:14px;top:50%;transform:translateY(-50%);width:24px;height:24px;color:#334155;opacity:.9}
        .loan-inp .edit-btn{position:absolute;right:16px;top:50%;transform:translateY(-50%);color:#9aa4b2;font-weight:600;font-size:15px}
        .loan-next{width:100%;height:48px;border-radius:8px;border:none;background:#153a63;color:#fff;font-weight:700;letter-spacing:.5px}
        .loan-next:hover{background:#123558}
        @media(min-width:576px){.loan-row{gap:16px}}

        .steps-wrap{padding:34px 0 36px 0;text-align:center}
        .steps-wrap h3{font-size:32px;margin:0 0 8px 0;color:#1b2436;font-weight:800}
        .steps-wrap p.subtitle{margin:0 0 26px 0;color:#667085}
        .steps{display:grid;grid-template-columns:1fr;gap:28px;max-width:1050px;margin:0 auto}
        @media(min-width:768px){.steps{grid-template-columns:repeat(4,1fr)}}
        .step{display:flex;flex-direction:column;align-items:center;gap:10px}
        .step .badge{width:32px;height:32px;border-radius:50%;background:#153a63;color:#fff;display:flex;align-items:center;justify-content:center;font-weight:700}
        .step .sico{width:56px;height:56px;border-radius:12px;background:#fff;border:1px solid #eef2f6;display:flex;align-items:center;justify-content:center;box-shadow:0 6px 16px rgba(15,23,42,.06)}
        .step h5{margin:6px 0 6px 0;font-size:18px;color:#1b2436}
        .step p{margin:0;color:#6b7280}

        .elig-wrap{background:#f7f8fa;padding:34px 0}
        .elig-section{max-width:1150px;margin:0 auto}
        .elig-card{background:#fff;border:1px solid #eef2f6;border-radius:10px;padding:16px 18px;margin:0 auto 22px auto}
        .elig-title{font-size:28px;margin:0 0 4px 0;text-align:center;color:#1b2436;font-weight:800}
        .elig-sub{margin:0 0 18px 0;text-align:center;color:#6b7280}
        .elig-list{display:grid;grid-template-columns:1fr;gap:14px}
        @media(min-width:768px){.elig-list{grid-template-columns:1fr 1fr}}
        .elig-item{display:flex;align-items:center;gap:12px;background:#f9fafb;border:1px solid #eef2f6;border-radius:8px;padding:12px 14px}
        .file-ico{width:20px;height:20px}
      </style>

      <!-- Section 1: Top Form -->
      <div class="loan-top-card">
        <div class="loan-top-head"><h2>Apply for New Tractor Loan</h2></div>
        <div class="loan-top-body">
          <form class="loan-row" method="post" action="<?= base_url('action/submit_form_lead') ?>" onsubmit="return uploadandform('<?= base_url('action/submit_form_lead') ?>','post',this,'image_name','progress_value_sc','prog_valie_text','Show_Errors_987','loader_post_upload','1','uni_loader_prog_status');">
            <input type="hidden" name="form_type" value="loan_calculator"/>
            <div class="loan-inp">
              <svg class="ico" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M12 12c2.761 0 5-2.239 5-5s-2.239-5-5-5-5 2.239-5 5 2.239 5 5 5Zm0 2c-4.418 0-8 2.239-8 5v1h16v-1c0-2.761-3.582-5-8-5Z" fill="currentColor"/></svg>
              <input type="text" name="name" placeholder="Enter Your Name">
                            </div>
            <div class="loan-inp">
              <svg class="ico" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M6.62 10.79a15.053 15.053 0 006.59 6.59l2.2-2.2a1 1 0 011.01-.24c1.12.37 2.33.57 3.58.57a1 1 0 011 1V20a1 1 0 01-1 1C10.07 21 3 13.93 3 5a1 1 0 011-1h3.5a1 1 0 011 1c0 1.25.2 2.46.57 3.58a1 1 0 01-.25 1.01l-2.2 2.2z" fill="currentColor"/></svg>
              <input type="tel" name="mobile" placeholder="+91 - Enter Mobile Number">
                                        </div>
            <div class="loan-inp">
              <select id="state" name="state" onchange="load_new_citys(this)">
                <option value="">Select State</option>
                <?php $states = $this->db->query("SELECT * FROM yn_site_states WHERE status = 1 ORDER BY state_name ASC")->result_array();
                foreach($states as $st){ echo '<option value="'.$st['state_id'].'">'.htmlspecialchars($st['state_name']).'</option>'; } ?>
                                            </select>
                                        </div>
            <div class="loan-inp">
              <select id="get_cities_data" name="city">
                <option value="">Select City</option>
                                            </select>
                                        </div>
            <button type="submit" class="loan-next">NEXT</button>
          </form>
                            </div>
                        </div>

      <!-- Section 2: Steps -->
      <div class="steps-wrap">
        <h3>New Tractor Loan in 4 Steps</h3>
        <p class="subtitle">Get New tractor loan quickly by these 4 steps.</p>
        <div class="steps">
          <div class="step">
            <div class="badge">1</div>
            <div class="sico">📝</div>
            <h5>Fill the Form</h5>
            <p>These details make the process quick.</p>
                            </div>
          <div class="step">
            <div class="badge">2</div>
            <div class="sico">🏷️</div>
            <h5>Compare Offers</h5>
            <p>Choose the best loan offer for you.</p>
                                                </div>
          <div class="step">
            <div class="badge">3</div>
            <div class="sico">✅</div>
            <h5>Instant Approval</h5>
            <p>Get immediate approval from the bank.</p>
                                            </div>
          <div class="step">
            <div class="badge">4</div>
            <div class="sico">🏦</div>
            <h5>Money in your Account</h5>
            <p>You can get instant money in an account.</p>
                                        </div>
                                    </div>
                                </div>

      <!-- Section 3: Eligibility & Documents -->
      <div class="elig-wrap">
        <div class="elig-section">
          <div class="elig-card">
            <h4 class="elig-title">New Tractor Loan Eligibility</h4>
            <p class="elig-sub">Check down below eligibility for a new tractor loan.</p>
            <div class="elig-list">
              <div class="elig-item"><span class="file-ico">📁</span><span>18 years - Minimum Age</span></div>
              <div class="elig-item"><span class="file-ico">📁</span><span>65 years - Maximum Age</span></div>
              <div class="elig-item"><span class="file-ico">📁</span><span>Income Proof and minimum land holding of 2 acres</span></div>
                            </div>
                        </div>

          <div class="elig-card">
            <h4 class="elig-title">Tractor Loan Documents</h4>
            <p class="elig-sub">Documents required for new tractor loan.</p>
            <div class="elig-list">
              <div class="elig-item"><span class="file-ico">📁</span><span>Land Ownership Proof</span></div>
              <div class="elig-item"><span class="file-ico">📁</span><span>Address Proof: Aadhaar Card or any one of Voter ID / Passport / Driving License</span></div>
              <div class="elig-item"><span class="file-ico">📁</span><span>3 months bank statement</span></div>
              <div class="elig-item"><span class="file-ico">📁</span><span>CV 12 months track record</span></div>
              <div class="elig-item" style="grid-column:1 / -1"><span class="file-ico">📁</span><span>Identity Proof: Aadhaar Card or any one of Voter ID / PAN Card / Driving License / Passport</span></div>
                            </div>
                                            </div>
                                    </div>
                                            </div>
      <!-- End New Sections -->

      <style>
        .emi-wrap { margin: 40px 0px; }
        .emi-card { background:#fff; border:1px solid #e5e5e5; border-radius:10px; box-shadow:0 4px 16px rgba(0,0,0,.04); }
        .emi-card .card-header { padding:16px 18px; border-bottom:1px solid #eee; }
        .emi-card .card-title { margin:0; font-size:20px; }
        .emi-card .card-body { padding:18px; }
        .emi-grid { display:grid; grid-template-columns:1fr; gap:14px; }
        @media (min-width: 576px) { .emi-grid { grid-template-columns:1fr 1fr; } }
        .emi-field { display:flex; flex-direction:column; }
        .emi-field label { font-weight:600; margin-bottom:6px; }
        .emi-field input, .emi-field select { height:44px; padding:8px 12px; border:1px solid #ced4da; border-radius:8px; font-size:16px; }
        .emi-actions { display:flex; gap:10px; margin-top:12px; }
        .btn { display:inline-flex; align-items:center; justify-content:center; gap:8px; padding:10px 16px; border-radius:8px; cursor:pointer; user-select:none; border:1px solid transparent; }
        .btn-primary { background:#2c7be5; border-color:#2c7be5; color:#fff; }
        .btn-light { background:#f8f9fa; border-color:#ced4da; color:#111; }
        .emi-results { display:none; margin-top:18px; }
        .emi-tiles { display:grid; grid-template-columns:1fr; gap:12px; }
        @media (min-width:576px){ .emi-tiles { grid-template-columns:1fr 1fr 1fr; } }
        .tile { background:#fafafa; border:1px solid #eee; border-radius:10px; padding:14px; }
        .tile .label { color:#6c757d; font-size:13px; }
        .tile .value { font-size:20px; font-weight:700; margin-top:4px; }
        .emi-schedule { display:none; margin-top:14px; }
        table.emi-table { width:100%; border-collapse:collapse; font-size:14px; }
        .emi-table th, .emi-table td { border:1px solid #eee; padding:8px; text-align:right; }
        .emi-table th:first-child, .emi-table td:first-child { text-align:center; }
        .emi-table tfoot td { font-weight:700; background:#f8f9fa; }
        input[type="number"]{ -moz-appearance:textfield; appearance:textfield; }
        input[type="number"]::-webkit-outer-spin-button,
        input[type="number"]::-webkit-inner-spin-button{ -webkit-appearance:none; appearance:none; margin:0; }
      </style>

      <div class="emi-wrap">
        <div class="emi-card">
                            <div class="card-header">
            <h4 class="card-title">Simplified EMI Calculator</h4>
                            </div>
                            <div class="card-body">
            <div class="emi-grid">
              <div class="emi-field">
                <label for="emiAmount">Loan Amount</label>
                <input type="number" id="emiAmount" placeholder="e.g. 500000" value="500000" min="0" step="1" inputmode="numeric" />
                                </div>
              <div class="emi-field">
                <label for="emiRate">Interest Rate (%)</label>
                <input type="number" id="emiRate" placeholder="e.g. 14" value="14" min="0" step="0.01" inputmode="decimal" />
                                    </div>
              <div class="emi-field">
                <label for="emiTenure">Loan Tenure</label>
                <input type="number" id="emiTenure" placeholder="e.g. 5 or 60" value="5" min="1" step="1" inputmode="numeric" />
                                    </div>
              <div class="emi-field">
                <label for="emiUnit">Tenure Unit</label>
                <select id="emiUnit">
                  <option value="years" selected>Years</option>
                  <option value="months">Months</option>
                                            </select>
                                    </div>
              <div class="emi-field">
                <label for="emiFrequency">Payment Frequency</label>
                <select id="emiFrequency">
                  <option value="monthly" selected>Monthly</option>
                  <option value="quarterly">Quarterly</option>
                  <option value="half_yearly">Half Yearly</option>
                </select>
              </div>
              <div class="emi-field">
                <label for="emiType">Payment Type</label>
                <select id="emiType">
                  <option value="emi" selected>Equal Payments (Principal & Interest)</option>
                  <option value="principal_fixed">Principal Fixed (Flat)</option>
                  <option value="flat_rate">Flat Rate</option>
                </select>
              </div>
                                </div>

            <div class="emi-actions">
              <button id="emiCalcBtn" class="btn btn-primary">Calculate</button>
              <button id="emiClearBtn" class="btn btn-light">Clear</button>
                        </div>

            <div id="emiResults" class="emi-results">
              <div class="emi-tiles">
                <div class="tile">
                  <div class="label" id="emiLabel">Monthly EMI</div>
                  <div class="value" id="vEmi">₹0.00</div>
                            </div>
                <div class="tile">
                  <div class="label">Total Payment</div>
                  <div class="value" id="vTotalPay">₹0.00</div>
                                    </div>
                <div class="tile">
                  <div class="label">Total Interest</div>
                  <div class="value" id="vTotalInt">₹0.00</div>
                            </div>
                        </div>

              <div style="margin-top:12px;">
                <button id="toggleSchedule" class="btn btn-light">Show Full Schedule</button>
            </div>

              <div id="scheduleBox" class="emi-schedule">
                <div class="emi-card" style="margin-top:10px;">
                  <div class="card-header"><strong>Amortization Schedule</strong></div>
                  <div class="card-body" style="overflow:auto;">
                    <table class="emi-table" id="emiTable">
                      <thead>
                        <tr>
                          <th>#</th>
                          <th>Payment</th>
                          <th>Principal</th>
                          <th>Interest</th>
                          <th>Balance</th>
                        </tr>
                      </thead>
                      <tbody></tbody>
                      <tfoot>
                        <tr>
                          <td>Sum</td>
                          <td id="sumPayment">₹0</td>
                          <td id="sumPrincipal">₹0</td>
                          <td id="sumInterest">₹0</td>
                          <td id="sumBalance">₹0</td>
                        </tr>
                      </tfoot>
                    </table>
                            </div>
                        </div>
                    </div>
                            </div>

<script>
              (function(){
                const $ = (s) => document.querySelector(s);
                const formatINR = (n) => '₹' + Number(n || 0).toLocaleString('en-IN', {minimumFractionDigits: 2, maximumFractionDigits: 2});

                function computeEMI(P, annualRatePct, tenure, unit, frequency = 'monthly'){
                  const N = unit === 'years' ? Math.round(tenure * 12) : Math.round(tenure);
                  if (P <= 0 || annualRatePct < 0 || N <= 0) return null;
                  
                  // Calculate frequency multiplier
                  let freqMultiplier = 1;
                  let paymentsPerYear = 12;
                  if (frequency === 'quarterly') {
                    freqMultiplier = 3;
                    paymentsPerYear = 4;
                  } else if (frequency === 'half_yearly') {
                    freqMultiplier = 6;
                    paymentsPerYear = 2;
                  }
                  
                  // Adjust tenure for frequency
                  const adjustedN = Math.ceil(N / freqMultiplier);
                  const R = annualRatePct / paymentsPerYear / 100; // rate per payment period
                  
                  if (R === 0) return { emi: P / adjustedN, N: adjustedN, R, freqMultiplier, paymentsPerYear };
                  const pow = Math.pow(1 + R, adjustedN);
                  const emi = P * R * pow / (pow - 1);
                  return { emi, N: adjustedN, R, freqMultiplier, paymentsPerYear };
                }

                function buildSchedule(P, emi, R, N){
                  const rows = [];
                  let bal = P; let sPay = 0, sPri = 0, sInt = 0;
                  for (let i = 1; i <= N; i++){
                    const interest = bal * R;
                    const principal = Math.min(emi - interest, bal);
                    bal = Math.max(bal - principal, 0);
                    rows.push({i, payment: emi, principal, interest, balance: bal});
                    sPay += emi; sPri += principal; sInt += interest;
                  }
                  return { rows, totals: { payment: sPay, principal: sPri, interest: sInt, balance: bal } };
                }

                function buildSchedulePrincipalFixed(P, R, N){
                  const rows = [];
                  let bal = P; let sPay = 0, sPri = 0, sInt = 0;
                  const principalPerMonth = P / N;
                  for (let i = 1; i <= N; i++){
                    const interest = bal * R;
                    const payment = principalPerMonth + interest;
                    const principal = Math.min(principalPerMonth, bal);
                    bal = Math.max(bal - principal, 0);
                    rows.push({i, payment, principal, interest, balance: bal});
                    sPay += payment; sPri += principal; sInt += interest;
                  }
                  return { rows, totals: { payment: sPay, principal: sPri, interest: sInt, balance: bal }, firstPayment: rows.length ? rows[0].payment : 0 };
                }

                function buildScheduleFlatRate(P, annualRatePct, N, frequency = 'monthly'){
                  const rows = [];
                  let bal = P; let sPay = 0, sPri = 0, sInt = 0;
                  
                  // Calculate flat rate interest
                  const totalInterest = P * (annualRatePct / 100) * (N / 12);
                  const totalPayment = P + totalInterest;
                  const paymentPerInstallment = totalPayment / N;
                  const principalPerInstallment = P / N;
                  const interestPerInstallment = totalInterest / N;
                  
                  for (let i = 1; i <= N; i++){
                    const payment = paymentPerInstallment;
                    const principal = principalPerInstallment;
                    const interest = interestPerInstallment;
                    bal = Math.max(bal - principal, 0);
                    rows.push({i, payment, principal, interest, balance: bal});
                    sPay += payment; sPri += principal; sInt += interest;
                  }
                  return { rows, totals: { payment: sPay, principal: sPri, interest: sInt, balance: bal }, firstPayment: rows.length ? rows[0].payment : 0 };
                }

                function render(){
                  const P = parseFloat($('#emiAmount').value || '0');
                  const rate = parseFloat($('#emiRate').value || '0');
                  const ten = parseFloat($('#emiTenure').value || '0');
                  const unit = $('#emiUnit').value;
                  const type = $('#emiType').value;
                  const frequency = $('#emiFrequency').value;
                  const base = computeEMI(P, rate, ten, unit, frequency);
                  if (!base) return;
                  const { emi, N, R, freqMultiplier, paymentsPerYear } = base;
                  let totalPay, totalInt, schedule;
                  
                  if (type === 'principal_fixed'){
                    schedule = buildSchedulePrincipalFixed(P, R, N);
                    totalPay = schedule.totals.payment;
                    totalInt = schedule.totals.interest;
                    // Show the first installment as the displayed payment
                    $('#vEmi').textContent = formatINR(schedule.firstPayment);
                  } else if (type === 'flat_rate'){
                    schedule = buildScheduleFlatRate(P, rate, N * freqMultiplier, frequency);
                    totalPay = schedule.totals.payment;
                    totalInt = schedule.totals.interest;
                    $('#vEmi').textContent = formatINR(schedule.firstPayment);
                  } else {
                    schedule = buildSchedule(P, emi, R, N);
                    totalPay = emi * N;
                    totalInt = totalPay - P;
                    $('#vEmi').textContent = formatINR(emi);
                  }
                  // Update EMI label based on frequency
                  let emiLabel = 'Monthly EMI';
                  if (frequency === 'quarterly') {
                    emiLabel = 'Quarterly EMI';
                  } else if (frequency === 'half_yearly') {
                    emiLabel = 'Half Yearly EMI';
                  }
                  $('#emiLabel').textContent = emiLabel;
                  
                  $('#vTotalPay').textContent = formatINR(totalPay);
                  $('#vTotalInt').textContent = formatINR(totalInt);
                  $('#emiResults').style.display = 'block';

                  const sched = schedule;
                  const tbody = $('#emiTable tbody');
                  tbody.innerHTML = '';
                  const frag = document.createDocumentFragment();
                  sched.rows.forEach(r => {
                    const tr = document.createElement('tr');
                    tr.innerHTML = `<td>${r.i}</td><td>${formatINR(r.payment)}</td><td>${formatINR(r.principal)}</td><td>${formatINR(r.interest)}</td><td>${formatINR(r.balance)}</td>`;
                    frag.appendChild(tr);
                  });
                  tbody.appendChild(frag);
                  $('#sumPayment').textContent = formatINR(sched.totals.payment);
                  $('#sumPrincipal').textContent = formatINR(sched.totals.principal);
                  $('#sumInterest').textContent = formatINR(sched.totals.interest);
                  $('#sumBalance').textContent = formatINR(sched.totals.balance);
                  $('#scheduleBox').style.display = 'none';
                  $('#toggleSchedule').textContent = 'Show Full Schedule';
                }

                $('#emiCalcBtn').addEventListener('click', render);
                $('#emiClearBtn').addEventListener('click', () => {
                  $('#emiAmount').value = '';
                  $('#emiRate').value = '';
                  $('#emiTenure').value = '';
                  $('#emiUnit').value = 'years';
                  $('#emiFrequency').value = 'monthly';
                  $('#emiType').value = 'emi';
                  $('#emiResults').style.display = 'none';
                  $('#scheduleBox').style.display = 'none';
                });
                $('#toggleSchedule').addEventListener('click', () => {
                  const box = $('#scheduleBox');
                  const open = box.style.display !== 'none';
                  box.style.display = open ? 'none' : 'block';
                  $('#toggleSchedule').textContent = open ? 'Show Full Schedule' : 'Hide Full Schedule';
                });
              })();
</script> 
<script>
  function load_new_citys(obj){
    var thestate = obj.value || '';
    var citySelect = document.getElementById('get_cities_data');
    if(!citySelect) return;
    if(!thestate){ citySelect.innerHTML = '<option value="">Select City</option>'; return; }
    fetch('<?= base_url("ynaps_load/load_city?state=") ?>'+thestate)
      .then(function(r){ return r.text(); })
      .then(function(html){ citySelect.innerHTML = html; })
      .catch(function(){ citySelect.innerHTML = '<option value="">Select City</option>'; });
}
</script> 
          </div>
        </div>
      </div>
    </div>
  </div>
</main>