<!DOCTYPE html>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Banner Mind - Login">
    <meta name="keywords" content="banner mind, login">
    <meta name="author" content="Banner Mind">
    <link rel="icon" href="<?= base_url('assets/avator/') ?>favicon.png" type="image/x-icon">
    <title>Login - Banner Mind</title>
    <link rel="apple-touch-icon" href=<?= base_url('assets/avator/') ?>favicon.png">
    <meta name="title-color" content="#00162E">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black">
    <meta name="apple-mobile-web-app-title" content="Banner Mind">
    <meta name="msapplication-TileImage" content="<?= base_url('assets/avator/') ?>favicon.png">
    <meta name="msapplication-TileColor" content="#FFFFFF">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">

    <!-- Google font css -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Lato:ital,wght@0,100;0,300;0,400;0,700;0,900;1,100;1,300;1,400;1,700;1,900&display=swap">

    <!-- Bootstrap css -->
    <link id="rtl-link" rel="stylesheet" type="text/css" href="<?= base_url('assets/theme/v1/social-app/assets/css/vendors/bootstrap/bootstrap.min.css') ?>">

    <!-- Iconsax css -->
    <link rel="stylesheet" type="text/css" href="<?= base_url('assets/theme/v1/social-app/assets/css/iconsax.css') ?>">

    <!-- Iconly css -->
    <link rel="stylesheet" type="text/css" href="<?= base_url('assets/theme/v1/social-app/assets/css/iconly.css') ?>">

    <!-- Style css -->
    <link id="change-link" rel="stylesheet" type="text/css" href="<?= base_url('assets/theme/v1/social-app/assets/css/style.css') ?>">
  
    <style>
        /* Ensure screenshots work - allow all interactions */
        * {
            -webkit-user-select: auto !important;
            -moz-user-select: auto !important;
            -ms-user-select: auto !important;
            user-select: auto !important;
        }
        body {
            -webkit-user-select: auto !important;
            -moz-user-select: auto !important;
            -ms-user-select: auto !important;
            user-select: auto !important;
        }
        .login-logo-container {
            text-align: center;
            padding: 50px 15px 20px;
        }
        .login-logo {
            max-width: 150px;
            height: auto;
            object-fit: contain;
        }
        .ecommerce-auth-title {
            margin-top: 20px !important;
        }
        @media (max-width: 600px) {
            .ecommerce-auth-title {
                padding-top: 20px !important;
                margin-top: 20px !important;
            }
        }
        .password-toggle-wrapper {
            position: relative;
        }
        .password-toggle-btn {
            position: absolute;
            right: 12px;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            cursor: pointer;
            padding: 8px;
            color: #666;
            font-size: 20px;
            z-index: 100;
            display: flex;
            align-items: center;
            justify-content: center;
            width: 32px;
            height: 32px;
            line-height: 1;
        }
        .password-toggle-btn:hover {
            color: #333;
        }
        .password-toggle-btn i {
            display: inline-block;
            width: 20px;
            height: 20px;
        }
        .password-toggle-wrapper .input-text {
            padding-right: 50px;
        }
        /* Professional Bright Colors for Buttons - Matching Black & White Logo */
        .btn.ecommerce-btn {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%) !important;
            border: none !important;
            color: #fff !important;
            font-weight: 600;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.4);
            transition: all 0.3s ease;
        }
        .btn.ecommerce-btn:hover {
            background: linear-gradient(135deg, #764ba2 0%, #667eea 100%) !important;
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(102, 126, 234, 0.5);
        }
    </style>
</head>

<body class="ecommerce lato-font">

    <!-- loader Start -->
    
    <!-- loader End -->

    <!-- login Start -->
    <div class="login-logo-container">
        <img src="<?= base_url('assets/avator/logo.png') ?>" alt="Logo" class="login-logo">
    </div>
    <div class="ecommerce-auth-title">
        <h2>Hey, Login Now</h2>
        <h3>Please login with your account to continue</h3>
    </div>

    <?php 
    $redirect_url = isset($_GET['redirect']) ? $_GET['redirect'] : base_url();
    ?>
    <form class="ecommerce-form" id="loginForm" onsubmit="return handleLoginForm(this);">
        <div class="custom-container">
            <div id="error_div" class="alert alert-danger" style="display:none;"></div>
            <div id="loder_div" style="display:none; text-align:center; padding:10px;">
                <img src="<?= base_url('assets/theme/v1/social-app/assets/images/gif/fashion.gif') ?>" style="width:50px; height:50px;">
            </div>

            <div class="form-group floating-label-input">
                <input class="input-text" type="email" id="email" name="email" placeholder="Email" required>
                <label class="form-check-label" for="email">Email</label>
            </div>

            <div class="form-group floating-label-input password-toggle-wrapper">
                <input class="input-text form-control" type="password" id="password" name="pass" placeholder="Password" required>
                <label class="form-check-label" for="password">Password</label>
                <button type="button" class="password-toggle-btn" onclick="togglePassword('password', this)" aria-label="Toggle password visibility">
                    <i class="iconsax" data-icon="eye"></i>
                    <span class="eye-icon-fallback" style="display: none;">👁️</span>
                </button>
            </div>
            <!-- <a href="<?= base_url('index.php/password') ?>" class="forgot">Forgot password?</a> -->

            <input type="hidden" name="redirect_url" value="<?= $redirect_url ?>">
            <button type="submit" class="btn ecommerce-btn w-100 mt-5">Login</button>

            <h5 class="content-color fw-medium mt-3 text-center" style="padding-bottom: 10px; margin-bottom: 0;"> I don't have an account
                <a href="<?= base_url('index.php/signup') ?>" class="text-decoration-underline link-offset-2">Sign up</a>
            </h5>
        </div>

     
       
    </form>
    <!-- login End -->

    <!-- jQuery -->
    <script src="<?= base_url('assets/js/jquery-3.3.1.min.js') ?>"></script>
    
    <!-- Bootstrap js-->
    <script src="<?= base_url('assets/theme/v1/social-app/assets/js/vendors/bootstrap/bootstrap.bundle.min.js') ?>"></script>

    <!-- template Settings js-->
    <script src="<?= base_url('assets/theme/v1/social-app/assets/js/template-setting.js') ?>"></script>

    <!-- script js-->
    <script src="<?= base_url('assets/theme/v1/social-app/assets/js/script.js') ?>"></script>

    <!-- SweetAlert -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>
    // Ensure loader is hidden when page loads
    document.addEventListener('DOMContentLoaded', function() {
        // Fallback: Hide loader after page loads (in case script.js doesn't work)
        setTimeout(function() {
            const loader = document.querySelector('.loader');
            if (loader) {
                loader.classList.add('hide');
                setTimeout(function() {
                    loader.remove();
                }, 800);
            }
        }, 500);
    });

    // Also use window load event as backup
    window.addEventListener('load', function() {
        setTimeout(function() {
            const loader = document.querySelector('.loader');
            if (loader && !loader.classList.contains('hide')) {
                loader.classList.add('hide');
                setTimeout(function() {
                    loader.remove();
                }, 800);
            }
        }, 500);
    });

    function togglePassword(inputId, btn) {
        const input = document.getElementById(inputId);
        const icon = btn.querySelector('i');
        const fallback = btn.querySelector('.eye-icon-fallback');
        
        if (input.type === 'password') {
            input.type = 'text';
            if (icon) icon.setAttribute('data-icon', 'eye-slash');
            if (fallback) fallback.textContent = '🙈';
        } else {
            input.type = 'password';
            if (icon) icon.setAttribute('data-icon', 'eye');
            if (fallback) fallback.textContent = '👁️';
        }
        
        // Trigger iconsax update if available
        if (typeof iconsax !== 'undefined') {
            iconsax.init();
        } else {
            // Fallback: Wait for iconsax to load
            setTimeout(function() {
                if (typeof iconsax !== 'undefined') {
                    iconsax.init();
                } else {
                    // Show fallback if iconsax not available
                    if (fallback) fallback.style.display = 'inline-block';
                    if (icon) icon.style.display = 'none';
                }
            }, 100);
        }
    }
    
    // Initialize iconsax after page load and check for fallback
    document.addEventListener('DOMContentLoaded', function() {
        setTimeout(function() {
            if (typeof iconsax !== 'undefined') {
                iconsax.init();
            } else {
                // Show fallback icons if iconsax not available
                document.querySelectorAll('.eye-icon-fallback').forEach(function(fallback) {
                    const icon = fallback.previousElementSibling;
                    if (icon && icon.tagName === 'I' && !icon.querySelector('svg')) {
                        fallback.style.display = 'inline-block';
                        if (icon) icon.style.display = 'none';
                    }
                });
            }
        }, 500);
    });
    
    // Ensure screenshots work - remove any blocking event listeners
    document.addEventListener('DOMContentLoaded', function() {
        // Remove any contextmenu blocking
        document.removeEventListener('contextmenu', function(e) { e.preventDefault(); });
        
        // Allow all keyboard shortcuts for screenshots
        document.addEventListener('keydown', function(e) {
            // Allow Print Screen and other screenshot shortcuts
            if (e.key === 'PrintScreen' || (e.ctrlKey && e.shiftKey && e.key === 'S')) {
                // Allow screenshot shortcuts
                return true;
            }
        }, true);
        
        // Ensure no CSS is blocking screenshots
        const style = document.createElement('style');
        style.textContent = `
            * {
                -webkit-user-select: auto !important;
                -moz-user-select: auto !important;
                -ms-user-select: auto !important;
                user-select: auto !important;
            }
        `;
        document.head.appendChild(style);
    });

    function handleLoginForm(form) {
        $("#error_div").hide().empty();
        $("#loder_div").show();
        
        $.ajax({
            type: 'POST',
            url: '<?= base_url('index.php/action/login') ?>',
            data: $(form).serialize(),
            success: function(data) {
                console.log('Login Response:', data);
                
                if($.trim(data) == 'YNAPS_SUCCESS' || $.trim(data) == 'YNAPS_SUCCESS22') {
                    var redirectUrl = '<?= $redirect_url ?>';
                    window.location.href = redirectUrl;
                }
                else if($.trim(data) == 'OTP_SENT') {
                    window.location.href = '<?= base_url('index.php/login_otp_verify') ?>';
                }
                else {
                    $("#error_div").html(data).show();
                    Swal.fire({
                        icon: 'error',
                        title: 'Login Failed',
                        text: data
                    });
                }
                $("#loder_div").hide();
            },
            error: function() {
                $("#error_div").html('An error occurred. Please try again.').show();
                $("#loder_div").hide();
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'An error occurred. Please try again.'
                });
            }
        });
        return false;
    }
    </script>

</body>

</html>
