<!DOCTYPE html>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Banner Mind - OTP Verification">
    <meta name="keywords" content="banner mind, otp, verification">
    <meta name="author" content="Banner Mind">
    <link rel="icon" href="<?= base_url('assets/avator/') ?>favicon.png" type="image/x-icon">
    <title>OTP Verification - Banner Mind</title>
    <link rel="apple-touch-icon" href="<?= base_url('assets/avator/') ?>favicon.png">
    <meta name="title-color" content="#00162E">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black">
    <meta name="apple-mobile-web-app-title" content="Banner Mind">
    <meta name="msapplication-TileImage" content="<?= base_url('assets/avator/') ?>favicon.png">
    <meta name="msapplication-TileColor" content="#FFFFFF">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">

    <!-- Google font css -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Lato:ital,wght@0,100;0,300;0,400;0,700;0,900;1,100;1,300;1,400;1,700;1,900&display=swap">

    <!-- Bootstrap css -->
    <link id="rtl-link" rel="stylesheet" type="text/css" href="<?= base_url('assets/theme/v1/social-app/assets/css/vendors/bootstrap/bootstrap.min.css') ?>">

    <!-- Iconsax css -->
    <link rel="stylesheet" type="text/css" href="<?= base_url('assets/theme/v1/social-app/assets/css/iconsax.css') ?>">

    <!-- Iconly css -->
    <link rel="stylesheet" type="text/css" href="<?= base_url('assets/theme/v1/social-app/assets/css/iconly.css') ?>">

    <!-- Style css -->
    <link id="change-link" rel="stylesheet" type="text/css" href="<?= base_url('assets/theme/v1/social-app/assets/css/style.css') ?>">
      
    <style>
        .login-logo-container {
            text-align: center;
            padding: 30px 15px 20px;
        }
        .login-logo {
            max-width: 150px;
            height: auto;
            object-fit: contain;
        }
        .otp-display {
            background: #e8f5e8;
            border: 2px solid #4caf50;
            border-radius: 8px;
            padding: 12px;
            text-align: center;
            margin-bottom: 20px;
        }
        .otp-display strong {
            color: #2e7d32;
            font-size: 16px;
        }
        .otp-display small {
            color: #666;
        }
        /* Professional Bright Colors for Buttons - Matching Black & White Logo */
        .btn.ecommerce-btn {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%) !important;
            border: none !important;
            color: #fff !important;
            font-weight: 600;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.4);
            transition: all 0.3s ease;
        }
        .btn.ecommerce-btn:hover {
            background: linear-gradient(135deg, #764ba2 0%, #667eea 100%) !important;
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(102, 126, 234, 0.5);
        }
    </style>
</head>

<body class="ecommerce lato-font">

    <!-- loader Start -->
    <div class="loader">
        <img src="<?= base_url('assets/theme/v1/social-app/assets/images/gif/fashion.gif') ?>" class="img-fluid" alt="ecommerce">
    </div>
    <!-- loader End -->

    <!-- OTP Verification Start -->
    <div class="login-logo-container">
        <img src="<?= base_url('assets/avator/logo.png') ?>" alt="Logo" class="login-logo">
    </div>
    <div class="ecommerce-auth-title">
        <h2>OTP Verification</h2>
        <h3>We have sent OTP on your phone</h3>
    </div>

    <form class="ecommerce-form" id="otpVerificationForm" onsubmit="return handleOTPVerification(this);">
        <div class="custom-container">
            <div id="error_div" class="alert alert-danger" style="display:none;"></div>
            <div id="loder_div" style="display:none; text-align:center; padding:10px;">
                <img src="<?= base_url('assets/theme/v1/social-app/assets/images/gif/fashion.gif') ?>" style="width:50px; height:50px;">
            </div>

            <!-- OTP Display Area -->
            <?php if (isset($_SESSION['login_otp_phone']) && $_SESSION['login_otp_phone'] != ''): ?>
                <div class="otp-display">
                    <strong>Testing OTP: <?= $_SESSION['login_otp_phone'] ?></strong>
                    <br>
                    <small>This OTP has been sent to your mobile number</small>
                </div>
            <?php elseif (isset($_SESSION['login_otp_email']) && $_SESSION['login_otp_email'] != ''): ?>
                <div class="otp-display">
                    <strong>OTP: <?= $_SESSION['login_otp_email'] ?></strong>
                    <br>
                    <small>This OTP has been sent to your email address</small>
                </div>
            <?php elseif (isset($_SESSION['signup_code_email']) && $_SESSION['signup_code_email'] != ''): ?>
                <div class="otp-display">
                    <strong>OTP: <?= $_SESSION['signup_code_email'] ?></strong>
                    <br>
                    <small>This OTP has been sent to your email and phone</small>
                    <?php if (isset($_SESSION['signup_user_type']) && $_SESSION['signup_user_type'] == 'teacher'): ?>
                        <br>
                        <small style="color: #007bff; font-weight: 500;">🎓 Teacher Account Verification</small>
                    <?php endif; ?>
                </div>
            <?php endif; ?>

            <div class="row">
                <div class="col-12">
                    <div class="form-group floating-label-input">
                        <input class="input-text" type="number" id="motp" name="motp" value="<?= @$_SESSION['login_otp_phone'] ?: @$_SESSION['login_otp_email'] ?: @$_SESSION['signup_code_email'] ?>" placeholder="Enter 4-digit OTP" required>
                        <label class="form-check-label" for="motp">OTP Code</label>
                    </div>
                </div>
            </div>

            <button type="submit" class="btn ecommerce-btn w-100 mt-5">Verify OTP</button>

        </div>

        <h6>
            <?php if (isset($_SESSION['signup_code_email']) && $_SESSION['signup_code_email'] != ''): ?>
                Already have an account? <a href="<?= base_url('index.php/login') ?>">Login</a>
            <?php else: ?>
                Don't have an account? <a href="<?= base_url('index.php/signup') ?>">Sign Up</a>
            <?php endif; ?>
        </h6>
    </form>
    <!-- OTP Verification End -->

    <!-- jQuery -->
    <script src="<?= base_url('assets/js/jquery-3.3.1.min.js') ?>"></script>
    
    <!-- Bootstrap js-->
    <script src="<?= base_url('assets/theme/v1/social-app/assets/js/vendors/bootstrap/bootstrap.bundle.min.js') ?>"></script>

    <!-- template Settings js-->
    <script src="<?= base_url('assets/theme/v1/social-app/assets/js/template-setting.js') ?>"></script>

    <!-- script js-->
    <script src="<?= base_url('assets/theme/v1/social-app/assets/js/script.js') ?>"></script>

    <!-- SweetAlert -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>
    // Ensure loader is hidden when page loads
    document.addEventListener('DOMContentLoaded', function() {
        // Fallback: Hide loader after page loads (in case script.js doesn't work)
        setTimeout(function() {
            const loader = document.querySelector('.loader');
            if (loader) {
                loader.classList.add('hide');
                setTimeout(function() {
                    loader.remove();
                }, 800);
            }
        }, 500);
    });

    // Also use window load event as backup
    window.addEventListener('load', function() {
        setTimeout(function() {
            const loader = document.querySelector('.loader');
            if (loader && !loader.classList.contains('hide')) {
                loader.classList.add('hide');
                setTimeout(function() {
                    loader.remove();
                }, 800);
            }
        }, 500);
    });

    function handleOTPVerification(form) {
        $("#error_div").hide().empty();
        $("#loder_div").show();

        $.ajax({
            type: 'POST',
            url: '<?= base_url('index.php/action/login_otp_verify') ?>',
            data: $(form).serialize(),
            success: function(data) {
                console.log('OTP Verification Response:', data);
                console.log('Trimmed response:', $.trim(data));

                if ($.trim(data) == 'YNAPS_SUCCESS' || $.trim(data) == 'YNAPS_SUCCESS22') {
                    // Check if there's a stored redirect URL
                    <?php if (isset($_SESSION['redirect_after_login']) && !empty($_SESSION['redirect_after_login'])): ?>
                        window.location.href = '<?= $_SESSION['redirect_after_login'] ?>';
                        <?php unset($_SESSION['redirect_after_login']); ?>
                    <?php else: ?>
                        window.location.href = '<?= base_url() ?>';
                    <?php endif; ?>
                } else if ($.trim(data) == 'COMPANY_SELECTION_REQUIRED') {
                    console.log('Redirecting to company/collection selection page');
                    window.location.href = '<?= base_url('index.php/main/select_company_collection') ?>';
                } else if ($.trim(data) == 'TEACHER_NEEDS_VIDEOS') {
                    console.log('Redirecting teacher to video upload page');
                    window.location.href = '<?= base_url('teacher-videos') ?>';
                } else {
                    // Show error in error div only (no SweetAlert)
                    $("#error_div").html(data).show();
                }
                $("#loder_div").hide();
            },
            error: function() {
                $("#error_div").html('An error occurred. Please try again.').show();
                $("#loder_div").hide();
            }
        });
        return false;
    }
    </script>

</body>

</html>
