<!-- header starts -->
<header class="header ecommerce-main-header">
    <div class="custom-container2">
        <div class="header-panel">
            <div class="header-top-content text-center">
                <a href="<?= base_url('index.php/profile') ?>" onclick="history.back()">
                    <i class="iconsax icon-btn" data-icon="chevron-left"></i>
                </a>
                <h3>My Gallery</h3>
            </div>
        </div>
    </div>
</header>
<!-- header end -->

<!-- gallery section starts -->
<section class="section-lg-t-space">
    <div class="custom-container">
        <!-- Upload Section -->
        <div class="upload-section mb-4">
            <div class="card">
                <div class="card-body">
                    <h5 class="mb-3">Upload Images</h5>
                    <form id="galleryUploadForm" enctype="multipart/form-data">
                        <div class="form-group">
                            <input type="file" id="galleryImages" name="gallery_images[]" multiple accept="image/*" class="form-control">
                            <small class="form-text text-muted">You can select multiple images at once</small>
                        </div>
                        
                        <!-- Image Preview Area -->
                        <div id="imagePreviewArea" class="mt-3" style="display:none;">
                            <h6 class="mb-2">Selected Images Preview:</h6>
                            <div id="previewContainer" class="row g-2"></div>
                        </div>
                        
                        <button type="submit" class="btn ecommerce-btn w-100 mt-3" id="uploadBtn">
                            <span id="uploadBtnText">Upload Images</span>
                            <span id="uploadLoader" style="display:none;">
                                <img src="<?= base_url('assets/theme/v1/social-app/assets/images/gif/fashion.gif') ?>" style="width:20px; height:20px; display:inline-block;">
                                Uploading...
                            </span>
                        </button>
                    </form>
                    <div id="uploadError" class="alert alert-danger mt-3" style="display:none;"></div>
                    <div id="uploadSuccess" class="alert alert-success mt-3" style="display:none;"></div>
                </div>
            </div>
        </div>

        <!-- Gallery Grid -->
        <?php if (isset($gallery_images) && !empty($gallery_images) && is_array($gallery_images) && count($gallery_images) > 0): ?>
            <div class="row g-3" id="galleryGrid">
                <?php foreach ($gallery_images as $image): ?>
                    <div class="col-6 col-md-4 col-lg-3 gallery-item" data-gallery-id="<?= $image['gallery_id'] ?>">
                        <div class="gallery-card position-relative">
                            <img src="<?= base_url('assets/mem/' . $_SESSION['yid'] . '/gallery/' . $image['gallery_image']) ?>" 
                                 alt="<?= htmlspecialchars($image['gallery_original_name'] ?: 'Gallery Image') ?>" 
                                 class="img-fluid w-100 gallery-image"
                                 style="height: 200px; object-fit: cover; border-radius: 8px; cursor: pointer;"
                                 onerror="this.src='<?= base_url('assets/theme/v1/social-app/assets/images/product/product-1.jpg') ?>'">
                            <button class="btn btn-sm btn-danger delete-image-btn" 
                                    data-gallery-id="<?= $image['gallery_id'] ?>"
                                    style="position: absolute; top: 5px; right: 5px; padding: 5px 10px; border-radius: 50%; width: 30px; height: 30px; display: flex; align-items: center; justify-content: center;">
                                <i class="iconsax" data-icon="trash" style="font-size: 14px;"></i>
                            </button>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php else: ?>
            <div class="text-center py-5">
                <i class="iconsax" data-icon="gallery" style="font-size: 64px; color: #ccc; margin-bottom: 20px;"></i>
                <h5>No Images Yet</h5>
                <p class="text-muted">Upload your first image to get started!</p>
            </div>
        <?php endif; ?>
    </div>
</section>
<!-- gallery section end -->

<!-- Image Preview Modal -->
<div class="modal fade" id="imagePreviewModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Image Preview</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body text-center">
                <img id="previewImage" src="" alt="Preview" class="img-fluid" style="max-height: 70vh;">
            </div>
        </div>
    </div>
</div>

<style>
.gallery-card {
    transition: transform 0.2s;
}
.gallery-card:hover {
    transform: scale(1.02);
}
.gallery-image {
    transition: opacity 0.2s;
}
.gallery-image:hover {
    opacity: 0.9;
}
.delete-image-btn {
    opacity: 0;
    transition: opacity 0.2s;
}
.gallery-card:hover .delete-image-btn {
    opacity: 1;
}
/* Professional Bright Colors for Buttons - Matching Black & White Logo */
.btn.ecommerce-btn {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%) !important;
    border: none !important;
    color: #fff !important;
    font-weight: 600;
    box-shadow: 0 4px 15px rgba(102, 126, 234, 0.4);
    transition: all 0.3s ease;
}
.btn.ecommerce-btn:hover {
    background: linear-gradient(135deg, #764ba2 0%, #667eea 100%) !important;
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(102, 126, 234, 0.5);
}
</style>

<script>
$(document).ready(function() {
    var isUploading = false; // Prevent duplicate uploads
    
    // Show image preview when files are selected
    $('#galleryImages').on('change', function() {
        var files = this.files;
        var previewContainer = $('#previewContainer');
        previewContainer.empty();
        
        if (files.length > 0) {
            $('#imagePreviewArea').show();
            
            for (var i = 0; i < files.length; i++) {
                var file = files[i];
                if (file.type.match('image.*')) {
                    var reader = new FileReader();
                    reader.onload = (function(file) {
                        return function(e) {
                            var previewHtml = '<div class="col-4 col-md-3">' +
                                '<div class="preview-item position-relative">' +
                                '<img src="' + e.target.result + '" class="img-fluid w-100" style="height: 100px; object-fit: cover; border-radius: 4px; border: 2px solid #ddd;">' +
                                '<small class="d-block text-center mt-1" style="font-size: 10px; overflow: hidden; text-overflow: ellipsis; white-space: nowrap;">' + file.name + '</small>' +
                                '</div>' +
                                '</div>';
                            previewContainer.append(previewHtml);
                        };
                    })(file);
                    reader.readAsDataURL(file);
                }
            }
        } else {
            $('#imagePreviewArea').hide();
        }
    });
    
    // Handle image upload
    $('#galleryUploadForm').on('submit', function(e) {
        e.preventDefault();
        
        // Prevent duplicate submissions
        if (isUploading) {
            return false;
        }
        
        var files = $('#galleryImages')[0].files;
        
        if (files.length === 0) {
            $('#uploadError').html('Please select at least one image.').show();
            return false;
        }
        
        // Create FormData and add files
        var formData = new FormData();
        for (var i = 0; i < files.length; i++) {
            formData.append('gallery_images[]', files[i]);
        }
        
        isUploading = true;
        
        $('#uploadBtn').prop('disabled', true);
        $('#uploadBtnText').hide();
        $('#uploadLoader').show();
        $('#uploadError').hide();
        $('#uploadSuccess').hide();
        
        $.ajax({
            url: '<?= base_url('index.php/action/upload_gallery_images') ?>',
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                console.log('Upload Response:', response);
                var data = typeof response === 'string' ? JSON.parse(response) : response;
                
                if (data.success) {
                    $('#uploadSuccess').html(data.message || 'Images uploaded successfully!').show();
                    $('#galleryUploadForm')[0].reset();
                    $('#imagePreviewArea').hide();
                    $('#previewContainer').empty();
                    
                    // Reload page after 1 second to show new images
                    setTimeout(function() {
                        window.location.reload();
                    }, 1000);
                } else {
                    $('#uploadError').html(data.message || 'Upload failed. Please try again.').show();
                }
                
                isUploading = false;
                $('#uploadBtn').prop('disabled', false);
                $('#uploadBtnText').show();
                $('#uploadLoader').hide();
            },
            error: function(xhr, status, error) {
                console.error('Upload Error:', error);
                $('#uploadError').html('An error occurred. Please try again.').show();
                isUploading = false;
                $('#uploadBtn').prop('disabled', false);
                $('#uploadBtnText').show();
                $('#uploadLoader').hide();
            }
        });
        
        return false;
    });
    
    // Handle image preview on click
    $('.gallery-image').on('click', function() {
        var imageSrc = $(this).attr('src');
        $('#previewImage').attr('src', imageSrc);
        var modal = new bootstrap.Modal(document.getElementById('imagePreviewModal'));
        modal.show();
    });
    
    // Handle delete image
    $('.delete-image-btn').on('click', function(e) {
        e.stopPropagation();
        var galleryId = $(this).data('gallery-id');
        var $galleryItem = $(this).closest('.gallery-item');
        
        if (confirm('Are you sure you want to delete this image?')) {
            $.ajax({
                url: '<?= base_url('index.php/action/delete_gallery_image') ?>',
                type: 'POST',
                data: { gallery_id: galleryId },
                success: function(response) {
                    var data = typeof response === 'string' ? JSON.parse(response) : response;
                    if (data.success) {
                        $galleryItem.fadeOut(300, function() {
                            $(this).remove();
                            // Check if gallery is empty
                            if ($('#galleryGrid .gallery-item').length === 0) {
                                location.reload();
                            }
                        });
                    } else {
                        alert(data.message || 'Failed to delete image.');
                    }
                },
                error: function() {
                    alert('An error occurred. Please try again.');
                }
            });
        }
    });
});
</script>

