<link rel="stylesheet" type="text/css" href="<?= base_url() ?>assets/theme/v2/assets/css/style.min.css">
<!-- Start of Main -->
<main class="main">
    <!-- Start of Page Content -->
    <div class="page-content">
        <div class="container">
            <!-- Start of Breadcrumb -->
            <nav class="breadcrumb-nav">
                <div class="container">
                    <ul class="breadcrumb">
                        <li><a href="<?= base_url() ?>">Home</a></li>
                        <li>On Road Price</li>
                    </ul>
                </div>
            </nav>
            <!-- End of Breadcrumb -->

            <!-- Start of On Road Price Form Section -->
            <div class="on-road-price-section">
                <div class="row justify-content-center">
                    <div class="col-lg-8 col-md-10">
                        <!-- Clean White Form Card -->
                        <div class="price-calculator-card">
                            <!-- Form Header -->
                            <div class="form-header">
                                <div class="row align-items-center">
                                    <div class="col-md-8">
                                        <h2 class="form-title">On Road Price Calculator</h2>
                                    </div>
                                    <div class="col-md-4 text-md-end">
                                        <p class="form-subtitle">Fill in the details below to get accurate on-road pricing</p>
                                    </div>
                                </div>
                            </div>

                            <!-- Form Content -->
                            <form class="price-calculator-form" method="post" action="<?= base_url('action/submit_form_lead') ?>" onsubmit="return uploadandform('<?= base_url('action/submit_form_lead') ?>','post',this,'image_name','progress_value_sc','prog_valie_text','Show_Errors_987','loader_post_upload','1','uni_loader_prog_status');">
                                <input type="hidden" name="form_type" value="onroad_price"/>
                                <!-- Row 1: Brand and Model (dynamic) -->
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label for="brand" class="form-label">Brand *</label>
                                        <select class="form-control" id="brand" name="brand" required>
                                            <option value="">Select Brand</option>
                                            <?php
                                            $brands = $this->db->query("SELECT stg_tgid, stg_name FROM yn_site_tags WHERE stg_type='Brands' ORDER BY stg_name ASC")->result_array();
                                            foreach($brands as $b){ echo '<option value="'.$b['stg_tgid'].'">'.htmlspecialchars($b['stg_name']).'</option>'; }
                                            ?>
                                        </select>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label for="model" class="form-label">Model *</label>
                                        <select class="form-control" id="model" name="model" required>
                                            <option value="">Select Model</option>
                                        </select>
                                    </div>
                                </div>

                                <!-- Row 2: Name and Mobile -->
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label for="name" class="form-label">Name *</label>
                                        <input type="text" class="form-control" id="name" name="name" placeholder="Enter Your Name" required>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label for="mobile" class="form-label">Mobile Number *</label>
                                        <input type="tel" class="form-control" id="mobile" name="mobile" placeholder="Enter Mobile Number" required>
                                    </div>
                                </div>

                                <!-- Row 3: State (dynamic like add_product) -->
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label for="state" class="form-label">State *</label>
                                        <select class="form-control" id="state" name="state" required onchange="load_new_citys(this)">
                                            <option value="">Select State</option>
                                            <?php $states = $this->db->query("SELECT * FROM yn_site_states WHERE status = 1 ORDER BY state_name ASC")->result_array();
                                            foreach($states as $st){ echo '<option value="'.$st['state_id'].'">'.htmlspecialchars($st['state_name']).'</option>'; } ?>
                                        </select>
                                    </div>
                                    <div class="form-group col-md-6">
                                    <label for="city" class="form-label">City *</label>
                                        <select class="form-control" id="get_cities_data" name="city" required>
                                            <option value="">Select City</option>
                                        </select>
                                    </div>
                                </div>
                                <!-- Loan Checkbox -->
                                <div class="form-row">
                                    <div class="form-group col-12">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="loan_offers" name="loan_offers" checked>
                                            <label class="form-check-label" for="loan_offers">
                                                Also, looking for loan offers?
                                            </label>
                                        </div>
                                    </div>
                                </div>

                                <!-- Submit Button -->
                                <div class="form-row">
                                    <div class="form-group col-12">
                                        <button type="submit" class="btn btn-primary btn-submit">
                                            CHECK ON ROAD PRICE
                                        </button>
                                    </div>
                                </div>

                                <!-- Disclaimer -->
                                <div class="form-row">
                                    <div class="form-group col-12">
                                        <p class="disclaimer-text">
                                            By proceeding ahead you expressly agree to the 
                                            <a href="<?= base_url('terms') ?>" class="terms-link">terms and conditions*</a>
                                        </p>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <!-- End of On Road Price Form Section -->
        </div>
    </div>
    <!-- End of Page Content -->
</main>
<!-- End of Main -->

<style>
/* Clean and Professional On Road Price Form Styles */
.on-road-price-section {
    padding: 60px 0;
    background: #f8f9fa;
    min-height: 100vh;
}

.price-calculator-card {
    background: #ffffff;
    border-radius: 12px;
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
    padding: 40px;
    border: 1px solid #e9ecef;
}

/* Form Header */
.form-header {
    margin-bottom: 30px;
    padding-bottom: 20px;
    border-bottom: 1px solid #e9ecef;
}

.form-title {
    color: #2c3e50;
    font-size: 28px;
    font-weight: 700;
    margin: 0;
    line-height: 1.2;
}

.form-subtitle {
    color: #6c757d;
    font-size: 14px;
    margin: 0;
    line-height: 1.4;
}

/* Form Rows */
.form-row {
    display: flex;
    flex-wrap: wrap;
    margin-right: -10px;
    margin-left: -10px;
    margin-bottom: 20px;
}

.form-group {
    padding-right: 10px;
    padding-left: 10px;
    flex: 1;
}

/* Form Labels */
.form-label {
    display: block;
    margin-bottom: 8px;
    color: #2c3e50;
    font-weight: 600;
    font-size: 14px;
}

/* Form Controls */
.form-control {
    display: block;
    width: 100%;
    padding: 12px 16px;
    font-size: 14px;
    line-height: 1.5;
    color: #495057;
    background-color: #fff;
    background-clip: padding-box;
    border: 2px solid #e9ecef;
    border-radius: 8px;
    transition: border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;
    height: 48px;
}

.form-control:focus {
    color: #495057;
    background-color: #fff;
    border-color: #667eea;
    outline: 0;
    box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
}

.form-control::placeholder {
    color: #adb5bd;
    opacity: 1;
}

/* Select Dropdown Styling */
.form-control[type="select"] {
    background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' fill='none' viewBox='0 0 20 20'%3e%3cpath stroke='%236b7280' stroke-linecap='round' stroke-linejoin='round' stroke-width='1.5' d='m6 8 4 4 4-4'/%3e%3c/svg%3e");
    background-position: right 12px center;
    background-repeat: no-repeat;
    background-size: 16px 12px;
    padding-right: 40px;
}

/* Checkbox Styling */
.form-check {
    display: flex;
    align-items: center;
    margin-bottom: 0;
}

.form-check-input {
    width: 20px;
    height: 20px;
    margin-right: 12px;
    border: 2px solid #e9ecef;
    border-radius: 4px;
    background-color: #fff;
    cursor: pointer;
}

.form-check-input:checked {
    background-color: #667eea;
    border-color: #667eea;
}

.form-check-label {
    color: #2c3e50;
    font-weight: 500;
    font-size: 15px;
    cursor: pointer;
    margin: 0;
}

/* Submit Button */
.btn-submit {
    width: 100%;
    height: 56px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border: none;
    border-radius: 8px;
    color: #ffffff;
    font-size: 16px;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    transition: all 0.3s ease;
    cursor: pointer;
}

.btn-submit:hover {
    background: linear-gradient(135deg, #5a6fd8 0%, #6a4190 100%);
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(102, 126, 234, 0.3);
}

.btn-submit:active {
    transform: translateY(0);
}

/* Disclaimer */
.disclaimer-text {
    text-align: center;
    color: #6c757d;
    font-size: 12px;
    margin: 20px 0 0 0;
    line-height: 1.4;
}

.terms-link {
    color: #667eea;
    text-decoration: underline;
    font-weight: 500;
}

.terms-link:hover {
    color: #5a6fd8;
    text-decoration: none;
}

/* Responsive Design */
@media (max-width: 768px) {
    .price-calculator-card {
        padding: 25px;
        margin: 20px 0;
    }
    
    .form-title {
        font-size: 24px;
    }
    
    .form-subtitle {
        text-align: left !important;
        margin-top: 10px;
    }
    
    .form-row {
        margin-bottom: 15px;
    }
    
    .form-group {
        margin-bottom: 15px;
    }
    
    .btn-submit {
        height: 50px;
        font-size: 15px;
    }
}

@media (max-width: 576px) {
    .price-calculator-card {
        padding: 20px;
    }
    
    .form-title {
        font-size: 22px;
    }
    
    .form-control {
        height: 44px;
        font-size: 14px;
    }
}

/* Loading State */
.btn-submit.loading {
    position: relative;
    pointer-events: none;
}

.btn-submit.loading::after {
    content: '';
    position: absolute;
    width: 20px;
    height: 20px;
    top: 50%;
    left: 50%;
    margin-left: -10px;
    margin-top: -10px;
    border: 2px solid transparent;
    border-top: 2px solid #ffffff;
    border-radius: 50%;
    animation: spin 1s linear infinite;
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

/* Form Validation Styles */
.form-control.is-invalid {
    border-color: #dc3545;
}

.form-control.is-valid {
    border-color: #28a745;
}

.invalid-feedback {
    display: block;
    width: 100%;
    margin-top: 5px;
    font-size: 12px;
    color: #dc3545;
}
</style>

<!-- Simple unified form overrides to match Insurance/Dealer Inquiry -->
<style>
  .on-road-price-section{padding:20px 0 !important;background:#fff !important}
  .price-calculator-card{background:#fff !important;border:1px solid #e6ebf2 !important;border-radius:12px !important;box-shadow:none !important;padding:16px !important}
  .form-header{display:none !important}
  .form-label{font-weight:600 !important;color:#2b3a55 !important;font-size:13px !important;margin-bottom:6px !important}
  .form-control{height:44px !important;border:1px solid #dfe5ee !important;border-radius:6px !important;box-shadow:none !important}
  .btn-submit{width:100% !important;height:34px !important;background:#153a63 !important;border:none !important;border-radius:6px !important;color:#fff !important;letter-spacing:0 !important;text-transform:none !important;display:inline-flex !important;align-items:center !important;justify-content:center !important}
  .btn-submit:hover{background:#1b3a6e !important;transform:none !important;box-shadow:none !important}
  .disclaimer-text{color:#5b6678 !important;font-size:12px !important;margin:10px 0 0 0 !important}
</style>

<script>
  // Populate city based on state (same flow as add_product)
  function load_new_citys(obj){
    var thestate = obj.value || '';
    if(!thestate){ document.getElementById('get_cities_data').innerHTML='<option value="">Select City</option>'; return; }
    fetch('<?= base_url("ynaps_load/load_city?state=") ?>'+thestate)
      .then(r=>r.text())
      .then(html=>{ document.getElementById('get_cities_data').innerHTML = html; })
      .catch(()=>{ document.getElementById('get_cities_data').innerHTML='<option value="">Select City</option>'; });
  }

  // Load models when brand selected (from products table grouped by model for selected brand)
  document.getElementById('brand').addEventListener('change', function(){
    var brandId = this.value;
    var modelSelect = document.getElementById('model');
    modelSelect.innerHTML = '<option value="">Select Model</option>';
    if(!brandId) return;
    fetch('<?= base_url('action/compare_models?brand_id=') ?>'+brandId)
      .then(r=>r.json())
      .then(function(models){
        models.forEach(function(m){
          var opt = document.createElement('option');
          opt.value = m.id || m.name; // API returns id/name; either is fine for selection
          opt.textContent = m.name;
          modelSelect.appendChild(opt);
        });
    });
});
</script> 

