<!DOCTYPE html>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Banner Mind - Password Reset">
    <meta name="keywords" content="banner mind, password reset">
    <meta name="author" content="Banner Mind">
    <link rel="icon" href="<?= base_url('assets/avator/') ?>favicon.png" type="image/x-icon">
    <title>Password Reset - Banner Mind</title>
    <link rel="apple-touch-icon" href="<?= base_url('assets/avator/') ?>favicon.png">
    <meta name="title-color" content="#00162E">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black">
    <meta name="apple-mobile-web-app-title" content="Banner Mind">
    <meta name="msapplication-TileImage" content="<?= base_url('assets/avator/') ?>favicon.png">
    <meta name="msapplication-TileColor" content="#FFFFFF">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">

    <!-- Google font css -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Lato:ital,wght@0,100;0,300;0,400;0,700;0,900;1,100;1,300;1,400;1,700;1,900&display=swap">

    <!-- Bootstrap css -->
    <link id="rtl-link" rel="stylesheet" type="text/css" href="<?= base_url('assets/theme/v1/social-app/assets/css/vendors/bootstrap/bootstrap.min.css') ?>">

    <!-- Iconsax css -->
    <link rel="stylesheet" type="text/css" href="<?= base_url('assets/theme/v1/social-app/assets/css/iconsax.css') ?>">

    <!-- Iconly css -->
    <link rel="stylesheet" type="text/css" href="<?= base_url('assets/theme/v1/social-app/assets/css/iconly.css') ?>">

    <!-- Style css -->
    <link id="change-link" rel="stylesheet" type="text/css" href="<?= base_url('assets/theme/v1/social-app/assets/css/style.css') ?>">
    
    <style>
        /* Ensure screenshots work - allow all interactions */
        * {
            -webkit-user-select: auto !important;
            -moz-user-select: auto !important;
            -ms-user-select: auto !important;
            user-select: auto !important;
        }
        body {
            -webkit-user-select: auto !important;
            -moz-user-select: auto !important;
            -ms-user-select: auto !important;
            user-select: auto !important;
        }
        .login-logo-container {
            text-align: center;
            padding: 50px 15px 20px;
        }
        .login-logo {
            max-width: 150px;
            height: auto;
            object-fit: contain;
        }
        .ecommerce-auth-title {
            margin-top: 20px !important;
        }
        @media (max-width: 600px) {
            .ecommerce-auth-title {
                padding-top: 20px !important;
                margin-top: 20px !important;
            }
        }
        /* Professional Bright Colors for Buttons - Matching Black & White Logo */
        .btn.ecommerce-btn {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%) !important;
            border: none !important;
            color: #fff !important;
            font-weight: 600;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.4);
            transition: all 0.3s ease;
        }
        .btn.ecommerce-btn:hover {
            background: linear-gradient(135deg, #764ba2 0%, #667eea 100%) !important;
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(102, 126, 234, 0.5);
        }
        .forgot-password-link {
            text-align: center;
            margin-top: 15px;
        }
        .forgot-password-link a {
            color: var(--theme-color, #007bff);
            text-decoration: none;
            font-size: 14px;
            font-weight: 500;
        }
        .forgot-password-link a:hover {
            text-decoration: underline;
        }
    </style>
</head>

<body class="ecommerce lato-font">

    <!-- loader Start -->
    <div class="loader">
        <img src="<?= base_url('assets/theme/v1/social-app/assets/images/gif/fashion.gif') ?>" class="img-fluid" alt="ecommerce">
    </div>
    <!-- loader End -->

    <!-- Password Reset Start -->
    <div class="login-logo-container">
        <img src="<?= base_url('assets/avator/logo.png') ?>" alt="Logo" class="login-logo">
    </div>
    <div class="ecommerce-auth-title">
        <h2>Reset Password</h2>
        <h3>Enter your email to receive a password reset link</h3>
    </div>

    <form class="ecommerce-form" method="post" action="<?=base_url('index.php/action/password_reset');?>" onsubmit="return handlePasswordResetForm(this);">
        <div class="custom-container">
            <div id="error_div" class="alert alert-danger" style="display:none;"></div>
            <div id="loder_div" style="display:none; text-align:center; padding:10px;">
                <img src="<?= base_url('assets/theme/v1/social-app/assets/images/gif/fashion.gif') ?>" style="width:50px; height:50px;">
            </div>

            <div class="form-group floating-label-input">
                <input class="input-text" type="email" id="reset_email" name="email" placeholder="Email" required>
                <label class="form-check-label" for="reset_email">Email</label>
            </div>

            <div class="form-group">
                <?=get_captcha('caprght_oplkion','sign9_form_90_feed');?>
            </div>

            <button type="submit" class="btn ecommerce-btn w-100 mt-5">Send Reset Link</button>

            <div class="forgot-password-link">
                <h5 class="content-color fw-medium mt-3 text-center" style="padding-bottom: 10px; margin-bottom: 0;">
                    Remember your password? <a href="<?= base_url('index.php/login') ?>" class="text-decoration-underline link-offset-2">Login</a>
                </h5>
                <h5 class="content-color fw-medium mt-2 text-center" style="padding-bottom: 10px; margin-bottom: 0;">
                    Don't have an account? <a href="<?= base_url('index.php/signup') ?>" class="text-decoration-underline link-offset-2">Sign up</a>
                </h5>
            </div>
        </div>
    </form>
    <!-- Password Reset End -->

    <!-- jQuery -->
    <script src="<?= base_url('assets/js/jquery-3.3.1.min.js') ?>"></script>
    
    <!-- Bootstrap js-->
    <script src="<?= base_url('assets/theme/v1/social-app/assets/js/vendors/bootstrap/bootstrap.bundle.min.js') ?>"></script>

    <!-- template Settings js-->
    <script src="<?= base_url('assets/theme/v1/social-app/assets/js/template-setting.js') ?>"></script>

    <!-- script js-->
    <script src="<?= base_url('assets/theme/v1/social-app/assets/js/script.js') ?>"></script>

    <!-- SweetAlert -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>
    // Ensure loader is hidden when page loads
    document.addEventListener('DOMContentLoaded', function() {
        setTimeout(function() {
            const loader = document.querySelector('.loader');
            if (loader) {
                loader.classList.add('hide');
                setTimeout(function() {
                    loader.remove();
                }, 800);
            }
        }, 500);
    });

    window.addEventListener('load', function() {
        setTimeout(function() {
            const loader = document.querySelector('.loader');
            if (loader && !loader.classList.contains('hide')) {
                loader.classList.add('hide');
                setTimeout(function() {
                    loader.remove();
                }, 800);
            }
        }, 500);
    });

    function handlePasswordResetForm(form) {
        $("#error_div").hide().empty();
        $("#loder_div").show();
        
        $.ajax({
            type: 'POST',
            url: '<?= base_url('index.php/action/password_reset') ?>',
            data: $(form).serialize(),
            success: function(data) {
                console.log('Password Reset Response:', data);
                
                $("#loder_div").hide();
                
                if($.trim(data) == 'YNAPS_SUCCESS' || $.trim(data) == 'YNAPS_SUCCESS22') {
                    Swal.fire({
                        icon: 'success',
                        title: 'Email Sent!',
                        text: 'Password reset link has been sent to your email. Please check your inbox.',
                        confirmButtonText: 'OK'
                    }).then(function() {
                        window.location.href = '<?= base_url('index.php/login') ?>';
                    });
                } else {
                    $("#error_div").html(data).show();
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: data || 'Failed to send reset link. Please try again.'
                    });
                }
            },
            error: function() {
                $("#loder_div").hide();
                $("#error_div").html('An error occurred. Please try again.').show();
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'An error occurred. Please try again.'
                });
            }
        });
        return false;
    }
    </script>

</body>

</html>
