<!DOCTYPE html>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Banner Mind - Reset Password">
    <meta name="keywords" content="banner mind, reset password">
    <meta name="author" content="Banner Mind">
    <link rel="icon" href="<?= base_url('assets/avator/') ?>favicon.png" type="image/x-icon">
    <title>Reset Password - Banner Mind</title>
    <link rel="apple-touch-icon" href="<?= base_url('assets/avator/') ?>favicon.png">
    <meta name="title-color" content="#00162E">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black">
    <meta name="apple-mobile-web-app-title" content="Banner Mind">
    <meta name="msapplication-TileImage" content="<?= base_url('assets/avator/') ?>favicon.png">
    <meta name="msapplication-TileColor" content="#FFFFFF">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">

    <!-- Google font css -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Lato:ital,wght@0,100;0,300;0,400;0,700;0,900;1,100;1,300;1,400;1,700;1,900&display=swap">

    <!-- Bootstrap css -->
    <link id="rtl-link" rel="stylesheet" type="text/css" href="<?= base_url('assets/theme/v1/social-app/assets/css/vendors/bootstrap/bootstrap.min.css') ?>">

    <!-- Iconsax css -->
    <link rel="stylesheet" type="text/css" href="<?= base_url('assets/theme/v1/social-app/assets/css/iconsax.css') ?>">

    <!-- Iconly css -->
    <link rel="stylesheet" type="text/css" href="<?= base_url('assets/theme/v1/social-app/assets/css/iconly.css') ?>">

    <!-- Style css -->
    <link id="change-link" rel="stylesheet" type="text/css" href="<?= base_url('assets/theme/v1/social-app/assets/css/style.css') ?>">
    
    <style>
        /* Ensure screenshots work - allow all interactions */
        * {
            -webkit-user-select: auto !important;
            -moz-user-select: auto !important;
            -ms-user-select: auto !important;
            user-select: auto !important;
        }
        body {
            -webkit-user-select: auto !important;
            -moz-user-select: auto !important;
            -ms-user-select: auto !important;
            user-select: auto !important;
        }
        .login-logo-container {
            text-align: center;
            padding: 50px 15px 20px;
        }
        .login-logo {
            max-width: 150px;
            height: auto;
            object-fit: contain;
        }
        .ecommerce-auth-title {
            margin-top: 20px !important;
        }
        @media (max-width: 600px) {
            .ecommerce-auth-title {
                padding-top: 20px !important;
                margin-top: 20px !important;
            }
        }
        .password-toggle-wrapper {
            position: relative;
        }
        .password-toggle-btn {
            position: absolute;
            right: 12px;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            cursor: pointer;
            padding: 8px;
            color: #666;
            font-size: 20px;
            z-index: 100;
            display: flex;
            align-items: center;
            justify-content: center;
            width: 32px;
            height: 32px;
            line-height: 1;
        }
        .password-toggle-btn:hover {
            color: #333;
        }
        .password-toggle-btn i {
            display: inline-block;
            width: 20px;
            height: 20px;
        }
        .password-toggle-wrapper .input-text {
            padding-right: 50px;
        }
        /* Professional Bright Colors for Buttons - Matching Black & White Logo */
        .btn.ecommerce-btn {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%) !important;
            border: none !important;
            color: #fff !important;
            font-weight: 600;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.4);
            transition: all 0.3s ease;
        }
        .btn.ecommerce-btn:hover {
            background: linear-gradient(135deg, #764ba2 0%, #667eea 100%) !important;
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(102, 126, 234, 0.5);
        }
    </style>
</head>

<body class="ecommerce lato-font">

    <!-- loader Start -->
    <div class="loader">
        <img src="<?= base_url('assets/theme/v1/social-app/assets/images/gif/fashion.gif') ?>" class="img-fluid" alt="ecommerce">
                                    </div>
    <!-- loader End -->

    <!-- Reset Password Start -->
    <div class="login-logo-container">
        <img src="<?= base_url('assets/avator/logo.png') ?>" alt="Logo" class="login-logo">
                                </div>
    <div class="ecommerce-auth-title">
        <h2>Reset Your Password</h2>
        <h3>Enter your new password below</h3>
                            </div>

    <form class="ecommerce-form" method="post" action="<?=base_url('index.php/action/password_reset2');?>" onsubmit="return handlePasswordReset2Form(this);">
        <div class="custom-container">
            <div id="error_div" class="alert alert-danger" style="display:none;"></div>
            <div id="loder_div" style="display:none; text-align:center; padding:10px;">
                <img src="<?= base_url('assets/theme/v1/social-app/assets/images/gif/fashion.gif') ?>" style="width:50px; height:50px;">
                                    </div>

            <input type="hidden" name="e" value="<?= isset($e) ? htmlspecialchars($e) : '' ?>">

            <div class="form-group floating-label-input password-toggle-wrapper">
                <input class="input-text form-control" type="password" id="new_password" name="pass1" placeholder="New Password" required>
                <label class="form-check-label" for="new_password">New Password</label>
                <button type="button" class="password-toggle-btn" onclick="togglePassword('new_password', this)" aria-label="Toggle password visibility">
                    <i class="iconsax" data-icon="eye"></i>
                    <span class="eye-icon-fallback" style="display: none;">👁️</span>
                </button>
                                </div>

            <div class="form-group floating-label-input password-toggle-wrapper">
                <input class="input-text form-control" type="password" id="confirm_password" name="pass2" placeholder="Confirm Password" required>
                <label class="form-check-label" for="confirm_password">Confirm Password</label>
                <button type="button" class="password-toggle-btn" onclick="togglePassword('confirm_password', this)" aria-label="Toggle password visibility">
                    <i class="iconsax" data-icon="eye"></i>
                    <span class="eye-icon-fallback" style="display: none;">👁️</span>
                </button>
                        </div>
                        
            <button type="submit" class="btn ecommerce-btn w-100 mt-5">Change Password</button>

            <h5 class="content-color fw-medium mt-3 text-center" style="padding-bottom: 10px; margin-bottom: 0;">
                Remember your password? <a href="<?= base_url('index.php/login') ?>" class="text-decoration-underline link-offset-2">Login</a>
            </h5>
                        </div>
                    </form>
    <!-- Reset Password End -->

    <!-- jQuery -->
    <script src="<?= base_url('assets/js/jquery-3.3.1.min.js') ?>"></script>
    
    <!-- Bootstrap js-->
    <script src="<?= base_url('assets/theme/v1/social-app/assets/js/vendors/bootstrap/bootstrap.bundle.min.js') ?>"></script>

    <!-- template Settings js-->
    <script src="<?= base_url('assets/theme/v1/social-app/assets/js/template-setting.js') ?>"></script>

    <!-- script js-->
    <script src="<?= base_url('assets/theme/v1/social-app/assets/js/script.js') ?>"></script>

    <!-- SweetAlert -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>
    // Ensure loader is hidden when page loads
    document.addEventListener('DOMContentLoaded', function() {
        setTimeout(function() {
            const loader = document.querySelector('.loader');
            if (loader) {
                loader.classList.add('hide');
                setTimeout(function() {
                    loader.remove();
                }, 800);
            }
        }, 500);
    });

    window.addEventListener('load', function() {
        setTimeout(function() {
            const loader = document.querySelector('.loader');
            if (loader && !loader.classList.contains('hide')) {
                loader.classList.add('hide');
                setTimeout(function() {
                    loader.remove();
                }, 800);
            }
        }, 500);
    });

    function togglePassword(inputId, btn) {
        const input = document.getElementById(inputId);
        const icon = btn.querySelector('i');
        const fallback = btn.querySelector('.eye-icon-fallback');
        
        if (input.type === 'password') {
            input.type = 'text';
            if (icon) icon.setAttribute('data-icon', 'eye-slash');
            if (fallback) fallback.textContent = '🙈';
        } else {
            input.type = 'password';
            if (icon) icon.setAttribute('data-icon', 'eye');
            if (fallback) fallback.textContent = '👁️';
        }
        
        // Trigger iconsax update if available
        if (typeof iconsax !== 'undefined') {
            iconsax.init();
        } else {
            setTimeout(function() {
                if (typeof iconsax !== 'undefined') {
                    iconsax.init();
                } else {
                    if (fallback) fallback.style.display = 'inline-block';
                    if (icon) icon.style.display = 'none';
                }
            }, 100);
        }
    }
    
    // Initialize iconsax after page load
    document.addEventListener('DOMContentLoaded', function() {
        setTimeout(function() {
            if (typeof iconsax !== 'undefined') {
                iconsax.init();
            } else {
                document.querySelectorAll('.eye-icon-fallback').forEach(function(fallback) {
                    const icon = fallback.previousElementSibling;
                    if (icon && icon.tagName === 'I' && !icon.querySelector('svg')) {
                        fallback.style.display = 'inline-block';
                        if (icon) icon.style.display = 'none';
                    }
                });
            }
        }, 500);
    });

    function handlePasswordReset2Form(form) {
        var pass1 = document.getElementById('new_password').value;
        var pass2 = document.getElementById('confirm_password').value;
        
        if (pass1 !== pass2) {
            Swal.fire({
                icon: 'error',
                title: 'Password Mismatch',
                text: 'Passwords do not match. Please try again.'
            });
            return false;
        }
        
        if (pass1.length < 6) {
            Swal.fire({
                icon: 'error',
                title: 'Password Too Short',
                text: 'Password must be at least 6 characters long.'
            });
            return false;
        }
        
        $("#error_div").hide().empty();
        $("#loder_div").show();
        
        $.ajax({
            type: 'POST',
            url: '<?= base_url('index.php/action/password_reset2') ?>',
            data: $(form).serialize(),
            success: function(data) {
                console.log('Password Reset2 Response:', data);
                
                $("#loder_div").hide();
                
                if($.trim(data) == 'YNAPS_SUCCESS' || $.trim(data) == 'YNAPS_SUCCESS22') {
                    Swal.fire({
                        icon: 'success',
                        title: 'Password Changed!',
                        text: 'Your password has been successfully changed. Redirecting to login...',
                        timer: 2000,
                        showConfirmButton: false,
                        timerProgressBar: true
                    }).then(function() {
                        window.location.href = '<?= base_url('index.php/login') ?>';
                    });
                } else {
                    $("#error_div").html(data).show();
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: data || 'Failed to change password. Please try again.'
                    });
                }
            },
            error: function() {
                $("#loder_div").hide();
                $("#error_div").html('An error occurred. Please try again.').show();
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'An error occurred. Please try again.'
                });
            }
        });
        return false;
    }
    </script>

</body>

</html>
