<style>
  .product-img-box {
    width: 100%;
    height: 180px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: #F5F5F5;
    border-radius: 16px 16px 0 0;
    overflow: hidden;
    border-bottom: 1px solid #f0f0f0;
  }

  .product-img-box img {
    max-width: 100%;
    max-height: 100%;
    object-fit: contain;
    object-position: center;
    display: block;
  }

  .product-card {
    border: none;

    box-shadow: 0 4px 24px 0 rgba(0, 0, 0, 0.07), 0 1.5px 4px 0 rgba(0, 0, 0, 0.04);
    transition: box-shadow 0.2s, transform 0.2s;
    background: #fafbfc;
    position: relative;
    /* padding-bottom: 18px; */
    margin-bottom: 8px;
    overflow: hidden;
    padding: 10px 10px;
    ;
  }

  /* .product-card:hover {
    box-shadow: 0 12px 32px 0 rgba(0,0,0,0.13), 0 3px 12px 0 rgba(0,0,0,0.08);
    transform: translateY(-4px) scale(1.02);
    z-index: 2;
} */
  .product-badge {
    font-size: 0.78rem;
    font-weight: 500;
    border-radius: 50px;
    padding: 0.25em 0.8em;
    margin-right: 0.3em;
    margin-bottom: 0.3em;
    display: inline-block;
    background: #e3f7e6;
    color: #1a7f37;
    border: none;
  }

  .product-badge.price {
    background: #fff3cd;
    color: #856404;
  }

  .card-body-pro {
    padding: 1.1rem 1.2rem 0.5rem 1.2rem;
  }

  .card-title-pro {
    font-size: 1.13rem;
    font-weight: 700;
    margin-bottom: 0.2rem;
    color: #222;
  }

  .card-price-pro {
    color: #0d6efd;
    font-size: 1.1rem;
    font-weight: 600;
    margin-bottom: 0.2rem;
  }

  .card-meta-pro {
    font-size: 0.97rem;
    color: #888;
    margin-bottom: 0.2rem;
  }

  .card-year-pro {
    font-size: 0.97rem;
    color: #888;
    font-weight: 500;
  }

  .book-btn-pro {
    width: 100%;

    padding: 10px 8px;
    font-weight: 600;
    font-size: 1rem;
    background: rgb(24, 68, 133);
    color: #fff;
    border: none;
    margin-top: 0.7rem;
    transition: background 0.18s;
  }

  .book-btn-pro:hover {
    background: #0b5ed7;
    color: #fff;
  }

  .category-title {
    font-size: 2rem;
    font-weight: 700;
    color: #184485;
    margin-bottom: 1.2rem;
    margin-top: 0.5rem;
    letter-spacing: 0.5px;
  }

  @media (min-width: 576px) {
    .product-card {
      margin-bottom: 32px;
    }
  }

  @media (max-width: 575.98px) {
    .product-card {
      margin-bottom: 20px;
    }
  }
</style>
<style>
  /* What we offers Section Styles */
  .offers-section {
    background: #eaf4fe;
    border-radius: 16px;
    margin-top: 30px;
    padding: 30px 15px;
  }

  .offers-section-title {
    font-weight: 700;
    font-size: 1.5rem;
    color: #222;
  }

  .offers-underline {
    height: 3px;
    width: 60px;
    background: #e74c3c;
    border-radius: 2px;
    margin: 10px 0 20px 2px;
  }

  .offer-card {
    background: #fff;
    border-radius: 18px;
    box-shadow: 0 2px 12px 0 rgba(24, 68, 133, 0.07);
    padding: 32px 18px 24px 18px;
    min-height: 220px;
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    border: 1px solid #f0f0f0;
    transition: box-shadow 0.18s, transform 0.18s;
  }

  .offer-card:hover {
    box-shadow: 0 8px 24px 0 rgba(24, 68, 133, 0.13);
    transform: translateY(-3px);
  }

  .offer-icon {
    width: 64px;
    height: 64px;
    object-fit: contain;
    margin-bottom: 18px;
  }

  .offer-title {
    font-size: 1.18rem;
    color: #222;
    font-weight: 600;
    margin-top: 10px;
  }

  .offer-callback-btn {
    background: #d04a4a;
    color: #fff;
    font-weight: 600;
    font-size: 1.25rem;
    border: none;
    border-radius: 8px;
    padding: 14px 38px;
    margin-top: 18px;
    box-shadow: 0 2px 8px rgba(208, 74, 74, 0.08);
    transition: background 0.18s, box-shadow 0.18s;
    display: flex;
    align-items: center;
    gap: 10px;
  }

  .offer-callback-btn:hover {
    background: #b93838;
    box-shadow: 0 4px 16px rgba(208, 74, 74, 0.18);
  }

  @media (max-width: 991.98px) {
    .offer-card {
      min-height: 180px;
      padding: 24px 10px 18px 10px;
    }

    .offer-icon {
      width: 48px;
      height: 48px;
    }

    .offer-title {
      font-size: 1rem;
    }

    .offer-callback-btn {
      font-size: 1.1rem;
      padding: 12px 22px;
    }
  }

  @media (max-width: 575.98px) {
    .offers-section {
      padding: 18px 2px;
    }

    .offers-section-title {
      font-size: 1.1rem;
    }

    .offers-underline {
      width: 38px;
      margin: 8px 0 14px 2px;
    }

    .offer-card {
      min-height: 120px;
      padding: 14px 4px 10px 4px;
    }

    .offer-icon {
      width: 36px;
      height: 36px;
      margin-bottom: 10px;
    }

    .offer-title {
      font-size: 0.92rem;
    }

    .offer-callback-btn {
      font-size: 0.98rem;
      padding: 8px 10px;
    }
  }
</style>


<style>
  /* Brand Section Styles */
  .brand-section {
    background: #eaf4fe;
    border-radius: 16px;
    padding: 30px 15px;
  }

  .brand-section-title {
    font-weight: 700;
    font-size: 1.5rem;
    color: #222;
    margin-bottom: 0;
  }

  .brand-underline {
    height: 3px;
    width: 60px;
    background: #e74c3c;
    border-radius: 2px;
    margin: 10px 0 20px 2px;
  }

  /* Brand Card Styles */
  .brand-card {
    background: #fff;
    border-radius: 14px;
    box-shadow: 0 2px 12px 0 rgba(24, 68, 133, 0.07);
    padding: 25px 15px;
    height: 100%;
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    transition: all 0.3s ease;
    border: 1px solid #f0f0f0;
    margin: 0 8px;
  }

  .brand-card:hover {
    box-shadow: 0 8px 24px 0 rgba(24, 68, 133, 0.13);
    transform: translateY(-3px);
  }

  .brand-logo {
    max-width: 70px;
    max-height: 40px;
    width: auto;
    height: auto;
    object-fit: contain;
    margin-bottom: 15px;
  }

  .brand-name {
    font-size: 1.05rem;
    color: #444;
    font-weight: 500;
    margin-top: 8px;
  }

  /* Swiper Container */
  .brand-swiper {
    padding: 15px 0;
  }

  /* Navigation Buttons */
  .brand-swiper .swiper-button-prev,
  .brand-swiper .swiper-button-next {
    width: 44px;
    height: 44px;
    background: #184485;
    border-radius: 50%;
    box-shadow: 0 4px 12px rgba(24, 68, 133, 0.3);
    color: white;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: all 0.3s ease;
    top: 50%;
    transform: translateY(-50%);
  }

  .brand-swiper .swiper-button-prev {
    left: -15px;
  }

  .brand-swiper .swiper-button-next {
    right: -15px;
  }

  .brand-swiper .swiper-button-prev:after,
  .brand-swiper .swiper-button-next:after {
    font-size: 20px;
    font-weight: bold;
  }

  .brand-swiper .swiper-button-prev:hover,
  .brand-swiper .swiper-button-next:hover {
    background: #0d47a1;
    transform: translateY(-50%) scale(1.1);
  }

  /* Responsive Adjustments */
  @media (max-width: 991.98px) {
    .brand-section {
      padding: 25px 10px;
    }

    .brand-card {
      padding: 20px 10px;
      margin: 0 5px;
    }

    .brand-logo {
      max-width: 60px;
      margin-bottom: 12px;
    }

    .brand-name {
      font-size: 0.95rem;
    }

    .brand-swiper .swiper-button-prev {
      left: -10px;
    }

    .brand-swiper .swiper-button-next {
      right: -10px;
    }
  }

  @media (max-width: 575.98px) {
    .brand-section {
      padding: 20px 5px;
    }

    .brand-section-title {
      font-size: 1.3rem;
    }

    .brand-card {
      padding: 15px 8px;
      margin: 0 3px;
    }

    .brand-logo {
      max-width: 50px;
      margin-bottom: 10px;
    }

    .brand-name {
      font-size: 0.85rem;
    }

    .brand-swiper .swiper-button-prev,
    .brand-swiper .swiper-button-next {
      width: 36px;
      height: 36px;
    }

    .brand-swiper .swiper-button-prev:after,
    .brand-swiper .swiper-button-next:after {
      font-size: 16px;
    }
  }
</style>




<!-- Product Category Page - Mobile Responsive, Theme Structure -->
<main class="main">
  <div class="container mt-4">

    <!-- Filter Pills (Mobile Scrollable) -->
    <div class="mb-3 d-flex flex-nowrap overflow-auto gap-2">
      <h1 class="category-title"><?= htmlspecialchars($category_name) ?></h1>
    </div>

    <!-- Product Grid: Show products of selected category -->
    <div class="row gy-4 gx-4">
      <?php if (!empty($category_products)) : ?>
        <?php foreach ($category_products as $prod) : ?>
          <div class="col-12 col-sm-6 col-md-4 col-lg-3">
            <div class="product-card h-100">
              <div class="product-img-box">
                <img src="<?= !empty($prod['p_cover']) ? base_url('assets/avator/upload/' . $prod['p_cover']) : base_url('assets/theme/v2/assets/images/demos/demo1/sliders/tractor.png') ?>" alt="<?= htmlspecialchars($prod['p_name']) ?>">
              </div>
              <div class="p-3 pb-0">
                <span class="product-badge">Model: <?= htmlspecialchars($prod['p_model'] ?? '-') ?></span>
                <span class="product-badge price">Location: <?= htmlspecialchars($prod['p_location'] ?? '-') ?></span>
              </div>
              <div class="card-body-pro">
                <div class="card-title-pro"><?= htmlspecialchars($prod['p_name']) ?></div>
                <div class="d-flex justify-content-between align-items-center mb-1">
                  <span class="card-price-pro">₹<?= number_format($prod['p_price']) ?></span>
                  <span class="card-year-pro"><?= htmlspecialchars($prod['p_year'] ?? '-') ?></span>
                </div>
                <div class="card-meta-pro">HP: <?= htmlspecialchars($prod['p_hp'] ?? '-') ?> | <?= htmlspecialchars($prod['p_brand_name'] ?? '-') ?></div>
                <button class="book-btn-pro">BOOK NOW</button>
              </div>
            </div>
          </div>
        <?php endforeach; ?>
      <?php else: ?>
        <div class="col-12"><div class="alert alert-info">No products found in this category.</div></div>
      <?php endif; ?>
    </div>

    <!-- Popular Brands Slider Section -->
    <section class="brand-section py-5 px-2 mb-5" style="background: #eaf4fe; border-radius: 16px; margin-top:30px; padding:20px 10px;">
      <div class="container">
        <div class="d-flex align-items-center mb-2">
          <h2 class="brand-section-title mb-0">Used Tractors From Popular Brands</h2>
        </div>
        <div class="brand-underline mb-4"></div>
        <div class="position-relative">
          <div class="swiper brand-swiper" style="position:relative; padding: 15px 0;">
            <div class="swiper-wrapper">
              <!-- Brand Card 1 -->
              <div class="swiper-slide">
                <div class="brand-card text-center">
                  <img src="https://www.mahindratractor.com/images/logo.png" alt="Mahindra" class="brand-logo mb-2" onerror="this.onerror=null;this.src='https://upload.wikimedia.org/wikipedia/commons/6/65/No-Image-Placeholder.svg';">
                  <div class="brand-name">Mahindra</div>
                </div>
              </div>
              <!-- Brand Card 2 -->
              <div class="swiper-slide">
                <div class="brand-card text-center">
                  <img src="https://www.swarajtractors.com/images/logo.png" alt="Swaraj" class="brand-logo mb-2" onerror="this.onerror=null;this.src='https://upload.wikimedia.org/wikipedia/commons/6/65/No-Image-Placeholder.svg';">
                  <div class="brand-name">Swaraj</div>
                </div>
              </div>
              <!-- Brand Card 3 -->
              <div class="swiper-slide">
                <div class="brand-card text-center">
                  <img src="https://www.masseyferguson.com/content/dam/public/masseyferguson/ce/brand/logos/massey-ferguson-logo.png" alt="Massey Ferguson" class="brand-logo mb-2" onerror="this.onerror=null;this.src='https://upload.wikimedia.org/wikipedia/commons/6/65/No-Image-Placeholder.svg';">
                  <div class="brand-name">Massey Ferguson</div>
                </div>
              </div>
              <!-- Brand Card 4 -->
              <div class="swiper-slide">
                <div class="brand-card text-center">
                  <img src="https://www.sonalika.com/images/logo.png" alt="Sonalika" class="brand-logo mb-2" onerror="this.onerror=null;this.src='https://upload.wikimedia.org/wikipedia/commons/6/65/No-Image-Placeholder.svg';">
                  <div class="brand-name">Sonalika</div>
                </div>
              </div>
              <!-- Brand Card 5 -->
              <div class="swiper-slide">
                <div class="brand-card text-center">
                  <img src="https://www.farmtracglobal.com/images/logo.png" alt="Farmtrac" class="brand-logo mb-2" onerror="this.onerror=null;this.src='https://upload.wikimedia.org/wikipedia/commons/6/65/No-Image-Placeholder.svg';">
                  <div class="brand-name">Farmtrac</div>
                </div>
              </div>
              <!-- Brand Card 6 -->
              <div class="swiper-slide">
                <div class="brand-card text-center">
                  <img src="https://www.deere.com/assets/images/logos/john-deere-logo.png" alt="John Deere" class="brand-logo mb-2" onerror="this.onerror=null;this.src='https://upload.wikimedia.org/wikipedia/commons/6/65/No-Image-Placeholder.svg';">
                  <div class="brand-name">John Deere</div>
                </div>
              </div>
              <!-- Brand Card 7 -->
              <div class="swiper-slide">
                <div class="brand-card text-center">
                  <img src="https://www.eichertractors.com/images/logo.png" alt="Eicher" class="brand-logo mb-2" onerror="this.onerror=null;this.src='https://upload.wikimedia.org/wikipedia/commons/6/65/No-Image-Placeholder.svg';">
                  <div class="brand-name">Eicher</div>
                </div>
              </div>
              <!-- Brand Card 8 -->
              <div class="swiper-slide">
                <div class="brand-card text-center">
                  <img src="https://www.powertracagri.com/images/logo.png" alt="Powertrac" class="brand-logo mb-2" onerror="this.onerror=null;this.src='https://upload.wikimedia.org/wikipedia/commons/6/65/No-Image-Placeholder.svg';">
                  <div class="brand-name">Powertrac</div>
                </div>
              </div>
            </div>
            <!-- Add navigation buttons -->
            <div class="swiper-button-prev brand-swiper-prev"></div>
            <div class="swiper-button-next brand-swiper-next"></div>
          </div>
        </div>
      </div>
    </section>

    <!-- Product Grid -->
    <div class="row gy-4 gx-4">
      <!-- Product 1 -->
      <div class="col-12 col-sm-6 col-md-4 col-lg-3">
        <div class="product-card h-100">
          <div class="product-img-box">
            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/demos/demo1/sliders/tractor1.png" alt="Mahindra 475 DI">
          </div>
          <div class="p-3 pb-0">
            <span class="product-badge">Assured</span>
            <span class="product-badge price">location</span>
          </div>
          <div class="card-body-pro">
            <div class="card-title-pro">Mahindra 475 DI</div>
            <div class="d-flex justify-content-between align-items-center mb-1">
              <span class="card-price-pro">₹4,50,000</span>
              <span class="card-year-pro">2020</span>
            </div>
            <div class="card-meta-pro">HP: 47 | Mahindra</div>
            <button class="book-btn-pro">BOOK NOW</button>
          </div>
        </div>
      </div>
      <!-- Product 2 -->
      <div class="col-12 col-sm-6 col-md-4 col-lg-3">
        <div class="product-card h-100">
          <div class="product-img-box">
            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/demos/demo1/sliders/tractor3.png" alt="Swaraj 744 FE">
          </div>
          <div class="p-3 pb-0">
            <span class="product-badge">model</span>
            <span class="product-badge price">location</span>
          </div>
          <div class="card-body-pro">
            <div class="card-title-pro">Swaraj 744 FE</div>
            <div class="d-flex justify-content-between align-items-center mb-1">
              <span class="card-price-pro">₹5,20,000</span>
              <span class="card-year-pro">2021</span>
            </div>
            <div class="card-meta-pro">HP: 44 | Swaraj</div>
            <button class="book-btn-pro">BOOK NOW</button>
          </div>
        </div>
      </div>
      <!-- Product 3 -->
      <div class="col-12 col-sm-6 col-md-4 col-lg-3">
        <div class="product-card h-100">
          <div class="product-img-box">
            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/demos/demo1/sliders/tractor2.png" alt="New Holland 3630">
          </div>
          <div class="p-3 pb-0">
            <span class="product-badge">model</span>
            <span class="product-badge price">location</span>
          </div>
          <div class="card-body-pro">
            <div class="card-title-pro">New Holland 3630</div>
            <div class="d-flex justify-content-between align-items-center mb-1">
              <span class="card-price-pro">₹6,80,000</span>
              <span class="card-year-pro">2019</span>
            </div>
            <div class="card-meta-pro">HP: 30 | New Holland</div>
            <button class="book-btn-pro">BOOK NOW</button>
          </div>
        </div>
      </div>
      <!-- Product 4 -->
      <div class="col-12 col-sm-6 col-md-4 col-lg-3">
        <div class="product-card h-100">
          <div class="product-img-box">
            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/demos/demo1/sliders/tractor.png" alt="John Deere 3028EN">
          </div>
          <div class="p-3 pb-0">
            <span class="product-badge">model</span>
            <span class="product-badge price">location</span>
          </div>
          <div class="card-body-pro">
            <div class="card-title-pro">John Deere 3028EN</div>
            <div class="d-flex justify-content-between align-items-center mb-1">
              <span class="card-price-pro">₹7,50,000</span>
              <span class="card-year-pro">2022</span>
            </div>
            <div class="card-meta-pro">HP: 28 | John Deere</div>
            <button class="book-btn-pro">BOOK NOW</button>
          </div>
        </div>
      </div>

    </div>

    <!-- What we offers Section (Below Brands Slider) -->
    <section class="offers-section py-5 px-2 mb-5" style="background: #eaf4fe; border-radius: 16px; margin-top:30px; padding:20px 10px;">
      <div class="container">
        <div class="d-flex align-items-center mb-2">
          <h2 class="offers-section-title mb-0">What we offers</h2>
        </div>
        <div class="offers-underline mb-4"></div>
        <div class="row g-4 justify-content-center">
          <div class="col-12 col-sm-6 col-md-3">
            <div class="offer-card text-center h-100">
              <img src="https://cdn-icons-png.flaticon.com/512/3135/3135715.png" alt="Best Quality Tractor" class="offer-icon mb-3" loading="lazy">
              <div class="offer-title">Best Quality Tractor</div>
            </div>
          </div>
          <div class="col-12 col-sm-6 col-md-3">
            <div class="offer-card text-center h-100">
              <img src="https://cdn-icons-png.flaticon.com/512/190/190411.png" alt="location Guaranteed" class="offer-icon mb-3" loading="lazy">
              <div class="offer-title">location Guaranteed</div>
            </div>
          </div>
          <div class="col-12 col-sm-6 col-md-3">
            <div class="offer-card text-center h-100">
              <img src="https://cdn-icons-png.flaticon.com/512/3135/3135789.png" alt="Get upto 85% loan" class="offer-icon mb-3" loading="lazy">
              <div class="offer-title">Get upto 85% loan</div>
            </div>
          </div>
          <div class="col-12 col-sm-6 col-md-3">
            <div class="offer-card text-center h-100">
              <img src="https://cdn-icons-png.flaticon.com/512/3135/3135768.png" alt="Hassle free RC transfer" class="offer-icon mb-3" loading="lazy">
              <div class="offer-title">Hassle free RC transfer</div>
            </div>
          </div>
        </div>
        <div class="d-flex justify-content-center mt-4">
          <button class="offer-callback-btn"><i class="fa fa-phone"></i> Request Call Back</button>
        </div>
      </div>
    </section>

    <!-- What is Used model Tractors Section -->
    <section class="bg-light rounded-3 p-4 mb-5 mt-5">
      <h5 class="fw-bold mb-2">What is Used Assured Tractors?</h5>
      <p class="mb-0 text-muted">Used Assured Tractors are thoroughly inspected, certified, and come with warranty and easy finance options. Buy with confidence and peace of mind.</p>
    </section>
  </div>
</main>

<!-- Swiper JS for Brand Slider (if not already included in theme) -->
<script src="https://cdn.jsdelivr.net/npm/swiper@9/swiper-bundle.min.js"></script>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@9/swiper-bundle.min.css" />
<script>
  // Initialize brand swiper with proper spacing
  var brandSwiper = new Swiper('.brand-swiper', {
    slidesPerView: 2,
    spaceBetween: 20,
    navigation: {
      nextEl: '.swiper-button-next',
      prevEl: '.swiper-button-prev',
    },
    breakpoints: {
      576: {
        slidesPerView: 3,
        spaceBetween: 25
      },
      768: {
        slidesPerView: 4,
        spaceBetween: 25
      },
      992: {
        slidesPerView: 5,
        spaceBetween: 25
      },
      1200: {
        slidesPerView: 6,
        spaceBetween: 25
      }
    },
    loop: false,
    autoplay: false
  });
</script>