<link rel="stylesheet" type="text/css" href="<?=base_url()?>assets/theme/v2/assets/css/style.min.css">

<!-- Custom Modal CSS -->
<style>
/* Modal Overlay */
.modal-backdrop {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-color: rgba(0, 0, 0, 0.5);
    z-index: 1040;
    display: none;
}

.modal-backdrop.show {
    display: block;
}

/* Modal Container */
.modal {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    z-index: 1050;
    display: none;
    overflow: auto;
    outline: 0;
}

.modal.show {
    display: block;
}

/* Modal Dialog */
.modal-dialog {
    position: relative;
    width: auto;
    margin: 1.75rem auto;
    pointer-events: none;
    max-width: 500px;
}

.modal-dialog-centered {
    display: flex;
    align-items: center;
    min-height: calc(100% - 3.5rem);
}

/* Modal Content */
.modal-content {
    position: relative;
    display: flex;
    flex-direction: column;
    width: 100%;
    pointer-events: auto;
    background-color: #fff;
    background-clip: padding-box;
    border: 1px solid rgba(0, 0, 0, 0.2);
    border-radius: 0.3rem;
    outline: 0;
    box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
}

/* Modal Header */
.modal-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 1rem;
    border-bottom: 1px solid #dee2e6;
    border-top-left-radius: calc(0.3rem - 1px);
    border-top-right-radius: calc(0.3rem - 1px);
}

.modal-title {
    margin-bottom: 0;
    line-height: 1.5;
    font-size: 1.25rem;
    font-weight: 500;
}

.modal-header .close {
    padding: 1rem;
    margin: -1rem -1rem -1rem auto;
    background: transparent;
    border: 0;
    font-size: 1.5rem;
    font-weight: 700;
    line-height: 1;
    color: #000;
    text-shadow: 0 1px 0 #fff;
    opacity: 0.5;
    cursor: pointer;
}

.modal-header .close:hover {
    opacity: 0.75;
}

/* Modal Body */
.modal-body {
    position: relative;
    flex: 1 1 auto;
    padding: 1rem;
}

/* Form Controls */
.form-group {
    margin-bottom: 1rem;
}

.form-group label {
    display: inline-block;
    margin-bottom: 0.5rem;
    font-weight: 500;
}

.form-control {
    display: block;
    width: 100%;
    padding: 0.375rem 0.75rem;
    font-size: 1rem;
    line-height: 1.5;
    color: #495057;
    background-color: #fff;
    background-clip: padding-box;
    border: 1px solid #ced4da;
    border-radius: 0.25rem;
    transition: border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;
}

.form-control:focus {
    color: #495057;
    background-color: #fff;
    border-color: #80bdff;
    outline: 0;
    box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25);
}

/* Input Group */
.input-group {
    position: relative;
    display: flex;
    flex-wrap: wrap;
    align-items: stretch;
    width: 100%;
}

.input-group-prepend {
    display: flex;
}

.input-group-text {
    display: flex;
    align-items: center;
    padding: 0.375rem 0.75rem;
    margin-bottom: 0;
    font-size: 1rem;
    font-weight: 400;
    line-height: 1.5;
    color: #495057;
    text-align: center;
    white-space: nowrap;
    background-color: #e9ecef;
    border: 1px solid #ced4da;
    border-radius: 0.25rem 0 0 0.25rem;
}

.input-group .form-control {
    position: relative;
    flex: 1 1 auto;
    width: 1%;
    margin-bottom: 0;
    border-radius: 0 0.25rem 0.25rem 0;
}

/* Buttons */
.btn {
    display: inline-block;
    font-weight: 400;
    text-align: center;
    vertical-align: middle;
    user-select: none;
    border: 1px solid transparent;
    padding: 0.375rem 0.75rem;
    font-size: 1rem;
    line-height: 1.5;
    border-radius: 0.25rem;
    transition: color 0.15s ease-in-out, background-color 0.15s ease-in-out, border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;
    cursor: pointer;
}







.btn-lg {
    padding: 0.5rem 1rem;
    font-size: 1.25rem;
    line-height: 1.5;
    border-radius: 0.3rem;
}

/* Text Utilities */
.text-center {
    text-align: center;
}

.text-muted {
    color: #6c757d;
}

.mt-3 {
    margin-top: 1rem;
}

/* Responsive */
@media (max-width: 576px) {
    .modal-dialog {
        margin: 0.5rem;
        max-width: none;
    }
    
    .modal-dialog-centered {
        min-height: calc(100% - 1rem);
    }
}
</style>
<!-- What We Offers Section -->
<style>
    .what-we-offer-section {
        background: #f6f9fb;
        border-radius: 14px;
        box-shadow: 0 2px 8px #0001;
        padding: 28px 18px 36px 18px;
        margin-bottom: 32px;
        margin-top: 32px;
    }

    .what-we-offer-title {
        font-size: 2rem;
        font-weight: 700;
        margin-bottom: 28px;
    }

    .offer-cards {
        display: flex;
        flex-wrap: nowrap;
        gap: 28px;
        justify-content: space-between;
        margin-bottom: 32px;
    }

    .offer-card {
        background: #fff;
        border-radius: 16px;
        box-shadow: 0 4px 16px #0001;
        padding: 36px 18px 28px 18px;
        width: 24%;
        max-width: 320px;
        min-width: 200px;
        display: flex;
        flex-direction: column;
        align-items: center;
        transition: box-shadow 0.2s;
    }

    .offer-card:hover {
        box-shadow: 0 8px 24px #0002;
    }

    .offer-icon {
        margin-bottom: 18px;
        display: flex;
        align-items: center;
        justify-content: center;
        height: 64px;
    }

    .offer-label {
        font-size: 1.18rem;
        font-weight: 700;
        color: #181818;
        text-align: center;
    }

    .call-expert-btn {
        display: flex;
        align-items: center;
        justify-content: center;
        background: #d44d53;
        color: #fff;
        font-size: 1.35rem;
        font-weight: 700;
        border: none;
        border-radius: 8px;
        padding: 16px 0;
        width: 340px;
        margin: 0 auto;
        transition: background 0.2s;
        box-shadow: 0 2px 8px #0001;
        cursor: pointer;
    }

    .call-expert-btn i {
        margin-right: 10px;
        font-size: 1.3em;
    }

    .call-expert-btn:hover {
        background: #b93b3f;
    }

    @media (max-width: 991px) {
        .offer-cards {
            flex-wrap: wrap;
            gap: 16px;
        }

        .offer-card {
            width: 45%;
            min-width: 180px;
            max-width: 100%;
        }

        .call-expert-btn {
            width: 100%;
        }
    }

    @media (max-width: 600px) {
        .what-we-offer-section {
            padding: 10px 2px;
        }

        .what-we-offer-title {
            font-size: 1.2rem;
        }

        .offer-cards {
            flex-wrap: wrap;
        }

        .offer-card {
            width: 100%;
            min-width: 100%;
        }
    }
</style>
<style>
    .key-spec-section {
        background: #f6f9fb;
        border-radius: 16px;
        box-shadow: 0 2px 8px #0001;
        padding: 28px 18px 28px 18px;
        margin-bottom: 32px;
    }

    .key-spec-title {
        font-size: 1.6rem;
        font-weight: 700;
        margin-bottom: 18px;
    }

    .key-spec-cards {
        display: flex;
        flex-wrap: wrap;
        gap: 14px;
        justify-content: flex-start;
    }

    .key-spec-card {
        background: #fff;
        border-radius: 10px;
        box-shadow: 0 2px 8px #0001;
        padding: 14px 16px 10px 16px;
        min-width: 200px;
        max-width: 240px;
        flex: 1 1 200px;
        display: flex;
        flex-direction: column;
        align-items: flex-start;
        margin-bottom: 0;
    }

    .key-spec-row {
        display: flex;
        align-items: center;
        gap: 8px;
        margin-bottom: 2px;
    }

    .key-spec-icon {
        font-size: 1.35rem;
        color: #2d7be5;
        flex-shrink: 0;
    }

    .key-spec-label {
        color: #444;
        font-size: 1.08rem;
        font-weight: 600;
        margin-bottom: 0;
        line-height: 1.1;
    }

    .key-spec-value {
        font-weight: 700;
        font-size: 1.08rem;
        color: #222;
        margin-top: 4px;
    }

    @media (max-width: 991px) {
        .key-spec-cards {
            gap: 10px;
        }

        .key-spec-card {
            min-width: 46%;
            max-width: 100%;
        }
    }

    @media (max-width: 600px) {
        .key-spec-section {
            padding: 10px 2px;
        }

        .key-spec-title {
            font-size: 1.1rem;
        }

        .key-spec-card {
            min-width: 100%;
        }
    }
</style>

<!-- EMI Calculator Section (New Design) CSS -->
<style>
.emi-calc-main-section {
    background: #fff;
    border-radius: 12px;
    box-shadow: 0 2px 8px #0001;
    padding: 32px 24px;
    margin-bottom: 32px;
    margin-top: 24px;
}
.emi-calc-flex {
    display: flex;
    gap: 32px;
    flex-wrap: wrap;
}
.emi-calc-left {
    flex: 1 1 340px;
    min-width: 320px;
    max-width: 420px;
}
.emi-calc-right {
    flex: 1 1 320px;
    min-width: 300px;
    max-width: 400px;
    display: flex;
    flex-direction: column;
    align-items: flex-start;
}
.emi-calc-title {
    font-size: 1.5rem;
    font-weight: 700;
    margin-bottom: 18px;
    color: #222;
    letter-spacing: 0.5px;
}
.emi-calc-group {
    margin-bottom: 28px;
}
.emi-calc-slider-row {
    display: flex;
    align-items: center;
    gap: 16px;
}
.emi-calc-slider-value {
    font-weight: 600;
    font-size: 1.1rem;
    color: #204080;
    min-width: 80px;
    text-align: right;
}
.emi-calc-slider-labels {
    display: flex;
    justify-content: space-between;
    font-size: 0.95rem;
    color: #888;
    margin-top: 2px;
}
.emi-calc-group label {
    font-weight: 600;
    color: #222;
    margin-bottom: 8px;
    display: block;
}
.emi-calc-loan-periods {
    display: flex;
    gap: 8px;
    flex-wrap: wrap;
    margin-top: 8px;
}
.emi-loan-period-btn {
    background: #fff;
    border: 1.5px solid #d1d5db;
    color: #222;
    border-radius: 6px;
    padding: 8px 18px;
    font-weight: 600;
    font-size: 1rem;
    cursor: pointer;
    transition: all 0.2s;
}
.emi-loan-period-btn.active, .emi-loan-period-btn:focus {
    background: #204080;
    color: #fff;
    border-color: #204080;
}
.emi-loan-period-btn:hover {
    border-color: #204080;
}
.emi-calc-emi-type-group {
    display: flex;
    gap: 12px;
    margin-bottom: 18px;
}
.emi-calc-emi-type {
    display: flex;
    flex-direction: column;
    align-items: center;
    border: 1.5px solid #d1d5db;
    border-radius: 8px;
    padding: 8px 18px 6px 18px;
    cursor: pointer;
    position: relative;
    min-width: 80px;
    background: #fff;
    transition: border 0.2s;
}
.emi-calc-emi-type input[type="radio"] {
    accent-color: #204080;
    margin-bottom: 4px;
}
.emi-calc-emi-type-popular {
    border-color: #f7bfc2;
    position: relative;
}
.emi-calc-popular {
    position: absolute;
    top: -18px;
    left: 50%;
    transform: translateX(-50%);
    background: #f7bfc2;
    color: #d44d53;
    font-size: 0.85rem;
    font-weight: 600;
    border-radius: 6px;
    padding: 2px 10px;
    z-index: 2;
}
.emi-calc-emi-type input[type="radio"]:checked + span {
    color: #204080;
    font-weight: 700;
}
.emi-calc-result-box {
    width: 100%;
    background: #f6f9fb;
    border-radius: 10px;
    padding: 18px 0 10px 0;
    text-align: center;
    margin-bottom: 18px;
    box-shadow: 0 1px 4px #0001;
}
.emi-calc-result-label {
    color: #888;
    font-size: 1.05rem;
    margin-bottom: 6px;
}
.emi-calc-result-value {
    color: #204080;
    font-size: 2rem;
    font-weight: 700;
    letter-spacing: 1px;
}
.emi-calc-summary {
    width: 100%;
    margin-bottom: 18px;
}
.emi-calc-summary-row {
    display: flex;
    justify-content: space-between;
    font-size: 1.08rem;
    color: #222;
    margin-bottom: 4px;
}
.emi-calc-loan-offer-btn {
    width: 100%;
    background: #204080;
    color: #fff;
    border: none;
    border-radius: 8px;
    padding: 14px 0;
    font-size: 1.1rem;
    font-weight: 700;
    margin-bottom: 8px;
    cursor: pointer;
    transition: background 0.2s;
}
.emi-calc-loan-offer-btn:hover {
    background: #1a3366;
}
.emi-calc-details-link {
    width: 100%;
    text-align: center;
    font-size: 1rem;
    margin-top: 2px;
}
@media (max-width: 900px) {
    .emi-calc-flex {
        flex-direction: column;
        gap: 24px;
    }
    .emi-calc-left, .emi-calc-right {
        max-width: 100%;
        min-width: 0;
    }
}
@media (max-width: 600px) {
    .emi-calc-main-section {
        padding: 10px 2px;
    }
    .emi-calc-title {
        font-size: 1.1rem;
    }
    .emi-calc-result-value {
        font-size: 1.3rem;
    }
    .emi-calc-loan-offer-btn {
        font-size: 1rem;
        padding: 10px 0;
    }
}
</style>

<!-- Tractor Inspection Checklist Section -->
<style>
    .tractor-checklist-section {
        background: #f6f9fb;
        border-radius: 14px;
        box-shadow: 0 2px 8px #0001;
        padding: 28px 18px 36px 18px;
        margin-bottom: 32px;
        margin-top: 32px;
    }

    .tractor-checklist-title {
        font-size: 2rem;
        font-weight: 700;
        margin-bottom: 24px;
    }

    .checklist-tabs {
        display: flex;
        gap: 0;
        margin-bottom: 0;
    }

    .checklist-tab {
        background: #fff;
        border: 1px solid #e0e4ea;
        border-bottom: none;
        border-radius: 8px 8px 0 0;
        padding: 10px 32px;
        font-size: 1.1rem;
        font-weight: 600;
        color: #222;
        cursor: pointer;
        margin-right: 2px;
        transition: background 0.2s, color 0.2s;
        outline: none;
    }

    .checklist-tab.active {
        background: #f6f9fb;
        color: #204080;
        border-bottom: 2px solid #f6f9fb;
        position: relative;
        z-index: 1;
    }

    .checklist-tab-content {
        background: #f6f9fb;
        border: 1px solid #e0e4ea;
        border-top: none;
        padding: 24px;
        margin-top: -1px;
        position: relative;
    }

    .checklist-items {
        display: flex;
        flex-wrap: wrap;
        gap: 24px;
    }

    .checklist-col {
        flex: 1;
        min-width: 200px;
    }

    .checklist-list {
        list-style: none;
        padding: 0;
        margin: 0;
    }

    .checklist-list li {
        display: flex;
        align-items: center;
        gap: 8px;
        margin-bottom: 12px;
        font-size: 0.95rem;
        color: #444;
    }

    .checklist-icon {
        color: #204080;
        display: flex;
        align-items: center;
        justify-content: center;
        width: 20px;
        height: 20px;
    }

    .checklist-icon i {
        font-size: 0.9rem;
    }

    @media (max-width: 768px) {
        .checklist-items {
            flex-direction: column;
            gap: 16px;
        }

        .checklist-col {
            width: 100%;
        }

        .checklist-tab {
            padding: 8px 16px;
            font-size: 1rem;
        }
    }

    .checklist-tab:not(.active):hover {
        background: #f0f2f7;
    }

    .checklist-tab-content {
        background: #fff;
        border-radius: 0 0 8px 8px;
        box-shadow: 0 2px 8px #0001;
        padding: 32px 24px 24px 24px;
        margin-top: -1px;
    }

    .checklist-items {
        display: grid;
        grid-template-columns: repeat(4, 1fr);
        gap: 20px;
    }

    .checklist-col {
        width: 100%;
    }

    .checklist-list {
        list-style: none;
        padding: 0;
        margin: 0 0 0 0;
    }

    .checklist-list li {
        display: flex;
        align-items: center;
        font-size: 1.08rem;
        margin-bottom: 16px;
        color: #181818;
    }

    .checklist-icon {
        color: #d44d53;
        font-size: 1.2rem;
        margin-right: 8px;
        display: flex;
        align-items: center;
    }

    @media (max-width: 991px) {
        .checklist-items {
            grid-template-columns: repeat(3, 1fr);
        }
    }

    @media (max-width: 600px) {
        .tractor-checklist-section {
            padding: 10px 2px;
        }

        .tractor-checklist-title {
            font-size: 1.2rem;
        }

        .checklist-items {
            grid-template-columns: repeat(2, 1fr);
            gap: 10px;
        }

        .checklist-tab {
            padding: 8px 10px;
            font-size: 1rem;
        }

        .checklist-tab-content {
            padding: 16px 6px 12px 6px;
        }
    }
</style>

<!-- Start of Main -->
<main class="main mb-10 pb-1">

    
    <!-- Start of Breadcrumb -->
    <nav class="breadcrumb-nav container">
        <ul class="breadcrumb bb-no">
            <li><a href="<?= base_url() ?>">Home</a></li>
            <li><a href="<?= base_url('shop') ?>">Products</a></li>
            <!-- <li><?= htmlspecialchars($product['p_name']) ?></li> -->
        </ul>
        <!-- <ul class="product-nav list-style-none">
            <li class="product-nav-prev">
                <a href="#">
                    <i class="w-icon-angle-left"></i>
                </a>
                <span class="product-nav-popup">
                    <img src="<?= base_url('assets/theme/v2/') ?>assets/images/products/product-nav-prev.jpg" alt="Product" width="110"
                        height="110" />
                    <span class="product-name">Soft Sound Maker</span>
                </span>
            </li>
            <li class="product-nav-next">
                <a href="#">
                    <i class="w-icon-angle-right"></i>
                </a>
                <span class="product-nav-popup">
                    <img src="<?= base_url('assets/theme/v2/') ?>assets/images/products/product-nav-next.jpg" alt="Product" width="110"
                        height="110" />
                    <span class="product-name">Fabulous Sound Speaker</span>
                </span>
            </li>
        </ul> -->
    </nav>
    <!-- End of Breadcrumb -->

    <!-- Start of Page Content -->
    <div class="page-content">
        <div class="container">
            <div class="row gutter-lg">
                <div class="main-content">
                    <div class="product product-single row">
                        <div class="col-md-6 mb-6">
                            <div class="product-gallery product-gallery-sticky">
                                <div class="swiper-container product-single-swiper swiper-theme nav-inner" data-swiper-options="{
                                            'navigation': {
                                                'nextEl': '.swiper-button-next',
                                                'prevEl': '.swiper-button-prev'
                                            }
                                        }">
                                    <div class="swiper-wrapper row cols-1 gutter-no">
                                        <!-- Main product image -->
                                        <div class="swiper-slide">
                                            <figure class="product-image"  style="background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%); border-radius: 8px; padding: 20px;">
                                                <img src="<?= !empty($product['p_image1']) ? base_url('assets/avator/upload/') . $product['p_image1'] : base_url('assets/theme/v2/assets/images/products/default/1-800x900.jpg') ?>"
                                                    data-zoom-image="<?= !empty($product['p_image1']) ? base_url('assets/avator/upload/') . $product['p_image1'] : base_url('assets/theme/v2/assets/images/products/default/1-800x900.jpg') ?>"
                                                    alt="<?= htmlspecialchars($product['p_name']) ?>" width="800" height="600">
                                            </figure>
                                        </div>
                                        <!-- Additional product images -->
                                        <?php if (isset($product_images) && !empty($product_images)) { ?>
                                            <?php foreach ($product_images as $img) { ?>
                                                <div class="swiper-slide">
                                                    <figure class="product-image">
                                                        <img src="<?= base_url('assets/avator/upload/') . $img['img'] ?>"
                                                            data-zoom-image="<?= base_url('assets/avator/upload/') . $img['img'] ?>"
                                                            alt="<?= htmlspecialchars($product['p_name']) ?>" width="800" height="900">
                                                    </figure>
                                                </div>
                                            <?php } ?>
                                        <?php } ?>
                                    </div>
                                    <button class="swiper-button-next"></button>
                                    <button class="swiper-button-prev"></button>
                                    <a href="#" class="product-gallery-btn product-image-full"><i class="w-icon-zoom"></i></a>
                                </div>
                                <div class="product-thumbs-wrap swiper-container" data-swiper-options="{
                                            'navigation': {
                                                'nextEl': '.swiper-button-next',
                                                'prevEl': '.swiper-button-prev'
                                            }
                                        }">
                                    <div class="product-thumbs swiper-wrapper row cols-4 gutter-sm">
                                        <!-- Main product image thumbnail -->
                                        <div class="product-thumb swiper-slide">
                                            <img src="<?= !empty($product['p_image1']) ? base_url('assets/avator/upload/') . $product['p_image1'] : base_url('assets/theme/v2/assets/images/products/default/1-800x900.jpg') ?>"
                                                alt="Product Thumb" width="800" height="900">
                                        </div>
                                        <!-- Additional product images thumbnails -->
                                        <?php if (isset($product_images) && !empty($product_images)) { ?>
                                            <?php foreach ($product_images as $img) { ?>
                                                <div class="product-thumb swiper-slide">
                                                    <img src="<?= base_url('assets/avator/upload/') . $img['img'] ?>"
                                                        alt="Product Thumb" width="800" height="900">
                                                </div>
                                            <?php } ?>
                                        <?php } ?>
                                    </div>
                                    <button class="swiper-button-next"></button>
                                    <button class="swiper-button-prev"></button>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 mb-4 mb-md-6">
                            <div class="product-details" data-sticky-options="{'minWidth': 767}">
                                <h1 class="product-title"><?= htmlspecialchars($product['p_name']) ?></h1>
                                <div class="product-bm-wrapper">
                                    <figure class="brand">
                                        <?php if (!empty($product['brand_image'])): ?>
                                            <img src="<?= base_url('assets/avator/upload/tags/') . $product['brand_image'] ?>" 
                                                 alt="<?= htmlspecialchars($product['brand_name']) ?>"
                                                 width="102" height="48" style="object-fit:contain; border-radius:6px; background:#fff; border:1px solid #eee;" />
                                        <?php else: ?>
                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/products/brand/brand-1.jpg" alt="Brand"
                                                width="102" height="48" />
                                        <?php endif; ?>
                                    </figure>
                                    <div class="product-meta">
                                        <div class="product-categories">
                                            Category:
                                            <span class="product-category"><a href="<?= base_url('shop?cat=' . $product['p_category']) ?>"><?= !empty($product['category_name']) ? htmlspecialchars($product['category_name']) : 'General' ?></a></span>
                                        </div>
                                        <?php if (!empty($product['brand_name'])): ?>
                                        <div class="product-brand">
                                            Brand:
                                            <span class="product-brand-name"><?= htmlspecialchars($product['brand_name']) ?></span>
                                        </div>
                                        <?php endif; ?>
                                        <div class="product-sku">
                                            Product ID: <span><?= $product['p_id'] ?></span>
                                        </div>
                                    </div>
                                </div>

                                <hr class="product-divider">

                                <div class="product-price">
                                    <?php if ($product['p_discount'] > 0) { ?>
                                        <ins class="new-price">₹<?= number_format($product['p_price'] - ($product['p_price'] * $product['p_discount'] / 100), 2) ?></ins>
                                        <del class="old-price">₹<?= number_format($product['p_price'], 2) ?></del>
                                    <?php } else { ?>
                                        <ins class="new-price">₹<?= number_format($product['p_price'], 2) ?></ins>
                                    <?php } ?>
                                </div>

                                <!-- <div class="ratings-container">
                                            <div class="ratings-full">
                                                <span class="ratings" style="width: 80%;"></span>
                                                <span class="tooltiptext tooltip-top"></span>
                                            </div>
                                            <a href="#product-tab-reviews" class="rating-reviews scroll-to">(3
                                                Reviews)</a>
                                        </div> -->

                                <div class="product-short-desc">
                                    <ul class="list-type-check list-style-none">
                                        <?php if (!empty($product['p_year'])): ?>
                                            <li><strong>Year:</strong> <?= htmlspecialchars($product['p_year']) ?></li>
                                        <?php endif; ?>
                                        <?php if (!empty($product['p_model'])): ?>
                                            <li><strong>Model:</strong> <?= htmlspecialchars($product['p_model']) ?></li>
                                        <?php endif; ?>
                                        <?php if (!empty($product['brand_name'])): ?>
                                            <li><strong>Brand:</strong> <?= htmlspecialchars($product['brand_name']) ?></li>
                                        <?php endif; ?>
                                        <?php if (!empty($product['city_name'])): ?>
                                            <li><strong>City:</strong> <?= htmlspecialchars($product['city_name']) ?></li>
                                        <?php endif; ?>
                                        <?php if (!empty($product['state_name'])): ?>
                                            <li><strong>State:</strong> <?= htmlspecialchars($product['state_name']) ?></li>
                                        <?php endif; ?>
                                        <?php if (!empty($product['tyre_condition'])): ?>
                                            <li><strong>Tyre Condition:</strong> <?= htmlspecialchars($product['tyre_condition']) ?></li>
                                        <?php endif; ?>
                                        <?php if (!empty($product['engine_condition'])): ?>
                                            <li><strong>Engine Condition:</strong> <?= htmlspecialchars($product['engine_condition']) ?></li>
                                        <?php endif; ?>
                                    </ul>
                                </div>

                                <hr class="product-divider">
                                <!-- <div class="product-variation-price">
                                            <span></span>
                                        </div> -->
                                <div class="fix-bottom product-sticky-content sticky-content">
                                    <div class="product-form container">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <button type="button" onclick="openBookingModal(<?= $product['p_id'] ?>, <?= $product['p_vendor'] ?>, '<?= htmlspecialchars($product['p_name']) ?>', event)" class="btn btn-primary btn-rounded btn-block book-now-btn" style="min-width:130px; font-weight:600; font-size:15px;padding:10px 0px;">
                                                    <span class="btn-text">
                                                        <i class="w-icon-cart"></i>
                                                        <span>Book Now</span>
                                                    </span>
                                                    <span class="btn-loading" style="display:none;">
                                                        <i class="fa fa-spinner fa-spin"></i> Loading...
                                                    </span>
                                                </button>
                                            </div>
                                            <!-- <div class="col-md-6">
                                                <button type="button" onclick="openEMICalculator()" class="btn btn-outline-primary btn-rounded btn-block" style="min-width:120px; font-weight:600; font-size:15px;padding:10px 0px;">
                                                    <i class="fa fa-calculator"></i>
                                                    <span>EMI Calculator</span>
                                                </button>
                                            </div> -->
                                        </div>
                                    </div>
                                </div>


                            </div>
                        </div>
                    </div>



                    <!-- Start Key Specification Section (Icon + Label in One Line, Larger) -->

                    <div class="container key-spec-section">
                        <div class="key-spec-title"><?= htmlspecialchars($product['p_name']) ?> Key Specification</div>
                        <div class="key-spec-cards">
                            <?php if (!empty($product['city_name']) || !empty($product['state_name'])): ?>
                                <div class="key-spec-card">
                                    <div class="key-spec-row">
                                        <span class="key-spec-icon"><i class="fa fa-map-marker"></i></span>
                                        <span class="key-spec-label">Location</span>
                                    </div>
                                    <div class="key-spec-value"><?= !empty($product['city_name']) ? htmlspecialchars($product['city_name']) : '' ?><?= !empty($product['city_name']) && !empty($product['state_name']) ? ', ' : '' ?><?= !empty($product['state_name']) ? htmlspecialchars($product['state_name']) : '' ?></div>
                                </div>
                            <?php endif; ?>

                            <?php if (!empty($product['engine_power'])): ?>
                                <div class="key-spec-card">
                                    <div class="key-spec-row">
                                        <span class="key-spec-icon"><i class="fa fa-cogs"></i></span>
                                        <span class="key-spec-label">Engine Power</span>
                                    </div>
                                    <div class="key-spec-value"><?= htmlspecialchars($product['engine_power']) ?></div>
                                </div>
                            <?php endif; ?>

                            <?php if (!empty($product['p_year'])): ?>
                                <div class="key-spec-card">
                                    <div class="key-spec-row">
                                        <span class="key-spec-icon"><i class="fa fa-calendar"></i></span>
                                        <span class="key-spec-label">Purchase Year</span>
                                    </div>
                                    <div class="key-spec-value"><?= htmlspecialchars($product['p_year']) ?></div>
                                </div>
                            <?php endif; ?>

                            <?php if (!empty($product['rto_no'])): ?>
                                <div class="key-spec-card">
                                    <div class="key-spec-row">
                                        <span class="key-spec-icon"><i class="fa fa-id-card"></i></span>
                                        <span class="key-spec-label">RTO NO.</span>
                                    </div>
                                    <div class="key-spec-value"><?= htmlspecialchars($product['rto_no']) ?></div>
                                </div>
                            <?php endif; ?>

                            <?php if (!empty($product['tyre_condition'])): ?>
                                <div class="key-spec-card">
                                    <div class="key-spec-row">
                                        <span class="key-spec-icon"><i class="fa fa-life-ring"></i></span>
                                        <span class="key-spec-label">Tyre Conditions</span>
                                    </div>
                                    <div class="key-spec-value"><?= htmlspecialchars($product['tyre_condition']) ?></div>
                                </div>
                            <?php endif; ?>

                            <?php if (!empty($product['engine_condition'])): ?>
                                <div class="key-spec-card">
                                    <div class="key-spec-row">
                                        <span class="key-spec-icon"><i class="fa fa-tint"></i></span>
                                        <span class="key-spec-label">Engine Conditions</span>
                                    </div>
                                    <div class="key-spec-value"><?= htmlspecialchars($product['engine_condition']) ?></div>
                                </div>
                            <?php endif; ?>

                            <?php if (!empty($product['financier_noc'])): ?>
                                <div class="key-spec-card">
                                    <div class="key-spec-row">
                                        <span class="key-spec-icon"><i class="fa fa-university"></i></span>
                                        <span class="key-spec-label">Financier / NOC</span>
                                    </div>
                                    <div class="key-spec-value"><?= htmlspecialchars($product['financier_noc']) ?></div>
                                </div>
                            <?php endif; ?>

                            <?php if (!empty($product['rc_status'])): ?>
                                <div class="key-spec-card">
                                    <div class="key-spec-row">
                                        <span class="key-spec-icon"><i class="fa fa-file-text"></i></span>
                                        <span class="key-spec-label">RC</span>
                                    </div>
                                    <div class="key-spec-value"><?= htmlspecialchars($product['rc_status']) ?></div>
                                </div>
                            <?php endif; ?>

                            <?php if (!empty($product['p_model'])): ?>
                                <div class="key-spec-card">
                                    <div class="key-spec-row">
                                        <span class="key-spec-icon"><i class="fa fa-truck"></i></span>
                                        <span class="key-spec-label">Model</span>
                                    </div>
                                    <div class="key-spec-value"><?= htmlspecialchars($product['p_model']) ?></div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <!-- End Key Specification Section -->

                    <!-- Start EMI Calculator Section (New Design) -->
                    <!-- <div class="container emi-calc-main-section">
                        <div class="emi-calc-flex">
                           
                            <div class="emi-calc-left">
                                <div class="emi-calc-title"><?= htmlspecialchars($product['p_name']) ?> <span style="font-weight:400;">EMI</span></div>
                                <div class="emi-calc-group">
                                    <label for="emi-down-payment">Down Payment</label>
                                    <div class="emi-calc-slider-row">
                                        <input type="range" id="emi-down-payment" min="0" max="<?= $product['p_price'] ?>" value="<?= round($product['p_price']*0.1) ?>" step="1000">
                                        <span class="emi-calc-slider-value" id="emi-down-payment-value">₹<?= number_format(round($product['p_price']*0.1)) ?></span>
                                    </div>
                                    <div class="emi-calc-slider-labels">
                                        <span>₹ 0</span>
                                        <span>₹ <?= number_format($product['p_price']) ?></span>
                                    </div>
                                </div>
                                <div class="emi-calc-group">
                                    <label for="emi-interest-rate">Interest Rate</label>
                                    <div class="emi-calc-slider-row">
                                        <input type="range" id="emi-interest-rate" min="8" max="22" value="13" step="0.1">
                                        <span class="emi-calc-slider-value" id="emi-interest-rate-value">13 %</span>
                                    </div>
                                    <div class="emi-calc-slider-labels">
                                        <span>8 %</span>
                                        <span>22 %</span>
                                    </div>
                                </div>
                                <div class="emi-calc-group">
                                    <label>Loan Period (Months)</label>
                                    <div class="emi-calc-loan-periods" id="emi-loan-periods">
                                        <button type="button" class="emi-loan-period-btn" data-months="12">12</button>
                                        <button type="button" class="emi-loan-period-btn" data-months="24">24</button>
                                        <button type="button" class="emi-loan-period-btn" data-months="36">36</button>
                                        <button type="button" class="emi-loan-period-btn" data-months="48">48</button>
                                        <button type="button" class="emi-loan-period-btn active" data-months="60">60</button>
                                        <button type="button" class="emi-loan-period-btn" data-months="72">72</button>
                                        <button type="button" class="emi-loan-period-btn" data-months="84">84</button>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="emi-calc-right">
                                <div class="emi-calc-emi-type-group">
                                    <label class="emi-calc-emi-type">
                                        <input type="radio" name="emi-type" value="1" checked>
                                        <span>EMI<br><small>1 month</small></span>
                                    </label>
                                    <label class="emi-calc-emi-type emi-calc-emi-type-popular">
                                        <input type="radio" name="emi-type" value="3">
                                        <span>EMI<br><small>3 month</small></span>
                                        <span class="emi-calc-popular">Popular</span>
                                    </label>
                                    <label class="emi-calc-emi-type">
                                        <input type="radio" name="emi-type" value="6">
                                        <span>EMI<br><small>6 month</small></span>
                                    </label>
                                </div>
                                <div class="emi-calc-result-box">
                                    <div class="emi-calc-result-label">Your Monthly EMI</div>
                                    <div class="emi-calc-result-value" id="emi-monthly-emi">₹0</div>
                                </div>
                                <div class="emi-calc-summary">
                                    <div class="emi-calc-summary-row">
                                        <span>Ex-Showroom Price</span>
                                        <span id="emi-exshowroom">₹<?= number_format($product['p_price']) ?></span>
                                    </div>
                                    <div class="emi-calc-summary-row">
                                        <span>Total Loan Amount</span>
                                        <span id="emi-loan-amount">₹0</span>
                                    </div>
                                </div>
                                <button class="emi-calc-loan-offer-btn">View Loan Offers</button>
                                <div class="emi-calc-details-link"><a href="#" style="color:#204080;">Check EMI Details</a></div>
                            </div>
                        </div>
                    </div> -->
                    <!-- End EMI Calculator Section (New Design) -->

                    <div class="container what-we-offer-section">
                        <div class="what-we-offer-title">What we offers</div>
                        <div class="offer-cards">
                            <div class="offer-card">
                                <span class="offer-icon">
                                    <!-- Placeholder SVG icon -->
                                    <svg width="56" height="56" viewBox="0 0 56 56" fill="none">
                                        <circle cx="42" cy="16" r="12" fill="#eaf3fa" />
                                        <rect x="14" y="18" width="28" height="20" rx="3" fill="#fff" stroke="#222" stroke-width="2" />
                                        <rect x="18" y="22" width="20" height="8" rx="1.5" fill="#fff" stroke="#222" stroke-width="1.5" />
                                        <rect x="18" y="32" width="8" height="2" rx="1" fill="#d44d53" />
                                    </svg>
                                </span>
                                <div class="offer-label">Best Quality Tractor</div>
                            </div>
                            <div class="offer-card">
                                <span class="offer-icon">
                                    <!-- Placeholder SVG icon -->
                                    <svg width="56" height="56" viewBox="0 0 56 56" fill="none">
                                        <circle cx="42" cy="16" r="12" fill="#eaf3fa" />
                                        <path d="M28 38c2-6 8-8 8-14a8 8 0 10-16 0c0 6 6 8 8 14z" fill="#fff" stroke="#222" stroke-width="2" />
                                        <path d="M28 38v4" stroke="#d44d53" stroke-width="2" />
                                    </svg>
                                </span>
                                <div class="offer-label">Best Price Guaranteed</div>
                            </div>
                            <div class="offer-card">
                                <span class="offer-icon">
                                    <!-- Placeholder SVG icon -->
                                    <svg width="56" height="56" viewBox="0 0 56 56" fill="none">
                                        <circle cx="42" cy="16" r="12" fill="#eaf3fa" />
                                        <path d="M28 36c2-4 8-6 8-10a8 8 0 10-16 0c0 4 6 6 8 10z" fill="#fff" stroke="#222" stroke-width="2" /><text x="28" y="28" text-anchor="middle" fill="#222" font-size="14" font-family="Arial" dy=".3em">₹</text>
                                        <path d="M28 36v4" stroke="#d44d53" stroke-width="2" />
                                    </svg>
                                </span>
                                <div class="offer-label">Get upto 85% loan</div>
                            </div>
                            <div class="offer-card">
                                <span class="offer-icon">
                                    <!-- Placeholder SVG icon -->
                                    <svg width="56" height="56" viewBox="0 0 56 56" fill="none">
                                        <circle cx="42" cy="16" r="12" fill="#eaf3fa" />
                                        <rect x="18" y="18" width="20" height="20" rx="3" fill="#fff" stroke="#222" stroke-width="2" /><text x="28" y="32" text-anchor="middle" fill="#222" font-size="12" font-family="Arial" dy=".3em">RC</text>
                                        <path d="M38 28l4 4-4 4" stroke="#d44d53" stroke-width="2" fill="none" />
                                    </svg>
                                </span>
                                <div class="offer-label">Hassle free RC transfer</div>
                            </div>
                        </div>
                        <button class="call-expert-btn"><i class="fa fa-phone"></i>Call Expert</button>
                    </div>
                    <!-- End What We Offers Section -->


                    <div class="container tractor-checklist-section">
                        <div class="tractor-checklist-title"><?= htmlspecialchars($product['p_name']) ?> Inspection Checklist</div>
                        <div class="checklist-tabs">
                            <button class="checklist-tab active" onclick="showChecklistTab(event, 'exterior')">Exterior</button>
                            <button class="checklist-tab" onclick="showChecklistTab(event, 'interior')">Interior</button>
                            <button class="checklist-tab" onclick="showChecklistTab(event, 'others')">Others</button>
                        </div>
                        <!-- Exterior Tab -->
                        <div class="checklist-tab-content" id="checklist-tab-exterior">
                            <div class="checklist-items">
                                <?php if (!empty($exterior_checklist_items)) {
                                    $total_items = count($exterior_checklist_items);
                                    $items_per_col = ceil($total_items / 4);
                                    for ($col = 0; $col < 4; $col++) { ?>
                                        <div class="checklist-col">
                                            <ul class="checklist-list">
                                                <?php
                                                $start = $col * $items_per_col;
                                                $end = min($start + $items_per_col, $total_items);
                                                for ($i = $start; $i < $end; $i++) { ?>
                                                    <li><span class="checklist-icon"><i class="fa fa-shield"></i></span><?= htmlspecialchars($exterior_checklist_items[$i]['stg_name']) ?></li>
                                                <?php } ?>
                                            </ul>
                                        </div>
                                    <?php } ?>
                                <?php } else { ?>
                                    <div class="checklist-col">
                                        <ul class="checklist-list">
                                            <li><span style="color:#888;">No exterior checklist items.</span></li>
                                        </ul>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                        <!-- Interior Tab -->
                        <div class="checklist-tab-content" id="checklist-tab-interior" style="display:none;">
                            <div class="checklist-items">
                                <?php if (!empty($interior_checklist_items)) {
                                    $total_items = count($interior_checklist_items);
                                    $items_per_col = ceil($total_items / 4);
                                    for ($col = 0; $col < 4; $col++) { ?>
                                        <div class="checklist-col">
                                            <ul class="checklist-list">
                                                <?php
                                                $start = $col * $items_per_col;
                                                $end = min($start + $items_per_col, $total_items);
                                                for ($i = $start; $i < $end; $i++) { ?>
                                                    <li><span class="checklist-icon"><i class="fa fa-shield"></i></span><?= htmlspecialchars($interior_checklist_items[$i]['stg_name']) ?></li>
                                                <?php } ?>
                                            </ul>
                                        </div>
                                    <?php } ?>
                                <?php } else { ?>
                                    <div class="checklist-col">
                                        <ul class="checklist-list">
                                            <li><span style="color:#888;">No interior checklist items.</span></li>
                                        </ul>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                        <!-- Others Tab -->
                        <div class="checklist-tab-content" id="checklist-tab-others" style="display:none;">
                            <div class="checklist-items">
                                <?php if (!empty($other_checklist_items)) {
                                    $total_items = count($other_checklist_items);
                                    $items_per_col = ceil($total_items / 4);
                                    for ($col = 0; $col < 4; $col++) { ?>
                                        <div class="checklist-col">
                                            <ul class="checklist-list">
                                                <?php
                                                $start = $col * $items_per_col;
                                                $end = min($start + $items_per_col, $total_items);
                                                for ($i = $start; $i < $end; $i++) { ?>
                                                    <li><span class="checklist-icon"><i class="fa fa-shield"></i></span><?= htmlspecialchars($other_checklist_items[$i]['stg_name']) ?></li>
                                                <?php } ?>
                                            </ul>
                                        </div>
                                    <?php } ?>
                                <?php } else { ?>
                                    <div class="checklist-col">
                                        <ul class="checklist-list">
                                            <li><span style="color:#888;">No other checklist items.</span></li>
                                        </ul>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                       
                    </div>

                    <!-- End Tractor Inspection Checklist Section -->

                    <script>
                        function showChecklistTab(evt, tabName) {
                            // Hide all tab content
                            var tabContents = document.getElementsByClassName('checklist-tab-content');
                            for (var i = 0; i < tabContents.length; i++) {
                                tabContents[i].style.display = 'none';
                            }

                            // Remove active class from all tabs
                            var tabs = document.getElementsByClassName('checklist-tab');
                            for (var i = 0; i < tabs.length; i++) {
                                tabs[i].classList.remove('active');
                            }

                            // Show the selected tab content and mark the button as active
                            document.getElementById('checklist-tab-' + tabName).style.display = 'block';
                            evt.currentTarget.classList.add('active');
                        }

                        // Initialize: Show the first tab (Exterior) by default
                        document.addEventListener('DOMContentLoaded', function() {
                            document.getElementById('checklist-tab-exterior').style.display = 'block';
                        });
                    </script>

                    <div class="tab tab-nav-boxed tab-nav-underline product-tabs">
                        <ul class="nav nav-tabs" role="tablist">
                            <li class="nav-item">
                                <a href="#product-tab-description" class="nav-link active">Description</a>
                            </li>
                            <li class="nav-item">
                                <a href="#product-tab-specification" class="nav-link">Specification</a>
                            </li>
                            <li class="nav-item">
                                <a href="#product-tab-vendor" class="nav-link">Vendor Info</a>
                            </li>
                            <!-- <li class="nav-item">
                                <a href="#product-tab-reviews" class="nav-link">Customer Reviews (3)</a>
                            </li> -->
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane active" id="product-tab-description">
                                <div class="row mb-4">
                                    <div class="col-md-6 mb-5">
                                        <h4 class="title tab-pane-title font-weight-bold mb-2">Detail</h4>
                                        <p class="mb-4"><?php if (!empty($product['p_descp'])) { ?><?= nl2br(htmlspecialchars($product['p_descp'])) ?><?php } else { ?><span class="text-muted">No description available.</span><?php } ?>
                                           </p>
                                        <ul class="list-type-check">
                                            <li>Nunc nec porttitor turpis. In eu risus enim. In vitae mollis
                                                elit.
                                            </li>
                                            <li>Vivamus finibus vel mauris ut vehicula.</li>
                                            <li>Nullam a magna porttitor, dictum risus nec, faucibus sapien.
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="banner banner-video product-video br-xs">
                                           
                                            <figure class="banner-media"  style="background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%); border-radius: 8px; padding: 20px;">
                                                <a href="#">
                                                    <img src="<?= !empty($product['p_image1']) ? base_url('assets/avator/upload/') . $product['p_image1'] : base_url('assets/theme/v2/assets/images/products/default/1-800x900.jpg') ?>"
                                                    data-zoom-image="<?= !empty($product['p_image1']) ? base_url('assets/avator/upload/') . $product['p_image1'] : base_url('assets/theme/v2/assets/images/products/default/1-800x900.jpg') ?>"
                                                    alt="<?= htmlspecialchars($product['p_name']) ?>" width="800" height="600">
                                                </a>
                                                <a class="btn-play-video btn-iframe"
                                                    href=""></a>
                                            </figure>
                                        </div>
                                    </div>
                                </div>
                                <div class="row cols-md-3">
                                    <div class="mb-3">
                                        <h5 class="sub-title font-weight-bold"><span class="mr-3">1.</span>Free
                                            Shipping &amp; Return</h5>
                                        <p class="detail pl-5">We offer free shipping for products on orders
                                            above 50$ and offer free delivery for all orders in US.</p>
                                    </div>
                                    <div class="mb-3">
                                        <h5 class="sub-title font-weight-bold"><span>2.</span>Free and Easy
                                            Returns</h5>
                                        <p class="detail pl-5">We guarantee our products and you could get back
                                            all of your money anytime you want in 30 days.</p>
                                    </div>
                                    <div class="mb-3">
                                        <h5 class="sub-title font-weight-bold"><span>3.</span>Special Financing
                                        </h5>
                                        <p class="detail pl-5">Get 20%-50% off items over 50$ for a month or
                                            over 250$ for a year with our special credit card.</p>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane" id="product-tab-specification">
                                <ul class="list-none">
                                    <?php if (!empty($product['p_model'])): ?>
                                    <li>
                                        <label>Model</label>
                                        <p><?= htmlspecialchars($product['p_model']) ?></p>
                                    </li>
                                    <?php endif; ?>

                                    <?php if (!empty($product['engine_power'])): ?>
                                    <li>
                                        <label>Engine Power</label>
                                        <p><?= htmlspecialchars($product['engine_power']) ?></p>
                                    </li>
                                    <?php endif; ?>
                                  <?php if (!empty($product['tyre_condition'])): ?>
                                    <li>
                                        <label>Tyre Condtion</label>
                                        <p><?= htmlspecialchars($product['tyre_condition']) ?></p>
                                    </li>
                                    <?php endif; ?>
                                   <?php if (!empty($product['engine_condition'])): ?>
                                    <li>
                                        <label>Engine Condtion</label>
                                        <p><?= htmlspecialchars($product['engine_condition']) ?></p>
                                    </li>
                                    <?php endif; ?>
                                  
                                </ul>
                            </div>
                            <div class="tab-pane" id="product-tab-vendor">
                                <?php if (!empty($product['vendor_name'])): ?>
                                <div class="row mb-3">
                                    <div class="col-md-6 mb-4">
                                        <figure class="product-image">
                                                <img src="<?= !empty($product['p_image1']) ? base_url('assets/avator/upload/') . $product['p_image1'] : base_url('assets/theme/v2/assets/images/products/default/1-800x900.jpg') ?>"
                                                    data-zoom-image="<?= !empty($product['p_image1']) ? base_url('assets/avator/upload/') . $product['p_image1'] : base_url('assets/theme/v2/assets/images/products/default/1-800x900.jpg') ?>"
                                                    alt="<?= htmlspecialchars($product['p_name']) ?>" width="800" height="600">
                                        </figure>
                                    </div>
                                    <div class="col-md-6 pl-2 pl-md-6 mb-4">
                                        <div class="vendor-user">
                                            <figure class="vendor-logo mr-4">
                                                <a href="#">
                                                    <?php if (!empty($product['vendor_profile_pic'])): ?>
                                                        <img src="<?= base_url('assets/avator/upload/') . $product['vendor_profile_pic'] ?>"
                                                            alt="Vendor Logo" width="80" height="80" />
                                                        <!-- Debug: Profile pic path: <?= base_url('assets/avator/upload/') . $product['vendor_profile_pic'] ?> -->
                                                    <?php else: ?>
                                                        <div style="width: 80px; height: 80px; background: #f0f0f0; border-radius: 50%; display: flex; align-items: center; justify-content: center; border: 2px solid #ddd;">
                                                            <i class="fas fa-user" style="font-size: 32px; color: #666;"></i>
                                                        </div>
                                                        <!-- Debug: No profile pic found. Vendor profile_pic value: <?= $product['vendor_profile_pic'] ?> -->
                                                    <?php endif; ?>
                                                </a>
                                            </figure>
                                            <div>
                                                <div class="vendor-name"><a href="#"><?= htmlspecialchars($product['vendor_name']) ?></a></div>
                                                <?php if (!empty($product['brand_name'])): ?>
                                                <div class="vendor-brand" style="display:flex; align-items:center; gap:10px; margin-top:10px;">
                                                    <img src="<?= !empty($product['brand_image']) ? base_url('assets/avator/upload/tags/') . $product['brand_image'] : base_url('assets/theme/v2/assets/images/demos/demo1/brands/1.png') ?>"
                                                         alt="<?= htmlspecialchars($product['brand_name']) ?>"
                                                         style="width:60px; height:40px; object-fit:contain; border-radius:6px; background:#fff; border:1px solid #eee;" />
                                                    <span style="font-weight:600; font-size:16px;"><?= htmlspecialchars($product['brand_name']) ?></span>
                                                </div>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <ul class="vendor-info list-style-none">
                                            <?php if (!empty($product['vendor_address'])): ?>
                                            <li class="store-address">
                                                <label>Address:</label>
                                                <span class="detail"><?= htmlspecialchars($product['vendor_address']) ?></span>
                                            </li>
                                            <?php endif; ?>
                                            <?php if (!empty($product['city_name']) || !empty($product['state_name'])): ?>
                                            <li class="store-location">
                                                <label>Location:</label>
                                                <span class="detail">
                                                    <?= !empty($product['city_name']) ? htmlspecialchars($product['city_name']) : '' ?>
                                                    <?= !empty($product['city_name']) && !empty($product['state_name']) ? ', ' : '' ?>
                                                    <?= !empty($product['state_name']) ? htmlspecialchars($product['state_name']) : '' ?>
                                                </span>
                                            </li>
                                            <?php endif; ?>
                                            <?php if (!empty($product['vendor_phone'])): ?>
                                            <li class="store-phone">
                                                <label>Phone:</label>
                                                <a href="tel:<?= htmlspecialchars($product['vendor_phone']) ?>"><?= htmlspecialchars($product['vendor_phone']) ?></a>
                                            </li>
                                            <?php endif; ?>
                                            <?php if (!empty($product['vendor_email'])): ?>
                                            <li class="store-email">
                                                <label>Email:</label>
                                                <a href="mailto:<?= htmlspecialchars($product['vendor_email']) ?>"><?= htmlspecialchars($product['vendor_email']) ?></a>
                                            </li>
                                            <?php endif; ?>
                                        </ul>
                                    </div>
                                </div>
                                <?php if (!empty($product['vendor_about'])): ?>
                                <div class="vendor-description">
                                    <h4 class="title tab-pane-title font-weight-bold mb-3">About Vendor</h4>
                                    <p class="mb-4"><?= nl2br(htmlspecialchars($product['vendor_about'])) ?></p>
                                </div>
                                <?php endif; ?>
                                <?php else: ?>
                                <div class="text-center py-5">
                                    <div class="vendor-not-found">
                                        <i class="fas fa-user-tie" style="font-size: 3rem; color: #ccc; margin-bottom: 1rem;"></i>
                                        <h4 class="text-muted">Vendor Information Not Available</h4>
                                        <p class="text-muted">This product's vendor information is not currently available.</p>
                                    </div>
                                </div>
                                <?php endif; ?>
                            </div>
                            <!-- <div class="tab-pane" id="product-tab-reviews">
                                <div class="row mb-4">
                                    <div class="col-xl-4 col-lg-5 mb-4">
                                        <div class="ratings-wrapper">
                                            <div class="avg-rating-container">
                                                <h4 class="avg-mark font-weight-bolder ls-50">3.3</h4>
                                                <div class="avg-rating">
                                                    <p class="text-dark mb-1">Average Rating</p>
                                                    <div class="ratings-container">
                                                        <div class="ratings-full">
                                                            <span class="ratings" style="width: 60%;"></span>
                                                            <span class="tooltiptext tooltip-top"></span>
                                                        </div>
                                                        <a href="#" class="rating-reviews">(3 Reviews)</a>
                                                    </div>
                                                </div>
                                            </div>
                                            <div
                                                class="ratings-value d-flex align-items-center text-dark ls-25">
                                                <span
                                                    class="text-dark font-weight-bold">66.7%</span>Recommended<span
                                                    class="count">(2 of 3)</span>
                                            </div>
                                            <div class="ratings-list">
                                                <div class="ratings-container">
                                                    <div class="ratings-full">
                                                        <span class="ratings" style="width: 100%;"></span>
                                                        <span class="tooltiptext tooltip-top"></span>
                                                    </div>
                                                    <div class="progress-bar progress-bar-sm ">
                                                        <span></span>
                                                    </div>
                                                    <div class="progress-value">
                                                        <mark>70%</mark>
                                                    </div>
                                                </div>
                                                <div class="ratings-container">
                                                    <div class="ratings-full">
                                                        <span class="ratings" style="width: 80%;"></span>
                                                        <span class="tooltiptext tooltip-top"></span>
                                                    </div>
                                                    <div class="progress-bar progress-bar-sm ">
                                                        <span></span>
                                                    </div>
                                                    <div class="progress-value">
                                                        <mark>30%</mark>
                                                    </div>
                                                </div>
                                                <div class="ratings-container">
                                                    <div class="ratings-full">
                                                        <span class="ratings" style="width: 60%;"></span>
                                                        <span class="tooltiptext tooltip-top"></span>
                                                    </div>
                                                    <div class="progress-bar progress-bar-sm ">
                                                        <span></span>
                                                    </div>
                                                    <div class="progress-value">
                                                        <mark>40%</mark>
                                                    </div>
                                                </div>
                                                <div class="ratings-container">
                                                    <div class="ratings-full">
                                                        <span class="ratings" style="width: 40%;"></span>
                                                        <span class="tooltiptext tooltip-top"></span>
                                                    </div>
                                                    <div class="progress-bar progress-bar-sm ">
                                                        <span></span>
                                                    </div>
                                                    <div class="progress-value">
                                                        <mark>0%</mark>
                                                    </div>
                                                </div>
                                                <div class="ratings-container">
                                                    <div class="ratings-full">
                                                        <span class="ratings" style="width: 20%;"></span>
                                                        <span class="tooltiptext tooltip-top"></span>
                                                    </div>
                                                    <div class="progress-bar progress-bar-sm ">
                                                        <span></span>
                                                    </div>
                                                    <div class="progress-value">
                                                        <mark>0%</mark>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xl-8 col-lg-7 mb-4">
                                        <div class="review-form-wrapper">
                                            <h3 class="title tab-pane-title font-weight-bold mb-1">Submit Your
                                                Review</h3>
                                            <p class="mb-3">Your email address will not be published. Required
                                                fields are marked *</p>
                                            <form action="#" method="POST" class="review-form">
                                                <div class="rating-form">
                                                    <label for="rating">Your Rating Of This Product :</label>
                                                    <span class="rating-stars">
                                                        <a class="star-1" href="#">1</a>
                                                        <a class="star-2" href="#">2</a>
                                                        <a class="star-3" href="#">3</a>
                                                        <a class="star-4" href="#">4</a>
                                                        <a class="star-5" href="#">5</a>
                                                    </span>
                                                    <select name="rating" id="rating" required=""
                                                        style="display: none;">
                                                        <option value="">Rate…</option>
                                                        <option value="5">Perfect</option>
                                                        <option value="4">Good</option>
                                                        <option value="3">Average</option>
                                                        <option value="2">Not that bad</option>
                                                        <option value="1">Very poor</option>
                                                    </select>
                                                </div>
                                                <textarea cols="30" rows="6"
                                                    placeholder="Write Your Review Here..." class="form-control"
                                                    id="review"></textarea>
                                                <div class="row gutter-md">
                                                    <div class="col-md-6">
                                                        <input type="text" class="form-control"
                                                            placeholder="Your Name" id="author">
                                                    </div>
                                                    <div class="col-md-6">
                                                        <input type="text" class="form-control"
                                                            placeholder="Your Email" id="email_1">
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <input type="checkbox" class="custom-checkbox"
                                                        id="save-checkbox">
                                                    <label for="save-checkbox">Save my name, email, and website
                                                        in this browser for the next time I comment.</label>
                                                </div>
                                                <button type="submit" class="btn btn-dark">Submit
                                                    Review</button>
                                            </form>
                                        </div>
                                    </div>
                                </div>

                                <div class="tab tab-nav-boxed tab-nav-outline tab-nav-center">
                                    <ul class="nav nav-tabs" role="tablist">
                                        <li class="nav-item">
                                            <a href="#show-all" class="nav-link active">Show All</a>
                                        </li>
                                        <li class="nav-item">
                                            <a href="#helpful-positive" class="nav-link">Most Helpful
                                                Positive</a>
                                        </li>
                                        <li class="nav-item">
                                            <a href="#helpful-negative" class="nav-link">Most Helpful
                                                Negative</a>
                                        </li>
                                        <li class="nav-item">
                                            <a href="#highest-rating" class="nav-link">Highest Rating</a>
                                        </li>
                                        <li class="nav-item">
                                            <a href="#lowest-rating" class="nav-link">Lowest Rating</a>
                                        </li>
                                    </ul>
                                    <div class="tab-content">
                                        <div class="tab-pane active" id="show-all">
                                            <ul class="comments list-style-none">
                                                <li class="comment">
                                                    <div class="comment-body">
                                                        <figure class="comment-avatar">
                                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/agents/1-100x100.png"
                                                                alt="Commenter Avatar" width="90" height="90">
                                                        </figure>
                                                        <div class="comment-content">
                                                            <h4 class="comment-author">
                                                                <a href="#">John Doe</a>
                                                                <span class="comment-date">March 22, 2021 at
                                                                    1:54 pm</span>
                                                            </h4>
                                                            <div class="ratings-container comment-rating">
                                                                <div class="ratings-full">
                                                                    <span class="ratings"
                                                                        style="width: 60%;"></span>
                                                                    <span
                                                                        class="tooltiptext tooltip-top"></span>
                                                                </div>
                                                            </div>
                                                            <p>pellentesque habitant morbi tristique senectus
                                                                et. In dictum non consectetur a erat.
                                                                Nunc ultrices eros in cursus turpis massa
                                                                tincidunt ante in nibh mauris cursus mattis.
                                                                Cras ornare arcu dui vivamus arcu felis bibendum
                                                                ut tristique.</p>
                                                            <div class="comment-action">
                                                                <a href="#"
                                                                    class="btn btn-secondary btn-link btn-underline sm btn-icon-left font-weight-normal text-capitalize">
                                                                    <i class="far fa-thumbs-up"></i>Helpful (1)
                                                                </a>
                                                                <a href="#"
                                                                    class="btn btn-dark btn-link btn-underline sm btn-icon-left font-weight-normal text-capitalize">
                                                                    <i class="far fa-thumbs-down"></i>Unhelpful
                                                                    (0)
                                                                </a>
                                                                <div class="review-image">
                                                                    <a href="#">
                                                                        <figure>
                                                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/products/default/review-img-1.jpg"
                                                                                width="60" height="60"
                                                                                alt="Attachment image of John Doe's review on Electronics Black Wrist Watch"
                                                                                data-zoom-image="assets/images/products/default/review-img-1-800x900.jpg" />
                                                                        </figure>
                                                                    </a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li class="comment">
                                                    <div class="comment-body">
                                                        <figure class="comment-avatar">
                                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/agents/2-100x100.png"
                                                                alt="Commenter Avatar" width="90" height="90">
                                                        </figure>
                                                        <div class="comment-content">
                                                            <h4 class="comment-author">
                                                                <a href="#">John Doe</a>
                                                                <span class="comment-date">March 22, 2021 at
                                                                    1:52 pm</span>
                                                            </h4>
                                                            <div class="ratings-container comment-rating">
                                                                <div class="ratings-full">
                                                                    <span class="ratings"
                                                                        style="width: 80%;"></span>
                                                                    <span
                                                                        class="tooltiptext tooltip-top"></span>
                                                                </div>
                                                            </div>
                                                            <p>Nullam a magna porttitor, dictum risus nec,
                                                                faucibus sapien.
                                                                Ultrices eros in cursus turpis massa tincidunt
                                                                ante in nibh mauris cursus mattis.
                                                                Cras ornare arcu dui vivamus arcu felis bibendum
                                                                ut tristique.</p>
                                                            <div class="comment-action">
                                                                <a href="#"
                                                                    class="btn btn-secondary btn-link btn-underline sm btn-icon-left font-weight-normal text-capitalize">
                                                                    <i class="far fa-thumbs-up"></i>Helpful (1)
                                                                </a>
                                                                <a href="#"
                                                                    class="btn btn-dark btn-link btn-underline sm btn-icon-left font-weight-normal text-capitalize">
                                                                    <i class="far fa-thumbs-down"></i>Unhelpful
                                                                    (0)
                                                                </a>
                                                                <div class="review-image">
                                                                    <a href="#">
                                                                        <figure>
                                                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/products/default/review-img-2.jpg"
                                                                                width="60" height="60"
                                                                                alt="Attachment image of John Doe's review on Electronics Black Wrist Watch"
                                                                                data-zoom-image="assets/images/products/default/review-img-2.jpg" />
                                                                        </figure>
                                                                    </a>
                                                                    <a href="#">
                                                                        <figure>
                                                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/products/default/review-img-3.jpg"
                                                                                width="60" height="60"
                                                                                alt="Attachment image of John Doe's review on Electronics Black Wrist Watch"
                                                                                data-zoom-image="assets/images/products/default/review-img-3.jpg" />
                                                                        </figure>
                                                                    </a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li class="comment">
                                                    <div class="comment-body">
                                                        <figure class="comment-avatar">
                                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/agents/3-100x100.png"
                                                                alt="Commenter Avatar" width="90" height="90">
                                                        </figure>
                                                        <div class="comment-content">
                                                            <h4 class="comment-author">
                                                                <a href="#">John Doe</a>
                                                                <span class="comment-date">March 22, 2021 at
                                                                    1:21 pm</span>
                                                            </h4>
                                                            <div class="ratings-container comment-rating">
                                                                <div class="ratings-full">
                                                                    <span class="ratings"
                                                                        style="width: 60%;"></span>
                                                                    <span
                                                                        class="tooltiptext tooltip-top"></span>
                                                                </div>
                                                            </div>
                                                            <p>In fermentum et sollicitudin ac orci phasellus. A
                                                                condimentum vitae
                                                                sapien pellentesque habitant morbi tristique
                                                                senectus et. In dictum
                                                                non consectetur a erat. Nunc scelerisque viverra
                                                                mauris in aliquam sem fringilla.</p>
                                                            <div class="comment-action">
                                                                <a href="#"
                                                                    class="btn btn-secondary btn-link btn-underline sm btn-icon-left font-weight-normal text-capitalize">
                                                                    <i class="far fa-thumbs-up"></i>Helpful (0)
                                                                </a>
                                                                <a href="#"
                                                                    class="btn btn-dark btn-link btn-underline sm btn-icon-left font-weight-normal text-capitalize">
                                                                    <i class="far fa-thumbs-down"></i>Unhelpful
                                                                    (1)
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="tab-pane" id="helpful-positive">
                                            <ul class="comments list-style-none">
                                                <li class="comment">
                                                    <div class="comment-body">
                                                        <figure class="comment-avatar">
                                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/agents/1-100x100.png"
                                                                alt="Commenter Avatar" width="90" height="90">
                                                        </figure>
                                                        <div class="comment-content">
                                                            <h4 class="comment-author">
                                                                <a href="#">John Doe</a>
                                                                <span class="comment-date">March 22, 2021 at
                                                                    1:54 pm</span>
                                                            </h4>
                                                            <div class="ratings-container comment-rating">
                                                                <div class="ratings-full">
                                                                    <span class="ratings"
                                                                        style="width: 60%;"></span>
                                                                    <span
                                                                        class="tooltiptext tooltip-top"></span>
                                                                </div>
                                                            </div>
                                                            <p>pellentesque habitant morbi tristique senectus
                                                                et. In dictum non consectetur a erat.
                                                                Nunc ultrices eros in cursus turpis massa
                                                                tincidunt ante in nibh mauris cursus mattis.
                                                                Cras ornare arcu dui vivamus arcu felis bibendum
                                                                ut tristique.</p>
                                                            <div class="comment-action">
                                                                <a href="#"
                                                                    class="btn btn-secondary btn-link btn-underline sm btn-icon-left font-weight-normal text-capitalize">
                                                                    <i class="far fa-thumbs-up"></i>Helpful (1)
                                                                </a>
                                                                <a href="#"
                                                                    class="btn btn-dark btn-link btn-underline sm btn-icon-left font-weight-normal text-capitalize">
                                                                    <i class="far fa-thumbs-down"></i>Unhelpful
                                                                    (0)
                                                                </a>
                                                                <div class="review-image">
                                                                    <a href="#">
                                                                        <figure>
                                                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/products/default/review-img-1.jpg"
                                                                                width="60" height="60"
                                                                                alt="Attachment image of John Doe's review on Electronics Black Wrist Watch"
                                                                                data-zoom-image="assets/images/products/default/review-img-1.jpg" />
                                                                        </figure>
                                                                    </a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li class="comment">
                                                    <div class="comment-body">
                                                        <figure class="comment-avatar">
                                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/agents/2-100x100.png"
                                                                alt="Commenter Avatar" width="90" height="90">
                                                        </figure>
                                                        <div class="comment-content">
                                                            <h4 class="comment-author">
                                                                <a href="#">John Doe</a>
                                                                <span class="comment-date">March 22, 2021 at
                                                                    1:52 pm</span>
                                                            </h4>
                                                            <div class="ratings-container comment-rating">
                                                                <div class="ratings-full">
                                                                    <span class="ratings"
                                                                        style="width: 80%;"></span>
                                                                    <span
                                                                        class="tooltiptext tooltip-top"></span>
                                                                </div>
                                                            </div>
                                                            <p>Nullam a magna porttitor, dictum risus nec,
                                                                faucibus sapien.
                                                                Ultrices eros in cursus turpis massa tincidunt
                                                                ante in nibh mauris cursus mattis.
                                                                Cras ornare arcu dui vivamus arcu felis bibendum
                                                                ut tristique.</p>
                                                            <div class="comment-action">
                                                                <a href="#"
                                                                    class="btn btn-secondary btn-link btn-underline sm btn-icon-left font-weight-normal text-capitalize">
                                                                    <i class="far fa-thumbs-up"></i>Helpful (1)
                                                                </a>
                                                                <a href="#"
                                                                    class="btn btn-dark btn-link btn-underline sm btn-icon-left font-weight-normal text-capitalize">
                                                                    <i class="far fa-thumbs-down"></i>Unhelpful
                                                                    (0)
                                                                </a>
                                                                <div class="review-image">
                                                                    <a href="#">
                                                                        <figure>
                                                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/products/default/review-img-2.jpg"
                                                                                width="60" height="60"
                                                                                alt="Attachment image of John Doe's review on Electronics Black Wrist Watch"
                                                                                data-zoom-image="assets/images/products/default/review-img-2-800x900.jpg" />
                                                                        </figure>
                                                                    </a>
                                                                    <a href="#">
                                                                        <figure>
                                                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/products/default/review-img-3.jpg"
                                                                                width="60" height="60"
                                                                                alt="Attachment image of John Doe's review on Electronics Black Wrist Watch"
                                                                                data-zoom-image="assets/images/products/default/review-img-3-800x900.jpg" />
                                                                        </figure>
                                                                    </a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="tab-pane" id="helpful-negative">
                                            <ul class="comments list-style-none">
                                                <li class="comment">
                                                    <div class="comment-body">
                                                        <figure class="comment-avatar">
                                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/agents/3-100x100.png"
                                                                alt="Commenter Avatar" width="90" height="90">
                                                        </figure>
                                                        <div class="comment-content">
                                                            <h4 class="comment-author">
                                                                <a href="#">John Doe</a>
                                                                <span class="comment-date">March 22, 2021 at
                                                                    1:21 pm</span>
                                                            </h4>
                                                            <div class="ratings-container comment-rating">
                                                                <div class="ratings-full">
                                                                    <span class="ratings"
                                                                        style="width: 60%;"></span>
                                                                    <span
                                                                        class="tooltiptext tooltip-top"></span>
                                                                </div>
                                                            </div>
                                                            <p>In fermentum et sollicitudin ac orci phasellus. A
                                                                condimentum vitae
                                                                sapien pellentesque habitant morbi tristique
                                                                senectus et. In dictum
                                                                non consectetur a erat. Nunc scelerisque viverra
                                                                mauris in aliquam sem fringilla.</p>
                                                            <div class="comment-action">
                                                                <a href="#"
                                                                    class="btn btn-secondary btn-link btn-underline sm btn-icon-left font-weight-normal text-capitalize">
                                                                    <i class="far fa-thumbs-up"></i>Helpful (0)
                                                                </a>
                                                                <a href="#"
                                                                    class="btn btn-dark btn-link btn-underline sm btn-icon-left font-weight-normal text-capitalize">
                                                                    <i class="far fa-thumbs-down"></i>Unhelpful
                                                                    (1)
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="tab-pane" id="highest-rating">
                                            <ul class="comments list-style-none">
                                                <li class="comment">
                                                    <div class="comment-body">
                                                        <figure class="comment-avatar">
                                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/agents/2-100x100.png"
                                                                alt="Commenter Avatar" width="90" height="90">
                                                        </figure>
                                                        <div class="comment-content">
                                                            <h4 class="comment-author">
                                                                <a href="#">John Doe</a>
                                                                <span class="comment-date">March 22, 2021 at
                                                                    1:52 pm</span>
                                                            </h4>
                                                            <div class="ratings-container comment-rating">
                                                                <div class="ratings-full">
                                                                    <span class="ratings"
                                                                        style="width: 80%;"></span>
                                                                    <span
                                                                        class="tooltiptext tooltip-top"></span>
                                                                </div>
                                                            </div>
                                                            <p>Nullam a magna porttitor, dictum risus nec,
                                                                faucibus sapien.
                                                                Ultrices eros in cursus turpis massa tincidunt
                                                                ante in nibh mauris cursus mattis.
                                                                Cras ornare arcu dui vivamus arcu felis bibendum
                                                                ut tristique.</p>
                                                            <div class="comment-action">
                                                                <a href="#"
                                                                    class="btn btn-secondary btn-link btn-underline sm btn-icon-left font-weight-normal text-capitalize">
                                                                    <i class="far fa-thumbs-up"></i>Helpful (1)
                                                                </a>
                                                                <a href="#"
                                                                    class="btn btn-dark btn-link btn-underline sm btn-icon-left font-weight-normal text-capitalize">
                                                                    <i class="far fa-thumbs-down"></i>Unhelpful
                                                                    (0)
                                                                </a>
                                                                <div class="review-image">
                                                                    <a href="#">
                                                                        <figure>
                                                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/products/default/review-img-2.jpg"
                                                                                width="60" height="60"
                                                                                alt="Attachment image of John Doe's review on Electronics Black Wrist Watch"
                                                                                data-zoom-image="assets/images/products/default/review-img-2-800x900.jpg" />
                                                                        </figure>
                                                                    </a>
                                                                    <a href="#">
                                                                        <figure>
                                                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/products/default/review-img-3.jpg"
                                                                                width="60" height="60"
                                                                                alt="Attachment image of John Doe's review on Electronics Black Wrist Watch"
                                                                                data-zoom-image="assets/images/products/default/review-img-3-800x900.jpg" />
                                                                        </figure>
                                                                    </a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="tab-pane" id="lowest-rating">
                                            <ul class="comments list-style-none">
                                                <li class="comment">
                                                    <div class="comment-body">
                                                        <figure class="comment-avatar">
                                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/agents/1-100x100.png"
                                                                alt="Commenter Avatar" width="90" height="90">
                                                        </figure>
                                                        <div class="comment-content">
                                                            <h4 class="comment-author">
                                                                <a href="#">John Doe</a>
                                                                <span class="comment-date">March 22, 2021 at
                                                                    1:54 pm</span>
                                                            </h4>
                                                            <div class="ratings-container comment-rating">
                                                                <div class="ratings-full">
                                                                    <span class="ratings"
                                                                        style="width: 60%;"></span>
                                                                    <span
                                                                        class="tooltiptext tooltip-top"></span>
                                                                </div>
                                                            </div>
                                                            <p>pellentesque habitant morbi tristique senectus
                                                                et. In dictum non consectetur a erat.
                                                                Nunc ultrices eros in cursus turpis massa
                                                                tincidunt ante in nibh mauris cursus mattis.
                                                                Cras ornare arcu dui vivamus arcu felis bibendum
                                                                ut tristique.</p>
                                                            <div class="comment-action">
                                                                <a href="#"
                                                                    class="btn btn-secondary btn-link btn-underline sm btn-icon-left font-weight-normal text-capitalize">
                                                                    <i class="far fa-thumbs-up"></i>Helpful (1)
                                                                </a>
                                                                <a href="#"
                                                                    class="btn btn-dark btn-link btn-underline sm btn-icon-left font-weight-normal text-capitalize">
                                                                    <i class="far fa-thumbs-down"></i>Unhelpful
                                                                    (0)
                                                                </a>
                                                                <div class="review-image">
                                                                    <a href="#">
                                                                        <figure>
                                                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/products/default/review-img-3.jpg"
                                                                                width="60" height="60"
                                                                                alt="Attachment image of John Doe's review on Electronics Black Wrist Watch"
                                                                                data-zoom-image="assets/images/products/default/review-img-3-800x900.jpg" />
                                                                        </figure>
                                                                    </a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div> -->
                        </div>
                    </div>
                                        <?php if (!empty($vendor_products)): ?>
                    <section class="vendor-product-section">
                        <div class="title-link-wrapper mb-4">
                            <h4 class="title text-left">More Products From This Vendor</h4>
                            <a href="<?= base_url('shop?vendor=' . $product['p_vendor']) ?>" class="btn btn-dark btn-link btn-slide-right btn-icon-right">More
                                Products<i class="w-icon-long-arrow-right"></i></a>
                        </div>
                        <div class="vendor-products-grid">
                            <?php foreach ($vendor_products as $vendor_product): ?>
                            <div class="vendor-product-card">
                                <div class="product text-center" style="display:flex; flex-direction:column; height:100%;">
                                    <figure class="product-media" style="background:#F4F4F4; min-height:243px; display:flex; align-items:center; justify-content:center;">
                                        <a href="<?= base_url('product/' . $vendor_product['p_id'] . '/' . url_title($vendor_product['p_name'], 'dash', TRUE)) ?>">
                                            <img src="<?= !empty($vendor_product['p_image1']) ? base_url('assets/avator/upload/') . $vendor_product['p_image1'] : base_url('assets/theme/v2/assets/images/products/default/1-800x900.jpg') ?>"
                                                alt="<?= htmlspecialchars($vendor_product['p_name']) ?>"
                                                width="216" height="180"
                                                style="object-fit:contain; width:216px; height:180px; display:block; margin:auto;" />
                                        </a>
                                    </figure>
                                    <div class="product-details" style="flex:1 0 auto;">
                                        <div style="height:22px; line-height:22px; overflow:hidden; text-align:center; margin-bottom:4px;">
                                            <h4 class="product-name" style="font-size:14px; font-weight:500; margin:0; padding:0; white-space:nowrap; overflow:hidden; text-overflow:ellipsis;">
                                                <a href="<?= base_url('product/' . $vendor_product['p_id'] . '/' . url_title($vendor_product['p_name'], 'dash', TRUE)) ?>" style="color:#222; text-decoration:none; display:block; white-space:nowrap; overflow:hidden; text-overflow:ellipsis;">
                                                    <?= htmlspecialchars($vendor_product['p_name']) ?>
                                                </a>
                                            </h4>
                                        </div>
                                        <div style="font-size:15px; font-weight:600; color:#222; margin-bottom:2px;">Model: <span style="font-weight:400; color:#444;"><?= !empty($vendor_product['p_model']) ? htmlspecialchars($vendor_product['p_model']) : '&nbsp;' ?></span></div>
                                        <div style="font-size:15px; font-weight:600; color:#222; margin-bottom:8px;">Engine Power: <span style="font-weight:400; color:#444;"><?= !empty($vendor_product['engine_power']) ? htmlspecialchars($vendor_product['engine_power']) : '&nbsp;' ?></span></div>
                                        <div class="product-price">
                                            <?php if ($vendor_product['p_discount'] > 0) { ?>
                                                <ins class="new-price">₹<?= number_format($vendor_product['p_price'] - ($vendor_product['p_price'] * $vendor_product['p_discount'] / 100), 2) ?></ins>
                                                <del class="old-price">₹<?= number_format($vendor_product['p_price'], 2) ?></del>
                                            <?php } else { ?>
                                                <ins class="new-price">₹<?= number_format($vendor_product['p_price'], 2) ?></ins>
                                            <?php } ?>
                                        </div>
                                        <!-- Book Now Button -->
                                        <div class="mt-2 mb-2" style="margin-top:auto;">
                                            <a href="<?= base_url('product/' . $vendor_product['p_id'] . '/' . url_title($vendor_product['p_name'], 'dash', TRUE)) ?>" class="btn btn-primary btn-rounded btn-block" style="min-width:120px; font-weight:600; font-size:15px;">Book Now</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </section>

                    <style>
                    /* Vendor Products Grid - Mobile Responsive */
                    .vendor-products-grid {
                        display: grid;
                        grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
                        gap: 20px;
                        margin: 0;
                        padding: 0;
                    }

                    .vendor-product-card {
                        border: 1px solid #e0e6ed;
                        box-shadow: 0 2px 12px 0 rgba(40,60,90,0.08);
                        border-radius: 10px;
                        display: flex;
                        flex-direction: column;
                        height: 100%;
                        padding: 0 10px;
                        background: #fff;
                        transition: transform 0.2s ease, box-shadow 0.2s ease;
                    }

                    .vendor-product-card:hover {
                        transform: translateY(-2px);
                        box-shadow: 0 4px 20px 0 rgba(40,60,90,0.12);
                    }

                    .vendor-product-card .product {
                        display: flex;
                        flex-direction: column;
                        height: 100%;
                        padding: 15px 0;
                    }

                    .vendor-product-card .product-media {
                        background: #F4F4F4;
                        min-height: 200px;
                        display: flex;
                        align-items: center;
                        justify-content: center;
                        border-radius: 8px;
                        margin-bottom: 15px;
                        overflow: hidden;
                    }

                    .vendor-product-card .product-media img {
                        object-fit: contain;
                        width: 100%;
                        max-width: 216px;
                        height: 180px;
                        display: block;
                        margin: auto;
                        transition: transform 0.2s ease;
                    }

                    .vendor-product-card .product-media:hover img {
                        transform: scale(1.05);
                    }

                    .vendor-product-card .product-details {
                        flex: 1 0 auto;
                        display: flex;
                        flex-direction: column;
                    }

                    .vendor-product-card .product-name {
                        font-size: 14px;
                        font-weight: 500;
                        margin: 0 0 8px 0;
                        padding: 0;
                        line-height: 1.3;
                        height: auto;
                        overflow: hidden;
                        text-overflow: ellipsis;
                        display: -webkit-box;
                        -webkit-line-clamp: 2;
                        -webkit-box-orient: vertical;
                    }

                    .vendor-product-card .product-name a {
                        color: #222;
                        text-decoration: none;
                        display: block;
                        line-height: 1.3;
                    }

                    .vendor-product-card .product-name a:hover {
                        color: #336699;
                    }

                    .vendor-product-card .product-price {
                        margin: 10px 0;
                        font-weight: 600;
                        font-size: 16px;
                    }

                    .vendor-product-card .new-price {
                        color: #336699;
                    }

                    .vendor-product-card .old-price {
                        color: #999;
                        text-decoration: line-through;
                        margin-left: 8px;
                        font-size: 14px;
                    }

                    .vendor-product-card .btn-primary {
                        min-width: 120px;
                        font-weight: 600;
                        font-size: 14px;
                        padding: 10px 20px;
                        margin-top: auto;
                        border-radius: 6px;
                        transition: all 0.2s ease;
                    }

                    .vendor-product-card .btn-primary:hover {
                        transform: translateY(-1px);
                        box-shadow: 0 2px 8px rgba(51, 102, 153, 0.3);
                    }

                    /* Mobile Responsive Breakpoints */
                    @media (max-width: 1200px) {
                        .vendor-products-grid {
                            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
                            gap: 15px;
                        }
                    }

                    @media (max-width: 991px) {
                        .vendor-products-grid {
                            grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
                            gap: 12px;
                        }

                        .vendor-product-card .product-media {
                            min-height: 180px;
                        }

                        .vendor-product-card .product-media img {
                            max-width: 180px;
                            height: 150px;
                        }
                    }

                    @media (max-width: 768px) {
                        .vendor-products-grid {
                            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
                            gap: 10px;
                        }

                        .vendor-product-card {
                            padding: 0 8px;
                        }

                        .vendor-product-card .product {
                            padding: 12px 0;
                        }

                        .vendor-product-card .product-media {
                            min-height: 160px;
                            margin-bottom: 12px;
                        }

                        .vendor-product-card .product-media img {
                            max-width: 160px;
                            height: 130px;
                        }

                        .vendor-product-card .product-name {
                            font-size: 13px;
                            margin-bottom: 6px;
                        }

                        .vendor-product-card .product-price {
                            margin: 8px 0;
                            font-size: 15px;
                        }

                        .vendor-product-card .btn-primary {
                            min-width: 100px;
                            font-size: 13px;
                            padding: 8px 16px;
                        }
                    }

                    @media (max-width: 576px) {
                        .vendor-products-grid {
                            grid-template-columns: repeat(auto-fit, minmax(160px, 1fr));
                            gap: 8px;
                        }

                        .vendor-product-card {
                            padding: 0 6px;
                        }

                        .vendor-product-card .product {
                            padding: 10px 0;
                        }

                        .vendor-product-card .product-media {
                            min-height: 140px;
                            margin-bottom: 10px;
                        }

                        .vendor-product-card .product-media img {
                            max-width: 140px;
                            height: 110px;
                        }

                        .vendor-product-card .product-name {
                            font-size: 12px;
                            margin-bottom: 5px;
                            -webkit-line-clamp: 2;
                        }

                        .vendor-product-card .product-price {
                            margin: 6px 0;
                            font-size: 14px;
                        }

                        .vendor-product-card .btn-primary {
                            min-width: 90px;
                            font-size: 12px;
                            padding: 6px 12px;
                        }

                        .vendor-product-card .product-details > div {
                            font-size: 12px;
                            margin-bottom: 4px;
                        }
                    }

                    @media (max-width: 480px) {
                        .vendor-products-grid {
                            grid-template-columns: repeat(auto-fit, minmax(140px, 1fr));
                            gap: 6px;
                        }

                        .vendor-product-card {
                            padding: 0 4px;
                        }

                        .vendor-product-card .product {
                            padding: 8px 0;
                        }

                        .vendor-product-card .product-media {
                            min-height: 120px;
                            margin-bottom: 8px;
                        }

                        .vendor-product-card .product-media img {
                            max-width: 120px;
                            height: 100px;
                        }

                        .vendor-product-card .product-name {
                            font-size: 11px;
                            margin-bottom: 4px;
                            -webkit-line-clamp: 1;
                        }

                        .vendor-product-card .product-price {
                            margin: 5px 0;
                            font-size: 13px;
                        }

                        .vendor-product-card .btn-primary {
                            min-width: 80px;
                            font-size: 11px;
                            padding: 5px 10px;
                        }

                        .vendor-product-card .product-details > div {
                            font-size: 11px;
                            margin-bottom: 3px;
                        }
                    }

                    /* Title section responsive */
                    @media (max-width: 768px) {
                        .vendor-product-section .title-link-wrapper {
                            flex-direction: column;
                            align-items: flex-start;
                            gap: 10px;
                        }

                        .vendor-product-section .title-link-wrapper .title {
                            font-size: 18px;
                            margin-bottom: 0;
                        }

                        .vendor-product-section .title-link-wrapper .btn {
                            font-size: 14px;
                            padding: 8px 16px;
                        }
                    }

                    @media (max-width: 576px) {
                        .vendor-product-section .title-link-wrapper .title {
                            font-size: 16px;
                        }

                        .vendor-product-section .title-link-wrapper .btn {
                            font-size: 13px;
                            padding: 6px 12px;
                        }
                    }
                    </style>
                    <?php endif; ?>
                    <!-- <section class="related-product-section">
                        <div class="title-link-wrapper mb-4">
                            <h4 class="title">Related Products</h4>
                            <a href="#" class="btn btn-dark btn-link btn-slide-right btn-icon-right">More
                                Products<i class="w-icon-long-arrow-right"></i></a>
                        </div>
                        <div class="swiper-container swiper-theme" data-swiper-options="{
                                    'spaceBetween': 20,
                                    'slidesPerView': 2,
                                    'breakpoints': {
                                        '576': {
                                            'slidesPerView': 3
                                        },
                                        '768': {
                                            'slidesPerView': 4
                                        },
                                        '992': {
                                            'slidesPerView': 3
                                        }
                                    }
                                }">
                            <div class="swiper-wrapper row cols-lg-3 cols-md-4 cols-sm-3 cols-2">
                                <div class="swiper-slide product">
                                    <figure class="product-media">
                                        <a href="product-default.html">
                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/products/default/5.jpg" alt="Product"
                                                width="300" height="338" />
                                        </a>
                                        <div class="product-action-vertical">
                                            <a href="#" class="btn-product-icon btn-cart w-icon-cart"
                                                title="Add to cart"></a>
                                            <a href="#" class="btn-product-icon btn-wishlist w-icon-heart"
                                                title="Add to wishlist"></a>
                                            <a href="#" class="btn-product-icon btn-compare w-icon-compare"
                                                title="Add to Compare"></a>
                                        </div>
                                        <div class="product-action">
                                            <a href="#" class="btn-product btn-quickview" title="Quick View">Quick
                                                View</a>
                                        </div>
                                    </figure>
                                    <div class="product-details">
                                        <h4 class="product-name"><a href="product-default.html">Drone</a></h4>
                                        <div class="ratings-container">
                                            <div class="ratings-full">
                                                <span class="ratings" style="width: 100%;"></span>
                                                <span class="tooltiptext tooltip-top"></span>
                                            </div>
                                            <a href="product-default.html" class="rating-reviews">(3 reviews)</a>
                                        </div>
                                        <div class="product-pa-wrapper">
                                            <div class="product-price">$632.00</div>
                                        </div>
                                    </div>
                                </div>
                                <div class="swiper-slide product">
                                    <figure class="product-media">
                                        <a href="product-default.html">
                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/products/default/6.jpg" alt="Product"
                                                width="300" height="338" />
                                        </a>
                                        <div class="product-action-vertical">
                                            <a href="#" class="btn-product-icon btn-cart w-icon-cart"
                                                title="Add to cart"></a>
                                            <a href="#" class="btn-product-icon btn-wishlist w-icon-heart"
                                                title="Add to wishlist"></a>
                                            <a href="#" class="btn-product-icon btn-compare w-icon-compare"
                                                title="Add to Compare"></a>
                                        </div>
                                        <div class="product-action">
                                            <a href="#" class="btn-product btn-quickview" title="Quick View">Quick
                                                View</a>
                                        </div>
                                    </figure>
                                    <div class="product-details">
                                        <h4 class="product-name"><a href="product-default.html">Official Camera</a>
                                        </h4>
                                        <div class="ratings-container">
                                            <div class="ratings-full">
                                                <span class="ratings" style="width: 100%;"></span>
                                                <span class="tooltiptext tooltip-top"></span>
                                            </div>
                                            <a href="product-default.html" class="rating-reviews">(3 reviews)</a>
                                        </div>
                                        <div class="product-pa-wrapper">
                                            <div class="product-price">
                                                <ins class="new-price">$263.00</ins><del
                                                    class="old-price">$300.00</del>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="swiper-slide product">
                                    <figure class="product-media">
                                        <a href="product-default.html">
                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/products/default/7-1.jpg" alt="Product"
                                                width="300" height="338" />
                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/products/default/7-2.jpg" alt="Product"
                                                width="300" height="338" />
                                        </a>
                                        <div class="product-action-vertical">
                                            <a href="#" class="btn-product-icon btn-cart w-icon-cart"
                                                title="Add to cart"></a>
                                            <a href="#" class="btn-product-icon btn-wishlist w-icon-heart"
                                                title="Add to wishlist"></a>
                                            <a href="#" class="btn-product-icon btn-compare w-icon-compare"
                                                title="Add to Compare"></a>
                                        </div>
                                        <div class="product-action">
                                            <a href="#" class="btn-product btn-quickview" title="Quick View">Quick
                                                View</a>
                                        </div>
                                    </figure>
                                    <div class="product-details">
                                        <h4 class="product-name"><a href="product-default.html">Phone Charge Pad</a>
                                        </h4>
                                        <div class="ratings-container">
                                            <div class="ratings-full">
                                                <span class="ratings" style="width: 80%;"></span>
                                                <span class="tooltiptext tooltip-top"></span>
                                            </div>
                                            <a href="product-default.html" class="rating-reviews">(8 reviews)</a>
                                        </div>
                                        <div class="product-pa-wrapper">
                                            <div class="product-price">$23.00</div>
                                        </div>
                                    </div>
                                </div>
                                <div class="swiper-slide product">
                                    <figure class="product-media">
                                        <a href="product-default.html">
                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/products/default/8.jpg" alt="Product"
                                                width="300" height="338" />
                                        </a>
                                        <div class="product-action-vertical">
                                            <a href="#" class="btn-product-icon btn-cart w-icon-cart"
                                                title="Add to cart"></a>
                                            <a href="#" class="btn-product-icon btn-wishlist w-icon-heart"
                                                title="Add to wishlist"></a>
                                            <a href="#" class="btn-product-icon btn-compare w-icon-compare"
                                                title="Add to Compare"></a>
                                        </div>
                                        <div class="product-action">
                                            <a href="#" class="btn-product btn-quickview" title="Quick View">Quick
                                                View</a>
                                        </div>
                                    </figure>
                                    <div class="product-details">
                                        <h4 class="product-name"><a href="product-default.html">Fashionalble
                                                Pencil</a></h4>
                                        <div class="ratings-container">
                                            <div class="ratings-full">
                                                <span class="ratings" style="width: 100%;"></span>
                                                <span class="tooltiptext tooltip-top"></span>
                                            </div>
                                            <a href="product-default.html" class="rating-reviews">(9 reviews)</a>
                                        </div>
                                        <div class="product-pa-wrapper">
                                            <div class="product-price">$50.00</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section> -->
                </div>
                <!-- End of Main Content -->
                <aside class="sidebar product-sidebar sidebar-fixed right-sidebar sticky-sidebar-wrapper">
                    <div class="sidebar-overlay"></div>
                    <a class="sidebar-close" href="#"><i class="close-icon"></i></a>
                    <a href="#" class="sidebar-toggle d-flex d-lg-none"><i class="fas fa-chevron-left"></i></a>
                    <div class="sidebar-content scrollable">
                        <div class="sticky-sidebar">
                            <!-- <div class="widget widget-icon-box mb-6">
                                <div class="icon-box icon-box-side">
                                    <span class="icon-box-icon text-dark">
                                        <i class="w-icon-truck"></i>
                                    </span>
                                    <div class="icon-box-content">
                                        <h4 class="icon-box-title">Free Shipping & Returns</h4>
                                        <p>For all orders over $99</p>
                                    </div>
                                </div>
                                <div class="icon-box icon-box-side">
                                    <span class="icon-box-icon text-dark">
                                        <i class="w-icon-bag"></i>
                                    </span>
                                    <div class="icon-box-content">
                                        <h4 class="icon-box-title">Secure Payment</h4>
                                        <p>We ensure secure payment</p>
                                    </div>
                                </div>
                                <div class="icon-box icon-box-side">
                                    <span class="icon-box-icon text-dark">
                                        <i class="w-icon-money"></i>
                                    </span>
                                    <div class="icon-box-content">
                                        <h4 class="icon-box-title">Money Back Guarantee</h4>
                                        <p>Any back within 30 days</p>
                                    </div>
                                </div>
                            </div> -->
                            <!-- End of Widget Icon Box -->

                            <div class="widget widget-banner mb-9">
                                <div class="banner banner-fixed br-sm">
                                    <figure>
                                        <img src="<?= base_url('assets/theme/v2/') ?>assets/images/shop/banner3.jpg" alt="Banner" width="266"
                                            height="220" style="background-color: #1D2D44;" />
                                    </figure>
                                    <div class="banner-content">
                                        <div class="banner-price-info font-weight-bolder text-white lh-1 ls-25">
                                            <sup class="font-weight-bold"></sup><sub
                                                class="font-weight-bold text-uppercase ls-25"></sub>
                                        </div>
                                        <h4
                                            class="banner-subtitle text-white font-weight-bolder text-uppercase mb-0">
                                            </h4>
                                    </div>
                                </div>
                            </div>
                            <!-- End of Widget Banner -->

                            <div class="widget widget-products">
                                <div class="title-link-wrapper mb-2">
                                    <h4 class="title title-link font-weight-bold">More Products</h4>
                                </div>

                                <?php if (!empty($sidebar_products)): ?>
                                <div class="swiper nav-top">
                                    <div class="swiper-container swiper-theme nav-top" data-swiper-options="{
                                                'slidesPerView': 1,
                                                'spaceBetween': 20,
                                                'navigation': {
                                                    'prevEl': '.swiper-button-prev',
                                                    'nextEl': '.swiper-button-next'
                                                }
                                            }">
                                        <div class="swiper-wrapper">
                                            <?php 
                                            $total_products = count($sidebar_products);
                                            $products_per_slide = 3;
                                            $slides = ceil($total_products / $products_per_slide);
                                            
                                            for ($slide = 0; $slide < $slides; $slide++) { ?>
                                                <div class="widget-col swiper-slide">
                                                    <?php 
                                                    $start = $slide * $products_per_slide;
                                                    $end = min($start + $products_per_slide, $total_products);
                                                    
                                                    for ($i = $start; $i < $end; $i++) {
                                                        $sidebar_product = $sidebar_products[$i];
                                                    ?>
                                                    <div class="product product-widget">
                                                        <figure class="product-media">
                                                            <a href="<?= base_url('product/' . $sidebar_product['p_id'] . '/' . url_title($sidebar_product['p_name'], 'dash', TRUE)) ?>">
                                                                <img src="<?= !empty($sidebar_product['p_image1']) ? base_url('assets/avator/upload/') . $sidebar_product['p_image1'] : base_url('assets/theme/v2/assets/images/products/default/1-800x900.jpg') ?>"
                                                                    alt="<?= htmlspecialchars($sidebar_product['p_name']) ?>"
                                                                    width="100" height="113" style="object-fit:contain;" />
                                                            </a>
                                                        </figure>
                                                        <div class="product-details">
                                                            <h4 class="product-name">
                                                                <a href="<?= base_url('product/' . $sidebar_product['p_id'] . '/' . url_title($sidebar_product['p_name'], 'dash', TRUE)) ?>">
                                                                    <?= htmlspecialchars($sidebar_product['p_name']) ?>
                                                                </a>
                                                            </h4>
                                                            <div class="product-price">
                                                                <?php if ($sidebar_product['p_discount'] > 0) { ?>
                                                                    <ins class="new-price">₹<?= number_format($sidebar_product['p_price'] - ($sidebar_product['p_price'] * $sidebar_product['p_discount'] / 100), 2) ?></ins>
                                                                    <del class="old-price">₹<?= number_format($sidebar_product['p_price'], 2) ?></del>
                                                                <?php } else { ?>
                                                                    <ins class="new-price">₹<?= number_format($sidebar_product['p_price'], 2) ?></ins>
                                                                <?php } ?>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <?php if ($i < $end - 1): ?>
                                                    <div class="product-separator"></div>
                                                    <?php endif; ?>
                                                    <?php } ?>
                                                </div>
                                            <?php } ?>
                                        </div>
                                        <button class="swiper-button-next"></button>
                                        <button class="swiper-button-prev"></button>
                                    </div>
                                </div>
                                <?php else: ?>
                                <div class="text-center py-3">
                                    <p class="text-muted">No products available</p>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </aside>

<style>
/* Product Separator Line for More Products Section */
.product-separator {
    height: 1px;
    background-color: #e0e6ed;
    margin: 15px 0;
    width: 100%;
}
</style>
                <!-- End of Sidebar -->
            </div>
        </div>
    </div>
    <!-- End of Page Content -->
</main>
<!-- End of Main -->

<!-- Booking Modal -->
<div class="modal fade" id="bookingModal" tabindex="-1" role="dialog" aria-labelledby="bookingModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="bookingModalLabel">Book Now</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="bookingForm" method="post" action="<?= base_url('action/book_product') ?>" onsubmit="return uploadandform('<?= base_url('action/book_product') ?>','post',this,'image_name','progress_value_sc','prog_valie_text','Show_Errors_987','loader_post_upload','1','uni_loader_prog_status');">
                    <input type="hidden" id="product_id" name="product_id">
                    <input type="hidden" id="p_vendor" name="p_vendor">
                    
                    <div class="form-group">
                        <label for="customer_name">Name *</label>
                        <input type="text" class="form-control" id="customer_name" name="customer_name" placeholder="Enter Your Name" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="customer_mobile">Mobile Number *</label>
                        <input type="tel" class="form-control" id="customer_mobile" name="customer_mobile" placeholder="Please Enter Mobile Number" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="customer_budget">Enter Your Budget</label>
                        <input type="text" class="form-control" id="customer_budget" name="customer_budget" placeholder="Enter Your Budget">
                    </div>
                    
                    <div class="form-group">
                        <label for="customer_location">Location</label>
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text"><i class="fa fa-map-marker"></i></span>
                            </div>
                            <!-- <input type="text" class="form-control" id="customer_location" name="customer_location" placeholder="Please Select your location"> -->
                             <input type="hidden" name="latitude" id="latitude2" value="">
                                    <input type="hidden" name="longitude" id="longitude2" value="">
                                    <input type="text" class="form-control" name="customer_location" id="autocomplete2" placeholder="Enter your address" value="">
                        </div>
                    </div>
                    
                    <div class="form-group text-center">
                        <button type="submit" class="btn btn-primary btn-rounded btn-block" id="bookNowBtn" style="font-weight:600; font-size:15px;padding:10px 0px">
                            <span class="btn-text">BOOK NOW</span>
                            <span class="btn-loading" style="display:none;">
                                <i class="fa fa-spinner fa-spin"></i> Processing...
                            </span>
                        </button>
                    </div>
                    
                    <div class="text-center mt-3">
                        <small class="text-muted">By clicking on Submit, you agree to our <a href="<?= base_url('terms')?>" target="_blank">terms and conditions</a></small>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>



<style>
/* EMI Calculator Styles */
.emi-calculator-inputs .form-group {
    margin-bottom: 25px;
}

.emi-calculator-inputs label {
    font-weight: 600;
    color: #333;
    margin-bottom: 8px;
    display: block;
}

.emi-calculator-inputs .input-group {
    margin-bottom: 10px;
}

.emi-calculator-inputs .form-control-range {
    width: 100%;
    margin: 10px 0;
}

.loan-period-buttons {
    display: flex;
    flex-wrap: wrap;
    gap: 8px;
}

.loan-period-buttons .btn {
    min-width: 50px;
    padding: 8px 12px;
    font-size: 14px;
    font-weight: 500;
}

.emi-options {
    margin-bottom: 20px;
}

.emi-options .form-check-inline {
    margin-right: 15px;
    margin-bottom: 10px;
}

.badge-pink {
    background-color: #e91e63;
    color: white;
    font-size: 10px;
    padding: 2px 6px;
    border-radius: 10px;
    margin-left: 5px;
}

.monthly-emi-display {
    background: #f8f9fa;
    padding: 20px;
    border-radius: 8px;
    text-align: center;
    margin-bottom: 20px;
}

.monthly-emi-display h6 {
    color: #666;
    margin-bottom: 10px;
    font-size: 14px;
}

.emi-amount {
    font-size: 28px;
    font-weight: 700;
    color: #333;
    margin-bottom: 5px;
}

.loan-summary {
    background: #fff;
    border: 1px solid #e0e6ed;
    border-radius: 8px;
    padding: 15px;
    margin-bottom: 20px;
}

.loan-summary h6 {
    color: #333;
    margin-bottom: 15px;
    font-weight: 600;
}

.summary-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 8px 0;
    border-bottom: 1px solid #f0f0f0;
}

.summary-item:last-child {
    border-bottom: none;
}

.summary-item.total {
    font-weight: 600;
    color: #333;
    border-top: 2px solid #e0e6ed;
    padding-top: 12px;
    margin-top: 8px;
}

.emi-actions {
    margin-top: 20px;
}

.emi-actions .btn-link {
    color: #007bff;
    text-decoration: none;
    font-size: 14px;
}

.emi-actions .btn-link:hover {
    text-decoration: underline;
}

/* Modal Responsive */
@media (max-width: 768px) {
    .loan-period-buttons {
        justify-content: center;
    }
    
    .emi-amount {
        font-size: 24px;
    }
    
    .summary-item {
        flex-direction: column;
        align-items: flex-start;
        gap: 5px;
    }
}
</style>

<script>
   


    
    function closeBookingModal() {
        const modal = document.getElementById('bookingModal');
        const backdrop = document.getElementById('modalBackdrop');
        
        modal.classList.remove('show');
        backdrop.classList.remove('show');
        
        setTimeout(() => {
            modal.style.display = 'none';
            if (backdrop) {
                backdrop.remove();
            }
        }, 150);
    }

    // Handle form submission with page refresh
    document.getElementById('bookingForm').addEventListener('submit', function(e) {
        // Show loading state
        const btn = document.getElementById('bookNowBtn');
        const btnText = btn.querySelector('.btn-text');
        const btnLoading = btn.querySelector('.btn-loading');
        
        btnText.style.display = 'none';
        btnLoading.style.display = 'inline-block';
        btn.disabled = true;
        
        // Let uploadandform handle the submission
        // After submission, close modal and refresh the page
        setTimeout(function() {
            closeBookingModal(); // Close the modal first
            location.reload(); // Then refresh the page
        }, 2000); // Wait 2 seconds for uploadandform to complete
    });

    // Function to show loading on Book Now buttons
    function showBookNowLoading(button) {
        const btnText = button.querySelector('.btn-text');
        const btnLoading = button.querySelector('.btn-loading');
        
        btnText.style.display = 'none';
        btnLoading.style.display = 'inline-block';
        button.disabled = true;
        
        // Reset after 3 seconds if modal doesn't open
        setTimeout(function() {
            if (!document.getElementById('bookingModal').classList.contains('show')) {
                btnText.style.display = 'inline-block';
                btnLoading.style.display = 'none';
                button.disabled = false;
            }
        }, 3000);
    }

    // Booking Modal Functions with loading
    function openBookingModal(productId, vendorId, productName, event) {
        // Show loading on the clicked button
        const clickedBtn = event ? event.target.closest('.book-now-btn') : null;
        if (clickedBtn) {
            showBookNowLoading(clickedBtn);
        }
        
        document.getElementById('product_id').value = productId;
        document.getElementById('p_vendor').value = vendorId;
        document.getElementById('bookingModalLabel').textContent = productName;
        
        // Add delay before opening modal
        setTimeout(() => {
            // Show modal
            const modal = document.getElementById('bookingModal');
            const backdrop = document.createElement('div');
            backdrop.className = 'modal-backdrop';
            backdrop.id = 'modalBackdrop';
            
            document.body.appendChild(backdrop);
            modal.style.display = 'block';
            
            setTimeout(() => {
                backdrop.classList.add('show');
                modal.classList.add('show');
                
                // Reset button loading state after modal opens
                if (clickedBtn) {
                    const btnText = clickedBtn.querySelector('.btn-text');
                    const btnLoading = clickedBtn.querySelector('.btn-loading');
                    btnText.style.display = 'inline-block';
                    btnLoading.style.display = 'none';
                    clickedBtn.disabled = false;
                }
            }, 10);
            
            // Close modal when clicking backdrop
            backdrop.addEventListener('click', closeBookingModal);
            
            // Close modal when clicking close button
            document.querySelector('#bookingModal .close').addEventListener('click', closeBookingModal);
        }, 1500); // 1.5 second delay
    }

    // EMI Calculator Functionality (New Design)
    document.addEventListener('DOMContentLoaded', function() {
        // Initialize EMI Calculator variables
        const productPrice = <?= $product['p_price'] ?>;
        let downPayment = <?= round($product['p_price']*0.1) ?>;
        let interestRate = 13;
        let loanPeriod = 60;
        let emiType = 1;

        // Initialize EMI calculation on page load
        updateEMICalculation();

        // Down Payment Slider
        const downPaymentSlider = document.getElementById('emi-down-payment');
        const downPaymentValue = document.getElementById('emi-down-payment-value');
        
        if (downPaymentSlider && downPaymentValue) {
            downPaymentSlider.addEventListener('input', function() {
                downPayment = parseInt(this.value);
                downPaymentValue.textContent = '₹' + formatNumber(downPayment);
                updateEMICalculation();
            });
        }

        // Interest Rate Slider
        const interestRateSlider = document.getElementById('emi-interest-rate');
        const interestRateValue = document.getElementById('emi-interest-rate-value');
        
        if (interestRateSlider && interestRateValue) {
            interestRateSlider.addEventListener('input', function() {
                interestRate = parseFloat(this.value);
                interestRateValue.textContent = interestRate + ' %';
                updateEMICalculation();
            });
        }

        // Loan Period Buttons
        const loanPeriodButtons = document.querySelectorAll('.emi-loan-period-btn');
        loanPeriodButtons.forEach(button => {
            button.addEventListener('click', function() {
                // Remove active class from all buttons
                loanPeriodButtons.forEach(btn => btn.classList.remove('active'));
                
                // Add active class to clicked button
                this.classList.add('active');
                
                loanPeriod = parseInt(this.dataset.months);
                updateEMICalculation();
            });
        });

        // EMI Type Radio Buttons
        const emiTypeRadios = document.querySelectorAll('input[name="emi-type"]');
        emiTypeRadios.forEach(radio => {
            radio.addEventListener('change', function() {
                emiType = parseInt(this.value);
                updateEMICalculation();
            });
        });

        // Standard EMI Calculation Function
        function updateEMICalculation() {
            const loanAmount = productPrice - downPayment;
            const monthlyRate = (interestRate / 100) / 12;
            const numberOfPayments = loanPeriod;

            let emi = 0;
            if (monthlyRate > 0 && loanAmount > 0) {
                // Standard EMI formula: EMI = P × r × (1 + r)^n / ((1 + r)^n - 1)
                emi = (loanAmount * monthlyRate * Math.pow(1 + monthlyRate, numberOfPayments)) / 
                      (Math.pow(1 + monthlyRate, numberOfPayments) - 1);
            } else if (loanAmount > 0) {
                emi = loanAmount / numberOfPayments;
            }

            // Apply EMI type multiplier (1, 3, or 6 months)
            emi = emi * emiType;

            // Update display elements
            const monthlyEMIElement = document.getElementById('emi-monthly-emi');
            const loanAmountElement = document.getElementById('emi-loan-amount');
            
            if (monthlyEMIElement) {
                monthlyEMIElement.textContent = '₹' + formatNumber(Math.round(emi));
            }
            
            if (loanAmountElement) {
                loanAmountElement.textContent = '₹' + formatNumber(loanAmount);
            }
        }

        // Format number with commas
        function formatNumber(num) {
            return num.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
        }

        // View Loan Offers button functionality
        const loanOfferBtn = document.querySelector('.emi-calc-loan-offer-btn');
        if (loanOfferBtn) {
            loanOfferBtn.addEventListener('click', function() {
                // You can add loan application logic here
                alert('Loan offers functionality will be implemented here.');
            });
        }

        // Check EMI Details link functionality
        const emiDetailsLink = document.querySelector('.emi-calc-details-link a');
        if (emiDetailsLink) {
            emiDetailsLink.addEventListener('click', function(e) {
                e.preventDefault();
                // You can add detailed EMI breakdown logic here
                alert('EMI details functionality will be implemented here.');
            });
        }
    });

</script>

 
<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAH0ovld3PKMKQwLH5F_Qnjtf7WMWZsrhM&libraries=places">
</script>
 
<style>
/* Fix Google Places Autocomplete z-index issue in modal */
.pac-container {
    z-index: 9999 !important;
    background: white !important;
    border: 1px solid #ccc !important;
    border-radius: 4px !important;
    box-shadow: 0 2px 6px rgba(0,0,0,0.3) !important;
    font-family: inherit !important;
    font-size: 14px !important;
    max-height: 200px !important;
    overflow-y: auto !important;
}

.pac-container:after {
    content: none !important;
}

.pac-item {
    padding: 8px 12px !important;
    cursor: pointer !important;
    border-bottom: 1px solid #f0f0f0 !important;
    font-size: 14px !important;
    line-height: 1.4 !important;
}

.pac-item:hover {
    background-color: #f8f9fa !important;
}

.pac-item:last-child {
    border-bottom: none !important;
}

.pac-item-selected {
    background-color: #e3f2fd !important;
}

/* Ensure modal has proper z-index */
#bookingModal {
    z-index: 1050 !important;
}

#bookingModal .modal-dialog {
    z-index: 1055 !important;
}

#bookingModal .modal-content {
    z-index: 1060 !important;
}

/* Fix for Bootstrap modal backdrop */
.modal-backdrop {
    z-index: 1040 !important;
}

/* Additional styling for better modal appearance */
#bookingModal .modal-content {
    border-radius: 8px !important;
    box-shadow: 0 10px 30px rgba(0,0,0,0.3) !important;
}

#bookingModal .form-control {
    border-radius: 6px !important;
    border: 1px solid #ddd !important;
    padding: 10px 12px !important;
}

#bookingModal .form-control:focus {
    border-color: #007bff !important;
    box-shadow: 0 0 0 0.2rem rgba(0,123,255,0.25) !important;
}

#bookingModal .input-group-text {
    background-color: #f8f9fa !important;
    border: 1px solid #ddd !important;
    border-right: none !important;
}

#bookingModal .input-group .form-control {
    border-left: none !important;
}
</style>

<script>
    let autocomplete2;
 
    function initAutocomplete2() {
        const input = document.getElementById('autocomplete2');
        if (!input) return;
 
        autocomplete2 = new google.maps.places.Autocomplete(input, {
            componentRestrictions: {
                country: "in"
            },
            fields: ["geometry", "address_components"]
        });
 
        autocomplete2.addListener("place_changed", () => {
            const place = autocomplete2.getPlace();
 
            if (!place.geometry || !place.address_components) {
                console.warn("Place details missing.");
                return;
            }
 
            const lat = place.geometry.location.lat();
            const lng = place.geometry.location.lng();
 
            document.getElementById("latitude2").value = lat;
            document.getElementById("longitude2").value = lng;
 
            const city = place.address_components.find(c => c.types.includes("locality"))?.long_name || "";
            const country = place.address_components.find(c => c.types.includes("country"))?.long_name || "";
 
            console.log("City:", city, "| Country:", country);
        });
    }
 
    // Initialize on load
    window.addEventListener("load", () => {
        initAutocomplete2();
    });
    
    // Additional fix: Ensure autocomplete suggestions appear above modal
    document.addEventListener('DOMContentLoaded', function() {
        // Monitor for modal opening and adjust autocomplete container
        const bookingModal = document.getElementById('bookingModal');
        if (bookingModal) {
            bookingModal.addEventListener('shown.bs.modal', function() {
                // Force update of pac-container z-index
                setTimeout(() => {
                    const pacContainer = document.querySelector('.pac-container');
                    if (pacContainer) {
                        pacContainer.style.zIndex = '9999';
                    }
                }, 100);
            });
        }
        
        // Also monitor for autocomplete input focus
        const autocompleteInput = document.getElementById('autocomplete2');
        if (autocompleteInput) {
            autocompleteInput.addEventListener('focus', function() {
                setTimeout(() => {
                    const pacContainer = document.querySelector('.pac-container');
                    if (pacContainer) {
                        pacContainer.style.zIndex = '9999';
                    }
                }, 100);
            });
        }
    });
</script>
 
 