<!-- What We Offers Section -->
<style>
    .what-we-offer-section {
        background: #f6f9fb;
        border-radius: 14px;
        box-shadow: 0 2px 8px #0001;
        padding: 28px 18px 36px 18px;
        margin-bottom: 32px;
        margin-top: 32px;
    }

    .what-we-offer-title {
        font-size: 2rem;
        font-weight: 700;
        margin-bottom: 28px;
    }

    .offer-cards {
        display: flex;
        flex-wrap: nowrap;
        gap: 28px;
        justify-content: space-between;
        margin-bottom: 32px;
    }

    .offer-card {
        background: #fff;
        border-radius: 16px;
        box-shadow: 0 4px 16px #0001;
        padding: 36px 18px 28px 18px;
        width: 24%;
        max-width: 320px;
        min-width: 200px;
        display: flex;
        flex-direction: column;
        align-items: center;
        transition: box-shadow 0.2s;
    }

    .offer-card:hover {
        box-shadow: 0 8px 24px #0002;
    }

    .offer-icon {
        margin-bottom: 18px;
        display: flex;
        align-items: center;
        justify-content: center;
        height: 64px;
    }

    .offer-label {
        font-size: 1.18rem;
        font-weight: 700;
        color: #181818;
        text-align: center;
    }

    .call-expert-btn {
        display: flex;
        align-items: center;
        justify-content: center;
        background: #d44d53;
        color: #fff;
        font-size: 1.35rem;
        font-weight: 700;
        border: none;
        border-radius: 8px;
        padding: 16px 0;
        width: 340px;
        margin: 0 auto;
        transition: background 0.2s;
        box-shadow: 0 2px 8px #0001;
        cursor: pointer;
    }

    .call-expert-btn i {
        margin-right: 10px;
        font-size: 1.3em;
    }

    .call-expert-btn:hover {
        background: #b93b3f;
    }

    @media (max-width: 991px) {
        .offer-cards {
            flex-wrap: wrap;
            gap: 16px;
        }

        .offer-card {
            width: 45%;
            min-width: 180px;
            max-width: 100%;
        }

        .call-expert-btn {
            width: 100%;
        }
    }

    @media (max-width: 600px) {
        .what-we-offer-section {
            padding: 10px 2px;
        }

        .what-we-offer-title {
            font-size: 1.2rem;
        }

        .offer-cards {
            flex-wrap: wrap;
        }

        .offer-card {
            width: 100%;
            min-width: 100%;
        }
    }
</style>
<style>
    .key-spec-section {
        background: #f6f9fb;
        border-radius: 16px;
        box-shadow: 0 2px 8px #0001;
        padding: 28px 18px 28px 18px;
        margin-bottom: 32px;
    }

    .key-spec-title {
        font-size: 1.6rem;
        font-weight: 700;
        margin-bottom: 18px;
    }

    .key-spec-cards {
        display: flex;
        flex-wrap: wrap;
        gap: 14px;
        justify-content: flex-start;
    }

    .key-spec-card {
        background: #fff;
        border-radius: 10px;
        box-shadow: 0 2px 8px #0001;
        padding: 14px 16px 10px 16px;
        min-width: 200px;
        max-width: 240px;
        flex: 1 1 200px;
        display: flex;
        flex-direction: column;
        align-items: flex-start;
        margin-bottom: 0;
    }

    .key-spec-row {
        display: flex;
        align-items: center;
        gap: 8px;
        margin-bottom: 2px;
    }

    .key-spec-icon {
        font-size: 1.35rem;
        color: #2d7be5;
        flex-shrink: 0;
    }

    .key-spec-label {
        color: #444;
        font-size: 1.08rem;
        font-weight: 600;
        margin-bottom: 0;
        line-height: 1.1;
    }

    .key-spec-value {
        font-weight: 700;
        font-size: 1.08rem;
        color: #222;
        margin-top: 4px;
    }

    @media (max-width: 991px) {
        .key-spec-cards {
            gap: 10px;
        }

        .key-spec-card {
            min-width: 46%;
            max-width: 100%;
        }
    }

    @media (max-width: 600px) {
        .key-spec-section {
            padding: 10px 2px;
        }

        .key-spec-title {
            font-size: 1.1rem;
        }

        .key-spec-card {
            min-width: 100%;
        }
    }
</style>
<!-- Tractor Inspection Checklist Section -->
<style>
    .tractor-checklist-section {
        background: #f6f9fb;
        border-radius: 14px;
        box-shadow: 0 2px 8px #0001;
        padding: 28px 18px 36px 18px;
        margin-bottom: 32px;
        margin-top: 32px;
    }

    .tractor-checklist-title {
        font-size: 2rem;
        font-weight: 700;
        margin-bottom: 24px;
    }

    .checklist-tabs {
        display: flex;
        gap: 0;
        margin-bottom: 0;
    }

    .checklist-tab {
        background: #fff;
        border: 1px solid #e0e4ea;
        border-bottom: none;
        border-radius: 8px 8px 0 0;
        padding: 10px 32px;
        font-size: 1.1rem;
        font-weight: 600;
        color: #222;
        cursor: pointer;
        margin-right: 2px;
        transition: background 0.2s, color 0.2s;
        outline: none;
    }

    .checklist-tab.active {
        background: #f6f9fb;
        color: #204080;
        border-bottom: 2px solid #f6f9fb;
    }

    .checklist-tab:not(.active):hover {
        background: #f0f2f7;
    }

    .checklist-tab-content {
        background: #fff;
        border-radius: 0 0 8px 8px;
        box-shadow: 0 2px 8px #0001;
        padding: 32px 24px 24px 24px;
        margin-top: -1px;
    }

    .checklist-items {
        display: grid;
        grid-template-columns: repeat(4, 1fr);
        gap: 20px;
    }

    .checklist-col {
        width: 100%;
    }

    .checklist-list {
        list-style: none;
        padding: 0;
        margin: 0 0 0 0;
    }

    .checklist-list li {
        display: flex;
        align-items: center;
        font-size: 1.08rem;
        margin-bottom: 16px;
        color: #181818;
    }

    .checklist-icon {
        color: #d44d53;
        font-size: 1.2rem;
        margin-right: 8px;
        display: flex;
        align-items: center;
    }

    @media (max-width: 991px) {
        .checklist-items {
            grid-template-columns: repeat(3, 1fr);
        }
    }

    @media (max-width: 600px) {
        .tractor-checklist-section {
            padding: 10px 2px;
        }

        .tractor-checklist-title {
            font-size: 1.2rem;
        }

        .checklist-items {
            grid-template-columns: repeat(2, 1fr);
            gap: 10px;
        }

        .checklist-tab {
            padding: 8px 10px;
            font-size: 1rem;
        }

        .checklist-tab-content {
            padding: 16px 6px 12px 6px;
        }
    }
</style>

<!-- Start of Main -->
<main class="main mb-10 pb-1">
    <!-- Start of Breadcrumb -->
    <nav class="breadcrumb-nav container">
        <ul class="breadcrumb bb-no">
            <li><a href="<?= base_url() ?>">Home</a></li>
            <li><a href="<?= base_url('shop') ?>">Products</a></li>
            <li><?= htmlspecialchars($product['p_name']) ?></li>
        </ul>
        <ul class="product-nav list-style-none">
            <li class="product-nav-prev">
                <a href="#">
                    <i class="w-icon-angle-left"></i>
                </a>
                <span class="product-nav-popup">
                    <img src="<?= base_url('assets/theme/v2/') ?>assets/images/products/product-nav-prev.jpg" alt="Product" width="110"
                        height="110" />
                    <span class="product-name">Soft Sound Maker</span>
                </span>
            </li>
            <li class="product-nav-next">
                <a href="#">
                    <i class="w-icon-angle-right"></i>
                </a>
                <span class="product-nav-popup">
                    <img src="<?= base_url('assets/theme/v2/') ?>assets/images/products/product-nav-next.jpg" alt="Product" width="110"
                        height="110" />
                    <span class="product-name">Fabulous Sound Speaker</span>
                </span>
            </li>
        </ul>
    </nav>
    <!-- End of Breadcrumb -->

    <!-- Start of Page Content -->
    <div class="page-content">
        <div class="container">
            <div class="row gutter-lg">
                <div class="main-content">
                    <div class="product product-single row">
                        <div class="col-md-6 mb-6">
                            <div class="product-gallery product-gallery-sticky">
                                <div class="swiper-container product-single-swiper swiper-theme nav-inner" data-swiper-options="{
                                            'navigation': {
                                                'nextEl': '.swiper-button-next',
                                                'prevEl': '.swiper-button-prev'
                                            }
                                        }">
                                    <div class="swiper-wrapper row cols-1 gutter-no">
                                        <!-- Main product image -->
                                        <div class="swiper-slide">
                                            <figure class="product-image">
                                                <img src="<?= !empty($product['p_image1']) ? base_url('assets/avator/upload/') . $product['p_image1'] : base_url('assets/theme/v2/assets/images/products/default/1-800x900.jpg') ?>"
                                                    data-zoom-image="<?= !empty($product['p_image1']) ? base_url('assets/avator/upload/') . $product['p_image1'] : base_url('assets/theme/v2/assets/images/products/default/1-800x900.jpg') ?>"
                                                    alt="<?= htmlspecialchars($product['p_name']) ?>" width="800" height="600">
                                            </figure>
                                        </div>
                                        <!-- Additional product images -->
                                        <?php if (isset($product_images) && !empty($product_images)) { ?>
                                            <?php foreach ($product_images as $img) { ?>
                                                <div class="swiper-slide">
                                                    <figure class="product-image">
                                                        <img src="<?= base_url('assets/avator/upload/') . $img['img'] ?>"
                                                            data-zoom-image="<?= base_url('assets/avator/upload/') . $img['img'] ?>"
                                                            alt="<?= htmlspecialchars($product['p_name']) ?>" width="800" height="900">
                                                    </figure>
                                                </div>
                                            <?php } ?>
                                        <?php } ?>
                                    </div>
                                    <button class="swiper-button-next"></button>
                                    <button class="swiper-button-prev"></button>
                                    <a href="#" class="product-gallery-btn product-image-full"><i class="w-icon-zoom"></i></a>
                                </div>
                                <div class="product-thumbs-wrap swiper-container" data-swiper-options="{
                                            'navigation': {
                                                'nextEl': '.swiper-button-next',
                                                'prevEl': '.swiper-button-prev'
                                            }
                                        }">
                                    <div class="product-thumbs swiper-wrapper row cols-4 gutter-sm">
                                        <!-- Main product image thumbnail -->
                                        <div class="product-thumb swiper-slide">
                                            <img src="<?= !empty($product['p_image1']) ? base_url('assets/avator/upload/') . $product['p_image1'] : base_url('assets/theme/v2/assets/images/products/default/1-800x900.jpg') ?>"
                                                alt="Product Thumb" width="800" height="900">
                                        </div>
                                        <!-- Additional product images thumbnails -->
                                        <?php if (isset($product_images) && !empty($product_images)) { ?>
                                            <?php foreach ($product_images as $img) { ?>
                                                <div class="product-thumb swiper-slide">
                                                    <img src="<?= base_url('assets/avator/upload/') . $img['img'] ?>"
                                                        alt="Product Thumb" width="800" height="900">
                                                </div>
                                            <?php } ?>
                                        <?php } ?>
                                    </div>
                                    <button class="swiper-button-next"></button>
                                    <button class="swiper-button-prev"></button>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 mb-4 mb-md-6">
                            <div class="product-details" data-sticky-options="{'minWidth': 767}">
                                <h1 class="product-title"><?= htmlspecialchars($product['p_name']) ?></h1>
                                <div class="product-bm-wrapper">
                                    <figure class="brand">
                                        <img src="<?= base_url('assets/theme/v2/') ?>assets/images/products/brand/brand-1.jpg" alt="Brand"
                                            width="102" height="48" />
                                    </figure>
                                    <div class="product-meta">
                                        <div class="product-categories">
                                            Category:
                                            <span class="product-category"><a href="<?= base_url('shop?cat=' . $product['p_category']) ?>"><?= !empty($product['category_name']) ? htmlspecialchars($product['category_name']) : 'General' ?></a></span>
                                        </div>
                                        <div class="product-sku">
                                            Product ID: <span><?= $product['p_id'] ?></span>
                                        </div>
                                    </div>
                                </div>

                                <hr class="product-divider">

                                <div class="product-price">
                                    <?php if ($product['p_discount'] > 0) { ?>
                                        <ins class="new-price">₹<?= number_format($product['p_price'] - ($product['p_price'] * $product['p_discount'] / 100), 2) ?></ins>
                                        <del class="old-price">₹<?= number_format($product['p_price'], 2) ?></del>
                                    <?php } else { ?>
                                        <ins class="new-price">₹<?= number_format($product['p_price'], 2) ?></ins>
                                    <?php } ?>
                                </div>

                                <!-- <div class="ratings-container">
                                            <div class="ratings-full">
                                                <span class="ratings" style="width: 80%;"></span>
                                                <span class="tooltiptext tooltip-top"></span>
                                            </div>
                                            <a href="#product-tab-reviews" class="rating-reviews scroll-to">(3
                                                Reviews)</a>
                                        </div> -->

                                <div class="product-short-desc">
                                    <ul class="list-type-check list-style-none">
                                        <?php if (!empty($product['p_year'])): ?>
                                            <li><strong>Year:</strong> <?= htmlspecialchars($product['p_year']) ?></li>
                                        <?php endif; ?>
                                        <?php if (!empty($product['p_model'])): ?>
                                            <li><strong>Model:</strong> <?= htmlspecialchars($product['p_model']) ?></li>
                                        <?php endif; ?>
                                        <?php if (!empty($product['brand_name'])): ?>
                                            <li><strong>Brand:</strong> <?= htmlspecialchars($product['brand_name']) ?></li>
                                        <?php endif; ?>
                                        <?php if (!empty($product['city_name'])): ?>
                                            <li><strong>City:</strong> <?= htmlspecialchars($product['city_name']) ?></li>
                                        <?php endif; ?>
                                        <?php if (!empty($product['state_name'])): ?>
                                            <li><strong>State:</strong> <?= htmlspecialchars($product['state_name']) ?></li>
                                        <?php endif; ?>
                                        <?php if (!empty($product['tyre_condition'])): ?>
                                            <li><strong>Tyre Condition:</strong> <?= htmlspecialchars($product['tyre_condition']) ?></li>
                                        <?php endif; ?>
                                        <?php if (!empty($product['engine_condition'])): ?>
                                            <li><strong>Engine Condition:</strong> <?= htmlspecialchars($product['engine_condition']) ?></li>
                                        <?php endif; ?>
                                    </ul>
                                </div>

                                <hr class="product-divider">
                                <!-- <div class="product-variation-price">
                                            <span></span>
                                        </div> -->
                                <div class="fix-bottom product-sticky-content sticky-content">
                                    <div class="product-form container">

                                        <a href="<?= base_url('shop?product=' . $product['p_id']) ?>" class="btn btn-primary btn-cart">
                                            <i class="w-icon-cart"></i>
                                            <span>Buy Now</span>
                                        </a>
                                    </div>
                                </div>


                            </div>
                        </div>
                    </div>



                    <!-- Start Key Specification Section (Icon + Label in One Line, Larger) -->

                    <div class="container key-spec-section">
                        <div class="key-spec-title"><?= htmlspecialchars($product['p_name']) ?> Key Specification</div>
                        <div class="key-spec-cards">
                            <?php if (!empty($product['city_name']) || !empty($product['state_name'])): ?>
                                <div class="key-spec-card">
                                    <div class="key-spec-row">
                                        <span class="key-spec-icon"><i class="fa fa-map-marker"></i></span>
                                        <span class="key-spec-label">Location</span>
                                    </div>
                                    <div class="key-spec-value"><?= !empty($product['city_name']) ? htmlspecialchars($product['city_name']) : '' ?><?= !empty($product['city_name']) && !empty($product['state_name']) ? ', ' : '' ?><?= !empty($product['state_name']) ? htmlspecialchars($product['state_name']) : '' ?></div>
                                </div>
                            <?php endif; ?>

                            <?php if (!empty($product['engine_power'])): ?>
                                <div class="key-spec-card">
                                    <div class="key-spec-row">
                                        <span class="key-spec-icon"><i class="fa fa-cogs"></i></span>
                                        <span class="key-spec-label">Engine Power</span>
                                    </div>
                                    <div class="key-spec-value"><?= htmlspecialchars($product['engine_power']) ?></div>
                                </div>
                            <?php endif; ?>

                            <?php if (!empty($product['p_year'])): ?>
                                <div class="key-spec-card">
                                    <div class="key-spec-row">
                                        <span class="key-spec-icon"><i class="fa fa-calendar"></i></span>
                                        <span class="key-spec-label">Purchase Year</span>
                                    </div>
                                    <div class="key-spec-value"><?= htmlspecialchars($product['p_year']) ?></div>
                                </div>
                            <?php endif; ?>

                            <?php if (!empty($product['rto_no'])): ?>
                                <div class="key-spec-card">
                                    <div class="key-spec-row">
                                        <span class="key-spec-icon"><i class="fa fa-id-card"></i></span>
                                        <span class="key-spec-label">RTO NO.</span>
                                    </div>
                                    <div class="key-spec-value"><?= htmlspecialchars($product['rto_no']) ?></div>
                                </div>
                            <?php endif; ?>

                            <?php if (!empty($product['tyre_condition'])): ?>
                                <div class="key-spec-card">
                                    <div class="key-spec-row">
                                        <span class="key-spec-icon"><i class="fa fa-life-ring"></i></span>
                                        <span class="key-spec-label">Tyre Conditions</span>
                                    </div>
                                    <div class="key-spec-value"><?= htmlspecialchars($product['tyre_condition']) ?></div>
                                </div>
                            <?php endif; ?>

                            <?php if (!empty($product['engine_condition'])): ?>
                                <div class="key-spec-card">
                                    <div class="key-spec-row">
                                        <span class="key-spec-icon"><i class="fa fa-tint"></i></span>
                                        <span class="key-spec-label">Engine Conditions</span>
                                    </div>
                                    <div class="key-spec-value"><?= htmlspecialchars($product['engine_condition']) ?></div>
                                </div>
                            <?php endif; ?>

                            <?php if (!empty($product['financier_noc'])): ?>
                                <div class="key-spec-card">
                                    <div class="key-spec-row">
                                        <span class="key-spec-icon"><i class="fa fa-university"></i></span>
                                        <span class="key-spec-label">Financier / NOC</span>
                                    </div>
                                    <div class="key-spec-value"><?= htmlspecialchars($product['financier_noc']) ?></div>
                                </div>
                            <?php endif; ?>

                            <?php if (!empty($product['rc_status'])): ?>
                                <div class="key-spec-card">
                                    <div class="key-spec-row">
                                        <span class="key-spec-icon"><i class="fa fa-file-text"></i></span>
                                        <span class="key-spec-label">RC</span>
                                    </div>
                                    <div class="key-spec-value"><?= htmlspecialchars($product['rc_status']) ?></div>
                                </div>
                            <?php endif; ?>

                            <?php if (!empty($product['p_model'])): ?>
                                <div class="key-spec-card">
                                    <div class="key-spec-row">
                                        <span class="key-spec-icon"><i class="fa fa-truck"></i></span>
                                        <span class="key-spec-label">Model</span>
                                    </div>
                                    <div class="key-spec-value"><?= htmlspecialchars($product['p_model']) ?></div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <!-- End Key Specification Section -->


                    <div class="container what-we-offer-section">
                        <div class="what-we-offer-title">What we offers</div>
                        <div class="offer-cards">
                            <div class="offer-card">
                                <span class="offer-icon">
                                    <!-- Placeholder SVG icon -->
                                    <svg width="56" height="56" viewBox="0 0 56 56" fill="none">
                                        <circle cx="42" cy="16" r="12" fill="#eaf3fa" />
                                        <rect x="14" y="18" width="28" height="20" rx="3" fill="#fff" stroke="#222" stroke-width="2" />
                                        <rect x="18" y="22" width="20" height="8" rx="1.5" fill="#fff" stroke="#222" stroke-width="1.5" />
                                        <rect x="18" y="32" width="8" height="2" rx="1" fill="#d44d53" />
                                    </svg>
                                </span>
                                <div class="offer-label">Best Quality Tractor</div>
                            </div>
                            <div class="offer-card">
                                <span class="offer-icon">
                                    <!-- Placeholder SVG icon -->
                                    <svg width="56" height="56" viewBox="0 0 56 56" fill="none">
                                        <circle cx="42" cy="16" r="12" fill="#eaf3fa" />
                                        <path d="M28 38c2-6 8-8 8-14a8 8 0 10-16 0c0 6 6 8 8 14z" fill="#fff" stroke="#222" stroke-width="2" />
                                        <path d="M28 38v4" stroke="#d44d53" stroke-width="2" />
                                    </svg>
                                </span>
                                <div class="offer-label">Best Price Guaranteed</div>
                            </div>
                            <div class="offer-card">
                                <span class="offer-icon">
                                    <!-- Placeholder SVG icon -->
                                    <svg width="56" height="56" viewBox="0 0 56 56" fill="none">
                                        <circle cx="42" cy="16" r="12" fill="#eaf3fa" />
                                        <path d="M28 36c2-4 8-6 8-10a8 8 0 10-16 0c0 4 6 6 8 10z" fill="#fff" stroke="#222" stroke-width="2" /><text x="28" y="28" text-anchor="middle" fill="#222" font-size="14" font-family="Arial" dy=".3em">₹</text>
                                        <path d="M28 36v4" stroke="#d44d53" stroke-width="2" />
                                    </svg>
                                </span>
                                <div class="offer-label">Get upto 85% loan</div>
                            </div>
                            <div class="offer-card">
                                <span class="offer-icon">
                                    <!-- Placeholder SVG icon -->
                                    <svg width="56" height="56" viewBox="0 0 56 56" fill="none">
                                        <circle cx="42" cy="16" r="12" fill="#eaf3fa" />
                                        <rect x="18" y="18" width="20" height="20" rx="3" fill="#fff" stroke="#222" stroke-width="2" /><text x="28" y="32" text-anchor="middle" fill="#222" font-size="12" font-family="Arial" dy=".3em">RC</text>
                                        <path d="M38 28l4 4-4 4" stroke="#d44d53" stroke-width="2" fill="none" />
                                    </svg>
                                </span>
                                <div class="offer-label">Hassle free RC transfer</div>
                            </div>
                        </div>
                        <button class="call-expert-btn"><i class="fa fa-phone"></i>Call Expert</button>
                    </div>
                    <!-- End What We Offers Section -->


                    <div class="container tractor-checklist-section">
                        <div class="tractor-checklist-title"><?= htmlspecialchars($product['p_name']) ?> Inspection Checklist</div>
                        <div class="checklist-tabs">
                            <button class="checklist-tab active" onclick="showChecklistTab(event, 'exterior')">Exterior</button>
                            <button class="checklist-tab" onclick="showChecklistTab(event, 'interior')">Interior</button>
                            <button class="checklist-tab" onclick="showChecklistTab(event, 'others')">Others</button>
                        </div>
                        <!-- Exterior Tab -->
                        <div class="checklist-tab-content" id="checklist-tab-exterior">
                            <div class="checklist-items">
                                <?php if (!empty($exterior_checklist_items)) {
                                    $total_items = count($exterior_checklist_items);
                                    $items_per_col = ceil($total_items / 4);
                                    for ($col = 0; $col < 4; $col++) { ?>
                                        <div class="checklist-col">
                                            <ul class="checklist-list">
                                                <?php
                                                $start = $col * $items_per_col;
                                                $end = min($start + $items_per_col, $total_items);
                                                for ($i = $start; $i < $end; $i++) { ?>
                                                    <li><span class="checklist-icon"><i class="fa fa-shield"></i></span><?= htmlspecialchars($exterior_checklist_items[$i]['stg_name']) ?></li>
                                                <?php } ?>
                                            </ul>
                                        </div>
                                    <?php } ?>
                                <?php } else { ?>
                                    <div class="checklist-col">
                                        <ul class="checklist-list">
                                            <li><span style="color:#888;">No exterior checklist items.</span></li>
                                        </ul>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                        <!-- Interior Tab -->
                        <div class="checklist-tab-content" id="checklist-tab-interior" style="display:none;">
                            <div class="checklist-items">
                                <?php if (!empty($interior_checklist_items)) {
                                    $total_items = count($interior_checklist_items);
                                    $items_per_col = ceil($total_items / 4);
                                    for ($col = 0; $col < 4; $col++) { ?>
                                        <div class="checklist-col">
                                            <ul class="checklist-list">
                                                <?php
                                                $start = $col * $items_per_col;
                                                $end = min($start + $items_per_col, $total_items);
                                                for ($i = $start; $i < $end; $i++) { ?>
                                                    <li><span class="checklist-icon"><i class="fa fa-shield"></i></span><?= htmlspecialchars($interior_checklist_items[$i]['stg_name']) ?></li>
                                                <?php } ?>
                                            </ul>
                                        </div>
                                    <?php } ?>
                                <?php } else { ?>
                                    <div class="checklist-col">
                                        <ul class="checklist-list">
                                            <li><span style="color:#888;">No interior checklist items.</span></li>
                                        </ul>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                        <!-- Others Tab -->
                        <div class="checklist-tab-content" id="checklist-tab-others" style="display:none;">
                            <div class="checklist-items">
                                <?php if (!empty($other_checklist_items)) {
                                    $total_items = count($other_checklist_items);
                                    $items_per_col = ceil($total_items / 4);
                                    for ($col = 0; $col < 4; $col++) { ?>
                                        <div class="checklist-col">
                                            <ul class="checklist-list">
                                                <?php
                                                $start = $col * $items_per_col;
                                                $end = min($start + $items_per_col, $total_items);
                                                for ($i = $start; $i < $end; $i++) { ?>
                                                    <li><span class="checklist-icon"><i class="fa fa-shield"></i></span><?= htmlspecialchars($other_checklist_items[$i]['stg_name']) ?></li>
                                                <?php } ?>
                                            </ul>
                                        </div>
                                    <?php } ?>
                                <?php } else { ?>
                                    <div class="checklist-col">
                                        <ul class="checklist-list">
                                            <li><span style="color:#888;">No other checklist items.</span></li>
                                        </ul>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                       
                    </div>

                    <!-- End Tractor Inspection Checklist Section -->

                    <div class="tab tab-nav-boxed tab-nav-underline product-tabs">
                        <ul class="nav nav-tabs" role="tablist">
                            <li class="nav-item">
                                <a href="#product-tab-description" class="nav-link active">Description</a>
                            </li>
                            <li class="nav-item">
                                <a href="#product-tab-specification" class="nav-link">Specification</a>
                            </li>
                            <li class="nav-item">
                                <a href="#product-tab-vendor" class="nav-link">Vendor Info</a>
                            </li>
                            <!-- <li class="nav-item">
                                <a href="#product-tab-reviews" class="nav-link">Customer Reviews (3)</a>
                            </li> -->
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane active" id="product-tab-description">
                                <div class="row mb-4">
                                    <div class="col-md-6 mb-5">
                                        <h4 class="title tab-pane-title font-weight-bold mb-2">Detail</h4>
                                        <p class="mb-4">Lorem ipsum dolor sit amet, consectetur adipiscing elit,
                                            sed do eiusmod tempor incididunt arcu cursus vitae congue mauris.
                                            Sagittis id consectetur purus ut. Tellus rutrum tellus pelle Vel
                                            pretium lectus quam id leo in vitae turpis massa.</p>
                                        <ul class="list-type-check">
                                            <li>Nunc nec porttitor turpis. In eu risus enim. In vitae mollis
                                                elit.
                                            </li>
                                            <li>Vivamus finibus vel mauris ut vehicula.</li>
                                            <li>Nullam a magna porttitor, dictum risus nec, faucibus sapien.
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="col-md-6 mb-5">
                                        <div class="banner banner-video product-video br-xs">
                                            <figure class="banner-media">
                                                <a href="#">
                                                    <img src="<?= base_url('assets/theme/v2/') ?>assets/images/products/video-banner-610x300.jpg"
                                                        alt="banner" width="610" height="300"
                                                        style="background-color: #bebebe;">
                                                </a>
                                                <a class="btn-play-video btn-iframe"
                                                    href="assets/video/memory-of-a-woman.mp4"></a>
                                            </figure>
                                        </div>
                                    </div>
                                </div>
                                <div class="row cols-md-3">
                                    <div class="mb-3">
                                        <h5 class="sub-title font-weight-bold"><span class="mr-3">1.</span>Free
                                            Shipping &amp; Return</h5>
                                        <p class="detail pl-5">We offer free shipping for products on orders
                                            above 50$ and offer free delivery for all orders in US.</p>
                                    </div>
                                    <div class="mb-3">
                                        <h5 class="sub-title font-weight-bold"><span>2.</span>Free and Easy
                                            Returns</h5>
                                        <p class="detail pl-5">We guarantee our products and you could get back
                                            all of your money anytime you want in 30 days.</p>
                                    </div>
                                    <div class="mb-3">
                                        <h5 class="sub-title font-weight-bold"><span>3.</span>Special Financing
                                        </h5>
                                        <p class="detail pl-5">Get 20%-50% off items over 50$ for a month or
                                            over 250$ for a year with our special credit card.</p>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane" id="product-tab-specification">
                                <ul class="list-none">
                                    <li>
                                        <label>Model</label>
                                        <p></p>
                                    </li>
                                    <li>
                                        <label>Engine Power</label>
                                        <p></p>
                                    </li>
                                    <li>
                                        <label>Engine Type</label>
                                        <p></p>
                                    </li>
                                    <li>
                                        <label>Tyre Type</label>
                                        <p></p>
                                    </li>
                                </ul>
                            </div>
                            <div class="tab-pane" id="product-tab-vendor">
                                <div class="row mb-3">
                                    <div class="col-md-6 mb-4">
                                        <figure class="vendor-banner br-sm">
                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/products/vendor-banner.jpg"
                                                alt="Vendor Banner" width="610" height="295"
                                                style="background-color: #353B55;" />
                                        </figure>
                                    </div>
                                    <div class="col-md-6 pl-2 pl-md-6 mb-4">
                                        <div class="vendor-user">
                                            <figure class="vendor-logo mr-4">
                                                <a href="#">
                                                    <img src="<?= base_url('assets/theme/v2/') ?>assets/images/products/vendor-logo.jpg"
                                                        alt="Vendor Logo" width="80" height="80" />
                                                </a>
                                            </figure>
                                            <div>
                                                <div class="vendor-name"><a href="#">Jone Doe</a></div>
                                                <!-- <div class="ratings-container">
                                                    <div class="ratings-full">
                                                        <span class="ratings" style="width: 90%;"></span>
                                                        <span class="tooltiptext tooltip-top"></span>
                                                    </div>
                                                    <a href="#" class="rating-reviews">(32 Reviews)</a>
                                                </div> -->
                                            </div>
                                        </div>
                                        <ul class="vendor-info list-style-none">
                                            <!-- <li class="store-name">
                                                <label>Store Name:</label>
                                                <span class="detail">OAIO Store</span>
                                            </li> -->
                                            <li class="store-address">
                                                <label>Address:</label>
                                                <span class="detail">Steven Street, El Carjon, CA 92020, United
                                                    States (US)</span>
                                            </li>
                                            <li class="store-phone">
                                                <label>Phone:</label>
                                                <a href="#tel:">1234567890</a>
                                            </li>
                                        </ul>
                                        <!-- <a href="vendor-dokan-store.html"
                                            class="btn btn-dark btn-link btn-underline btn-icon-right">Visit
                                            Store<i class="w-icon-long-arrow-right"></i></a> -->
                                    </div>
                                </div>
                                <p class="mb-5"><strong class="text-dark">L</strong>orem ipsum dolor sit amet,
                                    consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et
                                    dolore magna aliqua.
                                    Venenatis tellus in metus vulputate eu scelerisque felis. Vel pretium
                                    lectus quam id leo in vitae turpis massa. Nunc id cursus metus aliquam.
                                    Libero id faucibus nisl tincidunt eget. Aliquam id diam maecenas ultricies
                                    mi eget mauris. Volutpat ac tincidunt vitae semper quis lectus. Vestibulum
                                    mattis ullamcorper velit sed. A arcu cursus vitae congue mauris.
                                </p>
                                <p class="mb-2"><strong class="text-dark">A</strong> arcu cursus vitae congue
                                    mauris. Sagittis id consectetur purus
                                    ut. Tellus rutrum tellus pellentesque eu tincidunt tortor aliquam nulla.
                                    Diam in
                                    arcu cursus euismod quis. Eget sit amet tellus cras adipiscing enim eu. In
                                    fermentum et sollicitudin ac orci phasellus. A condimentum vitae sapien
                                    pellentesque
                                    habitant morbi tristique senectus et. In dictum non consectetur a erat. Nunc
                                    scelerisque viverra mauris in aliquam sem fringilla.</p>
                            </div>
                            <!-- <div class="tab-pane" id="product-tab-reviews">
                                <div class="row mb-4">
                                    <div class="col-xl-4 col-lg-5 mb-4">
                                        <div class="ratings-wrapper">
                                            <div class="avg-rating-container">
                                                <h4 class="avg-mark font-weight-bolder ls-50">3.3</h4>
                                                <div class="avg-rating">
                                                    <p class="text-dark mb-1">Average Rating</p>
                                                    <div class="ratings-container">
                                                        <div class="ratings-full">
                                                            <span class="ratings" style="width: 60%;"></span>
                                                            <span class="tooltiptext tooltip-top"></span>
                                                        </div>
                                                        <a href="#" class="rating-reviews">(3 Reviews)</a>
                                                    </div>
                                                </div>
                                            </div>
                                            <div
                                                class="ratings-value d-flex align-items-center text-dark ls-25">
                                                <span
                                                    class="text-dark font-weight-bold">66.7%</span>Recommended<span
                                                    class="count">(2 of 3)</span>
                                            </div>
                                            <div class="ratings-list">
                                                <div class="ratings-container">
                                                    <div class="ratings-full">
                                                        <span class="ratings" style="width: 100%;"></span>
                                                        <span class="tooltiptext tooltip-top"></span>
                                                    </div>
                                                    <div class="progress-bar progress-bar-sm ">
                                                        <span></span>
                                                    </div>
                                                    <div class="progress-value">
                                                        <mark>70%</mark>
                                                    </div>
                                                </div>
                                                <div class="ratings-container">
                                                    <div class="ratings-full">
                                                        <span class="ratings" style="width: 80%;"></span>
                                                        <span class="tooltiptext tooltip-top"></span>
                                                    </div>
                                                    <div class="progress-bar progress-bar-sm ">
                                                        <span></span>
                                                    </div>
                                                    <div class="progress-value">
                                                        <mark>30%</mark>
                                                    </div>
                                                </div>
                                                <div class="ratings-container">
                                                    <div class="ratings-full">
                                                        <span class="ratings" style="width: 60%;"></span>
                                                        <span class="tooltiptext tooltip-top"></span>
                                                    </div>
                                                    <div class="progress-bar progress-bar-sm ">
                                                        <span></span>
                                                    </div>
                                                    <div class="progress-value">
                                                        <mark>40%</mark>
                                                    </div>
                                                </div>
                                                <div class="ratings-container">
                                                    <div class="ratings-full">
                                                        <span class="ratings" style="width: 40%;"></span>
                                                        <span class="tooltiptext tooltip-top"></span>
                                                    </div>
                                                    <div class="progress-bar progress-bar-sm ">
                                                        <span></span>
                                                    </div>
                                                    <div class="progress-value">
                                                        <mark>0%</mark>
                                                    </div>
                                                </div>
                                                <div class="ratings-container">
                                                    <div class="ratings-full">
                                                        <span class="ratings" style="width: 20%;"></span>
                                                        <span class="tooltiptext tooltip-top"></span>
                                                    </div>
                                                    <div class="progress-bar progress-bar-sm ">
                                                        <span></span>
                                                    </div>
                                                    <div class="progress-value">
                                                        <mark>0%</mark>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xl-8 col-lg-7 mb-4">
                                        <div class="review-form-wrapper">
                                            <h3 class="title tab-pane-title font-weight-bold mb-1">Submit Your
                                                Review</h3>
                                            <p class="mb-3">Your email address will not be published. Required
                                                fields are marked *</p>
                                            <form action="#" method="POST" class="review-form">
                                                <div class="rating-form">
                                                    <label for="rating">Your Rating Of This Product :</label>
                                                    <span class="rating-stars">
                                                        <a class="star-1" href="#">1</a>
                                                        <a class="star-2" href="#">2</a>
                                                        <a class="star-3" href="#">3</a>
                                                        <a class="star-4" href="#">4</a>
                                                        <a class="star-5" href="#">5</a>
                                                    </span>
                                                    <select name="rating" id="rating" required=""
                                                        style="display: none;">
                                                        <option value="">Rate…</option>
                                                        <option value="5">Perfect</option>
                                                        <option value="4">Good</option>
                                                        <option value="3">Average</option>
                                                        <option value="2">Not that bad</option>
                                                        <option value="1">Very poor</option>
                                                    </select>
                                                </div>
                                                <textarea cols="30" rows="6"
                                                    placeholder="Write Your Review Here..." class="form-control"
                                                    id="review"></textarea>
                                                <div class="row gutter-md">
                                                    <div class="col-md-6">
                                                        <input type="text" class="form-control"
                                                            placeholder="Your Name" id="author">
                                                    </div>
                                                    <div class="col-md-6">
                                                        <input type="text" class="form-control"
                                                            placeholder="Your Email" id="email_1">
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <input type="checkbox" class="custom-checkbox"
                                                        id="save-checkbox">
                                                    <label for="save-checkbox">Save my name, email, and website
                                                        in this browser for the next time I comment.</label>
                                                </div>
                                                <button type="submit" class="btn btn-dark">Submit
                                                    Review</button>
                                            </form>
                                        </div>
                                    </div>
                                </div>

                                <div class="tab tab-nav-boxed tab-nav-outline tab-nav-center">
                                    <ul class="nav nav-tabs" role="tablist">
                                        <li class="nav-item">
                                            <a href="#show-all" class="nav-link active">Show All</a>
                                        </li>
                                        <li class="nav-item">
                                            <a href="#helpful-positive" class="nav-link">Most Helpful
                                                Positive</a>
                                        </li>
                                        <li class="nav-item">
                                            <a href="#helpful-negative" class="nav-link">Most Helpful
                                                Negative</a>
                                        </li>
                                        <li class="nav-item">
                                            <a href="#highest-rating" class="nav-link">Highest Rating</a>
                                        </li>
                                        <li class="nav-item">
                                            <a href="#lowest-rating" class="nav-link">Lowest Rating</a>
                                        </li>
                                    </ul>
                                    <div class="tab-content">
                                        <div class="tab-pane active" id="show-all">
                                            <ul class="comments list-style-none">
                                                <li class="comment">
                                                    <div class="comment-body">
                                                        <figure class="comment-avatar">
                                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/agents/1-100x100.png"
                                                                alt="Commenter Avatar" width="90" height="90">
                                                        </figure>
                                                        <div class="comment-content">
                                                            <h4 class="comment-author">
                                                                <a href="#">John Doe</a>
                                                                <span class="comment-date">March 22, 2021 at
                                                                    1:54 pm</span>
                                                            </h4>
                                                            <div class="ratings-container comment-rating">
                                                                <div class="ratings-full">
                                                                    <span class="ratings"
                                                                        style="width: 60%;"></span>
                                                                    <span
                                                                        class="tooltiptext tooltip-top"></span>
                                                                </div>
                                                            </div>
                                                            <p>pellentesque habitant morbi tristique senectus
                                                                et. In dictum non consectetur a erat.
                                                                Nunc ultrices eros in cursus turpis massa
                                                                tincidunt ante in nibh mauris cursus mattis.
                                                                Cras ornare arcu dui vivamus arcu felis bibendum
                                                                ut tristique.</p>
                                                            <div class="comment-action">
                                                                <a href="#"
                                                                    class="btn btn-secondary btn-link btn-underline sm btn-icon-left font-weight-normal text-capitalize">
                                                                    <i class="far fa-thumbs-up"></i>Helpful (1)
                                                                </a>
                                                                <a href="#"
                                                                    class="btn btn-dark btn-link btn-underline sm btn-icon-left font-weight-normal text-capitalize">
                                                                    <i class="far fa-thumbs-down"></i>Unhelpful
                                                                    (0)
                                                                </a>
                                                                <div class="review-image">
                                                                    <a href="#">
                                                                        <figure>
                                                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/products/default/review-img-1.jpg"
                                                                                width="60" height="60"
                                                                                alt="Attachment image of John Doe's review on Electronics Black Wrist Watch"
                                                                                data-zoom-image="assets/images/products/default/review-img-1-800x900.jpg" />
                                                                        </figure>
                                                                    </a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li class="comment">
                                                    <div class="comment-body">
                                                        <figure class="comment-avatar">
                                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/agents/2-100x100.png"
                                                                alt="Commenter Avatar" width="90" height="90">
                                                        </figure>
                                                        <div class="comment-content">
                                                            <h4 class="comment-author">
                                                                <a href="#">John Doe</a>
                                                                <span class="comment-date">March 22, 2021 at
                                                                    1:52 pm</span>
                                                            </h4>
                                                            <div class="ratings-container comment-rating">
                                                                <div class="ratings-full">
                                                                    <span class="ratings"
                                                                        style="width: 80%;"></span>
                                                                    <span
                                                                        class="tooltiptext tooltip-top"></span>
                                                                </div>
                                                            </div>
                                                            <p>Nullam a magna porttitor, dictum risus nec,
                                                                faucibus sapien.
                                                                Ultrices eros in cursus turpis massa tincidunt
                                                                ante in nibh mauris cursus mattis.
                                                                Cras ornare arcu dui vivamus arcu felis bibendum
                                                                ut tristique.</p>
                                                            <div class="comment-action">
                                                                <a href="#"
                                                                    class="btn btn-secondary btn-link btn-underline sm btn-icon-left font-weight-normal text-capitalize">
                                                                    <i class="far fa-thumbs-up"></i>Helpful (1)
                                                                </a>
                                                                <a href="#"
                                                                    class="btn btn-dark btn-link btn-underline sm btn-icon-left font-weight-normal text-capitalize">
                                                                    <i class="far fa-thumbs-down"></i>Unhelpful
                                                                    (0)
                                                                </a>
                                                                <div class="review-image">
                                                                    <a href="#">
                                                                        <figure>
                                                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/products/default/review-img-2.jpg"
                                                                                width="60" height="60"
                                                                                alt="Attachment image of John Doe's review on Electronics Black Wrist Watch"
                                                                                data-zoom-image="assets/images/products/default/review-img-2.jpg" />
                                                                        </figure>
                                                                    </a>
                                                                    <a href="#">
                                                                        <figure>
                                                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/products/default/review-img-3.jpg"
                                                                                width="60" height="60"
                                                                                alt="Attachment image of John Doe's review on Electronics Black Wrist Watch"
                                                                                data-zoom-image="assets/images/products/default/review-img-3.jpg" />
                                                                        </figure>
                                                                    </a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li class="comment">
                                                    <div class="comment-body">
                                                        <figure class="comment-avatar">
                                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/agents/3-100x100.png"
                                                                alt="Commenter Avatar" width="90" height="90">
                                                        </figure>
                                                        <div class="comment-content">
                                                            <h4 class="comment-author">
                                                                <a href="#">John Doe</a>
                                                                <span class="comment-date">March 22, 2021 at
                                                                    1:21 pm</span>
                                                            </h4>
                                                            <div class="ratings-container comment-rating">
                                                                <div class="ratings-full">
                                                                    <span class="ratings"
                                                                        style="width: 60%;"></span>
                                                                    <span
                                                                        class="tooltiptext tooltip-top"></span>
                                                                </div>
                                                            </div>
                                                            <p>In fermentum et sollicitudin ac orci phasellus. A
                                                                condimentum vitae
                                                                sapien pellentesque habitant morbi tristique
                                                                senectus et. In dictum
                                                                non consectetur a erat. Nunc scelerisque viverra
                                                                mauris in aliquam sem fringilla.</p>
                                                            <div class="comment-action">
                                                                <a href="#"
                                                                    class="btn btn-secondary btn-link btn-underline sm btn-icon-left font-weight-normal text-capitalize">
                                                                    <i class="far fa-thumbs-up"></i>Helpful (0)
                                                                </a>
                                                                <a href="#"
                                                                    class="btn btn-dark btn-link btn-underline sm btn-icon-left font-weight-normal text-capitalize">
                                                                    <i class="far fa-thumbs-down"></i>Unhelpful
                                                                    (1)
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="tab-pane" id="helpful-positive">
                                            <ul class="comments list-style-none">
                                                <li class="comment">
                                                    <div class="comment-body">
                                                        <figure class="comment-avatar">
                                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/agents/1-100x100.png"
                                                                alt="Commenter Avatar" width="90" height="90">
                                                        </figure>
                                                        <div class="comment-content">
                                                            <h4 class="comment-author">
                                                                <a href="#">John Doe</a>
                                                                <span class="comment-date">March 22, 2021 at
                                                                    1:54 pm</span>
                                                            </h4>
                                                            <div class="ratings-container comment-rating">
                                                                <div class="ratings-full">
                                                                    <span class="ratings"
                                                                        style="width: 60%;"></span>
                                                                    <span
                                                                        class="tooltiptext tooltip-top"></span>
                                                                </div>
                                                            </div>
                                                            <p>pellentesque habitant morbi tristique senectus
                                                                et. In dictum non consectetur a erat.
                                                                Nunc ultrices eros in cursus turpis massa
                                                                tincidunt ante in nibh mauris cursus mattis.
                                                                Cras ornare arcu dui vivamus arcu felis bibendum
                                                                ut tristique.</p>
                                                            <div class="comment-action">
                                                                <a href="#"
                                                                    class="btn btn-secondary btn-link btn-underline sm btn-icon-left font-weight-normal text-capitalize">
                                                                    <i class="far fa-thumbs-up"></i>Helpful (1)
                                                                </a>
                                                                <a href="#"
                                                                    class="btn btn-dark btn-link btn-underline sm btn-icon-left font-weight-normal text-capitalize">
                                                                    <i class="far fa-thumbs-down"></i>Unhelpful
                                                                    (0)
                                                                </a>
                                                                <div class="review-image">
                                                                    <a href="#">
                                                                        <figure>
                                                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/products/default/review-img-1.jpg"
                                                                                width="60" height="60"
                                                                                alt="Attachment image of John Doe's review on Electronics Black Wrist Watch"
                                                                                data-zoom-image="assets/images/products/default/review-img-1.jpg" />
                                                                        </figure>
                                                                    </a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li class="comment">
                                                    <div class="comment-body">
                                                        <figure class="comment-avatar">
                                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/agents/2-100x100.png"
                                                                alt="Commenter Avatar" width="90" height="90">
                                                        </figure>
                                                        <div class="comment-content">
                                                            <h4 class="comment-author">
                                                                <a href="#">John Doe</a>
                                                                <span class="comment-date">March 22, 2021 at
                                                                    1:52 pm</span>
                                                            </h4>
                                                            <div class="ratings-container comment-rating">
                                                                <div class="ratings-full">
                                                                    <span class="ratings"
                                                                        style="width: 80%;"></span>
                                                                    <span
                                                                        class="tooltiptext tooltip-top"></span>
                                                                </div>
                                                            </div>
                                                            <p>Nullam a magna porttitor, dictum risus nec,
                                                                faucibus sapien.
                                                                Ultrices eros in cursus turpis massa tincidunt
                                                                ante in nibh mauris cursus mattis.
                                                                Cras ornare arcu dui vivamus arcu felis bibendum
                                                                ut tristique.</p>
                                                            <div class="comment-action">
                                                                <a href="#"
                                                                    class="btn btn-secondary btn-link btn-underline sm btn-icon-left font-weight-normal text-capitalize">
                                                                    <i class="far fa-thumbs-up"></i>Helpful (1)
                                                                </a>
                                                                <a href="#"
                                                                    class="btn btn-dark btn-link btn-underline sm btn-icon-left font-weight-normal text-capitalize">
                                                                    <i class="far fa-thumbs-down"></i>Unhelpful
                                                                    (0)
                                                                </a>
                                                                <div class="review-image">
                                                                    <a href="#">
                                                                        <figure>
                                                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/products/default/review-img-2.jpg"
                                                                                width="60" height="60"
                                                                                alt="Attachment image of John Doe's review on Electronics Black Wrist Watch"
                                                                                data-zoom-image="assets/images/products/default/review-img-2-800x900.jpg" />
                                                                        </figure>
                                                                    </a>
                                                                    <a href="#">
                                                                        <figure>
                                                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/products/default/review-img-3.jpg"
                                                                                width="60" height="60"
                                                                                alt="Attachment image of John Doe's review on Electronics Black Wrist Watch"
                                                                                data-zoom-image="assets/images/products/default/review-img-3-800x900.jpg" />
                                                                        </figure>
                                                                    </a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="tab-pane" id="helpful-negative">
                                            <ul class="comments list-style-none">
                                                <li class="comment">
                                                    <div class="comment-body">
                                                        <figure class="comment-avatar">
                                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/agents/3-100x100.png"
                                                                alt="Commenter Avatar" width="90" height="90">
                                                        </figure>
                                                        <div class="comment-content">
                                                            <h4 class="comment-author">
                                                                <a href="#">John Doe</a>
                                                                <span class="comment-date">March 22, 2021 at
                                                                    1:21 pm</span>
                                                            </h4>
                                                            <div class="ratings-container comment-rating">
                                                                <div class="ratings-full">
                                                                    <span class="ratings"
                                                                        style="width: 60%;"></span>
                                                                    <span
                                                                        class="tooltiptext tooltip-top"></span>
                                                                </div>
                                                            </div>
                                                            <p>In fermentum et sollicitudin ac orci phasellus. A
                                                                condimentum vitae
                                                                sapien pellentesque habitant morbi tristique
                                                                senectus et. In dictum
                                                                non consectetur a erat. Nunc scelerisque viverra
                                                                mauris in aliquam sem fringilla.</p>
                                                            <div class="comment-action">
                                                                <a href="#"
                                                                    class="btn btn-secondary btn-link btn-underline sm btn-icon-left font-weight-normal text-capitalize">
                                                                    <i class="far fa-thumbs-up"></i>Helpful (0)
                                                                </a>
                                                                <a href="#"
                                                                    class="btn btn-dark btn-link btn-underline sm btn-icon-left font-weight-normal text-capitalize">
                                                                    <i class="far fa-thumbs-down"></i>Unhelpful
                                                                    (1)
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="tab-pane" id="highest-rating">
                                            <ul class="comments list-style-none">
                                                <li class="comment">
                                                    <div class="comment-body">
                                                        <figure class="comment-avatar">
                                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/agents/2-100x100.png"
                                                                alt="Commenter Avatar" width="90" height="90">
                                                        </figure>
                                                        <div class="comment-content">
                                                            <h4 class="comment-author">
                                                                <a href="#">John Doe</a>
                                                                <span class="comment-date">March 22, 2021 at
                                                                    1:52 pm</span>
                                                            </h4>
                                                            <div class="ratings-container comment-rating">
                                                                <div class="ratings-full">
                                                                    <span class="ratings"
                                                                        style="width: 80%;"></span>
                                                                    <span
                                                                        class="tooltiptext tooltip-top"></span>
                                                                </div>
                                                            </div>
                                                            <p>Nullam a magna porttitor, dictum risus nec,
                                                                faucibus sapien.
                                                                Ultrices eros in cursus turpis massa tincidunt
                                                                ante in nibh mauris cursus mattis.
                                                                Cras ornare arcu dui vivamus arcu felis bibendum
                                                                ut tristique.</p>
                                                            <div class="comment-action">
                                                                <a href="#"
                                                                    class="btn btn-secondary btn-link btn-underline sm btn-icon-left font-weight-normal text-capitalize">
                                                                    <i class="far fa-thumbs-up"></i>Helpful (1)
                                                                </a>
                                                                <a href="#"
                                                                    class="btn btn-dark btn-link btn-underline sm btn-icon-left font-weight-normal text-capitalize">
                                                                    <i class="far fa-thumbs-down"></i>Unhelpful
                                                                    (0)
                                                                </a>
                                                                <div class="review-image">
                                                                    <a href="#">
                                                                        <figure>
                                                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/products/default/review-img-2.jpg"
                                                                                width="60" height="60"
                                                                                alt="Attachment image of John Doe's review on Electronics Black Wrist Watch"
                                                                                data-zoom-image="assets/images/products/default/review-img-2-800x900.jpg" />
                                                                        </figure>
                                                                    </a>
                                                                    <a href="#">
                                                                        <figure>
                                                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/products/default/review-img-3.jpg"
                                                                                width="60" height="60"
                                                                                alt="Attachment image of John Doe's review on Electronics Black Wrist Watch"
                                                                                data-zoom-image="assets/images/products/default/review-img-3-800x900.jpg" />
                                                                        </figure>
                                                                    </a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="tab-pane" id="lowest-rating">
                                            <ul class="comments list-style-none">
                                                <li class="comment">
                                                    <div class="comment-body">
                                                        <figure class="comment-avatar">
                                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/agents/1-100x100.png"
                                                                alt="Commenter Avatar" width="90" height="90">
                                                        </figure>
                                                        <div class="comment-content">
                                                            <h4 class="comment-author">
                                                                <a href="#">John Doe</a>
                                                                <span class="comment-date">March 22, 2021 at
                                                                    1:54 pm</span>
                                                            </h4>
                                                            <div class="ratings-container comment-rating">
                                                                <div class="ratings-full">
                                                                    <span class="ratings"
                                                                        style="width: 60%;"></span>
                                                                    <span
                                                                        class="tooltiptext tooltip-top"></span>
                                                                </div>
                                                            </div>
                                                            <p>pellentesque habitant morbi tristique senectus
                                                                et. In dictum non consectetur a erat.
                                                                Nunc ultrices eros in cursus turpis massa
                                                                tincidunt ante in nibh mauris cursus mattis.
                                                                Cras ornare arcu dui vivamus arcu felis bibendum
                                                                ut tristique.</p>
                                                            <div class="comment-action">
                                                                <a href="#"
                                                                    class="btn btn-secondary btn-link btn-underline sm btn-icon-left font-weight-normal text-capitalize">
                                                                    <i class="far fa-thumbs-up"></i>Helpful (1)
                                                                </a>
                                                                <a href="#"
                                                                    class="btn btn-dark btn-link btn-underline sm btn-icon-left font-weight-normal text-capitalize">
                                                                    <i class="far fa-thumbs-down"></i>Unhelpful
                                                                    (0)
                                                                </a>
                                                                <div class="review-image">
                                                                    <a href="#">
                                                                        <figure>
                                                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/products/default/review-img-3.jpg"
                                                                                width="60" height="60"
                                                                                alt="Attachment image of John Doe's review on Electronics Black Wrist Watch"
                                                                                data-zoom-image="assets/images/products/default/review-img-3-800x900.jpg" />
                                                                        </figure>
                                                                    </a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div> -->
                        </div>
                    </div>
                    <section class="vendor-product-section">
                        <div class="title-link-wrapper mb-4">
                            <h4 class="title text-left">More Products From This Vendor</h4>
                            <a href="#" class="btn btn-dark btn-link btn-slide-right btn-icon-right">More
                                Products<i class="w-icon-long-arrow-right"></i></a>
                        </div>
                        <div class="swiper-container swiper-theme" data-swiper-options="{
                                    'spaceBetween': 20,
                                    'slidesPerView': 2,
                                    'breakpoints': {
                                        '576': {
                                            'slidesPerView': 3
                                        },
                                        '768': {
                                            'slidesPerView': 4
                                        },
                                        '992': {
                                            'slidesPerView': 3
                                        }
                                    }
                                }">
                            <div class="swiper-wrapper row cols-lg-3 cols-md-4 cols-sm-3 cols-2">
                                <div class="swiper-slide product">
                                    <figure class="product-media">
                                        <a href="product-default.html">
                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/products/default/1-1.jpg" alt="Product"
                                                width="300" height="338" />
                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/products/default/1-2.jpg" alt="Product"
                                                width="300" height="338" />
                                        </a>
                                      
                                        <!-- <div class="product-action">
                                            <a href="#" class="btn-product btn-quickview" title="Quick View">Quick
                                                View</a>
                                        </div> -->
                                    </figure>
                                    <div class="product-details">
                                        <div class="product-cat"><a href="shop-banner-sidebar.html">Accessories</a>
                                        </div>
                                        <h4 class="product-name"><a href="product-default.html">Sticky Pencil</a>
                                        </h4>
                                        <div class="ratings-container">
                                            <div class="ratings-full">
                                                <span class="ratings" style="width: 100%;"></span>
                                                <span class="tooltiptext tooltip-top"></span>
                                            </div>
                                            <a href="product-default.html" class="rating-reviews">(3 reviews)</a>
                                        </div>
                                        <div class="product-pa-wrapper">
                                            <div class="product-price">$20.00</div>
                                        </div>
                                    </div>
                                </div>
                                <div class="swiper-slide product">
                                    <figure class="product-media">
                                        <a href="product-default.html">
                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/products/default/2.jpg" alt="Product"
                                                width="300" height="338" />
                                        </a>
                                        <!-- <div class="product-action-vertical">
                                            <a href="#" class="btn-product-icon btn-cart w-icon-cart"
                                                title="Add to cart"></a>
                                            <a href="#" class="btn-product-icon btn-wishlist w-icon-heart"
                                                title="Add to wishlist"></a>
                                            <a href="#" class="btn-product-icon btn-compare w-icon-compare"
                                                title="Add to Compare"></a>
                                        </div>
                                        <div class="product-action">
                                            <a href="#" class="btn-product btn-quickview" title="Quick View">Quick
                                                View</a>
                                        </div> -->
                                    </figure>
                                    <div class="product-details">
                                        <div class="product-cat"><a href="shop-banner-sidebar.html">Electronics</a>
                                        </div>
                                        <h4 class="product-name"><a href="product-default.html">Mini
                                                Multi-Functional Cooker</a></h4>
                                        <div class="ratings-container">
                                            <div class="ratings-full">
                                                <span class="ratings" style="width: 80%;"></span>
                                                <span class="tooltiptext tooltip-top"></span>
                                            </div>
                                            <a href="product-default.html" class="rating-reviews">(5 reviews)</a>
                                        </div>
                                        <div class="product-pa-wrapper">
                                            <div class="product-price">
                                                <ins class="new-price">$480.00</ins><del
                                                    class="old-price">$534.00</del>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="swiper-slide product">
                                    <figure class="product-media">
                                        <a href="product-default.html">
                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/products/default/3.jpg" alt="Product"
                                                width="300" height="338" />
                                        </a>
                                        <!-- <div class="product-action-vertical">
                                            <a href="#" class="btn-product-icon btn-cart w-icon-cart"
                                                title="Add to cart"></a>
                                            <a href="#" class="btn-product-icon btn-wishlist w-icon-heart"
                                                title="Add to wishlist"></a>
                                            <a href="#" class="btn-product-icon btn-compare w-icon-compare"
                                                title="Add to Compare"></a>
                                        </div>
                                        <div class="product-action">
                                            <a href="#" class="btn-product btn-quickview" title="Quick View">Quick
                                                View</a>
                                        </div> -->
                                    </figure>
                                    <div class="product-details">
                                        <div class="product-cat"><a href="shop-banner-sidebar.html">Sports</a></div>
                                        <h4 class="product-name"><a href="product-default.html">Skate Pan</a></h4>
                                        <div class="ratings-container">
                                            <div class="ratings-full">
                                                <span class="ratings" style="width: 100%;"></span>
                                                <span class="tooltiptext tooltip-top"></span>
                                            </div>
                                            <a href="product-default.html" class="rating-reviews">(3 reviews)</a>
                                        </div>
                                        <div class="product-pa-wrapper">
                                            <div class="product-price">
                                                <ins class="new-price">$278.00</ins><del
                                                    class="old-price">$310.00</del>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="swiper-slide product">
                                    <figure class="product-media">
                                        <a href="product-default.html">
                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/products/default/4-1.jpg" alt="Product"
                                                width="300" height="338" />
                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/products/default/4-2.jpg" alt="Product"
                                                width="300" height="338" />
                                        </a>
                                        <!-- <div class="product-action-vertical">
                                            <a href="#" class="btn-product-icon btn-cart w-icon-cart"
                                                title="Add to cart"></a>
                                            <a href="#" class="btn-product-icon btn-wishlist w-icon-heart"
                                                title="Add to wishlist"></a>
                                            <a href="#" class="btn-product-icon btn-compare w-icon-compare"
                                                title="Add to Compare"></a>
                                        </div>
                                        <div class="product-action">
                                            <a href="#" class="btn-product btn-quickview" title="Quick View">Quick
                                                View</a>
                                        </div> -->
                                    </figure>
                                    <div class="product-details">
                                        <div class="product-cat"><a href="shop-banner-sidebar.html">Accessories</a>
                                        </div>
                                        <h4 class="product-name"><a href="product-default.html">Clip Attachment</a>
                                        </h4>
                                        <div class="ratings-container">
                                            <div class="ratings-full">
                                                <span class="ratings" style="width: 100%;"></span>
                                                <span class="tooltiptext tooltip-top"></span>
                                            </div>
                                            <a href="product-default.html" class="rating-reviews">(5 reviews)</a>
                                        </div>
                                        <div class="product-pa-wrapper">
                                            <div class="product-price">$40.00</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>
                    <!-- <section class="related-product-section">
                        <div class="title-link-wrapper mb-4">
                            <h4 class="title">Related Products</h4>
                            <a href="#" class="btn btn-dark btn-link btn-slide-right btn-icon-right">More
                                Products<i class="w-icon-long-arrow-right"></i></a>
                        </div>
                        <div class="swiper-container swiper-theme" data-swiper-options="{
                                    'spaceBetween': 20,
                                    'slidesPerView': 2,
                                    'breakpoints': {
                                        '576': {
                                            'slidesPerView': 3
                                        },
                                        '768': {
                                            'slidesPerView': 4
                                        },
                                        '992': {
                                            'slidesPerView': 3
                                        }
                                    }
                                }">
                            <div class="swiper-wrapper row cols-lg-3 cols-md-4 cols-sm-3 cols-2">
                                <div class="swiper-slide product">
                                    <figure class="product-media">
                                        <a href="product-default.html">
                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/products/default/5.jpg" alt="Product"
                                                width="300" height="338" />
                                        </a>
                                        <div class="product-action-vertical">
                                            <a href="#" class="btn-product-icon btn-cart w-icon-cart"
                                                title="Add to cart"></a>
                                            <a href="#" class="btn-product-icon btn-wishlist w-icon-heart"
                                                title="Add to wishlist"></a>
                                            <a href="#" class="btn-product-icon btn-compare w-icon-compare"
                                                title="Add to Compare"></a>
                                        </div>
                                        <div class="product-action">
                                            <a href="#" class="btn-product btn-quickview" title="Quick View">Quick
                                                View</a>
                                        </div>
                                    </figure>
                                    <div class="product-details">
                                        <h4 class="product-name"><a href="product-default.html">Drone</a></h4>
                                        <div class="ratings-container">
                                            <div class="ratings-full">
                                                <span class="ratings" style="width: 100%;"></span>
                                                <span class="tooltiptext tooltip-top"></span>
                                            </div>
                                            <a href="product-default.html" class="rating-reviews">(3 reviews)</a>
                                        </div>
                                        <div class="product-pa-wrapper">
                                            <div class="product-price">$632.00</div>
                                        </div>
                                    </div>
                                </div>
                                <div class="swiper-slide product">
                                    <figure class="product-media">
                                        <a href="product-default.html">
                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/products/default/6.jpg" alt="Product"
                                                width="300" height="338" />
                                        </a>
                                        <div class="product-action-vertical">
                                            <a href="#" class="btn-product-icon btn-cart w-icon-cart"
                                                title="Add to cart"></a>
                                            <a href="#" class="btn-product-icon btn-wishlist w-icon-heart"
                                                title="Add to wishlist"></a>
                                            <a href="#" class="btn-product-icon btn-compare w-icon-compare"
                                                title="Add to Compare"></a>
                                        </div>
                                        <div class="product-action">
                                            <a href="#" class="btn-product btn-quickview" title="Quick View">Quick
                                                View</a>
                                        </div>
                                    </figure>
                                    <div class="product-details">
                                        <h4 class="product-name"><a href="product-default.html">Official Camera</a>
                                        </h4>
                                        <div class="ratings-container">
                                            <div class="ratings-full">
                                                <span class="ratings" style="width: 100%;"></span>
                                                <span class="tooltiptext tooltip-top"></span>
                                            </div>
                                            <a href="product-default.html" class="rating-reviews">(3 reviews)</a>
                                        </div>
                                        <div class="product-pa-wrapper">
                                            <div class="product-price">
                                                <ins class="new-price">$263.00</ins><del
                                                    class="old-price">$300.00</del>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="swiper-slide product">
                                    <figure class="product-media">
                                        <a href="product-default.html">
                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/products/default/7-1.jpg" alt="Product"
                                                width="300" height="338" />
                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/products/default/7-2.jpg" alt="Product"
                                                width="300" height="338" />
                                        </a>
                                        <div class="product-action-vertical">
                                            <a href="#" class="btn-product-icon btn-cart w-icon-cart"
                                                title="Add to cart"></a>
                                            <a href="#" class="btn-product-icon btn-wishlist w-icon-heart"
                                                title="Add to wishlist"></a>
                                            <a href="#" class="btn-product-icon btn-compare w-icon-compare"
                                                title="Add to Compare"></a>
                                        </div>
                                        <div class="product-action">
                                            <a href="#" class="btn-product btn-quickview" title="Quick View">Quick
                                                View</a>
                                        </div>
                                    </figure>
                                    <div class="product-details">
                                        <h4 class="product-name"><a href="product-default.html">Phone Charge Pad</a>
                                        </h4>
                                        <div class="ratings-container">
                                            <div class="ratings-full">
                                                <span class="ratings" style="width: 80%;"></span>
                                                <span class="tooltiptext tooltip-top"></span>
                                            </div>
                                            <a href="product-default.html" class="rating-reviews">(8 reviews)</a>
                                        </div>
                                        <div class="product-pa-wrapper">
                                            <div class="product-price">$23.00</div>
                                        </div>
                                    </div>
                                </div>
                                <div class="swiper-slide product">
                                    <figure class="product-media">
                                        <a href="product-default.html">
                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/products/default/8.jpg" alt="Product"
                                                width="300" height="338" />
                                        </a>
                                        <div class="product-action-vertical">
                                            <a href="#" class="btn-product-icon btn-cart w-icon-cart"
                                                title="Add to cart"></a>
                                            <a href="#" class="btn-product-icon btn-wishlist w-icon-heart"
                                                title="Add to wishlist"></a>
                                            <a href="#" class="btn-product-icon btn-compare w-icon-compare"
                                                title="Add to Compare"></a>
                                        </div>
                                        <div class="product-action">
                                            <a href="#" class="btn-product btn-quickview" title="Quick View">Quick
                                                View</a>
                                        </div>
                                    </figure>
                                    <div class="product-details">
                                        <h4 class="product-name"><a href="product-default.html">Fashionalble
                                                Pencil</a></h4>
                                        <div class="ratings-container">
                                            <div class="ratings-full">
                                                <span class="ratings" style="width: 100%;"></span>
                                                <span class="tooltiptext tooltip-top"></span>
                                            </div>
                                            <a href="product-default.html" class="rating-reviews">(9 reviews)</a>
                                        </div>
                                        <div class="product-pa-wrapper">
                                            <div class="product-price">$50.00</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section> -->
                </div>
                <!-- End of Main Content -->
                <aside class="sidebar product-sidebar sidebar-fixed right-sidebar sticky-sidebar-wrapper">
                    <div class="sidebar-overlay"></div>
                    <a class="sidebar-close" href="#"><i class="close-icon"></i></a>
                    <a href="#" class="sidebar-toggle d-flex d-lg-none"><i class="fas fa-chevron-left"></i></a>
                    <div class="sidebar-content scrollable">
                        <div class="sticky-sidebar">
                            <div class="widget widget-icon-box mb-6">
                                <div class="icon-box icon-box-side">
                                    <span class="icon-box-icon text-dark">
                                        <i class="w-icon-truck"></i>
                                    </span>
                                    <div class="icon-box-content">
                                        <h4 class="icon-box-title">Free Shipping & Returns</h4>
                                        <p>For all orders over $99</p>
                                    </div>
                                </div>
                                <div class="icon-box icon-box-side">
                                    <span class="icon-box-icon text-dark">
                                        <i class="w-icon-bag"></i>
                                    </span>
                                    <div class="icon-box-content">
                                        <h4 class="icon-box-title">Secure Payment</h4>
                                        <p>We ensure secure payment</p>
                                    </div>
                                </div>
                                <div class="icon-box icon-box-side">
                                    <span class="icon-box-icon text-dark">
                                        <i class="w-icon-money"></i>
                                    </span>
                                    <div class="icon-box-content">
                                        <h4 class="icon-box-title">Money Back Guarantee</h4>
                                        <p>Any back within 30 days</p>
                                    </div>
                                </div>
                            </div>
                            <!-- End of Widget Icon Box -->

                            <div class="widget widget-banner mb-9">
                                <div class="banner banner-fixed br-sm">
                                    <figure>
                                        <img src="<?= base_url('assets/theme/v2/') ?>assets/images/shop/banner3.jpg" alt="Banner" width="266"
                                            height="220" style="background-color: #1D2D44;" />
                                    </figure>
                                    <div class="banner-content">
                                        <div class="banner-price-info font-weight-bolder text-white lh-1 ls-25">
                                            40<sup class="font-weight-bold">%</sup><sub
                                                class="font-weight-bold text-uppercase ls-25">Off</sub>
                                        </div>
                                        <h4
                                            class="banner-subtitle text-white font-weight-bolder text-uppercase mb-0">
                                            Ultimate Sale</h4>
                                    </div>
                                </div>
                            </div>
                            <!-- End of Widget Banner -->

                            <div class="widget widget-products">
                                <div class="title-link-wrapper mb-2">
                                    <h4 class="title title-link font-weight-bold">More Products</h4>
                                </div>

                                <div class="swiper nav-top">
                                    <div class="swiper-container swiper-theme nav-top" data-swiper-options="{
                                                'slidesPerView': 1,
                                                'spaceBetween': 20,
                                                'navigation': {
                                                    'prevEl': '.swiper-button-prev',
                                                    'nextEl': '.swiper-button-next'
                                                }
                                            }">
                                        <div class="swiper-wrapper">
                                            <div class="widget-col swiper-slide">
                                                <div class="product product-widget">
                                                    <figure class="product-media">
                                                        <a href="#">
                                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/shop/13.jpg" alt="Product"
                                                                width="100" height="113" />
                                                        </a>
                                                    </figure>
                                                    <div class="product-details">
                                                        <h4 class="product-name">
                                                            <a href="#">Smart Watch</a>
                                                        </h4>
                                                        <div class="ratings-container">
                                                            <div class="ratings-full">
                                                                <span class="ratings" style="width: 100%;"></span>
                                                                <span class="tooltiptext tooltip-top"></span>
                                                            </div>
                                                        </div>
                                                        <div class="product-price">$80.00 - $90.00</div>
                                                    </div>
                                                </div>
                                                <div class="product product-widget">
                                                    <figure class="product-media">
                                                        <a href="#">
                                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/shop/14.jpg" alt="Product"
                                                                width="100" height="113" />
                                                        </a>
                                                    </figure>
                                                    <div class="product-details">
                                                        <h4 class="product-name">
                                                            <a href="#">Sky Medical Facility</a>
                                                        </h4>
                                                        <div class="ratings-container">
                                                            <div class="ratings-full">
                                                                <span class="ratings" style="width: 80%;"></span>
                                                                <span class="tooltiptext tooltip-top"></span>
                                                            </div>
                                                        </div>
                                                        <div class="product-price">$58.00</div>
                                                    </div>
                                                </div>
                                                <div class="product product-widget">
                                                    <figure class="product-media">
                                                        <a href="#">
                                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/shop/15.jpg" alt="Product"
                                                                width="100" height="113" />
                                                        </a>
                                                    </figure>
                                                    <div class="product-details">
                                                        <h4 class="product-name">
                                                            <a href="#">Black Stunt Motor</a>
                                                        </h4>
                                                        <div class="ratings-container">
                                                            <div class="ratings-full">
                                                                <span class="ratings" style="width: 60%;"></span>
                                                                <span class="tooltiptext tooltip-top"></span>
                                                            </div>
                                                        </div>
                                                        <div class="product-price">$374.00</div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="widget-col swiper-slide">
                                                <div class="product product-widget">
                                                    <figure class="product-media">
                                                        <a href="#">
                                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/shop/16.jpg" alt="Product"
                                                                width="100" height="113" />
                                                        </a>
                                                    </figure>
                                                    <div class="product-details">
                                                        <h4 class="product-name">
                                                            <a href="#">Skate Pan</a>
                                                        </h4>
                                                        <div class="ratings-container">
                                                            <div class="ratings-full">
                                                                <span class="ratings" style="width: 100%;"></span>
                                                                <span class="tooltiptext tooltip-top"></span>
                                                            </div>
                                                        </div>
                                                        <div class="product-price">$278.00</div>
                                                    </div>
                                                </div>
                                                <div class="product product-widget">
                                                    <figure class="product-media">
                                                        <a href="#">
                                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/shop/17.jpg" alt="Product"
                                                                width="100" height="113" />
                                                        </a>
                                                    </figure>
                                                    <div class="product-details">
                                                        <h4 class="product-name">
                                                            <a href="#">Modern Cooker</a>
                                                        </h4>
                                                        <div class="ratings-container">
                                                            <div class="ratings-full">
                                                                <span class="ratings" style="width: 80%;"></span>
                                                                <span class="tooltiptext tooltip-top"></span>
                                                            </div>
                                                        </div>
                                                        <div class="product-price">$324.00</div>
                                                    </div>
                                                </div>
                                                <div class="product product-widget">
                                                    <figure class="product-media">
                                                        <a href="#">
                                                            <img src="<?= base_url('assets/theme/v2/') ?>assets/images/shop/18.jpg" alt="Product"
                                                                width="100" height="113" />
                                                        </a>
                                                    </figure>
                                                    <div class="product-details">
                                                        <h4 class="product-name">
                                                            <a href="#">CT Machine</a>
                                                        </h4>
                                                        <div class="ratings-container">
                                                            <div class="ratings-full">
                                                                <span class="ratings" style="width: 100%;"></span>
                                                                <span class="tooltiptext tooltip-top"></span>
                                                            </div>
                                                        </div>
                                                        <div class="product-price">$236.00</div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <button class="swiper-button-next"></button>
                                        <button class="swiper-button-prev"></button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </aside>
                <!-- End of Sidebar -->
            </div>
        </div>
    </div>
    <!-- End of Page Content -->
</main>
<!-- End of Main -->

<script>
    function showChecklistTab(evt, tab) {
        var i, tabcontent, tablinks;
        tabcontent = document.querySelectorAll('.checklist-tab-content');
        tablinks = document.querySelectorAll('.checklist-tab');
        tabcontent.forEach(function(tc) {
            tc.style.display = 'none';
        });
        tablinks.forEach(function(tl) {
            tl.classList.remove('active');
        });
        document.getElementById('checklist-tab-' + tab).style.display = '';
        evt.currentTarget.classList.add('active');
    }
</script>