<!-- header starts -->
<header class="header ecommerce-main-header">
    <div class="custom-container2">
        <div class="header-panel">
            <div class="header-top-content text-center">
                <a href="<?= base_url('index.php/profile') ?>" onclick="history.back()">
                    <i class="iconsax icon-btn" data-icon="chevron-left"></i>
                </a>
                <h3>Account Setting</h3>
            </div>
        </div>
    </div>
</header>
<!-- header end -->

<style>
    /* Professional Bright Colors for Buttons - Matching Black & White Logo */
    .btn.ecommerce-btn {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%) !important;
        border: none !important;
        color: #fff !important;
        font-weight: 600;
        box-shadow: 0 4px 15px rgba(102, 126, 234, 0.4);
        transition: all 0.3s ease;
    }
    .btn.ecommerce-btn:hover {
        background: linear-gradient(135deg, #764ba2 0%, #667eea 100%) !important;
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(102, 126, 234, 0.5);
    }
</style>

    <!-- account section starts -->
    <section class="section-lg-t-space">
        <div class="custom-container">
            <form class="ecommerce-form" id="profileSettingForm" onsubmit="return handleProfileUpdate(this);" enctype="multipart/form-data">
                <div id="error_div" class="alert alert-danger" style="display:none;"></div>
                <div id="loder_div" style="display:none; text-align:center; padding:10px;">
                    <img src="<?= base_url('assets/theme/v1/social-app/assets/images/gif/fashion.gif') ?>" style="width:50px; height:50px;">
                </div>

                <div class="profile-img" style="position: relative; cursor: pointer; margin-bottom: 30px;" onclick="document.getElementById('profile_photo_input').click()">
                    <?php
                    $user_photo = '';
                    $yid = $_SESSION['yid'];
                    
                    // Check multiple possible locations for the photo
                    if (!empty($profile_data['photo']) && $profile_data['photo'] != 'photo.jpg') {
                        // First try: user's img directory with the exact filename from database
                        $photo_path1 = 'assets/mem/' . $yid . '/img/' . $profile_data['photo'];
                        // Second try: user's img directory as photo.jpg (where we copy it)
                        $photo_path2 = 'assets/mem/' . $yid . '/img/photo.jpg';
                        // Third try: upload directory (original upload location)
                        $photo_path3 = 'assets/avator/upload/' . $profile_data['photo'];
                        
                        if (file_exists($photo_path1)) {
                            $user_photo = base_url($photo_path1);
                        } elseif (file_exists($photo_path2)) {
                            $user_photo = base_url($photo_path2);
                        } elseif (file_exists($photo_path3)) {
                            $user_photo = base_url($photo_path3);
                        } else {
                            // Fallback to default
                            $user_photo = base_url('assets/theme/v1/social-app/assets/images/profile/p3.png');
                        }
                    } else {
                        // Try photo.jpg in user directory
                        $photo_path = 'assets/mem/' . $yid . '/img/photo.jpg';
                        if (file_exists($photo_path)) {
                            $user_photo = base_url($photo_path);
                        } else {
                            $user_photo = base_url('assets/theme/v1/social-app/assets/images/profile/p3.png');
                        }
                    }
                    ?>
                    <img id="output" class="img-fluid profile" src="<?= $user_photo ?>" alt="profile" onerror="this.src='<?= base_url('assets/theme/v1/social-app/assets/images/profile/p3.png') ?>'">
                    <i class="iconsax edit-icon" data-icon="edit-2"></i>
                    <input id="profile_photo_input" type="file" name="profile_photo" accept="image/*" style="display: none;" onchange="loadFile(event)">
                </div>

                <div class="profile-setting-details">

                    <div class="form-group floating-label-input">
                        <input class="input-text" type="text" id="firstname" name="firstname" placeholder="First Name" value="<?= isset($profile_data['firstname']) ? htmlspecialchars($profile_data['firstname']) : '' ?>" required>
                        <label class="form-check-label" for="firstname">First Name</label>
                    </div>

                    <div class="form-group floating-label-input">
                        <input class="input-text" type="text" id="lastname" name="lastname" placeholder="Last Name" value="<?= isset($profile_data['lastname']) ? htmlspecialchars($profile_data['lastname']) : '' ?>" required>
                        <label class="form-check-label" for="lastname">Last Name</label>
                    </div>

                    <div class="form-group floating-label-input">
                        <input class="input-text" type="email" id="email" name="email" placeholder="Email" value="<?= isset($profile_data['email']) ? htmlspecialchars($profile_data['email']) : (isset($_SESSION['email']) ? htmlspecialchars($_SESSION['email']) : '') ?>" required>
                        <label class="form-check-label" for="email">Email</label>
                    </div>

                    <div class="form-group floating-label-input">
                        <input class="input-text" type="tel" id="phone" name="phone" placeholder="Phone" value="<?= isset($profile_data['phone']) ? htmlspecialchars($profile_data['phone']) : (isset($profile_data['contact']) ? htmlspecialchars($profile_data['contact']) : '') ?>" required>
                        <label class="form-check-label" for="phone">Phone</label>
                    </div>

                    <div class="form-group floating-label-input">
                        <input class="input-text" type="text" id="username" name="username" placeholder="Username" value="<?= isset($profile_data['username']) ? htmlspecialchars($profile_data['username']) : '' ?>">
                        <label class="form-check-label" for="username">Username</label>
                    </div>

                    <div class="form-group floating-label-input">
                        <textarea class="input-text" id="bio" name="bio" placeholder="Bio" rows="3"><?= isset($profile_data['about']) ? htmlspecialchars($profile_data['about']) : '' ?></textarea>
                        <label class="form-check-label" for="bio">Bio</label>
                    </div>

                    <button type="submit" class="btn ecommerce-btn w-100 mt-5">Update Account</button>
            </div>
            </form>
        </div>
    </section>
    <!-- account section end -->

    <!-- panel-space start -->
    <div class="panel-space"></div>
    <!-- panel-space end -->

    <!-- SweetAlert2 Library -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>
    // Preview profile photo when file is selected
    function loadFile(event) {
        var output = document.getElementById('output');
        if (event.target.files && event.target.files[0]) {
            var reader = new FileReader();
            reader.onload = function(e) {
                output.src = e.target.result;
            };
            reader.readAsDataURL(event.target.files[0]);
        }
    }


    // Handle profile update form submission
    function handleProfileUpdate(form) {
        var formData = new FormData(form);
        
        $('#error_div').hide();
        $('#loder_div').show();
        
        $.ajax({
            url: '<?= base_url('index.php/action/update_profile') ?>',
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                $('#loder_div').hide();
                if (response.trim() == 'YNAPS_SUCCESS') {
                    Swal.fire({
                        icon: 'success',
                        title: 'Success!',
                        text: 'Profile updated successfully!',
                        timer: 2000,
                        showConfirmButton: false,
                        timerProgressBar: true
                    }).then(function() {
                        window.location.reload();
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error!',
                        text: response || 'Failed to update profile. Please try again.',
                        confirmButtonText: 'OK'
                    });
                    $('#error_div').html(response).show();
                }
            },
            error: function(xhr, status, error) {
                $('#loder_div').hide();
                Swal.fire({
                    icon: 'error',
                    title: 'Error!',
                    text: 'An error occurred. Please try again.',
                    confirmButtonText: 'OK'
                });
                $('#error_div').html('An error occurred. Please try again.').show();
            }
        });
        
        return false;
    }
    </script>
 