  <!-- main-area -->
  <main class="main-area">

<!-- breadcrumb-area -->
	<div class="breadcrumb__area breadcrumb__bg breadcrumb__bg-three" data-background="<?= base_url('assets/theme/v2/skillgro/') ?>assets/img/bg/breadcrumb_bg.jpg">
	<div class="breadcrumb__shape-wrap">
		<img src="<?= base_url('assets/theme/v2/skillgro/') ?>assets/img/others/breadcrumb_shape01.svg" alt="img" class="alltuchtopdown">
		<img src="<?= base_url('assets/theme/v2/skillgro/') ?>assets/img/others/breadcrumb_shape02.svg" alt="img" data-aos="fade-right" data-aos-delay="300">
		<img src="<?= base_url('assets/theme/v2/skillgro/') ?>assets/img/others/breadcrumb_shape03.svg" alt="img" data-aos="fade-up" data-aos-delay="400">
		<img src="<?= base_url('assets/theme/v2/skillgro/') ?>assets/img/others/breadcrumb_shape04.svg" alt="img" data-aos="fade-down-left" data-aos-delay="400">
		<img src="<?= base_url('assets/theme/v2/skillgro/') ?>assets/img/others/breadcrumb_shape05.svg" alt="img" data-aos="fade-left" data-aos-delay="400">
	</div>
</div>
<!-- breadcrumb-area-end -->

<!-- dashboard-area -->
<section class="dashboard__area section-pb-120">
		<div class="container">
		<div class="dashboard__top-wrap">
				<div class="dashboard__top-bg" data-background="<?= base_url('assets/theme/v2/skillgro/') ?>assets/img/bg/student_bg1.jpg"></div>
			<div class="dashboard__instructor-info">
									<div class="dashboard__instructor-info-left">
					<div class="thumb">
							<?php
							$user_photo = '';
							if (!empty($_SESSION['photo'])) {
								$user_photo = base_url('assets/avator/upload/' . $_SESSION['photo']);
							} else {
								$user_photo = base_url('assets/mem/' . $_SESSION['yid'] . '/img/profile.jpg');
							}
							?>
							<img src="<?= $user_photo ?>" alt="img" onerror="this.src='<?= base_url('assets/theme/v2/skillgro/') ?>assets/img/courses/details_instructors02.jpg'"
								style="width: 120px; height: 120px; object-fit: cover; border-radius: 50%; border: 3px solid #fff; box-shadow: 0 4px 8px rgba(0,0,0,0.1);">
		</div>
					<div class="content">
						<h4 class="title"><?= isset($profile_name) ? $profile_name : 'User' ?></h4>
						<ul class="list-wrap">
							<li>
								<img src="<?= base_url('assets/theme/v2/skillgro/') ?>assets/img/icons/course_icon03.svg" alt="img" class="injectable">
								<?= isset($_SESSION['user_type']) ? ucfirst($_SESSION['user_type']) : 'User' ?>
					</li>
							<li>
								<img src="<?= base_url('assets/theme/v2/skillgro/') ?>assets/img/icons/course_icon05.svg" alt="img" class="injectable">
								Member Since <?= date('M Y') ?>
					</li>
				</ul>
										</div>
									</div>
				<div class="dashboard__instructor-info-right">
						<?php if (isset($_SESSION['user_type']) && $_SESSION['user_type'] == 'student'): ?>
							<!-- <a href="#" class="btn btn-two arrow-btn">Become an Instructor <img src="<?= base_url('assets/theme/v2/skillgro/') ?>assets/img/icons/right_arrow.svg" alt="img" class="injectable"></a> -->
						<?php elseif (isset($_SESSION['user_type']) && $_SESSION['user_type'] == 'teacher'): ?>
						<a href="#" class="btn btn-two arrow-btn">Teacher Dashboard <img src="<?= base_url('assets/theme/v2/skillgro/') ?>assets/img/icons/right_arrow.svg" alt="img" class="injectable"></a>
					<?php else: ?>
						<a href="#" class="btn btn-two arrow-btn">Dashboard <img src="<?= base_url('assets/theme/v2/skillgro/') ?>assets/img/icons/right_arrow.svg" alt="img" class="injectable"></a>
					<?php endif; ?>
							</div>
										</div>
									</div>
		<div class="row">
			<div class="col-lg-3">
				<div class="dashboard__sidebar-wrap">
					<div class="dashboard__sidebar-title mb-20">
						<h6 class="title">Welcome, <?= isset($_SESSION['name']) ? $_SESSION['name'] : 'User' ?></h6>
					</div>
					<nav class="dashboard__sidebar-menu">
						<ul class="list-wrap">
							<li>
									<a href="#" class="profile-tab-link active" data-tab="profile">
									<i class="skillgro-avatar"></i>
									My Profile
								</a>
							</li>
							<li>
									<a href="#" class="profile-tab-link" data-tab="topics">
										<i class="skillgro-video-tutorial"></i>
										My Topics
									</a>
								</li>
								<!-- <li>
									<a href="#">
										<i class="skillgro-marketing"></i>
										Announcements
									</a>
								</li>
								<li>
									<a href="#">
										<i class="skillgro-chat"></i>
										Quiz Attempts
								</a>
							</li>
								<li>
									<a href="#">
										<i class="skillgro-list"></i>
										Assignments
									</a>
								</li> -->
						</ul>
					</nav>
						<!-- <div class="dashboard__sidebar-title mt-40 mb-20">
							<h6 class="title">INSTRUCTOR</h6>
						</div> -->

					<div class="dashboard__sidebar-title mt-30 mb-20">
						<h6 class="title">User</h6>
					</div>
					<nav class="dashboard__sidebar-menu">
						<ul class="list-wrap">
							<li>
									<a href="#" class="profile-tab-link" data-tab="settings">
									<i class="skillgro-settings"></i>
									Settings
								</a>
							</li>
							<li>
								<a href="<?= base_url('logout') ?>">
									<i class="skillgro-logout"></i>
									Logout
								</a>
							</li>
						</ul>
					</nav>
												</div>
											</div>
			<div class="col-lg-9">
				<div class="dashboard__content-wrap">
						<!-- Profile Tab Content -->
						<div class="profile-tab-content active" id="profile-tab">
					<div class="dashboard__content-title">
						<h4 class="title">My Profile</h4>
					</div>
					<div class="row">
						<div class="col-lg-12">
							<div class="profile__content-wrap">
								<ul class="list-wrap">
									<li><span>Registration Date</span> <?= date('F j, Y g:i a') ?></li>
									<li><span>Full Name</span> <?= isset($profile_name) ? $profile_name : 'Not Set' ?></li>
									<li><span>User Type</span> <?= isset($_SESSION['user_type']) ? ucfirst($_SESSION['user_type']) : 'Not Set' ?></li>
									<li><span>Email</span> <?= isset($_SESSION['email']) ? $_SESSION['email'] : 'Not Set' ?></li>
									<li><span>Phone Number</span> <?= isset($profile_phone) ? $profile_phone : 'Not Set' ?></li>
									<li><span>User ID</span> <?= isset($_SESSION['yid']) ? $_SESSION['yid'] : 'Not Set' ?></li>
									<li><span>Account Status</span> <?= isset($_SESSION['verify']) ? ($_SESSION['verify'] == '1' ? 'Verified' : 'Pending Verification') : 'Not Set' ?></li>
									<li><span>Member Since</span> <?= date('F Y') ?></li>
								</ul>
									</div>
								</div>
							</div>
						</div>

						<!-- My Topics Tab Content -->
						<div class="profile-tab-content" id="topics-tab">
							<!-- Course Cards Grid -->
							<div class="row" id="topics-grid">
								<!-- Dynamic content will be loaded here -->
								<div class="col-12 text-center" id="loading-topics">
									<div class="spinner-border text-primary" role="status">
										<span class="visually-hidden">Loading...</span>
									</div>
									<p class="mt-2">Loading your topics...</p>
								</div>
							</div>

							<!-- Topic Detail Section (Hidden by default) -->
							<div id="topic-detail-section" style="display: none;">
								<div class="row">
									<div class="col-12">
										<div class="courses__details-area" style="padding: 40px 0;">
											<div class="container">
												<!-- Compact Header with Back Button -->
												<div class="row mb-4">
													<div class="col-12">
														<button type="button" class="btn btn-outline-primary" onclick="showTopicsGrid()" style="border-radius: 8px; padding: 8px 20px;">
															<i class="fas fa-arrow-left me-2"></i> Back to My Topics
														</button>
													</div>
												</div>
												
												<!-- Topic Details Section - Full Width -->
												<div class="row mb-4">
													<div class="col-12">
														<div class="topic-details-section">
															<div class="row align-items-start">
																<div class="col-md-4">
																	<img id="detail-topic-image" src="" alt="Topic Image" style="width: 100%; height: 300px; object-fit: cover; border-radius: 12px; box-shadow: 0 5px 15px rgba(0,0,0,0.1);">
																</div>
																<div class="col-md-8">
																	<h2 class="mb-3" id="detail-topic-title" style="color: #2c3e50; font-weight: 700; font-size: 28px;">Topic Details</h2>
																	<div class="d-flex flex-wrap gap-2 mb-4">
																		<span id="detail-topic-category" class="badge" style="background: #667eea; font-size: 14px; padding: 8px 16px;">Category</span>
																		<span id="detail-topic-subcategory" class="badge" style="background: #764ba2; font-size: 14px; padding: 8px 16px;">Subcategory</span>
																		<span id="detail-topic-sub-subcategory" class="badge" style="background: #4facfe; font-size: 14px; padding: 8px 16px;">Sub-subcategory</span>
																		<span id="detail-topic-sub-sub-subcategory" class="badge" style="background: #00f2fe; font-size: 14px; padding: 8px 16px;">Sub-sub-subcategory</span>
																	</div>
																	<div class="d-flex gap-4">
																		<div class="d-flex align-items-center">
																			<i class="flaticon-calendar me-2" style="color: #667eea; font-size: 18px;"></i>
																			<small style="color: #6c757d; font-size: 16px;"><strong>Purchased:</strong> <span id="detail-purchase-date">Date</span></small>
																		</div>
																		<div class="d-flex align-items-center">
																			<i class="flaticon-clock me-2" style="color: #667eea; font-size: 18px;"></i>
																			<small style="color: #6c757d; font-size: 16px;"><strong>Duration:</strong> <span id="detail-topic-duration">10 hours</span></small>
																		</div>
																	</div>
																</div>
															</div>
														</div>
													</div>
												</div>

												<!-- Student Details Section - Full Width Below Topic -->
												<div class="row mb-4">
													<div class="col-12">
														<!-- Student Details Section (for Teachers) -->
														<div id="student-details-section" class="mb-3" style="display: none;">
															<div class="student-info-card" style="background: linear-gradient(135deg, #f8f9ff 0%, #e8f2ff 100%); padding: 25px; border-radius: 12px; color: #2c3e50; box-shadow: 0 5px 20px rgba(0,0,0,0.05); border: 1px solid #e3f2fd;">
																<h5 class="mb-4" style="color: #2c3e50; font-weight: 600; text-align: center;">Student Information</h5>
																<div class="row align-items-center">
																	<div class="col-md-3 text-center">
																		<img id="student-avatar" src="<?= base_url('assets/theme/v2/skillgro/') ?>assets/img/courses/course_author001.png" alt="Student" style="width: 80px; height: 80px; border-radius: 50%; object-fit: cover; border: 3px solid #e3f2fd;">
																	</div>
																	<div class="col-md-9">
																		<div class="row">
																			<div class="col-md-6">
																				<h6 class="mb-2" id="student-name" style="color: #2c3e50; font-weight: 600; font-size: 18px;">John Doe</h6>
																				<div class="mb-2">
																					<i class="fas fa-calendar me-2" style="color: #667eea;"></i>
																					<small id="student-enrollment-date" style="color: #6c757d; font-size: 14px;">Enrolled: 15 Jan 2024</small>
																				</div>
																			</div>
																			<div class="col-md-6">
																				<div class="mb-2">
																					<i class="fas fa-envelope me-2" style="color: #667eea;"></i>
																					<small id="student-email" style="color: #2c3e50; font-size: 14px;">john.doe@email.com</small>
																				</div>
																				<div class="mb-0">
																					<i class="fas fa-phone me-2" style="color: #667eea;"></i>
																					<small id="student-phone" style="color: #2c3e50; font-size: 14px;">+1 234 567 8900</small>
																				</div>
																			</div>
																		</div>
																	</div>
																</div>
															</div>
														</div>
													</div>
												</div>
												
												<!-- Meeting Information Section - Full Width -->
												<div class="row mt-4">
													<div class="col-12">
														<div class="meeting-section">
															<h6 class="mb-3" style="color: #2c3e50; font-weight: 600;">Meeting Information</h6>
															
															<!-- Teacher View: Meeting Link Input -->
															<div id="teacher-meeting-section" style="display: none;">
																<div class="meeting-link-form" style="background: #f8f9fa; padding: 20px; border-radius: 12px; box-shadow: 0 3px 10px rgba(0,0,0,0.05);">
																	<div class="row">
																		<div class="col-md-4">
																			<div class="mb-3">
																				<label for="meeting-link" class="form-label fw-bold" style="font-size: 14px;">Meeting Link</label>
																				<input type="url" class="form-control" id="meeting-link" placeholder="https://meet.google.com/abc-defg-hij" style="border-radius: 8px; border: 1px solid #e9ecef; font-size: 14px;">
																			</div>
																		</div>
																		<div class="col-md-4">
																			<div class="mb-3">
																				<label for="meeting-time" class="form-label fw-bold" style="font-size: 14px;">Scheduled Time</label>
																				<input type="datetime-local" class="form-control" id="meeting-time" style="border-radius: 8px; border: 1px solid #e9ecef; font-size: 14px;">
																			</div>
																		</div>
																		<div class="col-md-4">
																			<div class="mb-3">
																				<label for="meeting-notes" class="form-label fw-bold" style="font-size: 14px;">Notes (Optional)</label>
																				<textarea class="form-control" id="meeting-notes" rows="2" placeholder="Any additional information..." style="border-radius: 8px; border: 1px solid #e9ecef; font-size: 14px;"></textarea>
																			</div>
																		</div>
																	</div>
																	<div class="text-center">
																		<button type="button" class="btn btn-primary" onclick="saveMeetingLink()" style="border-radius: 8px; padding: 10px 30px; font-size: 14px;">
																			<i class="fas fa-save me-2"></i> Save Meeting Details
																		</button>
																	</div>
																</div>
															</div>

															<!-- Student View: Meeting Link Display -->
															<div id="student-meeting-section" style="display: none;">
																<div class="meeting-info-card" style="background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%); padding: 20px; border-radius: 12px; color: white; box-shadow: 0 5px 20px rgba(0,0,0,0.1);">
																	<div class="row align-items-center">
																		<div class="col-md-3 text-center">
																			<span class="badge bg-success px-3 py-2" id="meeting-status" style="font-size: 12px; border-radius: 15px;">Scheduled</span>
																		</div>
																		<div class="col-md-3 text-center">
																			<a href="#" id="display-meeting-link" class="btn btn-light btn-sm" target="_blank" style="border-radius: 8px; padding: 8px 16px; font-size: 14px;">
																				<i class="fas fa-video me-2"></i> Join Meeting
																			</a>
																		</div>
																		<div class="col-md-3">
																			<div class="meeting-info-item mb-1" style="font-size: 12px;">
																				<i class="fas fa-clock me-2"></i>
																				<strong>Time:</strong> <span id="display-meeting-time">Not set</span>
																			</div>
																		</div>
																		<div class="col-md-3">
																			<div class="meeting-info-item mb-0" style="font-size: 12px;">
																				<i class="fas fa-sticky-note me-2"></i>
																				<strong>Notes:</strong> <span id="display-meeting-notes">No notes</span>
																			</div>
																		</div>
																	</div>
																</div>
															</div>

															<!-- No Meeting Set -->
															<div id="no-meeting-section" style="display: none;">
																<div class="no-meeting-card" style="background: linear-gradient(135deg, #ffeaa7 0%, #fab1a0 100%); padding: 20px; border-radius: 12px; text-align: center; box-shadow: 0 3px 10px rgba(0,0,0,0.05);">
																	<i class="fas fa-calendar-times text-warning mb-2" style="font-size: 32px;"></i>
																	<h6 class="mb-1" style="color: #856404;">No Meeting Scheduled</h6>
																	<small style="color: #856404;">Your teacher will provide meeting details soon.</small>
																</div>
															</div>
														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>

							<!-- Pagination -->
							<nav class="pagination__wrap mt-25" id="topics-pagination">
								<ul class="list-wrap">
									<li class="active"><a href="#">1</a></li>
									<li><a href="#">2</a></li>
									<li><a href="#">3</a></li>
									<li><a href="#">4</a></li>
								</ul>
							</nav>
						</div>
						<!-- Settings Tab Content -->
						<div class="profile-tab-content" id="settings-tab">
							<div class="dashboard__content-title">
								<h4 class="title">Settings</h4>
							</div>
							<div class="row">
								<div class="col-lg-12">
									<div class="dashboard__nav-wrap">
										<ul class="nav nav-tabs" id="myTab" role="tablist">
											<li class="nav-item" role="presentation">
												<button class="nav-link active" id="itemOne-tab" data-bs-toggle="tab" data-bs-target="#itemOne-tab-pane" type="button" role="tab" aria-controls="itemOne-tab-pane" aria-selected="true">Profile</button>
											</li>
											<li class="nav-item" role="presentation">
												<button class="nav-link" id="itemTwo-tab" data-bs-toggle="tab" data-bs-target="#itemTwo-tab-pane" type="button" role="tab" aria-controls="itemTwo-tab-pane" aria-selected="false">Password</button>
											</li>
											<li class="nav-item" role="presentation">
												<button class="nav-link" id="itemThree-tab" data-bs-toggle="tab" data-bs-target="#itemThree-tab-pane" type="button" role="tab" aria-controls="itemThree-tab-pane" aria-selected="false">
													<?= (isset($_SESSION['user_type']) && $_SESSION['user_type'] == 'teacher') ? 'Upload Video' : 'Social Share' ?>
												</button>
											</li>
										</ul>
									</div>
									<div class="tab-content" id="myTabContent">
										<!-- Profile Settings Tab -->
										<div class="tab-pane fade show active" id="itemOne-tab-pane" role="tabpanel" aria-labelledby="itemOne-tab" tabindex="0">
											<div class="instructor__cover-bg" data-background="<?= base_url('assets/theme/v2/skillgro/') ?>assets/img/bg/student_bg.jpg">
												<div class="instructor__cover-info">
													<div class="instructor__cover-info-left">
														<div class="thumb" style="position: relative; cursor: pointer;" onclick="document.getElementById('profile_photo').click()">
															<?php
															$user_photo = '';
															if (!empty($_SESSION['photo'])) {
																$user_photo = base_url('assets/avator/upload/' . $_SESSION['photo']);
															} else {
																$user_photo = base_url('assets/mem/' . $_SESSION['yid'] . '/img/profile.jpg');
															}
															?>
															<img id="profile-photo-preview" src="<?= $user_photo ?>" alt="img" onerror="this.src='<?= base_url('assets/theme/v2/skillgro/') ?>assets/img/courses/details_instructors02.jpg'" style="width: 100%; height: 100%; object-fit: cover; border-radius: 50%;">
															<input type="file" id="profile_photo" name="profile_photo" accept="image/*" style="display: none;" onchange="previewProfilePhotoOnly(this)">
														</div>
														<button title="Upload Photo" onclick="document.getElementById('profile_photo').click()" style="position: absolute; bottom: 0; right: 0; background: #007bff; border: none; border-radius: 50%; width: 40px; height: 40px; color: white; cursor: pointer; display: flex; align-items: center; justify-content: center;">
															<i class="fas fa-camera"></i>
														</button>
													</div>
													<div class="instructor__cover-info-right">
														<a href="#" class="btn btn-two arrow-btn">Edit Cover Photo</a>
													</div>
												</div>
											</div>
											<div class="instructor__profile-form-wrap">
												<form action="<?= base_url('action/update_profile') ?>" method="post" enctype="multipart/form-data" class="instructor__profile-form" id="profile-form" onsubmit="event.preventDefault(); return ajaxsubmitform('<?= base_url('action/update_profile') ?>',this,'error_div_profile','loder_div_profile','#','1','profile_update');">
													<!-- Hidden input for profile photo -->
													<input type="file" id="profile_photo_form" name="profile_photo" accept="image/*" style="display: none;">
													
													<div class="row">
														<div class="col-md-6">
															<div class="form-grp">
																<label for="firstname">First Name</label>
																<input id="firstname" name="firstname" type="text" value="<?= isset($profile_firstname) ? $profile_firstname : '' ?>">
															</div>
														</div>
														<div class="col-md-6">
															<div class="form-grp">
																<label for="lastname">Last Name</label>
																<input id="lastname" name="lastname" type="text" value="<?= isset($profile_lastname) ? $profile_lastname : '' ?>">
															</div>
														</div>
														<div class="col-md-6">
															<div class="form-grp">
																<label for="username">User Name</label>
																<input id="username" name="username" type="text" value="<?= isset($profile_username) ? $profile_username : '' ?>">
															</div>
														</div>
														<div class="col-md-6">
															<div class="form-grp">
																<label for="phonenumber">Phone Number</label>
																<input id="phonenumber" name="phone" type="tel" value="<?= isset($profile_phone) ? $profile_phone : '' ?>">
															</div>
														</div>
														<div class="col-md-6">
															<div class="form-grp">
																<label for="skill">Skill/Occupation</label>
																<input id="skill" name="skill" type="text" value="<?= isset($profile_skill) ? $profile_skill : '' ?>">
															</div>
														</div>
														<div class="col-md-6">
															<div class="form-grp select-grp">
																<label for="displayname">Display Name Publicly As</label>
																<select id="displayname" name="displayname">
																	<option value="<?= isset($profile_displayname) ? $profile_displayname : '' ?>"><?= isset($profile_displayname) ? $profile_displayname : 'Select Name' ?></option>
																	<option value="First Name Only">First Name Only</option>
																	<option value="Last Name Only">Last Name Only</option>
																	<option value="Username">Username</option>
																</select>
															</div>
														</div>
													</div>
													<div class="form-grp">
														<label for="bio">Bio</label>
														<textarea id="bio" name="bio" placeholder="Tell us about yourself..."><?= isset($profile_about) ? $profile_about : 'I\'m a passionate learner and always looking to expand my knowledge in various fields.' ?></textarea>
													</div>
													<div class="submit-btn mt-25">
														<button type="submit" class="btn">Update Info</button>
													</div>
													
													<!-- Error and Loader divs for ajaxsubmitform -->
													<div id="error_div_profile"></div>
													<div id="loder_div_profile" style="display: none;">
														<div class="text-center">
															<i class="fa fa-spinner fa-spin"></i> Updating profile...
														</div>
													</div>
												</form>
											</div>
										</div>

										<!-- Password Settings Tab -->
										<div class="tab-pane fade" id="itemTwo-tab-pane" role="tabpanel" aria-labelledby="itemTwo-tab" tabindex="0">
											<div class="instructor__profile-form-wrap">
												<form action="<?= base_url('action/password_change') ?>" method="post" class="instructor__profile-form" id="password-form" onsubmit="event.preventDefault(); return ajaxsubmitform('<?= base_url('action/password_change') ?>',this,'error_div','loder_div','#','1','success');">
													<div class="form-grp">
														<label for="currentpassword">Current Password</label>
														<input id="currentpassword" name="pass" type="password" placeholder="Current Password" required>
													</div>
													<div class="form-grp">
														<label for="newpassword">New Password</label>
														<input id="newpassword" name="pass1" type="password" placeholder="New Password" required>
													</div>
													<div class="form-grp">
														<label for="repassword">Re-Type New Password</label>
														<input id="repassword" name="pass2" type="password" placeholder="Re-Type New Password" required>
													</div>
													<div class="submit-btn mt-25">
														<button type="submit" class="btn">Update Password</button>
													</div>
													
													<!-- Error and Loader divs for ajaxsubmitform -->
													<div id="error_div"></div>
													<div id="loder_div" style="display: none;">
														<div class="text-center">
															<i class="fa fa-spinner fa-spin"></i> Updating password...
														</div>
													</div>
												</form>
											</div>
										</div>

										<!-- Upload Video Tab (Teachers Only) -->
										<?php if(isset($_SESSION['user_type']) && $_SESSION['user_type'] == 'teacher'): ?>
										<div class="tab-pane fade" id="itemThree-tab-pane" role="tabpanel" aria-labelledby="itemThree-tab" tabindex="0">
											<div class="instructor__profile-form-wrap">
												<form action="<?= base_url('action/update_teacher_profile') ?>" method="post" enctype="multipart/form-data" class="instructor__profile-form" id="teacher-profile-form" onsubmit="event.preventDefault(); return ajaxsubmitform('<?= base_url('action/update_teacher_profile') ?>',this,'error_div_teacher','loder_div_teacher','#','1','teacher_profile');">
													<!-- Video Upload Section -->
													<div class="form-grp">
														<label for="intro_video">Introduction Video <small class="text-muted">(1-2 minutes, MP4 format)</small></label>
														<div class="video-upload-area" style="border: 2px dashed #ddd; padding: 20px; text-align: center; border-radius: 8px;">
															<input type="file" id="intro_video" name="intro_video" accept="video/mp4" style="display: none;">
															
															<!-- Current Video Preview (if exists) -->
															<?php if(!empty($_SESSION['teacher_intro_video'])): ?>
																<div id="current-video-preview">
																	<video width="300" height="200" controls style="border-radius: 8px; margin-bottom: 10px;">
																		<source src="<?= base_url('assets/teacher_videos/' . $_SESSION['teacher_intro_video']) ?>" type="video/mp4">
																		Your browser does not support the video tag.
																	</video>
																	<p class="text-success mb-2">
																		<i class="fas fa-check-circle"></i> Current video: <?= $_SESSION['teacher_intro_video'] ?>
																	</p>
																	<button type="button" class="btn btn-outline-secondary btn-sm" onclick="changeVideo()">Change Video</button>
																</div>
															<?php endif; ?>
															
															<!-- New Video Preview (when uploading) -->
															<div id="video-preview" style="display: none;">
																<video width="300" height="200" controls style="border-radius: 8px;">
																	<source id="video-source" src="" type="video/mp4">
																	Your browser does not support the video tag.
																</video>
																<p id="video-name" class="mt-2"></p>
																<button type="button" class="btn btn-outline-secondary btn-sm" onclick="cancelVideoUpload()">Cancel</button>
															</div>
															
															<!-- Upload Placeholder (when no video exists) -->
															<div id="video-upload-placeholder" style="<?= !empty($_SESSION['teacher_intro_video']) ? 'display: none;' : '' ?>">
																<i class="fas fa-video" style="font-size: 48px; color: #ddd; margin-bottom: 10px;"></i>
																<p>Click to upload your introduction video</p>
																<button type="button" class="btn btn-outline-primary" onclick="document.getElementById('intro_video').click()">Choose Video</button>
															</div>
														</div>
													</div>

													<!-- Bio Section -->
													<div class="form-grp">
														<label for="teacher_bio">Bio</label>
														<textarea id="teacher_bio" name="teacher_bio" placeholder="Tell us about yourself, your teaching philosophy, and what makes you unique..."><?= isset($profile_about) ? $profile_about : '' ?></textarea>
													</div>

													<!-- Address Section -->
													<div class="form-grp">
														<label for="teacher_address">Address</label>
														<textarea id="teacher_address" name="teacher_address" placeholder="Your complete address..."><?= isset($_SESSION['address']) ? $_SESSION['address'] : '' ?></textarea>
													</div>

													<!-- Experience Section -->
													<div class="form-grp">
														<label for="teacher_experience">Teaching Experience</label>
														<textarea id="teacher_experience" name="teacher_experience" placeholder="Describe your teaching experience, subjects you teach, years of experience, notable achievements..."><?= isset($_SESSION['teacher_experience']) ? $_SESSION['teacher_experience'] : '' ?></textarea>
													</div>

													<!-- Education Section -->
													<div class="form-grp">
														<label for="teacher_education">Education & Qualifications</label>
														<textarea id="teacher_education" name="teacher_education" placeholder="Your educational background, degrees, certifications, specializations..."><?= isset($_SESSION['teacher_education']) ? $_SESSION['teacher_education'] : '' ?></textarea>
													</div>

													<div class="submit-btn mt-25">
														<button type="submit" class="btn">Update Teacher Profile</button>
													</div>
													
													<!-- Error and Loader divs for ajaxsubmitform -->
													<div id="error_div_teacher"></div>
													<div id="loder_div_teacher" style="display: none;">
														<div class="text-center">
															<i class="fa fa-spinner fa-spin"></i> Updating teacher profile...
														</div>
													</div>
												</form>
											</div>
										</div>
										<?php else: ?>
										<!-- Social Settings Tab (Students) -->
										<div class="tab-pane fade" id="itemThree-tab-pane" role="tabpanel" aria-labelledby="itemThree-tab" tabindex="0">
											<div class="instructor__profile-form-wrap">
												<form action="#" class="instructor__profile-form">
													<div class="form-grp">
														<label for="facebook">Facebook</label>
														<input id="facebook" type="url" placeholder="https://facebook.com/">
													</div>
													<div class="form-grp">
														<label for="twitter">Twitter</label>
														<input id="twitter" type="url" placeholder="https://twitter.com/">
													</div>
													<div class="form-grp">
														<label for="linkedin">Linkedin</label>
														<input id="linkedin" type="url" placeholder="https://linkedin.com/">
													</div>
													<div class="form-grp">
														<label for="website">Website</label>
														<input id="website" type="url" placeholder="https://website.com/">
													</div>
													<div class="form-grp">
														<label for="github">Github</label>
														<input id="github" type="url" placeholder="https://github.com/">
													</div>
													<div class="submit-btn mt-25">
														<button type="submit" class="btn">Update Social Links</button>
													</div>
												</form>
											</div>
										</div>
										<?php endif; ?>
									</div>
								</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
<!-- dashboard-area-end -->

</main>
<!-- main-area-end -->

<style>
	.profile-tab-content {
		display: none;
	}

	.profile-tab-content.active {
		display: block;
	}

	.profile-tab-link.active {
		background-color: #f8f9fa;
		color: #007bff;
	}
</style>

<script>
	document.addEventListener('DOMContentLoaded', function() {
		// Profile tab functionality
		const profileTabLinks = document.querySelectorAll('.profile-tab-link');
		const profileTabContents = document.querySelectorAll('.profile-tab-content');

		profileTabLinks.forEach(link => {
			link.addEventListener('click', function(e) {
				e.preventDefault();

				// Remove active class from all links
				profileTabLinks.forEach(l => l.classList.remove('active'));
				// Add active class to clicked link
				this.classList.add('active');

				// Hide all tab contents
				profileTabContents.forEach(content => content.classList.remove('active'));

				// Show selected tab content
				const targetTab = this.getAttribute('data-tab');
				const targetContent = document.getElementById(targetTab + '-tab');
				if (targetContent) {
					targetContent.classList.add('active');
				}
			});
		});

		// Initialize Bootstrap tabs for settings sub-tabs
		const settingsTabTriggerList = [].slice.call(document.querySelectorAll('#myTab button[data-bs-toggle="tab"]'));
		settingsTabTriggerList.map(function(tabTriggerEl) {
			return new bootstrap.Tab(tabTriggerEl);
		});

		// Initialize Bootstrap tabs for topics sub-tabs
		const topicsTabTriggerList = [].slice.call(document.querySelectorAll('#courseTab button[data-bs-toggle="tab"]'));
		topicsTabTriggerList.map(function(tabTriggerEl) {
			return new bootstrap.Tab(tabTriggerEl);
		});

		// Video upload preview functionality
		const videoInput = document.getElementById('intro_video');
		if (videoInput) {
			videoInput.addEventListener('change', function(e) {
				const file = e.target.files[0];
				if (file) {
					// Validate file type
					if (file.type !== 'video/mp4') {
						alert('Please select an MP4 video file.');
						return;
					}
					
					// Validate file size (max 50MB)
					if (file.size > 50 * 1024 * 1024) {
						alert('Video file size should be less than 50MB.');
						return;
					}
					
					// Hide current video preview and upload placeholder
					const currentVideoPreview = document.getElementById('current-video-preview');
					const videoUploadPlaceholder = document.getElementById('video-upload-placeholder');
					const videoPreview = document.getElementById('video-preview');
					const videoSource = document.getElementById('video-source');
					const videoName = document.getElementById('video-name');
					
					if (currentVideoPreview) currentVideoPreview.style.display = 'none';
					videoUploadPlaceholder.style.display = 'none';
					videoPreview.style.display = 'block';
					
					const videoURL = URL.createObjectURL(file);
					videoSource.src = videoURL;
					videoName.textContent = file.name;
					
					// Load the video
					videoSource.load();
				}
			});
		}

		// Function to change video (show file input)
		window.changeVideo = function() {
			document.getElementById('intro_video').click();
		}

		// Function to cancel video upload
		window.cancelVideoUpload = function() {
			const videoInput = document.getElementById('intro_video');
			const currentVideoPreview = document.getElementById('current-video-preview');
			const videoUploadPlaceholder = document.getElementById('video-upload-placeholder');
			const videoPreview = document.getElementById('video-preview');
			
			// Clear file input
			videoInput.value = '';
			
			// Show appropriate section
			if (currentVideoPreview) {
				currentVideoPreview.style.display = 'block';
			} else {
				videoUploadPlaceholder.style.display = 'block';
			}
			videoPreview.style.display = 'none';
		}

		// Profile photo preview only (no upload)
		window.previewProfilePhotoOnly = function(input) {
			if (input.files && input.files[0]) {
				const file = input.files[0];
				
				// Validate file type
				if (!file.type.startsWith('image/')) {
					alert('Please select an image file.');
					input.value = '';
					return;
				}
				
				// Validate file size (max 5MB)
				if (file.size > 5 * 1024 * 1024) {
					alert('Image file size should be less than 5MB.');
					input.value = '';
					return;
				}
				
				const reader = new FileReader();
				reader.onload = function(e) {
					// Update preview image
					document.getElementById('profile-photo-preview').src = e.target.result;
					
					// Copy file to form input for submission
					const formInput = document.getElementById('profile_photo_form');
					formInput.files = input.files;
				};
				reader.readAsDataURL(file);
			}
		}



		// Function to show notifications (keeping for profile updates)
		window.showNotification = function(message, type) {
			// Create notification element
			const notification = document.createElement('div');
			notification.style.cssText = `
				position: fixed;
				top: 20px;
				right: 20px;
				padding: 15px 20px;
				border-radius: 5px;
				color: white;
				font-weight: bold;
				z-index: 9999;
				opacity: 0;
				transition: opacity 0.3s ease;
				background-color: ${type === 'success' ? '#28a745' : '#dc3545'};
			`;
			notification.textContent = message;
			
			document.body.appendChild(notification);
			
			// Fade in
			setTimeout(() => notification.style.opacity = '1', 100);
			
			// Fade out and remove
			setTimeout(() => {
				notification.style.opacity = '0';
				setTimeout(() => document.body.removeChild(notification), 300);
			}, 3000);
		}

		// Topic Detail Functionality - Initialize after DOM is ready
		function initializeTopicDetailFunctionality() {
			const topicCards = document.querySelectorAll('.topic-card');
			const topicLinks = document.querySelectorAll('.topic-link');
			
			console.log('Found topic cards:', topicCards.length);
			console.log('Found topic links:', topicLinks.length);
			
			// Handle topic card clicks
			topicCards.forEach((card, index) => {
				console.log('Adding click listener to card', index);
				card.addEventListener('click', function(e) {
					e.preventDefault();
					e.stopPropagation();
					console.log('Card clicked:', index);
					showTopicDetail(this);
				});
			});
			
			// Handle topic link clicks
			topicLinks.forEach((link, index) => {
				console.log('Adding click listener to link', index);
				link.addEventListener('click', function(e) {
					e.preventDefault();
					e.stopPropagation();
					console.log('Link clicked:', index);
					const card = this.closest('.topic-card');
					if (card) {
						showTopicDetail(card);
					}
				});
			});
		}
		
		// Test function - can be called from browser console
		window.testTopicDetail = function() {
			console.log('Testing topic detail functionality');
			const firstCard = document.querySelector('.topic-card');
			if (firstCard) {
				console.log('Found first card, calling showTopicDetail');
				showTopicDetail(firstCard);
			} else {
				console.error('No topic cards found');
			}
		};
		
		// Initialize topic detail functionality after a short delay to ensure DOM is ready
		setTimeout(function() {
			initializeTopicDetailFunctionality();
		}, 100);


		// Function to show topics grid
		window.showTopicsGrid = function() {
			// Hide detail section and show topics grid with pagination
			document.getElementById('topic-detail-section').style.display = 'none';
			document.getElementById('topics-grid').style.display = 'block';
			document.getElementById('topics-pagination').style.display = 'block';
			
			// Scroll to top of topics section
			document.getElementById('topics-grid').scrollIntoView({ behavior: 'smooth' });
		}

		// Function to save meeting link (for teachers)
		window.saveMeetingLink = function() {
			const meetingLink = document.getElementById('meeting-link').value;
			const meetingTime = document.getElementById('meeting-time').value;
			const meetingNotes = document.getElementById('meeting-notes').value;
			
			if (!meetingLink) {
				alert('Please enter a meeting link.');
				return;
			}

			// Get current topic data from the detail section
			const currentTopicCard = document.querySelector('.topic-card[data-topic-id]');
			if (!currentTopicCard) {
				alert('No topic selected.');
				return;
			}

			const orderId = currentTopicCard.getAttribute('data-order-id');
			const topicId = currentTopicCard.getAttribute('data-topic-id');
			
			// Prepare form data
			const formData = new FormData();
			formData.append('order_id', orderId);
			formData.append('topic_id', topicId);
			formData.append('meeting_link', meetingLink);
			formData.append('meeting_time', meetingTime);
			formData.append('meeting_notes', meetingNotes);
			
			// Save to database via AJAX
			fetch('<?= base_url('save-meeting-details') ?>', {
				method: 'POST',
				body: formData
			})
			.then(response => response.json())
			.then(data => {
				if (data.status === 'success') {
					// Update the display
					document.getElementById('display-meeting-link').href = meetingLink;
					document.getElementById('display-meeting-time').textContent = meetingTime ? new Date(meetingTime).toLocaleString() : 'Not set';
					document.getElementById('display-meeting-notes').textContent = meetingNotes || 'No additional notes';
					
					// Show success notification
					showNotification('Meeting details saved successfully!', 'success');
				} else {
					showNotification('Failed to save meeting details: ' + data.message, 'danger');
				}
			})
			.catch(error => {
				console.error('Error saving meeting details:', error);
				showNotification('Failed to save meeting details. Please try again.', 'danger');
			});
		}

		// Function removed - no start learning button needed

		// Load topics when My Topics tab is clicked
		const topicsTab = document.querySelector('[data-tab="topics"]');
		if (topicsTab) {
			topicsTab.addEventListener('click', function() {
				renderTopicsFromPHP();
			});

			// Load topics on page load if My Topics tab is active
			if (topicsTab.classList.contains('active')) {
				renderTopicsFromPHP();
			}
		}
	});

	// Function to render topics from PHP data
	function renderTopicsFromPHP() {
		const topicsGrid = document.getElementById('topics-grid');
		const loadingDiv = document.getElementById('loading-topics');
		
		// Hide loading state
		if (loadingDiv) {
			loadingDiv.style.display = 'none';
		}
		
		// Get topics data from PHP
		const topics = <?= json_encode($user_topics ?? []) ?>;
		const userType = '<?= $user_type ?? 'user' ?>';


		if (topics && topics.length > 0) {
			renderTopics(topics, userType);
		} else {
			showError('No topics found');
		}
	}

	// Function to render topics in the grid
	function renderTopics(topics, userType) {
		const topicsGrid = document.getElementById('topics-grid');
		
		if (!topicsGrid) {
			console.error('topics-grid element not found');
			return;
		}
		
		if (topics.length === 0) {
			topicsGrid.innerHTML = `
				<div class="col-12 text-center">
					<div class="alert alert-info">
						<i class="fas fa-info-circle me-2"></i>
						No topics found. ${userType === 'teacher' ? 'No students have purchased topics assigned to you yet.' : 'You haven\'t purchased any topics yet.'}
					</div>
				</div>
			`;
			return;
		}

		let topicsHTML = '';
		topics.forEach((topic, index) => {
			const topicImage = topic.product_image ? '<?= base_url('assets/avator/upload/') ?>' + topic.product_image : (topic.topic_image || '<?= base_url('assets/theme/v2/skillgro/') ?>assets/img/courses/course_thumb01.jpg');
			const purchaseDate = topic.purchase_date ? new Date(topic.purchase_date).toLocaleDateString('en-US', { 
				year: 'numeric', 
				month: 'short', 
				day: 'numeric' 
			}) : 'N/A';
			
			// Determine what to show in the author section based on user type
			let authorSection = '';
			if (userType === 'teacher') {
				// For teachers, show student info
				const studentImage = topic.student_image ? '<?= base_url('assets/avator/upload/') ?>' + topic.student_image : '<?= base_url('assets/theme/v2/skillgro/') ?>assets/img/courses/course_author001.png';
				authorSection = `
					<div class="author-two">
						<a href="#"><img src="${studentImage}" alt="img">${topic.student_name || 'Student'}</a>
					</div>
				`;
			} else {
				// For students, show teacher info
				const teacherImage = topic.teacher_image ? '<?= base_url('assets/avator/upload/') ?>' + topic.teacher_image : '<?= base_url('assets/theme/v2/skillgro/') ?>assets/img/courses/course_author001.png';
				authorSection = `
					<div class="author-two">
						<a href="#"><img src="${teacherImage}" alt="img">${topic.teacher_name || 'Teacher'}</a>
					</div>
				`;
			}

			topicsHTML += `
				<div class="col-lg-4 col-md-6">
					<div class="courses__item courses__item-two shine__animate-item topic-card" 
						 data-topic-id="${topic.topic_id}" 
						 data-topic-name="${topic.topic_name}" 
						 data-topic-price="${topic.topic_price}" 
						 data-topic-category="${topic.category_name || 'Category'}"
						 data-topic-subcategory="${topic.subcategory_name || 'Subcategory'}"
						 data-topic-sub-subcategory="${topic.sub_subcategory_name || 'Sub-subcategory'}"
						 data-topic-sub-sub-subcategory="${topic.sub_sub_subcategory_name || 'Sub-sub-subcategory'}"
						 data-topic-duration="${topic.topic_duration || 'N/A'}"
						 data-purchase-date="${purchaseDate}"
						 data-order-id="${topic.order_id}"
						 data-student-name="${topic.student_name || ''}"
						 data-student-email="${topic.student_email || ''}"
						 data-student-phone="${topic.student_phone || ''}"
						 data-teacher-name="${topic.teacher_name || ''}"
						 data-teacher-email="${topic.teacher_email || ''}"
						 data-teacher-phone="${topic.teacher_phone || ''}"
						 data-teacher-bio="${topic.teacher_bio || ''}"
						 data-teacher-image="${topic.teacher_image || ''}"
						 data-meeting-link="${topic.meeting_link || ''}"
						 data-meeting-time="${topic.meeting_time || ''}"
						 data-meeting-notes="${topic.meeting_notes || ''}">
						<div class="courses__item-thumb courses__item-thumb-two">
							<a href="#" class="shine__animate-link topic-link">
								<img src="${topicImage}" alt="img">
							</a>
						</div>
						<div class="courses__item-content courses__item-content-two">
							<ul class="courses__item-meta list-wrap">
								<li class="courses__item-tag">
									<a href="#">${topic.subcategory_name || 'Subcategory'}</a>
								</li>
								<li class="price">$${topic.topic_price}</li>
							</ul>
							<h5 class="title"><a href="#" class="topic-link">${topic.topic_name.split(' ').slice(0, 4).join(' ')}${topic.topic_name.split(' ').length > 5 ? '...' : ''}</a></h5>
							<div class="courses__item-content-bottom">
								${authorSection}
								<div class="avg-rating">
									<i class="fas fa-star"></i> (${topic.rating || '4.5'} ${topic.reviews_count ? topic.reviews_count + ' Reviews' : 'Reviews'})
								</div>
							</div>
						</div>
						<div class="courses__item-bottom-two">
							<ul class="list-wrap" style="font-size: 12px;">
								<li><i class="flaticon-book"></i>${topic.topic_lessons || '0'}</li>
								<li><i class="flaticon-clock"></i>${topic.topic_duration || 'N/A'}</li>
								<li><i class="flaticon-level"></i>${topic.topic_level || 'Beginner'}</li>
							</ul>
						</div>
					</div>
				</div>
			`;
		});

		topicsGrid.innerHTML = topicsHTML;
		
		// Re-initialize topic detail functionality
		initializeTopicDetailFunctionality();
	}

	// Function to show error messages
	function showError(message) {
		const topicsGrid = document.getElementById('topics-grid');
		if (!topicsGrid) {
			console.error('topics-grid element not found for error display');
			return;
		}
		topicsGrid.innerHTML = `
			<div class="col-12 text-center">
				<div class="alert alert-danger">
					<i class="fas fa-exclamation-triangle me-2"></i>
					${message}
				</div>
			</div>
		`;
	}

	// Function to show success notification
	function showNotification(message, type = 'success') {
		// Create notification element
		const notification = document.createElement('div');
		notification.className = `alert alert-${type} alert-dismissible fade show position-fixed`;
		notification.style.cssText = 'top: 20px; right: 20px; z-index: 9999; min-width: 300px;';
		notification.innerHTML = `
			${message}
			<button type="button" class="btn-close" data-bs-dismiss="alert"></button>
		`;
		
		document.body.appendChild(notification);
		
		// Auto remove after 5 seconds
		setTimeout(() => {
			if (notification.parentNode) {
				notification.parentNode.removeChild(notification);
			}
		}, 5000);
	}

	// Function to initialize topic detail functionality
	function initializeTopicDetailFunctionality() {
		const topicCards = document.querySelectorAll('.topic-card');
		const topicLinks = document.querySelectorAll('.topic-link');
		
		console.log('Found topic cards:', topicCards.length);
		console.log('Found topic links:', topicLinks.length);
		
		// Add click event listeners to topic cards
		topicCards.forEach(card => {
			card.addEventListener('click', function(e) {
				e.preventDefault();
				e.stopPropagation();
				
				const topicId = this.getAttribute('data-topic-id');
				const topicName = this.getAttribute('data-topic-name');
				const topicPrice = this.getAttribute('data-topic-price');
				const topicCategory = this.getAttribute('data-topic-category');
				const topicSubcategory = this.getAttribute('data-topic-subcategory');
				const topicSubSubcategory = this.getAttribute('data-topic-sub-subcategory');
				const topicSubSubSubcategory = this.getAttribute('data-topic-sub-sub-subcategory');
				const topicDuration = this.getAttribute('data-topic-duration');
				const purchaseDate = this.getAttribute('data-purchase-date');
				const orderId = this.getAttribute('data-order-id');
				const studentName = this.getAttribute('data-student-name');
				const studentEmail = this.getAttribute('data-student-email');
				const studentPhone = this.getAttribute('data-student-phone');
				const teacherName = this.getAttribute('data-teacher-name');
				const teacherEmail = this.getAttribute('data-teacher-email');
				const teacherPhone = this.getAttribute('data-teacher-phone');
				const teacherBio = this.getAttribute('data-teacher-bio');
				const teacherImage = this.getAttribute('data-teacher-image');
				const meetingLink = this.getAttribute('data-meeting-link');
				const meetingTime = this.getAttribute('data-meeting-time');
				const meetingNotes = this.getAttribute('data-meeting-notes');
				
				showTopicDetail({
					topicId, 
					topicName, 
					topicPrice, 
					topicCategory, 
					topicSubcategory, 
					topicSubSubcategory, 
					topicSubSubSubcategory, 
					topicDuration, 
					purchaseDate, 
					orderId, 
					studentName, 
					studentEmail, 
					studentPhone,
					teacherName, 
					teacherEmail, 
					teacherPhone, 
					teacherBio, 
					teacherImage,
					meetingLink, 
					meetingTime, 
					meetingNotes
				});
			});
		});
		
		// Add click event listeners to topic links
		topicLinks.forEach(link => {
			link.addEventListener('click', function(e) {
				e.preventDefault();
				e.stopPropagation();
				
				const card = this.closest('.topic-card');
				if (card) {
					card.click();
				}
			});
		});
	}

	// Function to show topic detail section
	function showTopicDetail(topic) {
		const detailSection = document.getElementById('topic-detail-section');
		const topicsGrid = document.getElementById('topics-grid');
		const topicsTab = document.getElementById('topics-tab');
		
		if (!detailSection || !topicsGrid || !topicsTab) {
			console.error('Required elements not found for topic detail');
			return;
		}
		
		// Hide topics grid and show detail section
		topicsGrid.style.display = 'none';
		detailSection.style.display = 'block';
		
		// Get user type
		const userType = '<?= $user_type ?? 'user' ?>';
		
		// Update detail section content
		const detailContent = document.getElementById('topic-detail-content');
		if (detailContent) {
			const topicImage = topic.product_image ? '<?= base_url('assets/avator/upload/') ?>' + topic.product_image : '<?= base_url('assets/theme/v2/skillgro/') ?>assets/img/courses/course_thumb01.jpg';
			
			detailContent.innerHTML = `
				<div class="row">
					<div class="col-lg-8">
						<div class="courses__item-thumb mb-4">
							<img src="${topicImage}" alt="${topicName}" class="img-fluid rounded">
						</div>
						<div class="courses__content">
							<h3 class="courses__title">${topicName}</h3>
							<div class="courses__meta mb-3">
								<span class="badge bg-primary me-2">${topicCategory}</span>
								<span class="badge bg-secondary me-2">${topicSubcategory}</span>
								${topicSubSubcategory ? `<span class="badge bg-info me-2">${topicSubSubcategory}</span>` : ''}
								${topicSubSubSubcategory ? `<span class="badge bg-warning me-2">${topicSubSubSubcategory}</span>` : ''}
							</div>
							<div class="row mb-3">
								<div class="col-md-3">
									<strong>Duration:</strong> ${topicDuration || 'N/A'}
								</div>
								<div class="col-md-3">
									<strong>Price:</strong> $${topicPrice}
								</div>
								<div class="col-md-3">
									<strong>Order ID:</strong> ${orderId}
								</div>
								<div class="col-md-3">
									<strong>Purchase Date:</strong> ${purchaseDate}
								</div>
							</div>
						</div>
					</div>
					<div class="col-lg-4">
						<div class="card">
							<div class="card-header">
								<h5>${userType === 'teacher' ? 'Student Details' : 'Teacher Details'}</h5>
							</div>
							<div class="card-body">
								${userType === 'teacher' ? `
									<div class="d-flex align-items-center mb-3">
										<img src="<?= base_url('assets/theme/v2/skillgro/') ?>assets/img/courses/course_author001.png" 
											 alt="Student" class="rounded-circle me-3" width="50" height="50">
										<div>
											<h6 class="mb-0">${studentName || 'Student'}</h6>
											<small class="text-muted">Student</small>
										</div>
									</div>
									<p><strong>Email:</strong> ${studentEmail || 'N/A'}</p>
									<p><strong>Phone:</strong> ${studentPhone || 'N/A'}</p>
								` : `
									<div class="d-flex align-items-center mb-3">
										<img src="${teacherImage ? '<?= base_url('assets/avator/upload/') ?>' + teacherImage : '<?= base_url('assets/theme/v2/skillgro/') ?>assets/img/courses/course_author001.png'}" 
											 alt="Teacher" class="rounded-circle me-3" width="50" height="50">
										<div>
											<h6 class="mb-0">${teacherName || 'Teacher'}</h6>
											<small class="text-muted">Teacher</small>
										</div>
									</div>
									<p><strong>Email:</strong> ${teacherEmail || 'N/A'}</p>
									<p><strong>Phone:</strong> ${teacherPhone || 'N/A'}</p>
									${teacherBio ? `<p><strong>Bio:</strong> ${teacherBio}</p>` : ''}
								`}
							</div>
						</div>
						
						<div class="card mt-3">
							<div class="card-header">
								<h5>Meeting Information</h5>
							</div>
							<div class="card-body">
								${userType === 'teacher' ? `
									<form id="meeting-form">
										<div class="mb-3">
											<label for="meeting-link" class="form-label">Meeting Link</label>
											<input type="url" class="form-control" id="meeting-link" 
												   value="${meetingLink || ''}" placeholder="https://meet.google.com/...">
										</div>
										<div class="mb-3">
											<label for="meeting-time" class="form-label">Meeting Time</label>
											<input type="datetime-local" class="form-control" id="meeting-time" 
												   value="${meetingTime || ''}">
										</div>
										<div class="mb-3">
											<label for="meeting-notes" class="form-label">Notes</label>
											<textarea class="form-control" id="meeting-notes" rows="3" 
													  placeholder="Additional notes...">${meetingNotes || ''}</textarea>
										</div>
										<button type="submit" class="btn btn-primary">Save Meeting Details</button>
									</form>
								` : `
									${meetingLink ? `
										<p><strong>Meeting Link:</strong> 
											<a href="${meetingLink}" target="_blank" class="btn btn-sm btn-outline-primary">Join Meeting</a>
										</p>
									` : '<p class="text-muted">No meeting link provided yet.</p>'}
									${meetingTime ? `<p><strong>Meeting Time:</strong> ${meetingTime}</p>` : ''}
									${meetingNotes ? `<p><strong>Notes:</strong> ${meetingNotes}</p>` : ''}
								`}
							</div>
						</div>
					</div>
				</div>
			`;
		}
		
		// Add back button functionality
		const backButton = document.getElementById('back-to-topics');
		if (backButton) {
			backButton.onclick = function() {
				detailSection.style.display = 'none';
				topicsGrid.style.display = 'block';
			};
		}
		
		// Add meeting form submission for teachers
		if (userType === 'teacher') {
			const meetingForm = document.getElementById('meeting-form');
			if (meetingForm) {
				meetingForm.addEventListener('submit', function(e) {
					e.preventDefault();
					saveMeetingDetails(topicId, orderId);
				});
			}
		}
	}

	// Function to save meeting details
	function saveMeetingDetails(topicId, orderId) {
									<strong>Duration:</strong> ${topicDuration || 'N/A'}
								</div>
								<div class="col-md-3">
									<strong>Price:</strong> $${topicPrice}
								</div>
								<div class="col-md-3">
									<strong>Order ID:</strong> ${orderId}
								</div>
								<div class="col-md-3">
									<strong>Purchase Date:</strong> ${purchaseDate}
								</div>
							</div>
						</div>
					</div>
					<div class="col-lg-4">
						<div class="card">
							<div class="card-header">
								<h5>${userType === 'teacher' ? 'Student Details' : 'Teacher Details'}</h5>
							</div>
							<div class="card-body">
								${userType === 'teacher' ? `
									<div class="d-flex align-items-center mb-3">
										<img src="<?= base_url('assets/theme/v2/skillgro/') ?>assets/img/courses/course_author001.png" 
											 alt="Student" class="rounded-circle me-3" width="50" height="50">
										<div>
											<h6 class="mb-0">${studentName || 'Student'}</h6>
											<small class="text-muted">Student</small>
										</div>
									</div>
									<p><strong>Email:</strong> ${studentEmail || 'N/A'}</p>
									<p><strong>Phone:</strong> ${studentPhone || 'N/A'}</p>
								` : `
									<div class="d-flex align-items-center mb-3">
										<img src="${teacherImage ? '<?= base_url('assets/avator/upload/') ?>' + teacherImage : '<?= base_url('assets/theme/v2/skillgro/') ?>assets/img/courses/course_author001.png'}" 
											 alt="Teacher" class="rounded-circle me-3" width="50" height="50">
										<div>
											<h6 class="mb-0">${teacherName || 'Teacher'}</h6>
											<small class="text-muted">Teacher</small>
										</div>
									</div>
									<p><strong>Email:</strong> ${teacherEmail || 'N/A'}</p>
									<p><strong>Phone:</strong> ${teacherPhone || 'N/A'}</p>
									${teacherBio ? `<p><strong>Bio:</strong> ${teacherBio}</p>` : ''}
								`}
							</div>
						</div>
						
						<div class="card mt-3">
							<div class="card-header">
								<h5>Meeting Information</h5>
							</div>
							<div class="card-body">
								${userType === 'teacher' ? `
									<form id="meeting-form">
										<div class="mb-3">
											<label for="meeting-link" class="form-label">Meeting Link</label>
											<input type="url" class="form-control" id="meeting-link" 
												   value="${meetingLink || ''}" placeholder="https://meet.google.com/...">
										</div>
										<div class="mb-3">
											<label for="meeting-time" class="form-label">Meeting Time</label>
											<input type="datetime-local" class="form-control" id="meeting-time" 
												   value="${meetingTime || ''}">
										</div>
										<div class="mb-3">
											<label for="meeting-notes" class="form-label">Notes</label>
											<textarea class="form-control" id="meeting-notes" rows="3" 
													  placeholder="Additional notes...">${meetingNotes || ''}</textarea>
										</div>
										<button type="submit" class="btn btn-primary">Save Meeting Details</button>
									</form>
								` : `
									${topic.meetingLink ? `
										<p><strong>Meeting Link:</strong> 
											<a href="${meetingLink}" target="_blank" class="btn btn-sm btn-outline-primary">Join Meeting</a>
										</p>
									` : '<p class="text-muted">No meeting link provided yet.</p>'}
									${topic.meetingTime ? `<p><strong>Meeting Time:</strong> ${meetingTime}</p>` : ''}
									${topic.meetingNotes ? `<p><strong>Notes:</strong> ${meetingNotes}</p>` : ''}
								`}
							</div>
						</div>
					</div>
				</div>
			`;
		}
		
		// Add back button functionality
		const backButton = document.getElementById('back-to-topics');
		if (backButton) {
			backButton.onclick = function() {
				detailSection.style.display = 'none';
				topicsGrid.style.display = 'block';
			};
		}
		
		// Add meeting form submission for teachers
		if (userType === 'teacher') {
			const meetingForm = document.getElementById('meeting-form');
			if (meetingForm) {
				meetingForm.addEventListener('submit', function(e) {
					e.preventDefault();
					saveMeetingDetails(topicId, orderId);
				});
			}
		}
	}

	// Function to save meeting details
	function saveMeetingDetails(topicId, orderId) {
		const meetingLink = document.getElementById('meeting-link').value;
		const meetingTime = document.getElementById('meeting-time').value;
		const meetingNotes = document.getElementById('meeting-notes').value;
		
		// Here you would typically send this data to the server
		// For now, we'll just show a success message
		showNotification('Meeting details saved successfully!', 'success');
		
		// Update the topic data attributes
		const topicCard = document.querySelector(`[data-topic-id="${topicId}"]`);
		if (topicCard) {
			topicCard.setAttribute('data-meeting-link', meetingLink);
			topicCard.setAttribute('data-meeting-time', meetingTime);
			topicCard.setAttribute('data-meeting-notes', meetingNotes);
		}
	}
</script>