<!-- header starts -->
<header class="header ecommerce-main-header">
    <div class="custom-container2">
        <div class="header-panel">
            <div class="header-top-content text-center">
                <a href="<?= base_url('index.php/profile') ?>" onclick="history.back()">
                    <i class="iconsax icon-btn" data-icon="chevron-left"></i>
                </a>
                <h3>Saved Templates</h3>
            </div>
        </div>
    </div>
</header>
<!-- header end -->

<!-- saved templates section starts -->
<section class="section-lg-t-space" style="padding-top: 10px;">
    <div class="custom-container">
        <?php if (isset($saved_templates) && !empty($saved_templates) && is_array($saved_templates) && count($saved_templates) > 0): ?>
            <div class="templates-slider-wrapper" style="margin-top: 0;">
                <div class="templates-slider-scroll" style="display: flex; overflow-x: auto; overflow-y: hidden; gap: 12px; padding: 5px 0; -webkit-overflow-scrolling: touch; scrollbar-width: thin;">
                    <?php foreach ($saved_templates as $template): ?>
                        <a href="<?= base_url('generate-image/' . $template['temp_id']) ?>" class="template-slider-item" style="display: block; text-decoration: none; color: inherit; flex-shrink: 0; width: 100px;">
                            <div class="template-slider-box" style="position: relative; width: 100px; height: 100px; border-radius: 12px; overflow: visible; box-shadow: 0 2px 8px rgba(0,0,0,0.1); transition: transform 0.2s, box-shadow 0.2s; background: #fff; border: 3px solid #ffc107; padding: 4px; margin-bottom: 8px;">
                                <div style="width: 100%; height: 100%; border-radius: 8px; overflow: hidden;">
                                    <?php if (!empty($template['temp_image'])): ?>
                                        <img src="<?= base_url('assets/ai/uploads/templates/' . $template['temp_image']) ?>" 
                                             alt="<?= htmlspecialchars($template['temp_name']) ?>"
                                             style="width: 100%; height: 100%; object-fit: cover;"
                                             onerror="this.src='<?= base_url('assets/theme/v1/social-app/assets/images/profile/p3.png') ?>'">
                                    <?php else: ?>
                                        <img src="<?= base_url('assets/theme/v1/social-app/assets/images/profile/p3.png') ?>" 
                                             alt="Template Image"
                                             style="width: 100%; height: 100%; object-fit: cover;">
                                    <?php endif; ?>
                                    
                                    <!-- Template Name Overlay (shown on hover) -->
                                    <div class="template-overlay">
                                        <p><?= htmlspecialchars($template['temp_name']) ?></p>
                                    </div>
                                </div>
                            </div>
                            <!-- Template Name Below Image -->
                            <div class="template-name-below" style="width: 100px; text-align: center; margin-top: 4px;">
                                <p style="margin: 0; font-size: 12px; color: #333; font-weight: 500; display: flex; align-items: center; justify-content: center; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;">
                                    <span style="display: inline-block; width: 8px; height: 8px; background: #28a745; border-radius: 50%; margin-right: 6px; flex-shrink: 0;"></span>
                                    <span style="overflow: hidden; text-overflow: ellipsis; white-space: nowrap;"><?= htmlspecialchars($template['temp_name']) ?></span>
                                </p>
                            </div>
                        </a>
                    <?php endforeach; ?>
                </div>
            </div>
        <?php else: ?>
            <div class="empty-state text-center py-5">
                <i class="iconsax" data-icon="heart" style="font-size: 64px; color: #ccc; margin-bottom: 20px;"></i>
                <h4>No Saved Templates</h4>
                <p>You haven't saved any templates yet. Save templates to see them here.</p>
                <a href="<?= base_url('collections') ?>" class="btn ecommerce-btn mt-3">
                    <i class="iconsax" data-icon="add"></i> Browse Templates
                </a>
            </div>
        <?php endif; ?>
    </div>
</section>
<!-- saved templates section end -->

<style>
/* Templates Slider - Horizontal Scroll */
.templates-slider-wrapper {
    margin-top: 15px;
}

.templates-slider-scroll {
    display: flex;
    overflow-x: auto;
    overflow-y: hidden;
    gap: 12px;
    padding: 5px 0;
    -webkit-overflow-scrolling: touch;
    scrollbar-width: thin;
    scrollbar-color: #ccc transparent;
}

.templates-slider-scroll::-webkit-scrollbar {
    height: 6px;
}

.templates-slider-scroll::-webkit-scrollbar-track {
    background: transparent;
}

.templates-slider-scroll::-webkit-scrollbar-thumb {
    background: #ccc;
    border-radius: 3px;
}

.templates-slider-scroll::-webkit-scrollbar-thumb:hover {
    background: #999;
}

.template-slider-item {
    display: block;
    text-decoration: none;
    color: inherit;
    flex-shrink: 0;
    width: 100px;
}

.template-name-below {
    width: 100px;
    text-align: center;
    margin-top: 4px;
}

.template-name-below p {
    margin: 0;
    font-size: 12px;
    color: #333;
    font-weight: 500;
    display: flex;
    align-items: center;
    justify-content: center;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}

.template-name-below .green-dot {
    display: inline-block;
    width: 8px;
    height: 8px;
    background: #28a745;
    border-radius: 50%;
    margin-right: 6px;
    flex-shrink: 0;
}

.template-name-below .template-name-text {
    overflow: hidden;
    text-overflow: ellipsis;
    white-space: nowrap;
}

.template-slider-box {
    position: relative;
    width: 100px;
    height: 100px;
    border-radius: 12px;
    overflow: visible;
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    transition: transform 0.2s, box-shadow 0.2s;
    background: #fff;
    border: 3px solid #ffc107;
    padding: 4px;
}

.template-slider-box:hover {
    transform: translateY(-4px) scale(1.05);
    box-shadow: 0 4px 15px rgba(0,0,0,0.2);
    border-color: #ffb300;
}

.template-slider-box:hover .template-overlay {
    opacity: 1;
}

.template-slider-box > div {
    width: 100%;
    height: 100%;
    border-radius: 8px;
    overflow: hidden;
    position: relative;
}

.template-slider-box img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.template-overlay {
    position: absolute;
    bottom: 0;
    left: 0;
    right: 0;
    background: linear-gradient(to top, rgba(0,0,0,0.7), transparent);
    padding: 6px;
    opacity: 0;
    transition: opacity 0.2s;
}

.template-overlay p {
    color: #fff;
    font-size: 10px;
    font-weight: 600;
    margin: 0;
    text-align: center;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}

@media (max-width: 480px) {
    .template-slider-item {
        width: 90px;
    }
    
    .template-slider-box {
        width: 90px;
        height: 90px;
        border-width: 2px;
        padding: 3px;
    }
    
    .template-name-below {
        width: 90px;
    }
    
    .template-name-below p {
        font-size: 11px;
    }
}

.empty-state {
    padding: 60px 20px;
    background: #fff;
    border-radius: 12px;
}

.empty-state h4 {
    color: #333;
    margin-bottom: 10px;
}

.empty-state p {
    color: #666;
}
/* Professional Bright Colors for Buttons - Matching Black & White Logo */
.btn.ecommerce-btn {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%) !important;
    border: none !important;
    color: #fff !important;
    font-weight: 600;
    box-shadow: 0 4px 15px rgba(102, 126, 234, 0.4);
    transition: all 0.3s ease;
}
.btn.ecommerce-btn:hover {
    background: linear-gradient(135deg, #764ba2 0%, #667eea 100%) !important;
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(102, 126, 234, 0.5);
}
</style>

<script>
function toggleSaveTemplate(tempId, button) {
    $.ajax({
        url: '<?= base_url('index.php/action/toggle_save_template') ?>',
        type: 'POST',
        data: { temp_id: tempId },
        dataType: 'json',
        success: function(response) {
            if (response.success) {
                if (response.saved) {
                    button.classList.add('saved');
                    button.querySelector('i').setAttribute('data-icon', 'heart');
                    button.title = 'Unsave Template';
                } else {
                    button.classList.remove('saved');
                    button.querySelector('i').setAttribute('data-icon', 'heart-add');
                    button.title = 'Save Template';
                    
                    // If on saved templates page, remove the card
                    if (window.location.pathname.includes('saved-templates')) {
                        button.closest('.template-slider-item').remove();
                        
                        // Check if no more templates, show empty state
                        setTimeout(function() {
                            const remainingTemplates = document.querySelectorAll('.template-slider-item');
                            if (remainingTemplates.length === 0) {
                                location.reload();
                            }
                        }, 300);
                    }
                }
            } else {
                alert(response.message || 'Error saving template');
            }
        },
        error: function() {
            alert('Error saving template. Please try again.');
        }
    });
}
</script>

