<!DOCTYPE html>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Banner Mind - Select Company & Collection">
    <meta name="keywords" content="banner mind, company, collection">
    <meta name="author" content="Banner Mind">
    <link rel="icon" href="<?= base_url('assets/avator/') ?>favicon.png" type="image/x-icon">
    <title>Select Company & Collection - Banner Mind</title>
    <link rel="apple-touch-icon" href="<?= base_url('assets/avator/') ?>favicon.png">
    <meta name="title-color" content="#00162E">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black">
    <meta name="apple-mobile-web-app-title" content="Banner Mind">
    <meta name="msapplication-TileImage" content="<?= base_url('assets/avator/') ?>favicon.png">
    <meta name="msapplication-TileColor" content="#FFFFFF">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">

    <!-- Google font css -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Lato:ital,wght@0,100;0,300;0,400;0,700;0,900;1,100;1,300;1,400;1,700;1,900&display=swap">

    <!-- Bootstrap css -->
    <link id="rtl-link" rel="stylesheet" type="text/css" href="<?= base_url('assets/theme/v1/social-app/assets/css/vendors/bootstrap/bootstrap.min.css') ?>">

    <!-- Iconsax css -->
    <link rel="stylesheet" type="text/css" href="<?= base_url('assets/theme/v1/social-app/assets/css/iconsax.css') ?>">

    <!-- Iconly css -->
    <link rel="stylesheet" type="text/css" href="<?= base_url('assets/theme/v1/social-app/assets/css/iconly.css') ?>">

    <!-- Style css -->
    <link id="change-link" rel="stylesheet" type="text/css" href="<?= base_url('assets/theme/v1/social-app/assets/css/style.css') ?>">
      
    <style>
        /* Style for select dropdowns */
        .form-group select.input-text {
            appearance: none;
            -webkit-appearance: none;
            -moz-appearance: none;
            background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='12' height='12' viewBox='0 0 12 12'%3E%3Cpath fill='%23333' d='M6 9L1 4h10z'/%3E%3C/svg%3E");
            background-repeat: no-repeat;
            background-position: right 15px center;
            padding-right: 40px;
            cursor: pointer;
        }
        .form-group select.input-text:focus {
            outline: none;
            border-color: var(--theme-color, #007bff);
        }
        .login-logo-container {
            text-align: center;
            padding: 30px 15px 20px;
        }
        .login-logo {
            max-width: 150px;
            height: auto;
            object-fit: contain;
        }
        /* Professional Bright Colors for Buttons - Matching Black & White Logo */
        .btn.ecommerce-btn {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%) !important;
            border: none !important;
            color: #fff !important;
            font-weight: 600;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.4);
            transition: all 0.3s ease;
        }
        .btn.ecommerce-btn:hover {
            background: linear-gradient(135deg, #764ba2 0%, #667eea 100%) !important;
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(102, 126, 234, 0.5);
        }
        
        /* Custom Dropdown with Logo */
        .custom-select-wrapper {
            position: relative;
            width: 100%;
            margin-bottom: 0;
        }
        
        /* Fix label positioning for custom dropdown */
        .form-group.floating-label-input {
            position: relative;
            margin-bottom: 20px;
        }
        
        .form-group.floating-label-input .custom-select-wrapper + label {
            position: absolute !important;
            top: 0 !important;
            left: 15px !important;
            transform: translateY(-50%) !important;
            background: #fff !important;
            padding: 0 8px !important;
            font-size: 12px !important;
            color: var(--theme-color, #007bff) !important;
            pointer-events: none !important;
            z-index: 2 !important;
            transition: all 0.2s ease !important;
            margin-bottom: 0 !important;
            display: flex !important;
            align-items: center !important;
            gap: 6px !important;
        }
        
        /* Ensure custom dropdown trigger is above label */
        .custom-select-trigger {
            position: relative;
            z-index: 1;
        }
        .custom-select-trigger {
            width: 100%;
            padding: 14px 40px 14px 16px;
            border: 2px solid #e0e0e0;
            border-radius: 12px;
            background: #fff;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: space-between;
            transition: all 0.3s ease;
            min-height: 50px;
        }
        .custom-select-trigger:hover {
            border-color: var(--theme-color, #007bff);
        }
        .custom-select-wrapper.active .custom-select-trigger {
            border-color: var(--theme-color, #007bff);
            box-shadow: 0 0 0 3px rgba(0, 123, 255, 0.1);
        }
        .custom-select-placeholder {
            display: flex;
            align-items: center;
            gap: 8px;
            color: #999;
            font-size: 15px;
        }
        .custom-select-trigger.selected .custom-select-placeholder {
            color: #333;
        }
        .custom-select-trigger .selected-company {
            display: flex;
            align-items: center;
            gap: 10px;
        }
        .custom-select-trigger .selected-company img {
            width: 32px;
            height: 32px;
            object-fit: contain;
            border-radius: 4px;
        }
        .custom-select-trigger .selected-company-name {
            font-size: 15px;
            color: #333;
            font-weight: 500;
        }
        .custom-select-arrow {
            font-size: 16px;
            color: #666;
            transition: transform 0.3s ease;
        }
        .custom-select-wrapper.active .custom-select-arrow {
            transform: rotate(180deg);
        }
        .custom-select-options {
            position: absolute;
            top: calc(100% + 5px);
            left: 0;
            right: 0;
            background: #fff;
            border: 2px solid #e0e0e0;
            border-radius: 12px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.15);
            max-height: 300px;
            overflow-y: auto;
            z-index: 1000;
            display: none;
        }
        .custom-select-wrapper.active .custom-select-options {
            display: block;
        }
        .custom-select-option {
            padding: 12px 16px;
            cursor: pointer;
            display: flex;
            align-items: center;
            gap: 12px;
            transition: all 0.2s ease;
            border-bottom: 1px solid #f0f0f0;
        }
        .custom-select-option:last-child {
            border-bottom: none;
        }
        .custom-select-option:hover {
            background: #f8f9fa;
        }
        .custom-select-option.selected {
            background: #e7f3ff;
        }
        .company-logo-option {
            width: 32px;
            height: 32px;
            object-fit: contain;
            border-radius: 4px;
            flex-shrink: 0;
        }
        .company-logo-placeholder {
            width: 32px;
            height: 32px;
            display: flex;
            align-items: center;
            justify-content: center;
            background: #f0f0f0;
            border-radius: 4px;
            flex-shrink: 0;
        }
        .company-logo-placeholder i {
            font-size: 18px;
            color: #999;
        }
        .company-name-option {
            font-size: 15px;
            color: #333;
            font-weight: 500;
        }
    </style>
</head>

<body class="ecommerce lato-font">

    <!-- loader Start -->
    <div class="loader">
        <img src="<?= base_url('assets/theme/v1/social-app/assets/images/gif/fashion.gif') ?>" class="img-fluid" alt="ecommerce">
    </div>
    <!-- loader End -->

    <!-- signup Start -->
    <div class="login-logo-container">
        <img src="<?= base_url('assets/avator/logo.png') ?>" alt="Logo" class="login-logo">
    </div>
    <div class="ecommerce-auth-title">
        <h2>Complete Your Registration</h2>
        <h3>Please select your Company and Collection to continue</h3>
    </div>

    <form class="ecommerce-form" id="companyCollectionForm" onsubmit="return handleCompanyCollectionForm(this);">
        <div class="custom-container">
            <div id="error_div" class="alert alert-danger" style="display:none;"></div>
            <div id="loder_div" style="display:none; text-align:center; padding:10px;">
                <img src="<?= base_url('assets/theme/v1/social-app/assets/images/gif/fashion.gif') ?>" style="width:50px; height:50px;">
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="form-group floating-label-input">
                        <!-- Hidden select for form submission -->
                        <select class="input-text" id="company" name="comp_id" required style="display: none;">
                            <option value="">Select Company</option>
                            <?php if(isset($companies) && !empty($companies)): ?>
                                <?php foreach($companies as $company): ?>
                                    <option value="<?= $company['comp_id'] ?>" 
                                        data-logo="<?= !empty($company['comp_logo']) ? htmlspecialchars($company['comp_logo']) : '' ?>">
                                        <?= htmlspecialchars($company['comp_name']) ?>
                                    </option>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </select>
                        <!-- Custom Dropdown with Logo -->
                        <div class="custom-select-wrapper" id="company_wrapper">
                            <div class="custom-select-trigger" id="company_trigger">
                                <span class="custom-select-placeholder">
                                    <i class="iconsax" data-icon="buildings-2"></i> Select Company
                                </span>
                                <i class="iconsax custom-select-arrow" data-icon="arrow-down-2"></i>
                            </div>
                            <div class="custom-select-options" id="company_options">
                                <?php if(isset($companies) && !empty($companies)): ?>
                                    <?php foreach($companies as $company): ?>
                                        <?php 
                                        $logo_url = '';
                                        if (!empty($company['comp_logo'])) {
                                            $logo_path = 'assets/ai/uploads/companies/' . $company['comp_logo'];
                                            if (file_exists($logo_path)) {
                                                $logo_url = base_url($logo_path);
                                            }
                                        }
                                        ?>
                                        <div class="custom-select-option" 
                                             data-value="<?= $company['comp_id'] ?>"
                                             data-logo="<?= htmlspecialchars($logo_url) ?>">
                                            <?php if ($logo_url): ?>
                                                <img src="<?= $logo_url ?>" alt="<?= htmlspecialchars($company['comp_name']) ?>" class="company-logo-option" onerror="this.style.display='none'">
                                            <?php else: ?>
                                                <div class="company-logo-placeholder">
                                                    <i class="iconsax" data-icon="buildings-2"></i>
                                                </div>
                                            <?php endif; ?>
                                            <span class="company-name-option"><?= htmlspecialchars($company['comp_name']) ?></span>
                                        </div>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </div>
                        </div>
                        <label class="form-check-label" for="company">Company</label>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group floating-label-input">
                        <select class="input-text" id="collection" name="coll_id" required>
                            <option value="">Select Collection</option>
                            <?php if(isset($collections) && !empty($collections)): ?>
                                <?php foreach($collections as $collection): ?>
                                    <option value="<?= $collection['coll_id'] ?>" data-comp-id="<?= $collection['coll_comp_id'] ?>" style="display:none;">
                                        <?= htmlspecialchars($collection['coll_name']) ?>
                                    </option>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </select>
                        <label class="form-check-label" for="collection">Collection</label>
                    </div>
                </div>
            </div>

            <button type="submit" class="btn ecommerce-btn w-100 mt-5">Complete Registration</button>

           
        </div>

       
        <h6>Already have an account? <a href="<?= base_url('index.php/login') ?>">Login</a></h6>
    </form>
    <!-- signup End -->

    <!-- jQuery -->
    <script src="<?= base_url('assets/js/jquery-3.3.1.min.js') ?>"></script>
    
    <!-- Bootstrap js-->
    <script src="<?= base_url('assets/theme/v1/social-app/assets/js/vendors/bootstrap/bootstrap.bundle.min.js') ?>"></script>

    <!-- template Settings js-->
    <script src="<?= base_url('assets/theme/v1/social-app/assets/js/template-setting.js') ?>"></script>

    <!-- script js-->
    <script src="<?= base_url('assets/theme/v1/social-app/assets/js/script.js') ?>"></script>

    <!-- SweetAlert -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>
    // Ensure loader is hidden when page loads
    document.addEventListener('DOMContentLoaded', function() {
        // Fallback: Hide loader after page loads (in case script.js doesn't work)
        setTimeout(function() {
            const loader = document.querySelector('.loader');
            if (loader) {
                loader.classList.add('hide');
                setTimeout(function() {
                    loader.remove();
                }, 800);
            }
        }, 500);
    });

    // Also use window load event as backup
    window.addEventListener('load', function() {
        setTimeout(function() {
            const loader = document.querySelector('.loader');
            if (loader && !loader.classList.contains('hide')) {
                loader.classList.add('hide');
                setTimeout(function() {
                    loader.remove();
                }, 800);
            }
        }, 500);
    });

    // Custom Dropdown with Logo Functionality
    function initCustomDropdown() {
        const wrapper = document.getElementById('company_wrapper');
        const trigger = document.getElementById('company_trigger');
        const options = document.getElementById('company_options');
        const select = document.getElementById('company');
        
        if (!wrapper || !trigger || !options || !select) return;
        
        // Set initial value if selected (for page reload scenarios)
        const selectedOption = select.options[select.selectedIndex];
        if (selectedOption && selectedOption.value) {
            const logoUrl = selectedOption.getAttribute('data-logo');
            const companyName = selectedOption.text;
            updateTriggerDisplay(companyName, logoUrl);
            wrapper.classList.add('has-value');
            wrapper.classList.add('selected');
        }
        
        // Ensure label is always floated
        const label = wrapper.nextElementSibling;
        if (label && label.classList.contains('form-check-label')) {
            label.style.top = '0';
            label.style.left = '15px';
            label.style.background = '#fff';
            label.style.padding = '0 8px';
            label.style.fontSize = '12px';
            label.style.color = 'var(--theme-color, #007bff)';
            label.style.transform = 'translateY(-50%)';
        }
        
        // Toggle dropdown
        trigger.addEventListener('click', function(e) {
            e.stopPropagation();
            wrapper.classList.toggle('active');
        });
        
        // Close dropdown when clicking outside
        document.addEventListener('click', function(e) {
            if (!wrapper.contains(e.target)) {
                wrapper.classList.remove('active');
            }
        });
        
        // Handle option selection
        options.querySelectorAll('.custom-select-option').forEach(function(option) {
            option.addEventListener('click', function() {
                const value = this.getAttribute('data-value');
                const logoUrl = this.getAttribute('data-logo');
                const companyName = this.querySelector('.company-name-option').textContent;
                
                // Update select value
                select.value = value;
                select.dispatchEvent(new Event('change'));
                
                // Update trigger display
                updateTriggerDisplay(companyName, logoUrl);
                
                // Update selected state
                options.querySelectorAll('.custom-select-option').forEach(function(opt) {
                    opt.classList.remove('selected');
                });
                this.classList.add('selected');
                
                // Close dropdown
                wrapper.classList.remove('active');
                wrapper.classList.add('has-value');
                wrapper.classList.add('selected');
            });
        });
    }
    
    function updateTriggerDisplay(companyName, logoUrl) {
        const trigger = document.getElementById('company_trigger');
        const placeholder = trigger.querySelector('.custom-select-placeholder');
        
        if (companyName && companyName !== 'Select Company') {
            trigger.classList.add('selected');
            if (logoUrl) {
                placeholder.innerHTML = '<div class="selected-company"><img src="' + logoUrl + '" alt="' + companyName + '" onerror="this.style.display=\'none\'"><span class="selected-company-name">' + companyName + '</span></div>';
            } else {
                placeholder.innerHTML = '<div class="selected-company"><div class="company-logo-placeholder"><i class="iconsax" data-icon="buildings-2"></i></div><span class="selected-company-name">' + companyName + '</span></div>';
            }
        } else {
            trigger.classList.remove('selected');
            placeholder.innerHTML = '<i class="iconsax" data-icon="buildings-2"></i> Select Company';
        }
        
        // Update iconsax
        if (typeof iconsax !== 'undefined') {
            iconsax.init();
        }
    }

    // Filter collections based on selected company
    $(document).ready(function() {
        initCustomDropdown();
        
        $('#company').on('change', function() {
            var selectedCompId = $(this).val();
            var $collectionSelect = $('#collection');
            
            // Reset collection dropdown
            $collectionSelect.val('');
            
            // Show/hide collection options based on selected company
            $collectionSelect.find('option').each(function() {
                if ($(this).val() == '') {
                    $(this).show(); // Always show "Select Collection" option
                } else {
                    var compId = $(this).data('comp-id');
                    if (compId == selectedCompId) {
                        $(this).show();
                    } else {
                        $(this).hide();
                    }
                }
            });
        });
    });

    function handleCompanyCollectionForm(form) {
        // Validate company and collection selection
        var company = document.getElementById('company').value;
        var collection = document.getElementById('collection').value;
        
        if (!company || !collection) {
            Swal.fire({
                icon: 'error',
                title: 'Required Fields',
                text: 'Please select both Company and Collection.'
            });
            return false;
        }

        $("#error_div").hide().empty();
        $("#loder_div").show();
        
        $.ajax({
            type: 'POST',
            url: '<?= base_url('index.php/action/save_company_collection') ?>',
            data: $(form).serialize(),
            success: function(data) {
                console.log('Company Collection Response:', data);
                
                if($.trim(data) == 'YNAPS_SUCCESS' || $.trim(data) == 'YNAPS_SUCCESS22') {
                    Swal.fire({
                        icon: 'success',
                        title: 'Registration Complete',
                        text: 'Your account has been successfully completed. Redirecting...'
                    }).then(function() {
                        window.location.href = '<?= base_url() ?>';
                    });
                }
                else {
                    $("#error_div").html(data).show();
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: data
                    });
                }
                $("#loder_div").hide();
            },
            error: function() {
                $("#error_div").html('An error occurred. Please try again.').show();
                $("#loder_div").hide();
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'An error occurred. Please try again.'
                });
            }
        });
        return false;
    }
    </script>

</body>

</html>

