<!DOCTYPE html>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Banner Mind - Signup">
    <meta name="keywords" content="banner mind, signup">
    <meta name="author" content="Banner Mind">
    <link rel="icon" href="<?= base_url('assets/avator/') ?>favicon.png" type="image/x-icon">
    <title>Signup - Banner Mind</title>
    <link rel="apple-touch-icon" href="<?= base_url('assets/avator/') ?>favicon.png">
    <meta name="title-color" content="#00162E">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black">
    <meta name="apple-mobile-web-app-title" content="Banner Mind">
    <meta name="msapplication-TileImage" content="<?= base_url('assets/avator/') ?>favicon.png">
    <meta name="msapplication-TileColor" content="#FFFFFF">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">

    <!-- Google font css -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Lato:ital,wght@0,100;0,300;0,400;0,700;0,900;1,100;1,300;1,400;1,700;1,900&display=swap">

    <!-- Bootstrap css -->
    <link id="rtl-link" rel="stylesheet" type="text/css" href="<?= base_url('assets/theme/v1/social-app/assets/css/vendors/bootstrap/bootstrap.min.css') ?>">

    <!-- Iconsax css -->
    <link rel="stylesheet" type="text/css" href="<?= base_url('assets/theme/v1/social-app/assets/css/iconsax.css') ?>">

    <!-- Iconly css -->
    <link rel="stylesheet" type="text/css" href="<?= base_url('assets/theme/v1/social-app/assets/css/iconly.css') ?>">

    <!-- Style css -->
    <link id="change-link" rel="stylesheet" type="text/css" href="<?= base_url('assets/theme/v1/social-app/assets/css/style.css') ?>">
    
    <style>
        /* Style for select dropdowns */
        .form-group select.input-text {
            appearance: none;
            -webkit-appearance: none;
            -moz-appearance: none;
            background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='12' height='12' viewBox='0 0 12 12'%3E%3Cpath fill='%23333' d='M6 9L1 4h10z'/%3E%3C/svg%3E");
            background-repeat: no-repeat;
            background-position: right 15px center;
            padding-right: 40px;
            cursor: pointer;
        }
        .form-group select.input-text:focus {
            outline: none;
            border-color: var(--theme-color, #007bff);
        }
        .login-logo-container {
            text-align: center;
            padding: 50px 15px 20px;
        }
        .login-logo {
            max-width: 150px;
            height: auto;
            object-fit: contain;
        }
        .ecommerce-auth-title {
            margin-top: 20px !important;
        }
        @media (max-width: 600px) {
            .ecommerce-auth-title {
                padding-top: 20px !important;
                margin-top: 20px !important;
            }
        }
        .password-toggle-wrapper {
            position: relative;
        }
        .password-toggle-btn {
            position: absolute;
            right: 12px;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            cursor: pointer;
            padding: 8px;
            color: #666;
            font-size: 20px;
            z-index: 100;
            display: flex;
            align-items: center;
            justify-content: center;
            width: 32px;
            height: 32px;
            line-height: 1;
        }
        .password-toggle-btn:hover {
            color: #333;
        }
        .password-toggle-btn i {
            display: inline-block;
            width: 20px;
            height: 20px;
        }
        .password-toggle-wrapper .input-text {
            padding-right: 50px;
        }
        /* Professional Bright Colors for Buttons - Matching Black & White Logo */
        .btn.ecommerce-btn {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%) !important;
            border: none !important;
            color: #fff !important;
            font-weight: 600;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.4);
            transition: all 0.3s ease;
        }
        .btn.ecommerce-btn:hover {
            background: linear-gradient(135deg, #764ba2 0%, #667eea 100%) !important;
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(102, 126, 234, 0.5);
        }
        /* Ensure screenshots work - allow all interactions */
        * {
            -webkit-user-select: auto !important;
            -moz-user-select: auto !important;
            -ms-user-select: auto !important;
            user-select: auto !important;
        }
        body {
            -webkit-user-select: auto !important;
            -moz-user-select: auto !important;
            -ms-user-select: auto !important;
            user-select: auto !important;
        }
    </style>
</head>

<body class="ecommerce lato-font">

    

    <!-- signup Start -->
    <div class="login-logo-container">
        <img src="<?= base_url('assets/avator/logo.png') ?>" alt="Logo" class="login-logo">
    </div>
    <div class="ecommerce-auth-title">
        <h2>Hey, Sign Up Now</h2>
        <h3>Please create your account to continue</h3>
    </div>

    <form class="ecommerce-form" id="signupForm" onsubmit="return handleSignupForm(this);">
        <div class="custom-container">
            <div id="error_div" class="alert alert-danger" style="display:none;"></div>
            <div id="loder_div" style="display:none; text-align:center; padding:10px;">
                <img src="<?= base_url('assets/theme/v1/social-app/assets/images/gif/fashion.gif') ?>" style="width:50px; height:50px;">
                <p style="margin-top: 10px; color: #666; font-size: 14px;">Please wait...</p>
            </div>
            <div id="debug_div" style="display:none; text-align:center; padding:5px; font-size:12px; color:#999;"></div>

            <div class="row">
                <div class="col-md-6">
                    <div class="form-group floating-label-input">
                        <input class="input-text" type="text" id="firstname" name="firstname" placeholder="First Name" required>
                        <label class="form-check-label" for="firstname">First Name</label>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group floating-label-input">
                        <input class="input-text" type="text" id="lastname" name="lastname" placeholder="Last Name" required>
                        <label class="form-check-label" for="lastname">Last Name</label>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="form-group floating-label-input">
                        <input class="input-text" type="email" id="email" name="email" placeholder="Email" required>
                        <label class="form-check-label" for="email">Email</label>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group floating-label-input">
                        <input class="input-text" type="tel" id="phone" name="phone" placeholder="Phone" required>
                        <label class="form-check-label" for="phone">Phone</label>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="form-group floating-label-input password-toggle-wrapper">
                        <input class="input-text form-control" type="password" id="pass" name="pass" placeholder="Password" required>
                        <label class="form-check-label" for="pass">Password</label>
                        <button type="button" class="password-toggle-btn" onclick="togglePassword('pass', this)" aria-label="Toggle password visibility">
                            <i class="iconsax" data-icon="eye"></i>
                            <span class="eye-icon-fallback" style="display: none;">👁️</span>
                        </button>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group floating-label-input password-toggle-wrapper">
                        <input class="input-text form-control" type="password" id="confirm-password" placeholder="Confirm Password" required>
                        <label class="form-check-label" for="confirm-password">Confirm Password</label>
                        <button type="button" class="password-toggle-btn" onclick="togglePassword('confirm-password', this)" aria-label="Toggle password visibility">
                            <i class="iconsax" data-icon="eye"></i>
                            <span class="eye-icon-fallback" style="display: none;">👁️</span>
                        </button>
                    </div>
                </div>
            </div>

            <!-- Captcha Row -->
            <div class="captcha-row" style="margin: 15px 0 10px 0;">
                <?php echo get_captcha('caprght_oplkion', 'sign9_form_90_feed'); ?>
            </div>

            <button type="submit" class="btn ecommerce-btn w-100 mt-3">Sign Up</button>

           
        </div>

       
        <h6 style="padding-bottom: 10px; margin-bottom: 0;">Already have an account? <a href="<?= base_url('index.php/login') ?>">Login</a></h6>
    </form>
    <!-- signup End -->

    <!-- jQuery -->
    <script src="<?= base_url('assets/js/jquery-3.3.1.min.js') ?>"></script>
    
    <!-- Bootstrap js-->
    <script src="<?= base_url('assets/theme/v1/social-app/assets/js/vendors/bootstrap/bootstrap.bundle.min.js') ?>"></script>

    <!-- template Settings js-->
    <script src="<?= base_url('assets/theme/v1/social-app/assets/js/template-setting.js') ?>"></script>

    <!-- script js-->
    <script src="<?= base_url('assets/theme/v1/social-app/assets/js/script.js') ?>"></script>

    <!-- SweetAlert -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>
    // Ensure loader is hidden when page loads
    document.addEventListener('DOMContentLoaded', function() {
        // Fallback: Hide loader after page loads (in case script.js doesn't work)
        setTimeout(function() {
            const loader = document.querySelector('.loader');
            if (loader) {
                loader.classList.add('hide');
                setTimeout(function() {
                    loader.remove();
                }, 800);
            }
        }, 500);
    });

    // Also use window load event as backup
    window.addEventListener('load', function() {
        setTimeout(function() {
            const loader = document.querySelector('.loader');
            if (loader && !loader.classList.contains('hide')) {
                loader.classList.add('hide');
                setTimeout(function() {
                    loader.remove();
                }, 800);
            }
        }, 500);
    });

    function togglePassword(inputId, btn) {
        const input = document.getElementById(inputId);
        const icon = btn.querySelector('i');
        const fallback = btn.querySelector('.eye-icon-fallback');
        
        if (input.type === 'password') {
            input.type = 'text';
            if (icon) icon.setAttribute('data-icon', 'eye-slash');
            if (fallback) fallback.textContent = '🙈';
        } else {
            input.type = 'password';
            if (icon) icon.setAttribute('data-icon', 'eye');
            if (fallback) fallback.textContent = '👁️';
        }
        
        // Trigger iconsax update if available
        if (typeof iconsax !== 'undefined') {
            iconsax.init();
        } else {
            // Fallback: Wait for iconsax to load
            setTimeout(function() {
                if (typeof iconsax !== 'undefined') {
                    iconsax.init();
                } else {
                    // Show fallback if iconsax not available
                    if (fallback) fallback.style.display = 'inline-block';
                    if (icon) icon.style.display = 'none';
                }
            }, 100);
        }
    }
    
    // Initialize iconsax after page load and check for fallback
    document.addEventListener('DOMContentLoaded', function() {
        setTimeout(function() {
            if (typeof iconsax !== 'undefined') {
                iconsax.init();
            } else {
                // Show fallback icons if iconsax not available
                document.querySelectorAll('.eye-icon-fallback').forEach(function(fallback) {
                    const icon = fallback.previousElementSibling;
                    if (icon && icon.tagName === 'I' && !icon.querySelector('svg')) {
                        fallback.style.display = 'inline-block';
                        if (icon) icon.style.display = 'none';
                    }
                });
            }
        }, 500);
    });
    
    // Ensure screenshots work - remove any blocking event listeners
    document.addEventListener('DOMContentLoaded', function() {
        // Remove any contextmenu blocking
        document.removeEventListener('contextmenu', function(e) { e.preventDefault(); });
        
        // Allow all keyboard shortcuts for screenshots
        document.addEventListener('keydown', function(e) {
            // Allow Print Screen and other screenshot shortcuts
            if (e.key === 'PrintScreen' || (e.ctrlKey && e.shiftKey && e.key === 'S')) {
                // Allow screenshot shortcuts
                return true;
            }
        }, true);
        
        // Ensure no CSS is blocking screenshots
        const style = document.createElement('style');
        style.textContent = `
            * {
                -webkit-user-select: auto !important;
                -moz-user-select: auto !important;
                -ms-user-select: auto !important;
                user-select: auto !important;
            }
        `;
        document.head.appendChild(style);
    });

    function handleSignupForm(form) {
        // Validate password confirmation
        var password = document.getElementById('pass').value;
        var confirmPassword = document.getElementById('confirm-password').value;
        
        if (password !== confirmPassword) {
            $("#error_div").html('Password and Confirm Password do not match.').show();
            return false;
        }

        $("#error_div").hide().empty();
        $("#loder_div").show();
        
        // Disable form submission to prevent double submission
        var submitBtn = form.querySelector('button[type="submit"]');
        if (submitBtn) {
            submitBtn.disabled = true;
            submitBtn.textContent = 'Signing Up...';
        }
        
        // Show debug info on mobile
        $("#debug_div").html('Sending request...').show();
        
        $.ajax({
            type: 'POST',
            url: '<?= base_url('index.php/action/signup') ?>',
            data: $(form).serialize(),
            timeout: 30000, // 30 seconds timeout
            beforeSend: function() {
                $("#debug_div").html('Connecting to server...').show();
            },
            success: function(data) {
                console.log('Signup Response (Raw):', data);
                console.log('Signup Response (Type):', typeof data);
                
                var trimmedData = $.trim(String(data));
                console.log('Signup Response (Trimmed):', trimmedData);
                console.log('Signup Response (Length):', trimmedData.length);
                
                // Show debug info
                $("#debug_div").html('Response received: ' + trimmedData.substring(0, 50)).show();
                
                // Always hide loader first
                $("#loder_div").hide();
                
                // Re-enable submit button
                if (submitBtn) {
                    submitBtn.disabled = false;
                    submitBtn.textContent = 'Sign Up';
                }
                
                // Check response (case-insensitive for safety)
                var responseUpper = trimmedData.toUpperCase();
                
                if(responseUpper == 'YNAPS_SUCCESS' || responseUpper == 'YNAPS_SUCCESS22') {
                    console.log('Redirecting to login...');
                    $("#debug_div").html('Success! Redirecting...').show();
                    setTimeout(function() {
                        window.location.href = '<?= base_url('index.php/login') ?>';
                    }, 500);
                }
                else if(responseUpper == 'OTP_REQUIRED' || responseUpper == 'OTP_SENT') {
                    console.log('Redirecting to OTP verification...');
                    $("#debug_div").html('OTP sent! Redirecting...').show();
                    setTimeout(function() {
                        window.location.href = '<?= base_url('index.php/login_otp_verify') ?>';
                    }, 500);
                }
                else {
                    console.log('Showing error:', trimmedData);
                    $("#debug_div").hide();
                    // Show error in error div
                    $("#error_div").html(trimmedData || 'An error occurred. Please try again.').show();
                }
            },
            error: function(xhr, status, error) {
                console.error('AJAX Error:', status, error);
                console.error('Response Text:', xhr.responseText);
                
                // Always hide loader
                $("#loder_div").hide();
                $("#debug_div").html('Error: ' + status).show();
                
                // Re-enable submit button
                if (submitBtn) {
                    submitBtn.disabled = false;
                    submitBtn.textContent = 'Sign Up';
                }
                
                var errorMsg = 'An error occurred. Please try again.';
                if (status === 'timeout') {
                    errorMsg = 'Request timed out. Please check your internet connection and try again.';
                } else if (xhr.responseText) {
                    var responseText = $.trim(xhr.responseText);
                    if (responseText) {
                        errorMsg = responseText;
                    }
                }
                
                setTimeout(function() {
                    $("#debug_div").hide();
                    $("#error_div").html(errorMsg).show();
                }, 2000);
            }
        });
        return false;
    }
    </script>

</body>

</html>
