<style>
/* Mobile responsiveness for subcategories slider */
@media (max-width: 768px) {
    .categories__wrap {
        position: relative;
        overflow: visible;
    }
    
    .categories__nav {
        position: absolute;
        top: 50%;
        left: 0;
        right: 0;
        transform: translateY(-50%);
        display: flex !important;
        justify-content: space-between;
        align-items: center;
        gap: 0;
        margin-top: 0;
        width: 100%;
        pointer-events: none;
        z-index: 10;
    }
    
    .categories__nav button {
        position: relative;
        pointer-events: auto;
    }
    
    .categories__nav button {
        display: flex !important;
        align-items: center;
        justify-content: center;
        width: 40px;
        height: 40px;
        background: #5751e1;
        border: none;
        border-radius: 50%;
        color: white;
        cursor: pointer;
        transition: all 0.3s ease;
        position: relative;
        z-index: 10;
        pointer-events: auto;
    }
    
    .categories__nav button:hover {
        background: #4a45c7;
        transform: scale(1.1);
    }
    
    .categories__nav button svg {
        width: 16px;
        height: 14px;
    }
    
    .categories__nav button svg path {
        stroke: white !important;
    }
    
    /* Ensure subcategories are properly spaced on mobile */
    .categories__item {
        margin-bottom: 15px;
    }
    
    /* Make sure the slider container is visible */
    .categories__wrap {
        position: relative;
        overflow: visible;
    }
}

/* Tablet responsiveness */
@media (min-width: 769px) and (max-width: 1024px) {
    .categories__wrap {
        position: relative;
        overflow: visible;
    }
    
    .categories__nav {
        position: absolute;
        top: 50%;
        left: 0;
        right: 0;
        transform: translateY(-50%);
        display: flex !important;
        justify-content: space-between;
        align-items: center;
        gap: 0;
        margin-top: 0;
        width: 100%;
        pointer-events: none;
        z-index: 10;
    }
    
    .categories__nav button {
        position: relative;
        pointer-events: auto;
    }
    
    .categories__nav button {
        display: flex !important;
        align-items: center;
        justify-content: center;
        width: 45px;
        height: 45px;
        background: #5751e1;
        border: none;
        border-radius: 50%;
        color: white;
        cursor: pointer;
        transition: all 0.3s ease;
    }
    
    .categories__nav button:hover {
        background: #4a45c7;
        transform: scale(1.1);
    }
    
    .categories__nav button svg path {
        stroke: white !important;
    }
}

/* Desktop - ensure navigation is always visible */
@media (min-width: 1025px) {
    .categories__wrap {
        position: relative;
        overflow: visible;
    }
    
    .categories__nav {
        position: absolute;
        top: 50%;
        left: 0;
        right: 0;
        transform: translateY(-50%);
        display: flex !important;
        justify-content: space-between;
        align-items: center;
        gap: 0;
        margin-top: 0;
        width: 100%;
        pointer-events: none;
        z-index: 10;
    }
    
    .categories__nav button {
        position: relative;
        pointer-events: auto;
    }
    
    .categories__nav button {
        display: flex !important;
        align-items: center;
        justify-content: center;
        width: 50px;
        height: 50px;
        background: #5751e1;
        border: none;
        border-radius: 50%;
        color: white;
        cursor: pointer;
        transition: all 0.3s ease;
    }
    
    .categories__nav button:hover {
        background: #4a45c7;
        transform: scale(1.1);
    }
    
    .categories__nav button svg path {
        stroke: white !important;
    }
}
</style>

<!-- main-area -->
<main class="main-area fix">

<div class="brand-area" style="background-image: url('<?= base_url('assets/theme/v2/skillgro/')?>assets/img/banner/edication.jpg'); background-size: cover; background-position: center; background-repeat: no-repeat; min-height: 150px;">
</div>

    <!-- subcategories-area -->
    <section class="categories-area section-py-120">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-5 col-lg-7">
                    <div class="section__title text-center mb-40">
                        <span class="sub-title"><?= isset($category['name']) ? $category['name'] : 'Category' ?> Subcategories</span>
                        <h2 class="title">Explore Specializations</h2>
                        <p class="desc">Discover specialized areas within <?= isset($category['name']) ? $category['name'] : 'this category' ?></p>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <div class="categories__wrap">
                        <div class="swiper categories-active">
                            <div class="swiper-wrapper">
                                <?php if (isset($subcategories) && !empty($subcategories)): ?>
                                    <?php foreach ($subcategories as $index => $subcategory): ?>
                                        <div class="swiper-slide">
                                            <div class="categories__item">
                                                <a href="<?= base_url('sub-sub/' . url_smart($subcategory['sc_name']) . '/' . $subcategory['sc_id']) ?>">
                                                    <div class="icon">
                                                        <?php
                                                        // Output the database icon HTML directly since it already contains complete <i> tags
                                                        if (!empty($subcategory['sc_text'])) {
                                                            echo $subcategory['sc_text'];
                                                        } else {
                                                            // Fallback if no icon in database
                                                            $icons = ['flaticon-graphic-design', 'flaticon-investment', 'flaticon-coding', 'flaticon-email', 'flaticon-fashion', 'flaticon-interaction'];
                                                            $icon = $icons[$index % count($icons)];
                                                            echo '<i class="' . $icon . '"></i>';
                                                        }
                                                        ?>
                                                    </div>
                                                    <span class="name" style="white-space: nowrap; overflow: hidden; text-overflow: ellipsis; display: block; max-width: 100%;"><?= $subcategory['sc_name'] ?></span>
                                                </a>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <div class="col-12 text-center">
                                        <p>No subcategories found for this category.</p>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="categories__nav">
                            <button class="categories-button-prev" onclick="event.stopPropagation(); event.preventDefault();">
                                <svg width="16" height="14" viewBox="0 0 16 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M15 7L1 7M1 7L7 1M1 7L7 13" stroke="#161439" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                                </svg>
                            </button>
                            <button class="categories-button-next" onclick="event.stopPropagation(); event.preventDefault();">
                                <svg width="16" height="14" viewBox="0 0 16 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M1 7L15 7M15 7L9 1M15 7L9 13" stroke="#161439" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                                </svg>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- subcategories-area-end -->


</main>
<!-- main-area-end -->

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Initialize Subcategories Swiper with mobile responsiveness
    if (document.querySelector('.categories-active')) {
        const subcategoriesSwiper = new Swiper('.categories-active', {
            slidesPerView: 1,
            spaceBetween: 20,
            loop: true,
            autoplay: {
                delay: 3000,
                disableOnInteraction: false,
            },
            navigation: {
                nextEl: '.categories-button-next',
                prevEl: '.categories-button-prev',
            },
            breakpoints: {
                320: {
                    slidesPerView: 1,
                    spaceBetween: 15,
                },
                480: {
                    slidesPerView: 2,
                    spaceBetween: 15,
                },
                768: {
                    slidesPerView: 3,
                    spaceBetween: 20,
                },
                992: {
                    slidesPerView: 4,
                    spaceBetween: 25,
                },
                1200: {
                    slidesPerView: 5,
                    spaceBetween: 30,
                },
                1400: {
                    slidesPerView: 6,
                    spaceBetween: 30,
                }
            }
        });
    }
});
</script>

