<!-- header starts -->
<header class="header ecommerce-main-header">
	<div class="custom-container2">
		<div class="header-panel">
			<div class="header-top-content  text-center">
				<a href="<?= base_url('index.php/wallet') ?>" onclick="history.back()">
					<i class="iconsax icon-btn" data-icon="chevron-left"> </i>
				</a>
				<h3>Transaction History</h3>
			</div>
		</div>
	</div>
</header>
<!-- header end -->

<!-- transaction history section starts -->
<section class="pt-0" style="background: #f5f5f5; min-height: 100vh;">
	<div class="custom-container">
		<div style="padding: 20px 0;">
			<!-- Top Section with Balance and All Transactions Header -->
			<div style="display: flex; gap: 20px; margin-bottom: 25px; align-items: flex-start;">
				<!-- Current Balance Card - Left Side -->
				<div style="flex: 0 0 auto; width: 200px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); padding: 25px 20px; border-radius: 20px; color: white; box-shadow: 0 4px 15px rgba(102, 126, 234, 0.25);">
					<h6 style="color: rgba(255,255,255,0.9); margin: 0 0 12px 0; font-size: 13px; font-weight: 500; text-transform: uppercase; letter-spacing: 0.5px;">Current Balance</h6>
					<h2 style="color: white; margin: 0; font-size: 28px; font-weight: 700; line-height: 1.2;">
						₹<?= number_format(isset($profile_data['wallet_bal']) ? floatval($profile_data['wallet_bal']) : 0.00, 2) ?>
					</h2>
				</div>

				<!-- All Transactions Section - Right Side -->
				<div style="flex: 1;">
					<h5 style="font-size: 20px; font-weight: 600; color: #1f2937; margin: 0 0 25px 0;">
						All Transactions
					</h5>

					<!-- Transaction History List -->
					<div class="transaction-history-section">
						<?php if (!empty($wallet_trans) && count($wallet_trans) > 0) { 
							$current_date = '';
							foreach ($wallet_trans as $trans) { 
								$amount = floatval($trans['wallet_amount']);
								$is_credit = ($trans['wallet_type'] == 'credit');
								$trans_date = date('Y-m-d', strtotime($trans['wallet_date']));
								$display_date = date('d M Y', strtotime($trans['wallet_date']));
								
								// Show date separator if new date
								if ($current_date != $trans_date) {
									$current_date = $trans_date;
									?>
									<div class="date-separator" style="margin: 25px 0 15px 0;">
										<h6 style="margin: 0; font-size: 13px; font-weight: 600; color: #6b7280; text-transform: uppercase; letter-spacing: 0.5px;">
											<?= strtoupper($display_date) ?>
										</h6>
									</div>
									<?php
								}
							?>
								<div class="transaction-item" style="background: #fff; padding: 18px; border-radius: 16px; margin-bottom: 12px; box-shadow: 0 2px 8px rgba(0,0,0,0.06); display: flex; justify-content: space-between; align-items: center; transition: all 0.3s;">
									<div class="transaction-info" style="flex: 1; display: flex; align-items: center;">
										<!-- Icon - Green square with rounded corners -->
										<div class="transaction-icon" style="width: 48px; height: 48px; border-radius: 12px; background: <?= $is_credit ? '#10b981' : '#ef4444' ?>; display: flex; align-items: center; justify-content: center; margin-right: 15px; flex-shrink: 0;">
											<i class="iconsax" data-icon="<?= $is_credit ? 'arrow-down' : 'arrow-up' ?>" style="color: white; font-size: 22px;"></i>
										</div>
										<div style="flex: 1; min-width: 0;">
											<h6 style="margin: 0 0 8px 0; font-size: 16px; font-weight: 600; color: #1f2937;">
												<?= htmlspecialchars($trans['wallet_text'] ?: 'Transaction') ?>
											</h6>
											<p style="margin: 0; font-size: 13px; color: #6b7280; line-height: 1.5;">
												<?= date('h:i A', strtotime($trans['wallet_date'])) ?>
												<?php if (!empty($trans['wallet_orderID'])): ?>
													<br>
													<small style="color: #9ca3af;">ID: <?= htmlspecialchars($trans['wallet_orderID']) ?></small>
												<?php endif; ?>
											</p>
										</div>
									</div>
									<div class="transaction-amount" style="text-align: right; margin-left: 15px; flex-shrink: 0;">
										<h5 style="margin: 0; font-size: 18px; font-weight: 700; color: <?= $is_credit ? '#10b981' : '#ef4444' ?>;">
											<?= $is_credit ? '+' : '-' ?>₹<?= number_format(abs($amount), 2) ?>
										</h5>
									</div>
								</div>
							<?php } 
						} else { ?>
							<div class="no-transactions" style="text-align: center; padding: 60px 20px; background: #fff; border-radius: 16px; margin-top: 20px; box-shadow: 0 2px 8px rgba(0,0,0,0.06);">
								<div style="width: 80px; height: 80px; background: #f3f4f6; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto 20px;">
									<i class="iconsax" data-icon="document" style="font-size: 40px; color: #9ca3af;"></i>
								</div>
								<h5 style="color: #1f2937; font-size: 18px; font-weight: 600; margin: 0 0 10px 0;">No transactions yet</h5>
								<p style="color: #6b7280; font-size: 14px; margin: 0;">Your transaction history will appear here</p>
							</div>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
<!-- transaction history section end -->

<!-- panel-space start -->
<div class="panel-space"></div>
<!-- panel-space end -->

<style>
.transaction-item:hover {
	transform: translateY(-2px);
	box-shadow: 0 4px 15px rgba(0,0,0,0.1) !important;
}

@media (max-width: 768px) {
	.custom-container > div > div[style*="display: flex"] {
		flex-direction: column !important;
	}
	.custom-container > div > div[style*="display: flex"] > div:first-child {
		width: 100% !important;
	}
}
</style>
