<?php
// GD Library Diagnostic Script
header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html>
<head>
    <title>GD Library Check</title>
    <style>
        body { font-family: Arial, sans-serif; padding: 20px; }
        .success { color: green; font-weight: bold; }
        .error { color: red; font-weight: bold; }
        .info { background: #f0f0f0; padding: 10px; margin: 10px 0; border-radius: 5px; }
        pre { background: #f5f5f5; padding: 10px; border-radius: 5px; overflow-x: auto; }
    </style>
</head>
<body>
    <h1>GD Library Diagnostic Check</h1>
    
    <?php
    echo "<div class='info'>";
    echo "<strong>PHP Version:</strong> " . phpversion() . "<br>";
    echo "<strong>PHP.ini Location:</strong> " . php_ini_loaded_file() . "<br>";
    echo "<strong>Additional .ini files:</strong> " . php_ini_scanned_files() . "<br>";
    echo "</div>";
    
    // Check 1: Extension loaded
    echo "<h2>Check 1: Extension Loaded</h2>";
    if (extension_loaded('gd')) {
        echo "<p class='success'>✓ GD extension is LOADED</p>";
    } else {
        echo "<p class='error'>✗ GD extension is NOT loaded</p>";
    }
    
    // Check 2: GD Info
    echo "<h2>Check 2: GD Information</h2>";
    if (function_exists('gd_info')) {
        echo "<p class='success'>✓ gd_info() function is available</p>";
        $gd_info = gd_info();
        echo "<pre>";
        print_r($gd_info);
        echo "</pre>";
    } else {
        echo "<p class='error'>✗ gd_info() function is NOT available</p>";
    }
    
    // Check 3: Individual Functions
    echo "<h2>Check 3: GD Functions Availability</h2>";
    $functions = [
        'imagecreatetruecolor',
        'imagecreatefromjpeg',
        'imagecreatefrompng',
        'imagecreatefromgif',
        'imagecreatefromwebp',
        'imagecopyresampled',
        'imagecopy',
        'imagepng',
        'imagejpeg',
        'imagestring',
        'imagecolorallocate',
        'imagecolorallocatealpha',
        'imagefilledrectangle',
        'imagesx',
        'imagesy'
    ];
    
    $available_count = 0;
    foreach ($functions as $func) {
        $available = function_exists($func);
        if ($available) $available_count++;
        $status = $available ? '✓ Available' : '✗ Not Available';
        $color = $available ? 'success' : 'error';
        echo "<p class='$color'>$func: $status</p>";
    }
    
    echo "<p><strong>Available Functions: $available_count / " . count($functions) . "</strong></p>";
    
    // Check 4: Test Image Creation
    echo "<h2>Check 4: Test Image Creation</h2>";
    if (function_exists('imagecreatetruecolor') && function_exists('imagepng')) {
        try {
            $test_img = @imagecreatetruecolor(100, 100);
            if ($test_img) {
                echo "<p class='success'>✓ Successfully created test image (100x100)</p>";
                imagedestroy($test_img);
            } else {
                echo "<p class='error'>✗ Failed to create test image</p>";
            }
        } catch (Exception $e) {
            echo "<p class='error'>✗ Error creating test image: " . $e->getMessage() . "</p>";
        }
    } else {
        echo "<p class='error'>✗ Cannot test image creation - required functions not available</p>";
    }
    
    // Final Recommendation
    echo "<h2>Recommendation</h2>";
    if (extension_loaded('gd') && $available_count > 10) {
        echo "<p class='success'>✓ GD Library is properly configured and ready to use!</p>";
    } else {
        echo "<div class='error'>";
        echo "<h3>GD Library is NOT properly configured. Please follow these steps:</h3>";
        echo "<ol>";
        echo "<li><strong>Open php.ini file:</strong><br>";
        echo "Location: <code>" . php_ini_loaded_file() . "</code></li>";
        echo "<li><strong>Find GD extension line:</strong><br>";
        echo "Search for: <code>extension=gd</code> or <code>;extension=gd</code></li>";
        echo "<li><strong>Uncomment the line:</strong><br>";
        echo "Change <code>;extension=gd</code> to <code>extension=gd</code><br>";
        echo "(Remove the semicolon at the beginning)</li>";
        echo "<li><strong>Save the file</strong></li>";
        echo "<li><strong>Restart Apache:</strong><br>";
        echo "Go to XAMPP Control Panel → Stop Apache → Start Apache</li>";
        echo "<li><strong>Refresh this page</strong> to verify</li>";
        echo "</ol>";
        echo "<p><strong>Note:</strong> If <code>extension=gd</code> doesn't work, try <code>extension=gd2</code></p>";
        echo "</div>";
    }
    ?>
    
    <hr>
    <p><a href="<?= base_url() ?>">← Back to Home</a></p>
</body>
</html>

