-- Saved Templates Table - Stores user's saved templates
-- Run this SQL in your database: ai-app

CREATE TABLE IF NOT EXISTS `yn_ai_saved_templates` (
  `save_id` int(11) NOT NULL AUTO_INCREMENT,
  `save_user_id` int(11) NOT NULL COMMENT 'User ID who saved the template',
  `save_temp_id` int(11) NOT NULL COMMENT 'Template ID that was saved',
  `save_created` datetime DEFAULT CURRENT_TIMESTAMP COMMENT 'Save timestamp',
  PRIMARY KEY (`save_id`),
  UNIQUE KEY `unique_user_template` (`save_user_id`, `save_temp_id`),
  KEY `save_user_id` (`save_user_id`),
  KEY `save_temp_id` (`save_temp_id`),
  KEY `save_created` (`save_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Add foreign keys separately (only if tables exist)
-- Uncomment these if you want foreign key constraints:
-- ALTER TABLE `yn_ai_saved_templates`
-- ADD CONSTRAINT `fk_save_user_id` FOREIGN KEY (`save_user_id`) REFERENCES `yn_site_mem` (`mid`) ON DELETE CASCADE;
--
-- ALTER TABLE `yn_ai_saved_templates`
-- ADD CONSTRAINT `fk_save_temp_id` FOREIGN KEY (`save_temp_id`) REFERENCES `yn_ai_templates` (`temp_id`) ON DELETE CASCADE;

