<?php
// Test GD Library
echo "<h2>GD Library Test</h2>";

if (extension_loaded('gd')) {
    echo "<p style='color: green;'>✓ GD Library is ENABLED</p>";
    
    $info = gd_info();
    echo "<h3>GD Information:</h3>";
    echo "<pre>";
    print_r($info);
    echo "</pre>";
    
    // Test image creation
    if (function_exists('imagecreatetruecolor')) {
        echo "<p style='color: green;'>✓ imagecreatetruecolor() is available</p>";
    }
    if (function_exists('imagecreatefromjpeg')) {
        echo "<p style='color: green;'>✓ imagecreatefromjpeg() is available</p>";
    }
    if (function_exists('imagecreatefrompng')) {
        echo "<p style='color: green;'>✓ imagecreatefrompng() is available</p>";
    }
    if (function_exists('imagepng')) {
        echo "<p style='color: green;'>✓ imagepng() is available</p>";
    }
} else {
    echo "<p style='color: red;'>✗ GD Library is NOT ENABLED</p>";
    echo "<h3>How to Enable:</h3>";
    echo "<ol>";
    echo "<li>Open: C:\\xampp\\php\\php.ini</li>";
    echo "<li>Search for: extension=gd</li>";
    echo "<li>Remove semicolon (;) if present: extension=gd</li>";
    echo "<li>Save the file</li>";
    echo "<li>Restart Apache in XAMPP Control Panel</li>";
    echo "</ol>";
}

// Check individual functions
echo "<h3>Function Availability:</h3>";
$functions = [
    'imagecreatetruecolor',
    'imagecreatefromjpeg',
    'imagecreatefrompng',
    'imagecreatefromgif',
    'imagecreatefromwebp',
    'imagecopyresampled',
    'imagecopy',
    'imagepng',
    'imagejpeg',
    'imagestring',
    'imagecolorallocate',
    'imagecolorallocatealpha',
    'imagefilledrectangle'
];

foreach ($functions as $func) {
    $status = function_exists($func) ? '✓ Available' : '✗ Not Available';
    $color = function_exists($func) ? 'green' : 'red';
    echo "<p style='color: $color;'>$func: $status</p>";
}
?>

