<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Main extends CI_Controller
{
	function __construct()
	{
		parent::__construct();
	}

	public function index()
	{
		$data = db_variables();

		if ($data['home_page'] != '') {
			redirect(base_url($data['home_page']));
		}

		$data['seo_title'] = 'Home - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		$thecats = $this->db->query("select * from yn_site_catagory where type='cards' order by sid asc limit 6");
		$all_cats = $thecats->result_array();
		$data['the_cats'] = $all_cats;

		$geththeblogs = $this->db->query("select * from yn_site_blogs order by blog_id desc limit 3 ");
		$all_blogs = $geththeblogs->result_array();
		$data['show_blogs'] = $all_blogs;

		$get_sliders = $this->db->query("select * from yn_site_img where img_place ='team' and img_status='1' order by img_id asc limit 2");
		$all_sliders = $get_sliders->result_array();
		$data['show_sliders'] = $all_sliders;

		//All products
		$getProducts = $this->db->query("SELECT * FROM `yn_ecom_products` order by p_id desc limit 6");
		$the_prods = $getProducts->result_array();
		$data['prod'] = $the_prods;
		//prod1
		$getProducts = $this->db->query("SELECT * FROM `yn_ecom_products`  WHERE p_looking = '1' ORDER BY p_id DESC LIMIT 6");
		$the_prods = $getProducts->result_array();
		$data['prod1'] = $the_prods;
		//prod2
		$getProducts = $this->db->query("SELECT * FROM `yn_ecom_products`  WHERE p_looking = '2' ORDER BY p_id DESC LIMIT 6");
		$the_prods = $getProducts->result_array();
		$data['prod2'] = $the_prods;
		//prod3
		$getProducts = $this->db->query("SELECT * FROM `yn_ecom_products`  WHERE p_looking = '3' ORDER BY p_id DESC LIMIT 6");
		$the_prods = $getProducts->result_array();
		$data['prod3'] = $the_prods;
		//prod4
		$getProducts = $this->db->query("SELECT * FROM `yn_ecom_products`  WHERE p_looking = '4' ORDER BY p_id DESC LIMIT 6");
		$the_prods = $getProducts->result_array();
		$data['prod4'] = $the_prods;
		//prod5
		$getProducts = $this->db->query("SELECT * FROM `yn_ecom_products`  WHERE p_looking = '5' ORDER BY p_id DESC LIMIT 6");
		$the_prods = $getProducts->result_array();
		$data['prod5'] = $the_prods;
		//prod6
		$getProducts = $this->db->query("SELECT * FROM `yn_ecom_products`  WHERE p_looking = '6' ORDER BY p_id DESC LIMIT 6");
		$the_prods = $getProducts->result_array();
		$data['prod6'] = $the_prods;

		// featured products
		$featuredproducts = $this->db->query("SELECT * FROM yn_ecom_products WHERE p_sale_status = '2' ORDER BY p_id DESC LIMIT 6");
		$featuredproductsdata = $featuredproducts->result_array();
		$data['featuredProducts'] = $featuredproductsdata;

		// banner
		$get_banner = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='home' AND img_status='1' ORDER BY img_id DESC LIMIT 3");
		$thebanner = $get_banner->result_array();
		$data['banner'] = $thebanner;
		
		$get_banners = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='homeb' AND img_status='1' ORDER BY img_id DESC LIMIT 1");
		$thebanners = $get_banners->row_array();
		$data['banners'] = $thebanners;

		// Video banner
		$get_banner1 = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='homevideo' AND img_status='1' ORDER BY img_id DESC LIMIT 1");
		$thebanner1 = $get_banner1->row_array();
		$data['video'] = $thebanner1;

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/brain.php', $data);
		$this->load->view('home', $data);
		$this->load->view('inc/_footer', $data);
	}
	function admin()
	{
		redirect(base_url('admin/login'));
	}

	function error_404()
	{

		$data = db_variables();
		$data['seo_title'] = $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		$this->load->view('inc/_header', $data);
		$this->load->view('error', $data);
		$this->load->view('inc/_footer', $data);
	}

	function page($slug)
	{
		$get_all_blocks = $this->db->query("select * from yn_admin_pages where pg_slug ='$slug' ");
		$the_pages_data = $get_all_blocks->row_array();


		$data = db_variables();
		$data['seo_title'] = $the_pages_data['pg_meta_title'];
		$data['seo_description'] = $data['meta_title'];;
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['page_name'] = 'Ynaps.com';
		$data['page_data'] = $the_pages_data['content'];
		$data['meta_array'] = $data;


		$this->load->view('inc/_header', $data);
		$this->load->view('inc/_page_data.php', $data);
		$this->load->view('inc/_footer', $data);
	}

	function about()
	{
		$data = db_variables();
		$data['seo_title'] = 'About Us - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		// banner
		$get_banner = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='home' AND img_status='1' ORDER BY img_id DESC LIMIT 3");
		$thebanner = $get_banner->result_array();
		$data['banner'] = $thebanner;

		$get_banner1 = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='babout' AND img_status='1' ORDER BY img_id DESC LIMIT 1");
		$thebanner1 = $get_banner1->row_array();
		$data['breadcrumb'] = $thebanner1;
		
		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('about', $data);
		$this->load->view('inc/_footer', $data);
	}

	function services()
	{

		if (check_service_status('1', '2', 'se') != '1') {
			redirect('error-404?e=this feature is not enabled.');
		}

		$data = db_variables();
		$data['seo_title'] = $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;


		$getAllServices = $this->db->query("SELECT * FROM yn_site_services ORDER BY service_id ASC LIMIT 10");
		$all_services = $getAllServices->result_array();
		$data['services'] = $all_services;

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('service', $data);
		$this->load->view('inc/_footer', $data);
	}

	function service($slug)
	{


		if (check_service_status('1', '2', 'se') != '1') {
			redirect('error-404?e=this feature is not enabled.');
		}

		$data = db_variables();
		$data['seo_title'] = $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		$slug = clean($slug);
		if ($slug == '') {
			redirect(base_url('error-404?e=No Service found.'));
		}
		$getTheService = $this->db->query("SELECT * FROM yn_site_services WHERE slug = '$slug'");
		$theService = $getTheService->row_array();
		$data['theService'] = $theService;

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('service_detail', $data);
		$this->load->view('inc/_footer', $data);
	}

	function pricing()
	{
		$data = db_variables();
		$data['seo_title'] = 'Pricing - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('inc/pricing.php', $data);
		$this->load->view('inc/_footer', $data);
	}



	function support($cid = 0, $cname = null)
	{
		$this->contact();
	}
	function career($cid = 0, $cname = null)
	{
		$this->contact();
	}

	function contact($cid = 0, $cname = null)
	{
		$data = db_variables();
		$data['seo_title'] = 'Contact us - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_title'];;
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['page_name'] = 'YNAPS';
		$data['meta_array'] = $data;

		$data['con_type'] = '0';
		if ($cid > '0') {
			$data['con_type'] = '6';
			$data['cid'] = $cid;
			$data['cname'] = unsmart_url($cname);
		}

		$get_banner1 = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='bcontact' AND img_status='1' ORDER BY img_id DESC LIMIT 1");
		$thebanner1 = $get_banner1->row_array();
		$data['breadcrumb'] = $thebanner1;

		$this->load->view('inc/_header', $data);
		// $this->load->view('inc/section.php', $data);
		$this->load->view('contact', $data);
		$this->load->view('inc/_footer', $data);
	}

	function accounts()
	{
		$this->account();
	}
	function account()
	{
		check_session('1', 'profile');
		$theoption = $this->uri->segment(3);
		switch ($theoption) {
			case 'login':
				$this->login();
				break;
			default:
				$this->login();
				break;
		}
	}

	public function signup($user_type = null)
	{
		check_session(1, 'profile');

		$data = db_variables();
		$data['seo_title'] = 'Signup - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		$data['page_name'] = 'YNAPS';
		$data['user_type'] = $user_type;

		if (isset($_GET['refer'])) {
			$_SESSION['refer'] = $_GET['refer'];
		}

		$this->load->view('inc/_header', $data);
		$this->load->view('signup', $data);
		$this->load->view('inc/_footer', $data);
	}


	public function login()
	{
		check_session(1, 'profile');
		$data = db_variables();
		$data['seo_title'] = 'Login - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		$this->load->view('inc/_header', $data);
		$this->load->view('login', $data);
		$this->load->view('inc/_footer', $data);
	}

	function login_otp_verify()
	{
		@session_start();
		//check_session('2','account');
		$data = db_variables();
		$data['seo_title'] = 'OTP Verify - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_title'];
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['page_name'] = 'YNAPS';
		$data['meta_array'] = $data;

		$this->load->view('inc/_header', $data);
		// $this->load->view('inc/section',$data);
		$this->load->view('login_otp_verify', $data);
		$this->load->view('inc/_footer', $data);
	}

	function password()
	{
		if (isset($_SESSION['yid']) && $_SESSION['yid'] != '') {
			redirect(base_url('profile'));
		}
		$data = db_variables();
		$data['seo_title'] = 'Password Reset - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_title'];
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['page_name'] = 'Password';
		$data['meta_array'] = $data;


		$this->load->view('inc/_header.php', $data);
		$this->load->view('password_reset.php', $data);
		$this->load->view('inc/_footer.php', $data);
	}

	function reset_password()
	{
		// if(isset($_SESSION['yid']) && $_SESSION['yid'] !=''){ redirect(base_url('profile')); }

		$data = db_variables();
		$data['seo_title'] = 'Password Reset - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_title'];
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['page_name'] = 'Reset Password';
		$data['meta_array'] = $data;

		$email = $this->input->get('mail');

		$getdats = $this->db->query("select pass_reset from yn_site_mem where email='$email' ");
		$thedetails = $getdats->row_array();

		$c = $this->input->get('c');
		if ($thedetails['pass_reset'] != $c) {
			redirect(base_url('error-404'));
		}

		$hash = $this->input->get('ha');

		if (sha1($email) . '90' != $hash) {
			redirect(base_url('profile'));
		} else {
			$data['e'] = $email;



			$this->load->view('inc/_header.php', $data);
			$this->load->view('password_reset2.php', $data);
			$this->load->view('inc/_footer.php', $data);
		}
	}

	function refund()
	{
		$data = db_variables();
		$data['seo_title'] = 'Refund - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['meta_array'] = $data;
		$data['page_name'] = 'Terms';



		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('refund', $data);
		$this->load->view('inc/_footer', $data);
	}
	function terms()
	{
		$data = db_variables();
		$data['seo_title'] = 'Terms & Conditions - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['meta_array'] = $data;
		$data['page_name'] = 'Terms';



		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('terms', $data);
		$this->load->view('inc/_footer', $data);
	}
	function privacy()
	{
		$data = db_variables();
		$data['seo_title'] = 'Privacy Policy - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['meta_array'] = $data;
		$data['page_name'] = 'YNAPS';

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('privacy', $data);
		$this->load->view('inc/_footer', $data);
	}

	function faq()
	{
		$data = db_variables();
		$data['seo_title'] = 'FAQs - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['meta_array'] = $data;
		$data['page_name'] = 'Terms';



		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('inc/faq', $data);
		$this->load->view('inc/_footer', $data);
	}

	function profile()
	{
		@session_start();
		check_session('2', 'account');
		$data = db_variables();
		$data['seo_title'] = 'Profile - ' . $data['meta_title'];;
		$data['seo_description'] = $data['meta_title'];;
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['page_name'] = 'Profile';
		$data['meta_array'] = $data;

		$yid = $_SESSION['yid'];
		$themyuser_details = $this->ynaps_model->getprofile_data('*', $_SESSION['yid']);
		$data['profile_data'] = $themyuser_details;

		$yid = $_SESSION['yid'];
		$email = $_SESSION['email'];

		$getall_order = $this->db->query("select * from yn_ecom_order where so_email = '$email' order by so_id desc");
		$all_order = $getall_order->result_array();
		$data['allorders'] = $all_order;


		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section2', $data);
		$this->load->view('profile', $data);
		$this->load->view('inc/_footer', $data);
	}
	function view_checkout()
	{
		@session_start();
		check_session('2', 'account');
		$data = db_variables();
		$data['seo_title'] = 'Order Detail - ' . $data['meta_title'];;
		$data['seo_description'] = $data['meta_title'];;
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['page_name'] = 'Profile';
		$data['meta_array'] = $data;

		$yid = $_SESSION['yid'];
		$themyuser_details = $this->ynaps_model->getprofile_data('*', $_SESSION['yid']);
		$data['profile_data'] = $themyuser_details;

		$yid = $_SESSION['yid'];
		$email = $_SESSION['email'];

		$getall_order = $this->db->query("select * from yn_ecom_order where so_email = '$email' order by so_id desc");
		$all_order = $getall_order->result_array();
		$data['allorders'] = $all_order;


		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section2', $data);
		$this->load->view('view_checkout', $data);
		$this->load->view('inc/_footer', $data);
	}

	function otp_verify()
	{
		check_session(2, 'accounts');
		$data = db_variables();
		$data['seo_title'] = 'OTP Verify - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		$thedetails = $this->ynaps_model->getprofile_data('*', $_SESSION['yid']);
		if ($thedetails['user_email_status'] == '1') {
			redirect(base_url('profile'));
		}
		$data['profile_data'] = $thedetails;
		$yid = $_SESSION['yid'];
		$email = $_SESSION['email'];



		$this->load->view('inc/_header', $data);
		$this->load->view('otp_verify', $data);
		$this->load->view('inc/_footer', $data);
	}

	function edit($data_pass = null)
	{
		$data = db_variables();
		$data['seo_title'] = 'Edit - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_title'];
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['page_name'] = 'Edit';
		$data['meta_array'] = $data;

		$themyuser_details = $this->ynaps_model->getprofile_data('*', $_SESSION['yid']);
		$data['profile_data'] = $themyuser_details;



		check_session('2', 'account');
		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section2', $data);
		$this->load->view('edit', $data);
		$this->load->view('inc/_footer', $data);
	}

	function verify()
	{
		$data = db_variables();
		$data['seo_title'] = $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		$data['profile_data'] = $this->ynaps_model->getprofile_data('*', $_SESSION['yid']);


		check_session('2', 'account');
		$this->load->view('inc/_header', $data);
		$this->load->view('verify', $data);
		$this->load->view('inc/_footer', $data);
	}

	function logout()
	{
		$user_data = $this->session->all_userdata();
		foreach ($user_data as $key => $value) {
			if ($key != 'session_id' && $key != 'ip_address' && $key != 'user_agent' && $key != 'last_activity') {
				$this->session->unset_userdata($key);
			}
		}
		$this->session->sess_destroy();
		redirect(base_url());
	}


	function blog()
	{


		// if (check_service_status('1', '2', 'bl') != '1') {
		// 	redirect('error-404?e=this feature is not enabled.');
		// }

		$data = db_variables();
		$data['seo_title'] = 'Blogs - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['page_name'] = 'YNAPS';
		$data['meta_array'] = $data;

		$geththeblogs = $this->db->query("select * from yn_site_blogs order by blog_id desc");
		$total_num = $geththeblogs->num_rows(); //'100';
		$rec_per_page = '9';
		$this->load->library('pagination');
		$config['base_url'] = base_url('blog');
		$config['total_rows'] = $total_num;
		$config['per_page'] = $rec_per_page;
		$config['num_links'] = 3;
		$config['use_page_numbers'] = TRUE;
		$config['full_tag_open'] = "";
		$config['full_tag_close'] = '';
		$config['reuse_query_string'] = true;
		$config['page_query_string'] = TRUE;
		$config['query_string_segment'] = 'page';
		$this->pagination->initialize($config);

		@$page = $_GET['page'];
		if (isset($_GET['page'])) {
			$page = $page - 1;
		}
		$limit1 = $page * $rec_per_page;

		//echo "select * from yn_site_blogs order by blog_id desc  limit $limit1, $rec_per_page ";die;
		$geththeblogs = $this->db->query("select * from yn_site_blogs order by blog_id desc limit $limit1, $rec_per_page ");
		$all_blogs = $geththeblogs->result_array();
		$data['blogs'] = $all_blogs;

		if (@$_GET['q'] != '') {
			$q = clean($_GET['q']);
			$allblogs = $this->db->query("select * from yn_site_blogs where title like '%$q%' order by blog_id desc");
		} else {
			$allblogs = $this->db->query("select * from yn_site_blogs order by blog_id desc  limit 10 ");
		}


		$show_blogs = $allblogs->result_array();
		$data['show_blogs'] = $show_blogs;

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section.php', $data);
		$this->load->view('blog', $data);
		$this->load->view('inc/_footer', $data);
	}
	function theBlog($slug)
	{


		// if (check_service_status('1', '2', 'bl') != '1') {
		// 	redirect('error-404?e=this feature is not enabled.');
		// }

		count_view('bl', 'un');

		$data = db_variables();
		$config['base_url'] = base_url('blog');

		$geththeblog = $this->db->query("select * from yn_site_blogs where slug='$slug'");
		$theBlog = $geththeblog->row_array();
		$data['blog_rea'] = $theBlog;

		if (empty($theBlog)) {
			redirect(base_url('error-404?e=no blog found.'));
		}

		$data['seo_title'] = $theBlog['title'];
		$data['seo_description'] = trim_text(strip_tags($theBlog['comment']), 200);
		if ($theBlog['blog_img'] != '')
			$data['seo_image'] = base_url('assets/avator/upload/') . $theBlog['blog_img'];
		else
			$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['page_name'] = 'YNAPS';
		$data['meta_array'] = $data;

		$geththeblogs = $this->db->query("select * from yn_site_blogs order by blog_id desc limit 10 ");
		$all_blogs = $geththeblogs->result_array();
		$data['show_blogs'] = $all_blogs;


		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('theBlog', $data);
		$this->load->view('inc/_footer', $data);
	}

	function setcurrency()
	{
		$cur = xss_clean($_GET['c']);
		switch ($cur) {
			case 'USD':
			case 'INR':
				$_SESSION['currency'] = $cur;
				break;
			default:
				$_SESSION['currency'] = $cur;
				break;
		}
	}


	function pay_now()
	{
		@session_start();
		$cid = $_SESSION['ecom_order_id'];
		// check_session('2', 'account');

		$data = db_variables();
		$data['seo_title'] = 'Pay Now - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		@$yid = $_SESSION['yid'];
		$thedetails = $this->ynaps_model->getprofile_data('*', $yid);
		$data['profile_data'] = $thedetails;

		$getListing = $this->db->query("SELECT * FROM `yn_ecom_order` where so_order_id='$cid'");
		$data['theorder'] = $getListing->row_array();
		// if (empty($data['theorder'])) {
		// 	redirect(base_url('profile'));
		// }

		$data['cid'] = $cid;

		$this->load->view('inc/_header', $data);
		// $this->load->view('inc/section', $data);
		$this->load->view('pay_now.php', $data);
		$this->load->view('inc/_footer', $data);
	}

	function thank_you()
	{
		// @session_start();
		// check_session('2', 'account');
		$data = db_variables();
		$data['seo_title'] = 'Thank You - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;


		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('thank_you.php', $data);
		$this->load->view('inc/_footer', $data);
	}

	function payment_failed()
	{
		// @session_start();
		// check_session('2', 'account');
		$data = db_variables();
		$data['seo_title'] = 'Payment Failed - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;
		$_SESSION['ecom_order_id'] = 1231231231;

		if (isset($_SESSION['ecom_order_id'])) {
			unset($_SESSION['ecom_order_id']);
			unset($_SESSION['ecom_cart']);
		}


		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('payment_failed', $data);
		$this->load->view('inc/_footer', $data);
	}

	function search()
	{
		$data = db_variables();
		$data['seo_title'] = $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;


		$conditions = array();

		@$q = $_GET['q'];
		@$cat = $_GET['cat'];
		@$price = clean($_GET['price']);
		@$rating = clean($_GET['rating']);

		if ($price != '') {
			$conditions[] = "course_price = ('$price') ";
		}

		if ($cat != '') {
			$cat = "'" . str_replace(",", "','", $cat) . "'";
			$conditions[] = "course_cat IN ($cat) ";
		}

		if ($q != '') {
			$conditions[] = "(course_name like '%$q%' OR course_desc like '%$q%' OR course_tags like '%$q%' )";
		}

		if ($rating != '') {
			$rating = "'" . str_replace(",", "','", $rating) . "'";
			$conditions[] = "course_rating IN ($rating) ";
		}

		$sql_filter = "course_status='1'";
		if (count(@$conditions) > 0) {
			$sql_filter .= ' AND ' . implode(' AND ', @$conditions);
		}


		$allcourses = $this->db->query("select * from x_edu_courses where course_status='1' and $sql_filter and (course_app_web='web' OR course_app_web='both') order by course_id desc");

		$total_num = $allcourses->num_rows();
		$data['total_num'] = $total_num;
		$rec_per_page = '20';
		$this->load->library('pagination');
		$config['base_url'] = base_url('search');
		$config['total_rows'] = $total_num;
		$config['per_page'] = $rec_per_page;
		$config['num_links'] = 10;
		$config['use_page_numbers'] = TRUE;
		$config['full_tag_open'] = "";
		$config['full_tag_close'] = '';
		$config['reuse_query_string'] = true;
		$config['page_query_string'] = TRUE;
		$config['query_string_segment'] = 'page';
		$this->pagination->initialize($config);

		@$page = $_GET['page'];
		if (isset($_GET['page'])) {
			$page = $page - 1;
		}
		$limit1 = $page * $rec_per_page;

		//echo "select * from x_edu_courses where $sql_filter order by course_id desc  limit 10";die;
		$allcourses = $this->db->query("select * from x_edu_courses where $sql_filter order by course_id desc  limit $limit1,$rec_per_page");
		$show_courses = $allcourses->result_array();
		$data['show_courses'] = $show_courses;

		$this->load->view('inc/_header', $data);
		$this->load->view('search', $data);
		$this->load->view('inc/_footer', $data);
		//unset($_SESSION['filters']);
	}


	function auto_search($course)
	{
		$q = $this->input->post('search');
		switch ($course) {
			case 'course':

				$geththecourses = $this->db->query("select * from x_edu_courses where ( (course_name like '%$q%') and course_status='1') limit 8");
				// select * from x_edu_courses where course_status='1' order by course_id desc  limit 10
				// echo "select * from x_edu_courses where ( (course_name like '%$q%') and course_status='1' limit 8"; die;

				$thedetails_course = $geththecourses->result_array();
				foreach ($thedetails_course as $courses) { ?>
					<div class="col-12 py-2">
						<a href="<?= base_url('courses?q=') ?><?= preg_replace('/[^A-Za-z0-9\-]/', ' ', $courses['course_name']) ?>"><b><?= $courses['course_name'] ?></b></a>
					</div>
				<?php }
				break;
			default:
				$getproducts = $this->db->query("select * from rm_post,site_mem where (rmp_status !='0' and rmp_user=mid) and (rmp_title like '%$q%' or rmp_cat_name like '%$q%' or name like '%$q%') limit 5");
				$allproducts = $getproducts->result_array();
				foreach ($allproducts as $pro) { ?>
					<a href="<?= base_url('article') ?>?id=<?= $pro['rmp_id'] ?>" class='no_link_90'>
						<div class="list_details">
							<?= $pro['rmp_title'] ?></b> in <?= $pro['rmp_cat_name'] ?>
						</div>
					</a>
<?php }
				break;
		}
	}

	function shop()
	{

		if (check_service_status('1', '2', 'eco') != '1') {
			redirect('error-404?e=this feature is not enabled.');
		}


		$data = db_variables();

		$cat_name1 = urldecode($this->uri->segment(2));
		$cat_name = str_replace('-', ' ', $cat_name1);
		if (!empty($cat_name)) {
			$data['seo_title'] = ucfirst($cat_name) . ' - ' . $data['meta_title'];
		} else {
			$data['seo_title'] = 'Shop - ' . $data['meta_title'];
		}
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;



		$gettheprod = $this->db->query("select * from yn_ecom_products order by p_id desc");
		$total_num = $gettheprod->num_rows(); //'100';
		$rec_per_page = '9';
		$this->load->library('pagination');
		$config['base_url'] = base_url('shop');
		$config['total_rows'] = $total_num;
		$config['per_page'] = $rec_per_page;
		$config['num_links'] = 3;
		$config['use_page_numbers'] = TRUE;
		$config['full_tag_open'] = "";
		$config['full_tag_close'] = '';
		$config['reuse_query_string'] = true;
		$config['page_query_string'] = TRUE;
		$config['query_string_segment'] = 'page';
		$this->pagination->initialize($config);

		@$page = $_GET['page'];
		if (isset($_GET['page'])) {
			$page = $page - 1;
		}
		$limit1 = $page * $rec_per_page;



		// Top products
		$topProducts = $this->db->query("SELECT * FROM yn_ecom_products WHERE p_sale_status = '5' ORDER BY p_id DESC LIMIT 4");
		$topProductsData = $topProducts->result_array();
		$data['topProducts'] = $topProductsData;



		$searchIng = "";


		// Select category id from table where name is this. 
		$thecats = $this->db->query("select ctid from yn_site_catagory where name='$cat_name'");
		$cat2 = $thecats->row_array();
		$cat_id = $cat2['ctid'];


		$cate = $this->uri->segment(2);
		if (!empty($cate)) {
			$cate = $_GET['cate'];
			$getProducts = $this->db->query("SELECT * FROM `yn_ecom_products` where p_category ='$cat_id' order by p_id desc limit $limit1, $rec_per_page");
		} elseif (isset($_GET['scate']) && $_GET['scate'] != "" && $_GET['scate'] != null) {
			$scate = $_GET['scate'];

			$getProducts = $this->db->query("SELECT * FROM `yn_ecom_products` WHERE p_sub_category='$scate' ORDER BY p_id DESC LIMIT $limit1, $rec_per_page;");
		} elseif (isset($_GET['sscate']) && $_GET['sscate'] != "" && $_GET['sscate'] != null) {
			$sscate = $_GET['sscate'];

			$getProducts = $this->db->query("SELECT * FROM `yn_ecom_products` WHERE p_sub_sub_cat='$sscate' ORDER BY p_id DESC LIMIT $limit1, $rec_per_page;");
		} elseif (isset($_GET['q']) && $_GET['q'] != "" && $_GET['q'] != null) {
			$q = $_GET['q'];

			$getProducts = $this->db->query("SELECT * FROM `yn_ecom_products` WHERE p_name LIKE '%$q%' ORDER BY p_id DESC LIMIT $limit1, $rec_per_page;");
		} elseif (isset($_GET['min_price']) && isset($_GET['max_price'])) {
			$minPrice = $_GET['min_price'];
			$maxPrice = $_GET['max_price'];

			if (is_numeric($minPrice) && is_numeric($maxPrice)) {
				$getProducts = $this->db->query("SELECT * FROM `yn_ecom_products` WHERE p_price BETWEEN $minPrice AND $maxPrice ORDER BY p_id DESC LIMIT $limit1, $rec_per_page;");
			}
		} elseif (isset($_GET['primary_goal']) && isset($_GET['health_concern']) && isset($_GET['age_group'])) {
			$primary_goal = $_GET['primary_goal'];
			$health_concern = $_GET['health_concern'];
			$age_group = $_GET['age_group'];

		$getProducts = $this->db->query("SELECT * FROM `yn_ecom_products` WHERE  FIND_IN_SET('$primary_goal' , p_goal) > 0 AND p_concern = '$health_concern' AND  p_age = '$age_group' ORDER BY p_id DESC LIMIT $limit1, $rec_per_page;");
		} else {
			$getProducts = $this->db->query("SELECT * FROM `yn_ecom_products` order by p_id desc limit $limit1, $rec_per_page");
		}
		$the_prods = $getProducts->result_array();
		$data['prod'] = $the_prods;


		$get_banner1 = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='bshop' AND img_status='1' ORDER BY img_id DESC LIMIT 1");
		$thebanner1 = $get_banner1->row_array();
		$data['breadcrumb'] = $thebanner1;

		$thecats = $this->db->query("select * from yn_site_catagory order by sid asc limit 6");
		$all_cats = $thecats->result_array();
		$data['the_cats'] = $all_cats;

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('shop.php', $data);
		$this->load->view('inc/_footer', $data);
	}

	function cart()
	{

		if (check_service_status('1', '2', 'eco') != '1') {
			redirect('error-404?e=this feature is not enabled.');
		}

		$data = db_variables();
		$data['seo_title'] = 'Cart - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		$allpoppro = $this->db->query("select * from yn_ecom_products ORDER BY p_id desc limit 5 ");
		$thepoppro = $allpoppro->result_array();
		$data['prod'] = $thepoppro;

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('cart.php', $data);
		$this->load->view('inc/_footer', $data);
	}

	function product($pid, $pname)
	{
		// function product(){

		if (check_service_status('1', '2', 'eco') != '1') {
			redirect('error-404?e=this feature is not enabled.');
		}

		$data = db_variables();
		$allproduct = $this->db->query("SELECT * FROM yn_ecom_products WHERE p_id = $pid");
		$product = $allproduct->row_array();

		$data['seo_title'] = $product['p_name'];
		$data['seo_description'] = strip_tags($product['p_descp']);
		$data['seo_image'] = $product['p_cover'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;


		// featured products
		$featuredproducts = $this->db->query("SELECT * FROM yn_ecom_products WHERE p_sale_status = '2' ORDER BY p_id DESC LIMIT 3");
		$featuredproductsdata = $featuredproducts->result_array();
		$data['featuredProducts'] = $featuredproductsdata;


		$allpoppro = $this->db->query("select * from yn_ecom_products ORDER BY RAND() limit 5 ");
		$thepoppro = $allpoppro->result_array();
		$data['prod'] = $thepoppro;

		$getprd = $this->db->query("select * from yn_ecom_products where p_id='$pid'  ");
		$thepfd = $getprd->row_array();

		$getprd_img = $this->db->query("select * from  yn_ecom_products_img where pid='$pid'  ");
		$thepfd_mimg = $getprd_img->result_array();

		$data['product'] = $thepfd;
		$data['prod_img'] = $thepfd_mimg;

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('product.php', $data);
		$this->load->view('inc/_footer', $data);
	}


	

	///////////////////////	


	function checkout()
	{
		// @session_start();
		// check_session('2','login');
		$data = db_variables();
		$data['seo_title'] = 'Checkout - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('checkout', $data);
		$this->load->view('inc/_footer', $data);
	}

	function help()
	{
		// @session_start();
		// check_session('2','login');
		$data = db_variables();
		$data['seo_title'] = 'Help - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('help', $data);
		$this->load->view('inc/_footer', $data);
	}
	function view()
	{
		@session_start();
		check_session('2', 'account');
		$data = db_variables();
		$data['seo_title'] = 'View - ' . $data['meta_title'];;
		$data['seo_description'] = $data['meta_title'];;
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['page_name'] = 'View';
		$data['meta_array'] = $data;

		$oid = $_GET['ordid'];
		$viewallorder = $this->db->query("select * from yn_ecom_orders_detail where checkout_order_id = '$oid'  order by xod_id desc");
		$viewalldetail = $viewallorder->result_array();
		$data['viewall'] = $viewalldetail;


		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section2', $data);
		$this->load->view('view', $data);
		$this->load->view('inc/_footer', $data);
	}
	function wholesale()
	{
		$data = db_variables();
		$data['seo_title'] = 'Wholesale - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		//All products
		$getProducts = $this->db->query("SELECT * FROM `yn_ecom_products` where wholesale='1' order by p_id desc limit 21");
		$the_prods = $getProducts->result_array();
		$data['prod'] = $the_prods;

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('wholesale', $data);
		$this->load->view('inc/_footer', $data);
	}
	function rewards()
	{
		$data = db_variables();
		$data['seo_title'] = 'Rewards - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		$get_banner1 = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='brewards' AND img_status='1' ORDER BY img_id DESC LIMIT 1");
		$thebanner1 = $get_banner1->row_array();
		$data['breadcrumb'] = $thebanner1;

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('rewards', $data);
		$this->load->view('inc/_footer', $data);
	}

	function calculator()
	{
		$data = db_variables();
		$data['seo_title'] = 'Calculator - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		$this->load->view('inc/_header', $data);
		$this->load->view('calculator', $data);
		$this->load->view('inc/_footer', $data);
	}
}
