<?php
$theEnrollments = getEnrolledMembers($id);

// Load banner helper
$this->load->helper('banner');

// Try to get dynamic banner for course detail page
$banner_html = display_page_banner('course_detail', htmlspecialchars($thiscourse['course_name']), false);

if (!empty($banner_html)) {
    echo $banner_html;
} else {
    // Fallback banner
    ?>
    <div class="banner-wrapper">
        <h1 class="banner-title"><?= htmlspecialchars($thiscourse['course_name']) ?></h1>
    </div>
    <?php
}
?>

<style>
	.banner-wrapper {
		height: 100px;
		background-size: cover;
		background-position: center;
		display: flex;
		align-items: center;
		justify-content: center;
		text-align: center;
	}

	.banner-title {
		color: #0A8FD6;
		display: inline-block;
		background: #E8F6FE;
		padding: 15px 25px;
		border-radius: 8px;
		font-size: 2rem;
		max-width: 90%;
		word-wrap: break-word;
	}
</style>

<section class="courses-details-section py-5" style="background: #f5f7fa;">
   <div class="container">

      <div class="row justify-content-center g-4">

         <!-- Main Content -->
         <div class="col-lg-8">
            <div class="rounded-lg overflow-hidden" style="background: #ffffff; box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);">

               <!-- Course Header with Light Gradient -->
               <div class="text-center p-5" style="background: linear-gradient(135deg, #e8f4f8, #d1ecf1); color: #2c3e50;">
                  <!-- Author + Rating -->
                  <div class="d-flex justify-content-center align-items-center gap-3 mb-4">
                     <div class="position-relative">
                        <img src="<?= base_url('assets/avator/logo_light.png') ?>" alt="Author"
                           class=" shadow-sm border border-white" width="150" height="60"
                           data-bs-toggle="tooltip" data-bs-placement="top" title="Instructor: THE GITA GYAN">
                     </div>
                     <div>
                        <?= ratings_star($thiscourse['course_rating'], 'star') ?>
                     </div>
                  </div>

                  <!-- Course Image -->
                  <div class="position-relative d-inline-block mb-4">
                     <img src="<?= base_url('assets/avator/upload/courses/') ?><?= $thiscourse['course_img'] ?>"
                        alt="Course Image"
                        class="img-fluid rounded shadow-lg border border-white"
                        style="max-height: 400px; object-fit: cover;">
                     <span class="position-absolute top-0 start-50 translate-middle badge rounded-pill bg-warning text-dark px-3 py-2">
                        <?= $thiscourse['course_level'] ?? 'All Levels' ?>
                     </span>
                  </div>
               </div>

               <!-- Tabs -->
               <ul class="nav nav-pills justify-content-center p-3" role="tablist" style="background: #f8f9fa; border-bottom: 2px solid #e9ecef;">
                  <li class="nav-item me-2">
                     <a class="nav-link active gradient-pill" id="overview-tab" data-bs-toggle="tab" href="#overview" role="tab">Overview</a>
                  </li>
                  <li class="nav-item me-2">
                     <a class="nav-link gradient-pill" id="members-tab" data-bs-toggle="tab" href="#members" role="tab">Members</a>
                  </li>
                  <li class="nav-item">
                     <a class="nav-link gradient-pill" id="review-tab" data-bs-toggle="tab" href="#review" role="tab">Reviews</a>
                  </li>
               </ul>

               <!-- Tab Content -->
               <div class="tab-content p-4" style="background: #ffffff;">

                  <!-- Overview -->
                  <div class="tab-pane fade show active" id="overview" role="tabpanel">
                     <p class="mb-0"><?= $thiscourse['course_desc'] ?></p>
                  </div>

                  <!-- Members -->
                  <div class="tab-pane fade" id="members" role="tabpanel">
                     <h5 class="mb-4 text-center" style="color: #2c3e50;">Course Members (<?= $theEnrollments->num_rows() ?>)</h5>
                     <div class="row g-3 justify-content-center">
                        <?php
                        $z = 0;
                        $enrolled_students = $theEnrollments->result_array();
                        foreach ($enrolled_students as $member) {
                           $z++;
                           if ($z <= 12) { ?>
                              <div class="col-6 col-sm-4 col-md-3 text-center">
                                 <div class="p-3 rounded" style="background: #f8f9fa; border: 1px solid #e9ecef; transition: all 0.3s;">
                                    <img src="<?= base_url('assets/mem/') ?><?= $member['mid'] ?>/img/<?= $member['photo'] ?>"
                                       class="rounded-circle mb-2" width="70" height="70" alt="<?= $member['name'] ?>" style="border: 3px solid #e9ecef;">
                                    <div class="fw-bold" style="color: #2c3e50;"><?= $member['name'] ?></div>
                                    <small style="color: #6c757d;">Joined <?= date_format_1($member['co_start_date'], '1') ?></small>
                                 </div>
                              </div>
                        <?php }
                        } ?>
                     </div>
                     <?php if ($theEnrollments->num_rows() > 12) { ?>
                        <div class="text-center mt-3">
                           <button class="btn btn-outline-primary">View All Members</button>
                        </div>
                     <?php } ?>
                  </div>

                  <!-- Reviews -->
                  <div class="tab-pane fade" id="review" role="tabpanel">
                     <div class="row g-3 mb-4">
                        <div class="col-md-4 text-center">
                           <div class="p-4 rounded" style="background: linear-gradient(135deg, #e8f4f8, #d1ecf1); border: 1px solid #bee5eb;">
                              <h2 style="color: #0B8CD4;"><?= get_overall_rating($all_reviews_are, $review_count) ?></h2>
                              <?= ratings_star(get_overall_rating($all_reviews_are, $review_count), 'star') ?>
                              <p class="mb-0" style="color: #495057;">Based on <?= $review_count ?> reviews</p>
                           </div>
                        </div>
                        <div class="col-md-8">
                           <div class="p-4 rounded" style="background: #f8f9fa; border: 1px solid #e9ecef;">
                              <h6 style="color: #2c3e50;">Rating Breakdown</h6>
                              <?php for ($r = 5; $r > 0; $r--) {
                                 $count = get_review_count($all_reviews_are, $r);
                                 $review_per = $review_count == 0 ? 0 : ($count / $review_count) * 100;
                              ?>
                                 <div class="d-flex align-items-center mb-2">
                                    <div style="width: 70px;"><?= $r ?>★</div>
                                    <div class="progress flex-grow-1 mx-2" style="height: 8px;">
                                       <div class="progress-bar bg-warning" style="width: <?= $review_per ?>%"></div>
                                    </div>
                                    <div style="width:50px; text-align:right;"><?= number_format($review_per, 0) ?>%</div>
                                 </div>
                              <?php } ?>
                           </div>
                        </div>
                     </div>

                     <!-- Review Form -->
                     <div class="p-4 rounded" style="background: #f8f9fa; border: 1px solid #e9ecef;">
                        <h5 class="mb-3" style="color: #2c3e50;">Write a Review</h5>
                        
                        <?php if (!isset($_SESSION['yid']) || empty($_SESSION['yid'])): ?>
                           <div class="alert alert-warning mb-3">
                              <i class="fas fa-info-circle me-2"></i>
                              <strong>Login Required:</strong> Please <a href="<?= base_url('login') ?>" class="alert-link">login</a> to submit a review.
                           </div>
                        <?php endif; ?>
                        
                        <form method="post" class="js-validate"
                           onsubmit="return ajaxsubmitform('<?= base_url('index.php/action/post_review') ?>',this,'error_div','loder_div','#','1','posted');">
                           <input type="hidden" name="type" value="review">
                           <input type="hidden" name="type_id" value="<?= @$id ?>">

                           <div class="row g-3 mb-3">
                              <div class="col-md-6">
                                 <input type="text" class="form-control" placeholder="Your Name" name="name" value="<?= @$_SESSION['name'] ?>" required>
                              </div>
                              <div class="col-md-6">
                                 <input type="email" class="form-control" placeholder="Your Email" name="email" value="<?= @$_SESSION['email'] ?>" required>
                              </div>
                           </div>

                           <div class="mb-3">
                              <label class="form-label">Your Rating</label>
                              <div class="rating-container">
                                 <input type="radio" name="rating" value="1" id="star1" class="rating-input">
                                 <label for="star1" class="star-label">★</label>
                                 
                                 <input type="radio" name="rating" value="2" id="star2" class="rating-input">
                                 <label for="star2" class="star-label">★</label>
                                 
                                 <input type="radio" name="rating" value="3" id="star3" class="rating-input">
                                 <label for="star3" class="star-label">★</label>
                                 
                                 <input type="radio" name="rating" value="4" id="star4" class="rating-input">
                                 <label for="star4" class="star-label">★</label>
                                 
                                 <input type="radio" name="rating" value="5" id="star5" class="rating-input">
                                 <label for="star5" class="star-label">★</label>
                              </div>
                              <small class="text-muted" id="ratingText">Click on stars to rate</small>
                           </div>

                           <div class="mb-3">
                              <textarea class="form-control" rows="4" name="desc" placeholder="Share your experience..." required></textarea>
                           </div>

                           <div class="text-center">
                              <button type="submit" class="btn btn-primary w-50">Submit Review</button>
                           </div>
                        </form>
                     </div>
                  </div>
               </div>
            </div>
         </div>

         <!-- Sidebar -->
         <div class="col-lg-4">
            <div class="p-4 rounded sticky-top" style="top:100px; background: #ffffff; box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08); border: 1px solid #e9ecef;">
               <!-- Course Info -->
               <ul class="list-unstyled mb-3">
                  <li class="mb-3 p-3 rounded" style="background: #f8f9fa; border-left: 3px solid #0B8CD4;"><i class="fas fa-clock me-2" style="color: #0B8CD4;"></i><strong>Duration:</strong> <?= $thiscourse['course_dur'] ?></li>
                  <li class="mb-3 p-3 rounded" style="background: #f8f9fa; border-left: 3px solid #0B8CD4;"><i class="fas fa-users me-2" style="color: #0B8CD4;"></i><strong>Students:</strong> <?= $theEnrollments->num_rows() ?: 'New Course' ?></li>
                  <li class="mb-3 p-3 rounded" style="background: #f8f9fa; border-left: 3px solid #0B8CD4;"><i class="fas fa-book me-2" style="color: #0B8CD4;"></i><strong>Lessons:</strong> <?= @$thiscourse['course_lessons'] ?></li>
                  <li class="mb-3 p-3 rounded" style="background: #f8f9fa; border-left: 3px solid #0B8CD4;"><i class="fas fa-layer-group me-2" style="color: #0B8CD4;"></i><strong>Level:</strong> <?= $thiscourse['course_level'] ?? 'All Levels' ?></li>
                  <li class="mb-3 p-3 rounded" style="background: #f8f9fa; border-left: 3px solid #0B8CD4;"><i class="fas fa-globe me-2" style="color: #0B8CD4;"></i><strong>Language:</strong> <?= $thiscourse['course_lang'] ?></li>

               </ul>

               <!-- Enrollment Form -->
               <form action="<?= base_url('action/enroll') ?>" method="post" class="mb-3">
                  <input type="hidden" name="amount" value="<?= $thiscourse['course_price'] ?>">
                  <input type="hidden" name="courseID" value="<?= $thiscourse['course_id'] ?>">
                  <input type="hidden" name="courseName" value="<?= $thiscourse['course_name'] ?>">
                  <input type="hidden" name="course_end" value="<?= date("Y-m-d", strtotime('+' . $thiscourse['course_dur'])) ?>">

                  <?php if (isset($_SESSION['yid']) && $_SESSION['yid'] != ''): ?>
                     <?php if ($material_count > 0 && $thiscourse['course_lessons'] > 0 && ($enrolled == 0 || $theEnroll['co_end_date'] < date('Y-m-d'))): ?>
                        <button type="submit" class="btn btn-gradient w-100 mb-2">Enroll</button>
                     <?php elseif ($enrolled == 1): ?>
                        <a href="<?= base_url('Study_enrollments') ?>" class="btn btn-success w-100 mb-2">Access Course</a>
                     <?php else: ?>
                        <button type="button" class="btn btn-secondary w-100 mb-2" disabled>Not Available</button>
                        <small class="d-block text-muted text-center">No study materials yet.</small>
                     <?php endif; ?>
                  <?php else: ?>
                     <a href="<?= base_url('login?redirect=' . urlencode(current_url())) ?>" class="btn btn-gradient w-100 mb-2">Enroll</a>
                  <?php endif; ?>

               </form>

               <!-- Social Links -->
               <div class="d-flex justify-content-around mt-3">
                  <a href="<?= $social_fb ?>" class="btn btn-sm btn-facebook"><i class="fab fa-facebook-f"></i></a>
                  <a href="<?= $social_in ?>" class="btn btn-sm btn-instagram"><i class="fab fa-instagram"></i></a>
                  <a href="<?= $social_tw ?>" class="btn btn-sm btn-twitter"><i class="fab fa-twitter"></i></a>
                  <a href="<?= $social_yt ?>" class="btn btn-sm btn-youtube"><i class="fab fa-youtube"></i></a>
               </div>
            </div>
         </div>

         <style>
            /* Gradient Enroll Button */
            .btn-gradient {
               background: linear-gradient(135deg, #0B8CD4, rgba(37, 21, 107, 0.76));
               color: #fff;
               font-weight: 500;
               border: none;
               transition: all 0.3s ease;
               border-radius: 8px;
            }

            .btn-gradient:hover {
               transform: translateY(-3px);
               box-shadow: 0 6px 15px rgba(0, 0, 0, 0.2);
            }

            /* Social Buttons */
            .btn-facebook {
               background: #3b5998;
               color: #fff;
               border-radius: 50%;
               width: 38px;
               height: 38px;
               display: flex;
               align-items: center;
               justify-content: center;
               transition: all 0.3s;
            }

            .btn-facebook:hover {
               background: #2d4373;
            }

            .btn-instagram {
               background: #e1306c;
               color: #fff;
               border-radius: 50%;
               width: 38px;
               height: 38px;
               display: flex;
               align-items: center;
               justify-content: center;
               transition: all 0.3s;
            }

            .btn-instagram:hover {
               background: #b92a57;
            }

            .btn-twitter {
               background: #1da1f2;
               color: #fff;
               border-radius: 50%;
               width: 38px;
               height: 38px;
               display: flex;
               align-items: center;
               justify-content: center;
               transition: all 0.3s;
            }

            .btn-twitter:hover {
               background: #0d95e8;
            }

            .btn-youtube {
               background: #ff0000;
               color: #fff;
               border-radius: 50%;
               width: 38px;
               height: 38px;
               display: flex;
               align-items: center;
               justify-content: center;
               transition: all 0.3s;
            }

            .btn-youtube:hover {
               background: #cc0000;
            }
         </style>


      </div>
   </div>
</section>

<style>
   .hover-scale:hover {
      transform: translateY(-5px);
      transition: all 0.3s ease;
   }

   .gradient-pill {
      border-radius: 50px;
      transition: all 0.3s ease;
   }

   .gradient-pill.active {
      background: linear-gradient(135deg, #0B8CD4, rgba(37, 21, 107, 0.76));
      color: #fff !important;
   }

   .bg-gradient-hover {
      background: linear-gradient(135deg, #0B8CD4, rgba(37, 21, 107, 0.76));
      transition: all 0.3s ease;
   }

   .bg-gradient-hover:hover {
      transform: translateY(-5px);
      box-shadow: 0 8px 20px rgba(0, 0, 0, 0.3);
   }

   .rating-container {
      display: flex;
      gap: 5px;
      margin: 10px 0;
   }
   
   .rating-input {
      display: none;
   }
   
   .star-label {
      font-size: 2rem;
      color: #ddd;
      cursor: pointer;
      transition: color 0.2s;
   }
   
   .star-label:hover,
   .star-label:hover ~ .star-label {
      color: #ffc107;
   }
   
   .rating-input:checked ~ .star-label,
   .rating-input:checked ~ .star-label ~ .star-label {
      color: #ffc107;
   }
   
   .rating-input:checked + .star-label {
      color: #ffc107;
   }
</style>

<script>
   // Initialize tooltips
   const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
   tooltipTriggerList.map(function(tooltipTriggerEl) {
      return new bootstrap.Tooltip(tooltipTriggerEl)
   });

   // Simple rating system
   document.addEventListener('DOMContentLoaded', function() {
      const ratingInputs = document.querySelectorAll('.rating-input');
      const ratingText = document.getElementById('ratingText');
      
      ratingInputs.forEach(input => {
         input.addEventListener('change', function() {
            const rating = this.value;
            console.log('Rating selected:', rating);
            
            if (ratingText) {
               ratingText.textContent = `Rating: ${rating} star${rating > 1 ? 's' : ''}`;
               ratingText.className = 'text-success fw-bold';
            }
         });
      });
   });
</script>