<?php
// Debug page to check banner database entries
$this->load->database();

echo "<h2>Banner Database Debug</h2>";

// Check table structure
$structure = $this->db->query("DESCRIBE yn_site_img")->result_array();
echo "<h3>Table Structure:</h3>";
echo "<table border='1'><tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
foreach ($structure as $field) {
    echo "<tr>";
    echo "<td>" . $field['Field'] . "</td>";
    echo "<td>" . $field['Type'] . "</td>";
    echo "<td>" . $field['Null'] . "</td>";
    echo "<td>" . $field['Key'] . "</td>";
    echo "<td>" . $field['Default'] . "</td>";
    echo "<td>" . $field['Extra'] . "</td>";
    echo "</tr>";
}
echo "</table>";

// Check all entries
$all_entries = $this->db->query("SELECT * FROM yn_site_img ORDER BY img_id DESC LIMIT 10")->result_array();
echo "<h3>Recent Entries (Last 10):</h3>";
echo "<table border='1'><tr><th>ID</th><th>Place</th><th>Ex</th><th>Text</th><th>Image</th><th>Sort</th><th>Status</th><th>Link</th></tr>";
foreach ($all_entries as $entry) {
    echo "<tr>";
    echo "<td>" . $entry['img_id'] . "</td>";
    echo "<td>" . $entry['img_place'] . "</td>";
    echo "<td>" . $entry['img_ex'] . "</td>";
    echo "<td>" . htmlspecialchars($entry['img_text']) . "</td>";
    echo "<td>" . $entry['img_name'] . "</td>";
    echo "<td>" . $entry['img_sort'] . "</td>";
    echo "<td>" . $entry['img_status'] . "</td>";
    echo "<td>" . $entry['img_link'] . "</td>";
    echo "</tr>";
}
echo "</table>";

// Check home page banners specifically
$home_banners = $this->db->query("SELECT * FROM yn_site_img WHERE img_place='slider1' AND img_ex='home' AND img_status='1' ORDER BY img_sort ASC")->result_array();
echo "<h3>Home Page Banners:</h3>";
if (!empty($home_banners)) {
    echo "<table border='1'><tr><th>ID</th><th>Text</th><th>Image</th><th>Sort</th><th>Link</th></tr>";
    foreach ($home_banners as $banner) {
        echo "<tr>";
        echo "<td>" . $banner['img_id'] . "</td>";
        echo "<td>" . htmlspecialchars($banner['img_text']) . "</td>";
        echo "<td>" . $banner['img_name'] . "</td>";
        echo "<td>" . $banner['img_sort'] . "</td>";
        echo "<td>" . $banner['img_link'] . "</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<p>No banners found for home page.</p>";
}

// Test banner helper
echo "<h3>Banner Helper Test:</h3>";
$this->load->helper('banner');
$banner_html = display_page_banner('home', 'Test Fallback', true);
if (!empty($banner_html)) {
    echo "<p>Banner HTML generated successfully!</p>";
    echo "<div style='border: 1px solid #ccc; padding: 10px;'>" . $banner_html . "</div>";
} else {
    echo "<p>No banner HTML generated.</p>";
}
?>
