<style>
    .hero-1 .girl-img img {
        width: 100%;
        height: 100%;
        margin-bottom: 203px;
    }

    @media screen and (max-width:576px) {
        .shop-box-items .book-thumb img {
            max-width: 96% !important;
            transition: all 0.4s ease-in-out;
            -webkit-transition: all 0.4s ease-in-out;
            -moz-transition: all 0.4s ease-in-out;
            -ms-transition: all 0.4s ease-in-out;
            -o-transition: all 0.4s ease-in-out;
            object-fit: contain;
        }

        .shop-box-items .book-thumb {
            text-align: center;
            padding: 8px 0 !important;
        }

        .shop-box-items .shop-content {
            margin-top: 10px;
        }

        @media (max-width: 575px) {
            .theme-btn {
                padding: 12px 30px;
                font-size: 14px;

            }
        }

        .shop-box-items.style-2 .shop-content h3 {
            color: var(--header);
            font-family: "Inter", sans-serif;
            font-size: 14px;
            font-style: normal;
            font-weight: 700;
            line-height: 26px;
            text-transform: capitalize;
            margin-bottom: 5px;
        }



        .shop-box-items.style-2 .shop-content .price-list {
            display: flex;
            margin-top: 0px;
            justify-content: start;
            gap: 9px;
        }

        .shop-box-items.style-2 .shop-content .author-post {
            display: flex;
            align-items: center;
            justify-content: space-between;
            margin-top: -2px;
        }

        .star {
            font-size: 8px;
        }

        .shop-box-items .book-thumb img {
            width: 120%;
            /* make image wider than container */
            height: 100%;
            /* fill available height within padding */
            object-fit: contain;
            /* maintain aspect ratio without cropping */
            margin: 0 auto;
            /* center the image */
            display: block;
        }


        .shop-box-items .book-thumb {
            text-align: center;
            padding: 8px 0;
        }


        .shop-box-items .book-thumb {
            background-color: transparent;
            padding: 8px 0;
            border-radius: 10px;
            border: 2px solid #e0e0e0;
            position: relative;
            overflow: hidden;
            height: 224px !important;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        }
    }

    .shop-box-items .book-thumb {
        background-color: transparent;
        padding: 8px 0;
        border-radius: 10px;
        border: 2px solid #e0e0e0;
        position: relative;
        overflow: hidden;
        height: 239px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    }

    @media (min-width: 992px) {
        .col-lg-3 {
            flex: 0 0 auto;
            width: 16%;
        }
    }

    .shop-box-items .book-thumb img {
        width: 120%;
        /* make image wider than container */
        height: 100%;
        /* fill available height within padding */
        object-fit: contain;
        /* maintain aspect ratio without cropping */
        margin: 0 auto;
        /* center the image */
        display: block;
        /* ensures proper display */
    }

    @media screen and (max-width: 576px) {
        .shop-box-items .book-thumb img {
            width: 120%;
            height: 100%;
            object-fit: contain;
            margin: 0 auto;
            display: block;
        }
    }

    .book-catagories-wrapper .book-catagories-items .book-thumb {
        position: relative;
        padding: 14px 18px 27px;
        background-color: var(--white);
        border-radius: 10px;
        margin-bottom: 30px;
        transition: all 0.4s ease-in-out;
        -webkit-transition: all 0.4s ease-in-out;
        -moz-transition: all 0.4s ease-in-out;
        -ms-transition: all 0.4s ease-in-out;
        -o-transition: all 0.4s ease-in-out;
    }

    .rating-line {
        margin-top: 8px;
        text-align: left;
    }

    .rating-line .star {
        font-size: 12px;
        color: #ffc107;
    }

    /* All Book Card Sections - Make images flush with card borders */
    /* Apply to Featured Books, Popular Books, and any other sections with shop-box-items style-2 */
    /* Make rows use flexbox for equal height columns */
    .featured-books-row,
    .popular-books-row,
    .shop-section .row:has(.shop-box-items.style-2) {
        display: flex !important;
        flex-wrap: wrap !important;
        align-items: stretch !important;
    }
    
    .featured-books-row > [class*="col-"],
    .popular-books-row > [class*="col-"],
    .shop-section .row:has(.shop-box-items.style-2) > [class*="col-"] {
        padding-left: 12px !important;
        padding-right: 12px !important;
        display: flex !important;
        flex-direction: column !important;
    }

    /* Card container - no padding, no border, use flexbox for consistent alignment */
    .featured-books-row .shop-box-items,
    .popular-books-row .shop-box-items,
    .shop-section .shop-box-items.style-2 {
        padding: 0 !important;
        margin: 0 !important;
        width: 100% !important;
        height: 100% !important;
        overflow: hidden;
        border: none !important;
        box-sizing: border-box;
        display: flex !important;
        flex-direction: column !important;
    }

    /* Book thumb - completely flush, no padding, no border, no shadow */
    /* Make height flexible to accommodate full image */
    .featured-books-row .shop-box-items .book-thumb,
    .popular-books-row .shop-box-items .book-thumb,
    .shop-section .shop-box-items.style-2 .book-thumb {
        padding: 0 !important;
        margin: 0 !important;
        width: 100% !important;
        min-height: 239px !important;
        height: auto !important;
        border: none !important;
        border-radius: 0 !important;
        overflow: visible !important;
        display: block !important;
        box-sizing: border-box;
        box-shadow: none !important;
        background-color: transparent !important;
        position: relative;
    }

    /* Link wrapper - full width and height */
    .featured-books-row .shop-box-items .book-thumb a,
    .popular-books-row .shop-box-items .book-thumb a,
    .shop-section .shop-box-items.style-2 .book-thumb a {
        display: block !important;
        width: 100% !important;
        height: 100% !important;
        padding: 0 !important;
        margin: 0 !important;
    }

    /* Image - 100% width to match text, with contain to show full image without cutting */
    .featured-books-row .shop-box-items .book-thumb img,
    .popular-books-row .shop-box-items .book-thumb img,
    .shop-section .shop-box-items.style-2 .book-thumb img {
        /* CRITICAL: Force 100% width - this makes image match text width */
        width: 100% !important;
        max-width: 100% !important;
        min-width: 100% !important;
        /* Height auto to maintain aspect ratio - no fixed height to prevent cutting */
        height: auto !important;
        /* Use contain to ensure full image is visible without any cutting */
        object-fit: contain !important;
        object-position: center !important;
        display: block !important;
        margin: 0 !important;
        padding: 0 !important;
        border-radius: 0 !important;
        border: none !important;
        box-sizing: border-box !important;
    }
    
    /* Ensure link also forces full width */
    .featured-books-row .shop-box-items .book-thumb a img,
    .popular-books-row .shop-box-items .book-thumb a img,
    .shop-section .shop-box-items.style-2 .book-thumb a img {
        width: 100% !important;
    }
    
    /* Override any inherited styles that might add spacing */
    .featured-books-row .shop-box-items *,
    .popular-books-row .shop-box-items *,
    .shop-section .shop-box-items.style-2 * {
        box-sizing: border-box;
    }
    
    /* Ensure card content area doesn't add padding - consistent alignment */
    .featured-books-row .shop-box-items .shop-content,
    .popular-books-row .shop-box-items .shop-content,
    .shop-section .shop-box-items.style-2 .shop-content {
        padding: 15px !important;
        padding-top: 15px !important;
        margin: 0 !important;
        flex-shrink: 0 !important;
        display: flex !important;
        flex-direction: column !important;
        min-height: fit-content !important;
    }
    
    /* Category (h5) - consistent spacing and alignment */
    .featured-books-row .shop-box-items .shop-content h5,
    .popular-books-row .shop-box-items .shop-content h5,
    .shop-section .shop-box-items.style-2 .shop-content h5 {
        margin: 0 !important;
        margin-bottom: 5px !important;
        padding: 0 !important;
        line-height: 1.4 !important;
        min-height: 20px !important;
    }
    
    /* Title (h3) - consistent spacing and alignment */
    .featured-books-row .shop-box-items .shop-content h3,
    .popular-books-row .shop-box-items .shop-content h3,
    .shop-section .shop-box-items.style-2 .shop-content h3 {
        margin: 0 !important;
        margin-bottom: 8px !important;
        padding: 0 !important;
        line-height: 1.5 !important;
        min-height: 42px !important;
        display: flex !important;
        align-items: flex-start !important;
    }
    
    .featured-books-row .shop-box-items .shop-content h3 a,
    .popular-books-row .shop-box-items .shop-content h3 a,
    .shop-section .shop-box-items.style-2 .shop-content h3 a {
        display: block !important;
        line-height: 1.5 !important;
        word-wrap: break-word !important;
    }
    
    /* Price list - consistent spacing */
    .featured-books-row .shop-box-items .shop-content .price-list,
    .popular-books-row .shop-box-items .shop-content .price-list,
    .shop-section .shop-box-items.style-2 .shop-content .price-list {
        margin: 0 !important;
        margin-bottom: 8px !important;
        padding: 0 !important;
        min-height: 24px !important;
    }
    
    /* Author post - consistent spacing */
    .featured-books-row .shop-box-items .shop-content .author-post,
    .popular-books-row .shop-box-items .shop-content .author-post,
    .shop-section .shop-box-items.style-2 .shop-content .author-post {
        margin: 0 !important;
        margin-bottom: 8px !important;
        padding: 0 !important;
        min-height: 20px !important;
    }
    
    /* Rating line - consistent spacing */
    .featured-books-row .shop-box-items .shop-content .rating-line,
    .popular-books-row .shop-box-items .shop-content .rating-line,
    .shop-section .shop-box-items.style-2 .shop-content .rating-line {
        margin: 0 !important;
        padding: 0 !important;
        min-height: 18px !important;
    }
    
    /* Push Buy Now button to bottom for consistent alignment */
    .featured-books-row .shop-box-items .shop-button,
    .popular-books-row .shop-box-items .shop-button,
    .shop-section .shop-box-items.style-2 .shop-button {
        padding: 0 15px 15px 15px !important;
        margin: 0 !important;
        margin-top: auto !important;
        flex-shrink: 0 !important;
    }
    
    /* Ensure book thumb doesn't shrink unnecessarily */
    .featured-books-row .shop-box-items .book-thumb,
    .popular-books-row .shop-box-items .book-thumb,
    .shop-section .shop-box-items.style-2 .book-thumb {
        flex-shrink: 0 !important;
    }
    
    /* Universal selector for any row containing shop-box-items style-2 cards */
    .row:has(.shop-box-items.style-2) > [class*="col-"] {
        padding-left: 12px !important;
        padding-right: 12px !important;
    }

    /* Fallback for browsers that don't support :has() */
    @supports not selector(:has(*)) {
        .shop-section .row > [class*="col-"] {
            padding-left: 12px !important;
            padding-right: 12px !important;
        }
    }
</style>
<?php
// Load banner helper
$this->load->helper('banner');

// Debug: Check what banners are in database for home page
$debug_query = $this->db->query("SELECT * FROM yn_site_img WHERE img_place='slider1' AND img_ex='home' AND img_status='1' ORDER BY img_sort ASC");
$debug_banners = $debug_query->result_array();

// Debug output (remove this after testing)
if (!empty($debug_banners)) {
    echo "<!-- DEBUG: Found " . count($debug_banners) . " banners for home page -->";
    foreach ($debug_banners as $debug_banner) {
        echo "<!-- DEBUG: Banner - Text: " . htmlspecialchars($debug_banner['img_text']) . ", Image: " . $debug_banner['img_name'] . ", Sort: " . $debug_banner['img_sort'] . " -->";
    }
} else {
    echo "<!-- DEBUG: No banners found for home page -->";
}

// Display dynamic banner for home page
$banner_html = display_page_banner('home', 'Discover Stories That Inspire', true);

if (!empty($banner_html)) {
    echo $banner_html;
} else {
    // Fallback slides if no dynamic sliders
    ?>
    <section class="hero-slider">
        <div class="slide active" style="background-image:url('https://images.unsplash.com/photo-1524995997946-a1c2e315a42f');">
            <div class="overlay"></div>
            <div class="content">
                <div class="content-box">
                    <h1>Discover Stories That Inspire</h1>
                    <p><i class="fas fa-lightbulb"></i> Books for students, kids, and professionals</p>
                    <a href="<?= base_url('shop') ?>" class="btn">
                        Shop Now <i class="fas fa-arrow-right"></i>
                    </a>
                </div>
            </div>
        </div>
        <div class="slide" style="background-image:url('https://images.unsplash.com/photo-1512820790803-83ca734da794');">
            <div class="overlay"></div>
            <div class="content">
                <div class="content-box">
                    <h1>Find Your Next Adventure</h1>
                    <p>Novels, stories, and knowledge in one place</p>
                    <a href="<?= base_url('shop') ?>" class="btn">Shop Now</a>
                </div>
            </div>
        </div>
        <div class="dots"></div>
    </section>
    <?php
}
?>


<style>
    .hero-slider {
        position: relative;
        width: 100%;
        height: 85vh;
        overflow: hidden;
        font-family: 'Poppins', sans-serif;
    }

    .hero-slider .slide {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background-size: cover;
        background-position: center;
        display: flex;
        justify-content: center;
        align-items: center;
        transition: opacity 1s ease-in-out;
        opacity: 0;
    }

    .hero-slider .slide.active {
        opacity: 1;
    }

    .hero-slider .overlay {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(18, 18, 18, 0.5);
    }

    .hero-slider .content {
        position: relative;
        color: #fff;
        text-align: center;
        z-index: 2;
        padding: 20px;
    }

    .hero-slider .content-box {
        background: rgba(255, 255, 255, 0.12);
        /* glass effect */
        backdrop-filter: blur(10px);
        border-radius: 20px;
        padding: 30px 40px;
        display: inline-block;
        text-align: center;
        max-width: 180%;
        margin: 0 auto;
        box-shadow: 0 8px 30px rgba(0, 0, 0, 0.2);
        animation: fadeUp 1s ease-in-out;
    }

    .hero-slider h1 {
        font-size: 3.5rem;
        margin-bottom: 15px;
        color: #fff;
        text-shadow: 2px 2px 6px rgba(0, 0, 0, 0.6);
    }

    .hero-slider p {
        font-size: 1.2rem;
        margin-bottom: 25px;
        color: #f1f1f1;
    }

    .hero-slider .btn {
        display: inline-block;
        background: linear-gradient(135deg, #0B8CD4, rgba(37, 21, 107, 0.76));
        color: #fff;
        padding: 9px 35px;
        border-radius: 50px;
        text-decoration: none;
        font-size: 1.1rem;
        font-weight: 600;
        transition: all 0.3s ease;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
    }

    .hero-slider .btn:hover {
        transform: translateY(-3px);
        box-shadow: 0 8px 20px rgba(0, 0, 0, 0.3);
    }

    /* Dots */
    .dots {
        position: absolute;
        bottom: 20px;
        width: 100%;
        text-align: center;
        z-index: 3;
    }

    .dots span {
        cursor: pointer;
        height: 12px;
        width: 12px;
        margin: 0 5px;
        background: #bbb;
        border-radius: 50%;
        display: inline-block;
        transition: background 0.3s, transform 0.3s;
    }

    .dots span.active {
        background: #0D91D1;
        transform: scale(1.2);
    }

    @media (max-width: 768px) {
        .hero-slider {
            height: 65vh;
        }

        .hero-slider h1 {
            font-size: 2rem;
        }

        .hero-slider p {
            font-size: 1rem;
        }

        .hero-slider .btn {
            padding: 10px 20px;
            font-size: 1rem;
        }

        .hero-slider .content-box {
            padding: 20px;
            border-radius: 15px;
        }
    }

    /* Animation */
    @keyframes fadeUp {
        from {
            transform: translateY(20px);
            opacity: 0;
        }

        to {
            transform: translateY(0);
            opacity: 1;
        }
    }
</style>

<script>
    let slides = document.querySelectorAll('.hero-slider .slide');
    let dotsContainer = document.querySelector('.hero-slider .dots');
    let index = 0;
    let interval;

    // Create dots
    slides.forEach((_, i) => {
        let dot = document.createElement('span');
        dot.addEventListener('click', () => goToSlide(i));
        dotsContainer.appendChild(dot);
    });
    let dots = dotsContainer.querySelectorAll('span');

    function showSlide(i) {
        slides.forEach((s, idx) => s.classList.toggle('active', idx === i));
        dots.forEach((d, idx) => d.classList.toggle('active', idx === i));
        index = i;
    }

    function nextSlide() {
        showSlide((index + 1) % slides.length);
    }

    function goToSlide(i) {
        showSlide(i);
    }

    function startAuto() {
        interval = setInterval(nextSlide, 4000); // change timing here
    }

    function stopAuto() {
        clearInterval(interval);
    }

    document.querySelector('.hero-slider').addEventListener('mouseenter', stopAuto);
    document.querySelector('.hero-slider').addEventListener('mouseleave', startAuto);

    // Init
    showSlide(0);
    startAuto();
</script>




<!-- Shop Section start  -->
<section class="shop-section section-padding fix pt-0 mt-4">
    <div class="container featured-books-container">
        <div class="section-title-area d-flex justify-content-between align-items-center">
            <div class="section-title">
                <h2 class="wow fadeInUp" data-wow-delay=".3s">Featured Books</h2>
            </div>
            <a href="<?= base_url('shop') ?>" class="theme-btn style-2 fadeInUp" data-wow-delay=".5s">
                Explore More <i class="fa-solid fa-arrow-right-long"></i>
            </a>
        </div>

        <div class="row featured-books-row g-2">
            <?php if (!empty($featuredProducts)): ?>
                <?php foreach ($featuredProducts as $pro):
                    $url = base_url('product') . '/' . $pro['p_id'] . '/' . url_smart($pro['p_name']);
                    $cat = $this->db->query("SELECT name FROM yn_site_catagory WHERE ctid = ?", [$pro['p_category']])->row_array();
                ?>
                    <div class="col-6 col-md-4 col-lg-3">
                        <div class="shop-box-items style-2 h-100">
                            <div class="book-thumb center">
                                <a href="<?= $url ?>">
                                    <img src="<?= base_url('assets/avator/upload/' . $pro['p_cover']) ?>"
                                        alt="<?= htmlspecialchars($pro['p_name']) ?>">
                                </a>
                                <ul class="post-box">
                                    <?php if ($pro['p_mrp'] > $pro['p_price']): ?>
                                        <li>
                                            -<?= round((($pro['p_mrp'] - $pro['p_price']) / $pro['p_mrp']) * 100) ?>%
                                        </li>
                                    <?php endif; ?>
                                </ul>
                                <ul class="shop-icon d-grid justify-content-center align-items-center">
                                    <li>
                                        <?php
                                        // Check if user is logged in
                                        $user_id = $_SESSION['yid'] ?? 0;
                                        $is_wishlist = 0;
                                        if ($user_id) {
                                            $check = $this->db->query("SELECT * FROM wishlist WHERE user_id = ? AND product_id = ?", [$user_id, $pro['p_id']])->row_array();
                                            $is_wishlist = $check ? 1 : 0;
                                        }
                                        ?>
                                        <a href="javascript:void(0);"
                                            class="wishlist-btn"
                                            data-product="<?= $pro['p_id'] ?>">
                                            <i class="fa-<?= $is_wishlist ? 'solid' : 'regular' ?> fa-heart"></i>
                                        </a>
                                    </li>
                                </ul>

                            </div>
                            <div class="shop-content">
                                <h5><?= !empty($cat['name']) ? $cat['name'] : 'Design Low Book' ?></h5>
                                <h3>
                                    <a href="<?= $url ?>"><?= htmlspecialchars($pro['p_name']) ?></a>
                                </h3>
                                <ul class="price-list">
                                    <li>₹<?= number_format($pro['p_price'], 2) ?></li>
                                    <?php if ($pro['p_mrp'] > $pro['p_price']): ?>
                                        <li><del>₹<?= number_format($pro['p_mrp'], 2) ?></del></li>
                                    <?php endif; ?>
                                </ul>
                                <ul class="author-post">
                                    <li class="authot-list">
                                        <span class="content"><?= htmlspecialchars($author['img_head'] ?? $pro['p_vendor']) ?></span>
                                    </li>
                                </ul>
                                <div class="rating-line">
                                    <div class="star">
                                        <?php for ($i = 1; $i <= 5; $i++): ?>
                                            <i class="fa-<?= $i <= $pro['p_star'] ? 'solid' : 'regular' ?> fa-star"></i>
                                        <?php endfor; ?>
                                    </div>
                                </div>
                            </div>
                            <div class="shop-button">
                                <a href="<?= $url ?>" class="theme-btn">Buy Now</a>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </div>
</section>





<!-- Book Catagories Section start  -->
<section class="book-catagories-section fix section-padding bg-cover"
    style="background: linear-gradient(rgba(0, 0, 0, 0.74), rgba(0, 0, 0, 0.5)), 
           url('https://www.shutterstock.com/image-photo/old-books-quill-pen-vintage-600nw-2397543085.jpg');
           background-size: cover;
           background-position: center;">

    <div class="container">
        <div class="book-catagories-wrapper">
            <div class="section-title text-center">
                <span class="icon">
                    <!-- <img src="<?= base_url('assets/avator/favicon.png') ?>" alt="icon"> -->
                </span>
                <h2 class="wow fadeInUp" data-wow-delay=".3s">Top Categories Book</h2>
            </div>

            <div class="swiper book-catagories-slider">
                <div class="swiper-wrapper">
                    <?php
                    // Fetch categories
                    $categories = $this->db->query("SELECT * FROM yn_site_catagory ORDER BY sid ASC")->result_array();
                    foreach ($categories as $cat):
                        // Count number of books in this category
                        $count = $this->db->query("SELECT COUNT(*) as total FROM yn_ecom_products WHERE p_category = ?", [$cat['ctid']])->row()->total;
                    ?>
                        <div class="swiper-slide">
                            <div class="book-catagories-items">
                                <div class="book-thumb">
                                    <?php if (!empty($cat['img'])): ?>
                                        <img src="<?= base_url('assets/avator/upload/' . $cat['img']) ?>" alt="<?= htmlspecialchars($cat['name']) ?>">
                                    <?php elseif (!empty($cat['icon'])): ?>
                                        <div class="category-icon"><?= $cat['icon'] ?></div>
                                    <?php else: ?>
                                        <img src="<?= base_url('assets/theme/theme/assets/img/book-categori/default.png') ?>" alt="<?= htmlspecialchars($cat['name']) ?>">
                                    <?php endif; ?>
                                    <div class="book-box">
                                        <?= $count ?> books
                                    </div>
                                </div>
                                <div class="book-content">
                                    <h6>
                                        <a href="<?= base_url('shop?cate=' . $cat['ctid']) ?>">
                                            <?= htmlspecialchars($cat['name']) ?>
                                        </a>
                                    </h6>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
</section>
<style>
    .book-catagories-items {
        text-align: center;
        /* center all text inside item */
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
    }

    .book-catagories-items .book-thumb img,
    .book-catagories-items .category-icon {
        width: 150px;
        height: 200px;
        object-fit: cover;
        display: block;
        margin: 0 auto;
    }

    .book-catagories-items .book-box {
        text-align: center;
        margin-top: 5px;
        font-weight: 500;
    }

    .book-catagories-items .book-content h6 {
        margin-top: 10px;
    }

    .book-catagories-items .book-content h6 a {
        display: inline-block;
        text-align: center;
    }
</style>



<?php

$getProducts = $this->db->query("SELECT * FROM `yn_ecom_products` WHERE p_sale_status = '3' ORDER BY p_id DESC LIMIT 6");
$prod3 = $getProducts->result_array();
?>

<section class="shop-section section-padding fix pt-0" style="margin-top: 50px;">
    <div class="container">
        <div class="section-title-area d-flex justify-content-between align-items-center">
            <div class="section-title">
                <h2 class="wow fadeInUp" data-wow-delay=".3s">Popular Books</h2>
            </div>
            <a href="<?= base_url('shop') ?>" class="theme-btn style-2 fadeInUp" data-wow-delay=".5s">
                Explore More <i class="fa-solid fa-arrow-right-long"></i>
            </a>
        </div>


        <div class="row popular-books-row g-2">
            <?php if (!empty($prod3)): ?>
                <?php foreach ($prod3 as $pro):
                    $url = base_url('product') . '/' . $pro['p_id'] . '/' . url_smart($pro['p_name']);
                    $cat = $this->db->query("SELECT name FROM yn_site_catagory WHERE ctid = ?", [$pro['p_category']])->row_array();
                ?>
                    <div class="col-6 col-md-4 col-lg-3">
                        <div class="shop-box-items style-2 h-100">
                            <div class="book-thumb center">
                                <a href="<?= $url ?>">
                                    <img src="<?= base_url('assets/avator/upload/' . $pro['p_cover']) ?>"
                                        alt="<?= htmlspecialchars($pro['p_name']) ?>">
                                </a>
                                <ul class="post-box">
                                    <?php if ($pro['p_mrp'] > $pro['p_price']): ?>
                                        <li>
                                            -<?= round((($pro['p_mrp'] - $pro['p_price']) / $pro['p_mrp']) * 100) ?>%
                                        </li>
                                    <?php endif; ?>
                                </ul>
                                <ul class="shop-icon d-grid justify-content-center align-items-center">
                                    <li>
                                        <?php
                                        $user_id = $_SESSION['yid'] ?? 0;
                                        $is_wishlist = 0;
                                        if ($user_id) {
                                            $check = $this->db->query("SELECT * FROM wishlist WHERE user_id = ? AND product_id = ?", [$user_id, $pro['p_id']])->row_array();
                                            $is_wishlist = $check ? 1 : 0;
                                        }
                                        ?>
                                        <a href="javascript:void(0);"
                                            class="wishlist-btn"
                                            data-product="<?= $pro['p_id'] ?>">
                                            <i class="fa-<?= $is_wishlist ? 'solid' : 'regular' ?> fa-heart"></i>
                                        </a>
                                    </li>
                                </ul>

                            </div>
                            <div class="shop-content">
                                <h5><?= !empty($cat['name']) ? $cat['name'] : 'General' ?></h5>
                                <h3>
                                    <a href="<?= $url ?>"><?= htmlspecialchars($pro['p_name']) ?></a>
                                </h3>
                                <ul class="price-list">
                                    <li>₹<?= number_format($pro['p_price'], 2) ?></li>
                                    <?php if ($pro['p_mrp'] > $pro['p_price']): ?>
                                        <li><del>₹<?= number_format($pro['p_mrp'], 2) ?></del></li>
                                    <?php endif; ?>
                                </ul>
                                <ul class="author-post">
                                    <li class="authot-list">
                                        <span class="content"><?= htmlspecialchars($pro['p_author'] ?? $pro['p_vendor']) ?></span>
                                    </li>
                                </ul>
                                <div class="rating-line">
                                    <div class="star">
                                        <?php for ($i = 1; $i <= 5; $i++): ?>
                                            <i class="fa-<?= $i <= $pro['p_star'] ? 'solid' : 'regular' ?> fa-star"></i>
                                        <?php endfor; ?>
                                    </div>
                                </div>
                            </div>
                            <div class="shop-button">
                                <a href="<?= $url ?>" class="theme-btn">Buy Now</a>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </div>
</section>



<!-- Cta Banner Section start  -->
<section class="cta-banner-section fix section-padding pt-0">
    <div class="container">
        <div class="cta-banner-wrapper section-padding bg-cover"
            style="background-image: url('https://w7.pngwing.com/pngs/413/139/png-transparent-books-background-books-retro-library.png');" style="background: linear-gradient(rgba(0,0,0,0.6), rgba(0,0,0,0.3));
" ;>
            <div class="book-shape">
                <img src="<?= base_url('assets/theme/theme/') ?>assets/img/cta-book-2.png" alt="shape-img">
            </div>
            <div class="book-shape-2">
                <img src="<?= base_url('assets/theme/theme/') ?>assets/img/cta-book.png" alt="shape-img">
            </div>
            <div class="cta-content text-center">
                <span class="wow fadeInUp" data-wow-delay=".2s">Get 25% <img src="<?= base_url('assets/theme/theme/') ?>assets/img/line-shape.png" alt=""></span>
                <h2 class="mb-40 wow fadeInUp" data-wow-delay=".4s">discount
                    in all <br> kind of
                    super Selling</h2>
                <a href="<?= base_url('shop') ?>" class="theme-btn wow fadeInUp" data-wow-delay=".6s">Shop Now<i class="fa-solid fa-arrow-right-long"></i></a>
            </div>
        </div>
    </div>
</section>

<!-- Top Ratting Book Section start  -->
<section class="top-ratting-book-section fix section-padding bg-cover"
    style="background-image: linear-gradient(#E8F6FE), url('<?= base_url('assets/theme/theme/') ?>assets/img/news/bg.jpg'); background-size: cover; background-position: center;">
    <div class="container">
        <div class="top-ratting-book-wrapper">
            <div class="section-title-area">
                <div class="section-title">
                    <h2 class="wow fadeInUp" data-wow-delay=".3s">Top Selling Books</h2>
                </div>
                <a href="<?= base_url('shop') ?>" class="theme-btn wow fadeInUp" data-wow-delay=".5s">
                    View More Books
                    <i class="fa-solid fa-arrow-right-long"></i>
                </a>
            </div>

            <div class="row">
                <?php foreach ($prod5 as $pro):
                    $url = base_url('product') . '/' . $pro['p_id'] . '/' . url_smart($pro['p_name']);
                    $cat = $this->db->query("SELECT name FROM yn_site_catagory WHERE ctid = ?", [$pro['p_category']])->row_array();
                    $author = $this->db->query("SELECT * FROM yn_site_img WHERE img_head = ? AND img_place='partner' LIMIT 1", [$pro['p_vendor']])->row_array();
                ?>
                    <div class="col-xl-6 wow fadeInUp" data-wow-delay=".3s">
                        <div class="top-ratting-box-items">
                            <div class="book-thumb">
                                <a href="<?= $url ?>">
                                    <img src="<?= base_url('assets/avator/upload/' . $pro['p_cover']) ?>" alt="<?= htmlspecialchars($pro['p_name']) ?>">
                                </a>
                            </div>
                            <div class="book-content">
                                <div class="title-header d-flex justify-content-between align-items-center">
                                    <div>
                                        <h5><?= !empty($cat['name']) ? htmlspecialchars($cat['name']) : 'Book' ?></h5>
                                        <h3><a href="<?= $url ?>"><?= htmlspecialchars($pro['p_name']) ?></a></h3>
                                    </div>
                                    <ul class="shop-icon d-grid justify-content-center align-items-center">
                                        <li>
                                            <?php
                                            // Check if user is logged in
                                            $user_id = $_SESSION['yid'] ?? 0;
                                            $is_wishlist = 0;
                                            if ($user_id) {
                                                $check = $this->db->query("SELECT * FROM wishlist WHERE user_id = ? AND product_id = ?", [$user_id, $pro['p_id']])->row_array();
                                                $is_wishlist = $check ? 1 : 0;
                                            }
                                            ?>
                                            <a href="javascript:void(0);"
                                                class="wishlist-btn"
                                                data-product="<?= $pro['p_id'] ?>">
                                                <i class="fa-<?= $is_wishlist ? 'solid' : 'regular' ?> fa-heart"></i>
                                            </a>
                                        </li>


                                        <li>
                                            <a href="<?= $url ?>"><i class="far fa-eye"></i></a>
                                        </li>
                                    </ul>
                                </div>

                                <span class="mt-10">₹<?= number_format($pro['p_price'], 2) ?></span>

                                <ul class="author-post">
                                    <li class="authot-list">
                                        <span class="content mt-10"><?= htmlspecialchars($author['img_head'] ?? $pro['p_vendor']) ?></span>
                                    </li>
                                    <li class="star">
                                        <?php for ($i = 1; $i <= 5; $i++): ?>
                                            <i class="fa-<?= $i <= $pro['p_star'] ? 'solid' : 'regular' ?> fa-star"></i>
                                        <?php endfor; ?>
                                    </li>
                                </ul>

                                <div class="shop-btn d-flex justify-content-between align-items-center">
                                    <a href="<?= $url ?>" class="theme-btn">Buy Now</a>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
</section>


<!-- Shop Section start  -->
<!-- <section class="shop-section section-padding fix">
    <div class="container">
        <div class="section-title-area">
            <div class="section-title wow fadeInUp" data-wow-delay=".3s">
                <h2>Top Selling Books</h2>
            </div>
            <a href="<?= base_url('shop') ?>" class="theme-btn style-2 wow fadeInUp" data-wow-delay=".5s">
                Explore More <i class="fa-solid fa-arrow-right-long"></i>
            </a>
        </div>

        <div class="book-shop-wrapper">
            <?php foreach ($prod4 as $pro):
                $url = base_url('product') . '/' . $pro['p_id'] . '/' . url_smart($pro['p_name']);
                $cat = $this->db->query("SELECT name FROM yn_site_catagory WHERE ctid = ?", [$pro['p_category']])->row_array();
                $author = $this->db->query("SELECT * FROM yn_site_img WHERE img_head = ? AND img_place='partner' LIMIT 1", [$pro['p_vendor']])->row_array();
            ?>
                <div class="shop-box-items style-2 wow fadeInUp" data-wow-delay=".3s">
                    <div class="book-thumb center">
                        <a href="<?= $url ?>">
                            <img src="<?= base_url('assets/avator/upload/' . $pro['p_cover']) ?>" alt="<?= htmlspecialchars($pro['p_name']) ?>">
                        </a>
                        <ul class="shop-icon d-grid justify-content-center align-items-center">
                            <li>
                                <a href="javascript:void(0);" class="wishlist-btn" data-product="<?= $pro['p_id'] ?>"><i class="far fa-heart"></i></a>
                            </li>

                            <li>
                                <a href="<?= $url ?>"><i class="far fa-eye"></i></a>
                            </li>
                        </ul>
                    </div>

                    <div class="shop-content">
                        <h5><?= !empty($cat['name']) ? htmlspecialchars($cat['name']) : 'Book' ?></h5>
                        <h3><a href="<?= $url ?>"><?= htmlspecialchars($pro['p_name']) ?></a></h3>

                        <ul class="price-list">
                            <li>$<?= number_format($pro['p_price'], 2) ?></li>
                            <?php if ($pro['p_mrp'] > $pro['p_price']): ?>
                                <li><del>$<?= number_format($pro['p_mrp'], 2) ?></del></li>
                            <?php endif; ?>
                        </ul>

                        <ul class="author-post">
                            <li class="authot-list">
                                <span class="content">(Author) <?= htmlspecialchars($author['img_head'] ?? $pro['p_vendor']) ?></span>
                            </li>
                            <li class="star">
                                <?php for ($i = 1; $i <= 5; $i++): ?>
                                    <i class="fa-<?= $i <= $pro['p_star'] ? 'solid' : 'regular' ?> fa-star"></i>
                                <?php endfor; ?>
                            </li>
                        </ul>
                    </div>

                    <div class="shop-button">
                        <a href="<?= $url ?>" class="theme-btn">Buy Now</a>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section> -->


<!-- Testimonial Section start  -->
<section class="testimonial-section fix section-padding pt-0">
    <div class="container">
        <div class="section-title text-left">
            <h2 class="mb-3 wow fadeInUp mt-5" data-wow-delay=".3s">What our client say</h2>
        </div>

        <div class="swiper testimonial-slider">
            <div class="swiper-wrapper">
                <?php
                // Fetch testimonials dynamically
                $testimonials = get_web_elements('testi', '1', '10'); // Adjust the limit as needed
                foreach ($testimonials as $testimonial):
                    // Optional: fetch logo if dynamic, else use default
                ?>
                    <div class="swiper-slide">
                        <div class="testimonial-card-items">
                            <p><?= htmlspecialchars($testimonial['text']) ?></p>
                            <div class="client-info-wrapper d-flex align-items-center justify-content-between">
                                <div class="client-info">
                                    <div class="client-img bg-cover" style="background-image: url('<?= base_url('assets/avator/webimg/t/' . $testimonial['image']) ?>');">
                                        <div class="icon">
                                            <img class="shape" src="<?= base_url('assets/theme/theme/assets/img/testimonial/shape.svg') ?>" alt="img">
                                        </div>
                                    </div>
                                    <div class="content">
                                        <h3><?= htmlspecialchars($testimonial['name']) ?></h3>
                                        <span><?= htmlspecialchars($testimonial['designation'] ?? '') ?></span>
                                        <div class="star">
                                            <?php for ($i = 1; $i <= 5; $i++): ?>
                                                <i class="fa-<?= $i <= $testimonial['star'] ? 'solid' : 'regular' ?> fa-star"></i>
                                            <?php endfor; ?>
                                        </div>
                                    </div>
                                </div>


                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
</section>


<!-- Team Section start  -->
<?php
// Fetch featured authors
$limit1 = 0; // starting index
$limit2 = 10; // number of authors to display
$get_authors = $this->db->query("SELECT * FROM yn_site_img WHERE img_place = 'partner' AND img_status='1' ORDER BY img_sort DESC LIMIT ?, ?", [$limit1, $limit2]);
$all_authors = $get_authors->result_array();
?>

<style>
    .team-box-items .team-image .thumb img {
        width: 150px;

        height: 150px;
        object-fit: cover;

        border-radius: 50%;

    }
</style>

<section class="team-section fix section-padding pt-0 margin-bottom-30">
    <div class="container">
        <div class="section-title text-center">
            <h2 class="mb-3 wow fadeInUp" data-wow-delay=".3s">Featured Author</h2>
            <p class="wow fadeInUp" data-wow-delay=".5s">
                Discover inspiring stories and insights from our featured authors. Their works open new perspectives and offer<br>
                a wealth of knowledge for every reader.
            </p>
        </div>

        <div class="array-button">
            <button class="array-prev"><i class="fal fa-arrow-left"></i></button>
            <button class="array-next"><i class="fal fa-arrow-right"></i></button>
        </div>

        <div class="swiper team-slider">
            <div class="swiper-wrapper">
                <?php foreach ($all_authors as $author): ?>
                    <div class="swiper-slide">
                        <div class="team-box-items">
                            <div class="team-image">
                                <div class="thumb">
                                    <img src="<?= base_url('assets/avator/upload/' . $author['img_name']) ?>" alt="<?= htmlspecialchars($author['img_head']) ?>">
                                </div>
                                <div class="shape-img">
                                    <img src="<?= base_url('assets/theme/theme/assets/img/team/shape-img.png') ?>" alt="img">
                                </div>
                            </div>
                            <div class="team-content text-center">
                                <h6>
                                    <a href="<?= htmlspecialchars($author['img_link'] ?: '#') ?>">
                                        <?= htmlspecialchars($author['img_head']) ?>
                                    </a>
                                </h6>
                                <p><?= trim_text(strip_tags($author['img_text']), '50') ?> Published Books</p>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
</section>


<!-- News Section start  -->
<section class="news-section fix section-padding bg-cover"
    style="background-image: linear-gradient(#E8F6FE), url('<?= base_url('assets/theme/theme/') ?>assets/img/news/bg.jpg'); background-size: cover; background-position: center;">
    <div class="container">
        <div class="section-title text-center">
            <h2 class="mb-3 wow fadeInUp" data-wow-delay=".3s">Our Latest News</h2>
            <p class="wow fadeInUp" data-wow-delay=".5s">
                Stay updated with the latest news and insights from the world of books and authors.
                Discover new releases <br>, author interviews, and trending stories that keep you informed and inspired
            </p>
        </div>

        <div class="row">
            <?php
            $get_blogs = $this->db->query("SELECT * FROM yn_site_blogs ORDER BY blog_id DESC LIMIT 8");
            $blogs = $get_blogs->result_array();
            foreach ($blogs as $blog):
                $url = base_url('blog/' . url_smart($blog['slug']));
            ?>
                <div class="col-xl-3 col-lg-4 col-md-6 wow fadeInUp" data-wow-delay=".2s" style="margin-bottom:10px;">
                    <!-- wrap the card in anchor -->
                    <a href="<?= $url ?>" class="news-card-link" style="text-decoration:none; color:inherit; display:block;">
                        <div class="news-card-items">
                            <div class="news-image">
                                <img src="<?= base_url('assets/avator/upload/' . $blog['blog_img']) ?>"
                                    alt="<?= htmlspecialchars($blog['title']) ?>"
                                    style="width:100%; height:250px; object-fit:cover;">
                                <img src="<?= base_url('assets/avator/upload/' . $blog['blog_img']) ?>"
                                    alt="<?= htmlspecialchars($blog['title']) ?>"
                                    style="width:100%; height:250px; object-fit:cover;">
                                <!-- <div class="post-box">
                                    <?= htmlspecialchars($blog['tags']) ?>
                                </div> -->
                            </div>

                            <div class="news-content">
                                <ul>
                                    <li>
                                        <i class="fa-light fa-calendar-days"></i>
                                        <?= date_format_1($blog['blog_time'], 'alpha_date'); ?>
                                    </li>
                                    <li>
                                        <i class="fa-regular fa-user"></i>
                                        By <?= htmlspecialchars($blog['author'] ?? 'Admin') ?>
                                    </li>
                                </ul>
                                <h3><?= htmlspecialchars($blog['title']) ?></h3>
                                <p><?= trim_text(strip_tags($blog['comment']), 80, '...') ?></p>
                                <span class="theme-btn-2">Read More <i class="fa-regular fa-arrow-right-long"></i></span>
                            </div>
                        </div>
                    </a>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<!-- Feature Section start  -->
<section class="feature-section fix section-padding">
    <div class="container">
        <div class="feature-wrapper">
            <div class="feature-box-items wow fadeInUp" data-wow-delay=".2s">
                <div class="icon">
                    <i class="icon-icon-1"></i>
                </div>
                <div class="content">
                    <h3>Return & refund</h3>
                    <p>Money back guarantee</p>
                </div>
            </div>
            <div class="feature-box-items wow fadeInUp" data-wow-delay=".4s">
                <div class="icon">
                    <i class="fa-solid fa-shield-halved"></i>

                </div>
                <div class=" content">
                    <h3>Secure Payment</h3>
                    <p>30% off by subscribing</p>
                </div>
            </div>
            <div class="feature-box-items wow fadeInUp" data-wow-delay=".6s">
                <div class="icon">
                    <i class="icon-icon-3"></i>
                </div>
                <div class="content">
                    <h3>Quality Support</h3>
                    <p>Always online 24/7</p>
                </div>
            </div>
            <div class="feature-box-items wow fadeInUp" data-wow-delay=".8s">
                <div class="icon">
                    <i class="icon-icon-4"></i>
                </div>
                <div class="content">
                    <h3>Daily Offers</h3>
                    <p>20% off by subscribing</p>
                </div>
            </div>
        </div>
    </div>
</section>
<style>
    .wishlist-modal {
        display: none;
        position: fixed;
        z-index: 9999;
        left: 0;
        top: 0;
        width: 100%;
        height: 100%;
        overflow-y: auto;
        /* allow scrolling */
        background: rgba(0, 0, 0, 0.5);
        padding: 20px;
        /* optional for spacing */
    }

    .wishlist-content {
        background: #fff;
        width: 400px;
        max-width: 90%;
        margin: 50px auto;
        /* margin top & bottom */
        border-radius: 10px;
        overflow: hidden;
        position: relative;
    }

    .swal2-container {
        z-index: 10000 !important;
    }
</style>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    $(document).ready(function() {
        $('.wishlist-btn').click(function() {
            var product_id = $(this).data('product');
            var btn = $(this);

            <?php if (!isset($_SESSION['yid'])): ?>
                // If not logged in, redirect to login
                window.location.href = "<?= base_url('login') ?>";
                return;
            <?php endif; ?>

            $.ajax({
                url: "<?= base_url('index.php/action/wishlist_toggle') ?>",
                type: "POST",
                data: {
                    product_id: product_id
                },
                dataType: "json",
                success: function(res) {
                    if (res.status === 'added') {
                        btn.find('i').removeClass('fa-regular').addClass('fa-solid');
                        Swal.fire({
                            toast: true,
                            position: 'top-end',
                            icon: 'success',
                            title: 'Added to wishlist',
                            showConfirmButton: false,
                            timer: 1500,
                            timerProgressBar: true
                        });
                    } else if (res.status === 'removed') {
                        btn.find('i').removeClass('fa-solid').addClass('fa-regular');
                        Swal.fire({
                            toast: true,
                            position: 'top-end',
                            icon: 'info',
                            title: 'Removed from wishlist',
                            showConfirmButton: false,
                            timer: 1500,
                            timerProgressBar: true
                        });
                    }

                    // Update header count
                    $('.header-icon .number').text(res.count);
                },
                error: function() {
                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: 'Something went wrong!'
                    });
                }
            });
        });
    });
</script>