<div class="container p-0">
  <div class="row p-0">
    <div class="col-12">
      <h3>Study Material Enrollments</h3><br />
      <?php
      if (count(@$enrollments)) { ?>
        <div class="col-12 m-0 p-0">
          <table class="table table-striped">
            <thead>
              <tr>
                <th># / Study Material Name</th>
                <!-- <th>Start Date</th>  -->
                <th>End Date</th>
                <th>Details</th>
                <th>&nbsp;</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach ($enrollments as $enrollment) {
                $thecourse_url = base_url('course_detail/') . $enrollment['co_course_id'] . '/' . url_smart($enrollment['course_name']); ?>
                <tr>
                  <td><a href="<?= base_url('viewEnrollment') ?>?enrol=<?= $enrollment['co_id'] ?>"><?= $enrollment['co_order_id'] ?></a><br><a href="<?= $thecourse_url ?>" style="color: #3156F6;"><?= $enrollment['course_name'] ?></a></td>
                  <!-- <td><small><?= date_format_1($enrollment['co_start_date'], '1') ?></small></td> -->
                  <td><small><?= date_format_1($enrollment['co_end_date'], '1') ?><br /></small></td>
                  <td>
                    <span class="pill bg-primary badge"><?= strip_tags(read_me_user('cpay', $enrollment['co_payment_status'])) ?><br></span>
                    <span class="pill bg-secondary badge"><?= strip_tags(read_me_user('test_status', $enrollment['co_status'])) ?></span>
                  </td>
                  <td><a href="<?= base_url('viewEnrollment') ?>?enrol=<?= $enrollment['co_id'] ?>" class='btn  btn-block' style="background-color:#0C8ACF;color:white;">Access Material </a> </td>
                </tr>
              <?php } ?>
            </tbody>
          </table>
        </div>
      <?php } else {
        echo "You haven't Enrolled YET in any Course.<br><a href='" . base_url('search') . "' style='color: #0C8ACF'>Choose your course and Enroll</a>";
      } ?>
    </div>
  </div>
</div>