<?php
$p_category = $pro['p_category'];

// Get category name
$thecats = $this->db->query("SELECT * FROM yn_site_catagory WHERE ctid ='$p_category'");
$the_cats = $thecats->row_array();
$category_name = !empty($the_cats['ctname']) ? $the_cats['ctname'] : 'General';

// Get author (assuming author stored in p_vendor)
$author_name = !empty($pro['p_vendor']) ? $pro['p_vendor'] : 'Unknown Author';
?>


<div class="swiper-slide" style="margin-bottom: 200px;">
    <div class="shop-box-items style-2">
        <div class="book-thumb center">
            <a href="<?= base_url('product/' . $pro['p_id'] . '/' . url_smart($pro['p_name'])) ?>">
                <img src="<?= base_url('assets/avator/upload/' . $pro['p_cover']) ?>" alt="<?= $pro['p_name'] ?>">
            </a>
            <?php if (!empty($pro['p_tag'])): ?>
                <ul class="post-box">
                    <li><?= $pro['p_tag'] ?></li>
                </ul>
            <?php endif; ?>
            <ul class="shop-icon d-grid justify-content-center align-items-center">
                <li>
                    <a href="javascript:void(0);" class="wishlist-btn" data-product="<?= $pro['p_id'] ?>">
                        <i class="far fa-heart"></i>
                    </a>
                </li>

                <li>
                    <a href="<?= base_url('product/' . $pro['p_id'] . '/' . url_smart($pro['p_name'])) ?>"><i class="far fa-eye"></i></a>
                </li>
            </ul>
        </div>

        <div class="shop-content">
            <!-- Category Name -->
            <?php
            // Fetch category name
            $cat = $this->db->query("SELECT name FROM yn_site_catagory WHERE ctid = ?", [$pro['p_category']])->row_array();
            $category_name = !empty($cat['name']) ? $cat['name'] : 'Book';

            // Author (either from $author['img_head'] or fallback to vendor field)
            $author_name = !empty($author['img_head']) ? $author['img_head'] : (!empty($pro['p_vendor']) ? $pro['p_vendor'] : 'Unknown Author');

            // Product URL
            $url = base_url('product/' . $pro['p_id'] . '/' . url_smart($pro['p_name']));
            ?>

            <h5><?= htmlspecialchars($category_name) ?></h5>

            <!-- Book Title -->
            <h3>
                <a href="<?= base_url('product/' . $pro['p_id'] . '/' . url_smart($pro['p_name'])) ?>">
                    <?= trim_text($pro['p_name'], 50) ?>
                </a>
            </h3>

            <!-- Price -->
            <ul class="price-list">
                <li>₹<?= $pro['p_price'] ?></li>
                <?php if (!empty($pro['p_old_price'])): ?>
                    <li><del>₹<?= $pro['p_old_price'] ?></del></li>
                <?php endif; ?>
            </ul>

            <!-- Author -->
            <ul class="author-post">
                <li class="authot-list">

                    <span class="content"><?= $author_name ?></span>
                </li>
                <li class="star">
                    <?= ratings_star($pro['p_star'], 'star', '20px') ?>
                </li>
            </ul>
        </div>

        <div class="shop-button">
            <a href="<?= base_url('product/' . $pro['p_id'] . '/' . url_smart($pro['p_name'])) ?>" class="theme-btn">Buy Now</a>
        </div>
    </div>
</div>

<script>
    function updateWishlistCount(count) {
        const badge = document.querySelector('.header-icon .number');
        if (count > 0) {
            if (badge) {
                badge.textContent = count;
            } else {
                // Create badge if it doesn't exist
                const icon = document.querySelector('.header-icon a i.fa-heart');
                const span = document.createElement('span');
                span.className = 'number';
                span.textContent = count;
                icon.parentNode.appendChild(span);
            }
        } else {
            if (badge) badge.remove(); // remove badge if count is 0
        }
    }

    $(document).ready(function() {

        function updateWishlistModal() {
            $.ajax({
                url: '<?= base_url("index.php/action/get_wishlist_modal") ?>',
                type: 'GET',
                success: function(html) {
                    $('#wishlistModal .wishlist-items').html(html);
                    let count = $('#wishlistModal .wishlist-items li').length;
                    count = $('#wishlistModal .wishlist-items li:contains("empty")').length ? 0 : count;
                    $('.header-icon .number').text(count);
                }
            });
        }

        // Initial load
        updateWishlistModal();

        // Toggle wishlist
        $(document).on('click', '.wishlist-btn', function() {
            var product_id = $(this).data('product');
            if (!product_id) {
                console.error('Product ID missing!');
                return;
            }
            var $btn = $(this);

            $.ajax({
                url: '<?= base_url("index.php/action/toggle_wishlist") ?>',
                type: 'POST',
                data: {
                    product_id: product_id
                },
                dataType: 'json',
                success: function(response) {
                    var $count = $('.header-icon .number');
                    var currentCount = parseInt($count.text()) || 0;

                    if (response.status === 'added') {
                        $btn.find('i').removeClass('far').addClass('fas');
                        updateWishlistModal();
                        $count.text(currentCount + 1);
                    } else if (response.status === 'removed') {
                        $btn.find('i').removeClass('fas').addClass('far');
                        updateWishlistModal();
                        $count.text(Math.max(0, currentCount - 1));
                    } else if (response.status === 'no_user') {
                        alert('Please log in to add wishlist.');
                    }
                },
                error: function(xhr, status, error) {
                    console.error('AJAX error:', status, error);
                }
            });
        });

        // Remove from wishlist modal
        $(document).on('click', '.remove-wishlist-item', function() {
            var $li = $(this).closest('li');
            var product_id = $li.data('id');

            $.ajax({
                url: '<?= base_url("index.php/action/toggle_wishlist") ?>',
                type: 'POST',
                data: {
                    product_id: product_id
                },
                dataType: 'json',
                success: function(response) {
                    if (response.status === 'removed') {
                        $li.remove();
                        if ($('#wishlistModal .wishlist-items li').length === 0) {
                            $('#wishlistModal .wishlist-items').html('<li>Your wishlist is empty.</li>');
                        }
                        var $count = $('.header-icon .number');
                        var currentCount = parseInt($count.text()) || 0;
                        $count.text(Math.max(0, currentCount - 1));
                        $('.wishlist-btn[data-product="' + product_id + '"] i').removeClass('fas').addClass('far');
                    }
                }
            });
        });

    });
</script>