<div class="breadcrumb-wrapper bg-cover section-padding"
    style="background: linear-gradient(#E8F6FE), 
                     url('<?= base_url('assets/theme/theme/') ?>assets/img/hero/banner.jpg'); 
            background-size: cover;
            background-position: center;">

    <div class="container">
        <div class="page-heading">
            <h1>Live Class Details</h1>
            <div class="page-header">
                <ul class="breadcrumb-items wow fadeInUp" data-wow-delay=".3s">
                    <li><a href="<?= base_url() ?>">Home</a></li>
                    <li><a href="<?= base_url('profile') ?>">Profile</a></li>
                    <li>Live Class Details</li>
                </ul>
            </div>
        </div>
    </div>
</div>

<section class="live-class-detail-section py-5" style="background: #f5f7fa; min-height: 60vh;">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 mx-auto">
                <div class="card shadow-lg border-0">
                    <div class="card-header bg-primary text-white py-4">
                        <div class="d-flex justify-content-between align-items-start">
                            <div>
                                <h4 class="mb-2"><?= htmlspecialchars($live_class['lc_title']) ?></h4>
                                <?php if (!empty($live_class['study_material_name'])): ?>
                                    <p class="mb-0 text-white-50">
                                        <i class="fas fa-book me-2"></i><?= htmlspecialchars($live_class['study_material_name']) ?>
                                    </p>
                                <?php endif; ?>
                            </div>
                            <div class="text-end">
                                <?php if ($is_upcoming): ?>
                                    <span class="badge bg-success fs-6 px-3 py-2">
                                        <?= $is_today ? 'Today' : 'Upcoming' ?>
                                    </span>
                                <?php elseif ($is_ongoing): ?>
                                    <span class="badge bg-warning text-dark fs-6 px-3 py-2">Ongoing</span>
                                <?php else: ?>
                                    <span class="badge bg-secondary fs-6 px-3 py-2">Past</span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    
                    <div class="card-body p-4">
                        <?php if (!empty($live_class['lc_description'])): ?>
                            <div class="mb-4">
                                <h6 class="text-primary mb-3"><i class="fas fa-info-circle me-2"></i>Description</h6>
                                <p class="text-muted"><?= nl2br(htmlspecialchars($live_class['lc_description'])) ?></p>
                            </div>
                        <?php endif; ?>

                        <div class="row mb-4">
                            <div class="col-md-6 mb-3">
                                <div class="info-box p-3 bg-light rounded">
                                    <h6 class="text-primary mb-2"><i class="fas fa-calendar-alt me-2"></i>Date</h6>
                                    <p class="mb-0 fs-5"><strong><?= date_format_1($live_class['lc_date'], '1') ?></strong></p>
                                </div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <div class="info-box p-3 bg-light rounded">
                                    <h6 class="text-primary mb-2"><i class="fas fa-clock me-2"></i>Time</h6>
                                    <p class="mb-1">
                                        <strong>Start:</strong> <?= date('h:i A', strtotime($live_class['lc_start_time'])) ?>
                                    </p>
                                    <p class="mb-0">
                                        <strong>End:</strong> <?= date('h:i A', strtotime($live_class['lc_end_time'])) ?>
                                    </p>
                                </div>
                            </div>
                        </div>

                        <?php if (!empty($live_class['course_name'])): ?>
                            <div class="mb-4">
                                <h6 class="text-primary mb-2"><i class="fas fa-graduation-cap me-2"></i>Course</h6>
                                <p class="mb-0"><?= htmlspecialchars($live_class['course_name']) ?></p>
                            </div>
                        <?php endif; ?>

                        <?php if (!empty($recorded_videos)): ?>
                            <div class="mb-4">
                                <h6 class="text-primary mb-3"><i class="fas fa-video me-2"></i>Recorded Videos (<?= count($recorded_videos) ?>)</h6>
                                <div class="row g-3">
                                    <?php foreach ($recorded_videos as $index => $video): 
                                        $video_path = !empty($video['smv_video_url']) ? $video['smv_video_url'] : '';
                                        if (!empty($video_path) && strpos($video_path, 'http') !== 0) {
                                            $video_url = base_url($video_path);
                                        } else {
                                            $video_url = $video_path;
                                        }
                                    ?>
                                        <div class="col-md-6">
                                            <div class="card recorded-video-card border" style="border-radius: 8px; overflow: hidden; transition: all 0.3s;">
                                                <div class="video-thumbnail-wrapper" style="position: relative; padding-bottom: 56.25%; background: #000; cursor: pointer;" onclick="playVideoLC(<?= $index ?>)">
                                                    <video id="video-lc-<?= $index ?>" style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; display: none;" controls>
                                                        <source src="<?= $video_url ?>" type="video/mp4">
                                                        Your browser does not support the video tag.
                                                    </video>
                                                    <div class="video-placeholder-lc" style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; display: flex; align-items: center; justify-content: center; background: linear-gradient(135deg, #098FD9, #0B8CD4);">
                                                        <i class="fas fa-play-circle" style="font-size: 48px; color: white; opacity: 0.9;"></i>
                                                    </div>
                                                </div>
                                                <div class="card-body p-3">
                                                    <h6 class="card-title mb-2" style="font-size: 14px; font-weight: 600; color: #333;">
                                                        <?= htmlspecialchars($video['smv_title']) ?>
                                                    </h6>
                                                    <?php if (!empty($video['smv_description'])): ?>
                                                        <p class="card-text small text-muted mb-0" style="display: -webkit-box; -webkit-line-clamp: 2; -webkit-box-orient: vertical; overflow: hidden;">
                                                            <?= htmlspecialchars(strip_tags($video['smv_description'])) ?>
                                                        </p>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        <?php endif; ?>

                        <?php if (!empty($live_class['lc_zoom_link'])): ?>
                            <div class="mb-4">
                                <h6 class="text-primary mb-3"><i class="fas fa-video me-2"></i>Meeting Information</h6>
                                
                                <div class="zoom-info-box p-4 bg-light rounded mb-3">
                                    <div class="mb-3">
                                        <label class="text-muted small">Meeting Link:</label>
                                        <div class="input-group">
                                            <input type="text" class="form-control" id="zoom_link" 
                                                   value="<?= htmlspecialchars($live_class['lc_zoom_link']) ?>" readonly>
                                            <button class="btn btn-outline-primary" onclick="copyToClipboard('zoom_link')">
                                                <i class="fas fa-copy"></i> Copy
                                            </button>
                                        </div>
                                    </div>

                                    <?php if (!empty($live_class['lc_zoom_id'])): ?>
                                        <div class="mb-3">
                                            <label class="text-muted small">Meeting ID:</label>
                                            <div class="input-group">
                                                <input type="text" class="form-control" id="zoom_id" 
                                                       value="<?= htmlspecialchars($live_class['lc_zoom_id']) ?>" readonly>
                                                <button class="btn btn-outline-primary" onclick="copyToClipboard('zoom_id')">
                                                    <i class="fas fa-copy"></i> Copy
                                                </button>
                                            </div>
                                        </div>
                                    <?php endif; ?>

                                    <?php if (!empty($live_class['lc_zoom_password'])): ?>
                                        <div>
                                            <label class="text-muted small">Meeting Password:</label>
                                            <div class="input-group">
                                                <input type="text" class="form-control" id="zoom_password" 
                                                       value="<?= htmlspecialchars($live_class['lc_zoom_password']) ?>" readonly>
                                                <button class="btn btn-outline-primary" onclick="copyToClipboard('zoom_password')">
                                                    <i class="fas fa-copy"></i> Copy
                                                </button>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>

                                <?php if ($is_upcoming || $is_ongoing): ?>
                                    <div class="text-center">
                                        <a href="<?= htmlspecialchars($live_class['lc_zoom_link']) ?>" 
                                           target="_blank" 
                                           class="btn btn-success btn-lg px-5">
                                            <i class="fas fa-video me-2"></i> Join Live Class
                                        </a>
                                    </div>
                                <?php endif; ?>
                            </div>
                        <?php else: ?>
                            <div class="alert alert-warning">
                                <i class="fas fa-exclamation-triangle me-2"></i>
                                Meeting link will be available soon.
                            </div>
                        <?php endif; ?>
                    </div>

                    <div class="card-footer bg-light text-center py-3">
                        <a href="<?= base_url('profile') ?>#live-classes" class="btn btn-outline-primary">
                            <i class="fas fa-arrow-left me-2"></i> Back to Live Classes
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<script>
function copyToClipboard(elementId) {
    const element = document.getElementById(elementId);
    element.select();
    element.setSelectionRange(0, 99999);
    document.execCommand('copy');
    
    // Show success message
    const btn = event.target.closest('button');
    const originalHTML = btn.innerHTML;
    btn.innerHTML = '<i class="fas fa-check"></i> Copied!';
    btn.classList.remove('btn-outline-primary');
    btn.classList.add('btn-success');
    
    setTimeout(function() {
        btn.innerHTML = originalHTML;
        btn.classList.remove('btn-success');
        btn.classList.add('btn-outline-primary');
    }, 2000);
}

function playVideoLC(index) {
    const videoElement = document.getElementById('video-lc-' + index);
    const placeholder = videoElement.parentElement.querySelector('.video-placeholder-lc');
    
    if (videoElement.style.display === 'none' || videoElement.style.display === '') {
        // Show and play video
        placeholder.style.display = 'none';
        videoElement.style.display = 'block';
        videoElement.play();
    } else {
        // Hide video
        videoElement.pause();
        videoElement.style.display = 'none';
        placeholder.style.display = 'flex';
    }
}

// Pause all other videos when one is played
document.addEventListener('play', function(e) {
    const videos = document.getElementsByTagName('video');
    for (let i = 0; i < videos.length; i++) {
        if (videos[i] != e.target) {
            videos[i].pause();
            const placeholder = videos[i].parentElement.querySelector('.video-placeholder-lc');
            if (placeholder) {
                videos[i].style.display = 'none';
                placeholder.style.display = 'flex';
            }
        }
    }
}, true);
</script>

<style>
.live-class-detail-section {
    margin-bottom: 100px;
}

.info-box {
    border-left: 4px solid #0B8CD4;
}

.zoom-info-box {
    border: 1px solid #dee2e6;
}

.card-header h4 {
    font-weight: 600;
}

@media (max-width: 768px) {
    .card-header {
        flex-direction: column;
    }
    
    .card-header .text-end {
        text-align: left !important;
        margin-top: 1rem;
    }
}

.recorded-video-card {
    transition: transform 0.3s, box-shadow 0.3s;
}

.recorded-video-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 4px 12px rgba(9, 143, 217, 0.2);
}

.video-thumbnail-wrapper:hover .video-placeholder-lc {
    opacity: 0.8;
}
</style>

