<style>
    .first,
    .second,
    .foot,
    .the_mobile_fooeter,
    .back-to-top.show {
        display: none !important;
    }
</style>
<div class="container mt-5">
    <!-- Heading centered -->
    <h2 class="text-center mb-4"><?= $category['category_name'] ?> - Mock Test</h2>

    <div class="row">
        <!-- Left side: Current Question -->
        <div class="col-lg-8 col-md-7 col-sm-12 mb-4">
            <?php if (count($mcqs) > 0): ?>
                <form id="mcq_test_form">
                    <input type="hidden" name="category_id" value="<?= $category['category_id'] ?>">
                    <input type="hidden" id="total_questions" value="<?= count($mcqs) ?>">
                    
                    <!-- Question Container (will be populated by JavaScript) -->
                    <div id="question_container" class="card mb-4 shadow-sm question-card">
                        <!-- Question will be loaded here -->
                    </div>

                    <!-- Navigation Buttons -->
                    <div class="d-flex justify-content-between mt-4">
                        <button type="button" id="prev_btn" class="btn btn-secondary" style="display:none;">Previous</button>
                        <button type="button" id="next_btn" class="btn btn-primary ms-auto">Next</button>
                        <button type="submit" id="submit_btn" class="btn submit-btn" style="display:none;">Submit Test</button>
                    </div>
                </form>
            <?php else: ?>
                <div class="alert alert-info text-center">No questions available in this category.</div>
            <?php endif; ?>
        </div>

        <!-- Right side: Timer & Info -->
        <div class="col-lg-4 col-md-5 col-sm-12 mb-4">
            <div class="card p-3 shadow-sm info-card">
                <h5 class="mb-3 text-center">Test Info</h5>
                <p><strong>Total Questions:</strong> <span id="total_questions_display"><?= count($mcqs) ?></span></p>
                <p><strong>Current Question:</strong> <span id="current_question_num">1</span> of <span id="total_questions_display2"><?= count($mcqs) ?></span></p>
                <p><strong>Time Left:</strong> <span id="timer">30:00</span></p>
                
                <!-- Progress Bar -->
                <div class="mt-3">
                    <small class="text-muted">Progress</small>
                    <div class="progress" style="height: 8px;">
                        <div id="progress_bar" class="progress-bar bg-primary" role="progressbar" style="width: 0%"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    // Store all questions data
    const questions = <?= json_encode($mcqs) ?>;
    let currentQuestionIndex = 0;
    const answers = {}; // Store answers as user progresses
    
    // Initialize
    $(document).ready(function() {
        loadQuestion(0);
        updateNavigationButtons();
        updateProgress();
    });

    // Load a specific question
    function loadQuestion(index) {
        if (index < 0 || index >= questions.length) return;
        
        currentQuestionIndex = index;
        const q = questions[index];
        const questionNum = index + 1;
        
        let html = `
            <div class="card-header bg-light">
                <strong>Q${questionNum}:</strong> ${escapeHtml(q.question_text)}
            </div>
            <div class="card-body">
        `;
        
        const options = ['a', 'b', 'c', 'd'];
        options.forEach(opt => {
            const value = opt.toUpperCase();
            const text = q['option_' + opt] || '';
            const checked = answers[q.question_id] === value ? 'checked' : '';
            
            html += `
                <div class="form-check option-card mb-2" data-option="${value}">
                    <input class="form-check-input" type="radio" 
                           name="answers[${q.question_id}]" 
                           id="q${q.question_id}${value}" 
                           value="${value}" 
                           ${checked}
                           data-question-id="${q.question_id}">
                    <label class="form-check-label" for="q${q.question_id}${value}">
                        ${escapeHtml(text)}
                    </label>
                </div>
            `;
        });
        
        html += '</div>';
        $('#question_container').html(html);
        
        // Update current question number
        $('#current_question_num').text(questionNum);
        updateNavigationButtons();
        updateProgress();
    }

    // Make option cards clickable
    $(document).on('click', '.option-card', function(e) {
        if (!$(e.target).is('input')) {
            const radio = $(this).find('input[type=radio]');
            radio.prop('checked', true).trigger('change');
        }
    });

    // Store answer when selected
    $(document).on('change', 'input[type=radio]', function() {
        const questionId = $(this).data('question-id');
        const answer = $(this).val();
        answers[questionId] = answer;
    });

    // Previous button
    $('#prev_btn').on('click', function() {
        if (currentQuestionIndex > 0) {
            loadQuestion(currentQuestionIndex - 1);
        }
    });

    // Next button
    $('#next_btn').on('click', function() {
        if (currentQuestionIndex < questions.length - 1) {
            loadQuestion(currentQuestionIndex + 1);
        }
    });

    // Update navigation buttons visibility
    function updateNavigationButtons() {
        $('#prev_btn').toggle(currentQuestionIndex > 0);
        $('#next_btn').toggle(currentQuestionIndex < questions.length - 1);
        $('#submit_btn').toggle(currentQuestionIndex === questions.length - 1);
    }

    // Update progress bar
    function updateProgress() {
        const progress = ((currentQuestionIndex + 1) / questions.length) * 100;
        $('#progress_bar').css('width', progress + '%');
    }

    // Timer
    let totalSeconds = 30 * 60;
    const timerEl = document.getElementById('timer');
    const timerInterval = setInterval(() => {
        const minutes = Math.floor(totalSeconds / 60);
        const seconds = totalSeconds % 60;
        timerEl.textContent = `${minutes.toString().padStart(2,'0')}:${seconds.toString().padStart(2,'0')}`;
        totalSeconds--;
        if (totalSeconds < 0) {
            clearInterval(timerInterval);
            submitTest();
        }
    }, 1000);

    // Submit test
    function submitTest() {
        // Add all answers to form
        Object.keys(answers).forEach(questionId => {
            if (!$(`input[name="answers[${questionId}]"][value="${answers[questionId]}"]`).length) {
                $('#mcq_test_form').append(`<input type="hidden" name="answers[${questionId}]" value="${answers[questionId]}">`);
            }
        });
        
        // Submit form
        $.ajax({
            url: "<?= base_url('index.php/action/submit_mcq_test') ?>",
            type: "POST",
            data: $('#mcq_test_form').serialize(),
            dataType: "json",
            success: function(res) {
                if (res.status === 'success') {
                    window.location.href = "<?= base_url('index.php/main/result/') ?>" + res.submission_id;
                } else {
                    alert(res.message);
                }
            },
            error: function(err) {
                alert('Something went wrong.');
            }
        });
    }

    // Form submit handler
    $('#mcq_test_form').on('submit', function(e) {
        e.preventDefault();
        submitTest();
    });

    // Escape HTML to prevent XSS
    function escapeHtml(text) {
        const map = {
            '&': '&amp;',
            '<': '&lt;',
            '>': '&gt;',
            '"': '&quot;',
            "'": '&#039;'
        };
        return text ? text.replace(/[&<>"']/g, m => map[m]) : '';
    }
</script>

<style>
    /* Make the cursor pointer for the whole option-card */
    .option-card {
        cursor: pointer;
        border: 1px solid #e2e2e2;
        border-radius: 8px;
        padding: 10px 12px;
        transition: background 0.3s, transform 0.2s;
    }

    /* Highlight when hovering */
    .option-card:hover {
        background-color: #fdf2f2;
        transform: scale(1.02);
    }

    .option-card input[type="radio"]:checked ~ label,
    .form-check-input:checked + .form-check-label {
        font-weight: 600;
    }

    .option-card:has(input[type="radio"]:checked) {
        background-color: #FFE2E0;
        border-color: #FF7B6B;
    }

    /* Heading */
    h2 {
        font-weight: 600;
        color: #FF7B6B;
    }

    /* Card styles */
    .question-card,
    .info-card {
        border-radius: 12px;
        transition: transform 0.3s, box-shadow 0.3s;
    }

    .question-card:hover {
        transform: translateY(-3px);
        box-shadow: 0 8px 20px rgba(0, 0, 0, 0.15);
    }

    /* Timer styling */
    #timer {
        font-weight: bold;
        color: #FF7B6B;
        font-size: 1.3rem;
    }

    /* Submit button */
    .submit-btn {
        background-color: #FF7B6B;
        color: #fff;
        font-weight: 600;
        padding: 12px 30px;
        border-radius: 25px;
        transition: background 0.3s, transform 0.2s;
        border: none;
    }

    .submit-btn:hover {
        background-color: #e66b5e;
        transform: scale(1.03);
        color: #fff;
    }

    /* Navigation buttons */
    #prev_btn, #next_btn {
        padding: 10px 25px;
        border-radius: 8px;
        font-weight: 600;
    }

    #prev_btn {
        background-color: #6c757d;
        border: none;
    }

    #prev_btn:hover {
        background-color: #5a6268;
        color: #fff;
    }

    #next_btn {
        background-color: #FF7B6B;
        border: none;
        color: #fff;
    }

    #next_btn:hover {
        background-color: #e66b5e;
        color: #fff;
    }

    /* Info card */
    .info-card {
        background-color: #fff5f5;
        border: 1px solid #ffe2e0;
    }

    /* Progress bar */
    .progress {
        border-radius: 10px;
        background-color: #e9ecef;
    }

    .progress-bar {
        border-radius: 10px;
        transition: width 0.3s ease;
    }

    /* Responsive adjustments */
    @media (max-width: 992px) {
        .row {
            flex-direction: column-reverse;
        }

        .info-card {
            margin-bottom: 20px;
        }
    }
</style>