<!-- Pay Now Page -->
<main class="main-area fix">

    <!-- checkout-area -->
    <div class="checkout__area section-py-120">
        <div class="container">
            <div class="row">
                <!-- Payment Details Column -->
                <div class="col-lg-8 col-md-12 mx-auto">
                    <div class="checkout__content">
                        <div class="checkout__inner">
                            <div class="checkout__wrap">
                                <div class="checkout__block checkout__bill shadow-3 rounded-lg">
                                    <div class="checkout__block-content p-4">
                                        <div class="order__info-wrap">
                                            <h2 class="title text-center mb-4">YOUR ORDER</h2>

                                            <!-- User Details Section -->
                                            <div class="user-details mb-4">
                                                <div class="row mb-2">
                                                    <div class="col-4">
                                                        <label class="text-dark fw-bold">Name:</label>
                                                    </div>
                                                    <div class="col-8">
                                                        <span><?= @$theorder['so_name'] ?></span>
                                                    </div>
                                                </div>
                                                <div class="row mb-2">
                                                    <div class="col-4">
                                                        <label class="text-dark fw-bold">Email:</label>
                                                    </div>
                                                    <div class="col-8">
                                                        <span><?= @$theorder['so_email'] ?></span>
                                                    </div>
                                                </div>
                                                <div class="row mb-2">
                                                    <div class="col-4">
                                                        <label class="text-dark fw-bold">Phone:</label>
                                                    </div>
                                                    <div class="col-8">
                                                        <span><?= !empty($theorder['so_phone']) ? $theorder['so_phone'] : (!empty($profile_data['phone']) ? $profile_data['phone'] : (!empty($profile_data['contact']) ? $profile_data['contact'] : 'Not provided')) ?></span>
                                                    </div>
                                                </div>
                                                <div class="row mb-3">
                                                    <div class="col-4">
                                                        <label class="text-dark fw-bold">Order ID:</label>
                                                    </div>
                                                    <div class="col-8">
                                                        <span><?= !empty($theorder['so_order_id']) ? $theorder['so_order_id'] : (isset($order_id) ? $order_id : (isset($cid) ? $cid : 'N/A')) ?></span>
                                                    </div>
                                                </div>
                                                <?php if (isset($_SESSION['courseName']) && !empty($_SESSION['courseName'])): ?>
                                                    <div class="row mb-3">
                                                        <div class="col-4">
                                                            <label class="text-dark fw-bold">Course:</label>
                                                        </div>
                                                        <div class="col-8">
                                                            <span><?= htmlspecialchars($_SESSION['courseName']) ?></span>
                                                        </div>
                                                    </div>
                                                <?php elseif (isset($_SESSION['mockCategoryName']) && !empty($_SESSION['mockCategoryName'])): ?>
                                                    <div class="row mb-3">
                                                        <div class="col-4">
                                                            <label class="text-dark fw-bold">Mock Test:</label>
                                                        </div>
                                                        <div class="col-8">
                                                            <span><?= htmlspecialchars($_SESSION['mockCategoryName']) ?></span>
                                                        </div>
                                                    </div>
                                                <?php endif; ?>
                                            </div>

                                            <hr class="mb-4">

                                            <ul class="list-wrap mb-4">
                                                <li class="title d-flex justify-content-between">
                                                    <span>Item</span>
                                                    <span>Subtotal</span>
                                                </li>
                                                <?php if (isset($is_checkout_order) && $is_checkout_order && !empty($order_details)): ?>
                                                    <?php foreach ($order_details as $item): ?>
                                                        <li class="d-flex justify-content-between">
                                                            <span><?= htmlspecialchars($item['xod_title']) ?> × <?= $item['xod_qty'] ?></span>
                                                            <span>Rs.<?= number_format($item['xod_price'] * $item['xod_qty'], 2) ?></span>
                                                        </li>
                                                    <?php endforeach; ?>
                                                <?php else: ?>
                                                    <li class="d-flex justify-content-between">
                                                        <span><?= isset($_SESSION['mockCategoryName']) ? htmlspecialchars($_SESSION['mockCategoryName']) : (isset($_SESSION['courseName']) ? htmlspecialchars($_SESSION['courseName']) : 'Course Enrollment') ?> × 1</span>
                                                        <span>Rs.<?= @$theorder['so_price'] ?></span>
                                                    </li>
                                                <?php endif; ?>
                                                <li class="d-flex justify-content-between">
                                                    <span>Subtotal</span>
                                                    <span>Rs.<?= @$theorder['so_price'] ?></span>
                                                </li>
                                                <li class="d-flex justify-content-between fw-bold">
                                                    <span>Total</span>
                                                    <span>Rs.<?= @$theorder['so_price'] ?></span>
                                                </li>
                                            </ul>

                                            <p class="mb-4 text-muted small">Your personal data will be used to process your order, support your experience throughout this website, and for other purposes described in our <a href="#">privacy policy.</a></p>

                                            <div class="text-center">
                                                <button onclick="razorpaySubmit(this);" class="btn btn-primary btn-lg px-5">Pay Now</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- checkout-area-end -->


</main>
<!-- main-area-end -->

<?php
// Determine product info and order type based on session
if (isset($is_checkout_order) && $is_checkout_order) {
	$productinfo = 'Study Material Order';
	$order_type = 'study_material';
} else {
	$productinfo = isset($_SESSION['mockCategoryName']) ? 'Mock Test Enrollment' : 'Course Enrollment';
	$order_type = isset($_SESSION['mockCategoryName']) ? 'mock_test' : 'course';
}
$txnid = time();
$surl = base_url('thank_you?or=') . $theorder['so_order_id'];
$furl = base_url('thank_you?or=') . $theorder['so_order_id'];
$key_id = RAZOR_KEY_ID;
$currency_code = 'INR';
$total = $theorder['so_price'] * 100;
$amount = $theorder['so_price'];
$merchant_order_id = $theorder['so_order_id'];
$card_holder_name = '';
$email = $theorder['so_email'];
$phone = $theorder['so_phone'];
$name = $theorder['so_name'];
$return_url = base_url() . 'razorpay/callback';
?>

<form name="razorpay-form" id="razorpay-form" action="<?php echo $return_url; ?>" method="POST">
    <input type="hidden" name="razorpay_payment_id" id="razorpay_payment_id" />
    <input type="hidden" name="merchant_order_id" id="merchant_order_id" value="<?php echo $merchant_order_id; ?>" />
    <input type="hidden" name="merchant_trans_id" id="merchant_trans_id" value="<?php echo $txnid; ?>" />
    <input type="hidden" name="merchant_product_info_id" id="merchant_product_info_id" value="<?php echo $productinfo; ?>" />
    <input type="hidden" name="merchant_surl_id" id="merchant_surl_id" value="<?php echo $surl; ?>" />
    <input type="hidden" name="merchant_furl_id" id="merchant_furl_id" value="<?php echo $furl; ?>" />
    <input type="hidden" name="card_holder_name_id" id="card_holder_name_id" value="<?php echo $card_holder_name; ?>" />
    <input type="hidden" name="merchant_total" id="merchant_total" value="<?php echo $total; ?>" />
    <input type="hidden" name="merchant_amount" id="merchant_amount" value="<?php echo $amount; ?>" />
    <input type="hidden" name="email" id="email" value="<?php echo $email; ?>" />
    <input type="hidden" name="ecom_order_name" id="ecom_order_name" value="<?php echo $theorder['so_name']; ?>" />
    <input type="hidden" name="chk_code" id="chk_code" value="<?php echo $_SESSION['chk_code']; ?>" />
    <input type="hidden" name="or_type" id="or_type" value="<?= $order_type ?>"/>
</form>

<script src="https://checkout.razorpay.com/v1/checkout.js"></script>
<script>
    var razorpay_options = {
        key: "<?php echo $key_id; ?>",
        amount: "<?php echo $total; ?>",
        currency: "<?php echo $currency_code; ?>",
        name: "<?php echo $name; ?>",
        description: "Order # <?php echo $merchant_order_id; ?>",
        netbanking: true,
        currency: "INR",
        prefill: {
            name: "<?php echo $card_holder_name; ?>",
            email: "<?php echo $email; ?>",
            contact: "<?php echo $phone; ?>"
        },
        notes: {
            soolegal_order_id: "<?php echo $merchant_order_id; ?>",
        },
        handler: function(transaction) {
            document.getElementById('razorpay_payment_id').value = transaction.razorpay_payment_id;
            document.getElementById('razorpay-form').submit();
        },
        "modal": {
            "ondismiss": function() {
                location.reload()
            }
        }
    };
    var razorpay_submit_btn, razorpay_instance;

    function razorpaySubmit(el) {
        if (typeof Razorpay == 'undefined') {
            setTimeout(razorpaySubmit, 200);
            if (!razorpay_submit_btn && el) {
                razorpay_submit_btn = el;
                el.disabled = true;
                el.innerHTML = '<span>Please wait...</span>';
            }
        } else {
            if (!razorpay_instance) {
                razorpay_instance = new Razorpay(razorpay_options);
                if (razorpay_submit_btn) {
                    razorpay_submit_btn.disabled = false;
                    razorpay_submit_btn.innerHTML = '<span>Pay Now</span>';
                }
            }
            razorpay_instance.open();
        }
    }
</script>
