<div class="breadcrumb-wrapper bg-cover section-padding"
    style="background: linear-gradient(#E8F6FE), 
                     url('<?= base_url('assets/theme/theme/') ?>assets/img/hero/banner.jpg'); 
            background-size: cover;
            background-position: center;">

    <div class="container">
        <div class="page-heading">
            <h1>My Profile</h1>
            <div class="page-header">
                <ul class="breadcrumb-items wow fadeInUp" data-wow-delay=".3s">


                </ul>
            </div>
        </div>
    </div>
</div>

<!--my account section-->
<section class="my-account " style="margin-bottom: 200px;">
    <div class="container">
        <div class="account-info d-flex align-items-center gap-4 p-4 bg-white rounded shadow-sm flex-wrap flex-lg-nowrap mb-4">

            <div class="profile-info">
                <h4 class="mb-1"><?= ucfirst($profile_data['name']) ?></h4>
                <div class="info-meta d-flex align-items-center gap-3 flex-wrap">
                    <?php if (!empty($profile_data['address'])): ?>
                        <span>
                            <i class="fa-solid fa-location-pin"></i> <?= htmlspecialchars($profile_data['address']) ?>
                        </span>
                    <?php endif; ?>
                    <span><i class="fa-solid fa-phone"></i> <?= $profile_data['contact'] ?></span>
                    <span><i class="fa-solid fa-envelope"></i> <?= $profile_data['email'] ?></span>
                </div>
                <div class="profile-achievements d-flex align-items-center gap-3 mt-3 flex-wrap">
                    <div class="achievement-box bg-light rounded p-3 d-flex align-items-center gap-2 shadow-sm">
                        <span class="icon  text-white rounded-circle d-flex align-items-center justify-content-center" style="background-color:#0B8CD4;">
                            <i class="fas fa-box"></i>
                        </span>
                        <div>
                            <h5 class="mb-0"><?= count($allorders) ?></h5>
                            <small>Total Orders</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row g-4">
            <div class="col-xl-3">
                <div class="account-nav bg-white rounded shadow-sm py-4 px-3">
                    <h6 class="mb-3">Manage My Account</h6>
                    <ul class="nav flex-column account-nav-menu">
                        <li class="nav-item">
                            <a href="#dashboard" data-bs-toggle="tab" class="nav-link <?= (!isset($_GET['lc_id']) || empty($show_live_class_detail)) ? 'active' : '' ?>">
                                <i class="fas fa-tachometer-alt me-2"></i> Dashboard
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="#update-profile" data-bs-toggle="tab" class="nav-link">
                                <i class="fas fa-user-edit me-2"></i> Update Profile
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="#referral" data-bs-toggle="tab" class="nav-link">
                                <i class="fas fa-share-alt me-2"></i> My Referral Link
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="#live-classes" data-bs-toggle="tab" class="nav-link <?= (isset($_GET['lc_id']) && !empty($show_live_class_detail)) ? '' : '' ?>">
                                <i class="fas fa-video me-2"></i> Live Classes
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?= base_url('recorded_videos') ?>" class="nav-link">
                                <i class="fas fa-film me-2"></i> Recorded Videos
                            </a>
                        </li>
                        <?php if (isset($show_live_class_detail) && $show_live_class_detail): ?>
                        <li class="nav-item">
                            <a href="#live-class-detail" data-bs-toggle="tab" class="nav-link active">
                                <i class="fas fa-info-circle me-2"></i> Live Class Detail
                            </a>
                        </li>
                        <?php endif; ?>
                        <li class="nav-item">
                            <a href="<?= base_url('logout') ?>" class="nav-link ">
                                <i class="fas fa-sign-out-alt me-2"></i> Log out
                            </a>
                        </li>
                    </ul>
                </div>
            </div>

            <div class="col-xl-9">
                <div class="tab-content">
                    <?php 
                    // Determine which tab should be active
                    $dashboard_active = (!isset($_GET['lc_id']) || empty($show_live_class_detail)) ? 'show active' : '';
                    $live_class_detail_active = (isset($_GET['lc_id']) && !empty($show_live_class_detail)) ? 'show active' : '';
                    ?>
                    <div class="tab-pane fade <?= $dashboard_active ?>" id="dashboard">
                        <div class="recent-orders bg-white rounded shadow-sm p-4">
                            <h6 class="mb-3">Recent Orders</h6>
                            <div class="table-responsive">
                                <table class="table table-hover align-middle">
                                    <thead class="table-light">
                                        <tr>
                                            <th>Order Number#</th>
                                            <th>Type</th>
                                            <th>Placed on</th>
                                            <th>Status</th>
                                            <th>Total</th>
                                            <th class="text-center">File</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($allorders as $order):
                                            $so_id = $order['so_order_id'];
                                            $order_type = !empty($order['order_type']) ? $order['order_type'] : 'Study Material';
                                            
                                            // Set badge color based on type
                                            $badge_class = 'bg-secondary';
                                            if ($order_type == 'Course Enrollment') {
                                                $badge_class = 'bg-primary';
                                            } elseif ($order_type == 'Mock Test') {
                                                $badge_class = 'bg-info';
                                            } elseif ($order_type == 'Study Material') {
                                                $badge_class = 'bg-success';
                                            }
                                            ?>
                                            <tr>
                                                <td><?= $so_id ?></td>
                                                <td>
                                                    <span class="badge <?= $badge_class ?> text-white"><?= $order_type ?></span>
                                                </td>
                                                <td><?= date_format_1($order['so_date'], '1') ?></td>
                                                <td><?= read_me_user('order_status', $order['so_status'], 1) ?></td>
                                                <td><?= money_show($order['so_price']) ?></td>
                                                <td class="text-center">
                                                    <a href="<?= base_url('view-checkout?ord=' . $so_id) ?>" class="text-success fs-6">
                                                        <i class="fas fa-eye"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <div class="tab-pane fade" id="update-profile">
                        <div class="update-profile bg-white p-4 rounded shadow-sm">
                            <?php include('edit.php') ?>
                        </div>
                    </div>

                    <div class="tab-pane fade" id="referral">
                        <div class="referral-section bg-white p-4 rounded shadow-sm">
                            <h6 class="mb-4">My Referral Link</h6>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="card border-primary">
                                        <div class="card-body">
                                            <h6 class="card-title mb-3">
                                                <i class="fas fa-share-alt me-2"></i>Share Your Referral Link
                                            </h6>
                                            <p class="text-muted small mb-3">
                                                Share this link with your friends and earn rewards when they sign up!
                                            </p>
                                            <?php 
                                            // Get referral code from profile data
                                            $refer_code = !empty($profile_data['refer_code']) ? $profile_data['refer_code'] : (!empty($profile_data['roll_num']) ? $profile_data['roll_num'] : (!empty($profile_data['user_reffer']) ? $profile_data['user_reffer'] : $yid));
                                            $referral_link = base_url('signup?refer=' . $refer_code);
                                            ?>
                                            <div class="input-group mb-3">
                                                <input type="text" 
                                                       class="form-control" 
                                                       id="referral_code" 
                                                       value="<?= $referral_link ?>" 
                                                       readonly>
                                                <button class="btn btn-primary" type="button" onclick="copyToClipboard('referral_code', 'code')">
                                                    <i class="fas fa-copy me-1"></i> Copy Link
                                                </button>
                                            </div>
                                            <?php if (!empty($refer_code) && $refer_code != $yid): ?>
                                                <div class="mb-3">
                                                    <label class="form-label small text-muted">Your Referral Code:</label>
                                                    <div class="input-group">
                                                        <input type="text" 
                                                               class="form-control" 
                                                               id="refer_code_only" 
                                                               value="<?= htmlspecialchars($refer_code) ?>" 
                                                               readonly>
                                                        <button class="btn btn-outline-primary" type="button" onclick="copyToClipboard('refer_code_only', 'code')">
                                                            <i class="fas fa-copy me-1"></i> Copy Code
                                                        </button>
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                            <div class="alert alert-info mb-0">
                                                <i class="fas fa-info-circle me-2"></i>
                                                <strong>How it works:</strong> When someone signs up using your referral link, you'll get credit for the referral.
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="tab-pane fade" id="live-classes">
                        <div class="live-classes-section bg-white p-4 rounded shadow-sm">
                            <h6 class="mb-4">My Live Classes</h6>
                            <?php
                            $yid = $_SESSION['yid'];
                            
                            // Use the SAME logic as dashboard - get all orders first (exact same as Main.php)
                            $yid_escaped = (int)$yid;
                            $email = isset($_SESSION['email']) ? $_SESSION['email'] : '';
                            $phone = isset($profile_data['phone']) ? $profile_data['phone'] : '';
                            if (empty($phone) && isset($profile_data['contact'])) {
                                $phone = $profile_data['contact'];
                            }
                            
                            // Build WHERE conditions (EXACT same as Main.php profile function)
                            $where_conditions = ["so_mid = '$yid_escaped'"];
                            
                            if (!empty($phone)) {
                                $phone_escaped = $this->db->escape_str($phone);
                                $phone_normalized = preg_replace('/[^0-9]/', '', $phone);
                                if (!empty($phone_normalized)) {
                                    $phone_normalized_escaped = $this->db->escape_str($phone_normalized);
                                    $where_conditions[] = "so_phone = '$phone_escaped'";
                                    $where_conditions[] = "REPLACE(REPLACE(REPLACE(REPLACE(so_phone, ' ', ''), '-', ''), '(', ''), ')', '') = '$phone_normalized_escaped'";
                                }
                            }
                            
                            if (!empty($email)) {
                                $email_escaped = $this->db->escape_str($email);
                                $where_conditions[] = "so_email = '$email_escaped'";
                            }
                            
                            $where_clause = '(' . implode(' OR ', $where_conditions) . ')';
                            
                            // Get all orders (SAME as dashboard - no payment status filter)
                            $getall_order = $this->db->query("select * from yn_ecom_order where $where_clause order by so_id desc");
                            $all_order = $getall_order->result_array();
                            
                            // DIRECT APPROACH: Match order table with order detail table
                            // Step 1: Get all order IDs from orders table
                            $order_ids = array();
                            foreach ($all_order as $order) {
                                $order_ids[] = $this->db->escape_str($order['so_order_id']);
                            }
                            
                            $purchased_sm_ids = array();
                            
                            if (!empty($order_ids)) {
                                // Step 2: Get all xod_pid from order details table where checkout_order_id matches
                                $order_ids_str = "'" . implode("','", $order_ids) . "'";
                                
                                // Direct query: Get all product IDs from order details
                                // Get order details - use xod_sm_id if available (new column), otherwise fallback to xod_pid
                                $all_order_details = $this->db->query("
                                    SELECT DISTINCT 
                                        od.xod_sm_id,
                                        od.xod_pid
                                    FROM yn_ecom_orders_detail od
                                    INNER JOIN yn_ecom_order o ON od.checkout_order_id = o.so_order_id
                                    WHERE od.checkout_order_id IN ($order_ids_str)
                                    AND (od.xod_sm_id IS NOT NULL OR (od.xod_pid IS NOT NULL AND od.xod_pid != '' AND od.xod_pid != '0'))
                                ")->result_array();
                                
                                // Step 3: Get study material IDs - prefer xod_sm_id, fallback to xod_pid
                                if (!empty($all_order_details)) {
                                    $sm_ids_from_order = array();
                                    
                                    foreach ($all_order_details as $detail) {
                                        $sm_id = null;
                                        
                                        // First check xod_sm_id (new column - directly stores study material ID)
                                        if (!empty($detail['xod_sm_id'])) {
                                            $sm_id = (int)$detail['xod_sm_id'];
                                        } 
                                        // Fallback: Check if xod_pid is a study material ID
                                        elseif (!empty($detail['xod_pid'])) {
                                            $pid = trim($detail['xod_pid']);
                                            if (!empty($pid) && $pid != '0') {
                                                $pid_int = (int)$pid;
                                                
                                                // First: Check if xod_pid is directly a study material ID
                                                $sm_check = $this->db->query("SELECT sm_id FROM x_edu_study_material WHERE sm_id = '$pid_int' AND sm_status = '1'")->row_array();
                                                if (!empty($sm_check)) {
                                                    $sm_id = $pid_int;
                                                } else {
                                                    // If not found, check if xod_pid is a course ID - get all study materials from that course
                                                    $course_check = $this->db->query("SELECT course_id FROM x_edu_courses WHERE course_id = '$pid_int'")->row_array();
                                                    if (!empty($course_check)) {
                                                        // Get all study materials for this course
                                                        $course_sm = $this->db->query("SELECT sm_id FROM x_edu_study_material WHERE sm_course_id = '$pid_int' AND sm_status = '1'")->result_array();
                                                        foreach ($course_sm as $csm) {
                                                            $sm_ids_from_order[] = (int)$csm['sm_id'];
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        
                                        if (!empty($sm_id)) {
                                            $sm_ids_from_order[] = $sm_id;
                                        }
                                    }
                                    
                                    if (!empty($sm_ids_from_order)) {
                                        $purchased_sm_ids = array_merge($purchased_sm_ids, array_unique($sm_ids_from_order));
                                    }
                                }
                            }
                            
                            // Remove duplicates
                            $purchased_sm_ids = array_unique($purchased_sm_ids);
                            
                            // DEBUG: Check what we found
                            // Uncomment below to debug:
                            /*
                            echo "<pre>DEBUG INFO:<br>";
                            echo "Total Orders: " . count($all_order) . "<br>";
                            echo "Order IDs: ";
                            print_r($order_ids);
                            echo "<br>Order Details Count: " . (isset($all_order_details) ? count($all_order_details) : 0) . "<br>";
                            if (isset($all_order_details)) {
                                echo "All xod_pid values: ";
                                foreach ($all_order_details as $d) {
                                    echo $d['xod_pid'] . " ";
                                }
                            }
                            echo "<br>Found Study Material IDs: ";
                            print_r($purchased_sm_ids);
                            echo "</pre>";
                            */
                            
                            if (empty($purchased_sm_ids)): ?>
                                <div class="alert alert-info">
                                    <i class="fas fa-info-circle me-2"></i>
                                    You haven't purchased any study materials yet. Purchase a study material to access live classes!
                                    <?php 
                                    // Detailed debug - remove after testing
                                    if (count($all_order) > 0 && isset($all_order_details)) {
                                        echo "<br><br><small class='text-muted'><strong>Debug Info:</strong><br>";
                                        echo "Orders found: " . count($all_order) . "<br>";
                                        echo "Order details items: " . count($all_order_details) . "<br>";
                                        
                                        if (!empty($all_order_details)) {
                                            echo "<br><strong>Product IDs in order details:</strong><br>";
                                            foreach ($all_order_details as $idx => $detail) {
                                                $pid = trim($detail['xod_pid']);
                                                $pid_int = (int)$pid;
                                                echo "Item " . ($idx + 1) . ": xod_pid = '$pid' (int: $pid_int)<br>";
                                                
                                                // Check what type it is
                                                $sm_check = $this->db->query("SELECT sm_id, sm_name FROM x_edu_study_material WHERE sm_id = '$pid_int'")->row_array();
                                                $course_check = $this->db->query("SELECT course_id, course_name FROM x_edu_courses WHERE course_id = '$pid_int'")->row_array();
                                                $mock_check = $this->db->query("SELECT category_id, category_name FROM mock_categories WHERE category_id = '$pid_int'")->row_array();
                                                
                                                if (!empty($sm_check)) {
                                                    echo "&nbsp;&nbsp;→ Found in study_material table: " . htmlspecialchars($sm_check['sm_name']) . "<br>";
                                                } elseif (!empty($course_check)) {
                                                    echo "&nbsp;&nbsp;→ Found in courses table: " . htmlspecialchars($course_check['course_name']) . " (SKIPPED)<br>";
                                                } elseif (!empty($mock_check)) {
                                                    echo "&nbsp;&nbsp;→ Found in mock_categories table: " . htmlspecialchars($mock_check['category_name']) . " (SKIPPED)<br>";
                                                } else {
                                                    echo "&nbsp;&nbsp;→ NOT FOUND in any table (study_material, courses, or mock_categories)<br>";
                                                }
                                            }
                                        }
                                        
                                        if (!empty($all_pids)) {
                                            echo "<br><strong>All PIDs collected:</strong> " . implode(', ', $all_pids) . "<br>";
                                        }
                                        
                                        echo "<br><strong>Matched Study Material IDs:</strong> ";
                                        if (empty($purchased_sm_ids)) {
                                            echo "NONE";
                                        } else {
                                            echo implode(', ', $purchased_sm_ids);
                                        }
                                        echo "</small>";
                                    }
                                    ?>
                                </div>
                            <?php else:
                                $sm_ids_str = implode(',', array_map('intval', $purchased_sm_ids));
                                
                                // Get all live classes for purchased study materials
                                $live_classes = $this->db->query("
                                    SELECT lc.*, sm.sm_name as study_material_name, sm.sm_id, c.course_name 
                                    FROM yn_live_classes lc
                                    INNER JOIN x_edu_study_material sm ON lc.sm_id = sm.sm_id
                                    LEFT JOIN x_edu_courses c ON sm.sm_course_id = c.course_id
                                    WHERE lc.sm_id IN ($sm_ids_str)
                                    AND lc.lc_status = '1'
                                    AND sm.sm_status = '1'
                                    ORDER BY lc.lc_date ASC, lc.lc_start_time ASC
                                ")->result_array();

                                if (empty($live_classes)): ?>
                                    <div class="alert alert-warning">
                                        <i class="fas fa-exclamation-triangle me-2"></i>
                                        No live classes scheduled yet for your purchased study materials.
                                    </div>
                                <?php else: ?>
                                    <div class="row g-4">
                                        <?php foreach ($live_classes as $class): 
                                            $class_datetime = strtotime($class['lc_date'] . ' ' . $class['lc_start_time']);
                                            $is_upcoming = ($class_datetime > time());
                                            $is_today = (date('Y-m-d', $class_datetime) == date('Y-m-d'));
                                        ?>
                                            <div class="col-md-6 col-lg-4">
                                                <div class="card h-100 shadow-sm border-0 live-class-card" style="cursor: pointer; transition: transform 0.2s;" 
                                                     onclick="window.location.href='<?= base_url('profile?lc_id=' . $class['lc_id']) ?>#live-class-detail'"
                                                     onmouseover="this.style.transform='translateY(-5px)'" 
                                                     onmouseout="this.style.transform='translateY(0)'">
                                                    <div class="card-body">
                                                        <div class="d-flex justify-content-between align-items-start mb-3">
                                                            <span class="badge <?= $is_upcoming ? 'bg-success' : 'bg-secondary' ?>">
                                                                <?= $is_upcoming ? ($is_today ? 'Today' : 'Upcoming') : 'Past' ?>
                                                            </span>
                                                            <?php if (!empty($class['course_name'])): ?>
                                                                <small class="text-muted"><?= htmlspecialchars($class['course_name']) ?></small>
                                                            <?php endif; ?>
                                                        </div>
                                                        
                                                        <h6 class="card-title mb-2"><?= htmlspecialchars($class['lc_title']) ?></h6>
                                                        <p class="text-muted small mb-2">
                                                            <i class="fas fa-book me-1"></i> <?= htmlspecialchars($class['study_material_name']) ?>
                                                        </p>
                                                        
                                                        <?php if (!empty($class['lc_description'])): ?>
                                                            <p class="card-text small text-muted mb-3" style="display: -webkit-box; -webkit-line-clamp: 2; line-clamp: 2; -webkit-box-orient: vertical; overflow: hidden;">
                                                                <?= htmlspecialchars($class['lc_description']) ?>
                                                            </p>
                                                        <?php endif; ?>
                                                        
                                                        <div class="live-class-time mb-3">
                                                            <div class="d-flex align-items-center mb-1">
                                                                <i class="fas fa-calendar text-primary me-2"></i>
                                                                <small><strong><?= date_format_1($class['lc_date'], '1') ?></strong></small>
                                                            </div>
                                                            <div class="d-flex align-items-center">
                                                                <i class="fas fa-clock text-primary me-2"></i>
                                                                <small>
                                                                    <strong>Start:</strong> <?= date('h:i A', strtotime($class['lc_start_time'])) ?><br>
                                                                    <strong>End:</strong> <?= date('h:i A', strtotime($class['lc_end_time'])) ?>
                                                                </small>
                                                            </div>
                                                        </div>
                                                        
                                                        <div class="d-flex justify-content-between align-items-center">
                                                            <a href="<?= base_url('profile?lc_id=' . $class['lc_id']) ?>#live-class-detail" 
                                                               class="btn btn-sm btn-primary"
                                                               onclick="event.stopPropagation();">
                                                                <i class="fas fa-eye me-1"></i> View Details
                                                            </a>
                                                            <?php if (!empty($class['lc_zoom_link']) && $is_upcoming): ?>
                                                                <a href="<?= htmlspecialchars($class['lc_zoom_link']) ?>" 
                                                                   target="_blank" 
                                                                   class="btn btn-sm btn-success"
                                                                   onclick="event.stopPropagation();">
                                                                    <i class="fas fa-video me-1"></i> Join
                                                                </a>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                <?php endif; ?>
                            <?php endif; ?>
                        </div>
                    </div>

                    <?php if (isset($show_live_class_detail) && $show_live_class_detail && !empty($live_class_detail)): ?>
                    <div class="tab-pane fade <?= $live_class_detail_active ?>" id="live-class-detail">
                        <div class="live-class-detail-section bg-white p-4 rounded shadow-sm">
                            <div class="card border-0">
                                <div class="card-header bg-primary text-white py-4">
                                    <div class="d-flex justify-content-between align-items-start">
                                        <div>
                                            <h4 class="mb-2"><?= htmlspecialchars($live_class_detail['lc_title']) ?></h4>
                                            <?php if (!empty($live_class_detail['study_material_name'])): ?>
                                                <p class="mb-0 text-white-50">
                                                    <i class="fas fa-book me-2"></i><?= htmlspecialchars($live_class_detail['study_material_name']) ?>
                                                </p>
                                            <?php endif; ?>
                                        </div>
                                        <div class="text-end">
                                            <?php if (isset($is_upcoming) && $is_upcoming): ?>
                                                <span class="badge bg-success fs-6 px-3 py-2">
                                                    <?= (isset($is_today) && $is_today) ? 'Today' : 'Upcoming' ?>
                                                </span>
                                            <?php elseif (isset($is_ongoing) && $is_ongoing): ?>
                                                <span class="badge bg-warning text-dark fs-6 px-3 py-2">Ongoing</span>
                                            <?php else: ?>
                                                <span class="badge bg-secondary fs-6 px-3 py-2">Past</span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="card-body p-4">
                                    <?php if (!empty($live_class_detail['lc_description'])): ?>
                                        <div class="mb-4">
                                            <h6 class="text-primary mb-3"><i class="fas fa-info-circle me-2"></i>Description</h6>
                                            <p class="text-muted"><?= nl2br(htmlspecialchars($live_class_detail['lc_description'])) ?></p>
                                        </div>
                                    <?php endif; ?>

                                    <div class="row mb-4">
                                        <div class="col-md-6 mb-3">
                                            <div class="info-box p-3 bg-light rounded">
                                                <h6 class="text-primary mb-2"><i class="fas fa-calendar-alt me-2"></i>Date</h6>
                                                <p class="mb-0 fs-5"><strong><?= date_format_1($live_class_detail['lc_date'], '1') ?></strong></p>
                                            </div>
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <div class="info-box p-3 bg-light rounded">
                                                <h6 class="text-primary mb-2"><i class="fas fa-clock me-2"></i>Time</h6>
                                                <p class="mb-1">
                                                    <strong>Start:</strong> <?= date('h:i A', strtotime($live_class_detail['lc_start_time'])) ?>
                                                </p>
                                                <p class="mb-0">
                                                    <strong>End:</strong> <?= date('h:i A', strtotime($live_class_detail['lc_end_time'])) ?>
                                                </p>
                                            </div>
                                        </div>
                                    </div>

                                    <?php if (!empty($live_class_detail['course_name'])): ?>
                                        <div class="mb-4">
                                            <h6 class="text-primary mb-2"><i class="fas fa-graduation-cap me-2"></i>Course</h6>
                                            <p class="mb-0"><?= htmlspecialchars($live_class_detail['course_name']) ?></p>
                                        </div>
                                    <?php endif; ?>

                                    <?php if (!empty($live_class_detail['lc_zoom_link'])): ?>
                                        <div class="mb-4">
                                            <h6 class="text-primary mb-3"><i class="fas fa-video me-2"></i>Meeting Information</h6>
                                            
                                            <div class="zoom-info-box p-4 bg-light rounded mb-3">
                                                <div class="mb-3">
                                                    <label class="text-muted small">Meeting Link:</label>
                                                    <div class="input-group">
                                                        <input type="text" class="form-control" id="zoom_link_detail" 
                                                               value="<?= htmlspecialchars($live_class_detail['lc_zoom_link']) ?>" readonly>
                                                        <button class="btn btn-outline-primary" onclick="copyToClipboardDetail('zoom_link_detail')">
                                                            <i class="fas fa-copy"></i> Copy
                                                        </button>
                                                    </div>
                                                </div>

                                                <?php if (!empty($live_class_detail['lc_zoom_id'])): ?>
                                                    <div class="mb-3">
                                                        <label class="text-muted small">Meeting ID:</label>
                                                        <div class="input-group">
                                                            <input type="text" class="form-control" id="zoom_id_detail" 
                                                                   value="<?= htmlspecialchars($live_class_detail['lc_zoom_id']) ?>" readonly>
                                                            <button class="btn btn-outline-primary" onclick="copyToClipboardDetail('zoom_id_detail')">
                                                                <i class="fas fa-copy"></i> Copy
                                                            </button>
                                                        </div>
                                                    </div>
                                                <?php endif; ?>

                                                <?php if (!empty($live_class_detail['lc_zoom_password'])): ?>
                                                    <div>
                                                        <label class="text-muted small">Meeting Password:</label>
                                                        <div class="input-group">
                                                            <input type="text" class="form-control" id="zoom_password_detail" 
                                                                   value="<?= htmlspecialchars($live_class_detail['lc_zoom_password']) ?>" readonly>
                                                            <button class="btn btn-outline-primary" onclick="copyToClipboardDetail('zoom_password_detail')">
                                                                <i class="fas fa-copy"></i> Copy
                                                            </button>
                                                        </div>
                                                    </div>
                                                <?php endif; ?>
                                            </div>

                                            <?php if ((isset($is_upcoming) && $is_upcoming) || (isset($is_ongoing) && $is_ongoing)): ?>
                                                <div class="text-center">
                                                    <a href="<?= htmlspecialchars($live_class_detail['lc_zoom_link']) ?>" 
                                                       target="_blank" 
                                                       class="btn btn-success btn-lg px-5">
                                                        <i class="fas fa-video me-2"></i> Join Live Class
                                                    </a>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    <?php else: ?>
                                        <div class="alert alert-warning">
                                            <i class="fas fa-exclamation-triangle me-2"></i>
                                            Meeting link will be available soon.
                                        </div>
                                    <?php endif; ?>
                                </div>

                                <div class="card-footer bg-light text-center py-3">
                                    <a href="<?= base_url('profile') ?>#live-classes" class="btn btn-outline-primary">
                                        <i class="fas fa-arrow-left me-2"></i> Back to Live Classes
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</section>

<script>
function copyToClipboard(elementId, type) {
    const element = document.getElementById(elementId);
    element.select();
    element.setSelectionRange(0, 99999); // For mobile devices
    document.execCommand('copy');
    
    // Show success message
    const btn = event.target.closest('button');
    const originalText = btn.innerHTML;
    btn.innerHTML = '<i class="fas fa-check me-1"></i> Copied!';
    btn.classList.remove('btn-primary', 'btn-success');
    btn.classList.add('btn-success');
    
    setTimeout(function() {
        btn.innerHTML = originalText;
        if (elementId === 'referral_code') {
            btn.classList.remove('btn-success');
            btn.classList.add('btn-primary');
        }
    }, 2000);
}

function copyToClipboardDetail(elementId) {
    const element = document.getElementById(elementId);
    element.select();
    element.setSelectionRange(0, 99999); // For mobile devices
    document.execCommand('copy');
    
    // Show success message
    const btn = event.target.closest('button');
    const originalHTML = btn.innerHTML;
    btn.innerHTML = '<i class="fas fa-check"></i> Copied!';
    btn.classList.remove('btn-outline-primary');
    btn.classList.add('btn-success');
    
    setTimeout(function() {
        btn.innerHTML = originalHTML;
        btn.classList.remove('btn-success');
        btn.classList.add('btn-outline-primary');
    }, 2000);
}

// Handle tab activation on page load if lc_id is in URL
document.addEventListener('DOMContentLoaded', function() {
    const urlParams = new URLSearchParams(window.location.search);
    const lcId = urlParams.get('lc_id');
    
    if (lcId) {
        // Activate live class detail tab
        const detailTab = document.querySelector('a[href="#live-class-detail"]');
        const liveClassesTab = document.querySelector('a[href="#live-classes"]');
        const dashboardTab = document.querySelector('a[href="#dashboard"]');
        
        if (detailTab) {
            // Remove active from other tabs
            if (dashboardTab) dashboardTab.classList.remove('active');
            if (liveClassesTab) liveClassesTab.classList.remove('active');
            
            // Add active to detail tab
            detailTab.classList.add('active');
            
            // Show detail tab content
            const detailTabPane = document.getElementById('live-class-detail');
            const dashboardTabPane = document.getElementById('dashboard');
            
            if (detailTabPane && dashboardTabPane) {
                dashboardTabPane.classList.remove('show', 'active');
                detailTabPane.classList.add('show', 'active');
            }
        }
    }
});
</script>
<style>
    /* Breadcrumb */
    .breadcrumb-section {
        position: relative;
        height: 280px;
        display: flex;
        align-items: center;
        justify-content: center;
        background: linear-gradient(rgba(0, 0, 0, 0.4), rgba(0, 0, 0, 0.4)), url('https://honey-dale.com/cdn/shop/files/Honey_for_your_diet.png?v=1683704632&width=1500') center/cover no-repeat;
    }

    .breadcrumb-title {
        color: #fff;
        font-size: 3rem;
        font-weight: 600;
    }

    /* Account Info */
    .account-info .profile-avatar img {
        width: 120px;
        height: 120px;
        object-fit: cover;
    }

    .profile-info h4 {
        font-weight: 600;
        font-size: 1.5rem;
    }

    .profile-info .info-meta span {
        font-size: 0.9rem;
        color: #555;
    }

    .profile-info .info-meta i {
        color: #0B8CD4;
    }

    .achievement-box .icon {
        width: 45px;
        height: 45px;
        font-size: 1.2rem;
    }

    /* Tabs */
    .account-nav .nav-link {
        color: #212B36;
        font-weight: 500;
        margin-bottom: 0.5rem;
        border-radius: 0.375rem;
        padding: 0.5rem 1rem;
        transition: 0.3s;
    }

    .account-nav .nav-link.active,
    .account-nav .nav-link:hover {
        background-color: #0B8CD4;
        color: #fff;
    }

    .table-hover tbody tr:hover {
        background-color: #f0f9f4;
    }

    /* Live Classes Cards */
    .live-class-card {
        border-radius: 10px;
        overflow: hidden;
    }

    .live-class-card:hover {
        box-shadow: 0 8px 16px rgba(0,0,0,0.15) !important;
    }

    .live-class-card .card-body {
        padding: 1.5rem;
    }

    .live-class-time {
        background: #f8f9fa;
        padding: 0.75rem;
        border-radius: 5px;
    }

    /* Responsive */
    @media (max-width: 991px) {
        .account-info {
            flex-direction: column;
            text-align: center;
        }

        .profile-info .info-meta {
            justify-content: center;
        }

        .account-nav {
            margin-bottom: 1.5rem;
        }
    }
</style>