-- Live Classes Table Structure
-- Run this SQL query to create the table

CREATE TABLE IF NOT EXISTS `yn_live_classes` (
  `lc_id` int(11) NOT NULL AUTO_INCREMENT,
  `sm_id` int(11) NOT NULL COMMENT 'Study Material ID from x_edu_study_material',
  `lc_title` varchar(255) NOT NULL COMMENT 'Live Class Title',
  `lc_description` text DEFAULT NULL COMMENT 'Class Description',
  `lc_date` date NOT NULL COMMENT 'Class Date',
  `lc_start_time` time NOT NULL COMMENT 'Class Start Time',
  `lc_end_time` time NOT NULL COMMENT 'Class End Time',
  `lc_zoom_link` varchar(500) NOT NULL COMMENT 'Zoom Meeting Link',
  `lc_zoom_id` varchar(100) DEFAULT NULL COMMENT 'Zoom Meeting ID',
  `lc_zoom_password` varchar(100) DEFAULT NULL COMMENT 'Zoom Meeting Password',
  `lc_status` tinyint(1) DEFAULT '1' COMMENT '1=Active, 0=Inactive',
  `lc_created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`lc_id`),
  KEY `sm_id` (`sm_id`),
  KEY `lc_status` (`lc_status`),
  KEY `lc_date` (`lc_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

