-- Create table for study material recorded videos
-- Simplified version - only essential fields

CREATE TABLE IF NOT EXISTS `yn_study_material_videos` (
  `smv_id` int(11) NOT NULL AUTO_INCREMENT,
  `sm_id` int(11) NOT NULL COMMENT 'Study Material ID from x_edu_study_material',
  `lc_id` int(11) DEFAULT NULL COMMENT 'Live Class ID from yn_live_classes (optional - if video is from a live class)',
  `smv_title` varchar(255) NOT NULL COMMENT 'Video Title',
  `smv_description` text DEFAULT NULL COMMENT 'Video Description',
  `smv_video_url` varchar(500) NOT NULL COMMENT 'Video File Path (uploaded file)',
  `smv_status` tinyint(1) DEFAULT '1' COMMENT '1=Active, 0=Inactive',
  `smv_created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `smv_updated_at` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`smv_id`),
  KEY `sm_id` (`sm_id`),
  KEY `lc_id` (`lc_id`),
  KEY `smv_status` (`smv_status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Study Material Recorded Videos';
