<?php
// Test query to check video fetching logic
// Run this file directly: http://localhost/ynaps/ebook/test_video_query.php

// Database connection (from config/database.php)
$host = 'localhost';
$dbname = 'ebook';
$username = 'root';
$password = ''; // Empty password for XAMPP default

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "<h2>Video Fetching Test</h2>";
    echo "<hr>";
    
    // Test 1: Check all videos in database
    echo "<h3>Test 1: All Videos in Database</h3>";
    $query1 = "SELECT * FROM yn_study_material_videos WHERE smv_status = '1'";
    $stmt1 = $pdo->query($query1);
    $videos = $stmt1->fetchAll(PDO::FETCH_ASSOC);
    echo "<pre>";
    print_r($videos);
    echo "</pre>";
    echo "<p><strong>Total Active Videos:</strong> " . count($videos) . "</p>";
    echo "<hr>";
    
    // Test 2: Check specific video (sm_id=23, lc_id=2)
    echo "<h3>Test 2: Video with sm_id=23, lc_id=2</h3>";
    $query2 = "SELECT smv.*, sm.sm_name, sm.sm_status, 
                      lc.lc_id, lc.lc_title, lc.lc_status
               FROM yn_study_material_videos smv
               LEFT JOIN x_edu_study_material sm ON smv.sm_id = sm.sm_id
               LEFT JOIN yn_live_classes lc ON smv.lc_id = lc.lc_id
               WHERE smv.sm_id = 23 AND smv.lc_id = 2 AND smv.smv_status = '1'";
    $stmt2 = $pdo->query($query2);
    $video_detail = $stmt2->fetchAll(PDO::FETCH_ASSOC);
    echo "<pre>";
    print_r($video_detail);
    echo "</pre>";
    echo "<hr>";
    
    // Test 3: Check if study material exists and is active
    echo "<h3>Test 3: Study Material sm_id=23 Status</h3>";
    $query3 = "SELECT sm_id, sm_name, sm_status FROM x_edu_study_material WHERE sm_id = 23";
    $stmt3 = $pdo->query($query3);
    $sm = $stmt3->fetch(PDO::FETCH_ASSOC);
    echo "<pre>";
    print_r($sm);
    echo "</pre>";
    echo "<hr>";
    
    // Test 4: Check if live class exists and is active
    echo "<h3>Test 4: Live Class lc_id=2 Status</h3>";
    $query4 = "SELECT lc_id, lc_title, lc_status, sm_id FROM yn_live_classes WHERE lc_id = 2";
    $stmt4 = $pdo->query($query4);
    $lc = $stmt4->fetch(PDO::FETCH_ASSOC);
    echo "<pre>";
    print_r($lc);
    echo "</pre>";
    echo "<hr>";
    
    // Test 5: Simulate the actual query used in code
    echo "<h3>Test 5: Actual Query Used in Code (sm_id IN (23))</h3>";
    $sm_ids_str = "23";
    $query5 = "SELECT DISTINCT smv.*, sm.sm_id, sm.sm_name, sm.sm_desc, sm.sm_course_id,
                      lc.lc_id, lc.lc_title as lc_title, lc.lc_description, lc.lc_date,
                      c.course_name
               FROM yn_study_material_videos smv
               INNER JOIN x_edu_study_material sm ON smv.sm_id = sm.sm_id
               LEFT JOIN yn_live_classes lc ON (smv.lc_id = lc.lc_id)
               LEFT JOIN x_edu_courses c ON sm.sm_course_id = c.course_id
               WHERE sm.sm_id IN ($sm_ids_str)
               AND smv.smv_status = '1'
               AND sm.sm_status = '1'";
    $stmt5 = $pdo->query($query5);
    $all_videos = $stmt5->fetchAll(PDO::FETCH_ASSOC);
    echo "<pre>";
    print_r($all_videos);
    echo "</pre>";
    echo "<p><strong>Videos Found:</strong> " . count($all_videos) . "</p>";
    echo "<hr>";
    
    // Test 6: Organize videos (simulate PHP logic)
    echo "<h3>Test 6: Organized Videos (Study Material vs Live Class)</h3>";
    $sm_video_map = array();
    $lc_video_map = array();
    
    foreach ($all_videos as $video) {
        $sm_id = $video['sm_id'];
        
        // Study material videos (no lc_id or lc_id = 0)
        if (empty($video['lc_id']) || $video['lc_id'] == 0) {
            if (!isset($sm_video_map[$sm_id])) {
                $sm_video_map[$sm_id] = array(
                    'sm_id' => $sm_id,
                    'sm_name' => $video['sm_name'],
                    'video_count' => 0,
                    'item_type' => 'study_material'
                );
            }
            $sm_video_map[$sm_id]['video_count']++;
        }
        
        // Live class videos (has lc_id)
        if (!empty($video['lc_id']) && $video['lc_id'] > 0) {
            $lc_id = $video['lc_id'];
            if (!isset($lc_video_map[$lc_id])) {
                $lc_title = !empty($video['lc_title']) ? $video['lc_title'] : 'Live Class Recording';
                $lc_video_map[$lc_id] = array(
                    'lc_id' => $lc_id,
                    'lc_title' => $lc_title,
                    'sm_id' => $sm_id,
                    'sm_name' => $video['sm_name'],
                    'video_count' => 0,
                    'item_type' => 'live_class'
                );
            }
            $lc_video_map[$lc_id]['video_count']++;
        }
    }
    
    echo "<h4>Study Material Videos:</h4>";
    echo "<pre>";
    print_r($sm_video_map);
    echo "</pre>";
    
    echo "<h4>Live Class Videos:</h4>";
    echo "<pre>";
    print_r($lc_video_map);
    echo "</pre>";
    
    $video_items = array_merge(array_values($sm_video_map), array_values($lc_video_map));
    echo "<h4>Final Video Items (for display):</h4>";
    echo "<pre>";
    print_r($video_items);
    echo "</pre>";
    echo "<p><strong>Total Items to Display:</strong> " . count($video_items) . "</p>";
    
} catch(PDOException $e) {
    echo "<h3>Error:</h3>";
    echo "<p>" . $e->getMessage() . "</p>";
}
?>

