<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Main extends CI_Controller
{
	function __construct()
	{
		parent::__construct();
	}

	public function index()
	{
		$data = db_variables();

		if ($data['home_page'] != '') {
			redirect(base_url($data['home_page']));
		}

		$data['seo_title'] = 'Home - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		$thecats = $this->db->query("select * from yn_site_catagory where type='cards' order by sid asc limit 6");
		$all_cats = $thecats->result_array();
		$data['the_cats'] = $all_cats;

		$geththeblogs = $this->db->query("select * from yn_site_blogs order by blog_id desc limit 3 ");
		$all_blogs = $geththeblogs->result_array();
		$data['show_blogs'] = $all_blogs;

		$get_sliders = $this->db->query("select * from yn_site_img where img_place ='team' and img_status='1' order by img_id asc limit 2");
		$all_sliders = $get_sliders->result_array();
		$data['show_sliders'] = $all_sliders;

		//All products
		$getProducts = $this->db->query("SELECT * FROM `yn_ecom_products` order by p_id desc limit 6");
		$the_prods = $getProducts->result_array();
		$data['prod'] = $the_prods;
		//prod1
		$getProducts = $this->db->query("SELECT * FROM `yn_ecom_products`  WHERE p_looking = '1' ORDER BY p_id DESC LIMIT 6");
		$the_prods = $getProducts->result_array();
		$data['prod1'] = $the_prods;
		//prod2
		$getProducts = $this->db->query("SELECT * FROM `yn_ecom_products`  WHERE p_looking = '2' ORDER BY p_id DESC LIMIT 6");
		$the_prods = $getProducts->result_array();
		$data['prod2'] = $the_prods;
		//prod3
		$getProducts = $this->db->query("SELECT * FROM `yn_ecom_products`  WHERE p_sale_status = '3' ORDER BY p_id DESC LIMIT 6");
		$the_prods = $getProducts->result_array();
		$data['prod3'] = $the_prods;
		//prod4
		$getProducts = $this->db->query("SELECT * FROM `yn_ecom_products`  WHERE p_sale_status = '4' ORDER BY p_id DESC LIMIT 6");
		$the_prods = $getProducts->result_array();
		$data['prod4'] = $the_prods;
		//prod5
		$getProducts = $this->db->query("SELECT * FROM `yn_ecom_products`  WHERE p_sale_status= '5' ORDER BY p_id DESC LIMIT 4");
		$the_prods = $getProducts->result_array();
		$data['prod5'] = $the_prods;
		//prod6
		$getProducts = $this->db->query("SELECT * FROM `yn_ecom_products`  WHERE p_looking = '6' ORDER BY p_id DESC LIMIT 6");
		$the_prods = $getProducts->result_array();
		$data['prod6'] = $the_prods;

		// featured products
		$featuredproducts = $this->db->query("
    SELECT p.*, i.img_head 
    FROM yn_ecom_products p
    LEFT JOIN yn_site_img i 
        ON i.img_id = p.p_vendor 
       AND i.img_place = 'partner' 
       AND i.img_status = 1
    WHERE p.p_sale_status = '2' 
    ORDER BY p.p_id DESC 
    LIMIT 6
");

		$featuredproductsdata = $featuredproducts->result_array();
		$data['featuredProducts'] = $featuredproductsdata;

		// banner
		$get_banner = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='home' AND img_status='1' ORDER BY img_id DESC LIMIT 3");
		$thebanner = $get_banner->result_array();
		$data['banner'] = $thebanner;

		$get_banners = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='homeb' AND img_status='1' ORDER BY img_id DESC LIMIT 1");
		$thebanners = $get_banners->row_array();
		$data['banners'] = $thebanners;

		// Video banner
		$get_banner1 = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='homevideo' AND img_status='1' ORDER BY img_id DESC LIMIT 1");
		$thebanner1 = $get_banner1->row_array();
		$data['video'] = $thebanner1;

		$this->load->view('inc/_header', $data);
		// $this->load->view('inc/brain.php', $data);
		$this->load->view('home', $data);
		$this->load->view('inc/_footer', $data);
	}
	function admin()
	{
		redirect(base_url('admin/login'));
	}

	function error_404()
	{

		$data = db_variables();
		$data['seo_title'] = $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		$this->load->view('inc/_header', $data);
		$this->load->view('error', $data);
		$this->load->view('inc/_footer', $data);
	}

	function page($slug)
	{
		$get_all_blocks = $this->db->query("select * from yn_admin_pages where pg_slug ='$slug' ");
		$the_pages_data = $get_all_blocks->row_array();


		$data = db_variables();
		$data['seo_title'] = $the_pages_data['pg_meta_title'];
		$data['seo_description'] = $data['meta_title'];;
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['page_name'] = 'Ynaps.com';
		$data['page_data'] = $the_pages_data['content'];
		$data['meta_array'] = $data;


		$this->load->view('inc/_header', $data);
		$this->load->view('inc/_page_data.php', $data);
		$this->load->view('inc/_footer', $data);
	}

	function about()
	{
		$data = db_variables();
		$data['seo_title'] = 'About Us - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		// banner
		$get_banner = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='home' AND img_status='1' ORDER BY img_id DESC LIMIT 3");
		$thebanner = $get_banner->result_array();
		$data['banner'] = $thebanner;

		$get_banner = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='about' AND img_status='1' ORDER BY img_id DESC LIMIT 1");
		$thebanner = $get_banner->row_array();
		$data['image'] = $thebanner;

		$get_banner1 = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='babout' AND img_status='1' ORDER BY img_id DESC LIMIT 1");
		$thebanner1 = $get_banner1->row_array();
		$data['breadcrumb'] = $thebanner1;

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('about', $data);
		$this->load->view('inc/_footer', $data);
	}


	function studymaterial()
	{
		$data = db_variables();
		$data['seo_title'] = 'Study Material - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		// banner
		$get_banner = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='home' AND img_status='1' ORDER BY img_id DESC LIMIT 3");
		$thebanner = $get_banner->result_array();
		$data['banner'] = $thebanner;

		$get_banner = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='about' AND img_status='1' ORDER BY img_id DESC LIMIT 1");
		$thebanner = $get_banner->row_array();
		$data['image'] = $thebanner;

		$get_banner1 = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='babout' AND img_status='1' ORDER BY img_id DESC LIMIT 1");
		$thebanner1 = $get_banner1->row_array();
		$data['breadcrumb'] = $thebanner1;

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('studymaterial', $data);
		$this->load->view('inc/_footer', $data);
	}
	function Author()
	{
		$data = db_variables();
		$data['seo_title'] = 'Author- ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		// banner
		$get_banner = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='home' AND img_status='1' ORDER BY img_id DESC LIMIT 3");
		$thebanner = $get_banner->result_array();
		$data['banner'] = $thebanner;

		$get_banner = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='about' AND img_status='1' ORDER BY img_id DESC LIMIT 1");
		$thebanner = $get_banner->row_array();
		$data['image'] = $thebanner;

		$get_banner1 = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='babout' AND img_status='1' ORDER BY img_id DESC LIMIT 1");
		$thebanner1 = $get_banner1->row_array();
		$data['breadcrumb'] = $thebanner1;

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('Author', $data);
		$this->load->view('inc/_footer', $data);
	}

	function services()
	{

		if (check_service_status('1', '2', 'se') != '1') {
			redirect('error-404?e=this feature is not enabled.');
		}

		$data = db_variables();
		$data['seo_title'] = $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;


		$getAllServices = $this->db->query("SELECT * FROM yn_site_services ORDER BY service_id ASC LIMIT 10");
		$all_services = $getAllServices->result_array();
		$data['services'] = $all_services;

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('service', $data);
		$this->load->view('inc/_footer', $data);
	}

	function service($slug)
	{


		if (check_service_status('1', '2', 'se') != '1') {
			redirect('error-404?e=this feature is not enabled.');
		}

		$data = db_variables();
		$data['seo_title'] = $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		$slug = clean($slug);
		if ($slug == '') {
			redirect(base_url('error-404?e=No Service found.'));
		}
		$getTheService = $this->db->query("SELECT * FROM yn_site_services WHERE slug = '$slug'");
		$theService = $getTheService->row_array();
		$data['theService'] = $theService;

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('service_detail', $data);
		$this->load->view('inc/_footer', $data);
	}

	function pricing()
	{
		$data = db_variables();
		$data['seo_title'] = 'Pricing - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('inc/pricing.php', $data);
		$this->load->view('inc/_footer', $data);
	}



	function support($cid = 0, $cname = null)
	{
		$this->contact();
	}
	function career($cid = 0, $cname = null)
	{
		$this->contact();
	}

	function contact($cid = 0, $cname = null)
	{
		$data = db_variables();
		$data['seo_title'] = 'Contact us - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_title'];;
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['page_name'] = 'YNAPS';
		$data['meta_array'] = $data;

		$data['con_type'] = '0';
		if ($cid > '0') {
			$data['con_type'] = '6';
			$data['cid'] = $cid;
			$data['cname'] = unsmart_url($cname);
		}

		$get_banner1 = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='bcontact' AND img_status='1' ORDER BY img_id DESC LIMIT 1");
		$thebanner1 = $get_banner1->row_array();
		$data['breadcrumb'] = $thebanner1;

		$this->load->view('inc/_header', $data);
		// $this->load->view('inc/section.php', $data);
		$this->load->view('contact', $data);
		$this->load->view('inc/_footer', $data);
	}

	function accounts()
	{
		$this->account();
	}
	function account()
	{
		check_session('1', 'profile');
		$theoption = $this->uri->segment(3);
		switch ($theoption) {
			case 'login':
				$this->login();
				break;
			default:
				$this->login();
				break;
		}
	}

	public function debug_banners()
	{
		$this->load->view('debug_banners');
	}

	public function signup($user_type = null)
	{
		check_session(1, 'profile');

		@session_start();
		// Store redirect URL for after signup/OTP verification
		$redirect_url = $this->input->get('redirect');
		if (!empty($redirect_url)) {
			$_SESSION['redirect_after_login'] = $redirect_url;
		}

		$data = db_variables();
		$data['seo_title'] = 'Signup - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		$data['page_name'] = 'YNAPS';
		$data['user_type'] = $user_type;

		if (isset($_GET['refer'])) {
			$_SESSION['refer'] = $_GET['refer'];
		}

		$get_banner1 = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='bsignup' AND img_status='1' ORDER BY img_id DESC LIMIT 1");
		$thebanner1 = $get_banner1->row_array();
		$data['breadcrumb'] = $thebanner1;

		$this->load->view('inc/_header', $data);
		$this->load->view('signup', $data);
		$this->load->view('inc/_footer', $data);
	}


	public function login()
	{
		check_session(1, 'profile');
		
		@session_start();
		// Store redirect URL for after login
		$redirect_url = $this->input->get('redirect');
		if (!empty($redirect_url)) {
			$_SESSION['redirect_after_login'] = $redirect_url;
			$data['redirect_url'] = $redirect_url;
		} else {
			// Check if redirect URL exists in session
			$data['redirect_url'] = isset($_SESSION['redirect_after_login']) ? $_SESSION['redirect_after_login'] : base_url();
		}
		
		$data = db_variables();
		$data['seo_title'] = 'Login - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		$get_banner1 = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='bloginp' AND img_status='1' ORDER BY img_id DESC LIMIT 1");
		$thebanner1 = $get_banner1->row_array();
		$data['breadcrumb'] = $thebanner1;

		$this->load->view('inc/_header', $data);
		$this->load->view('login', $data);
		$this->load->view('inc/_footer', $data);
	}

	function login_otp_verify()
	{
		@session_start();
		//check_session('2','account');
		$data = db_variables();
		$data['seo_title'] = 'OTP Verify - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_title'];
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['page_name'] = 'YNAPS';
		$data['meta_array'] = $data;

		$this->load->view('inc/_header', $data);
		// $this->load->view('inc/section',$data);
		$this->load->view('login_otp_verify', $data);
		$this->load->view('inc/_footer', $data);
	}

	function password()
	{
		if (isset($_SESSION['yid']) && $_SESSION['yid'] != '') {
			redirect(base_url('profile'));
		}
		$data = db_variables();
		$data['seo_title'] = 'Password Reset - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_title'];
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['page_name'] = 'Password';
		$data['meta_array'] = $data;


		$this->load->view('inc/_header.php', $data);
		$this->load->view('password_reset.php', $data);
		$this->load->view('inc/_footer.php', $data);
	}

	function reset_password()
	{
		// if(isset($_SESSION['yid']) && $_SESSION['yid'] !=''){ redirect(base_url('profile')); }

		$data = db_variables();
		$data['seo_title'] = 'Password Reset - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_title'];
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['page_name'] = 'Reset Password';
		$data['meta_array'] = $data;

		$email = $this->input->get('mail');

		$getdats = $this->db->query("select pass_reset from yn_site_mem where email='$email' ");
		$thedetails = $getdats->row_array();

		$c = $this->input->get('c');
		if ($thedetails['pass_reset'] != $c) {
			redirect(base_url('error-404'));
		}

		$hash = $this->input->get('ha');

		if (sha1($email) . '90' != $hash) {
			redirect(base_url('profile'));
		} else {
			$data['e'] = $email;



			$this->load->view('inc/_header.php', $data);
			$this->load->view('password_reset2.php', $data);
			$this->load->view('inc/_footer.php', $data);
		}
	}

	function refund()
	{
		$data = db_variables();
		$data['seo_title'] = 'Refund - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['meta_array'] = $data;
		$data['page_name'] = 'Terms';

		$get_banner1 = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='brefund' AND img_status='1' ORDER BY img_id DESC LIMIT 1");
		$thebanner1 = $get_banner1->row_array();
		$data['breadcrumb'] = $thebanner1;


		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('refund', $data);
		$this->load->view('inc/_footer', $data);
	}
	function terms()
	{
		$data = db_variables();
		$data['seo_title'] = 'Terms & Conditions - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['meta_array'] = $data;
		$data['page_name'] = 'Terms';

		$get_banner1 = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='bterm' AND img_status='1' ORDER BY img_id DESC LIMIT 1");
		$thebanner1 = $get_banner1->row_array();
		$data['breadcrumb'] = $thebanner1;



		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('terms', $data);
		$this->load->view('inc/_footer', $data);
	}
	function check_pdfs()
	{
		$data = db_variables();
		$data['seo_title'] = 'Terms & Conditions - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['meta_array'] = $data;
		$data['page_name'] = 'Terms';





		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('check_pdfs', $data);
		$this->load->view('inc/_footer', $data);
	}
	function Mock_test_categories()
	{
		$data = db_variables();
		$data['seo_title'] = 'Mock Test Categories - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['meta_array'] = $data;
		$data['page_name'] = 'Terms';

		$get_banner1 = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='bterm' AND img_status='1' ORDER BY img_id DESC LIMIT 1");
		$thebanner1 = $get_banner1->row_array();
		$data['breadcrumb'] = $thebanner1;



		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('Mock_test_categories', $data);
		$this->load->view('inc/_footer', $data);
	}
	public function start($category_id = 0)
	{
		@session_start();
		
		// Check if user is logged in
		if (!isset($_SESSION['yid']) || $_SESSION['yid'] == '') {
			redirect(base_url('index.php/login?redirect=' . urlencode(current_url())));
			return;
		}
		
		// Check if category exists
		$category = $this->db->get_where('mock_categories', ['category_id' => (int)$category_id])->row_array();
		if (!$category) {
			show_404();
			return;
		}

		// Check if user has paid for this mock test using existing order tables
		$yid = (int)$_SESSION['yid'];
		$category_id_str = (string)$category_id;
		$checkPayment = $this->db->query("
			SELECT o.* FROM yn_ecom_order o
			INNER JOIN yn_ecom_orders_detail od ON o.so_order_id = od.checkout_order_id
			WHERE o.so_mid = $yid 
			AND TRIM(CAST(od.xod_pid AS CHAR)) = '" . $this->db->escape_str($category_id_str) . "'
			AND o.so_status = '1'
			ORDER BY o.so_date DESC LIMIT 1
		")->row_array();
		
		if (empty($checkPayment)) {
			// User hasn't paid - redirect to categories page with error
			$this->session->set_flashdata('error', 'Please purchase this mock test to access it.');
			redirect(base_url('index.php/main/Mock_test_categories'));
			return;
		}

		// Fetch MCQs for this category
		$mcqs = $this->db->get_where('mock_questions', ['category_id' => (int)$category_id])->result_array();

		// Load view and pass data
		$data['category'] = $category;
		$data['mcqs'] = $mcqs;
		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('mock_test_start', $data);
		$this->load->view('inc/_footer', $data);
	}
	public function result($submission_id)
	{
		// Fetch submission
		$submission = $this->db->get_where('mock_test_submissions', ['submission_id' => $submission_id])->row_array();

		if (!$submission) {
			show_404();
		}

		// Fetch category
		$category = $this->db->get_where('mock_categories', ['category_id' => $submission['category_id']])->row_array();

		// Pass to view
		$data = [
			'submission' => $submission,
			'category' => $category
		];
		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('mock_test_result', $data);
		$this->load->view('inc/_footer', $data);
	}


	function privacy()
	{
		$data = db_variables();
		$data['seo_title'] = 'Privacy Policy - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['meta_array'] = $data;
		$data['page_name'] = 'YNAPS';

		$get_banner1 = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='bprivacy' AND img_status='1' ORDER BY img_id DESC LIMIT 1");
		$thebanner1 = $get_banner1->row_array();
		$data['breadcrumb'] = $thebanner1;

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('privacy', $data);
		$this->load->view('inc/_footer', $data);
	}

	function faq()
	{
		$data = db_variables();
		$data['seo_title'] = 'FAQs - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['meta_array'] = $data;
		$data['page_name'] = 'FAQ';

		$get_banner1 = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='bfaq' AND img_status='1' ORDER BY img_id DESC LIMIT 1");
		$thebanner1 = $get_banner1->row_array();
		$data['breadcrumb'] = $thebanner1;



		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('inc/faq', $data);
		$this->load->view('inc/_footer', $data);
	}

	function profile()
	{
		@session_start();
		check_session('2', 'account');
		$data = db_variables();
		$data['seo_title'] = 'Profile - ' . $data['meta_title'];;
		$data['seo_description'] = $data['meta_title'];;
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['page_name'] = 'Profile';
		$data['meta_array'] = $data;

		$yid = $_SESSION['yid'];
		$themyuser_details = $this->ynaps_model->getprofile_data('*', $_SESSION['yid']);
		$data['profile_data'] = $themyuser_details;

		$yid = $_SESSION['yid'];
		$email = $_SESSION['email'];
		$phone = isset($_SESSION['phone']) ? $_SESSION['phone'] : '';
		
		// Get phone from profile data if not in session
		if (empty($phone) && !empty($themyuser_details['phone'])) {
			$phone = $themyuser_details['phone'];
		}
		if (empty($phone) && !empty($themyuser_details['contact'])) {
			$phone = $themyuser_details['contact'];
		}

		// Normalize phone number (remove spaces, dashes, etc. for comparison)
		$phone_normalized = '';
		if (!empty($phone)) {
			$phone_normalized = preg_replace('/[^0-9]/', '', $phone); // Keep only digits
		}

		// Link existing orders with this phone number to current user account (if they have so_mid = 0)
		$yid_escaped = (int)$yid;
		if (!empty($phone_normalized)) {
			$phone_escaped = $this->db->escape_str($phone);
			$phone_normalized_escaped = $this->db->escape_str($phone_normalized);
			// Update orders with matching phone number that don't have a user ID yet
			$this->db->query("UPDATE yn_ecom_order SET so_mid = '$yid_escaped' WHERE (so_mid = 0 OR so_mid IS NULL) AND (so_phone = '$phone_escaped' OR REPLACE(REPLACE(REPLACE(REPLACE(so_phone, ' ', ''), '-', ''), '(', ''), ')', '') = '$phone_normalized_escaped')");
		}

		// Get orders by user ID (so_mid) OR by phone number - this includes orders placed without login
		$where_conditions = ["so_mid = '$yid_escaped'"];
		
		if (!empty($phone_normalized)) {
			// Also search by phone number (both exact match and normalized)
			$phone_escaped = $this->db->escape_str($phone);
			$phone_normalized_escaped = $this->db->escape_str($phone_normalized);
			$where_conditions[] = "so_phone = '$phone_escaped'";
			$where_conditions[] = "REPLACE(REPLACE(REPLACE(REPLACE(so_phone, ' ', ''), '-', ''), '(', ''), ')', '') = '$phone_normalized_escaped'";
		}
		
		if (!empty($email)) {
			$email_escaped = $this->db->escape_str($email);
			$where_conditions[] = "so_email = '$email_escaped'";
		}
		
		$where_clause = '(' . implode(' OR ', $where_conditions) . ')';
		$getall_order = $this->db->query("select * from yn_ecom_order where $where_clause order by so_id desc");
		$all_order = $getall_order->result_array();
		
		// Determine order type for each order
		foreach ($all_order as $key => $order) {
			$order_id = $order['so_order_id'];
			
			// Get order details
			$order_details = $this->db->query("SELECT xod_pid, xod_name FROM yn_ecom_orders_detail WHERE checkout_order_id = '$order_id' LIMIT 1")->row_array();
			
			$order_type = 'Study Material'; // Default
			
			if (!empty($order_details['xod_pid'])) {
				$pid = $order_details['xod_pid'];
				
				// Check if it's a course
				$course_check = $this->db->query("SELECT course_id FROM x_edu_courses WHERE course_id = '$pid'")->row_array();
				if (!empty($course_check)) {
					$order_type = 'Course Enrollment';
				} else {
					// Check if it's a mock test
					$mock_check = $this->db->query("SELECT category_id FROM mock_categories WHERE category_id = '$pid'")->row_array();
					if (!empty($mock_check)) {
						$order_type = 'Mock Test';
					}
				}
			}
			
			$all_order[$key]['order_type'] = $order_type;
		}
		
		$data['allorders'] = $all_order;

		// Check if live class detail is requested (from URL parameter)
		$lc_id = isset($_GET['lc_id']) ? (int)$_GET['lc_id'] : 0;
		$data['live_class_detail'] = null;
		$data['show_live_class_detail'] = false;
		
		if ($lc_id > 0) {
			// Get live class details
			$live_class = $this->db->query("
				SELECT lc.*, sm.sm_name as study_material_name, sm.sm_id, c.course_name, c.course_id
				FROM yn_live_classes lc
				INNER JOIN x_edu_study_material sm ON lc.sm_id = sm.sm_id
				LEFT JOIN x_edu_courses c ON sm.sm_course_id = c.course_id
				WHERE lc.lc_id = '$lc_id'
				AND lc.lc_status = '1'
			")->row_array();
			
			if (!empty($live_class)) {
				// Verify user has purchased this study material (same logic as live classes tab)
				$where_conditions_sm = array();
				$where_conditions_sm[] = "so_mid = '$yid_escaped'";
				
				if (!empty($phone_normalized)) {
					$phone_escaped = $this->db->escape_str($phone);
					$phone_normalized_escaped = $this->db->escape_str($phone_normalized);
					$where_conditions_sm[] = "so_phone = '$phone_escaped'";
					$where_conditions_sm[] = "REPLACE(REPLACE(REPLACE(REPLACE(so_phone, ' ', ''), '-', ''), '(', ''), ')', '') = '$phone_normalized_escaped'";
				}
				if (!empty($email)) {
					$email_escaped = $this->db->escape_str($email);
					$where_conditions_sm[] = "so_email = '$email_escaped'";
				}
				$where_clause_sm = '(' . implode(' OR ', $where_conditions_sm) . ')';
				
				// Check if user has purchased this study material
				$has_access = false;
				$order_ids_sm = array();
				$getall_order_sm = $this->db->query("select so_order_id from yn_ecom_order where $where_clause_sm order by so_id desc");
				if ($getall_order_sm && $getall_order_sm->num_rows() > 0) {
					foreach ($getall_order_sm->result_array() as $ord) {
						if (!empty($ord['so_order_id'])) {
							$order_ids_sm[] = $this->db->escape_str($ord['so_order_id']);
						}
					}
				}
				
				if (!empty($order_ids_sm)) {
					$order_ids_str_sm = "'" . implode("','", $order_ids_sm) . "'";
					$sm_id_escaped = (int)$live_class['sm_id'];
					$check_access = $this->db->query("
						SELECT od.xod_sm_id, od.xod_pid
						FROM yn_ecom_orders_detail od
						WHERE od.checkout_order_id IN ($order_ids_str_sm)
						AND (od.xod_sm_id = '$sm_id_escaped' OR od.xod_pid = '$sm_id_escaped')
						LIMIT 1
					")->row_array();
					
					if (!empty($check_access)) {
						$has_access = true;
					} else {
						// Check if course purchase gives access
						$course_check = $this->db->query("
							SELECT DISTINCT od.xod_pid as course_id
							FROM yn_ecom_orders_detail od
							WHERE od.checkout_order_id IN ($order_ids_str_sm)
							AND od.xod_pid IS NOT NULL
							AND od.xod_pid != ''
							AND od.xod_pid != '0'
						")->result_array();
						
						if (!empty($course_check)) {
							foreach ($course_check as $crs) {
								$course_id = (int)$crs['course_id'];
								$course_sm = $this->db->query("
									SELECT sm_id 
									FROM x_edu_study_material 
									WHERE sm_course_id = '$course_id' 
									AND sm_id = '$sm_id_escaped'
									AND sm_status = '1'
									LIMIT 1
								")->row_array();
								if (!empty($course_sm)) {
									$has_access = true;
									break;
								}
							}
						}
					}
				}
				
				if ($has_access) {
					$data['live_class_detail'] = $live_class;
					$data['show_live_class_detail'] = true;
					
					// Calculate time status
					$class_datetime = strtotime($live_class['lc_date'] . ' ' . $live_class['lc_start_time']);
					$class_end_datetime = strtotime($live_class['lc_date'] . ' ' . $live_class['lc_end_time']);
					$current_time = time();
					$data['is_upcoming'] = ($class_datetime > $current_time);
					$data['is_ongoing'] = ($current_time >= $class_datetime && $current_time <= $class_end_datetime);
					$data['is_past'] = ($current_time > $class_end_datetime);
					$data['is_today'] = (date('Y-m-d', $class_datetime) == date('Y-m-d'));
				}
			}
		}

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section2', $data);
		$this->load->view('profile', $data);
		$this->load->view('inc/_footer', $data);
	}
	function view_checkout()
	{
		@session_start();
		check_session('2', 'account');
		$data = db_variables();
		$data['seo_title'] = 'Order Detail - ' . $data['meta_title'];;
		$data['seo_description'] = $data['meta_title'];;
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['page_name'] = 'Profile';
		$data['meta_array'] = $data;

		$yid = $_SESSION['yid'];
		$themyuser_details = $this->ynaps_model->getprofile_data('*', $_SESSION['yid']);
		$data['profile_data'] = $themyuser_details;

		$yid = $_SESSION['yid'];
		$email = $_SESSION['email'];

		$getall_order = $this->db->query("select * from yn_ecom_order where so_email = '$email' order by so_id desc");
		$all_order = $getall_order->result_array();
		$data['allorders'] = $all_order;


		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section2', $data);
		$this->load->view('view_checkout', $data);
		$this->load->view('inc/_footer', $data);
	}

	function otp_verify()
	{
		check_session(2, 'accounts');
		$data = db_variables();
		$data['seo_title'] = 'OTP Verify - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		$thedetails = $this->ynaps_model->getprofile_data('*', $_SESSION['yid']);
		if ($thedetails['user_email_status'] == '1') {
			redirect(base_url('profile'));
		}
		$data['profile_data'] = $thedetails;
		$yid = $_SESSION['yid'];
		$email = $_SESSION['email'];



		$this->load->view('inc/_header', $data);
		$this->load->view('otp_verify', $data);
		$this->load->view('inc/_footer', $data);
	}

	function edit($data_pass = null)
	{
		$data = db_variables();
		$data['seo_title'] = 'Edit - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_title'];
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['page_name'] = 'Edit';
		$data['meta_array'] = $data;

		$themyuser_details = $this->ynaps_model->getprofile_data('*', $_SESSION['yid']);
		$data['profile_data'] = $themyuser_details;



		check_session('2', 'account');
		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section2', $data);
		$this->load->view('edit', $data);
		$this->load->view('inc/_footer', $data);
	}

	function verify()
	{
		$data = db_variables();
		$data['seo_title'] = $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		$data['profile_data'] = $this->ynaps_model->getprofile_data('*', $_SESSION['yid']);


		check_session('2', 'account');
		$this->load->view('inc/_header', $data);
		$this->load->view('verify', $data);
		$this->load->view('inc/_footer', $data);
	}

	function logout()
	{
		$user_data = $this->session->all_userdata();
		foreach ($user_data as $key => $value) {
			if ($key != 'session_id' && $key != 'ip_address' && $key != 'user_agent' && $key != 'last_activity') {
				$this->session->unset_userdata($key);
			}
		}
		$this->session->sess_destroy();
		redirect(base_url());
	}


	function blog()
	{


		// if (check_service_status('1', '2', 'bl') != '1') {
		// 	redirect('error-404?e=this feature is not enabled.');
		// }

		$data = db_variables();
		$data['seo_title'] = 'Blogs - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['page_name'] = 'YNAPS';
		$data['meta_array'] = $data;

		$geththeblogs = $this->db->query("select * from yn_site_blogs order by blog_id desc");
		$total_num = $geththeblogs->num_rows(); //'100';
		$rec_per_page = '9';
		$this->load->library('pagination');
		$config['base_url'] = base_url('blog');
		$config['total_rows'] = $total_num;
		$config['per_page'] = $rec_per_page;
		$config['num_links'] = 3;
		$config['use_page_numbers'] = TRUE;
		$config['full_tag_open'] = "";
		$config['full_tag_close'] = '';
		$config['reuse_query_string'] = true;
		$config['page_query_string'] = TRUE;
		$config['query_string_segment'] = 'page';
		$this->pagination->initialize($config);

		@$page = $_GET['page'];
		if (isset($_GET['page'])) {
			$page = $page - 1;
		}
		$limit1 = $page * $rec_per_page;

		//echo "select * from yn_site_blogs order by blog_id desc  limit $limit1, $rec_per_page ";die;
		$geththeblogs = $this->db->query("select * from yn_site_blogs order by blog_id desc limit $limit1, $rec_per_page ");
		$all_blogs = $geththeblogs->result_array();
		$data['blogs'] = $all_blogs;

		$get_banner1 = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='bblog' AND img_status='1' ORDER BY img_id DESC LIMIT 1");
		$thebanner1 = $get_banner1->row_array();
		$data['breadcrumb'] = $thebanner1;

		if (@$_GET['q'] != '') {
			$q = clean($_GET['q']);
			$allblogs = $this->db->query("select * from yn_site_blogs where title like '%$q%' order by blog_id desc");
		} else {
			$allblogs = $this->db->query("select * from yn_site_blogs order by blog_id desc  limit 10 ");
		}


		$show_blogs = $allblogs->result_array();
		$data['show_blogs'] = $show_blogs;

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section.php', $data);
		$this->load->view('blog', $data);
		$this->load->view('inc/_footer', $data);
	}
	function theBlog($slug)
	{


		// if (check_service_status('1', '2', 'bl') != '1') {
		// 	redirect('error-404?e=this feature is not enabled.');
		// }

		count_view('bl', 'un');

		$data = db_variables();
		$config['base_url'] = base_url('blog');

		$geththeblog = $this->db->query("select * from yn_site_blogs where slug='$slug'");
		$theBlog = $geththeblog->row_array();
		$data['blog_rea'] = $theBlog;

		if (empty($theBlog)) {
			redirect(base_url('error-404?e=no blog found.'));
		}

		$data['seo_title'] = $theBlog['title'];
		$data['seo_description'] = trim_text(strip_tags($theBlog['comment']), 200);
		if ($theBlog['blog_img'] != '')
			$data['seo_image'] = base_url('assets/avator/upload/') . $theBlog['blog_img'];
		else
			$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['page_name'] = 'YNAPS';
		$data['meta_array'] = $data;

		$geththeblogs = $this->db->query("select * from yn_site_blogs order by blog_id desc limit 10 ");
		$all_blogs = $geththeblogs->result_array();
		$data['show_blogs'] = $all_blogs;


		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('theBlog', $data);
		$this->load->view('inc/_footer', $data);
	}

	function setcurrency()
	{
		$cur = xss_clean($_GET['c']);
		switch ($cur) {
			case 'USD':
			case 'INR':
				$_SESSION['currency'] = $cur;
				break;
			default:
				$_SESSION['currency'] = $cur;
				break;
		}
	}


	function pay_now()
	{
		@session_start();
		$cid = $_SESSION['ecom_order_id'];
		// check_session('2', 'account');

		$data = db_variables();
		$data['seo_title'] = 'Pay Now - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		@$yid = $_SESSION['yid'];
		$thedetails = $this->ynaps_model->getprofile_data('*', $yid);
		$data['profile_data'] = $thedetails;

		$getListing = $this->db->query("SELECT * FROM `yn_ecom_order` where so_order_id='$cid'");
		$data['theorder'] = $getListing->row_array();
		// if (empty($data['theorder'])) {
		// 	redirect(base_url('profile'));
		// }

		// Get order details for checkout orders
		$order_details = $this->db->query("SELECT * FROM yn_ecom_orders_detail WHERE checkout_order_id = '$cid'")->result_array();
		$data['order_details'] = $order_details;
		
		// Check if this is a checkout order (study material) vs course/mock test
		$is_checkout_order = false;
		if (!empty($order_details)) {
			// Check if first item is not a course or mock test
			$first_item_pid = $order_details[0]['xod_pid'];
			$course_check = $this->db->query("SELECT course_id FROM x_edu_courses WHERE course_id = '$first_item_pid'")->row_array();
			$mock_check = $this->db->query("SELECT category_id FROM mock_categories WHERE category_id = '$first_item_pid'")->row_array();
			if (empty($course_check) && empty($mock_check)) {
				$is_checkout_order = true;
			}
		}
		$data['is_checkout_order'] = $is_checkout_order;

		$data['cid'] = $cid;

		$this->load->view('inc/_header', $data);
		// $this->load->view('inc/section', $data);
		$this->load->view('pay_now.php', $data);
		$this->load->view('inc/_footer', $data);
	}

	function thank_you()
	{
		// @session_start();
		// check_session('2', 'account');
		$data = db_variables();
		$data['seo_title'] = 'Thank You - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		$get_banner1 = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='bthank' AND img_status='1' ORDER BY img_id DESC LIMIT 1");
		$thebanner1 = $get_banner1->row_array();
		$data['breadcrumb'] = $thebanner1;


		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('thank_you.php', $data);
		$this->load->view('inc/_footer', $data);
	}

	function payment_failed()
	{
		// @session_start();
		// check_session('2', 'account');
		$data = db_variables();
		$data['seo_title'] = 'Payment Failed - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;
		$_SESSION['ecom_order_id'] = 1231231231;

		if (isset($_SESSION['ecom_order_id'])) {
			unset($_SESSION['ecom_order_id']);
			unset($_SESSION['ecom_cart']);
		}


		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('payment_failed', $data);
		$this->load->view('inc/_footer', $data);
	}
	function viewEnrollment()
	{
		check_session('2', 'account');
		$data = db_variables();
		$data['seo_title'] = 'THE GITA GYAN - Learn Bhagavad Gita Online: Courses, Chapters & Practice Tests ';
		$data['seo_description'] = 'THE GITA GYAN - Learn Bhagavad Gita Online: Courses, Chapters & Practice Tests  ';
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['page_name'] = 'YNAPS';

		$yid = $_SESSION['yid'];
		$themyuser_details = $this->ynaps_model->getprofile_data('*', $_SESSION['yid']);
		$data['profile_data'] = $themyuser_details;

		$this->load->view('inc/_header.php', $data);
		$this->load->view('viewEnrollment.php', $data);
		$this->load->view('inc/_footer.php', $data);
	}
	function viewMaterial()
	{
		check_session('2', 'account');
		$data = db_variables();

		// SEO data
		$data['seo_title'] = 'THE GITA GYAN - Learn Bhagavad Gita Online: Courses, Chapters & Practice Tests';
		$data['seo_description'] = 'THE GITA GYAN - Learn Bhagavad Gita Online: Courses, Chapters & Practice Tests';
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['page_name'] = 'YNAPS';

		$yid = $_SESSION['yid'];
		$data['profile_data'] = $this->ynaps_model->getprofile_data('*', $yid);

		// Get GET variables safely
		$data['smid'] = $smid = isset($_GET['smid']) ? $_GET['smid'] : 0;
		$data['enrol'] = $enrol = isset($_GET['enrol']) ? $_GET['enrol'] : 0;

		// Fetch enrollment
		$theEnrolls = $this->db->query("
        SELECT e.*, c.* 
        FROM x_edu_enrollments e
        JOIN x_edu_courses c ON e.co_course_id = c.course_id
        WHERE e.co_user_id = '$yid' AND e.co_id = '$enrol'
        GROUP BY e.co_id
    ");
		$data['enrollment'] = $enrollment = $theEnrolls->row_array();

		if (!empty($enrollment)) {

			// Fetch material reviews
			$getreviews = $this->db->query("
            SELECT r.*, m.* 
            FROM x_edu_material_review r
            JOIN site_mem m ON r.mr_user = m.mid
            WHERE r.mr_type='rmaterial' 
              AND r.mr_lid='$enrol' 
              AND r.mr_smid='$smid' 
              AND r.mr_user='$yid'
            ORDER BY r.mrid DESC
        ");
			$data['review_count'] = $getreviews->num_rows();
			$data['all_reviews_are'] = $getreviews->result_array();

			// Fetch recorded videos for this study material
			$get_videos = $this->db->query("
				SELECT smv.*, lc.lc_title as live_class_title
				FROM yn_study_material_videos smv
				LEFT JOIN yn_live_classes lc ON smv.lc_id = lc.lc_id
				WHERE smv.sm_id = '$smid' 
				AND smv.smv_status = '1'
				ORDER BY smv.smv_created_at ASC
			");
			$data['recorded_videos'] = $get_videos->result_array();

			// Load views
			$this->load->view('inc/_header.php', $data);
			$this->load->view('viewMaterial.php', $data);
			$this->load->view('inc/_footer.php', $data);
		} else {
			// Enrollment not found, redirect safely
			if (isset($_SESSION['yid']) && $_SESSION['yid'] > 0) {
				redirect(base_url('profile'));
			} else {
				redirect(base_url());
			}
		}
	}




	function Study_enrollments()
	{
		@session_start();
		check_session('2', 'account');
		$data = db_variables();
		$data['seo_title'] = 'THE GITA GYAN - Learn Bhagavad Gita Online: Courses, Chapters & Practice Tests ';
		$data['seo_description'] = 'THE GITA GYAN - Learn Bhagavad Gita Online: Courses, Chapters & Practice Tests  ';
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['page_name'] = 'Profile';

		$yid = $_SESSION['yid'];
		// $themyuser_details=$this->ynaps_model->getprofile_data('*',$_SESSION['yid']);
		// $data['profile_data']=$themyuser_details;

		$theEnrolls = $this->db->query("select * from x_edu_enrollments,x_edu_courses where co_course_id=course_id and co_user_id='$yid' order by co_id DESC limit 15");
		$data['enrollments'] = $theEnrolls->result_array();

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section2', $data);
		$this->load->view('Study_enrollments', $data);
		$this->load->view('inc/_footer', $data);
	}
	function course_detail($id, $name)
	{
		$data = db_variables();
		$thecourse = $this->db->query("SELECT * FROM x_edu_courses WHERE course_id='$id' AND course_status='1'");
		$thecourse = $thecourse->row_array();

		if (!empty($thecourse)) {
			$data['id'] = $id;
			$data['thiscourse'] = $thecourse;


			$data['seo_title'] = $thecourse['course_name'] . ' - Learn Bhagavad Gita Online: Courses, Chapters & Practice Tests';
		} else {
			redirect(base_url('courses'));
		}


		// $data['seo_title'] = 'Course Details - Learn Bhagavad Gita Online: Courses, Chapters & Practice Tests ';
		$data['seo_description'] = 'THE GITA GYAN - Learn Bhagavad Gita Online: Courses, Chapters & Practice Tests  ';
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['page_name'] = 'YNAPS';

		$thecourse = $this->db->query("select * from x_edu_courses where course_id='$id' and course_status='1'");
		$thecourse = $thecourse->row_array();
		if (!empty($thecourse)) {
			$data['id'] = $id;
			$data['thiscourse'] = $thecourse;
		} else {
			redirect(base_url('courses'));
		}

		$getreviews = $this->db->query("select * from x_edu_course_review,site_mem where cr_user=mid and cr_type='review' and  cr_lid = '$id' order by crid DESC");
		$data['review_count'] = $getreviews->num_rows();
		$data['all_reviews_are'] = $getreviews->result_array();

		$getMaterials = $this->db->query("SELECT * from  x_edu_study_material where sm_course_id='$id'");
		$data['material_count'] = $getMaterials->num_rows();

		$data['enrolled'] = '0';

		if (isset($_SESSION['yid'])) {
			$yid = $_SESSION['yid'];
			$getEnrollment = $this->db->query("SELECT * from  x_edu_enrollments where co_user_id='$yid' and co_course_id='$id' order by co_id desc limit 1");
			if ($getEnrollment->num_rows() > '0') {
				$data['enrolled'] = '1';
				$data['theEnroll'] = $theEnroll = $getEnrollment->row_array();
			}
		}

		$this->load->view('inc/_header', $data);
		$this->load->view('course_detail.php', $data);
		$this->load->view('inc/_footer', $data);
	}

	function live_class_detail()
	{
		@session_start();
		check_session('2', 'account');
		$data = db_variables();
		$data['seo_title'] = 'Live Class Details - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['page_name'] = 'YNAPS';

		$yid = $_SESSION['yid'];
		$themyuser_details = $this->ynaps_model->getprofile_data('*', $yid);
		$data['profile_data'] = $themyuser_details;

		$lc_id = isset($_GET['lc_id']) ? (int)$_GET['lc_id'] : 0;

		if ($lc_id == 0) {
			redirect(base_url('profile'));
		}

		// Get live class details
		$live_class = $this->db->query("
			SELECT lc.*, sm.sm_name as study_material_name, sm.sm_id, c.course_name, c.course_id
			FROM yn_live_classes lc
			INNER JOIN x_edu_study_material sm ON lc.sm_id = sm.sm_id
			LEFT JOIN x_edu_courses c ON sm.sm_course_id = c.course_id
			WHERE lc.lc_id = '$lc_id'
			AND lc.lc_status = '1'
		")->row_array();

		if (empty($live_class)) {
			redirect(base_url('profile'));
		}

		// Verify user has purchased this study material
		$has_access = false;
		$get_purchased_sm = $this->db->query("
			SELECT DISTINCT od.xod_pid 
			FROM yn_ecom_order o
			INNER JOIN yn_ecom_orders_detail od ON o.so_order_id = od.checkout_order_id
			WHERE o.so_mid = '$yid' 
			AND o.so_status = '1'
			AND o.or_pay_status = '1'
			AND od.xod_pid = '{$live_class['sm_id']}'
		")->row_array();

		if (!empty($get_purchased_sm)) {
			$has_access = true;
		}

		if (!$has_access) {
			redirect(base_url('profile'));
		}

		$data['live_class'] = $live_class;
		$data['has_access'] = $has_access;

		// Calculate time status
		$class_datetime = strtotime($live_class['lc_date'] . ' ' . $live_class['lc_start_time']);
		$class_end_datetime = strtotime($live_class['lc_date'] . ' ' . $live_class['lc_end_time']);
		$current_time = time();
		$data['is_upcoming'] = ($class_datetime > $current_time);
		$data['is_ongoing'] = ($current_time >= $class_datetime && $current_time <= $class_end_datetime);
		$data['is_past'] = ($current_time > $class_end_datetime);
		$data['is_today'] = (date('Y-m-d', $class_datetime) == date('Y-m-d'));

		// Fetch recorded videos for this live class and study material
		$get_videos = $this->db->query("
			SELECT smv.*, lc.lc_title as live_class_title
			FROM yn_study_material_videos smv
			LEFT JOIN yn_live_classes lc ON smv.lc_id = lc.lc_id
			WHERE (smv.lc_id = '$lc_id' OR smv.sm_id = '{$live_class['sm_id']}')
			AND smv.smv_status = '1'
			ORDER BY smv.smv_created_at ASC
		");
		$data['recorded_videos'] = $get_videos->result_array();

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section2', $data);
		$this->load->view('live_class_detail', $data);
		$this->load->view('inc/_footer', $data);
	}

	function recorded_videos()
	{
		@session_start();
		check_session('2', 'account');
		$data = db_variables();
		$data['seo_title'] = 'Recorded Videos - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['page_name'] = 'YNAPS';

		$yid = $_SESSION['yid'];
		$themyuser_details = $this->ynaps_model->getprofile_data('*', $yid);
		$data['profile_data'] = $themyuser_details;

		// Check if detail page requested
		$sm_id = isset($_GET['sm_id']) ? (int)$_GET['sm_id'] : 0;
		$lc_id = isset($_GET['lc_id']) ? (int)$_GET['lc_id'] : 0;

		if ($sm_id > 0 || $lc_id > 0) {
			// Show detail page
			$this->recorded_videos_detail($data, $sm_id, $lc_id, $yid);
		} else {
			// Show list page
			$this->recorded_videos_list($data, $yid);
		}
	}

	private function recorded_videos_list($data, $yid)
	{
		// Use EXACT same logic as live classes in profile page (line 200-350)
		$yid_escaped = (int)$yid;
		$email = isset($_SESSION['email']) ? $_SESSION['email'] : '';
		$phone = isset($_SESSION['phone']) ? $_SESSION['phone'] : '';
		
		// Get phone from profile data if not in session
		if (empty($phone) && !empty($data['profile_data']['phone'])) {
			$phone = $data['profile_data']['phone'];
		}
		if (empty($phone) && !empty($data['profile_data']['contact'])) {
			$phone = $data['profile_data']['contact'];
		}
		
		// Normalize phone number
		$phone_normalized = '';
		if (!empty($phone)) {
			$phone_normalized = preg_replace('/[^0-9]/', '', $phone);
		}
		
		// IMPORTANT: Link existing orders with this phone number to current user account (if they have so_mid = 0)
		// This is the SAME step as profile page (line 730)
		if (!empty($phone_normalized)) {
			$phone_escaped = $this->db->escape_str($phone);
			$phone_normalized_escaped = $this->db->escape_str($phone_normalized);
			// Update orders with matching phone number that don't have a user ID yet
			$this->db->query("UPDATE yn_ecom_order SET so_mid = '$yid_escaped' WHERE (so_mid = 0 OR so_mid IS NULL) AND (so_phone = '$phone_escaped' OR REPLACE(REPLACE(REPLACE(REPLACE(so_phone, ' ', ''), '-', ''), '(', ''), ')', '') = '$phone_normalized_escaped')");
		}
		
		// Get orders by user ID OR by phone number OR by email (same as live classes)
		$where_conditions = array();
		$where_conditions[] = "so_mid = '$yid_escaped'";
		
		if (!empty($phone_normalized)) {
			$phone_escaped = $this->db->escape_str($phone);
			$phone_normalized_escaped = $this->db->escape_str($phone_normalized);
			$where_conditions[] = "so_phone = '$phone_escaped'";
			$where_conditions[] = "REPLACE(REPLACE(REPLACE(REPLACE(so_phone, ' ', ''), '-', ''), '(', ''), ')', '') = '$phone_normalized_escaped'";
		}
		
		if (!empty($email)) {
			$email_escaped = $this->db->escape_str($email);
			$where_conditions[] = "so_email = '$email_escaped'";
		}
		
		$where_clause = '(' . implode(' OR ', $where_conditions) . ')';
		// Get ALL orders (SAME as live classes - NO payment status filter)
		// Live classes show even if payment status is 0 (line 195 in profile.php)
		$getall_order = $this->db->query("SELECT * FROM yn_ecom_order WHERE $where_clause ORDER BY so_id DESC");
		$all_order = $getall_order->result_array();
		
		$purchased_sm_ids = array();
		
		if (!empty($all_order)) {
			// Get order IDs
			$order_ids = array();
			foreach ($all_order as $order) {
				if (!empty($order['so_order_id'])) {
					$order_ids[] = $this->db->escape_str($order['so_order_id']);
				}
			}
			
			if (!empty($order_ids)) {
				$order_ids_str = "'" . implode("','", $order_ids) . "'";
				
				// Get order details - use xod_sm_id if available, otherwise fallback to xod_pid (SAME AS LIVE CLASSES)
				$all_order_details = $this->db->query("
					SELECT DISTINCT 
						od.xod_sm_id,
						od.xod_pid
					FROM yn_ecom_orders_detail od
					INNER JOIN yn_ecom_order o ON od.checkout_order_id = o.so_order_id
					WHERE od.checkout_order_id IN ($order_ids_str)
					AND (od.xod_sm_id IS NOT NULL OR (od.xod_pid IS NOT NULL AND od.xod_pid != '' AND od.xod_pid != '0'))
				")->result_array();
				
				if (!empty($all_order_details)) {
					foreach ($all_order_details as $detail) {
						$sm_id = null;
						
						// First check xod_sm_id (directly stores study material ID)
						if (!empty($detail['xod_sm_id'])) {
							$sm_id = (int)$detail['xod_sm_id'];
						} 
						// Fallback: Check if xod_pid is a study material ID
						elseif (!empty($detail['xod_pid'])) {
							$pid = trim($detail['xod_pid']);
							if (!empty($pid) && $pid != '0') {
								$pid_int = (int)$pid;
								
								// Check if xod_pid is directly a study material ID
								$sm_check = $this->db->query("SELECT sm_id FROM x_edu_study_material WHERE sm_id = '$pid_int' AND sm_status = '1'")->row_array();
								if (!empty($sm_check)) {
									$sm_id = $pid_int;
								} else {
									// If not found, check if xod_pid is a course ID - get all study materials from that course
									$course_check = $this->db->query("SELECT course_id FROM x_edu_courses WHERE course_id = '$pid_int'")->row_array();
									if (!empty($course_check)) {
										// Get all study materials for this course
										$course_sm = $this->db->query("SELECT sm_id FROM x_edu_study_material WHERE sm_course_id = '$pid_int' AND sm_status = '1'")->result_array();
										foreach ($course_sm as $csm) {
											$purchased_sm_ids[] = (int)$csm['sm_id'];
										}
									}
								}
							}
						}
						
						if (!empty($sm_id)) {
							$purchased_sm_ids[] = $sm_id;
						}
					}
				}
			}
		}
		
		// Remove duplicates
		$sm_ids = array_unique($purchased_sm_ids);

		// Debug: Add debug info to data
		$data['debug_sm_ids'] = $sm_ids;
		$data['debug_sm_count'] = count($sm_ids);

		// Get study materials and live classes that have videos
		$video_items = array();
		
		if (!empty($sm_ids)) {
			$sm_ids_str = implode(',', $sm_ids);
			
			// Get ALL videos for purchased study materials
			// IMPORTANT: Don't check live class status - show videos even if live class is inactive or doesn't exist
			// Only check: video status = 1 AND study material status = 1
			$all_videos = $this->db->query("
				SELECT DISTINCT 
					smv.smv_id,
					smv.sm_id,
					smv.lc_id,
					smv.smv_title,
					smv.smv_description,
					smv.smv_video_url,
					smv.smv_status,
					sm.sm_id as sm_id_check,
					sm.sm_name,
					sm.sm_desc,
					sm.sm_course_id,
					lc.lc_id as lc_id_check,
					lc.lc_title,
					lc.lc_description,
					lc.lc_date,
					c.course_name
				FROM yn_study_material_videos smv
				INNER JOIN x_edu_study_material sm ON smv.sm_id = sm.sm_id
				LEFT JOIN yn_live_classes lc ON smv.lc_id = lc.lc_id
				LEFT JOIN x_edu_courses c ON sm.sm_course_id = c.course_id
				WHERE smv.sm_id IN ($sm_ids_str)
				AND smv.smv_status = '1'
				AND sm.sm_status = '1'
			")->result_array();
			
			// Organize videos by study material and live class
			$sm_video_map = array();
			$lc_video_map = array();
			
			foreach ($all_videos as $video) {
				$sm_id = $video['sm_id'];
				$lc_id_value = !empty($video['lc_id']) ? (int)$video['lc_id'] : 0;
				
				// If video has lc_id, add to live class map
				if ($lc_id_value > 0) {
					if (!isset($lc_video_map[$lc_id_value])) {
						// Fetch live class details if not already fetched
						$lc_title = !empty($video['lc_title']) ? $video['lc_title'] : 'Live Class Recording';
						$lc_description = !empty($video['lc_description']) ? $video['lc_description'] : '';
						$lc_date = !empty($video['lc_date']) ? $video['lc_date'] : '';
						
						// If live class title is still empty, try to fetch from database
						if (empty($lc_title) || $lc_title == 'Live Class Recording') {
							$lc_fetch = $this->db->query("
								SELECT lc_title, lc_description, lc_date 
								FROM yn_live_classes 
								WHERE lc_id = '$lc_id_value'
								LIMIT 1
							")->row_array();
							
							if (!empty($lc_fetch)) {
								$lc_title = !empty($lc_fetch['lc_title']) ? $lc_fetch['lc_title'] : 'Live Class Recording';
								$lc_description = !empty($lc_fetch['lc_description']) ? $lc_fetch['lc_description'] : '';
								$lc_date = !empty($lc_fetch['lc_date']) ? $lc_fetch['lc_date'] : '';
							}
						}
						
						$lc_video_map[$lc_id_value] = array(
							'lc_id' => $lc_id_value,
							'lc_title' => $lc_title,
							'lc_description' => $lc_description,
							'lc_date' => $lc_date,
							'sm_id' => $sm_id,
							'sm_name' => $video['sm_name'],
							'course_name' => $video['course_name'],
							'video_count' => 0,
							'item_type' => 'live_class'
						);
					}
					$lc_video_map[$lc_id_value]['video_count']++;
				} else {
					// Video not linked to live class - add to study material map
					if (!isset($sm_video_map[$sm_id])) {
						$sm_video_map[$sm_id] = array(
							'sm_id' => $sm_id,
							'sm_name' => $video['sm_name'],
							'sm_desc' => $video['sm_desc'],
							'course_name' => $video['course_name'],
							'video_count' => 0,
							'item_type' => 'study_material'
						);
					}
					$sm_video_map[$sm_id]['video_count']++;
				}
			}
			
			$video_items = array_merge(array_values($sm_video_map), array_values($lc_video_map));
			
			// Debug info
			$data['debug_all_videos_count'] = count($all_videos);
			$data['debug_sm_video_map'] = $sm_video_map;
			$data['debug_lc_video_map'] = $lc_video_map;
		}

		// Instead of organizing by items, pass ALL videos directly
		$data['all_videos'] = isset($all_videos) ? $all_videos : array();
		$data['video_items'] = $video_items;
		$data['debug_video_count'] = count($video_items);

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section2', $data);
		$this->load->view('recorded_videos_list', $data);
		$this->load->view('inc/_footer', $data);
	}

	private function recorded_videos_detail($data, $sm_id, $lc_id, $yid)
	{
		// Verify user has access
		$has_access = false;
		$study_material = null;
		$live_class = null;

		if ($sm_id > 0) {
			$study_material = $this->db->query("
				SELECT sm.*, c.course_name, c.course_id
				FROM x_edu_study_material sm
				LEFT JOIN x_edu_courses c ON sm.sm_course_id = c.course_id
				WHERE sm.sm_id = '$sm_id'
				AND sm.sm_status = '1'
			")->row_array();

			if (!empty($study_material)) {
				// Check if user purchased this study material
				$get_purchased = $this->db->query("
					SELECT DISTINCT od.xod_pid 
					FROM yn_ecom_order o
					INNER JOIN yn_ecom_orders_detail od ON o.so_order_id = od.checkout_order_id
					WHERE o.so_mid = '$yid' 
					AND o.so_status = '1'
					AND o.or_pay_status = '1'
					AND od.xod_pid = '$sm_id'
				")->row_array();

				if (!empty($get_purchased)) {
					$has_access = true;
				}
			}
		}

		if ($lc_id > 0) {
			$live_class = $this->db->query("
				SELECT lc.*, sm.sm_name as study_material_name, sm.sm_id, c.course_name, c.course_id
				FROM yn_live_classes lc
				INNER JOIN x_edu_study_material sm ON lc.sm_id = sm.sm_id
				LEFT JOIN x_edu_courses c ON sm.sm_course_id = c.course_id
				WHERE lc.lc_id = '$lc_id'
				AND lc.lc_status = '1'
			")->row_array();

			if (!empty($live_class)) {
				// Check if user purchased this study material
				$get_purchased = $this->db->query("
					SELECT DISTINCT od.xod_pid 
					FROM yn_ecom_order o
					INNER JOIN yn_ecom_orders_detail od ON o.so_order_id = od.checkout_order_id
					WHERE o.so_mid = '$yid' 
					AND o.so_status = '1'
					AND o.or_pay_status = '1'
					AND od.xod_pid = '{$live_class['sm_id']}'
				")->row_array();

				if (!empty($get_purchased)) {
					$has_access = true;
					$sm_id = $live_class['sm_id'];
				}
			}
		}

		if (!$has_access || (empty($study_material) && empty($live_class))) {
			redirect(base_url('recorded_videos'));
		}

		// Fetch videos
		$where_conditions = array();
		if ($lc_id > 0) {
			$where_conditions[] = "(smv.lc_id = '$lc_id' OR smv.sm_id = '$sm_id')";
		} else {
			$where_conditions[] = "smv.sm_id = '$sm_id'";
		}

		$where_clause = implode(' AND ', $where_conditions);
		$get_videos = $this->db->query("
			SELECT smv.*, lc.lc_title as live_class_title
			FROM yn_study_material_videos smv
			LEFT JOIN yn_live_classes lc ON smv.lc_id = lc.lc_id
			WHERE $where_clause
			AND smv.smv_status = '1'
			ORDER BY smv.smv_created_at ASC
		");
		$data['recorded_videos'] = $get_videos->result_array();
		$data['study_material'] = $study_material;
		$data['live_class'] = $live_class;

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section2', $data);
		$this->load->view('recorded_videos_detail', $data);
		$this->load->view('inc/_footer', $data);
	}

	function search()
	{
		$data = db_variables();
		$data['seo_title'] = 'All Courses- Learn Bhagavad Gita Online: Courses, Chapters & Practice Tests ';
		$data['seo_description'] = 'THE GITA GYAN - Learn Bhagavad Gita Online: Courses, Chapters & Practice Tests  ';
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['page_name'] = 'YNAPS';

		$conditions = array();

		@$q = $_GET['q'];
		@$cat = $_GET['cat'];
		@$price = clean($_GET['price']);
		if ($price != '') {
			$conditions[] = "course_price = ('$price') ";
		}

		if ($cat != '' && $cat != '0') {
			// Support both single category ID and comma-separated list
			if (strpos($cat, ',') !== false) {
				$cat = "'" . str_replace(",", "','", $cat) . "'";
				$conditions[] = "course_cat IN ($cat) ";
			} else {
				$conditions[] = "course_cat = '$cat' ";
			}
		}

		if ($q != '') {
			// Clean the search query - replace hyphens with spaces and normalize
			$clean_q = str_replace(['-', '_'], ' ', $q);
			$clean_q = preg_replace('/\s+/', ' ', trim($clean_q)); // Remove extra spaces
			
			// Create multiple search variations
			$search_variations = [
				$q,                    // Original query
				$clean_q,             // Cleaned query (spaces instead of hyphens)
				str_replace(' ', '-', $clean_q), // Hyphens instead of spaces
				str_replace(' ', '_', $clean_q), // Underscores instead of spaces
			];
			
			// Remove duplicates
			$search_variations = array_unique($search_variations);
			
			// Build LIKE conditions for each variation
			$like_conditions = [];
			foreach ($search_variations as $variation) {
				$like_conditions[] = "course_name like '%$variation%'";
				$like_conditions[] = "course_desc like '%$variation%'";
				$like_conditions[] = "course_tags like '%$variation%'";
			}
			
			$conditions[] = "(" . implode(' OR ', $like_conditions) . ")";
			
		}

		$sql_filter = "course_status='1'";
		if (count(@$conditions) > 0) {
			$sql_filter .= ' AND ' . implode(' AND ', @$conditions);
		}

		$allcourses = $this->db->query("select * from x_edu_courses where $sql_filter order by course_id desc limit 10");
		$show_courses = $allcourses->result_array();
		
		$data['show_courses'] = $show_courses;

		$this->load->view('inc/_header', $data);
		$this->load->view('search', $data);
		$this->load->view('inc/_footer', $data);
		//unset($_SESSION['filters']);
	}


	function auto_search($course)
	{
		$q = $this->input->post('search');
		
		// Debug: Check if search parameter is received
		if (empty($q)) {
			echo '<div class="search-suggestion-item">No search term provided</div>';
			return;
		}
		
		switch ($course) {
			case 'course':

				$geththecourses = $this->db->query("select * from x_edu_courses where ( (course_name like '%$q%') and course_status='1') limit 8");
				// select * from x_edu_courses where course_status='1' order by course_id desc  limit 10
				// echo "select * from x_edu_courses where ( (course_name like '%$q%') and course_status='1' limit 8"; die;

				$thedetails_course = $geththecourses->result_array();
				foreach ($thedetails_course as $courses) { ?>
					<div class="col-12 py-2">
						<a href="<?= base_url('courses?q=') ?><?= preg_replace('/[^A-Za-z0-9\-]/', ' ', $courses['course_name']) ?>"><b><?= $courses['course_name'] ?></b></a>
					</div>
				<?php }
				break;
			case 'product':
				// First check if table exists and has data
				try {
					$checkTable = $this->db->query("SELECT COUNT(*) as total FROM yn_ecom_products");
					$tableCount = $checkTable->row_array();
				} catch (Exception $e) {
					echo '<div class="search-suggestion-item error">Table Error: ' . $e->getMessage() . '</div>';
					return;
				}
				
				// Simple case-insensitive search
				$q_lower = strtolower($q);
				
				// First check table structure
				try {
					$columns = $this->db->query("DESCRIBE yn_ecom_products")->result_array();
					$column_names = array_column($columns, 'Field');
					
					// Build search query based on available columns
					$search_conditions = [];
					$search_params = [];
					
					if (in_array('p_name', $column_names)) {
						$search_conditions[] = "LOWER(p_name) LIKE ?";
						$search_params[] = '%' . $q_lower . '%';
					}
					
					if (in_array('p_vendor', $column_names)) {
						$search_conditions[] = "LOWER(p_vendor) LIKE ?";
						$search_params[] = '%' . $q_lower . '%';
					}
					
					// Check for author column with different possible names
					$author_columns = ['p_author', 'author', 'p_writer', 'writer'];
					foreach ($author_columns as $col) {
						if (in_array($col, $column_names)) {
							$search_conditions[] = "LOWER($col) LIKE ?";
							$search_params[] = '%' . $q_lower . '%';
							break;
						}
					}
					
					if (empty($search_conditions)) {
						echo '<div class="search-suggestion-item error">No searchable columns found</div>';
						return;
					}
					
					$where_clause = implode(' OR ', $search_conditions);
					$getproducts = $this->db->query("
						SELECT * FROM yn_ecom_products 
						WHERE ($where_clause)
						ORDER BY p_name ASC
						LIMIT 8
					", $search_params);
					$allproducts = $getproducts->result_array();
					
				} catch (Exception $e) {
					echo '<div class="search-suggestion-item error">Database Error: ' . $e->getMessage() . '</div>';
					return;
				}
				
				// Debug: Check if products found
				if (empty($allproducts)) {
					echo '<div class="search-suggestion-item">No products found for "' . htmlspecialchars($q) . '" (Total products in DB: ' . $tableCount['total'] . ')</div>';
					break;
				}
				
				foreach ($allproducts as $pro) { 
					$url = base_url('product') . '/' . $pro['p_id'] . '/' . url_smart($pro['p_name']);
					
					// Get author from available columns
					$author = '';
					$author_columns = ['p_author', 'author', 'p_writer', 'writer'];
					foreach ($author_columns as $col) {
						if (!empty($pro[$col])) {
							$author = $pro[$col];
							break;
						}
					}
					// Fallback to vendor if no author found
					if (empty($author) && !empty($pro['p_vendor'])) {
						$author = $pro['p_vendor'];
					}
					
					$discount = 0;
					if ($pro['p_mrp'] > $pro['p_price']) {
						$discount = round((($pro['p_mrp'] - $pro['p_price']) / $pro['p_mrp']) * 100);
					}
					
					// Highlight search term in product name and author
					$highlighted_name = $this->highlightSearchTerm($pro['p_name'], $q);
					$highlighted_author = $this->highlightSearchTerm($author, $q);
				?>
					<div class="search-suggestion-item">
						<a href="<?= $url ?>" class="search-suggestion-link">
							<div class="search-suggestion-content">
								<div class="search-suggestion-image">
									<img src="<?= base_url('assets/avator/upload/' . $pro['p_cover']) ?>" 
										 alt="<?= htmlspecialchars($pro['p_name']) ?>" 
										 style="width: 60px; height: 75px; object-fit: cover; border-radius: 8px; box-shadow: 0 4px 8px rgba(0,0,0,0.1);">
									<?php if ($discount > 0): ?>
										<div style="position: absolute; top: -5px; right: -5px; background: linear-gradient(135deg, #e74c3c, #c0392b); color: white; font-size: 10px; font-weight: bold; padding: 2px 6px; border-radius: 10px; box-shadow: 0 2px 4px rgba(0,0,0,0.2);">
											-<?= $discount ?>%
										</div>
									<?php endif; ?>
								</div>
								<div class="search-suggestion-text">
									<h6><?= $highlighted_name ?></h6>
									<p>By <?= $highlighted_author ?></p>
									<div style="display: flex; align-items: center; gap: 8px; margin-top: 4px;">
										<span>₹<?= number_format($pro['p_price'], 2) ?></span>
										<?php if ($pro['p_mrp'] > $pro['p_price']): ?>
											<del style="font-size: 12px; color: #95a5a6;">₹<?= number_format($pro['p_mrp'], 2) ?></del>
										<?php endif; ?>
									</div>
								</div>
							</div>
						</a>
					</div>
				<?php }
				break;
			default:
				$getproducts = $this->db->query("select * from rm_post,site_mem where (rmp_status !='0' and rmp_user=mid) and (rmp_title like '%$q%' or rmp_cat_name like '%$q%' or name like '%$q%') limit 5");
				$allproducts = $getproducts->result_array();
				foreach ($allproducts as $pro) { ?>
					<a href="<?= base_url('article') ?>?id=<?= $pro['rmp_id'] ?>" class='no_link_90'>
						<div class="list_details">
							<?= $pro['rmp_title'] ?></b> in <?= $pro['rmp_cat_name'] ?>
						</div>
					</a>
				<?php }
				break;
		}
	}
	
	// Function to highlight search term in text
	private function highlightSearchTerm($text, $searchTerm) {
		if (empty($searchTerm)) {
			return htmlspecialchars($text);
		}
		
		$highlighted = preg_replace(
			'/' . preg_quote($searchTerm, '/') . '/i',
			'<strong style="background: linear-gradient(135deg, #0391DD, #7CD1F9); -webkit-background-clip: text; -webkit-text-fill-color: transparent; background-clip: text; font-weight: 700;">$0</strong>',
			htmlspecialchars($text)
		);
		
		return $highlighted;
	}

	public function shop()
	{
		if (check_service_status('1', '2', 'eco') != '1') {
			redirect('error-404?e=this feature is not enabled.');
		}

		$data = db_variables();

		// Get category ID from GET
		$cat_id = !empty($_GET['cate']) ? intval($_GET['cate']) : null;
		$cat_name = '';

		// SEO title
		if (!empty($cat_id)) {
			$cat_row = $this->db->query("SELECT name FROM yn_site_catagory WHERE ctid = ?", [$cat_id])->row_array();
			$cat_name = $cat_row['name'] ?? '';
			$data['seo_title'] = ucfirst($cat_name) . ' - ' . $data['meta_title'];
		} else {
			$data['seo_title'] = 'Shop - ' . $data['meta_title'];
		}

		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		// Pagination
		$rec_per_page = 9;
		$page = max(intval($_GET['page'] ?? 1) - 1, 0);
		$limit1 = $page * $rec_per_page;

		// Get subcategory ID from GET
		$subcat_id = !empty($_GET['subcat']) ? intval($_GET['subcat']) : null;

		// Product query - filter by category and subcategory if selected
		if (!empty($subcat_id)) {
			// Filter by subcategory
			$getProducts = $this->db->query(
				"SELECT * FROM yn_ecom_products WHERE p_sub_category = ? ORDER BY p_id DESC LIMIT ?, ?",
				[$subcat_id, $limit1, $rec_per_page]
			);
		} elseif (!empty($cat_id)) {
			// Filter by category only
			$getProducts = $this->db->query(
				"SELECT * FROM yn_ecom_products WHERE p_category = ? ORDER BY p_id DESC LIMIT ?, ?",
				[$cat_id, $limit1, $rec_per_page]
			);
		} else {
			// All products
			$getProducts = $this->db->query(
				"SELECT * FROM yn_ecom_products ORDER BY p_id DESC LIMIT ?, ?",
				[$limit1, $rec_per_page]
			);
		}

		$data['prod'] = $getProducts->result_array();

		// Breadcrumb banner
		$data['breadcrumb'] = $this->db->query("SELECT * FROM yn_site_img WHERE img_place = 'bshop' AND img_status = '1' ORDER BY img_id DESC LIMIT 1")->row_array();

		// Categories for menu
		$data['the_cats'] = $this->db->query("SELECT * FROM yn_site_catagory ORDER BY sid ASC LIMIT 6")->result_array();

		// ✅ Pass category info to view
		$data['cat_id']   = $cat_id;
		$data['cat_name'] = $cat_name;
		$data['subcat_id'] = $subcat_id;

		// Load views
		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('shop', $data);
		$this->load->view('inc/_footer', $data);	
	}

	// AJAX method to get subcategories for a category
	public function get_subcategories()
	{
		$cat_id = !empty($_GET['cat_id']) ? intval($_GET['cat_id']) : 0;
		
		if ($cat_id > 0) {
			$subcategories = $this->db->query(
				"SELECT sc_id, sc_name FROM yn_site_sub_cat WHERE sc_ctid = ? ORDER BY sc_sort ASC",
				[$cat_id]
			)->result_array();
			
			header('Content-Type: application/json');
			echo json_encode(['subcategories' => $subcategories]);
		} else {
			header('Content-Type: application/json');
			echo json_encode(['subcategories' => []]);
		}
		exit;
	}


	function cart()
	{

		if (check_service_status('1', '2', 'eco') != '1') {
			redirect('error-404?e=this feature is not enabled.');
		}

		$data = db_variables();
		$data['seo_title'] = 'Cart - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		$allpoppro = $this->db->query("select * from yn_ecom_products ORDER BY p_id desc limit 5 ");
		$thepoppro = $allpoppro->result_array();
		$data['prod'] = $thepoppro;

		$get_banner1 = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='bcart' AND img_status='1' ORDER BY img_id DESC LIMIT 1");
		$thebanner1 = $get_banner1->row_array();
		$data['breadcrumb'] = $thebanner1;

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('cart.php', $data);
		$this->load->view('inc/_footer', $data);
	}

	function product($pid, $pname)
	{
		if (check_service_status('1', '2', 'eco') != '1') {
			redirect('error-404?e=this feature is not enabled.');
		}

		$data = db_variables();
		$allproduct = $this->db->query("SELECT * FROM yn_ecom_products WHERE p_id = $pid");
		$product = $allproduct->row_array();

		$data['seo_title'] = $product['p_name'];
		$data['seo_description'] = strip_tags($product['p_descp']);
		$data['seo_image'] = $product['p_cover'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		// featured products
		$featuredproducts = $this->db->query("SELECT * FROM yn_ecom_products WHERE p_sale_status = '2' ORDER BY p_id DESC LIMIT 6");
		$data['featuredProducts'] = $featuredproducts->result_array();

		$allpoppro = $this->db->query("select * from yn_ecom_products ORDER BY RAND() limit 5 ");
		$data['prod'] = $allpoppro->result_array();

		$getprd = $this->db->query("select * from yn_ecom_products where p_id='$pid'  ");
		$thepfd = $getprd->row_array();

		$getprd_img = $this->db->query("select * from  yn_ecom_products_img where pid='$pid'  ");
		$thepfd_mimg = $getprd_img->result_array();

		// put product & images in $data
		$data['product'] = $thepfd;
		$data['prod_img'] = $thepfd_mimg;

		// fetch author details from yn_site_img
		$author = [];
		if (!empty($thepfd['p_vendor'])) {
			$author = $this->db->query(
				"SELECT * FROM yn_site_img WHERE img_head = ? AND img_place='partner' LIMIT 1",
				[$thepfd['p_vendor']]
			)->row_array();
		}
		$data['author'] = $author;

		// load views
		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('product.php', $data);
		$this->load->view('inc/_footer', $data);
	}




	///////////////////////	


	function checkout()
	{
		// @session_start();
		// check_session('2','login');
		$data = db_variables();
		$data['seo_title'] = 'Checkout - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		$getprd_img = $this->db->query("select * from  yn_site_states where status= 1  ");
		$statess = $getprd_img->result_array();
		$data['states'] = $statess;

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('checkout', $data);
		$this->load->view('inc/_footer', $data);
	}

	function help()
	{
		// @session_start();
		// check_session('2','login');
		$data = db_variables();
		$data['seo_title'] = 'Help - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('help', $data);
		$this->load->view('inc/_footer', $data);
	}
	function view()
	{
		@session_start();
		check_session('2', 'account');
		$data = db_variables();
		$data['seo_title'] = 'View - ' . $data['meta_title'];;
		$data['seo_description'] = $data['meta_title'];;
		$data['seo_image'] = base_url('assets/avator/og_img.jpg');
		$data['seo_keywords'] = 'keywords';
		$data['page_name'] = 'View';
		$data['meta_array'] = $data;

		$oid = $_GET['ordid'];
		$viewallorder = $this->db->query("select * from yn_ecom_orders_detail where checkout_order_id = '$oid'  order by xod_id desc");
		$viewalldetail = $viewallorder->result_array();
		$data['viewall'] = $viewalldetail;


		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section2', $data);
		$this->load->view('view', $data);
		$this->load->view('inc/_footer', $data);
	}
	function wholesale()
	{
		$data = db_variables();
		$data['seo_title'] = 'Wholesale - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		//All products
		$getProducts = $this->db->query("SELECT * FROM `yn_ecom_products` where wholesale='1' order by p_id desc limit 21");
		$the_prods = $getProducts->result_array();
		$data['prod'] = $the_prods;

		$get_banner1 = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='bwhole' AND img_status='1' ORDER BY img_id DESC LIMIT 1");
		$thebanner1 = $get_banner1->row_array();
		$data['breadcrumb'] = $thebanner1;

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('wholesale', $data);
		$this->load->view('inc/_footer', $data);
	}
	function rewards()
	{
		$data = db_variables();
		$data['seo_title'] = 'Rewards - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		$get_banner1 = $this->db->query("SELECT * FROM yn_site_img WHERE img_place ='brewards' AND img_status='1' ORDER BY img_id DESC LIMIT 1");
		$thebanner1 = $get_banner1->row_array();
		$data['breadcrumb'] = $thebanner1;

		$this->load->view('inc/_header', $data);
		$this->load->view('inc/section', $data);
		$this->load->view('rewards', $data);
		$this->load->view('inc/_footer', $data);
	}

	function calculator()
	{
		$data = db_variables();
		$data['seo_title'] = 'Calculator - ' . $data['meta_title'];
		$data['seo_description'] = $data['meta_desc'];
		$data['seo_image'] = $data['meta_image'];
		$data['seo_keywords'] = $data['meta_key'];
		$data['meta_array'] = $data;

		$this->load->view('inc/_header', $data);
		$this->load->view('calculator', $data);
		$this->load->view('inc/_footer', $data);
	}
	function debug_videos()
	{
		@session_start();
		check_session('2', 'account');
		
		error_reporting(E_ALL);
		ini_set('display_errors', 1);
		
		$yid = $_SESSION['yid'];
		$email = isset($_SESSION['email']) ? $_SESSION['email'] : '';
		$phone = isset($_SESSION['phone']) ? $_SESSION['phone'] : '';
		
		echo "<h2>🔍 VIDEO DEBUGGING - Complete Check</h2>";
		echo "<hr>";
		
		// Step 1: Check video in database
		echo "<h3>Step 1: Video in Database</h3>";
		$q1 = "SELECT * FROM yn_study_material_videos WHERE smv_status = '1'";
		$r1 = $this->db->query($q1);
		$videos = $r1->result_array();
		echo "<pre>";
		print_r($videos);
		echo "</pre>";
		echo "<p><strong>Total Videos:</strong> " . count($videos) . "</p>";
		
		if (empty($videos)) {
			echo "<p style='color:red;'><strong>❌ NO VIDEOS FOUND IN DATABASE!</strong></p>";
			die;
		}
		
		$video = $videos[0];
		$sm_id = $video['sm_id'];
		$lc_id = $video['lc_id'];
		
		echo "<p><strong>Video sm_id:</strong> $sm_id</p>";
		echo "<p><strong>Video lc_id:</strong> " . ($lc_id ?? 'NULL') . "</p>";
		echo "<hr>";
		
		// Step 2: Check study material
		echo "<h3>Step 2: Study Material Status</h3>";
		$q2 = "SELECT sm_id, sm_name, sm_status FROM x_edu_study_material WHERE sm_id = $sm_id";
		$r2 = $this->db->query($q2);
		$sm = $r2->row_array();
		echo "<pre>";
		print_r($sm);
		echo "</pre>";
		
		if (empty($sm)) {
			echo "<p style='color:red;'><strong>❌ STUDY MATERIAL NOT FOUND!</strong></p>";
			die;
		}
		
		if ($sm['sm_status'] != '1') {
			echo "<p style='color:red;'><strong>❌ STUDY MATERIAL IS INACTIVE!</strong></p>";
		}
		echo "<hr>";
		
		// Step 3: Check live class (if lc_id exists)
		if (!empty($lc_id)) {
			echo "<h3>Step 3: Live Class Status</h3>";
			$q3 = "SELECT lc_id, lc_title, lc_status, sm_id FROM yn_live_classes WHERE lc_id = $lc_id";
			$r3 = $this->db->query($q3);
			$lc = $r3->row_array();
			echo "<pre>";
			print_r($lc);
			echo "</pre>";
			
			if (empty($lc)) {
				echo "<p style='color:orange;'><strong>⚠️ LIVE CLASS NOT FOUND (but video will still show)</strong></p>";
			}
			echo "<hr>";
		}
		
		// Step 4: Check user profile data
		echo "<h3>Step 4: User Profile Data</h3>";
		$themyuser_details = $this->ynaps_model->getprofile_data('*', $yid);
		echo "<p><strong>User ID:</strong> $yid</p>";
		echo "<p><strong>Email:</strong> " . ($email ?? 'NOT SET') . "</p>";
		echo "<p><strong>Phone (Session):</strong> " . ($phone ?? 'NOT SET') . "</p>";
		echo "<p><strong>Phone (Profile):</strong> " . ($themyuser_details['phone'] ?? 'NOT SET') . "</p>";
		echo "<p><strong>Contact (Profile):</strong> " . ($themyuser_details['contact'] ?? 'NOT SET') . "</p>";
		echo "<hr>";
		
		// Step 5: Check ALL orders (before linking)
		echo "<h3>Step 5: ALL Orders (Before Linking) - Check by Phone/Email</h3>";
		$phone_from_profile = !empty($themyuser_details['phone']) ? $themyuser_details['phone'] : (!empty($themyuser_details['contact']) ? $themyuser_details['contact'] : '');
		$phone_to_use = !empty($phone) ? $phone : $phone_from_profile;
		
		$phone_normalized = '';
		if (!empty($phone_to_use)) {
			$phone_normalized = preg_replace('/[^0-9]/', '', $phone_to_use);
		}
		
		echo "<p><strong>Phone to Use:</strong> $phone_to_use</p>";
		echo "<p><strong>Phone Normalized:</strong> $phone_normalized</p>";
		
		// Check orders by phone
		if (!empty($phone_normalized)) {
			$phone_escaped = $this->db->escape_str($phone_to_use);
			$phone_normalized_escaped = $this->db->escape_str($phone_normalized);
			
			$q_phone = "SELECT * FROM yn_ecom_order 
						WHERE (so_phone = '$phone_escaped' 
						OR REPLACE(REPLACE(REPLACE(REPLACE(so_phone, ' ', ''), '-', ''), '(', ''), ')', '') = '$phone_normalized_escaped')
						ORDER BY so_id DESC LIMIT 10";
			$r_phone = $this->db->query($q_phone);
			$orders_by_phone = $r_phone->result_array();
			echo "<p><strong>Orders by Phone:</strong> " . count($orders_by_phone) . "</p>";
			if (!empty($orders_by_phone)) {
				echo "<pre>";
				foreach ($orders_by_phone as $ord) {
					echo "Order ID: {$ord['so_order_id']}, so_mid: {$ord['so_mid']}, Status: {$ord['so_status']}, Pay Status: {$ord['or_pay_status']}, Phone: {$ord['so_phone']}\n";
				}
				echo "</pre>";
			}
		}
		
		// Check orders by email
		if (!empty($email)) {
			$email_escaped = $this->db->escape_str($email);
			$q_email = "SELECT * FROM yn_ecom_order WHERE so_email = '$email_escaped' ORDER BY so_id DESC LIMIT 10";
			$r_email = $this->db->query($q_email);
			$orders_by_email = $r_email->result_array();
			echo "<p><strong>Orders by Email:</strong> " . count($orders_by_email) . "</p>";
			if (!empty($orders_by_email)) {
				echo "<pre>";
				foreach ($orders_by_email as $ord) {
					echo "Order ID: {$ord['so_order_id']}, so_mid: {$ord['so_mid']}, Status: {$ord['so_status']}, Pay Status: {$ord['or_pay_status']}, Email: {$ord['so_email']}\n";
				}
				echo "</pre>";
			}
		}
		
		// Check orders by user ID
		$yid_escaped = (int)$yid;
		$q_userid = "SELECT * FROM yn_ecom_order WHERE so_mid = '$yid_escaped' ORDER BY so_id DESC LIMIT 10";
		$r_userid = $this->db->query($q_userid);
		$orders_by_userid = $r_userid->result_array();
		echo "<p><strong>Orders by User ID:</strong> " . count($orders_by_userid) . "</p>";
		if (!empty($orders_by_userid)) {
			echo "<pre>";
			foreach ($orders_by_userid as $ord) {
				echo "Order ID: {$ord['so_order_id']}, so_mid: {$ord['so_mid']}, Status: {$ord['so_status']}, Pay Status: {$ord['or_pay_status']}\n";
			}
			echo "</pre>";
		}
		echo "<hr>";
		
		// Step 6: Try to link orders (same as profile page)
		echo "<h3>Step 6: Linking Orders to User</h3>";
		if (!empty($phone_normalized)) {
			$phone_escaped = $this->db->escape_str($phone_to_use);
			$phone_normalized_escaped = $this->db->escape_str($phone_normalized);
			$update_query = "UPDATE yn_ecom_order SET so_mid = '$yid_escaped' WHERE (so_mid = 0 OR so_mid IS NULL) AND (so_phone = '$phone_escaped' OR REPLACE(REPLACE(REPLACE(REPLACE(so_phone, ' ', ''), '-', ''), '(', ''), ')', '') = '$phone_normalized_escaped')";
			echo "<p><strong>Update Query:</strong> $update_query</p>";
			$this->db->query($update_query);
			echo "<p style='color:green;'><strong>✅ Orders linked!</strong></p>";
		}
		echo "<hr>";
		
		// Step 7: Check user orders AFTER linking (same logic as live classes)
		echo "<h3>Step 7: User Orders AFTER Linking (Same Logic as Live Classes)</h3>";
		$where_conditions = array();
		$where_conditions[] = "so_mid = '$yid_escaped'";
		
		if (!empty($phone_normalized)) {
			$phone_escaped = $this->db->escape_str($phone_to_use);
			$phone_normalized_escaped = $this->db->escape_str($phone_normalized);
			$where_conditions[] = "so_phone = '$phone_escaped'";
			$where_conditions[] = "REPLACE(REPLACE(REPLACE(REPLACE(so_phone, ' ', ''), '-', ''), '(', ''), ')', '') = '$phone_normalized_escaped'";
		}
		
		if (!empty($email)) {
			$email_escaped = $this->db->escape_str($email);
			$where_conditions[] = "so_email = '$email_escaped'";
		}
		
		$where_clause = '(' . implode(' OR ', $where_conditions) . ')';
		$q4 = "SELECT * FROM yn_ecom_order WHERE $where_clause ORDER BY so_id DESC LIMIT 10";
		$r4 = $this->db->query($q4);
		$orders = $r4->result_array();
		echo "<p><strong>Total Orders Found:</strong> " . count($orders) . "</p>";
		
		// Filter paid orders
		$paid_orders = array();
		foreach ($orders as $order) {
			if ($order['so_status'] == '1' && $order['or_pay_status'] == '1') {
				$paid_orders[] = $order;
			}
		}
		echo "<p><strong>Paid Orders:</strong> " . count($paid_orders) . "</p>";
		
		if (!empty($orders)) {
			echo "<pre>";
			foreach ($orders as $ord) {
				$paid = ($ord['so_status'] == '1' && $ord['or_pay_status'] == '1') ? '✅ PAID' : '❌ NOT PAID';
				echo "Order ID: {$ord['so_order_id']}, so_mid: {$ord['so_mid']}, Status: {$ord['so_status']}, Pay Status: {$ord['or_pay_status']} - $paid\n";
			}
			echo "</pre>";
		}
		echo "<hr>";
		
		// Step 8: Check order details for sm_id
		echo "<h3>Step 8: Order Details for sm_id=$sm_id</h3>";
		if (!empty($paid_orders)) {
			$order_ids = array();
			foreach ($paid_orders as $ord) {
				if (!empty($ord['so_order_id'])) {
					$order_ids[] = $this->db->escape_str($ord['so_order_id']);
				}
			}
			
			if (!empty($order_ids)) {
				$order_ids_str = "'" . implode("','", $order_ids) . "'";
				
				// First show ALL order details
				$q_all_details = "SELECT od.*, o.so_mid, o.so_order_id, o.so_status, o.or_pay_status
								  FROM yn_ecom_orders_detail od
								  INNER JOIN yn_ecom_order o ON od.checkout_order_id = o.so_order_id
								  WHERE od.checkout_order_id IN ($order_ids_str)
								  LIMIT 20";
				$r_all_details = $this->db->query($q_all_details);
				$all_order_details = $r_all_details->result_array();
				echo "<p><strong>All Order Details Found:</strong> " . count($all_order_details) . "</p>";
				if (!empty($all_order_details)) {
					echo "<pre>";
					foreach ($all_order_details as $det) {
						echo "Order: {$det['checkout_order_id']}, xod_sm_id: {$det['xod_sm_id']}, xod_pid: {$det['xod_pid']}, Status: {$det['so_status']}, Pay: {$det['or_pay_status']}\n";
					}
					echo "</pre>";
				}
				
				$q5 = "SELECT od.*, o.so_mid, o.so_order_id
					   FROM yn_ecom_orders_detail od
					   INNER JOIN yn_ecom_order o ON od.checkout_order_id = o.so_order_id
					   WHERE od.checkout_order_id IN ($order_ids_str)
					   AND (od.xod_sm_id = $sm_id OR od.xod_pid = $sm_id)
					   LIMIT 10";
				$r5 = $this->db->query($q5);
				$order_details = $r5->result_array();
				echo "<p><strong>Order Details for sm_id=$sm_id:</strong> " . count($order_details) . "</p>";
				if (!empty($order_details)) {
					echo "<pre>";
					print_r($order_details);
					echo "</pre>";
				}
				
				if (empty($order_details)) {
					echo "<p style='color:red;'><strong>❌ NO USER HAS PURCHASED sm_id=$sm_id!</strong></p>";
					echo "<p>This is why video is not showing. User needs to purchase this study material first.</p>";
				} else {
					echo "<p style='color:green;'><strong>✅ USER HAS PURCHASED sm_id=$sm_id</strong></p>";
					echo "<hr>";
					
					// Step 9: Simulate exact query from code
					echo "<h3>Step 9: Simulate Exact Code Query</h3>";
					$sm_ids_str = "$sm_id";
					$q6 = "SELECT DISTINCT 
								smv.smv_id,
								smv.sm_id,
								smv.lc_id,
								smv.smv_title,
								sm.sm_name,
								lc.lc_title,
								c.course_name
							FROM yn_study_material_videos smv
							INNER JOIN x_edu_study_material sm ON smv.sm_id = sm.sm_id
							LEFT JOIN yn_live_classes lc ON smv.lc_id = lc.lc_id
							LEFT JOIN x_edu_courses c ON sm.sm_course_id = c.course_id
							WHERE smv.sm_id IN ($sm_ids_str)
							AND smv.smv_status = '1'
							AND sm.sm_status = '1'";
					
					$r6 = $this->db->query($q6);
					$all_videos = $r6->result_array();
					echo "<pre>";
					print_r($all_videos);
					echo "</pre>";
					echo "<p><strong>Videos Found:</strong> " . count($all_videos) . "</p>";
					
					if (empty($all_videos)) {
						echo "<p style='color:red;'><strong>❌ QUERY RETURNED NO RESULTS!</strong></p>";
					} else {
						echo "<p style='color:green;'><strong>✅ QUERY WORKS! Video should show.</strong></p>";
					}
				}
			}
		} else {
			echo "<p style='color:red;'><strong>❌ NO PAID ORDERS FOUND FOR USER!</strong></p>";
		}
	}

	function test()
	{
		echo "<pre>";
		print_r($this->session->all_userdata());
		echo "</pre>";
		// $this->load->view('test');
	}
}
