<!-- Team Section start  -->
<?php
// Fetch featured authors
$limit1 = 0; // starting index
$limit2 = 10; // number of authors to display
$get_authors = $this->db->query("SELECT * FROM yn_site_img WHERE img_place = 'partner' AND img_status='1' ORDER BY img_sort DESC LIMIT ?, ?", [$limit1, $limit2]);
$all_authors = $get_authors->result_array();
?>

<style>
    .team-box-items .team-image .thumb img {
        width: 150px;
        /* fixed width */
        height: 150px;
        /* fixed height */
        object-fit: cover;
        /* crops image nicely */
        border-radius: 50%;
        /* keep it circular */
    }
</style>

<section class="team-section fix section-padding pt-0 margin-bottom-30 mt-5">
    <div class="container">
        <div class="section-title text-center">
            <h2 class="mb-3 wow fadeInUp" data-wow-delay=".3s">Authors</h2>
            <p class="wow fadeInUp" data-wow-delay=".5s">
                Discover inspiring stories and insights from our authors. Their works open new perspectives and offer<br>
                a wealth of knowledge for every reader.
            </p>
        </div>

        <div class="array-button">
            <button class="array-prev"><i class="fal fa-arrow-left"></i></button>
            <button class="array-next"><i class="fal fa-arrow-right"></i></button>
        </div>

        <div class="swiper team-slider">
            <div class="swiper-wrapper">
                <?php foreach ($all_authors as $author): ?>
                    <div class="swiper-slide">
                        <div class="team-box-items">
                            <div class="team-image">
                                <div class="thumb">
                                    <img src="<?= base_url('assets/avator/upload/' . $author['img_name']) ?>" alt="<?= htmlspecialchars($author['img_head']) ?>">
                                </div>
                                <div class="shape-img">
                                    <img src="<?= base_url('assets/theme/theme/assets/img/team/shape-img.png') ?>" alt="img">
                                </div>
                            </div>
                            <div class="team-content text-center">
                                <h6>
                                    <a href="<?= htmlspecialchars($author['img_link'] ?: '#') ?>">
                                        <?= htmlspecialchars($author['img_head']) ?>
                                    </a>
                                </h6>
                                <p><?= trim_text(strip_tags($author['img_text']), '50') ?> Published Books</p>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
</section>