<div class="container mt-5">
    <h2 class="mb-4 text-center">Mock Test Categories</h2>

    <div class="row g-2">
        <?php
        $categories = $this->db->query("SELECT * FROM mock_categories ORDER BY category_name ASC")->result_array();

        if (count($categories) > 0) {
            foreach ($categories as $cat) { ?>
                <div class="col-lg-3 col-md-4 col-sm-6 col-12">
                    <div class="category-card h-100 d-flex flex-column">
                        <div class="category-img-wrapper">
                            <img src="<?= !empty($cat['icon']) ? base_url('assets/icons/' . $cat['icon']) : 'https://img.freepik.com/premium-vector/test-time-concept-clipboard-with-dough-form-pencil-stopwatch-vector-filling-writing-tests_153097-6256.jpg' ?>"
                                alt="<?= $cat['category_name'] ?>"
                                class="category-img">
                        </div>
                        <div class="category-content d-flex flex-column">
                            <h5 class="category-title"><?= $cat['category_name'] ?></h5>
                            <p class="category-price">Price: ₹<strong><?= $cat['category_price'] ?></strong></p>
                            <?php
                            $category_id = $cat['category_id'];
                            $category_price = $cat['category_price'];
                            session_start();
                            
                            $checkEnrollment = [];
                            $url = "#";
                            $btn_text = "Buy Now";
                            $btn_class = "start-btn mt-auto";
                            
                            // Check if user is logged in
                            if (isset($_SESSION['yid']) && $_SESSION['yid'] != '') {
                                // Check if user has already paid for this mock test using existing order tables
                                $yid = $_SESSION['yid'];
                                // Use direct comparison with proper type handling
                                $checkPayment = $this->db->query("
                                    SELECT o.* FROM yn_ecom_order o
                                    INNER JOIN yn_ecom_orders_detail od ON o.so_order_id = od.checkout_order_id
                                    WHERE o.so_mid = " . (int)$yid . " 
                                    AND TRIM(CAST(od.xod_pid AS CHAR)) = '" . $this->db->escape_str($category_id) . "'
                                    AND o.so_status = '1'
                                    ORDER BY o.so_date DESC LIMIT 1
                                ")->row_array();
                                
                                // Debug: Check what's actually in the database
                                if (empty($checkPayment)) {
                                    $debug_all = $this->db->query("SELECT o.so_order_id, o.so_mid, o.so_status, o.or_pay_status, od.xod_pid, od.xod_name FROM yn_ecom_order o LEFT JOIN yn_ecom_orders_detail od ON o.so_order_id = od.checkout_order_id WHERE o.so_mid = " . (int)$yid . " ORDER BY o.so_date DESC LIMIT 5")->result_array();
                                    if (!empty($debug_all)) {
                                        echo "<!-- DEBUG: Looking for User ID: " . (int)$yid . ", Category ID: $category_id | Found orders: " . json_encode($debug_all, JSON_PRETTY_PRINT) . " -->";
                                    }
                                }
                                
                                if (!empty($checkPayment)) {
                                    // User has already paid - show Start Now button
                                    $url = base_url("index.php/main/start/{$category_id}");
                                    $btn_text = "Start Now";
                                    $btn_class = "start-btn mt-auto";
                                    $checkEnrollment = $checkPayment; // For compatibility with template
                                } else {
                                    // User needs to pay - show Buy Now button
                                    $url = "#";
                                    $btn_text = "Buy Now";
                                    $btn_class = "start-btn mt-auto enroll-mock-btn";
                                    $checkEnrollment = [];
                                }
                            } else {
                                // Not logged in - redirect to login
                                $url = base_url("index.php/login?redirect=" . urlencode(current_url()));
                                $btn_text = "Buy Now";
                                $btn_class = "start-btn mt-auto";
                                $checkEnrollment = [];
                            }
                            ?>
                            <?php if (!empty($checkEnrollment)): ?>
                                <a href="<?= $url ?>" class="<?= $btn_class ?>"><?= $btn_text ?></a>
                            <?php else: ?>
                                <?php if ($url != "#"): ?>
                                    <a href="<?= $url ?>" class="<?= $btn_class ?>"><?= $btn_text ?></a>
                                <?php else: ?>
                                    <form method="post" action="<?= base_url('index.php/action/enroll_mock_test') ?>" style="width: 100%;">
                                        <input type="hidden" name="categoryID" value="<?= $category_id ?>">
                                        <input type="hidden" name="categoryName" value="<?= htmlspecialchars($cat['category_name']) ?>">
                                        <input type="hidden" name="amount" value="<?= $category_price ?>">
                                        <button type="submit" class="<?= $btn_class ?>" style="width: 100%; border: none; cursor: pointer;"><?= $btn_text ?></button>
                                    </form>
                                <?php endif; ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php }
        } else { ?>
            <div class="col-12">
                <div class="alert alert-info">No categories available at the moment.</div>
            </div>
        <?php } ?>
    </div>
</div>

<style>
    .category-card {
        background: #fff;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        transition: transform 0.3s, box-shadow 0.3s;
        overflow: hidden;
        border: 1px solid #e9ecef;
    }

    .category-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 20px rgba(0, 0, 0, 0.15);
    }

    .category-img-wrapper {
        width: 100%;
        height: 200px;
        overflow: hidden;
        display: flex;
        justify-content: center;
        align-items: center;
        background: #f8f9fa;
        padding: 0;
        margin: 0;
    }

    .category-img {
        width: 100%;
        height: 100%;
        object-fit: contain;
        padding: 15px;
    }

    .category-content {
        padding: 15px;
        flex: 1;
    }

    .category-title {
        font-size: 1.1rem;
        font-weight: 600;
        margin: 0 0 8px 0;
        color: #2c3e50;
        line-height: 1.4;
    }

    .category-price {
        font-size: 0.95rem;
        color: #6c757d;
        margin: 0 0 15px 0;
    }

    .category-price strong {
        color: #FF7B6B;
        font-size: 1.1rem;
    }

    .start-btn {
        background-color: #FF7B6B;
        border: none;
        border-radius: 8px;
        color: #fff;
        font-weight: 600;
        padding: 10px 20px;
        text-align: center;
        text-decoration: none;
        display: block;
        transition: background-color 0.3s, transform 0.3s;
        width: 100%;
    }

    .start-btn:hover {
        background-color: #e66b5e;
        transform: scale(1.02);
        color: #fff;
        text-decoration: none;
    }

    .row.g-2 {
        margin-left: -8px;
        margin-right: -8px;
    }

    .row.g-2 > [class*="col-"] {
        padding-left: 8px;
        padding-right: 8px;
        margin-bottom: 16px;
    }

    @media (max-width: 576px) {
        .category-img-wrapper {
            height: 150px;
        }
        
        .category-content {
            padding: 12px;
        }
        
        .row.g-2 > [class*="col-"] {
            margin-bottom: 12px;
        }
    }
</style>