<div class="breadcrumb-wrapper bg-cover section-padding"
    style="background-image: url(<?= base_url('assets/theme/theme/') ?>assets/img/hero/banner.jpg);">
    <div class="container">
        <div class="page-heading">
            <h1>About Us</h1>
            <div class="page-header">
                <ul class="breadcrumb-items wow fadeInUp" data-wow-delay=".3s">
                    <li>
                        <a href="<?= base_url('') ?>">
                            Home
                        </a>
                    </li>
                    <li>
                        <i class="fa-solid fa-chevron-right"></i>
                    </li>
                    <li>
                        About Us
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>

<!-- About Section Start -->
<section class="about-section fix section-padding">
    <div class="container">
        <div class="about-wrapper">
            <div class="row g-4 align-items-center">
                <div class="col-lg-6 wow fadeInUp" data-wow-delay=".3s">
                    <div class="about-image">
                        <img src="<?= base_url('assets/theme/theme/') ?>assets/img/about.jpg" alt="img">
                        <div class="video-box">
                            <a href="https://www.youtube.com/watch?v=Cn4G2lZ_g2I"
                                class="video-btn ripple video-popup">
                                <i class="fa-solid fa-play"></i>
                            </a>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="about-content">
                        <div class="section-title">
                            <h2 class="wow fadeInUp" data-wow-delay=".3s">About the Readit <br> Books Store</h2>
                        </div>
                        <p class="mt-3 mt-md-0 wow fadeInUp" data-wow-delay=".5s">
                            Readit Books Store is your ultimate destination for discovering exceptional books from around the world. We offer a diverse collection of titles spanning fiction, non-fiction, educational, and special interest genres. Every book in our collection is carefully selected to spark curiosity, inspire creativity, and expand knowledge for readers of all ages.
                        </p>
                        <p class="mt-3 wow fadeInUp" data-wow-delay=".7s">
                            Our mission is to make reading accessible, enjoyable, and meaningful. Whether you are searching for timeless classics, the latest bestsellers, or rare finds, Readit Books Store ensures a seamless experience with detailed descriptions, author information, and personalized recommendations.
                        </p>
                        <p class="mt-3 wow fadeInUp" data-wow-delay=".9s">
                            With a focus on quality service and customer satisfaction, we provide fast shipping, secure payment options, and a dedicated support team ready to assist you. At Readit Books Store, we believe that every book has a story to tell, and every reader deserves the perfect book to connect with.
                        </p>


                    </div>
                </div>
            </div>
        </div>
    </div>
</section>



<!-- Testimonial Section start -->
<section class="testimonial-section fix section-padding pt-0">
    <div class="container">
        <div class="section-title text-left">
            <h2 class="mb-3 wow fadeInUp" data-wow-delay=".3s">What our client say</h2>
        </div>

        <div class="swiper testimonial-slider">
            <div class="swiper-wrapper">
                <?php
                // Fetch testimonials dynamically
                $testimonials = get_web_elements('testi', '1', '10'); // Adjust the limit as needed
                foreach ($testimonials as $testimonial):
                    // Optional: fetch logo if dynamic, else use default
                    $logo = !empty($testimonial['logo']) ? base_url('assets/avator/webimg/') . $testimonial['logo'] : base_url('assets/theme/theme/assets/img/testimonial/logo1.png');
                ?>
                    <div class="swiper-slide">
                        <div class="testimonial-card-items">
                            <p><?= htmlspecialchars($testimonial['text']) ?></p>
                            <div class="client-info-wrapper d-flex align-items-center justify-content-between">
                                <div class="client-info">
                                    <div class="client-img bg-cover" style="background-image: url('<?= base_url('assets/avator/webimg/t/' . $testimonial['image']) ?>');">
                                        <div class="icon">
                                            <img class="shape" src="<?= base_url('assets/theme/theme/assets/img/testimonial/shape.svg') ?>" alt="img">
                                        </div>
                                    </div>
                                    <div class="content">
                                        <h3><?= htmlspecialchars($testimonial['name']) ?></h3>
                                        <span><?= htmlspecialchars($testimonial['designation'] ?? '') ?></span>
                                        <div class="star">
                                            <?php for ($i = 1; $i <= 5; $i++): ?>
                                                <i class="fa-<?= $i <= $testimonial['star'] ? 'solid' : 'regular' ?> fa-star"></i>
                                            <?php endfor; ?>
                                        </div>
                                    </div>
                                </div>


                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
</section>


<!-- Team Section start  -->
<?php
// Fetch featured authors
$limit1 = 0; // starting index
$limit2 = 10; // number of authors to display
$get_authors = $this->db->query("SELECT * FROM yn_site_img WHERE img_place = 'partner' AND img_status='1' ORDER BY img_sort DESC LIMIT ?, ?", [$limit1, $limit2]);
$all_authors = $get_authors->result_array();
?>

<style>
    .team-box-items .team-image .thumb img {
        width: 150px;
        /* fixed width */
        height: 150px;
        /* fixed height */
        object-fit: cover;
        /* crops image nicely */
        border-radius: 50%;
        /* keep it circular */
    }
</style>

<section class="team-section fix section-padding pt-0 margin-bottom-30">
    <div class="container">
        <div class="section-title text-center">
            <h2 class="mb-3 wow fadeInUp" data-wow-delay=".3s">Featured Author</h2>
            <p class="wow fadeInUp" data-wow-delay=".5s">
                Discover inspiring stories and insights from our featured authors. Their works open new perspectives and offer<br>
                a wealth of knowledge for every reader.
            </p>
        </div>

        <div class="array-button">
            <button class="array-prev"><i class="fal fa-arrow-left"></i></button>
            <button class="array-next"><i class="fal fa-arrow-right"></i></button>
        </div>

        <div class="swiper team-slider">
            <div class="swiper-wrapper">
                <?php foreach ($all_authors as $author): ?>
                    <div class="swiper-slide">
                        <div class="team-box-items">
                            <div class="team-image">
                                <div class="thumb">
                                    <img src="<?= base_url('assets/avator/upload/' . $author['img_name']) ?>" alt="<?= htmlspecialchars($author['img_head']) ?>">
                                </div>
                                <div class="shape-img">
                                    <img src="<?= base_url('assets/theme/theme/assets/img/team/shape-img.png') ?>" alt="img">
                                </div>
                            </div>
                            <div class="team-content text-center">
                                <h6>
                                    <a href="<?= htmlspecialchars($author['img_link'] ?: '#') ?>">
                                        <?= htmlspecialchars($author['img_head']) ?>
                                    </a>
                                </h6>
                                <p><?= trim_text(strip_tags($author['img_text']), '50') ?> Published Books</p>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
</section>